/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.mid.connection.dbmanager.ExpressionDeParserEx;
import java.util.Iterator;
import net.boke.jsqlparser.statement.StatementVisitor;
import net.boke.jsqlparser.statement.alter.Alter;
import net.boke.jsqlparser.statement.create.index.CreateIndex;
import net.boke.jsqlparser.statement.create.table.CreateTable;
import net.boke.jsqlparser.statement.delete.Delete;
import net.boke.jsqlparser.statement.drop.Drop;
import net.boke.jsqlparser.statement.insert.Insert;
import net.boke.jsqlparser.statement.replace.Replace;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.WithItem;
import net.boke.jsqlparser.statement.truncate.Truncate;
import net.boke.jsqlparser.statement.update.Update;
import net.boke.jsqlparser.util.deparser.CreateTableDeParser;
import net.boke.jsqlparser.util.deparser.DeleteDeParser;
import net.boke.jsqlparser.util.deparser.InsertDeParser;
import net.boke.jsqlparser.util.deparser.ReplaceDeParser;
import net.boke.jsqlparser.util.deparser.SelectDeParser;
import net.boke.jsqlparser.util.deparser.UpdateDeParser;

class SqlConvertor
implements StatementVisitor {
    protected StringBuffer buffer;
    int dbType;
    SelectDeParser selectDeParser;
    ExpressionDeParserEx expressionDeParser;

    public SqlConvertor(StringBuffer buffer, int dbType) {
        this.buffer = buffer;
    }

    @Override
    public void visit(CreateTable createTable) {
        CreateTableDeParser createTableDeParser = new CreateTableDeParser(this.buffer);
        createTableDeParser.deParse(createTable);
    }

    @Override
    public void visit(Delete delete) {
        this.selectDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        DeleteDeParser deleteDeParser = new DeleteDeParser(this.expressionDeParser, this.buffer);
        deleteDeParser.deParse(delete);
    }

    @Override
    public void visit(Drop drop) {
    }

    @Override
    public void visit(Insert insert) {
        this.selectDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        InsertDeParser insertDeParser = new InsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        insertDeParser.deParse(insert);
    }

    @Override
    public void visit(Replace replace) {
        this.selectDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        ReplaceDeParser replaceDeParser = new ReplaceDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        replaceDeParser.deParse(replace);
    }

    @Override
    public void visit(Select select) {
        this.selectDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        if (select.getWithItemsList() != null && !select.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            Iterator iter = select.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem withItem = (WithItem)iter.next();
                this.buffer.append(withItem);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        select.getSelectBody().accept(this.selectDeParser);
    }

    @Override
    public void visit(Truncate truncate) {
    }

    @Override
    public void visit(Update update) {
        this.selectDeParser.setBuffer(this.buffer);
        UpdateDeParser updateDeParser = new UpdateDeParser(this.expressionDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        updateDeParser.deParse(update);
    }

    @Override
    public void visit(CreateIndex createIndex) {
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void visit(Alter alter) {
    }
}

