/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.mid.connection.dbmanager.SelectDeParserEx;
import com.bokesoft.yigo.mid.util.DBManagerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.boke.jsqlparser.expression.CastExpression;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.operators.arithmetic.Concat;
import net.boke.jsqlparser.expression.operators.arithmetic.Division;
import net.boke.jsqlparser.expression.operators.arithmetic.Modulo;
import net.boke.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.IsNullExpression;
import net.boke.jsqlparser.expression.operators.relational.LikeExpression;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.create.table.ColDataType;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.util.deparser.ExpressionDeParser;
import org.apache.commons.lang3.StringUtils;

class ExpressionDeParserEx
extends ExpressionDeParser {
    final int dbType;
    SelectDeParserEx selectVisitor;

    ExpressionDeParserEx(SelectDeParserEx selectVisitor, StringBuffer buffer, int dbType) {
        super(selectVisitor, buffer);
        this.selectVisitor = selectVisitor;
        this.dbType = dbType;
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        super.visit(isNullExpression);
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType) && this.isEmptyString(notEqualsTo.getRightExpression())) {
            notEqualsTo.getLeftExpression().accept(this);
            this.buffer.append(" IS NOT NULL");
            this.selectVisitor.setChange();
        } else if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType) && this.isEmptValueJdbcParameter(notEqualsTo.getRightExpression())) {
            this.buffer.append("(");
            notEqualsTo.getLeftExpression().accept(this);
            this.buffer.append(" IS NOT NULL AND ? IS NULL");
            this.buffer.append(")");
            this.selectVisitor.setChange();
        } else {
            super.visit(notEqualsTo);
        }
    }

    private boolean isEmptValueJdbcParameter(Expression rightExpression) {
        if (!(rightExpression instanceof JdbcParameter)) {
            return false;
        }
        int index = ((JdbcParameter)rightExpression).getIndex();
        if (index < 0) {
            return false;
        }
        return this.selectVisitor.isEmptyStringJdbcParameter(index - 1);
    }

    private boolean isEmptyString(Expression rightExpression) {
        if (!(rightExpression instanceof StringValue)) {
            return false;
        }
        String value = ((StringValue)rightExpression).getValue();
        if (value == null) {
            return false;
        }
        return value.isEmpty();
    }

    @Override
    public void visit(CastExpression castExpression) {
        if (DBManagerUtil.isMySQLLikeDatabase((int)this.dbType) && this.isSQLServerDateToNumberFunction(castExpression)) {
            this.buffer.append("CAST(");
            castExpression.getLeftExpression().accept(this);
            this.buffer.append(" AS UNSIGNED)");
            this.selectVisitor.setChange();
        } else if (DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType) && this.isMySQLDateToNumberFunction(castExpression)) {
            this.buffer.append("CAST(");
            castExpression.getLeftExpression().accept(this);
            this.buffer.append(" AS BIGINT)");
            this.selectVisitor.setChange();
        } else if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType) && (this.isMySQLDateToNumberFunction(castExpression) || this.isSQLServerDateToNumberFunction(castExpression))) {
            this.buffer.append("TO_NUMBER(");
            castExpression.getLeftExpression().accept(this);
            this.buffer.append(")");
            this.selectVisitor.setChange();
        } else {
            super.visit(castExpression);
        }
    }

    @Override
    public void visit(Function function) {
        String functionName = function.getName();
        if (DBManagerUtil.isMySQLLikeDatabase((int)this.dbType) && this.isOracleDateToNumberFunction(function)) {
            this.buffer.append("CAST(");
            ((Expression)function.getParameters().getExpressions().get(0)).accept(this);
            this.buffer.append(" AS UNSIGNED)");
            this.selectVisitor.setChange();
        } else if (DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType) && this.isOracleDateToNumberFunction(function)) {
            this.buffer.append("CAST(");
            ((Expression)function.getParameters().getExpressions().get(0)).accept(this);
            this.buffer.append(" AS BIGINT)");
            this.selectVisitor.setChange();
        } else if (DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType) && functionName.equalsIgnoreCase("length")) {
            this.selectVisitor.setChange();
            this.visitSimpleFunction("LEN", function);
        } else if (DBManagerUtil.isMySQLLikeDatabase((int)this.dbType) && functionName.equalsIgnoreCase("len")) {
            this.selectVisitor.setChange();
            this.visitSimpleFunction("LENGTH", function);
        } else if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType) && functionName.equalsIgnoreCase("len")) {
            this.selectVisitor.setChange();
            this.visitSimpleFunction("LENGTH", function);
        } else if (DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType) && (functionName.equalsIgnoreCase("IFNULL") || functionName.equalsIgnoreCase("NVL"))) {
            this.selectVisitor.setChange();
            this.visitSimpleFunction("ISNULL", function);
        } else if (DBManagerUtil.isMySQLLikeDatabase((int)this.dbType) && (this.isSQLServerIsNull(function) || functionName.equalsIgnoreCase("NVL"))) {
            this.selectVisitor.setChange();
            this.visitSimpleFunction("IFNULL", function);
        } else if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType) && (functionName.equalsIgnoreCase("IFNULL") || functionName.equalsIgnoreCase("ISNULL"))) {
            this.selectVisitor.setChange();
            this.visitSimpleFunction("NVL", function);
        } else if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType) && functionName.equalsIgnoreCase("Concat") && function.getParameters().getExpressions().size() > 2) {
            this.selectVisitor.setChange();
            List expressions = function.getParameters().getExpressions();
            this.buffer.append("(");
            Iterator iter = expressions.iterator();
            while (iter.hasNext()) {
                Expression expression = (Expression)iter.next();
                expression.accept(this);
                if (!iter.hasNext()) continue;
                this.buffer.append(" || ");
            }
            this.buffer.append(")");
        } else if (DBManagerUtil.isMySQLLikeDatabase((int)this.dbType) && functionName.equalsIgnoreCase("getDate")) {
            this.selectVisitor.setChange();
            this.buffer.append("NOW()");
        } else if (DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType) && functionName.equalsIgnoreCase("now")) {
            this.selectVisitor.setChange();
            this.buffer.append("GETDATE()");
        } else if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType) && (functionName.equalsIgnoreCase("getDate") || functionName.equalsIgnoreCase("now"))) {
            this.selectVisitor.setChange();
            this.buffer.append("SYSDATE");
        } else if (DBManagerUtil.isMySQLLikeDatabase((int)this.dbType) && (ExpressionDeParserEx.isSqlServerDateFormat(function) || ExpressionDeParserEx.isOracleDateFormat(function))) {
            this.selectVisitor.setChange();
            this.buffer.append("DATE_FORMAT(");
            ExpressionDeParserEx.getDateArgumentInDateFormat(function).accept(this);
            this.buffer.append(", '%Y%m%d')");
        } else if (DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType) && (ExpressionDeParserEx.isMySqlDateFormat(function) || ExpressionDeParserEx.isOracleDateFormat(function))) {
            this.selectVisitor.setChange();
            this.buffer.append("CONVERT(VARCHAR(8), ");
            ExpressionDeParserEx.getDateArgumentInDateFormat(function).accept(this);
            this.buffer.append(", 112)");
        } else if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType) && (ExpressionDeParserEx.isMySqlDateFormat(function) || ExpressionDeParserEx.isSqlServerDateFormat(function))) {
            this.selectVisitor.setChange();
            this.buffer.append("TO_CHAR(");
            ExpressionDeParserEx.getDateArgumentInDateFormat(function).accept(this);
            this.buffer.append(", 'yyyyMMdd')");
        } else if (DBManagerUtil.isMySQLLikeDatabase((int)this.dbType) && (ExpressionDeParserEx.isSqlServerDateDiff(function) || ExpressionDeParserEx.isOracleDateDiff(function))) {
            this.selectVisitor.setChange();
            this.buffer.append("DATEDIFF(");
            this.parseDateArgumentInDateDiff(ExpressionDeParserEx.getDateArgumentInDateDiff(function, true), this.dbType);
            this.buffer.append(", ");
            this.parseDateArgumentInDateDiff(ExpressionDeParserEx.getDateArgumentInDateDiff(function, false), this.dbType);
            this.buffer.append(")");
        } else if (DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType) && (ExpressionDeParserEx.isMySqlDateDiff(function) || ExpressionDeParserEx.isOracleDateDiff(function))) {
            this.selectVisitor.setChange();
            this.buffer.append("DATEDIFF(DAY, ");
            this.parseDateArgumentInDateDiff(ExpressionDeParserEx.getDateArgumentInDateDiff(function, false), this.dbType);
            this.buffer.append(", ");
            this.parseDateArgumentInDateDiff(ExpressionDeParserEx.getDateArgumentInDateDiff(function, true), this.dbType);
            this.buffer.append(")");
        } else if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType) && (ExpressionDeParserEx.isMySqlDateDiff(function) || ExpressionDeParserEx.isSqlServerDateDiff(function))) {
            this.selectVisitor.setChange();
            this.buffer.append("ROUND(TO_NUMBER(");
            this.parseDateArgumentInDateDiff(ExpressionDeParserEx.getDateArgumentInDateDiff(function, true), this.dbType);
            this.buffer.append(" - ");
            this.parseDateArgumentInDateDiff(ExpressionDeParserEx.getDateArgumentInDateDiff(function, false), this.dbType);
            this.buffer.append("))");
        } else if (DBManagerUtil.isMySQLLikeDatabase((int)this.dbType) && (this.isOracleDateDiv(function) || this.isSQLServerDateDiv(function))) {
            this.selectVisitor.setChange();
            Division div = (Division)function.getParameters().getExpressions().get(0);
            this.buffer.append(div.getLeftExpression()).append(" DIV ").append(div.getRightExpression());
        } else if (DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType) && this.isOracleDateDiv(function)) {
            this.selectVisitor.setChange();
            this.buffer.append("FLOOR(");
            Division div = (Division)function.getParameters().getExpressions().get(0);
            this.buffer.append(div.getLeftExpression()).append(" / ").append(div.getRightExpression());
            this.buffer.append(")");
        } else if ((DBManagerUtil.isOracleLikeDatabase((int)this.dbType) || DBManagerUtil.isEsgynDBLikeDatabase((int)this.dbType)) && this.isSQLServerDateDiv(function)) {
            this.selectVisitor.setChange();
            this.buffer.append("TRUNC(");
            Division div = (Division)function.getParameters().getExpressions().get(0);
            this.buffer.append(div.getLeftExpression()).append(" / ").append(div.getRightExpression());
            this.buffer.append(")");
        } else if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType) && this.isOracleDateDiv(function)) {
            this.buffer.append(function);
        } else if (DBManagerUtil.isEsgynDBLikeDatabase((int)this.dbType) && this.isOracleDateDiv(function)) {
            this.buffer.append(function);
        } else if (DBManagerUtil.isMySQLLikeDatabase((int)this.dbType) && this.isOracleDateMod(function)) {
            this.selectVisitor.setChange();
            List list = function.getParameters().getExpressions();
            this.buffer.append(list.get(0)).append(" % ").append(list.get(1));
        } else if (DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType) && this.isOracleDateMod(function)) {
            this.selectVisitor.setChange();
            List list = function.getParameters().getExpressions();
            this.buffer.append(list.get(0)).append(" % ").append(list.get(1));
        } else {
            super.visit(function);
        }
    }

    private boolean isSQLServerIsNull(Function function) {
        if (!function.getName().equalsIgnoreCase("IsNull")) {
            return false;
        }
        List expressions = function.getParameters().getExpressions();
        return expressions.size() == 2;
    }

    private boolean isMySQLDateToNumberFunction(CastExpression castExpression) {
        ColDataType type = castExpression.getType();
        String dataType = type.getDataType();
        if (!"UNSIGNED".equalsIgnoreCase(dataType)) {
            return false;
        }
        Expression leftExpression = castExpression.getLeftExpression();
        if (!(leftExpression instanceof Function)) {
            return false;
        }
        Function fun = (Function)leftExpression;
        return ExpressionDeParserEx.isMySqlDateFormat(fun);
    }

    private boolean isSQLServerDateToNumberFunction(CastExpression castExpression) {
        ColDataType type = castExpression.getType();
        String dataType = type.getDataType();
        if (!"BIGINT".equalsIgnoreCase(dataType)) {
            return false;
        }
        Expression leftExpression = castExpression.getLeftExpression();
        if (!(leftExpression instanceof Function)) {
            return false;
        }
        Function fun = (Function)leftExpression;
        return ExpressionDeParserEx.isSqlServerDateFormat(fun);
    }

    private boolean isOracleDateToNumberFunction(Function function) {
        String name = function.getName();
        if (!"to_number".equalsIgnoreCase(name)) {
            return false;
        }
        ExpressionList parameters = function.getParameters();
        List tmp = parameters.getExpressions();
        if (tmp.size() != 1) {
            return false;
        }
        Object exp = tmp.get(0);
        if (!(exp instanceof Function)) {
            return false;
        }
        Function parameter = (Function)exp;
        return ExpressionDeParserEx.isOracleDateFormat(parameter);
    }

    private void visitSimpleFunction(String functionName, Function function) {
        this.buffer.append(functionName).append(this.useBracketsInExprList ? "" : "(");
        this.visit(function.getParameters());
        this.buffer.append(this.useBracketsInExprList ? "" : ")");
    }

    private static boolean isMySqlDateFormat(Function function) {
        if (!function.getName().equalsIgnoreCase("DATE_FORMAT")) {
            return false;
        }
        List expressions = function.getParameters().getExpressions();
        return expressions.size() == 2 && expressions.get(1).toString().equals("'%Y%m%d'");
    }

    private static boolean isSqlServerDateFormat(Function function) {
        if (!function.getName().equalsIgnoreCase("CONVERT")) {
            return false;
        }
        List expressions = function.getParameters().getExpressions();
        return expressions.size() == 3 && expressions.get(0).toString().equals("VARCHAR(8)") && expressions.get(2).toString().equals("112");
    }

    @Override
    public void visit(SubSelect subSelect) {
        boolean isSubSelect = this.selectVisitor.isSubSelect();
        this.selectVisitor.setSubSelect(false);
        super.visit(subSelect);
        this.selectVisitor.setSubSelect(isSubSelect);
    }

    private static boolean isOracleDateFormat(Function function) {
        if (!function.getName().equalsIgnoreCase("to_Char")) {
            return false;
        }
        List expressions = function.getParameters().getExpressions();
        if (expressions.size() != 2) {
            return false;
        }
        return expressions.size() == 2 && expressions.get(1).toString().equals("'yyyyMMdd'");
    }

    private static Expression getDateArgumentInDateFormat(Function function) {
        if (ExpressionDeParserEx.isMySqlDateFormat(function)) {
            return (Expression)function.getParameters().getExpressions().get(0);
        }
        if (ExpressionDeParserEx.isSqlServerDateFormat(function)) {
            return (Expression)function.getParameters().getExpressions().get(1);
        }
        if (ExpressionDeParserEx.isOracleDateFormat(function)) {
            return (Expression)function.getParameters().getExpressions().get(0);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u5904\u7406" + function.toString() + "\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
    }

    private static boolean isMySqlDateDiff(Function function) {
        if (!function.getName().equalsIgnoreCase("DATEDIFF")) {
            return false;
        }
        List expressions = function.getParameters().getExpressions();
        return expressions.size() == 2 && ExpressionDeParserEx.isMySqlDateDiffParameter(expressions.get(0)) && ExpressionDeParserEx.isMySqlDateDiffParameter(expressions.get(1));
    }

    private static boolean isMySqlDateDiffParameter(Object expression) {
        if (!(expression instanceof Function)) {
            return false;
        }
        Function function = (Function)expression;
        if (!function.getName().equalsIgnoreCase("str_to_date") || !function.getParameters().getExpressions().get(1).toString().equals("'%Y%m%d'")) {
            return false;
        }
        Object tmp = function.getParameters().getExpressions().get(0);
        if (tmp instanceof Function && "date_format".equals(((Function)tmp).getName())) {
            return true;
        }
        return tmp instanceof Column || tmp instanceof LongValue || tmp instanceof JdbcParameter || tmp.toString().equalsIgnoreCase("date_format(now(), '%Y%m%d')");
    }

    private static boolean isSqlServerDateDiff(Function function) {
        if (!function.getName().equalsIgnoreCase("DATEDIFF")) {
            return false;
        }
        List expressions = function.getParameters().getExpressions();
        return expressions.size() == 3 && expressions.get(0).toString().equalsIgnoreCase("day") && ExpressionDeParserEx.isSqlServerDateDiffParameter(expressions.get(1)) && ExpressionDeParserEx.isSqlServerDateDiffParameter(expressions.get(2));
    }

    private static boolean isSqlServerDateDiffParameter(Object expression) {
        if (!(expression instanceof Function)) {
            return false;
        }
        Function function = (Function)expression;
        if (!function.getName().equalsIgnoreCase("convert")) {
            return false;
        }
        List expressions = function.getParameters().getExpressions();
        if (expressions.size() != 3 || !expressions.get(0).toString().equalsIgnoreCase("datetime") || !expressions.get(2).toString().equalsIgnoreCase("112")) {
            return false;
        }
        Object tmp = expressions.get(1);
        if (!(tmp instanceof Function)) {
            return false;
        }
        Function function3 = (Function)tmp;
        if (!function3.getName().equalsIgnoreCase("convert")) {
            return false;
        }
        expressions = function3.getParameters().getExpressions();
        if (expressions.size() != 2 || !expressions.get(0).toString().equalsIgnoreCase("varchar(8)")) {
            return false;
        }
        tmp = expressions.get(1);
        if (tmp instanceof Column || tmp instanceof LongValue || tmp instanceof JdbcParameter) {
            return true;
        }
        return tmp.toString().equalsIgnoreCase("CONVERT(VARCHAR(8), GETDATE(), 112)");
    }

    private static boolean isOracleDateDiff(Function function) {
        if (!function.getName().equalsIgnoreCase("ROUND")) {
            return false;
        }
        List expressions = function.getParameters().getExpressions();
        if (expressions.size() != 1) {
            return false;
        }
        Object tmp = expressions.get(0);
        if (!(tmp instanceof Function)) {
            return false;
        }
        Function function2 = (Function)tmp;
        if (!function2.getName().equalsIgnoreCase("TO_NUMBER")) {
            return false;
        }
        expressions = function2.getParameters().getExpressions();
        if (expressions.size() != 1) {
            return false;
        }
        tmp = expressions.get(0);
        if (!(tmp instanceof Subtraction)) {
            return false;
        }
        Subtraction subtraction = (Subtraction)tmp;
        tmp = subtraction.getRightExpression();
        return ExpressionDeParserEx.isOracleDateDiffParameter(subtraction.getLeftExpression()) && ExpressionDeParserEx.isOracleDateDiffParameter(subtraction.getRightExpression());
    }

    private static boolean isOracleDateDiffParameter(Object expression) {
        if (!(expression instanceof Function)) {
            return false;
        }
        Function function3 = (Function)expression;
        if (!function3.getName().equalsIgnoreCase("to_Date")) {
            return false;
        }
        List expressions = function3.getParameters().getExpressions();
        if (expressions.size() != 2 || !expressions.get(1).toString().equals("'yyyyMMdd'")) {
            return false;
        }
        Object tmp = expressions.get(0);
        if (tmp instanceof Column || tmp instanceof LongValue || tmp instanceof JdbcParameter) {
            return true;
        }
        if (!(tmp instanceof Function)) {
            return false;
        }
        return tmp.toString().equalsIgnoreCase("to_char(sysdate, 'yyyyMMdd')");
    }

    private static Expression getDateArgumentInDateDiff(Function function, boolean isBig) {
        if (ExpressionDeParserEx.isMySqlDateDiff(function)) {
            return (Expression)function.getParameters().getExpressions().get(isBig ? 0 : 1);
        }
        if (ExpressionDeParserEx.isSqlServerDateDiff(function)) {
            return (Function)function.getParameters().getExpressions().get(isBig ? 2 : 1);
        }
        if (ExpressionDeParserEx.isOracleDateDiff(function)) {
            Subtraction subtraction = (Subtraction)((Function)function.getParameters().getExpressions().get(0)).getParameters().getExpressions().get(0);
            return isBig ? subtraction.getLeftExpression() : subtraction.getRightExpression();
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u5904\u7406" + function.toString() + "\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
    }

    private static Expression getToDateArgumentInDateDiff(Object expression) {
        if (ExpressionDeParserEx.isMySqlDateDiffParameter(expression)) {
            return (Expression)((Function)expression).getParameters().getExpressions().get(0);
        }
        if (ExpressionDeParserEx.isSqlServerDateDiffParameter(expression)) {
            return (Expression)((Function)((Function)expression).getParameters().getExpressions().get(1)).getParameters().getExpressions().get(1);
        }
        if (ExpressionDeParserEx.isOracleDateDiffParameter(expression)) {
            return (Expression)((Function)expression).getParameters().getExpressions().get(0);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u5904\u7406" + expression.toString() + "\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
    }

    private void parseDateArgumentInDateDiff(Object expression, int dbType) {
        if (DBManagerUtil.isMySQLLikeDatabase((int)dbType) && ExpressionDeParserEx.isSqlServerDateDiffParameter(expression)) {
            if (expression.toString().equalsIgnoreCase("CONVERT(DATETIME, CONVERT(VARCHAR(8), CONVERT(VARCHAR(8), GETDATE(), 112)), 112)")) {
                this.buffer.append("STR_TO_DATE(DATE_FORMAT(NOW(), '%Y%m%d'), '%Y%m%d')");
            } else {
                this.buffer.append("STR_TO_DATE(");
                ExpressionDeParserEx.getToDateArgumentInDateDiff(expression).accept(this);
                this.buffer.append(", '%Y%m%d')");
            }
        } else if (DBManagerUtil.isMySQLLikeDatabase((int)dbType) && ExpressionDeParserEx.isOracleDateDiffParameter(expression)) {
            if (expression.toString().equalsIgnoreCase("TO_DATE(TO_CHAR(SYSDATE, 'yyyyMMdd'), 'yyyyMMdd')")) {
                this.buffer.append("STR_TO_DATE(DATE_FORMAT(NOW(), '%Y%m%d'), '%Y%m%d')");
            } else {
                this.buffer.append("STR_TO_DATE(");
                ExpressionDeParserEx.getToDateArgumentInDateDiff(expression).accept(this);
                this.buffer.append(", '%Y%m%d')");
            }
        } else if (DBManagerUtil.isSQLServerLikeDatabase((int)dbType) && ExpressionDeParserEx.isMySqlDateDiffParameter(expression)) {
            if (expression.toString().equalsIgnoreCase("STR_TO_DATE(DATE_FORMAT(NOW(), '%Y%m%d'), '%Y%m%d')")) {
                this.buffer.append("CONVERT(DATETIME, CONVERT(VARCHAR(8), CONVERT(VARCHAR(8), GETDATE(), 112)), 112)");
            } else {
                this.buffer.append("CONVERT(DATETIME, CONVERT(VARCHAR(8), ");
                ExpressionDeParserEx.getToDateArgumentInDateDiff(expression).accept(this);
                this.buffer.append("), 112)");
            }
        } else if (DBManagerUtil.isSQLServerLikeDatabase((int)dbType) && ExpressionDeParserEx.isOracleDateDiffParameter(expression)) {
            if (expression.toString().equalsIgnoreCase("TO_DATE(TO_CHAR(SYSDATE, 'yyyyMMdd'), 'yyyyMMdd')")) {
                this.buffer.append("CONVERT(DATETIME, CONVERT(VARCHAR(8), CONVERT(VARCHAR(8), GETDATE(), 112)), 112)");
            } else {
                this.buffer.append("CONVERT(DATETIME, CONVERT(VARCHAR(8), ");
                ExpressionDeParserEx.getToDateArgumentInDateDiff(expression).accept(this);
                this.buffer.append("), 112)");
            }
        } else if (DBManagerUtil.isOracleLikeDatabase((int)dbType) && ExpressionDeParserEx.isMySqlDateDiffParameter(expression)) {
            if (expression.toString().equalsIgnoreCase("STR_TO_DATE(DATE_FORMAT(NOW(), '%Y%m%d'), '%Y%m%d')")) {
                this.buffer.append("TO_DATE(TO_CHAR(SYSDATE, 'yyyyMMdd'), 'yyyyMMdd')");
            } else {
                this.buffer.append("TO_DATE(");
                ExpressionDeParserEx.getToDateArgumentInDateDiff(expression).accept(this);
                this.buffer.append(", 'yyyyMMdd')");
            }
        } else if (DBManagerUtil.isOracleLikeDatabase((int)dbType) && ExpressionDeParserEx.isSqlServerDateDiffParameter(expression)) {
            if (expression.toString().equalsIgnoreCase("CONVERT(DATETIME, CONVERT(VARCHAR(8), CONVERT(VARCHAR(8), GETDATE(), 112)), 112)")) {
                this.buffer.append("TO_DATE(TO_CHAR(SYSDATE, 'yyyyMMdd'), 'yyyyMMdd')");
            } else {
                this.buffer.append("TO_DATE(");
                ExpressionDeParserEx.getToDateArgumentInDateDiff(expression).accept(this);
                this.buffer.append(", 'yyyyMMdd')");
            }
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u5904\u7406" + expression.toString() + "\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
        }
    }

    @Override
    public void visit(Concat concat) {
        if (DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType) || DBManagerUtil.isMySQLLikeDatabase((int)this.dbType)) {
            this.selectVisitor.setChange();
            ArrayList<Expression> arguments = new ArrayList<Expression>();
            this.getConcatArguments(concat, arguments);
            this.buffer.append("CONCAT(");
            ((Expression)arguments.get(0)).accept(this);
            int i = 1;
            int size = arguments.size();
            while (i < size) {
                this.buffer.append(", ");
                ((Expression)arguments.get(i)).accept(this);
                ++i;
            }
            this.buffer.append(")");
        } else {
            super.visit(concat);
        }
    }

    private void getConcatArguments(Concat concat, List<Expression> arguments) {
        Expression left = concat.getLeftExpression();
        if (left instanceof Concat) {
            this.getConcatArguments((Concat)left, arguments);
        } else {
            arguments.add(left);
        }
        Expression right = concat.getRightExpression();
        if (right instanceof Concat) {
            this.getConcatArguments((Concat)right, arguments);
        } else {
            arguments.add(right);
        }
    }

    @Override
    public void visit(Column tableColumn) {
        String wholeColumnName = tableColumn.getWholeColumnName();
        if (DBManagerUtil.isMySQLLikeDatabase((int)this.dbType) && wholeColumnName.equalsIgnoreCase("sysdate")) {
            this.selectVisitor.setChange();
            this.buffer.append("NOW()");
        } else if (DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType) && wholeColumnName.equalsIgnoreCase("sysdate")) {
            this.selectVisitor.setChange();
            this.buffer.append("GETDATE()");
        } else if (ExpressionDeParserEx.isKeyWordColumn(tableColumn)) {
            boolean isChanged = false;
            if (DBManagerUtil.isMySQLLikeDatabase((int)this.dbType)) {
                isChanged = tableColumn.getKeyWordEscapeStart() != '`';
                this.setKeyWordEscape(tableColumn, tableColumn.getColumnName(), "`", "`");
            } else if (DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType)) {
                isChanged = tableColumn.getKeyWordEscapeStart() != '[';
                this.setKeyWordEscape(tableColumn, tableColumn.getColumnName(), "[", "]");
            } else if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType)) {
                isChanged = tableColumn.getKeyWordEscapeStart() != '\"';
                this.setKeyWordEscape(tableColumn, tableColumn.getColumnName().toUpperCase(), "\"", "\"");
            } else if (DBManagerUtil.isEsgynDBLikeDatabase((int)this.dbType)) {
                isChanged = tableColumn.getKeyWordEscapeStart() != '\"';
                this.setKeyWordEscape(tableColumn, tableColumn.getColumnName().toLowerCase(), "\"", "\"");
            } else {
                super.visit(tableColumn);
            }
            if (isChanged) {
                this.selectVisitor.setChange();
            }
        } else {
            super.visit(tableColumn);
        }
    }

    private void setKeyWordEscape(Column tableColumn, String columnName, String keyWordEscapeStart, String keyWordEscapeEnd) {
        String wholeTableName;
        Table table = tableColumn.getTable();
        String string = wholeTableName = table == null ? null : table.getWholeTableName();
        if (!StringUtils.isBlank((CharSequence)wholeTableName)) {
            this.buffer.append(wholeTableName).append(".");
        }
        this.buffer.append(keyWordEscapeStart).append(columnName).append(keyWordEscapeEnd);
    }

    private static boolean isKeyWordColumn(Column tableColumn) {
        if (tableColumn.getKeyWordEscapeStart() > '\u0000') {
            return true;
        }
        String columnName = tableColumn.getColumnName();
        return "Reference".equalsIgnoreCase(columnName) || "Status".equalsIgnoreCase(columnName);
    }

    @Override
    public void visit(Division division) {
        if (DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType) && this.isMySqlDateDiv(division)) {
            this.selectVisitor.setChange();
            this.buffer.append("FLOOR(").append(division.getLeftExpression()).append(" / ").append(division.getRightExpression()).append(")");
        } else if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType) && this.isMySqlDateDiv(division)) {
            this.selectVisitor.setChange();
            this.buffer.append("TRUNC(").append(division.getLeftExpression()).append(" / ").append(division.getRightExpression()).append(")");
        } else if (DBManagerUtil.isEsgynDBLikeDatabase((int)this.dbType) && this.isMySqlDateDiv(division)) {
            this.selectVisitor.setChange();
            this.buffer.append("TRUNC(").append(division.getLeftExpression()).append(" / ").append(division.getRightExpression()).append(")");
        } else {
            super.visit(division);
        }
    }

    @Override
    public void visit(Modulo modulo) {
        if (DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType) && this.isMySqlDateMod(modulo) && !this.isSqlServerDateMod(modulo)) {
            this.selectVisitor.setChange();
            this.buffer.append(modulo.getLeftExpression()).append(" % ").append(modulo.getRightExpression());
        } else if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType) && (this.isMySqlDateMod(modulo) || this.isSqlServerDateMod(modulo))) {
            this.selectVisitor.setChange();
            this.buffer.append("MOD(").append(modulo.getLeftExpression()).append(", ").append(modulo.getRightExpression()).append(")");
        } else if (DBManagerUtil.isEsgynDBLikeDatabase((int)this.dbType) && (this.isMySqlDateMod(modulo) || this.isSqlServerDateMod(modulo))) {
            this.selectVisitor.setChange();
            this.buffer.append("MOD(").append(modulo.getLeftExpression()).append(", ").append(modulo.getRightExpression()).append(")");
        } else {
            super.visit(modulo);
        }
    }

    public boolean isMySqlDateDiv(Division division) {
        if (!division.isDivString() || !(division.getLeftExpression() instanceof Column)) {
            return false;
        }
        Expression right = division.getRightExpression();
        if (!(right instanceof LongValue)) {
            return false;
        }
        long value = ((LongValue)right).getValue();
        return value == 100L || value == 1000L || value == 10000L || value == 1000000L;
    }

    public boolean isDateDiv(Division division) {
        if (division.isDivString() || !(division.getLeftExpression() instanceof Column)) {
            return false;
        }
        Expression right = division.getRightExpression();
        if (!(right instanceof LongValue)) {
            return false;
        }
        long value = ((LongValue)right).getValue();
        return value == 100L || value == 1000L || value == 10000L || value == 1000000L;
    }

    public boolean isSQLServerDateDiv(Function function) {
        if (!function.getName().equalsIgnoreCase("floor")) {
            return false;
        }
        ExpressionList expressionList = function.getParameters();
        if (expressionList == null) {
            return false;
        }
        List expressions = expressionList.getExpressions();
        if (expressions == null || expressions.size() != 1) {
            return false;
        }
        Object exp = expressions.get(0);
        if (!(exp instanceof Division)) {
            return false;
        }
        return this.isDateDiv((Division)exp);
    }

    public boolean isOracleDateDiv(Function function) {
        if (!function.getName().equalsIgnoreCase("trunc")) {
            return false;
        }
        ExpressionList expressionList = function.getParameters();
        if (expressionList == null) {
            return false;
        }
        List expressions = expressionList.getExpressions();
        if (expressions == null || expressions.size() != 1) {
            return false;
        }
        Object exp = expressions.get(0);
        if (!(exp instanceof Division)) {
            return false;
        }
        return this.isDateDiv((Division)exp);
    }

    public boolean isMySqlDateMod(Modulo modulo) {
        if (!(modulo.getLeftExpression() instanceof Column)) {
            return false;
        }
        Expression right = modulo.getRightExpression();
        if (!(right instanceof LongValue)) {
            return false;
        }
        long value = ((LongValue)right).getValue();
        return value == 100L || value == 1000L || value == 10000L || value == 1000000L;
    }

    public boolean isSqlServerDateMod(Modulo modulo) {
        if (modulo.isModString()) {
            return false;
        }
        return this.isMySqlDateMod(modulo);
    }

    public boolean isOracleDateMod(Function function) {
        if (!function.getName().equalsIgnoreCase("mod")) {
            return false;
        }
        ExpressionList expressionList = function.getParameters();
        if (expressionList == null) {
            return false;
        }
        List expressions = expressionList.getExpressions();
        if (expressions == null || expressions.size() != 2) {
            return false;
        }
        Object exp0 = expressions.get(0);
        if (!(exp0 instanceof Column)) {
            return false;
        }
        Object exp1 = expressions.get(1);
        if (!(exp1 instanceof LongValue)) {
            return false;
        }
        long value = ((LongValue)exp1).getValue();
        return value == 100L || value == 1000L || value == 10000L || value == 1000000L;
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        boolean isChanged = false;
        this.visitBinaryExpression(likeExpression, " LIKE ");
        String escape = likeExpression.getEscape();
        if (escape != null && "\\".equals(escape) && DBManagerUtil.isMySQLLikeDatabase((int)this.dbType)) {
            escape = "\\\\";
            isChanged = true;
        } else if (escape != null && "\\\\".equals(escape) && DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType)) {
            escape = "\\";
            isChanged = true;
        } else if (escape != null && "\\\\".equals(escape) && DBManagerUtil.isOracleLikeDatabase((int)this.dbType)) {
            escape = "\\";
            isChanged = true;
        }
        if (escape != null) {
            this.buffer.append(" ESCAPE '").append(escape).append("'");
        }
        if (isChanged) {
            this.selectVisitor.setChange();
        }
    }
}

