/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.mid.connection.DbcpConnectionFactory;
import com.bokesoft.yes.mid.connection.DruidConnectionFactory;
import com.bokesoft.yes.mid.connection.JdbcConnectionFactory;
import com.bokesoft.yes.mid.connection.SqliteConnectionFactory;
import com.bokesoft.yes.mid.connection.dbmanager.DB2DBManager;
import com.bokesoft.yes.mid.connection.dbmanager.DMDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.MySqlClusterDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.MySqlDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.OracleDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.SqlServerDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.SqliteDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.connection.util.MutliDSNUtil;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.connection.IDBManagerFactory;
import java.sql.Connection;

public class MultiDBManagerFactory
implements IDBManagerFactory {
    private boolean isMultiDataBase = true;

    public MultiDBManagerFactory() {
        this.isMultiDataBase = true;
    }

    public MultiDBManagerFactory(boolean isMultiDB) {
        this.isMultiDataBase = isMultiDB;
    }

    public IDBManager getDBManager(IConnectionProfile profile) throws Throwable {
        Object[] actions = new Object[]{"CreateDBManager:", profile.getKey(), "\tMulti:", this.isMultiDataBase};
        int action = Performance.startAction((Object[])actions);
        MutliDSNUtil.getInstance().initDSNS();
        MultiDBManager dbManager = null;
        Object connectionFactory = null;
        int dbType = profile.getDBType();
        if (dbType == 7) {
            connectionFactory = new SqliteConnectionFactory();
        } else {
            int connectionType = profile.getConnectionType();
            switch (connectionType) {
                case 0: {
                    connectionFactory = new JdbcConnectionFactory();
                    break;
                }
                case 1: {
                    connectionFactory = new DbcpConnectionFactory();
                    break;
                }
                case 3: {
                    connectionFactory = new DruidConnectionFactory();
                }
            }
        }
        if (connectionFactory != null) {
            Connection connection = null;
            if (!this.isMultiDataBase) {
                connection = connectionFactory.getConnection(profile);
                connection.setAutoCommit(false);
                switch (dbType) {
                    case 1: {
                        dbManager = new SqlServerDBManager(profile, connection);
                        break;
                    }
                    case 2: {
                        dbManager = new OracleDBManager(profile, connection);
                        break;
                    }
                    case 3: {
                        dbManager = new DB2DBManager(profile, connection);
                        break;
                    }
                    case 4: {
                        dbManager = new MySqlDBManager(profile, connection);
                        break;
                    }
                    case 6: {
                        dbManager = new MySqlClusterDBManager(profile, connection);
                        break;
                    }
                    case 7: {
                        dbManager = new SqliteDBManager(profile, connection);
                        break;
                    }
                    case 8: {
                        dbManager = new DMDBManager(profile, connection);
                    }
                }
            } else {
                dbManager = new MultiDBManager(profile, null);
            }
            if (dbManager != null) {
                dbManager.setKey(profile.getKey());
            }
        }
        Performance.endActive((int)action, (Object[])actions);
        return dbManager;
    }

    public IDBManager getDBManager(IConnectionProfile profile, Connection connection) throws Throwable {
        SqlServerDBManager dbManager = null;
        int dbType = profile.getDBType();
        switch (dbType) {
            case 1: {
                dbManager = new SqlServerDBManager(profile, connection);
                break;
            }
            case 2: {
                dbManager = new OracleDBManager(profile, connection);
                break;
            }
            case 3: {
                dbManager = new DB2DBManager(profile, connection);
                break;
            }
            case 4: {
                dbManager = new MySqlDBManager(profile, connection);
                break;
            }
            case 6: {
                dbManager = new MySqlClusterDBManager(profile, connection);
                break;
            }
            case 7: {
                dbManager = new SqliteDBManager(profile, connection);
                break;
            }
            case 8: {
                dbManager = new DMDBManager(profile, connection);
            }
        }
        if (dbManager != null) {
            dbManager.setKey(profile.getKey());
        }
        return dbManager;
    }
}

