/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.bokesoft.yigo.mid.connection.IConnectionFactory;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DruidConnectionFactory
implements IConnectionFactory {
    private static Map<String, DruidDataSource> dsCache = Collections.synchronizedMap(new HashMap());

    private DruidDataSource getDataSource(IConnectionProfile profile) {
        String key = profile.getKey().toLowerCase();
        if (!dsCache.containsKey(key)) {
            DruidDataSource ds = new DruidDataSource();
            ds.setDriverClassName(profile.getDriver());
            ds.setUrl(profile.getURL());
            String user = profile.getUser();
            String password = profile.getPassword();
            if (user != null) {
                ds.setUsername(user);
                ds.setPassword(password);
            }
            ds.setMaxActive(200);
            String[] extPropNames = profile.getExtPropNames();
            if (extPropNames != null) {
                Method[] methods = ds.getClass().getMethods();
                HashMap<String, Method> mapMethod = new HashMap<String, Method>();
                int length = methods.length;
                Method method = null;
                String methodName = null;
                String propName = null;
                int i = 0;
                while (i < length) {
                    method = methods[i];
                    methodName = method.getName();
                    if (methodName.length() > 3 && methodName.substring(0, 3).equals("set")) {
                        propName = methodName.substring(3);
                        mapMethod.put(propName.toLowerCase(), method);
                    }
                    ++i;
                }
                length = extPropNames.length;
                i = 0;
                while (i < length) {
                    String extPropName = extPropNames[i];
                    method = (Method)mapMethod.get(extPropName.toLowerCase());
                    if (method != null) {
                        String value;
                        Class<?>[] paraTypes = method.getParameterTypes();
                        Class<?> type = null;
                        if (paraTypes != null && paraTypes.length == 1 && (value = profile.getExtProp(extPropName)) != null && !value.isEmpty()) {
                            type = paraTypes[0];
                            ArrayList<String> paraValue = null;
                            if (type == Integer.class || type == Integer.TYPE) {
                                paraValue = Integer.parseInt(value);
                            } else if (type == String.class) {
                                paraValue = value;
                            } else if (type == BigDecimal.class) {
                                paraValue = new BigDecimal(value);
                            } else if (type == Double.class || type == Double.TYPE) {
                                paraValue = Double.parseDouble(value);
                            } else if (type == Long.class || type == Long.TYPE) {
                                paraValue = Long.parseLong(value);
                            } else if (type == Float.class || type == Float.TYPE) {
                                paraValue = Float.valueOf(Float.parseFloat(value));
                            } else if (type == Boolean.class || type == Boolean.TYPE) {
                                paraValue = Boolean.parseBoolean(value);
                            } else if (type == Collection.class) {
                                String[] tmpValues = value.split(";");
                                int tmpLength = tmpValues.length;
                                ArrayList<String> listValue = new ArrayList<String>();
                                int j = 0;
                                while (j < tmpLength) {
                                    listValue.add(tmpValues[j]);
                                    ++j;
                                }
                                paraValue = listValue;
                            }
                            try {
                                method.invoke((Object)ds, paraValue);
                            }
                            catch (Throwable e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    ++i;
                }
            }
            dsCache.put(key, ds);
        }
        return dsCache.get(key);
    }

    public Connection getConnection(IConnectionProfile profile) throws Exception {
        DruidPooledConnection connection = null;
        DruidDataSource ds = null;
        try {
            ds = this.getDataSource(profile);
            connection = ds.getConnection();
            if (connection.getAutoCommit()) {
                connection.setAutoCommit(false);
            }
            if (connection.getTransactionIsolation() != 2) {
                connection.setTransactionIsolation(2);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return connection;
    }
}

