/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datastruct.metaload;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.datastruct.meta.MetaDataStructTable;
import com.bokesoft.yes.datastruct.metaload.AndExp;
import com.bokesoft.yes.datastruct.metaload.ColumnExp;
import com.bokesoft.yes.datastruct.metaload.CompareExp;
import com.bokesoft.yes.datastruct.metaload.ValueRange;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.List;

public abstract class WhereExp {
    static final int GreatEqual = 1;
    static final int Equal = 2;
    static final int LitterEqual = 3;
    static final int GreatThan = 4;
    static final int NotEqual = 5;
    static final int LitterThan = 6;
    static final int IN = 8;
    private int hash = 0;

    public abstract SqlString toSQL() throws Throwable;

    public abstract SqlString toSQL(SqlString var1) throws Throwable;

    public abstract List<MetaDataStructTable> getTables();

    public abstract List<ColumnExp> getColumns(MetaDataStructTable var1) throws Throwable;

    public abstract Object getColumnValue(ColumnExp var1);

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.toString().hashCode();
        }
        return this.hash;
    }

    public String toString() {
        try {
            return this.toSQL().toString();
        }
        catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
            return null;
        }
    }

    public static String getOperatorString(int operator) throws Throwable {
        switch (operator) {
            case 2: {
                return "=";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return ">";
            }
            case 5: {
                return "<>";
            }
            case 6: {
                return "<";
            }
            case 1: {
                return ">=";
            }
            case 8: {
                return "in";
            }
        }
        throw new Exception("\u76ee\u524d\u4e0d\u652f\u6301\u8fd9\u4e2a\u64cd\u4f5c\u7b26" + operator + ".");
    }

    public static int getOperatorInt(String operator) throws Throwable {
        if ((operator = operator.intern()).equals("=") || operator.equals("==")) {
            return 2;
        }
        if (operator.equals("<=")) {
            return 3;
        }
        if (operator.equals(">")) {
            return 4;
        }
        if (operator.equals("<>") || operator.equals("!=")) {
            return 5;
        }
        if (operator.equals("<")) {
            return 6;
        }
        if (operator.equals(">=")) {
            return 1;
        }
        if (operator.equalsIgnoreCase("in")) {
            return 8;
        }
        throw new Exception("\u76ee\u524d\u4e0d\u652f\u6301\u8fd9\u4e2a\u64cd\u4f5c\u7b26" + operator + ".");
    }

    abstract boolean isMatch(DataTable var1, int var2, boolean var3) throws Throwable;

    public static WhereExp eq(ColumnExp column, Object value) {
        return new CompareExp(column, value);
    }

    public static WhereExp in(ColumnExp column, String[] value) {
        return new CompareExp(column, value, 8);
    }

    public static WhereExp in(ColumnExp column, Integer[] value) {
        return new CompareExp(column, value, 8);
    }

    public static WhereExp in(ColumnExp column, int[] value) {
        return new CompareExp(column, value, 8);
    }

    public static WhereExp in(ColumnExp column, Long[] value) {
        return new CompareExp(column, value, 8);
    }

    public static WhereExp operator(ColumnExp column, String operator, Object value) throws Throwable {
        int opt = WhereExp.getOperatorInt(operator);
        return new CompareExp(column, value, opt);
    }

    public WhereExp addEQ(ColumnExp column, Object value) {
        return this.add(new CompareExp(column, value));
    }

    public WhereExp addIN(ColumnExp column, String[] value) {
        return this.add(new CompareExp(column, value, 8));
    }

    public WhereExp addIN(ColumnExp column, Integer[] value) {
        return this.add(new CompareExp(column, value, 8));
    }

    public WhereExp addLong(ColumnExp column, Long[] value) {
        return this.add(new CompareExp(column, value, 8));
    }

    public WhereExp addIN(ColumnExp column, int[] value) {
        return this.add(new CompareExp(column, value, 8));
    }

    public WhereExp addOperator(ColumnExp column, String operator, Object value) throws Throwable {
        int opt = WhereExp.getOperatorInt(operator);
        return this.add(new CompareExp(column, value, opt));
    }

    private WhereExp add(CompareExp expression) {
        if (this instanceof AndExp) {
            ((AndExp)this).addExpression(expression);
            return this;
        }
        return new AndExp(this, expression);
    }

    public abstract boolean hasColumnWhereClause(ColumnExp var1);

    public static WhereExp and(WhereExp left, WhereExp right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return new AndExp(left, right);
    }

    protected abstract ValueRange getValueRange(ColumnExp var1);
}

