/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datastruct.metaload;

import com.bokesoft.yes.datastruct.metaload.Interval;
import com.bokesoft.yes.datastruct.metaload.Points;
import com.bokesoft.yes.datastruct.metaload.ValueRange;

class Point
extends ValueRange {
    final Object value;
    final boolean isNotEqual;

    public Point(Object value, boolean isNotEqual, int dataType) {
        super(dataType);
        this.value = value;
        this.isNotEqual = isNotEqual;
    }

    @Override
    public boolean isIntersect(ValueRange valueRange) {
        if (valueRange == null) {
            throw new AssertionError((Object)"\u6bd4\u8f83\u9519\u8bef\u3002");
        }
        if (this.dataType != valueRange.dataType) {
            throw new AssertionError((Object)"\u6bd4\u8f83\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002");
        }
        if (valueRange instanceof Point) {
            Point point = (Point)valueRange;
            if (this.isNotEqual && point.isNotEqual) {
                return true;
            }
            if (this.isNotEqual || point.isNotEqual) {
                return Point.compare(this.value, point.value, this.dataType) != 0;
            }
            return Point.compare(this.value, point.value, this.dataType) == 0;
        }
        if (valueRange instanceof Points) {
            return ((Points)valueRange).isIntersect(this);
        }
        if (valueRange instanceof Interval) {
            return ((Interval)valueRange).isIntersect(this);
        }
        throw new AssertionError((Object)("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff0c" + valueRange.getClass().getName()));
    }

    public String toString() {
        return this.isNotEqual ? "!" + this.value : String.valueOf(this.value);
    }
}

