/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datastruct.metaload;

import com.bokesoft.yes.datastruct.meta.MetaDataStruct;
import com.bokesoft.yes.datastruct.meta.MetaDataStructColumn;
import com.bokesoft.yes.datastruct.meta.MetaDataStructSource;
import com.bokesoft.yes.datastruct.meta.MetaDataStructSourceColumn;
import com.bokesoft.yes.datastruct.meta.MetaDataStructTable;
import com.bokesoft.yes.datastruct.metaload.ColumnExp;
import com.bokesoft.yes.datastruct.metaload.CompareExp;
import com.bokesoft.yes.datastruct.metaload.WhereExp;
import com.bokesoft.yes.datastruct.metaload.WhereExpUtils;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataStructUtils {
    public static Map<MetaDataStructTable, WhereExp> getSourceWhereExpression(MetaDataStruct dataStruct, MetaDataStructSource source) throws Throwable {
        HashMap<MetaDataStructTable, WhereExp> result = new HashMap<MetaDataStructTable, WhereExp>();
        Iterator iterator = source.getColumnCollection().iterator();
        while (iterator.hasNext()) {
            MetaDataStructSourceColumn sourceColumn = (MetaDataStructSourceColumn)iterator.next();
            MetaDataStructColumn column = (MetaDataStructColumn)dataStruct.getColumnCollection().get(sourceColumn.getKey());
            String tableKey = column.getDataStructTableKey();
            if (tableKey == null || tableKey.length() <= 0) continue;
            MetaDataStructTable table = dataStruct.getTableByKeyOrName(tableKey);
            String whereClause = sourceColumn.getWhereClause();
            if (whereClause != null && whereClause.length() > 0) {
                WhereExp whereExp = WhereExpUtils.parseWhereClause(whereClause, table, false, dataStruct);
                result.put(table, WhereExp.and(whereExp, (WhereExp)result.get(table)));
            }
            if (!column.isKeyField() || sourceColumn.getOriginalRealTable() == null || sourceColumn.getOriginalRealTable().length() <= 0 || sourceColumn.getOriginalRealTable().equalsIgnoreCase(table.getRefTable())) continue;
            MetaDataStructTable originalTable = dataStruct.getTableByKeyOrName(sourceColumn.getOriginalRealTable());
            MetaColumn originalColumn = (MetaColumn)MetaTableCache.getFullMetaTable(originalTable.getRefTable()).get(sourceColumn.getOriginalColumn());
            MetaColumn oidColumn = (MetaColumn)MetaTableCache.getFullMetaTable(table.getRefTable()).get("OID");
            CompareExp whereExp = new CompareExp(new ColumnExp(table, oidColumn), new ColumnExp(originalTable, originalColumn), 2);
            result.put(table, WhereExp.and(whereExp, (WhereExp)result.get(table)));
        }
        Map<MetaDataStructTable, WhereExp> tableWhereExp = DataStructUtils.getStructTableWhereExpression(dataStruct);
        for (Map.Entry<MetaDataStructTable, WhereExp> entry : tableWhereExp.entrySet()) {
            MetaDataStructTable table = entry.getKey();
            result.put(table, WhereExp.and(entry.getValue(), (WhereExp)result.get(table)));
        }
        return result;
    }

    public static Map<MetaDataStructTable, WhereExp> getStructTableWhereExpression(MetaDataStruct dataStruct) throws Throwable {
        HashMap<MetaDataStructTable, WhereExp> result = new HashMap<MetaDataStructTable, WhereExp>();
        Iterator iterator = dataStruct.getTableCollection().iterator();
        while (iterator.hasNext()) {
            MetaDataStructTable table = (MetaDataStructTable)iterator.next();
            String whereClause = table.getWhereClause();
            if (whereClause == null || whereClause.length() <= 0) continue;
            result.put(table, WhereExpUtils.parseWhereClause(whereClause, table, true, dataStruct));
        }
        return result;
    }
}

