/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.mid.util;

import com.bokesoft.erp.mid.schema.ERPServerDBMaintance;
import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yes.mid.connection.util.ArchiveDSNUtil;
import com.bokesoft.yes.mid.schema.DefaultSchemaProvider;
import com.bokesoft.yes.mid.schema.ISchemaProvider;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.sql.SQLException;
import java.util.concurrent.CountDownLatch;

public class EnsureSingleArchiveDBStruct
extends Thread {
    private DefaultContext context;
    private String dsnName;
    private CountDownLatch countDownLatch;

    public EnsureSingleArchiveDBStruct(DefaultContext context, String dsnName, CountDownLatch countDownLatch) {
        this.context = context;
        this.dsnName = dsnName;
        this.countDownLatch = countDownLatch;
    }

    @Override
    public void run() {
        ServerSetting serverSetting = null;
        DefaultSchemaProvider schemaProvider = null;
        IDBManager coldDBmanager = null;
        try {
            serverSetting = ServerSetting.getInstance();
            schemaProvider = new DefaultSchemaProvider(this.context, serverSetting.getDeploy());
            Object[] actions = new Object[]{"\u786e\u8ba4\u6570\u636e\u5e93\u7ed3\u6784:", this.dsnName};
            int action = Performance.startAction((Object[])actions);
            coldDBmanager = ArchiveDSNUtil.getDBmanager(this.context, this.dsnName);
            if (coldDBmanager == null) {
                return;
            }
            try {
                new ERPServerDBMaintance().maintance((ISchemaProvider)schemaProvider, coldDBmanager);
                coldDBmanager.commit();
                Performance.endActive((int)action, (Object[])actions);
            }
            catch (Throwable e) {
                try {
                    coldDBmanager.rollback();
                    LogSvr.getInstance().error("\u786e\u8ba4\u6570\u636e\u5e93\u8868\u7ed3\u6784\u5931\u8d25,dsnName=" + this.dsnName, e);
                }
                catch (SQLException ex) {
                    LogSvr.getInstance().error("\u786e\u8ba4\u6570\u636e\u5e93\u8868\u7ed3\u6784\u5931\u8d25\u65f6\u56de\u6eda\u9519\u8bef,dsnName=" + this.dsnName, e);
                }
            }
        }
        finally {
            try {
                if (coldDBmanager != null) {
                    coldDBmanager.close();
                }
                this.countDownLatch.countDown();
            }
            catch (SQLException e) {
                LogSvr.getInstance().error("\u5173\u95eddbManager\u5931\u8d25,dsnName=" + this.dsnName, (Throwable)e);
            }
        }
    }
}

