/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.mid.util;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.connection.IQueryColumnMetaData;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetGetObjectByPos;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yes.tools.convertor.DocumentConvertor;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;

public class DocumentDBUtil {
    public static DataTable populate(IDBManager dbManager, ResultSet rs, IQueryColumnMetaData columnMetaData) throws Throwable {
        return DocumentDBUtil.impl_populate(dbManager, rs, columnMetaData);
    }

    public static DataTable populate(IDBManager dbManager, ResultSet rs) throws Throwable {
        return DocumentDBUtil.impl_populate(dbManager, rs, new NormalQueryColumnMetaData(dbManager));
    }

    private static DataTable impl_populate(IDBManager DBManager, ResultSet rs, IQueryColumnMetaData columnMetaData) throws Throwable {
        if (rs instanceof DataTableResultSet && ((DataTableResultSet)rs).getHiddenColumnCount() == 0) {
            return ((DataTableResultSet)rs).getDataTable();
        }
        DataTable table = new DataTable();
        ResultSetMetaData metaData = rs.getMetaData();
        HashMap<String, Integer> dataTypeList = new HashMap<String, Integer>();
        int hiddenColumnCount = rs instanceof ResultSetGetObjectByPos ? ((ResultSetGetObjectByPos)rs).getHiddenColumnCount() : 0;
        int i = 1;
        int columnCount = metaData.getColumnCount() - hiddenColumnCount;
        while (i <= columnCount) {
            String columnName = metaData.getColumnLabel(i);
            if (columnName == null || columnName.isEmpty()) {
                throw new MidCoreException(25, MidCoreException.formatMessage(null, (int)25, (Object[])new Object[0]));
            }
            int dataType = columnMetaData.getColumnType(metaData, i, columnName);
            dataTypeList.put(columnName, dataType);
            ColumnInfo c = new ColumnInfo(columnName, dataType);
            table.addColumn(c);
            ++i;
        }
        rs.beforeFirst();
        if (rs.next()) {
            do {
                int index = table.append();
                Row row = table.getRowByIndex(index);
                Object[] dataList = row.getDataList();
                int i2 = 1;
                while (i2 <= metaData.getColumnCount()) {
                    String columnName = metaData.getColumnLabel(i2);
                    Object value = rs.getObject(columnName);
                    int dataType = (Integer)dataTypeList.get(columnName);
                    if (StringUtil.isBlankOrNull((Object)value)) {
                        if (dataType == 1002 || dataType == 1012 || dataType == 1011) {
                            value = "";
                        } else if (dataType == 1001 || dataType == 1010 || dataType == 1005 || dataType == 1006 || dataType == 1007) {
                            value = TypeConvertor.toDataType((int)dataType, (Object)0);
                        }
                    }
                    dataList[i2 - 1] = value = DocumentConvertor.convert((Object)value, (int)((Integer)dataTypeList.get(columnName)));
                    ++i2;
                }
            } while (rs.next());
            rs.close();
        } else {
            rs.close();
        }
        return table;
    }

    public static void populate(IDBManager DBManager, DataTable table, ResultSet rs, ArrayList<String> DBKeyList) throws Throwable {
        throw new RuntimeException("\u76ee\u524d\u6ca1\u6709\u4f7f\u7528!");
    }

    public static void populate(IDBManager DBManager, Document doc, DataTable table, ResultSet rs, ArrayList<String> DBKeyList, int maxRows) throws Throwable {
        throw new RuntimeException("\u76ee\u524d\u6ca1\u6709\u4f7f\u7528!");
    }

    public static boolean startsWithIgnoreCase(String searchIn, int startAt, String searchFor) {
        return searchIn.regionMatches(true, startAt, searchFor, 0, searchFor.length());
    }

    public static boolean startsWithIgnoreCase(String searchIn, String searchFor) {
        return DocumentDBUtil.startsWithIgnoreCase(searchIn, 0, searchFor);
    }

    static final class NormalQueryColumnMetaData
    implements IQueryColumnMetaData {
        private IDBManager dbManager = null;

        public NormalQueryColumnMetaData(IDBManager dbManager) {
            this.dbManager = dbManager;
        }

        public int getColumnType(ResultSetMetaData metaData, int index, String column) throws Throwable {
            return this.dbManager.convertDataType(metaData.getColumnType(index));
        }
    }
}

