/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.mid.schema;

import com.bokesoft.erp.mid.schema.ERPSchemaCheck;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaIndexCollection;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.schemamgr.ISchemaCreate;
import com.bokesoft.yigo.mid.schemamgr.SchemaCreateFactory;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ERPSchemaProcess {
    private static final String ORACLE_INDEX_COLUMN_QUERY_SQL = "select table_name,index_name,column_name from user_ind_columns where index_name not in (select constraint_name from user_constraints where user_constraints.constraint_type='P') order by table_name,index_name,column_position";
    private static final String MYSQL_INDEX_COLUMN_QUERY_SQL = "select table_name,index_name,column_name from information_schema.STATISTICS where  TABLE_SCHEMA = %? order by table_name,index_name";
    private static final String SQLSERVER_INDEX_COLUMN_QUERY_SQL = "SELECT TableName=O.Name, IndexName=IDX.Name, ColumnName=C.Name FROM sys.indexes IDX INNER JOIN sys.index_columns IDXC ON IDX.[object_id]=IDXC.[object_id] AND IDX.index_id=IDXC.index_id INNER JOIN sys.objects O ON O.[object_id]=IDX.[object_id] INNER JOIN sys.columns C ON O.[object_id]=C.[object_id] AND O.type='U' AND O.is_ms_shipped=0 AND IDXC.Column_id=C.Column_id";
    private static final String DM_INDEX_COLUMN_QUERY_SQL = "select table_name,index_name,column_name from user_ind_columns where index_name not in (select constraint_name from user_constraints where user_constraints.constraint_type='P') order by table_name,index_name,column_position";
    private static final String ORACLE_INDEX_DROP_SQL = "drop index %s";
    private static final String MYSQL_INDEX_DROP_SQL = "DROP INDEX %s ON %s";
    private static final String SQLSERVER_INDEX_DROP_SQL = "DROP INDEX %s ON %s";
    private static final String DM_INDEX_DROP_SQL = "drop index %s";
    private DataBaseInfo info = new DataBaseInfo();
    private Map<String, String> columnsIndexMap = null;
    private Map<String, String> indexTableMap = null;

    public DataBaseInfo getInfo() {
        return this.info;
    }

    public ERPSchemaProcess(IDBManager dbManager) throws Throwable {
        dbManager.initDataBaseInfo(this.info);
        this.columnsIndexMap = new HashMap<String, String>();
        this.indexTableMap = new HashMap<String, String>();
        this.initIndexColumns(dbManager);
    }

    private void initIndexColumns(IDBManager dbManager) {
        try {
            String columns;
            String index_name;
            DataTable dataTable = null;
            int dbType = dbManager.getDBType();
            if (dbType == 2) {
                dataTable = dbManager.execQuery("select table_name,index_name,column_name from user_ind_columns where index_name not in (select constraint_name from user_constraints where user_constraints.constraint_type='P') order by table_name,index_name,column_position");
            } else if (dbType == 4) {
                String dbName = dbManager.getDBName();
                SqlString sql = SqlString.format(MYSQL_INDEX_COLUMN_QUERY_SQL, dbName);
                dataTable = dbManager.execPrepareQuery(sql.getSql(), sql.getParameterList());
            } else if (dbType == 1) {
                dataTable = dbManager.execPrepareQuery(SQLSERVER_INDEX_COLUMN_QUERY_SQL, new Object[0]);
            } else if (dbType == 8) {
                dataTable = dbManager.execPrepareQuery("select table_name,index_name,column_name from user_ind_columns where index_name not in (select constraint_name from user_constraints where user_constraints.constraint_type='P') order by table_name,index_name,column_position", new Object[0]);
            }
            if (dataTable == null || dataTable.size() == 0) {
                return;
            }
            HashMap<String, String> indexColumnsMap = new HashMap<String, String>();
            int size = dataTable.size();
            int rowIndex = 0;
            while (rowIndex < size) {
                String table_name = dataTable.getString(rowIndex, 0).toUpperCase();
                index_name = dataTable.getString(rowIndex, 1).toUpperCase();
                String column_name = dataTable.getString(rowIndex, 2).toUpperCase();
                columns = (String)indexColumnsMap.get(index_name);
                columns = columns == null ? column_name : String.valueOf(columns) + "," + column_name;
                indexColumnsMap.put(index_name, columns.toUpperCase());
                this.indexTableMap.put(index_name, table_name);
                ++rowIndex;
            }
            for (Map.Entry<String, String> entry : this.indexTableMap.entrySet()) {
                index_name = entry.getKey();
                String tableName = entry.getValue();
                columns = (String)indexColumnsMap.get(index_name);
                this.columnsIndexMap.put(String.valueOf(tableName) + "." + columns, index_name);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void updateIndexColumns(String tableKey, MetaIndex index) {
        String indexName = index.getKey().toUpperCase();
        this.indexTableMap.put(indexName, tableKey);
        String key = String.valueOf(tableKey.toUpperCase()) + "." + index.getColumns().toUpperCase();
        this.columnsIndexMap.put(key, indexName);
    }

    public boolean tableRebuild(IDBManager dbManager, MetaSchemaTable table) throws Throwable {
        boolean result = false;
        if (this.info.checkViewExist(table.getKey())) {
            return result;
        }
        ISchemaCreate schemaCreate = SchemaCreateFactory.getInstance().create();
        if (!this.info.checkTableExist(table.getKey())) {
            schemaCreate.createTable(dbManager, table);
            if (dbManager.getDBType() == 14) {
                dbManager.commit();
            }
            result = true;
            MetaIndexCollection indexCollection = table.getIndexCollection();
            if (indexCollection != null) {
                for (MetaIndex index : indexCollection) {
                    this.createIndex(dbManager, schemaCreate, table, index);
                    this.updateIndexColumns(table.getKey(), index);
                }
            }
        } else {
            ERPSchemaCheck schemaCheck = new ERPSchemaCheck(dbManager, table, this.info);
            List columns = schemaCheck.checkTable();
            if (columns.size() != 0) {
                String alterTableStr = dbManager.getAlterTableStr(table, columns);
                dbManager.execPrepareUpdate(alterTableStr, new Object[0]);
                if (dbManager.getDBType() == 14) {
                    dbManager.commit();
                }
                result = true;
            }
            List indexes = schemaCheck.checkIndex();
            this.checkUpdateIndex(dbManager, table, indexes, schemaCreate);
        }
        if (this.info != null) {
            this.info.updateInfo(table);
        }
        return result;
    }

    public void checkUpdateIndex(IDBManager dbManager, MetaSchemaTable table, List<MetaIndex> indexes, ISchemaCreate schemaCreate) throws Throwable {
        if (indexes.size() != 0) {
            for (MetaIndex index : indexes) {
                this.dropExistsIndex(dbManager, table.getKey(), index);
                this.createIndex(dbManager, schemaCreate, table, index);
                this.updateIndexColumns(table.getKey(), index);
            }
        }
    }

    public void tableRepartition(IDBManager dbManager, MetaSchemaTable table) throws Throwable {
        ISchemaCreate schemaCreate = SchemaCreateFactory.getInstance().create();
        ERPSchemaCheck schemaCheck = new ERPSchemaCheck(dbManager, table, this.info);
        if (!schemaCheck.checkPartition(this.info)) {
            schemaCreate.createPartition(dbManager, table);
            if (dbManager.getDBType() == 14) {
                dbManager.commit();
            }
            if (this.info != null) {
                this.info.updatePartitionInfo(table);
            }
        }
    }

    private void dropExistsIndex(IDBManager dbManager, String tableKey, MetaIndex index) throws Throwable {
        String key;
        String oldColumnIndex;
        String newIndexName = index.getKey().toUpperCase();
        String newIndexColumns = index.getColumns().toUpperCase();
        HashSet indexSet = this.info.getIndexSet(tableKey);
        String indexTableKey = this.indexTableMap.get(newIndexName);
        int dbType = dbManager.getDBType();
        if (!StringUtil.isBlankOrNull((String)indexTableKey) && tableKey.equalsIgnoreCase(indexTableKey)) {
            if (dbType == 2) {
                dbManager.execPrepareUpdate(String.format("drop index %s", newIndexName), new Object[0]);
            } else if (dbType == 4) {
                dbManager.execPrepareUpdate(String.format("DROP INDEX %s ON %s", newIndexName, tableKey), new Object[0]);
            } else if (dbType == 1) {
                dbManager.execPrepareUpdate(String.format("DROP INDEX %s ON %s", newIndexName, tableKey), new Object[0]);
            } else if (dbType == 8) {
                dbManager.execPrepareUpdate(String.format("drop index %s", newIndexName, tableKey), new Object[0]);
            }
            if (dbType == 14) {
                dbManager.commit();
            }
            indexSet.remove(newIndexName);
        }
        if (!StringUtil.isBlankOrNull((String)(oldColumnIndex = this.columnsIndexMap.get(key = String.valueOf(tableKey.toUpperCase()) + "." + newIndexColumns.toUpperCase()))) && !oldColumnIndex.equalsIgnoreCase(newIndexName)) {
            if (dbType == 2) {
                dbManager.execPrepareUpdate(String.format("drop index %s", oldColumnIndex), new Object[0]);
            } else if (dbType == 4) {
                dbManager.execPrepareUpdate(String.format("DROP INDEX %s ON %s", oldColumnIndex, tableKey), new Object[0]);
            } else if (dbType == 1) {
                dbManager.execPrepareUpdate(String.format("DROP INDEX %s ON %s", oldColumnIndex, tableKey), new Object[0]);
            } else if (dbType == 8) {
                dbManager.execPrepareUpdate(String.format("drop index %s", oldColumnIndex, tableKey), new Object[0]);
            }
            if (dbType == 14) {
                dbManager.commit();
            }
            indexSet.remove(oldColumnIndex);
        }
    }

    public void dropIndex(IDBManager dbManager, String tableKey, String indexName) throws Throwable {
        HashMap uniqueIndexSet;
        HashMap indexColumnSet;
        int dbType = dbManager.getDBType();
        if (dbType == 2) {
            dbManager.execPrepareUpdate(String.format("drop index %s", indexName), new Object[0]);
        } else if (dbType == 4) {
            dbManager.execPrepareUpdate(String.format("DROP INDEX %s ON %s", indexName, tableKey), new Object[0]);
        } else if (dbType == 1) {
            dbManager.execPrepareUpdate(String.format("DROP INDEX %s ON %s", indexName, tableKey), new Object[0]);
        } else if (dbType == 8) {
            dbManager.execPrepareUpdate(String.format("drop index %s", indexName, tableKey), new Object[0]);
        }
        if (dbType == 14) {
            dbManager.commit();
        }
        String name = indexName.toUpperCase();
        HashSet indexSet = this.info.getIndexSet(tableKey);
        if (indexSet != null) {
            indexSet.remove(name);
        }
        if ((indexColumnSet = this.info.getIndexColumnSet(tableKey)) != null) {
            indexColumnSet.remove(name);
        }
        if ((uniqueIndexSet = this.info.getUniqueIndexSet(tableKey)) != null) {
            uniqueIndexSet.remove(name);
        }
    }

    public void createIndex(IDBManager dbManager, ISchemaCreate schemaCreate, MetaSchemaTable table, MetaIndex index) throws Throwable {
        try {
            String oldIndexKey;
            String sql;
            DataTable rst;
            if (dbManager.getDBType() == 8 && (rst = dbManager.execPrepareQuery(sql = "select index_name from user_indexes where UPPER(index_name) like '" + (oldIndexKey = index.getKey()) + "%' order by index_name desc", new Object[0])) != null) {
                if (rst.size() == 1) {
                    String newSeq = "1";
                    index.setKey(String.valueOf(oldIndexKey) + newSeq);
                } else if (rst.size() > 1) {
                    String indexName_MaxSeq = rst.getString(0, "index_name");
                    String maxSeq = indexName_MaxSeq.substring(indexName_MaxSeq.length() - 1);
                    String newSeq = String.valueOf(Integer.valueOf(maxSeq) + 1);
                    index.setKey(String.valueOf(oldIndexKey) + newSeq);
                }
            }
            schemaCreate.createIndex(dbManager, table, index);
            if (dbManager.getDBType() == 14) {
                dbManager.commit();
            }
            return;
        }
        catch (SQLSyntaxErrorException e) {
            String error = "Specified key was too long; max key length is 3072 bytes";
            String msg = e.getMessage();
            if (error.equals(msg)) {
                throw new SQLSyntaxErrorException("\u7ec4\u6210\u7d22\u5f15\u5217\u7684\u5b57\u8282\u957f\u5ea6\u548c\u5927\u4e8e3072\u5b57\u8282\uff0c\u5efa\u8bae\u4fee\u6539\u914d\u7f6e\u3002", e);
            }
            LogSvr.getInstance().error("\u521b\u5efa\u7d22\u5f15\u51fa\u9519\u4e86\uff1a" + e.getMessage(), (Throwable)e);
        }
        catch (Throwable t) {
            String tableName = dbManager.searchIndex(index.getKey());
            if (tableName != null) {
                throw new MidCoreException(19, MidCoreException.formatMessage(null, (int)19, (Object[])new Object[]{table.getKey(), index.getKey(), tableName}));
            }
            LogSvr.getInstance().error("\u521b\u5efa\u7d22\u5f15\u51fa\u9519\u4e86\uff1a" + t.getMessage(), t);
        }
    }

    public boolean addColumnIntoKeysMigrationTable(IDBManager dbManager, MetaSchemaTable table) throws Throwable {
        boolean result = false;
        String tableName = table.getKey();
        String newTableName = String.valueOf(tableName) + "_NEW";
        String incrTableName = String.valueOf(tableName) + "_INCR";
        ERPSchemaCheck schemaCheck = new ERPSchemaCheck(dbManager, table, this.info);
        List<MetaSchemaColumn> columns = schemaCheck.checkKeysMigrationTable();
        if (columns.size() != 0) {
            table.setKey(newTableName);
            String alterTableStr = dbManager.getAlterTableStr(table, columns);
            dbManager.execPrepareUpdate(alterTableStr, new Object[0]);
            if (dbManager.getDBType() == 14) {
                dbManager.commit();
            }
            table.setKey(incrTableName);
            alterTableStr = dbManager.getAlterTableStr(table, columns);
            dbManager.execPrepareUpdate(alterTableStr, new Object[0]);
            if (dbManager.getDBType() == 14) {
                dbManager.commit();
            }
            result = Boolean.TRUE;
        }
        this.addColumnIntoInfo(table, incrTableName);
        this.addColumnIntoInfo(table, newTableName);
        return result;
    }

    private void addColumnIntoInfo(MetaSchemaTable table, String tableName) {
        HashSet columnSet = this.info.getTableColumnSet(tableName);
        if (columnSet != null && !columnSet.isEmpty()) {
            ArrayList<MetaSchemaColumn> fieldList = new ArrayList<MetaSchemaColumn>();
            for (MetaSchemaColumn metaSchemaColumn : table.getColumnCollection()) {
                if (columnSet.contains(metaSchemaColumn.getKey().toUpperCase())) continue;
                fieldList.add(metaSchemaColumn);
            }
            if (fieldList != null && !fieldList.isEmpty()) {
                this.info.updateColumnInfo(tableName, fieldList);
            }
        }
    }
}

