/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.mid.io.doc;

import com.bokesoft.yes.common.util.ReflectUtil;
import com.bokesoft.yes.mid.base.MidVE;
import com.bokesoft.yes.mid.connection.DBUtil;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.io.doc.DocLockCheck;
import com.bokesoft.yes.mid.relation.RelationProxy;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaHistory;
import com.bokesoft.yigo.meta.dataobject.MetaSecurityProvider;
import com.bokesoft.yigo.meta.dataobject.MetaSecurityProviderCollection;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.path.MetaRelationProxy;
import com.bokesoft.yigo.meta.path.MetaSecurityFilter;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.extend.ISecurityProvider;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.SaveFilterMap;
import com.bokesoft.yigo.struct.document.TableSaveFilterDetail;
import com.bokesoft.yigo.tools.ve.VE;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ERPDocSave {
    private Document doc = null;
    private MetaDataObject metaDataObject = null;
    private SaveFilterMap saveFilterMap = null;
    private MetaTable mainTable = null;
    private Integer VERID = 0;

    public ERPDocSave(Document doc, SaveFilterMap saveFilterMap, MetaDataObject metaDataObject) {
        this.doc = doc;
        this.metaDataObject = metaDataObject;
        this.saveFilterMap = saveFilterMap;
        this.mainTable = metaDataObject.getMainTable();
        this.VERID = doc.getVERID();
    }

    public boolean save(DefaultContext context) throws Throwable {
        IDBManager dbManager = context.getDBManager();
        MidVE ve = context.getVE();
        MetaSecurityFilter securityFilter = ve.getMetaFactory().getSecurityFilter(null);
        if (securityFilter != null) {
            MetaRelationProxy proxy = securityFilter.getRelationproxy();
            String impl = proxy.getImpl();
            Class<?> pxyClass = Class.forName(impl);
            Object o = pxyClass.newInstance();
            RelationProxy relationProxy = (RelationProxy)o;
            relationProxy.checkDoc((VE)ve, dbManager, this.doc, 2, proxy.isCache().booleanValue());
        }
        this.check(context);
        this.saveDiret(context, dbManager);
        return true;
    }

    private void check(DefaultContext context) throws Throwable {
        IDBManager dbManager = context.getDBManager();
        MidVE ve = context.getVE();
        this.preSecurityCheck((VE)ve);
        DocLockCheck.checkAndLock((ILocale)context.getEnv(), (Document)this.doc, (MetaDataObject)this.metaDataObject, (IDBManager)dbManager);
        MetaTable mainTable = this.metaDataObject.getMainTable();
        if (mainTable != null && mainTable.isUniquePrimary().booleanValue()) {
            this.preCheck4UniquePrimary(dbManager, this.doc.get(mainTable.getKey()), mainTable);
        }
    }

    private void preSecurityCheck(VE ve) throws Throwable {
        ISecurityProvider securityProvider;
        String provider;
        MetaSecurityProvider metaProvider;
        MetaSecurityProviderCollection securityProviderCollection = this.metaDataObject.getSecurityProviderCollection();
        if (securityProviderCollection != null && (metaProvider = (MetaSecurityProvider)securityProviderCollection.get("Save")) != null && (provider = metaProvider.getProvider()) != null && !provider.isEmpty() && (securityProvider = (ISecurityProvider)ReflectUtil.newInstance((String)provider)) != null) {
            securityProvider.doCheck(ve, this.metaDataObject.getKey(), this.doc);
        }
    }

    public void saveDiret(DefaultContext context, IDBManager dbManager) throws Throwable {
        if (this.mainTable != null) {
            DataTable tableData = this.doc.get(this.mainTable.getKey());
            if (this.metaDataObject.getSecondaryType() == 6 || this.metaDataObject.getSecondaryType() == 8) {
                this.saveTable(context, dbManager, tableData, this.mainTable);
            } else if (this.doc.getDocumentType() == 1) {
                if (tableData.getState(0) != 0) {
                    this.saveTable(context, dbManager, tableData, this.mainTable);
                } else {
                    ERPDocSave.saveMainTableVersionID(tableData, this.mainTable, dbManager, this.doc.getOID(), true);
                }
                this.doc.reSetIDValue();
            } else if (this.doc.getDocumentType() == 2) {
                ERPDocSave.saveMainTableVersionID(tableData, this.mainTable, dbManager, this.doc.getOID(), false);
            }
        }
        for (MetaTable table : this.metaDataObject.getTableCollection()) {
            if (table == this.mainTable || table.isHidden().booleanValue()) continue;
            this.saveTable(context, dbManager, this.doc.get(table.getKey()), table);
        }
    }

    private void preCheck4UniquePrimary(IDBManager DBManager, DataTable table, MetaTable metaTable) throws Throwable {
        if (table == null || table.size() == 0) {
            return;
        }
        if (table.getState(0) == 0) {
            return;
        }
        String OIDDBKey = metaTable.getOIDColumn().getBindingDBColumnName();
        String DBTableName = metaTable.getBindingDBTableName();
        DBManager.setRowLock(DBTableName, OIDDBKey, Long.valueOf(-1L));
        ArrayList<MetaColumn> primaryColumnList = new ArrayList<MetaColumn>();
        ArrayList<String> conditionFieldKeyList = new ArrayList<String>();
        MetaColumn metaColumn = null;
        Iterator itColumnEntry = metaTable.entryIterator();
        Map.Entry columnEntry = null;
        while (itColumnEntry.hasNext()) {
            columnEntry = (Map.Entry)itColumnEntry.next();
            metaColumn = (MetaColumn)columnEntry.getValue();
            if (!metaColumn.getIsPrimary().booleanValue()) continue;
            primaryColumnList.add(metaColumn);
            conditionFieldKeyList.add(metaColumn.getBindingDBColumnName());
        }
        ArrayList<String> resultFieldKeyList = new ArrayList<String>();
        resultFieldKeyList.add(OIDDBKey);
        String sql = DBUtil.getQuerySQL((IDBManager)DBManager, resultFieldKeyList, (String)DBTableName, conditionFieldKeyList);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = DBManager.preparedQueryStatement(sql);
            PSArgs args = new PSArgs();
            for (MetaColumn column : primaryColumnList) {
                args.addArg(column.getDataType(), table.getObject(0, column.getKey()));
            }
            rs = DBManager.executeQuery(ps, sql, (QueryArguments)args);
            if (!rs.next()) {
                return;
            }
            if (table.getState(0) == 1) {
                throw new MidCoreException(14, MidCoreException.formatMessage(null, (int)14, (Object[])new Object[0]));
            }
            Long OOID = (Long)table.getObject(0, "OID");
            Long OID = rs.getLong(1);
            if (!OID.equals(OOID) || rs.next()) {
                throw new MidCoreException(14, MidCoreException.formatMessage(null, (int)14, (Object[])new Object[0]));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    private final void saveTable(DefaultContext context, IDBManager DBManager, DataTable table, MetaTable metaTable) throws Throwable {
        TableSaveFilterDetail tableSaveFilter;
        TableSaveFilterDetail tableSaveFilterDetail = tableSaveFilter = this.saveFilterMap != null ? (TableSaveFilterDetail)this.saveFilterMap.get((Object)metaTable.getKey()) : null;
        if (tableSaveFilter != null && tableSaveFilter.getSaveType() == 2) {
            return;
        }
        if (table == null) {
            return;
        }
        if (!metaTable.isPersist().booleanValue()) {
            return;
        }
        table.setShowDeleted(true);
        int fieldSize = table.getMetaData().getColumnCount();
        if (metaTable.getOIDColumn() == null) {
            throw new MidCoreException(41, MidCoreException.formatMessage(null, (int)41, (Object[])new Object[]{metaTable.getKey()}));
        }
        String OIDDBKey = metaTable.getOIDColumn().getBindingDBColumnName();
        ArrayList<String> updateFieldList = new ArrayList<String>(fieldSize);
        ArrayList<String> insertFieldList = new ArrayList<String>(fieldSize);
        ArrayList<Integer> updateKeyIndex = new ArrayList<Integer>(fieldSize);
        ArrayList<Integer> insertKeyIndex = new ArrayList<Integer>(fieldSize);
        HashSet onlySet = null;
        HashSet excludeSet = null;
        if (tableSaveFilter != null) {
            if (tableSaveFilter.getSaveType() == 3) {
                onlySet = tableSaveFilter.getFieldKeySet();
            } else if (tableSaveFilter.getSaveType() == 4) {
                excludeSet = tableSaveFilter.getFieldKeySet();
            }
        }
        DataTableMetaData tableMetaData = table.getMetaData();
        int[] columnFieldTypes = new int[fieldSize];
        int i = 0;
        while (i < fieldSize) {
            ColumnInfo columnInfo = tableMetaData.getColumnInfo(i);
            columnFieldTypes[i] = columnInfo.getDataType();
            String key = columnInfo.getColumnKey();
            MetaColumn metaColumn = (MetaColumn)metaTable.get(key);
            if (metaColumn != null && metaColumn.isPersist().booleanValue() && !metaColumn.isIgnoreSave().booleanValue() && (metaColumn.isSystemControlField().booleanValue() || onlySet == null || onlySet.contains(key)) && (metaColumn.isSystemControlField().booleanValue() || excludeSet == null || !excludeSet.contains(key)) && columnInfo.isHasWriteRights()) {
                String dbKey = ((MetaColumn)metaTable.get(key)).getBindingDBColumnName();
                insertFieldList.add(dbKey);
                insertKeyIndex.add(i);
                if (!metaColumn.isSystemControlField().booleanValue()) {
                    updateFieldList.add(dbKey);
                    updateKeyIndex.add(i);
                }
            }
            ++i;
        }
        ArrayList<Integer> needLogs = new ArrayList<Integer>();
        String insertHistorySql = null;
        Statement ps4History = null;
        Statement deletePS = null;
        int deleteCount = 0;
        Statement updatePS = null;
        int updateCount = 0;
        Statement insertPS = null;
        int insertCount = 0;
        try {
            MetaHistory metaHistory;
            table.beforeFirst();
            while (table.next()) {
                Object value;
                int index;
                Iterator iterator;
                Object[] rv;
                int parameterIndex;
                int rowState = table.getState();
                if (rowState == 3) {
                    needLogs.add(table.getBookmark());
                    if (deletePS == null) {
                        deletePS = DBManager.preparedUpdateStatement(DBUtil.getDeleteSQL((IDBManager)DBManager, (String)metaTable.getBindingDBTableName(), (String)OIDDBKey));
                    }
                    DBManager.setParameter((PreparedStatement)deletePS, 1, (Object)((Long)table.getObject("OID")), 1010);
                    deletePS.addBatch();
                    if (++deleteCount != 100) continue;
                    deletePS.executeBatch();
                    deleteCount = 0;
                    continue;
                }
                if (rowState == 2) {
                    needLogs.add(table.getBookmark());
                    if (updatePS == null) {
                        String VERIDDBKey = metaTable.getVERIDColumn().getBindingDBColumnName();
                        updatePS = DBManager.preparedUpdateStatement(DBUtil.getUpdateSQL((IDBManager)DBManager, (String)metaTable.getBindingDBTableName(), updateFieldList, (String)VERIDDBKey, (String)OIDDBKey));
                    }
                    parameterIndex = 1;
                    rv = table.impl_getRow();
                    iterator = updateKeyIndex.iterator();
                    while (iterator.hasNext()) {
                        index = (Integer)iterator.next();
                        value = rv[index];
                        DBManager.setParameter((PreparedStatement)updatePS, parameterIndex++, value, columnFieldTypes[index]);
                    }
                    DBManager.setParameter((PreparedStatement)updatePS, parameterIndex++, (Object)((Long)table.getObject("OID")), 1010);
                    if (DBManager instanceof MultiDBManager) {
                        ((MultiDBManager)DBManager).setParameterSOID((PreparedStatement)updatePS, table.getLong("SOID"));
                    }
                    table.setInt("VERID", Integer.valueOf(TypeConvertor.toInteger((Object)table.getObject("VERID")) + 1));
                    updatePS.addBatch();
                    if (++updateCount != 100) continue;
                    updatePS.executeBatch();
                    updateCount = 0;
                    continue;
                }
                if (rowState != 1) continue;
                parameterIndex = 1;
                if (insertPS == null) {
                    insertPS = DBManager.preparedUpdateStatement(DBUtil.getInsertSQL((IDBManager)DBManager, (String)metaTable.getBindingDBTableName(), insertFieldList));
                }
                rv = table.impl_getRow();
                iterator = insertKeyIndex.iterator();
                while (iterator.hasNext()) {
                    index = (Integer)iterator.next();
                    value = rv[index];
                    DBManager.setParameter((PreparedStatement)insertPS, parameterIndex++, value, columnFieldTypes[index]);
                }
                insertPS.addBatch();
                if (++insertCount != 100) continue;
                insertPS.executeBatch();
                insertCount = 0;
            }
            if (deletePS != null && deleteCount > 0) {
                deletePS.executeBatch();
            }
            if (updatePS != null && updateCount > 0) {
                updatePS.executeBatch();
            }
            if (insertPS != null && insertCount > 0) {
                insertPS.executeBatch();
            }
            if ((metaHistory = this.metaDataObject.getHistory()) != null && metaHistory.isSupport().booleanValue()) {
                for (Integer bookmark : needLogs) {
                    table.setBookmark(bookmark.intValue());
                    PSArgs args = new PSArgs();
                    Iterator iterator = insertKeyIndex.iterator();
                    while (iterator.hasNext()) {
                        int index = (Integer)iterator.next();
                        String columnKey = table.getMetaData().getColumnInfo(index).getColumnKey();
                        if ("VERID".equalsIgnoreCase(columnKey)) continue;
                        Object orgValue = table.getOriginalObject(index);
                        args.addArg(Integer.valueOf(table.getMetaData().getColumnInfo(index).getDataType()), orgValue);
                    }
                    args.addArg(Integer.valueOf(1001), table.getOriginalObject("VERID"));
                    args.addArg(Integer.valueOf(1001), (Object)this.VERID);
                    if (ps4History == null) {
                        insertHistorySql = DBUtil.getHistoryInsertSQL((IDBManager)DBManager, (String)metaTable.getHistoryTableName(), insertFieldList);
                        ps4History = DBManager.preparedUpdateStatement(insertHistorySql);
                    }
                    DBManager.executeUpdate((PreparedStatement)ps4History, insertHistorySql, (QueryArguments)args);
                }
            }
        }
        finally {
            if (ps4History != null) {
                ps4History.close();
            }
            if (deletePS != null) {
                deletePS.close();
            }
            if (updatePS != null) {
                updatePS.close();
            }
            if (insertPS != null) {
                insertPS.close();
            }
        }
    }

    private static final void saveMainTableVersionID(DataTable tableData, MetaTable mainTable, IDBManager dbManager, long OID, boolean updateVERID) throws Throwable {
        if (!mainTable.isPersist().booleanValue()) {
            return;
        }
        String OIDDBKey = mainTable.getOIDColumn().getBindingDBColumnName();
        String versionFieldKEY = updateVERID ? "VERID" : "DVERID";
        String versionKEY = ((MetaColumn)mainTable.get(versionFieldKEY)).getBindingDBColumnName();
        String sql = DBUtil.getUpdateSQL((IDBManager)dbManager, (String)mainTable.getBindingDBTableName(), null, (String)versionKEY, (String)OIDDBKey);
        try (PreparedStatement ps = null;){
            ps = dbManager.preparedUpdateStatement(sql);
            PSArgs args = new PSArgs();
            args.addLongArg(Long.valueOf(OID));
            dbManager.executeUpdate(ps, sql, (QueryArguments)args);
        }
        if (tableData != null) {
            int oldValue = (Integer)tableData.getObject(0, versionFieldKEY);
            tableData.setInt(0, versionFieldKEY, Integer.valueOf(oldValue + 1));
        }
    }
}

