import elmUtils from "../util/elmUtils.js";
import Favorite from "../../home/js/favorite/favorite.js";

export default function MainTree(rootEntry, dom) {
    //FIXME 暂时设置，待后台服务完善修改
    const enableFavorite = true;
    const el = document.createElement("ul");
    el.classList.add("tm");
    dom.appendChild(el);

    var options = {
        el: el,
        _open: false,
        menuType: rootEntry.style,
        _openedItem: null,
        _data: [],
        //isSliding: false, //树是否正在展开和收缩的运动中
        rootEntry: rootEntry,
        isLodingForm: false, //是否正在打开表单

        clickEvent: {
            expandNode: function (self) {
                //展开和收缩的运动中不操作
                // if (self.isSliding) return;

                //展开
                var nodeId = this.getAttribute("id");
                var node = self.getTreeNode(nodeId);
                self.callback.beforeExpand(node);

                if (!node.isLoaded) {
                    node.isLoaded = true;
                }

                var issm = isSm();

                var _wrap = this.nextElementSibling;
                if (_wrap) {
                    if (issm) {
                        expandSmNode(this, _wrap);
                    } else {
                        elmUtils.slideDown(_wrap);
                    }
                }

                this.classList.remove("close", "collapse");
                this.classList.add("open", "expand", "cursel");

                this.parentNode.classList.add("sel");

                var close = YIUI.AppSetting.getClientSetting("mainframe.closeOtherEntry"); // 展开菜单节点时是否收起其它
                if (close === undefined) {
                    close = true;
                }

                if (close || issm) {
                    closeSiblingsMenu(this);
                }

                function expandSmNode(item, menu) {
                    var rectObject = item.getBoundingClientRect();

                    var w_h = window.innerHeight,
                        top = rectObject.top,
                        m_h = elmUtils.getHeight(menu);

                    if (rectObject.top + m_h > w_h) {
                        top = w_h - m_h - 20;
                    }

                    menu.style.top = top + "px";
                    menu.style.left = rectObject.right + "px";
                }
            },

            collapse: function (self) {
                //展开和收缩的运动中不操作

                if (!this.classList.contains("expand")) {
                    return;
                }

                var issm = isSm();

                let parent = this.parentNode;
                parent.classList.remove("sel");
                let openNodes = parent.querySelectorAll(".open.expand");
                let wraps = [];

                openNodes.forEach((node) => {
                    node.classList.add("close", "collapse");
                    node.classList.remove("open", "expand", "cursel");
                    node.nextElementSibling &&
                        wraps.push(node.nextElementSibling);
                });

                wraps.forEach((node) => {
                    if (issm) {
                        node.style.display = "none";
                    } else {
                        elmUtils.slideUp(node);
                    }
                });
            },

            selectNode: function (self) {
                const parent = this.parentNode,
                    id = this.getAttribute("id");

                if (self.selectedNodeId) {
                    const node = document.getElementById(self.selectedNodeId);
                    if (node) {
                        node.classList.remove("clicked");
                        node.parentNode.classList.remove("clicked");
                    }
                }
                self.selectedNodeId = id;
                this.classList.add("clicked");
                parent.classList.add("clicked");
                self.callback.onSelect(self.getTreeNode(id));
            },
        },
        callback: {
            beforeExpand: function () {},
            onSelect: async (node) => {
                if (this.isLodingForm) {
                    return;
                }
                try {
                    this.isLodingForm = true;
                    await YIUI.treeClickHandle(
                        node,
                        document.querySelector(".mainRight")
                    );
                } catch (e) {
                    throw e;
                } finally {
                    this.isLodingForm = false;
                }
            },
        },

        getTreeNode: function (nodeId) {
            for (var i = 0, len = this._data.length; i < len; i++) {
                if (this._data[i].id == nodeId) {
                    return this._data[i];
                }
            }
        },

        initDataSource: function (dataSource, parent) {
            if (!dataSource) return;
            var _this = this;
            if (Array.isArray(dataSource)) {
                dataSource.forEach(function (v, i) {
                    var data = dataSource[i];
                    if (!data.id) {
                        data.id = data.path.split("/").join("-") + "-" + i;
                    }
                    if(data.zTreeId){
                        data.id = data.id + "_fav";
                    }
                    data.parent = parent;
                    data.fullName = parent && parent.fullName ? [parent.fullName, data.name].join('/') : data.name;
                    doInitDataSource.call(_this, data);
                });
            } else {
                dataSource.fullName = dataSource.name;
                doInitDataSource.call(this, dataSource);
            }
        },

        dataSourceCopy: async function (dataSource, parentID, parentVisible) {
            if (dataSource) {
                if (!dataSource.length) {
                    dataSource = [dataSource];
                }
                var visible;
                for (var i = 0, len = dataSource.length; i < len; i++) {
                    var ds = dataSource[i];
                    //var parent = ds.parent;
                    var d = new Object();
                    d.name = ds.name;
                    d.orgCaption = ds.orgCaption;
                    d.id = ds.id;
                    d.itemKey = ds.itemKey;
                    d.layerItemKey = ds.layerItemKey;
                    d.fullName = ds.fullName;
                    if (ds.isLoaded) {
                        d.isLoaded = ds.isLoaded;
                    } else {
                        d.isLoaded = false;
                    }

                    if (parentVisible === false) {
                        visible = false;
                    } else if (ds.calcedVisible != (void 0)) { //FIXME: 这里平台给出方法让ERP能扩展
                        visible = ds.calcedVisible;
                    } else {
                        try {
                            visible = !ds.visible
                                ? true
                                : await this.calcBoolean(ds.visible);
                        } catch (e) {
                            console.error(e);
                            visible = false;
                        }
                    }

                    ds._visible = visible;
                    d._visible = visible;

                    if (ds.children && ds.children.length > 0) {
                        d.open = ds.open;
                        var children = [];
                        for (
                            var j = 0, length = ds.children.length;
                            j < length;
                            j++
                        ) {
                            var child = ds.children[j];
                            children.push(child.id);
                            this.dataSourceCopy(child, ds.id, visible);
                        }
                        d.children = children;
                    } else {
                        d.key = ds.key;
                        d.formKey = ds.formKey;
                        d.paras = ds.parameters;
                        d.single = ds.single;
                        d.target = ds.target;
                        d.enable = ds.enable;
                    }
                    d.path = ds.path;
                    if (ds.parent) {
                        d.parentId = ds.parent.id;
                    }

                    if (parentID) {
                        d.parentID = parentID;
                    }

                    this._data.push(d);
                }
            }
        },
        /** 构建树结构 */
        buildTreenode: function (el, nodes, parentId) {
            if (!nodes) {
                return;
            }
            if (!nodes.length) {
                if (!parentId) {
                    nodes = nodes.children;
                }
            }

            nodes && this.addChilds(nodes, parentId, 0, this);
        },

        calcBoolean: async function (str) {
            return await window.exec(-1, str);
        },

        addChilds: async function (nodes, parentId, level, options) {
            var parent = null;
            if (parentId) {
                var parent = document.getElementById(parentId);
            }
            if (nodes.length <= 0) {
                if (parentId && parent.nextElementSibling) {
                    parent.nextElementSibling.remove();
                    parent.children[0].classList.remove("tm-collapse");
                }
                return;
            }

            if (parentId) {
                var parentNode = options.getTreeNode(parentId);
                parentNode.children = [];
            }

            var _this = this;
            await nodes.forEach(async function (node) {
                var nid = node.id;
                node.parentId = parentId;

                if (!node._visible) return;

                var _li = document.createElement("li");
                _li.classList.add("tm-node");
                _li.setAttribute("level", level);
                _li.setAttribute("path", node.path);

                if (node.single) {
                    _li.setAttribute("single", "true");
                    _li.setAttribute("formKey", node.formKey);
                    _li.setAttribute("paras", node.parameters);
                }
                if (node.target) {
                    _li.setAttribute("target", node.target);
                }
                if (!node.parentId) {
                    _li.classList.add("top-level");
                }

                if (node.appKey) {
                    _li.setAttribute("appKey", node.appKey);
                }

                var isEnable;
                try {
                    isEnable = !node.enable
                        ? true
                        : await _this.calcBoolean(node.enable);
                } catch (e) {
                    console.error(e);
                    isEnable = false;
                }

                if (!isEnable) {
                    _li.setAttribute("enable", false);
                }

                if (parentId) {
                    parentNode.children.push(nid);
                    let ul = parent.nextElementSibling.querySelector(".tm-ul");
                    ul.appendChild(_li);
                } else {
                    options.el.appendChild(_li);
                }

                var _a = document.createElement("a"),
                    _div,
                    _ul;

                _a.setAttribute("id", nid);
                _a.setAttribute("title", node.name);
                _a.setAttribute("class", "tm-anchor");
                _li.appendChild(_a);

                if (node.isParent) {
                    var left = (level - 1) * 16 + 36;
                    _a.style.paddingLeft = left + "px";
                } else {
                    _a.style.paddingLeft = (level - 1) * 16 + 36 + "px";
                }

                if (node.isParent) {
                    _li.classList.add("isparent");
                    _div = document.createElement("div");
                    _div.classList.add("tm-ul-wrap");
                    _ul = document.createElement("ul");
                    _ul.classList.add("tm-ul");
                    _div.appendChild(_ul);

                    if (node.open && !options._isOpen && !node.parentId) {
                        _li.classList.add("sel");
                        _a.classList.add("cursel", "open", "expand");
                        _a.setAttribute("open", true);
                        options._isOpen = true;
                        options._openedItem = _a;
                    } else {
                        _a.setAttribute("open", false);
                        _a.classList.add("close", "collapse");
                        _div.style.display = "none";
                    }
                    _li.appendChild(_div);
                }

                var _span = document.createElement("span");
                _span.classList.add("tm-name");
                _a.appendChild(_span);
                _span.innerHTML = node.name;

                if (node.icon || node.iconCode) {
                    YIUI.IconUtil && YIUI.IconUtil.loadIconSource(node, "Menu", function (className) {
                        var _icon = document.createElement("span");
                            _a.insertBefore(_icon, _span);
                            _span.classList.add("hasIcon");
                            _icon.classList.add("icon");
                            _icon.classList.add(className);
                    }, function () {
                        if (node.icon) {
                            YIUI.SvrMgr.getBase64Image({
                                path: node.icon,
                                thumbnail: false,
                                sourceType: -1,
                                project: node.project || options.project,
                                formKey: node.formKey,
                            }).then((data) => {
                                    if (!data) return;
                                    var _img = document.createElement("img");
                                    _a.insertBefore(_img, _span);
                                    _span.classList.add("hasIcon");
                                    _img.setAttribute("src", data);
                                })
                                .catch((e) => {
                                    console.error(e);
                                });
                        }
                    });
                }

                if (node.children) {
                    options.project =
                        level === 0 ? node.project : options.project;
                    _this.addChilds(node.children, node.id, level + 1, options);
                } else {
                    _a.classList.add("noExpand");
                    if(enableFavorite){
                        if (!node || node.isParent || isSm()) {
                            return;
                        }
                        let fav_icon = Favorite.init(node, _this.rootEntry);
                        _a.appendChild(fav_icon);
                    }

                    //添加帮助按钮
                    if (isNeedHelpBtn()) {
                        let _btn = document.createElement("span");
                        _btn.classList.add("meun-help-btn");
                        _a.appendChild(_btn);
                        _this._addHelpHandler(_btn, node);
                    }
                }
            });
        },
        getLeafFormNode: function (_entry, _tree) {
            if (_entry && _tree && _tree.children && _tree.children.length > 0) {
                for (var i = 0, _len = _tree.children.length; i < _len; i++) {
                    var node = _tree.children[i];
                    if (node.key === 'PFC1' || node.path === 'BKVirtualMenu/PFC1') {
                        continue;
                    }
                    if (node.children && Array.isArray(node.children)) {
                        var result = this.getLeafFormNode(_entry, node);
                        if (result && result.MenuNamePath && Array.isArray(result.MenuNamePath)) {
                            result.MenuNamePath.push(node.name);
                            result.OrgMenuNamePath.push(node.orgCaption);
                            return result;
                        } else {
                            if (i == _len - 1) {
                                //最后一个节点
                                return null;
                            } else {
                                //继续循环查看下一个节点
                            }
                        }
                    } else {
                        //叶子链接节点
                        if (node.path && node.path === _entry) {
                            //节点在树中
                            node.MenuNamePath = [];
                            node.MenuNamePath.push(node.name);
                            node.OrgMenuNamePath = [];
                            node.OrgMenuNamePath.push(node.orgCaption);
                            return node;
                        } else {
                            if (i == _len - 1) {
                                //最后一个节点
                                return null;
                            } else {
                                //继续循环查看下一个节点
                            }
                        }
                    }
                }
            } else {
                return null;
            }
        },
        _addHelpHandler: function (elm, node) {
            elm.addEventListener("click", function (e) {
                var parser = new YIUI.ViewParser();
                var formula =
                    window.YigoClassicUxSetting
                        .clientParameters.menuHelpFormula;
                formula = formula.replace('${EntryKey}',node.key);
                parser.eval(formula, null);
                e.stopPropagation();
            });
        },

        install: function () {
            var self = this;

            self.el.addEventListener(
                "click",
                elmUtils.throttle(function (e) {
                    var target = e.target.closest("a");
                    e.stopPropagation();
                    if (!target) return;
                    if (target.classList.contains("close")) {
                        self.clickEvent.expandNode.call(target, self);
                    } else if (target.classList.contains("open")) {
                        self.clickEvent.collapse.call(target, self);
                    }
                }, 300)
            );

            // //sm状态下目标移入2级菜单，显示3级菜单
            // self.el.addEventListener("mouseover", function (e) {
            //     var target = e.target.closest(".mainLeft-sm a");
            //     e.stopPropagation();
            //     if (!target || !isSm()) return;
            //     var node = target.parentNode;
            //     if (
            //         !node.classList.contains("top-level") &&
            //         node.classList.contains("isparent")
            //     ) {
            //         self.clickEvent.expandNode.call(target, self);
            //     }
            // });
            self.el.addEventListener("mouseover", function (e) {
                var target = e.target.closest(".mainLeft-sm a");
                e.stopPropagation();
                if (!target || !isSm()) return;
                var node = target.parentNode;
                if (!node.classList.contains("top-level")) {
                    if (node.classList.contains("isparent")) {
                        self.clickEvent.expandNode.call(target, self);
                    } else {
                        closeSiblingsMenu(target);
                    }
                }
            });

            // //self.el mouseleave

            self.el.addEventListener("mouseleave", function (e) {
                if (isSm()) {
                    let anchors = this.querySelectorAll(
                        ".tm-anchor.open.expand"
                    );
                    let wraps = this.querySelectorAll(".tm-ul-wrap");

                    anchors.forEach((item) => {
                        item.classList.add("close", "collapse");
                        item.classList.remove("open", "expand");
                    });

                    wraps.forEach((item) => {
                        item.style.display = "none";
                    });
                }
                e.stopPropagation();
            });

            var isClick = YIUI.AppSetting.getClientSetting("mainframe.openEntryByClick"); // 设置菜单是否为单击打开
            var eventType = isClick ? "click" : "dblclick";
            self.el.addEventListener(
                eventType,
                function (e) {
                    var target = e.target.closest("a.noExpand");
                    e.stopPropagation();
                    if (!target) return;
                    var isloading = target.getAttribute("isloading");
                    if (!isloading) {
                        target.setAttribute("isloading", true);
                        YIUI.MainUIOptTracer.getInstance().traceOnClick(YIUI.MainUIOptTracer.ClickType.MenuEntryClick,
                            { entryItemID: target.getAttribute("id"), mainTree: self });
                        self.clickEvent.selectNode.call(target, self);
                        //sm菜单状态下，选中后隐藏列表
                        if (isSm()) {
                            close(target);
                        }
                        setTimeout(() => {
                            target.removeAttribute("isloading");
                        }, 500);
                    }
                }
            );

            bindScrollHandler();

            //叶子节点帮助按钮事件
            // if (isNeedHelpBtn()) {
            //     let helpBtns = self.el.querySelectorAll(".meun-help-btn");
            //     helpBtns.forEach((btn) => {
            //         btn.addEventListener("click", function () {
            //             var parser = new YIUI.ViewParser();
            //             var formula =
            //                 window.YigoClientPageVariable.YigoClassicUxSetting
            //                     .clientParameters.menuHelpFormula;
            //             return parser.eval(formula, null);
            //         });
            //     });
            // }
        },

        init: async function () {
            const self = this;
            if(enableFavorite){
                Favorite.addFavorites2MenuData(this.rootEntry).then(() => {
                    self.doInit();
                });
            }else{
                this.doInit();
            }
        },
        doInit : async function(){
            this.initDataSource(this.rootEntry);
            await this.dataSourceCopy(this.rootEntry.children);
            this.buildTreenode(this.el, this.rootEntry);
            this.install();
        },
        reload: async function (entry) {
            this.expandNodes = this.getExpandNodes();
            this.el.innerHTML = "";
            this._data = [];
            this.initDataSource(entry);
            await this.dataSourceCopy(entry.children);
            this.buildTreenode(this.el, entry);
            bindScrollHandler();
            this.expandSelectedNode();
        },
        getExpandNodes: function () {
            var result = [];
            var list = document.querySelectorAll(
                "a.tm-anchor.open.expand.cursel"
            );
            list.forEach((node) => {
                result.push(node.getAttribute("id"));
            });

            return result;
        },
        expandSelectedNode: function () {
            var node = document.querySelector("#" + this.selectedNodeId);
            if (node) {
                node.classList.add("clicked");
                node.parentNode.classList.add("clicked");
            }

            this.expandNodes.forEach((id) => {
                var node = document.querySelector("#" + id);
                if (node) {
                    node.classList.add("open", "expand", "cursel");
                    node.parentNode.classList.add("sel");
                    let next = node.nextElementSibling;
                    if (next) {
                        next.style.display = "block";
                    }
                }
            });
        },

        expandNode: function (node) {
            this.el.querySelectorAll(".clicked").forEach((item) => {
                item.classList.remove("clicked");
            });

            this.el.querySelectorAll(".sel").forEach((item) => {
                item.classList.remove("sel");
            });

            this.el.querySelectorAll(".open.expand.cursel").forEach((item) => {
                item.classList.remove("open", "expand", "cursel");
                item.classList.add("close", "collapse");
            });

            this.el.querySelectorAll(".tm-ul-wrap").forEach((item) => {
                item.style.display = "none";
            });

            expand(node);
        },
    };

    function expand(node) {
        if (node.classList.contains("noExpand")) {
            node.classList.add("clicked");
            node.parentNode.classList.add("clicked");
        }

        var tmWrap = node.closest(".tm-ul-wrap");
        if(!tmWrap){
            return;
        }
        tmWrap.style.display = "block";
        var a = tmWrap.previousElementSibling;
        a.classList.remove("close", "collapse");
        a.classList.add("open", "expand", "cursel");
        var li = a.parentNode;
        li.classList.add("sel");
        if (!li.classList.contains("top-level")) {
            expand(tmWrap.previousElementSibling);
        }
    }

    function doInitDataSource(data) {
        if (data.children) {
            data.isParent = true;
            this.initDataSource(data.children, data);
        }
    }

    //options.__proto__ = YIUI.MainTree.prototype;
    options.init();

    return options;
}

function closeSiblingsMenu(elm) {
    let parent = elm.parentNode;
    let parentSiblings = elmUtils.siblings(parent);
    let wraps = [];

    parentSiblings.forEach((item) => {
        let openNodes = item.querySelectorAll(".open.expand");
        openNodes.forEach((node) => {
            node.classList.remove("open", "expand", "cursel");
            node.classList.add("close", "collapse");
            let next = node.nextElementSibling;
            if (next) {
                wraps.push(next);
            }
        });
    });

    wraps.forEach((node) => {
        if (isSm()) {
            node.style.display = "none";
        } else {
            elmUtils.slideUp(node);
        }
    });
}

function isNeedHelpBtn() {
    if (
        window.YigoClassicUxSetting &&
        window.YigoClassicUxSetting.clientParameters &&
        window.YigoClassicUxSetting.clientParameters
            .menuHelpFormula
    ) {
        return true;
    }
    return false;
}

function isSm() {
    var mainLeft = document.querySelector(".mainLeft");
    return mainLeft.classList.contains("mainLeft-sm");
}

function close($dom) {
    let wrap = $dom.closest(".tm-ul-wrap");
    wrap.style.display = "none";
    let prev = wrap.previousElementSibling;
    prev.classList.remove("open", "expand", "cursel");
    prev.classList.add("close", "collapse");
}

function bindScrollHandler() {
    document.querySelectorAll(".tm-ul").forEach((node) => {
        node.addEventListener("scroll", function () {
            if (!isSm()) {
                return;
            }
            var items = this.querySelectorAll(".tm-anchor.open.expand");
            items.forEach((item) => {
                item.classList.remove("open", "expand");
                item.classList.add("close", "collapse");
            });

            this.querySelectorAll(".tm-ul-wrap").forEach((item) => {
                item.style.display = "none";
            });
        });
    });
}


