import { R as Request, C as CompBuilder, a as ControlType, L as LoadingUtil, S as StringUtil$1, F as FormStack, b as LRUCache, D as DataUtil, c as ServletURL, M as MetaFormProcess, d as MetaForm, e as FormDependProvider, U as UIScopeTrees, f as ComboBox$1, g as checkCompState, h as ComboBoxBuilder, i as DesignModeSetting, j as FormRender, B as BasePanel, T as TypeConvertor, V as ViewContext, k as SizeUtil, P as PanelBuilder, l as Utils, G as GridLayoutPanelBuilder, m as MetaService, I as I18N$1, O as OperationState, n as FormEvent, o as MainUIOptTracer, p as FormBuilder, q as LayoutType, r as FormParasUtil, s as ColorPickerDialog, t as ComboBoxHandler, u as checkParamNum, v as COMPONENT_NOT_EXISTS, w as TreeType, x as FormUIStatusMask, y as FormType, z as DataFun, A as UIFun, E as OptFun, H as ShowData, J as SystemField, K as DataType, N as MetaCache, Q as IndexedDBCache$1, W as FormTarget, X as DocService, Y as FormFactory, Z as OptQueue, _ as NewOpt, $ as YesJSONUtil, a0 as FormDepend, a1 as CssUtil, a2 as TextEditor$1, a3 as FuncMap, a4 as BPMKeys, a5 as BPMConstants, a6 as HashMap, a7 as DocCache, a8 as DialogType, a9 as ConfirmPanelSetting, aa as DialogFactory, ab as extend, ac as TabPanelHandler, ad as SelectHandler, ae as ImageSourceType, af as ExceptionStack, ag as BaseComponent, ah as Grid, ai as RadioButton } from "./yes-core-73b995f9.js";
import { j as jsonview } from "./vendor-dcacb77b.js";
import { C as ControlMapping, Y as YElement, h, a as YesGridBuilder, V as VAutoLayout, b as YesComponentBuilder, c as VGridLayout, d as YesGridPanelBuilder, T as Tabs, e as YesVBaseComponent, f as YesVImage } from "./yes-ui-29852ed4.js";
import { F as FormExt } from "./erp-yes-core-25f33c37.js";
import { Y as YesVGridExt, a as YesGridBuilderExt } from "./erp-yes-ui-4313cb43.js";
var EDesignMode = /* @__PURE__ */ ((EDesignMode2) => {
  EDesignMode2["User"] = "User";
  EDesignMode2["Dev"] = "Dev";
  EDesignMode2["Local"] = "Local";
  return EDesignMode2;
})(EDesignMode || {});
var XMLElementType = /* @__PURE__ */ ((XMLElementType2) => {
  XMLElementType2["CDATA"] = "CDATA";
  XMLElementType2["COLLECTION"] = "Collection";
  XMLElementType2["ATTRIBUTE"] = "Attribute";
  return XMLElementType2;
})(XMLElementType || {});
var ESizeType = /* @__PURE__ */ ((ESizeType2) => {
  ESizeType2["none"] = "none";
  ESizeType2["px"] = "px";
  ESizeType2["vh"] = "vh";
  ESizeType2["mm"] = "mm";
  ESizeType2["em"] = "em";
  ESizeType2["Percent"] = "Percent";
  ESizeType2["Auto"] = "auto";
  ESizeType2["Pre"] = "Pre";
  ESizeType2["Scale"] = "Scale";
  ESizeType2["FlexScale"] = "FlexScale";
  return ESizeType2;
})(ESizeType || {});
var ELayoutDirection = /* @__PURE__ */ ((ELayoutDirection2) => {
  ELayoutDirection2["None"] = "";
  ELayoutDirection2["Row"] = "row";
  ELayoutDirection2["Column"] = "column";
  return ELayoutDirection2;
})(ELayoutDirection || {});
var ENodeType = /* @__PURE__ */ ((ENodeType2) => {
  ENodeType2["ROOT"] = "root";
  ENodeType2["HEAD"] = "head";
  ENodeType2["COMMENT"] = "comment";
  ENodeType2["CDATA"] = "cdata";
  ENodeType2["TAG"] = "tag";
  ENodeType2["TEXT"] = "text";
  ENodeType2["EMPTY"] = "empty";
  return ENodeType2;
})(ENodeType || {});
var ETokenType = /* @__PURE__ */ ((ETokenType2) => {
  ETokenType2[ETokenType2["LAB"] = 0] = "LAB";
  ETokenType2[ETokenType2["LABS"] = 1] = "LABS";
  ETokenType2[ETokenType2["HEAD_START"] = 2] = "HEAD_START";
  ETokenType2[ETokenType2["RAB"] = 3] = "RAB";
  ETokenType2[ETokenType2["HEAD_END"] = 4] = "HEAD_END";
  ETokenType2[ETokenType2["SRAB"] = 5] = "SRAB";
  ETokenType2[ETokenType2["TEXT"] = 6] = "TEXT";
  ETokenType2[ETokenType2["STRING"] = 7] = "STRING";
  ETokenType2[ETokenType2["EQ"] = 8] = "EQ";
  ETokenType2[ETokenType2["COMMENT_START"] = 9] = "COMMENT_START";
  ETokenType2[ETokenType2["COMMENT_END"] = 10] = "COMMENT_END";
  ETokenType2[ETokenType2["CDATA_START"] = 11] = "CDATA_START";
  ETokenType2[ETokenType2["CDATA_END"] = 12] = "CDATA_END";
  ETokenType2[ETokenType2["ERROR"] = 13] = "ERROR";
  return ETokenType2;
})(ETokenType || {});
var EExtraLayoutType = /* @__PURE__ */ ((EExtraLayoutType2) => {
  EExtraLayoutType2["Collapsible"] = "Collapsible";
  EExtraLayoutType2["Property"] = "Property";
  return EExtraLayoutType2;
})(EExtraLayoutType || {});
var EHandleType = /* @__PURE__ */ ((EHandleType2) => {
  EHandleType2["Custom"] = "Custom";
  EHandleType2["Switch"] = "Switch";
  EHandleType2["UpDown"] = "UpDown";
  EHandleType2["SubAdd"] = "SubAdd";
  return EHandleType2;
})(EHandleType || {});
var EHAlign = /* @__PURE__ */ ((EHAlign2) => {
  EHAlign2["Left"] = "Left";
  EHAlign2["Center"] = "Center";
  EHAlign2["Right"] = "Right";
  return EHAlign2;
})(EHAlign || {});
var EVAlign = /* @__PURE__ */ ((EVAlign2) => {
  EVAlign2["Top"] = "Top";
  EVAlign2["Center"] = "Center";
  EVAlign2["Bottom"] = "Bottom";
  return EVAlign2;
})(EVAlign || {});
var EUnderLineStyle = /* @__PURE__ */ ((EUnderLineStyle2) => {
  EUnderLineStyle2["None"] = "None";
  EUnderLineStyle2["SolidNormal"] = "SolidNormal";
  EUnderLineStyle2["Dashed"] = "Dashed";
  EUnderLineStyle2["SolidBold"] = "SolidBold";
  return EUnderLineStyle2;
})(EUnderLineStyle || {});
var ETreeNodeType = /* @__PURE__ */ ((ETreeNodeType2) => {
  ETreeNodeType2[ETreeNodeType2["Branch"] = 0] = "Branch";
  ETreeNodeType2[ETreeNodeType2["Leaf"] = 1] = "Leaf";
  return ETreeNodeType2;
})(ETreeNodeType || {});
var EToggleStatus = /* @__PURE__ */ ((EToggleStatus2) => {
  EToggleStatus2[EToggleStatus2["Collapase"] = 0] = "Collapase";
  EToggleStatus2[EToggleStatus2["Expand"] = 1] = "Expand";
  return EToggleStatus2;
})(EToggleStatus || {});
const _GlobalSetting = class _GlobalSetting2 {
  static initMMPX(value2) {
    if (value2 <= 0) {
      let div = document.createElement("div");
      div.style.width = "1mm";
      document.body.appendChild(div);
      let mm1 = div.getBoundingClientRect();
      _GlobalSetting2.MM_PX = mm1.width;
      document.body.removeChild(div);
    }
    _GlobalSetting2.MM_PX = value2;
  }
  static checkMMPXSetting() {
    if (_GlobalSetting2.MM_PX <= 0) {
      let div = document.createElement("div");
      div.style.width = "1mm";
      document.body.appendChild(div);
      let mm1 = div.getBoundingClientRect();
      _GlobalSetting2.MM_PX = mm1.width;
      document.body.removeChild(div);
    }
  }
};
_GlobalSetting.D_TOOLBAR_HEIGHT = 30;
_GlobalSetting.META_A4_WIDTH = 595;
_GlobalSetting.META_A4_HEIGHT = 842;
_GlobalSetting.MM_PX = -1;
_GlobalSetting.PPI = 72;
let GlobalSetting = _GlobalSetting;
class TypeUtil {
  static toBoolean(value) {
    if (value == void 0)
      return false;
    if (typeof value == "string") {
      if ("true".toLowerCase() == value) {
        return true;
      } else if ("false".toLowerCase() == value) {
        return false;
      }
      return eval(value.toLowerCase());
    } else {
      return Boolean(value);
    }
  }
  static toNum(value2) {
    return Number(value2);
  }
  static isNum(obj) {
    return typeof obj === "number";
  }
  static isStr(obj) {
    return typeof obj === "string";
  }
  static isEmptyObject(obj) {
    if (obj == void 0 || obj == null)
      return true;
    var name;
    for (name in obj) {
      return false;
    }
    return true;
  }
  static getReal(value2, parentValue) {
    if (!TypeUtil.isDefined(value2) || value2 == null || value2 <= 0)
      return "auto";
    var real;
    if (TypeUtil.isNumeric(value2) && value2 > 1) {
      real = value2;
    } else if (TypeUtil.isNumeric(value2) && value2 <= 1 && parentValue) {
      var percent = parseFloat(value2);
      real = parentValue * percent;
    } else if (TypeUtil.isPercentage(value2) && parentValue) {
      var percent = parseFloat(value2) / 100;
      real = parentValue * percent;
    } else {
      real = parseInt(value2, 10);
    }
    return Math.floor(real);
  }
  static isDefined(v) {
    return v != void 0;
  }
  static isPercentage(v) {
    return v && /^(\d{1,2}%)$|^(100%)$/.test(v);
  }
  /**
   * 按jquery 3.1中的逻辑实现isNumeric方法
   * @param obj 
   * @returns 
   */
  static isNumeric(obj) {
    if (TypeUtil.isNum(obj)) {
      return true;
    }
    if (TypeUtil.isStr(obj) && !isNaN(obj - parseFloat(obj))) {
      return true;
    }
    return false;
  }
}
const _SizeInfo = class _SizeInfo2 {
  constructor(value2, type) {
    this.value = value2;
    this.type = type;
  }
  getValue() {
    return this.value;
  }
  getType() {
    return this.type;
  }
  toString() {
    switch (this.type) {
      case ESizeType.none:
        return "";
      case ESizeType.mm:
        return this.value + "mm";
      case ESizeType.Scale:
        return this.value.toString();
      case ESizeType.px:
        return this.value + "px";
      case ESizeType.vh:
        return this.value + "vh";
      case ESizeType.Percent:
        return this.value + "%";
      case ESizeType.Auto:
        return ESizeType.Auto;
      default:
        return this.value + this.type.toString();
    }
  }
  toStyleString(item) {
    if (ESizeType.FlexScale == this.type) {
      return "flex:" + this.value;
    }
    return item + ":" + this.value + this.type.toString();
  }
  static valueOf(value2, type) {
    if (type) {
      return new _SizeInfo2(value2, type);
    } else {
      return new _SizeInfo2(value2.value, value2.type);
    }
  }
  static valueOfPX(value2) {
    return new _SizeInfo2(value2, ESizeType.px);
  }
  static valueOfMM(value2) {
    return new _SizeInfo2(value2, ESizeType.mm);
  }
  static valueOfPercent(value2) {
    return new _SizeInfo2(value2, ESizeType.Percent);
  }
  static isFixSize(size) {
    return size.getType() == ESizeType.px;
  }
  static isPercentSize(size) {
    return size.getType() == ESizeType.Percent;
  }
  static mm2Px(mm) {
    GlobalSetting.checkMMPXSetting();
    return mm * GlobalSetting.MM_PX;
  }
  static getDPIRatio(WIDTH, MM) {
    return WIDTH / _SizeInfo2.mm2Px(MM);
  }
  /**
   * 将px类型的尺寸字符，转成数值
   * @param strValue 
   * @returns 
   */
  static getNumFromPX(strValue) {
    if (typeof strValue === "number")
      return strValue;
    if (!strValue)
      return 0;
    if (strValue.toLowerCase().endsWith("px")) {
      return TypeUtil.toNum(strValue.replace("px", ""));
    } else {
      return TypeUtil.toNum(strValue);
    }
  }
};
_SizeInfo.AUTO_SIZE = new _SizeInfo(0, ESizeType.Auto);
_SizeInfo.PX2 = new _SizeInfo(2, ESizeType.px);
_SizeInfo.PX5 = new _SizeInfo(5, ESizeType.px);
_SizeInfo.PX30 = new _SizeInfo(30, ESizeType.px);
_SizeInfo.PX200 = new _SizeInfo(200, ESizeType.px);
_SizeInfo.PERCENT100 = new _SizeInfo(100, ESizeType.Percent);
_SizeInfo.VH100 = new _SizeInfo(100, ESizeType.vh);
_SizeInfo.FLEXSCALE1 = new _SizeInfo(1, ESizeType.FlexScale);
_SizeInfo.NONE = new _SizeInfo(-1, ESizeType.none);
let SizeInfo = _SizeInfo;
class WfConstants {
  //<TimerItem ="155" Key="timer1" Peroid="88" Repeat="true" Trigger="2354"/>
}
WfConstants.NODE_Process = "Process";
WfConstants.C_Process = "流程";
WfConstants.NODE_Hand = "Hand";
WfConstants.C_Hand = "指针";
WfConstants.NODE_Flow_Sequence = "SequenceFlow";
WfConstants.C_Flow_Sequence = "顺序流";
WfConstants.NODE_Flow_Deny = "DenyFlow";
WfConstants.C_Flow_Deny = "驳回流";
WfConstants.NODE_Flow_Association = "Association";
WfConstants.C_Flow_Association = "关联线";
WfConstants.NODE_Flow_Exception = "ExceptionFlow";
WfConstants.C_Flow_Exception = "异常流";
WfConstants.NODE_Event_Begin = "Begin";
WfConstants.C_Event_Begin = "起始节点";
WfConstants.NODE_Event_BranchEnd = "BranchEnd";
WfConstants.C_Event_BranchEnd = "分支结束";
WfConstants.NODE_Event_End = "End";
WfConstants.C_Event_End = "结束节点";
WfConstants.NODE_Event_State = "State";
WfConstants.C_Event_State = "状态节点";
WfConstants.NODE_Task = "Task";
WfConstants.C_Task = "任务";
WfConstants.NODE_Task_Audit = "Audit";
WfConstants.C_Task_Audit = "审批任务";
WfConstants.U_Task_Audit = "&#xe656;";
WfConstants.NODE_Task_Service = "ServiceTask";
WfConstants.C_Task_Service = "系统任务";
WfConstants.U_Task_Service = "&#xe609;";
WfConstants.NODE_Task_Manual = "ManualTask";
WfConstants.C_Task_Manual = "人工任务";
WfConstants.U_Task_Manual = "&#xe923;";
WfConstants.NODE_Task_User = "UserTask";
WfConstants.C_Task_User = "用户任务";
WfConstants.U_Task_User = "&#xe7f1;";
WfConstants.NODE_Task_DataMap = "DataMap";
WfConstants.C_Task_DataMap = "映射任务";
WfConstants.U_Task_DataMap = "&#xe6bd;";
WfConstants.NODE_Task_CounterSign = "Countersign";
WfConstants.C_Task_CounterSign = "会签任务";
WfConstants.U_Task_CounterSign = "&#xe604;";
WfConstants.NODE_Task_MultiUser = "MultiUserTask";
WfConstants.C_Task_MultiUser = "多人任务";
WfConstants.U_Task_MultiUser = "&#xe61b;";
WfConstants.NODE_Task_MultiAudit = "MultiAudit";
WfConstants.C_Task_MultiAudit = "多人审批";
WfConstants.U_Task_MultiAudit = "&#xe602;";
WfConstants.NODE_Task_StateAction = "StateAction";
WfConstants.C_Task_StateAction = "状态机";
WfConstants.U_Task_StateAction = "&#xe603;";
WfConstants.NODE_Gateway = "GateWay#";
WfConstants.C_Gateway = "网关";
WfConstants.NODE_Gateway_GateWay = "GateWay";
WfConstants.C_Gateway_GateWay = "路由";
WfConstants.NODE_Gateway_Decision = "Decision";
WfConstants.C_Gateway_Decision = "选择网关";
WfConstants.NODE_Gateway_Join = "Join";
WfConstants.C_Gateway_Join = "合并网关";
WfConstants.NODE_Gateway_Fork = "Fork";
WfConstants.C_Gateway_Fork = "分支网关";
WfConstants.NODE_Gateway_ExclusiveFork = "ExclusiveFork";
WfConstants.C_Gateway_ExclusiveFork = "互斥网关";
WfConstants.NODE_Gateway_ComplexJoin = "ComplexJoin";
WfConstants.C_Gateway_ComplexJoin = "复合网关";
WfConstants.NODE_SubProcess = "SubProcess";
WfConstants.C_SubProcess = "子流程";
WfConstants.U_SubProcess = "&#xe601;";
WfConstants.NODE_Inline = "Inline";
WfConstants.C_Inline = "内联流程";
WfConstants.U_Inline = "&#xe7b6;";
WfConstants.C_Remove = "删除";
WfConstants.NODE_Operation = "Operation";
WfConstants.NODE_NodeGraphic = "NodeGraphic";
WfConstants.NODE_TransitionGraphic = "TransitionGraphic";
WfConstants.NODE_Action = "Action";
WfConstants.NODE_PermCollection = "PermCollection";
WfConstants.NODE_Perm = "Perm";
WfConstants.NODE_OptPerm = "OptPerm";
WfConstants.NODE_OptPermItem = "OptPermItem";
WfConstants.NODE_VisiblePerm = "VisiblePerm";
WfConstants.NODE_VisiblePermItem = "VisiblePermItem";
WfConstants.NODE_EnablePerm = "EnablePerm";
WfConstants.NODE_EnablePermItem = "EnablePermItem";
WfConstants.NODE_DMTable = "DMTable";
WfConstants.NODE_DataSource = "DataSource";
WfConstants.NODE_Table = "Table";
WfConstants.NODE_Field = "Field";
WfConstants.NODE_Dictionary = "Dictionary";
WfConstants.NODE_RowGroup = "RowGroup";
WfConstants.NODE_ColumnExpand = "ColumnExpand";
WfConstants.NODE_Display = "Display";
WfConstants.NODE_Format = "Format";
WfConstants.NODE_Font = "Font";
WfConstants.NODE_ImageStyle = "ImageStyle";
WfConstants.NODE_Query = "Query";
WfConstants.NODE_MidFormula = "MidFormula";
WfConstants.NODE_QueryParameterCollection = "QueryParameterCollection";
WfConstants.NODE_QueryParameter = "QueryParameter";
WfConstants.NODE_TransitionCollection = "TransitionCollection";
WfConstants.NODE_OperationCollection = "OperationCollection";
WfConstants.NODE_AssistanceCollection = "AssistanceCollection";
WfConstants.NODE_ParticipatorCollection = "ParticipatorCollection";
WfConstants.NODE_TimerItemCollection = "TimerItemCollection";
WfConstants.ATTR_X = "X";
WfConstants.ATTR_Y = "Y";
WfConstants.ATTR_Width = "Width";
WfConstants.ATTR_Height = "Height";
WfConstants.ATTR_TargetNodeKey = "TargetNodeKey";
WfConstants.ATTR_DenyToLastNode = "DenyToLastNode";
WfConstants.ATTR_DenyNodeKey = "DenyNodeKey";
WfConstants.ATTR_SourceFieldKey = "SourceFieldKey";
WfConstants.ATTR_Type = "Type";
WfConstants.ATTR_ConstValue = "ConstValue";
WfConstants.ATTR_CycleInterval = "CycleInterval";
WfConstants.ATTR_Peroid = "Peroid";
WfConstants.ATTR_Repeat = "Repeat";
WfConstants.ATTR_Trigger = "Trigger";
class AbstractPropertyDefine {
  constructor(propertyMananger) {
    this.properyManager = propertyMananger;
  }
  createNodeDefine(nodeDefine) {
    var groups = [];
    if (!nodeDefine)
      return groups;
    for (let propertyDefine of nodeDefine.getProperties()) {
      var item = this.createPropertyItem(nodeDefine.getKey(), propertyDefine);
      var group = this.ensurePropertyGroup(item.group ? item.group : nodeDefine.getCaption(), groups);
      group.properties.push(item);
    }
    return groups;
  }
  ensurePropertyGroup(groupCaption, groups) {
    for (let group of groups) {
      if (group.caption == groupCaption) {
        return group;
      }
    }
    var newGroup = {
      key: groupCaption,
      caption: groupCaption,
      expanded: true,
      properties: []
    };
    groups.push(newGroup);
    return newGroup;
  }
  createPropertyItem(tag, propertyDefine) {
    return {
      tag,
      key: propertyDefine.getKey(),
      caption: propertyDefine.getCaption(),
      textAttributeKey: propertyDefine.getTextAttributeKey(),
      updateAttributeOnly: propertyDefine.isUpdateAttributeOnly(),
      control: propertyDefine.getControlType(),
      type: propertyDefine.getXmlElementType(),
      node: propertyDefine.getNode(),
      onbuttonclick: propertyDefine.getOnButtonClick(),
      oninitialize: propertyDefine.getOnInitialize(),
      onvaluechanged: propertyDefine.getOnValueChanged(),
      group: propertyDefine.getGroup(),
      defaultvalue: propertyDefine.getDefaultValue(),
      editable: propertyDefine.getEditable(),
      visible: propertyDefine.getVisible()
    };
  }
  merge(baseGroups, mergeGroup) {
    for (let merge of mergeGroup) {
      var group = this.ensurePropertyGroup(merge.caption, baseGroups);
      for (let item of merge.properties) {
        group.properties.push(item);
      }
    }
  }
  getPropertyDefines(type) {
    var nodeDefine = this.properyManager.getNodeDefine(type);
    if (!nodeDefine)
      return [];
    var extend2 = nodeDefine.getExtend();
    if (extend2) {
      var extendGroup = this.getPropertyDefines(extend2);
      var curGroup = this.createNodeDefine(nodeDefine);
      this.merge(extendGroup, curGroup);
      return extendGroup;
    } else {
      return this.createNodeDefine(nodeDefine);
    }
  }
  getPropertyDefinesByTypes(types) {
    var all = [];
    for (let type of types) {
      var groups = this.getPropertyDefines(type);
      this.merge(all, groups);
    }
    return all;
  }
}
class NodeDefine {
  constructor(key2, caption = "", extend2 = "") {
    this.properties = [];
    this.key = key2;
    this.caption = caption;
    this.extend = extend2;
  }
  getKey() {
    return this.key;
  }
  getCaption() {
    return this.caption;
  }
  getExtend() {
    return this.extend;
  }
  addProperty(propertyDefine) {
    this.properties.push(propertyDefine);
  }
  getProperties() {
    return this.properties;
  }
}
var EComponentType = /* @__PURE__ */ ((EComponentType2) => {
  EComponentType2["Hyperlink"] = "Hyperlink";
  EComponentType2["TextEditor"] = "TextEditor";
  EComponentType2["NumberEditor"] = "NumberEditor";
  EComponentType2["ButtonEditor"] = "ButtonEditor";
  EComponentType2["TempButtonEditor"] = "TempButtonEditor";
  EComponentType2["ColorEditor"] = "ColorEditor";
  EComponentType2["DefSizeEditor"] = "DefSizeEditor";
  EComponentType2["PxDefSizeEditor"] = "PxDefSizeEditor";
  EComponentType2["Label"] = "Label";
  EComponentType2["Button"] = "Button";
  EComponentType2["SVGIcon"] = "SVGIcon";
  EComponentType2["Checkbox"] = "Checkbox";
  EComponentType2["Switch"] = "Switch";
  EComponentType2["UpDown"] = "UpDown";
  EComponentType2["SubAdd"] = "SubAdd";
  EComponentType2["DataMapTextEditor"] = "DataMapTextEditor";
  EComponentType2["Combobox"] = "Combobox";
  EComponentType2["ComboBoxEditor"] = "ComboBoxEditor";
  EComponentType2["Tree"] = "Tree";
  EComponentType2["Toolbar"] = "Toolbar";
  EComponentType2["TabPanel"] = "TabPanel";
  EComponentType2["Panel"] = "Panel";
  EComponentType2["YigoControl"] = "YigoControl";
  EComponentType2["YigoDict"] = "YigoDict";
  EComponentType2["YigoCodeDict"] = "YigoCodeDict";
  return EComponentType2;
})(EComponentType || {});
class PropertyDefine {
  constructor(key2, control = EComponentType.TextEditor) {
    this.caption = "";
    this.onbuttonclick = "";
    this.editable = "true";
    this.visible = "true";
    this.oninitialize = "";
    this.onvaluechanged = "";
    this.defaultValue = "";
    this.group = "";
    this.node = "";
    this.textAttributeKey = "";
    this.bUpdateAttributeOnly = false;
    this.elementType = XMLElementType.ATTRIBUTE;
    this.key = key2;
    this.control = control;
  }
  getKey() {
    return this.key;
  }
  setCaption(caption) {
    this.caption = caption;
  }
  getCaption() {
    return this.caption;
  }
  setXmlElementType(elementType) {
    if (elementType) {
      this.elementType = elementType;
    }
  }
  getXmlElementType() {
    return this.elementType;
  }
  setNode(node) {
    this.node = node;
  }
  getNode() {
    return this.node;
  }
  setControlType(control) {
    this.control = control;
  }
  getControlType() {
    return this.control;
  }
  setUpdateAttributeOnly(bUpdateAttributeOnly) {
    this.bUpdateAttributeOnly = bUpdateAttributeOnly;
  }
  isUpdateAttributeOnly() {
    return this.bUpdateAttributeOnly;
  }
  getTextAttributeKey() {
    return this.textAttributeKey;
  }
  setTextAttributeKey(textAttributeKey) {
    this.textAttributeKey = textAttributeKey;
  }
  setOnButtonClick(event) {
    this.onbuttonclick = event;
  }
  getOnButtonClick() {
    return this.onbuttonclick;
  }
  setEditable(editable) {
    this.editable = editable;
  }
  getEditable() {
    return this.editable;
  }
  setVisible(visible) {
    this.visible = visible;
  }
  getVisible() {
    return this.visible;
  }
  setDefaultValue(defaultValue) {
    this.defaultValue = defaultValue;
  }
  getDefaultValue() {
    return this.defaultValue;
  }
  setOnInitialize(oninitialize) {
    this.oninitialize = oninitialize;
  }
  getOnInitialize() {
    return this.oninitialize;
  }
  setOnValueChanged(onvaluechanged) {
    this.onvaluechanged = onvaluechanged;
  }
  getOnValueChanged() {
    return this.onvaluechanged;
  }
  setGroup(group) {
    this.group = group;
  }
  getGroup() {
    return this.group;
  }
}
class GlobalConstants {
  static getFormulaCodeAttrKey(key2) {
    return `${key2}__Code`;
  }
}
GlobalConstants.SP_KEY = "@";
GlobalConstants.EMPTY_XML = "<?xml version='1.0' encoding='UTF-8' standalone='no'?>";
GlobalConstants.XML_WF_DEFAULT = `<?xml version="1.0" encoding="UTF-8" standalone="no"?>
                                                <Process>
                                                    <Begin ID="1" Key="Begin" Caption="起始">
                                                        <NodeGraphic X="303" Y="131"/>
                                                        <TransitionCollection>
                                                        <SequenceFlow ID="3" Key="SequenceFlow" Caption="顺序流" TargetNodeKey="End"/>
                                                        </TransitionCollection>
                                                    </Begin>
                                                    <End ID="2" Key="End" Caption="结束">
                                                        <NodeGraphic X="303" Y="597"/>
                                                    </End>
                                                </Process>`;
GlobalConstants.S_ID = "ID";
GlobalConstants.S_Key = "Key";
GlobalConstants.S_Caption = "Caption";
GlobalConstants.S_Control = "Control";
GlobalConstants.S_Extends = "Extends";
GlobalConstants.S_Condition = "Condition";
GlobalConstants.S_ShowText = "ShowText";
GlobalConstants.S_Editable = "Editable";
GlobalConstants.S_Visible = "Visible";
GlobalConstants.S_DefaultValue = "DefaultValue";
GlobalConstants.S_Group = "Group";
GlobalConstants.S_Node = "Node";
GlobalConstants.S_Type = "Type";
GlobalConstants.S_TextAttributeKey = "TextAttributeKey";
GlobalConstants.S_OnButtonClick = "OnButtonClick";
GlobalConstants.S_OnInitialize = "OnInitialize";
GlobalConstants.S_OnValueChanged = "OnValueChanged";
GlobalConstants.S_UpdateAttributeOnly = "UpdateAttributeOnly";
GlobalConstants.S_IsUserDefine = "IsUserDefine";
GlobalConstants.S_FormKey = "FormKey";
GlobalConstants.S_Operator = "Operator";
GlobalConstants.S_Role = "Role";
GlobalConstants.S_Participator = "Participator";
GlobalConstants.S_Operation = "Operation";
GlobalConstants.S_Action = "Action";
GlobalConstants.S_Dictionary = "Dictionary";
GlobalConstants.S_MidFormula = "MidFormula";
GlobalConstants.S_Query = "Query";
GlobalConstants.S_QueryParameterCollection = "QueryParameterCollection";
GlobalConstants.S_Version = "Version";
GlobalConstants.S_ItemKey = "ItemKey";
GlobalConstants.S_ItemID = "ItemID";
GlobalConstants.S_Code = "Code";
GlobalConstants.S_ContentNode = "conentnode";
GlobalConstants.S_Attributes = "attributes";
GlobalConstants.S_ChildNodes = "childnodes";
GlobalConstants.S_TRUE = "true";
GlobalConstants.S_FALSE = "false";
GlobalConstants.ICON_SWICH_ON = "icon-switch-on";
GlobalConstants.ICON_SWICH_OFF = "icon-switch-off";
GlobalConstants.ICON_COLLAPSE_ARROWUP = "icon-collapse_arrowup";
GlobalConstants.ICON_COLLAPSE_ARROWDOWN = "icon-collapse_arrowdown";
class ArrayList {
  constructor() {
    this.items = [];
  }
  add(item) {
    this.items.push(item);
  }
  get(index) {
    if (index < 0 || index > this.items.length - 1) {
      throw new Error(index + " out range:" + this.items.length);
    }
    return this.items[index];
  }
  clearAll() {
    this.items = [];
  }
  contain(item) {
    return this.items.indexOf(item) > -1;
  }
  getList() {
    return this.items;
  }
  /**
   * 返回删除元素所在位置
   * @param item 
   */
  remove(item) {
    var index = this.items.indexOf(item);
    if (index >= 0) {
      this.items.splice(index, 1);
    }
    return index;
  }
  removeByIndex(index) {
    this.items.splice(index, 1);
  }
  getSize() {
    return this.items.length;
  }
}
class CmdQueue {
  constructor() {
    this.cmds = new ArrayList();
    this.curIndex = -1;
  }
  doCmd(cmd) {
    this.removeAfterCurrent();
    if (cmd.do()) {
      this.cmds.add(cmd);
      this.curIndex++;
    }
  }
  removeAfterCurrent() {
    for (var i = this.cmds.getSize() - 1; i > this.curIndex; i--) {
      this.cmds.removeByIndex(i);
    }
  }
  undoCmd() {
    if (this.curIndex >= 0) {
      var cmd = this.cmds.get(this.curIndex);
      cmd.undo();
      this.curIndex--;
    }
  }
  redoCmd() {
    if (this.cmds.getSize() == 0) {
      return;
    }
    if (this.curIndex < this.cmds.getSize() - 1) {
      this.curIndex++;
      var cmd = this.cmds.get(this.curIndex);
      cmd.do();
    }
  }
  clear() {
    this.cmds.clearAll();
    this.curIndex = -1;
  }
}
class ActionNames {
}
ActionNames.model_node_add = "model/node/add";
ActionNames.model_node_remove = "model/node/remove";
ActionNames.model_node_update = "model/node/update";
ActionNames.model_node_update_select = "model/node/update/select";
ActionNames.model_node_properties_commit = "model/node/properties/commit";
ActionNames.model_node_update_multi_select = "model/node/update/multiSelect";
class SelectionModel {
  constructor(xmlEntity) {
    this.bMultiSelection = false;
    this.selectItems = new ArrayList();
    this.xmlEntity = xmlEntity;
  }
  reset() {
    this.xmlEntity.unSelectAll();
    this.selectItems.clearAll();
  }
  setBMultiSelection(bMultiSelection) {
    this.bMultiSelection = bMultiSelection;
  }
  getBMultiSelection() {
    return this.bMultiSelection;
  }
  unMultiSelection() {
    for (let i = 0; i < this.selectItems.getList().length; i++) {
      var item = this.selectItems.getList()[i];
      if (item) {
        this.xmlEntity.unselect(item);
      }
    }
    this.selectItems.clearAll();
  }
  select(item) {
    if (!item) {
      this.reset();
    }
    if (!this.bMultiSelection) {
      this.reset();
    }
    item && this.selectItems.add(item);
    this.xmlEntity.select(item);
  }
  selectRoot() {
    this.select(this.xmlEntity.getTagRoot());
  }
  unselect(item) {
    this.xmlEntity.unselect(item);
    this.selectItems.remove(item);
  }
  hasSelected(item) {
    return this.selectItems.contain(item);
  }
  getSelectionItems() {
    return this.selectItems.getList();
  }
  doCacheItems() {
    var items = [];
    for (let item of this.getSelectionItems()) {
      items.push(item);
    }
    return items;
  }
  doCacheTagNodes4Node() {
    var items = [];
    for (let item of this.getSelectionItems()) {
      items.push(item.getTagNode());
    }
    return items;
  }
  doCacheTagNodes() {
    var items = [];
    for (let item of this.getSelectionItems()) {
      items.push(item.getTagNode());
    }
    return items;
  }
  getSingleSeletionItem() {
    if (this.selectItems.getSize() == 0) {
      return void 0;
    }
    return this.selectItems.get(0);
  }
  /*
      addSelectionChangedListener(listener: ISelectionChangedListener): void{
          this.listeners.add(listener);
      }
  
      fireSelectionChanged(item?: ISelectable): void {
          for (let listener of this.listeners.getList()) {
              listener.changeSelection(item);
          }
      }*/
}
const _Paras = class _Paras2 {
  constructor() {
    this.map = /* @__PURE__ */ new Map();
  }
  add(key2, value2) {
    this.map.set(key2, value2);
    return this;
  }
  setElement(value2) {
    this.map.set(_Paras2.P_ELEMENT, value2);
    return this;
  }
  getElement() {
    return this.map.get(_Paras2.P_ELEMENT);
  }
  get(key2) {
    return this.map.get(key2);
  }
  static newInstance() {
    return new _Paras2();
  }
};
_Paras.P_ELEMENT = "element";
_Paras.P_UPDATE_ATTR_ONLY = "update_attr_only";
let Paras = _Paras;
const _StringUtil = class _StringUtil2 {
  static isBlank(c) {
    return c == " " || c == "	" || c == "\n" || c == "\r" || c.charCodeAt(0) == 65279;
  }
  static isBlankOrNull(str) {
    return !str;
  }
  static isContentEnd(char) {
    return char == _StringUtil2.CONTENT_END;
  }
  static isDigit(c) {
    return c >= "0" && c <= "9";
  }
  static isAlpha(c) {
    return c >= "a" && c <= "z" || c >= "A" && c <= "Z";
  }
  static split(s, sp) {
    if (!s)
      return [];
    return s.split(sp);
  }
};
_StringUtil.STR_INDENT_NBSP = "&nbsp;&nbsp;&nbsp;&nbsp;";
_StringUtil.STR_INDENT_SPACE = "    ";
_StringUtil.STR_HTML_SPACE = " ";
_StringUtil.STR_SPACE = " ";
_StringUtil.CONTENT_END = "$";
let StringUtil = _StringUtil;
class Var {
  constructor(data) {
    this.data = data;
  }
  getData() {
    return this.data;
  }
  setData(data) {
    this.data = data;
  }
}
class ErrorUtil {
  static throwError(msg) {
    throw new Error(msg);
  }
}
class StringBuilder {
  constructor() {
    this.arrStr = [];
  }
  append(char) {
    this.arrStr.push(char);
    return this;
  }
  appends(chars) {
    for (let char of chars) {
      this.append(char);
    }
    return this;
  }
  /**
   * 移除数组中某个位置的元素
   * @param index 
   * @returns 
   */
  deleteCharAt(index) {
    this.arrStr.splice(index, 1);
    return this;
  }
  /**
   * 移除单个末尾元素，这里移除的元素并非单个字符，而是单个 append 方法添加进来的字符串
   */
  deleteLastChar() {
    this.arrStr.pop();
    return this;
  }
  /**
   * 移除多个末尾元素，这里移除的元素并非单个字符，而是单个 append 方法添加进来的字符串
   */
  deleteLastChars(len) {
    for (var n = 0; n < len; n++) {
      this.arrStr.pop();
    }
    return this;
  }
  rollbackTo(index) {
    var curLastIndex = this.getLastIndex();
    if (curLastIndex <= index)
      return this;
    var len = curLastIndex - index;
    return this.deleteLastChars(len);
  }
  getLastIndex() {
    return this.getSize() - 1;
  }
  getSize() {
    return this.arrStr.length;
  }
  isEmpty() {
    return this.arrStr.length == 0;
  }
  toString() {
    return this.arrStr.join("");
  }
  toStringWithSep(sep) {
    return this.arrStr.join(sep);
  }
}
const _Token = class _Token2 {
  //private line: number;
  constructor(tokentype, value2 = "", line = -1) {
    this.tokentype = tokentype;
    this.value = value2;
  }
  getType() {
    return this.tokentype;
  }
  getValue() {
    return this.value;
  }
  getTokenString() {
    return "[" + this.tokentype + "," + this.value + "]";
  }
  toString() {
    return this.value;
  }
};
_Token.TK_COMMENT_START = new _Token(ETokenType.COMMENT_START, "<!--");
_Token.TK_EQ = new _Token(ETokenType.EQ, "=");
_Token.TK_HEAD_START = new _Token(ETokenType.HEAD_START, "<?xml");
_Token.TK_HEAD_END = new _Token(ETokenType.HEAD_END, "?>");
_Token.TK_CDATA_START = new _Token(ETokenType.CDATA_START, "<![CDATA[");
_Token.TK_LABS = new _Token(ETokenType.LABS, "</");
_Token.TK_LAB = new _Token(ETokenType.LAB, "<");
_Token.TK_SRAB = new _Token(ETokenType.SRAB, "/>");
_Token.TK_RAB = new _Token(ETokenType.RAB, ">");
_Token.TK_UNKNOW = new _Token(ETokenType.ERROR, "unknow");
_Token.TK_END = new _Token(ETokenType.ERROR, "end");
_Token.CHAR_CMT_POSTFIX = ["-", ">"];
_Token.CHAR_XML = ["x", "m", "l"];
let Token = _Token;
class XmlLexicalAnalysis {
  constructor(source) {
    this.posInLine = 0;
    this.line = 0;
    this.position = 0;
    this.totalSize = 0;
    this.list = [];
    this.posInLine = 0;
    this.position = 0;
    this.source = source;
    this.source = this.source + StringUtil.CONTENT_END;
    this.totalSize = this.source.length;
    this.curChar = source.charAt(0);
  }
  analysis() {
    while (this.position < this.totalSize) {
      this.calcToken();
      this.incNext();
    }
    return this.list;
  }
  setAnalysisListener(analysisListener) {
    this.analysisListener = analysisListener;
  }
  calcToken() {
    while (StringUtil.isBlank(this.curChar)) {
      this.analysisListener && this.analysisListener.fireSkipBlank(this.curChar);
      this.incNext();
    }
    if (StringUtil.isContentEnd(this.curChar)) {
      this.analysisListener && this.analysisListener.fireFinishedAnalysis();
      return;
    }
    switch (this.curChar) {
      case "<":
        let nextChar = this.incNext();
        if (nextChar == "?") {
          this.record(this.follows(Token.CHAR_XML, Token.TK_HEAD_START, Token.TK_UNKNOW));
        } else if (nextChar == "!") {
          var char1 = this.incNext();
          var char2 = this.incNext();
          if (char1 == "-" && char2 == "-") {
            this.record(Token.TK_COMMENT_START);
            this.record(this.comment());
          } else if (char1 == "[" && char2 == "C") {
            if (this.checkAndIncNextString("DATA[")) {
              this.record(Token.TK_CDATA_START);
              this.record(this.cdata());
            } else {
              XmlUtil.error(this.line, this.posInLine, "error on comment");
            }
          } else {
            XmlUtil.error(this.line, this.posInLine, "error on comment");
          }
        } else if (nextChar == "/") {
          this.record(Token.TK_LABS);
        } else {
          this.decPrevious();
          this.record(Token.TK_LAB);
        }
        break;
      case "?":
        this.record(this.follow(">", Token.TK_HEAD_END, Token.TK_UNKNOW));
        break;
      case "/":
        this.record(this.follow(">", Token.TK_SRAB, Token.TK_UNKNOW));
        break;
      case ">":
        this.record(Token.TK_RAB);
        break;
      case "=":
        this.record(Token.TK_EQ);
        break;
      case "'":
      case '"':
        this.record(this.string(this.curChar, this.line, this.posInLine));
        break;
      default:
        this.record(this.text());
        break;
    }
  }
  record(token) {
    if (token.getType() == ETokenType.ERROR) {
      throw new Error(token.getValue());
    }
    this.analysisListener && this.analysisListener.fireAppendedToken(token);
    this.list.push(token);
  }
  follows(expects, ifyes, ifno) {
    let bChecked = true;
    for (let expect of expects) {
      if (this.incNext() != expect) {
        bChecked = false;
        break;
      }
    }
    if (bChecked) {
      return ifyes;
    }
    return ifno;
  }
  follow(expect, ifyes, ifno) {
    if (this.incNext() == expect) {
      return ifyes;
    }
    return ifno;
  }
  string(start, line, pos) {
    let sb = new StringBuilder();
    while (this.incNext() != start) {
      if (this.curChar == "\0") {
        XmlUtil.error(line, pos, "EOF while scanning string literal");
      }
      if (this.curChar == "\n") {
        XmlUtil.error(line, pos, "EOL while scanning string literal");
      }
      sb.append(this.curChar);
    }
    return new Token(ETokenType.STRING, sb.toString(), this.line);
  }
  text() {
    let sb = new StringBuilder();
    while (StringUtil.isAlpha(this.curChar) || StringUtil.isDigit(this.curChar) || this.curChar == "_") {
      sb.append(this.curChar);
      this.incNext();
    }
    if (sb.isEmpty()) {
      XmlUtil.error(this.line, this.posInLine, `identifer_or_integer unrecopgnized character: (${this.curChar}) ${this.curChar}`);
    }
    this.decPrevious();
    return new Token(ETokenType.TEXT, sb.toString(), this.line);
  }
  /**
   * 获取注释
   * @return
   */
  comment() {
    let chs = [this.incNext(), this.incNext(), this.incNext()];
    let sb = new StringBuilder();
    sb.appends(chs);
    let c;
    while (this.position < this.totalSize) {
      if (chs[0] == "-" && chs[1] == "-" && chs[2] == ">") {
        return new Token(ETokenType.COMMENT_END, sb.toString(), this.line);
      }
      c = this.incNext();
      sb.append(c);
      chs[0] = chs[1];
      chs[1] = chs[2];
      chs[2] = c;
    }
    return Token.TK_UNKNOW;
  }
  /**
   * 获取 cdata
   * @return
   */
  cdata() {
    let chs = [this.incNext(), this.incNext(), this.incNext()];
    let sb = new StringBuilder();
    sb.appends(chs);
    let c;
    while (this.position < this.totalSize) {
      if (chs[0] == "]" && chs[1] == "]" && chs[2] == ">") {
        return new Token(ETokenType.CDATA_END, sb.toString(), this.line);
      }
      c = this.incNext();
      sb.append(c);
      chs[0] = chs[1];
      chs[1] = chs[2];
      chs[2] = c;
    }
    return Token.TK_UNKNOW;
  }
  incNext() {
    this.posInLine++;
    this.position++;
    if (this.position >= this.totalSize) {
      this.curChar = "\0";
      return this.curChar;
    }
    this.curChar = this.source.charAt(this.position);
    if (this.curChar == "\n") {
      this.line++;
      this.posInLine = 0;
      this.analysisListener && this.analysisListener.fireNextLine();
    }
    return this.curChar;
  }
  decPrevious() {
    this.posInLine--;
    this.position--;
    this.curChar = this.source.charAt(this.position);
  }
  /**
   * 检查后续字符串
   * @param s
   * @return
   */
  checkAndIncNextString(s) {
    let len = s.length;
    let sb = new StringBuilder();
    for (let index = 0; index < len; index++) {
      sb.append(this.incNext());
    }
    return s == sb.toString();
  }
}
class XmlParser {
  constructor() {
    this.position = 0;
    this.total = 0;
    this.tokens = [];
    this.tagStack = [];
  }
  XmlParser() {
  }
  parse(content, toEntity, lexiAnalysisListener) {
    this.nodeFactory = toEntity.getNodeFactory();
    this.root = toEntity.getRoot();
    let lexicalAnalysis = new XmlLexicalAnalysis(content);
    lexicalAnalysis.setAnalysisListener(lexiAnalysisListener);
    this.tokens = lexicalAnalysis.analysis();
    this.position = 0;
    this.total = this.tokens.length;
    this.start(this.root);
    toEntity.getTagRoot().resetLineIndex(new Var(0));
  }
  start(node) {
    let curToken = this.token();
    while (this.position < this.total && curToken != Token.TK_END) {
      switch (curToken.getType()) {
        case ETokenType.HEAD_START:
          this.head(node);
          break;
        case ETokenType.LAB:
          this.node(node);
          break;
        case ETokenType.COMMENT_START:
          this.comment(node);
          break;
        case ETokenType.CDATA_START:
          this.cdata(node);
          break;
        case ETokenType.TEXT:
          this.text(node);
          break;
        case ETokenType.LABS:
          this.labs();
          break;
        default:
          ErrorUtil.throwError("Unknow Token Type: " + curToken.getType());
          break;
      }
      curToken = this.nextToken();
    }
  }
  text(node) {
    let token = this.token();
    let textNode = this.nodeFactory.createNode(ENodeType.TEXT, token.getValue());
    node.addChild(textNode);
  }
  /**
   * 左尖括号带斜杠  </
   * @throws Throwable 
   */
  labs() {
    let startTagNode = this.tagStack.pop();
    var startTag = startTagNode ? startTagNode.getTagName() : "";
    var textToken = this.nextToken();
    if (textToken.getValue() != startTag) {
      ErrorUtil.throwError("unexpected tag end:" + textToken.getValue() + " with " + startTag);
    }
    this.position++;
    var sizeOfStack = this.tagStack.length;
    if (sizeOfStack != 0) {
      this.position++;
      var curTop = this.tagStack[sizeOfStack - 1];
      this.start(curTop);
    }
  }
  node(parentNode) {
    let token = this.nextToken();
    let node = this.nodeFactory.createTagNode(token.getValue());
    parentNode.addChild(node);
    token = this.nextToken();
    while (token.getType() != ETokenType.RAB && token.getType() != ETokenType.SRAB) {
      this.attr(node);
      token = this.nextToken();
    }
    if (token.getType() == ETokenType.SRAB) {
      node.setTagNameEnd(false);
      return;
    } else if (token.getType() == ETokenType.RAB) {
      node.setTagNameEnd(true);
      this.tagStack.push(node);
      this.position++;
      this.start(node);
    }
  }
  attr(tagNode) {
    let textToken = this.token();
    this.position++;
    let strToken = this.nextToken();
    var attrValue = strToken.getValue();
    tagNode.addAttribute(textToken.getValue(), XmlUtil.escape(attrValue));
  }
  comment(parentNode) {
    let token1 = this.token();
    let token2 = this.nextToken();
    if (token2.getType() != ETokenType.COMMENT_END) {
      ErrorUtil.throwError("unexpected comment end!");
    }
    var node = this.nodeFactory.createNode(ENodeType.COMMENT, token1.getValue() + token2.getValue());
    if (node.getNodeType() != ENodeType.EMPTY) {
      parentNode.addChild(node);
    }
  }
  cdata(parentNode) {
    var token1 = this.token();
    var token2 = this.nextToken();
    if (token2.getType() != ETokenType.CDATA_END) {
      ErrorUtil.throwError("unexpected cdata end!");
    }
    var node = this.nodeFactory.createNode(ENodeType.CDATA, token1.getValue() + token2.getValue());
    parentNode.addChild(node);
  }
  head(parentNode) {
    let sb = new StringBuilder();
    sb.append(this.token().getValue()).append(" ");
    var token = this.nextToken();
    while (token.getType() != ETokenType.HEAD_END) {
      sb.append(token.getValue());
      this.position++;
      sb.append("=");
      token = this.nextToken();
      sb.append('"').append(token.getValue()).append('"').append(StringUtil.STR_SPACE);
      token = this.nextToken();
    }
    sb.deleteLastChar();
    if (this.tokens[this.position].getType() != ETokenType.HEAD_END) {
      ErrorUtil.throwError("can not find HEAD_END");
    }
    sb.append(token.getValue());
    var headNode = this.nodeFactory.createNode(ENodeType.HEAD, sb.toString());
    parentNode.addChild(headNode);
  }
  token() {
    return this.tokens[this.position];
  }
  nextToken() {
    this.position++;
    if (this.position < this.total) {
      return this.token();
    }
    return Token.TK_END;
  }
}
class XmlUtil {
  static getTagName(xmlFragment) {
    try {
      let parser = new XmlParser();
      var lineEntity = new XmlEntity(true);
      parser.parse(xmlFragment, lineEntity);
      var tagNode = lineEntity.getTagRoot();
      return tagNode.getTagName();
    } catch (e) {
      return "";
    }
  }
  static removeReturnChars(strFragment) {
    if (strFragment && typeof strFragment == "string") {
      strFragment = strFragment.replace(/[\r\n]/g, "");
    }
    return strFragment;
  }
  static escape(text) {
    text = String(text);
    return text.replace(/&amp;/g, "&").replace(/&quot;/g, '"').replace(/&lt;/g, "<").replace(/&gt;/g, ">");
  }
  static unescape(text) {
    text = String(text);
    return text.replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
  }
  static indentLine4Html(level, sb) {
    for (let i = 0; i < level; i++) {
      sb.append(StringUtil.STR_INDENT_NBSP);
    }
  }
  static indentLine(level, sb) {
    for (let i = 0; i < level; i++) {
      sb.append(StringUtil.STR_INDENT_SPACE);
    }
  }
  static error(line, pos, msg) {
    if (line > 0 && pos > 0) {
      throw new Error(`${msg} in line ${line}, pos ${pos}
`);
    } else {
      throw new Error(msg);
    }
  }
  static throwError(msg) {
    throw new Error(msg);
  }
  static checkXml(xml) {
    try {
      XmlEntity.parse(xml);
      return true;
    } catch (e) {
      return false;
    }
  }
}
class VarIndexUtil {
  static incVarIndex(varIndex) {
    var index = varIndex.getData() + 1;
    varIndex.setData(index);
    return varIndex.getData();
  }
}
class ContentNode {
  constructor(nodeType, content) {
    this.line = -1;
    this.nodeType = nodeType;
    this.content = content;
  }
  resetLineIndex(varIndex) {
    var contentLines = this.content.split("\n").length;
    varIndex.setData(varIndex.getData() + contentLines - 1);
    this.line = VarIndexUtil.incVarIndex(varIndex);
  }
  getMaxNodeID() {
    return 0;
  }
  setParent(parent) {
    this.parent = parent;
  }
  getParent() {
    return this.parent;
  }
  findNodeByLine(line) {
    if (line == this.line) {
      return this;
    }
    return null;
  }
  getEndLine() {
    return this.line;
  }
  getStartLine() {
    return this.line;
  }
  writeJSON(sb) {
    sb.append(GlobalConstants.S_ContentNode).append(this.content);
  }
  setContent(content) {
    this.content = content;
  }
  getNodeType() {
    return this.nodeType;
  }
  getContent() {
    return this.content;
  }
  writeXml(level, sb, bSimple) {
    if (!bSimple) {
      XmlUtil.indentLine(level, sb);
    }
    sb.append(this.content);
    return true;
  }
  accept(visitor) {
    visitor.visit(this);
  }
  outputLevel(level, outputHandler) {
    outputHandler.out(level, this, true);
  }
}
class Attribute {
  constructor(key2, value2) {
    this.key = "";
    this.value = "";
    this.key = key2;
    this.value = value2;
  }
  getKey() {
    return this.key;
  }
  getValue() {
    return this.value;
  }
  setValue(value2) {
    value2 = XmlUtil.removeReturnChars(value2);
    this.value = value2;
  }
  toString() {
    var attrValue = XmlUtil.unescape(this.value);
    return `${this.key}="${attrValue}"`;
  }
}
class BaseConstants {
}
BaseConstants.ATTR_Key = "Key";
BaseConstants.ATTR_Caption = "Caption";
BaseConstants.ATTR_COLUMEXPAND = "ColumnExpand";
BaseConstants.ATTR_COLUMTYPE = "GroupType";
BaseConstants.ATTR_Name = "Name";
BaseConstants.ATTR_ColSpan = "MergedColumnSpan";
BaseConstants.ATTR_RowSpan = "MergedRowSpan";
BaseConstants.ATTR_Merged_Head = "IsMergedHead";
BaseConstants.ATTR_ISMERGED = "IsMerged";
BaseConstants.ATTR_X = "X";
BaseConstants.ATTR_Y = "Y";
BaseConstants.ATTR_XSpan = "XSpan";
BaseConstants.ATTR_YSpan = "YSpan";
BaseConstants.ATTR_Type = "Type";
BaseConstants.ATTR_Width = "Width";
BaseConstants.ATTR_Height = "Height";
BaseConstants.ATTR_ForeColor = "ForeColor";
BaseConstants.ATTR_BackColor = "BackColor";
BaseConstants.ATTR_TableKey = "TableKey";
BaseConstants.NODE_Display = "Display";
BaseConstants.NODE_Border = "Border";
BaseConstants.NODE_Font = "Font";
BaseConstants.ATTR_FONT_Bold = "Bold";
BaseConstants.ATTR_FONT_Size = "Size";
BaseConstants.ATTR_FONT_Italic = "Italic";
BaseConstants.ATTR_FONT_Underline = "UnderLine";
BaseConstants.ATTR_FormKey = "FormKey";
BaseConstants.ATTR_BOTTOMCOLOR = "BottomColor";
BaseConstants.ATTR_RIGHTCOLOR = "RightColor";
BaseConstants.ATTR_TDPCOLOR = "TopColor";
BaseConstants.ATTR_LEFTCOLOR = "LeftColor";
BaseConstants.ATTR_BOTTOMSTYLE = "BottomStyle";
BaseConstants.ATTR_TOPSTYLE = "TopStyle";
BaseConstants.ATTR_RIGHTSTYLE = "RightStyle";
BaseConstants.ATTR_LEFTSTYLE = "LeftStyle";
BaseConstants.ATTR_DATATYPE = "DataType";
BaseConstants.ATTR_FORMATSTRING = "FormatString";
BaseConstants.Node_Cell = "Cell";
BaseConstants.Node_Rows = "Rows";
BaseConstants.Node_RowDef = "RowDef";
BaseConstants.Node_ColumnDef = "ColumnDef";
class TagNode {
  //是否以</TagName>结尾
  constructor(tagName) {
    this.startLine = -1;
    this.endLine = -1;
    this.children = [];
    this.attributes = [];
    this.selected = false;
    this.tagNameEnd = false;
    this.tagName = tagName;
  }
  /**
   * 通过行号查找当前的TagNode
   * @param line 
   * @returns 
   */
  findNodeByLine(line) {
    if (line == this.startLine) {
      return this;
    }
    for (let node of this.children) {
      var result = node.findNodeByLine(line);
      if (result)
        return result;
    }
    return null;
  }
  setTagNameEnd(tagNameEnd) {
    this.tagNameEnd = tagNameEnd;
  }
  isTagNameEnd() {
    return this.tagNameEnd;
  }
  getStartLine() {
    return this.startLine;
  }
  getEndLine() {
    return this.endLine;
  }
  /**
   * 取下一个兄弟节点
   */
  nextSibling() {
    var parent = this.getParent();
    if (parent) {
      var siblings = parent.getChildren();
      var index = siblings.indexOf(this);
      if (index >= 0 && index + 1 < siblings.length) {
        return siblings[index + 1];
      }
    }
    return null;
  }
  /**
   * 通过关键属性值，查找某个节点
   * @param tag 
   * @param primaryKey 
   * @param primaryValue 
   * @returns 
   */
  find(tag, primaryKey, primaryValue) {
    if (this.tagName == tag && this.getAttributeValue(primaryKey) == primaryValue) {
      return this;
    }
    for (let child of this.children) {
      if (child.getNodeType() == ENodeType.TAG) {
        var result = child.find(tag, primaryKey, primaryValue);
        if (result)
          return result;
      }
    }
    return void 0;
  }
  /**
   * 是否是用户模式下定义的节点
   * 
   * @returns 
   */
  isUserDefine() {
    return this.getAttributeValue(GlobalConstants.S_IsUserDefine) == "true";
  }
  setContent(content) {
  }
  setCDATAValue(value2) {
    var cdataNode = this.ensureCDataNode();
    if (value2) {
      cdataNode.setContent(`<![CDATA[${value2}]]>`);
    } else {
      this.removeChild(cdataNode);
    }
  }
  getCDATAValue() {
    var cdata = this.getCDATA();
    return cdata.length > 10 ? cdata.substring(9, cdata.length - 3) : "";
  }
  getCDATA() {
    return this.ensureCDataNode().getContent();
  }
  removeAttribute(key2) {
    var index = this.indexOfAttribute(key2);
    if (index > -1) {
      this.attributes.splice(index, 1);
    }
  }
  setSelected(b) {
    this.selected = b;
  }
  isSelected() {
    return this.selected;
  }
  setParent(parent) {
    this.parent = parent;
  }
  getParent() {
    return this.parent;
  }
  hasAttribute(key2) {
    let attr = this.getAttribute(key2);
    return attr != null;
  }
  setAttributeValue(key2, value2, defaultValue) {
    if (value2 == defaultValue) {
      this.removeAttribute(key2);
      return;
    }
    let attr = this.getAttribute(key2);
    if (attr) {
      attr.setValue(value2);
    } else {
      this.addAttribute(key2, value2);
    }
  }
  getAttributeValue(key2, defaultValue = "") {
    let attr = this.getAttribute(key2);
    if (attr) {
      return attr.getValue();
    } else {
      return defaultValue;
    }
  }
  getAttributeValueInt(key2, defaultValue = 0) {
    return this.hasAttribute(key2) ? parseInt(this.getAttributeValue(key2)) : defaultValue;
  }
  getAttributeValueBoolean(key2, defaultValue) {
    return this.hasAttribute(key2) ? TypeUtil.toBoolean(this.getAttributeValue(key2)) : defaultValue;
  }
  getNodeType() {
    return ENodeType.TAG;
  }
  getTagName() {
    return this.tagName;
  }
  getChildren() {
    for (let child of this.children) {
      if (child.getNodeType() && (child.getNodeType() == "comment" || child.getNodeType() == "text")) {
        let index = this.children.indexOf(child);
        this.children.splice(index, 1);
      }
    }
    return this.children;
  }
  /**
   * 删除子节点
   * onlyClearUserDefine： 是否仅删除用户模式下定义的节点
   * 
   */
  clearChildren(tag, onlyClearUserDefine, attrkey, attrValue) {
    var tmpChildren = [];
    if (tag) {
      for (let child of this.children) {
        if (child instanceof TagNode) {
          var tagNode = child;
          var value2 = attrkey ? tagNode.getAttributeValue(attrkey) : "";
          attrValue = attrValue ? attrValue : "";
          if (tagNode.tagName != tag || value2 != attrValue) {
            tmpChildren.push(tagNode);
          } else if (onlyClearUserDefine && !tagNode.isUserDefine()) {
            tmpChildren.push(tagNode);
          }
        } else {
          tmpChildren.push(child);
        }
      }
    }
    this.children = tmpChildren;
  }
  getChild(tag) {
    var pos = tag.indexOf("|");
    if (pos > 0) {
      var child = this.getChild(tag.substring(0, pos));
      if (child) {
        return child.getChild(tag.substring(pos + 1));
      }
    } else {
      for (let child2 of this.children) {
        if (child2.getNodeType() == ENodeType.TAG) {
          var tagNode = child2;
          if (tagNode.getTagName() == tag) {
            return tagNode;
          }
        }
      }
    }
    return null;
  }
  ensureChild(tags) {
    if (!tags)
      return this;
    var pos = tags.indexOf("|");
    if (pos <= 0) {
      return this.ensureSingleChild(tags);
    }
    var tag = tags.substring(0, pos);
    var child = this.ensureSingleChild(tag);
    return child.ensureChild(tags.substring(pos + 1));
  }
  ensureSingleChild(tag) {
    var child = this.getChild(tag);
    if (child)
      return child;
    child = new TagNode(tag);
    this.addChild(child);
    return child;
  }
  getAttributes() {
    return this.attributes;
  }
  getContent() {
    return toString();
  }
  addChild(child) {
    child.setParent(this);
    this.children.push(child);
    return child;
  }
  removeChild(child) {
    var index = this.children.indexOf(child);
    if (index >= 0) {
      this.children.splice(index, 1);
    }
  }
  addAttribute(key2, value2) {
    var attribute = new Attribute(key2, value2);
    this.attributes.push(attribute);
    return attribute;
  }
  getAttribute(key2) {
    for (let attr of this.attributes) {
      if (attr.getKey() == key2) {
        return attr;
      }
    }
    return null;
  }
  hasChild() {
    return this.children.length > 0;
  }
  toXml(bSimple) {
    let sb = new StringBuilder();
    this.writeXml(this.getLevel(), sb, bSimple);
    return sb.toString();
  }
  getLevel() {
    var tmpTag = this;
    var level = -2;
    while (tmpTag) {
      level++;
      tmpTag = tmpTag.getParent();
    }
    return level;
  }
  toJSONString() {
    let sb = new StringBuilder();
    this.writeJSON(sb);
    return sb.toString();
  }
  writeJSON(sb) {
    sb.append("{tag:").append(this.tagName);
    var lenAttr = this.attributes.length;
    if (lenAttr > 0) {
      var index = 0;
      sb.append(",");
      sb.append(GlobalConstants.S_Attributes).append(":{");
      for (let attr of this.attributes) {
        sb.append(attr.getKey()).append(":'").append(attr.getValue()).append("'");
        index < lenAttr - 1 && sb.append(",");
        index++;
      }
      sb.append("}");
    }
    if (this.hasChild()) {
      if (lenAttr > 0) {
        sb.append(",");
      }
      var index = 0;
      var size = this.children.length;
      sb.append(GlobalConstants.S_ChildNodes).append(":[");
      for (let node of this.children) {
        node.writeJSON(sb);
        index < size - 1 && sb.append(",");
        index++;
      }
      sb.append("]");
    }
    sb.append("}");
  }
  writeXml(level, sb, bSimple) {
    var beginIndex = sb.getLastIndex();
    if (!bSimple) {
      XmlUtil.indentLine(level, sb);
    }
    var linebreak = bSimple ? "" : "\r\n";
    var bNullTag = this.tagName == null || this.tagName == "";
    if (!bNullTag) {
      sb.append("<").append(this.tagName);
      for (let attr of this.attributes) {
        sb.append(" ").append(attr.toString());
      }
      if (!this.hasChild()) {
        if (this.attributes.length > 0 || this.tagName == BaseConstants.Node_Cell || this.tagName == BaseConstants.Node_Rows || this.tagName == BaseConstants.Node_RowDef || this.tagName == BaseConstants.Node_ColumnDef) {
          sb.append("/>");
          return true;
        } else {
          sb.rollbackTo(beginIndex);
          return false;
        }
      } else {
        sb.append(">");
      }
    }
    if (this.hasChild()) {
      var bFirstLine = bNullTag;
      for (let node of this.children) {
        if (bFirstLine) {
          bFirstLine = false;
          node.writeXml(level + 1, sb, bSimple);
        } else {
          sb.append(linebreak);
          var result = node.writeXml(level + 1, sb, bSimple);
          if (!result)
            sb.deleteLastChar();
        }
      }
    }
    if (!bNullTag) {
      sb.append(linebreak);
      if (!bSimple) {
        XmlUtil.indentLine(level, sb);
      }
      sb.append("</").append(this.tagName).append(">");
    }
    return true;
  }
  resetLineIndex(varIndex) {
    if (!this.hasChild() && this.attributes.length == 0 && this.tagName != BaseConstants.Node_Cell && this.tagName != BaseConstants.Node_Rows && this.tagName != BaseConstants.Node_RowDef && this.tagName != BaseConstants.Node_ColumnDef) {
      this.startLine = -1;
      this.endLine = -1;
      return;
    }
    this.startLine = VarIndexUtil.incVarIndex(varIndex);
    if (this.hasChild()) {
      for (let node of this.children) {
        node.resetLineIndex(varIndex);
      }
    } else {
      this.endLine = this.isTagNameEnd() ? VarIndexUtil.incVarIndex(varIndex) : this.startLine;
      return;
    }
    this.endLine = VarIndexUtil.incVarIndex(varIndex);
  }
  outputLevel(level, outputHandler) {
    outputHandler.out(level, this, true);
    for (let node of this.children) {
      node.outputLevel(level + 1, outputHandler);
    }
    if (this.hasChild()) {
      outputHandler.out(level, this, false);
    }
  }
  output(outputHandler) {
    var bNullTag = this.tagName == null || this.tagName == "";
    if (bNullTag) {
      for (let node of this.children) {
        node.outputLevel(0, outputHandler);
      }
    }
  }
  getMaxNodeID() {
    var id = this.getAttributeValueInt(GlobalConstants.S_ID);
    for (let child of this.children) {
      id = Math.max(id, child.getMaxNodeID());
    }
    return id;
  }
  getTagNode() {
    return this;
  }
  accept(visitor) {
    visitor.visit(this);
    for (let child of this.children) {
      child.accept(visitor);
    }
  }
  indexOfAttribute(key2) {
    var index = 0;
    for (let attr of this.attributes) {
      if (key2 == attr.getKey()) {
        return index;
      }
      index++;
    }
    return -1;
  }
  ensureCDataNode() {
    for (let node2 of this.children) {
      if (node2.getNodeType() == ENodeType.CDATA) {
        return node2;
      }
    }
    var node = new ContentNode(ENodeType.CDATA, "");
    this.addChild(node);
    return node;
  }
}
class DefaultNodeFactory {
  createNode(type, content) {
    switch (type) {
      case ENodeType.CDATA:
      case ENodeType.COMMENT:
      case ENodeType.TEXT:
      case ENodeType.HEAD:
        return new ContentNode(type, content);
      case ENodeType.TAG:
        return this.createTagNode(content);
    }
    throw new Error("unknow node type");
  }
  createTagNode(tagName) {
    return new TagNode(tagName);
  }
}
class EmptyNode {
  constructor() {
  }
  resetLineIndex(varIndex) {
  }
  getMaxNodeID() {
    return 0;
  }
  setParent(parent) {
  }
  getParent() {
    return void 0;
  }
  findNodeByLine(line) {
    return null;
  }
  getStartLine() {
    return -1;
  }
  getEndLine() {
    return -1;
  }
  writeJSON(sb) {
  }
  setContent(content) {
  }
  getNodeType() {
    return ENodeType.EMPTY;
  }
  getContent() {
    return "";
  }
  writeXml(level, sb, bSimple) {
    return true;
  }
  accept(visitor) {
  }
  outputLevel(level, outputHandler) {
  }
}
class NodeFactoryWithoutComment {
  createNode(type, content) {
    switch (type) {
      case ENodeType.COMMENT:
      case ENodeType.HEAD:
        return new EmptyNode();
      case ENodeType.CDATA:
      case ENodeType.TEXT:
        return new ContentNode(type, content);
      case ENodeType.TAG:
        return this.createTagNode(content);
    }
    throw new Error("unknow node type");
  }
  createTagNode(tagName) {
    return new TagNode(tagName);
  }
}
class RootNode extends TagNode {
  constructor() {
    super("");
  }
  getNodeType() {
    return ENodeType.ROOT;
  }
}
const _XmlEntity = class _XmlEntity2 {
  constructor(withoutComment = false) {
    this.cmdQueue = new CmdQueue();
    this.maxNodeID = -1;
    this.eventListeners = [];
    this.root = new RootNode();
    this.withoutComment = false;
    this.withoutComment = withoutComment;
    this.selectionModel = new SelectionModel(this);
  }
  find(tag, primaryKey, primaryValue) {
    return this.root.find(tag, primaryKey, primaryValue);
  }
  undo() {
    this.cmdQueue.undoCmd();
  }
  redo() {
    this.cmdQueue.redoCmd();
  }
  getCmdQueue() {
    return this.cmdQueue;
  }
  unselect(selectable) {
    selectable.setSelected(false);
    this.updateSelect(selectable.getTagNode());
  }
  unSelectAll() {
    var paras = Paras.newInstance().setElement(this.selectionModel.getSelectionItems());
    this.fireEvent(ActionNames.model_node_properties_commit, paras);
    var tagRoot = this.getTagRoot();
    this.unSelectChildren(tagRoot.getChildren());
  }
  unSelectChildren(children) {
    for (let child of children) {
      if (child.getNodeType() == ENodeType.TAG) {
        var tagNode = child;
        if (tagNode.isSelected()) {
          tagNode.setSelected(false);
          this.updateSelect(tagNode);
        }
        this.unSelectChildren(tagNode.getChildren());
      }
    }
  }
  select(selectable) {
    if (selectable) {
      selectable.setSelected(true);
      this.updateSelect(selectable.getTagNode());
    } else {
      this.updateSelect(void 0);
    }
  }
  getSelectionModel() {
    return this.selectionModel;
  }
  addEventListener(listener) {
    this.eventListeners.push(listener);
  }
  getTagNode() {
    return this.root;
  }
  getRoot() {
    return this.root;
  }
  addNode(node, parentNode) {
    var parent = parentNode ? parentNode : this.getTagRoot();
    parent.addChild(node);
    var paras = Paras.newInstance().setElement(node);
    this.fireEvent(ActionNames.model_node_add, paras);
    return node;
  }
  removeNode(node, fireEvent = true) {
    var _a;
    (_a = node.getParent()) == null ? void 0 : _a.removeChild(node);
    var paras = Paras.newInstance().setElement(node);
    this.fireEvent(ActionNames.model_node_remove, paras);
  }
  removeSelectNode() {
    var item = this.selectionModel.getSingleSeletionItem();
    if (item) {
      this.removeNode(item.getTagNode());
    }
  }
  ensureNode(tagName, parent) {
    var node = parent.getChild(tagName);
    if (!node) {
      node = this.getNodeFactory().createTagNode(tagName);
      this.addNode(node, parent);
    }
    return node;
  }
  getNodeFactory() {
    return this.withoutComment ? _XmlEntity2.nodeFactoryWidthoutComment : _XmlEntity2.defaultNodeFactory;
  }
  getXml(bSimple) {
    return this.root.toXml(bSimple);
  }
  getTagRoot() {
    for (let child of this.root.getChildren()) {
      if (child.getNodeType() == ENodeType.TAG) {
        return child;
      }
    }
    return this.root;
  }
  update(tagNode, bUpdateAttrOnly = false) {
    var paras = Paras.newInstance().setElement(tagNode).add(Paras.P_UPDATE_ATTR_ONLY, bUpdateAttrOnly);
    this.fireEvent(ActionNames.model_node_update, paras);
  }
  updateSelect(tagNode) {
    var paras = Paras.newInstance().setElement(tagNode);
    if (this.selectionModel.getBMultiSelection()) {
      this.fireEvent(ActionNames.model_node_update_multi_select, paras);
    } else {
      this.fireEvent(ActionNames.model_node_update_select, paras);
    }
  }
  fireEvent(action, paras) {
    for (let listener of this.eventListeners) {
      listener.notifyEvent(action, paras);
    }
  }
  reload(xml) {
    this.root.clearChildren();
    let parser = new XmlParser();
    parser.parse(xml, this);
    this.cmdQueue.clear();
  }
  findNodeByLine(line) {
    return this.root.findNodeByLine(line);
  }
  genNextNodeID() {
    if (this.maxNodeID == -1) {
      this.maxNodeID = this.getTagRoot().getMaxNodeID();
    }
    return ++this.maxNodeID;
  }
  fireCommit() {
    var paras = Paras.newInstance().setElement(this.selectionModel.getSelectionItems());
    this.fireEvent(ActionNames.model_node_properties_commit, paras);
  }
  static parse(xml, withoutComment = false) {
    let parser = new XmlParser();
    var xmlEntity = new _XmlEntity2(withoutComment);
    parser.parse(xml, xmlEntity);
    return xmlEntity;
  }
  static parseTagNode(xml) {
    let parser = new XmlParser();
    var xmlEntity = new _XmlEntity2(true);
    parser.parse(xml, xmlEntity);
    return xmlEntity.getTagRoot();
  }
  static parseTagNodeCollection(xml) {
    var xmlWithRoot = `<ROOT>${xml}</ROOT>`;
    var entity = _XmlEntity2.parse(xmlWithRoot);
    var root = entity.getTagRoot();
    return root.getChildren();
  }
};
_XmlEntity.nodeFactoryWidthoutComment = new NodeFactoryWithoutComment();
_XmlEntity.defaultNodeFactory = new DefaultNodeFactory();
let XmlEntity = _XmlEntity;
const _PropertyManager = class _PropertyManager2 {
  constructor(propertiesXml) {
    this.bpmnXmlEntity = XmlEntity.parse(propertiesXml, true);
    this.root = this.bpmnXmlEntity.getTagRoot();
    this.defines = /* @__PURE__ */ new Map();
    this.init();
  }
  getNodeDefines() {
    return this.defines.values();
  }
  getNodeDefine(key2) {
    return this.defines.get(key2);
  }
  init() {
    var defineCollection = this.root.getChild(_PropertyManager2.NODE_DefineCollection);
    var children = defineCollection == null ? void 0 : defineCollection.getChildren();
    if (children) {
      for (let defineTag of children) {
        var tagNode = defineTag;
        var key2 = tagNode.getAttributeValue(GlobalConstants.S_Key);
        var caption = tagNode.getAttributeValue(GlobalConstants.S_Caption);
        var extend2 = tagNode.getAttributeValue(GlobalConstants.S_Extends);
        var nodeDefine = new NodeDefine(key2, caption, extend2);
        this.defines.set(key2, nodeDefine);
        var propertyCollection = tagNode.getChild(_PropertyManager2.NODE_PropertyCollection);
        var subNodes = propertyCollection == null ? void 0 : propertyCollection.getChildren();
        if (subNodes) {
          for (let sub of subNodes) {
            var propertyDefine = this.createPropertyNode(sub);
            nodeDefine.addProperty(propertyDefine);
          }
        }
      }
    }
  }
  createPropertyNode(tagNode) {
    var key2 = tagNode.getAttributeValue(GlobalConstants.S_Key);
    var caption = tagNode.getAttributeValue(GlobalConstants.S_Caption);
    var controlType = tagNode.getAttributeValue(GlobalConstants.S_Control);
    var propertyDefine = new PropertyDefine(key2, controlType);
    propertyDefine.setCaption(caption);
    propertyDefine.setTextAttributeKey(tagNode.getAttributeValue(GlobalConstants.S_TextAttributeKey));
    propertyDefine.setNode(tagNode.getAttributeValue(GlobalConstants.S_Node));
    propertyDefine.setXmlElementType(tagNode.getAttributeValue(GlobalConstants.S_Type));
    propertyDefine.setEditable(tagNode.getAttributeValue(GlobalConstants.S_Editable, "true"));
    propertyDefine.setVisible(tagNode.getAttributeValue(GlobalConstants.S_Visible, "true"));
    propertyDefine.setDefaultValue(tagNode.getAttributeValue(GlobalConstants.S_DefaultValue));
    propertyDefine.setGroup(tagNode.getAttributeValue(GlobalConstants.S_Group));
    propertyDefine.setOnInitialize(tagNode.getAttributeValue(GlobalConstants.S_OnInitialize));
    propertyDefine.setOnButtonClick(tagNode.getAttributeValue(GlobalConstants.S_OnButtonClick));
    propertyDefine.setOnValueChanged(tagNode.getAttributeValue(GlobalConstants.S_OnValueChanged));
    propertyDefine.setUpdateAttributeOnly(tagNode.getAttributeValueBoolean(GlobalConstants.S_UpdateAttributeOnly, false));
    return propertyDefine;
  }
};
_PropertyManager.NODE_DefineCollection = "DefineCollection";
_PropertyManager.NODE_PropertyCollection = "PropertyCollection";
let PropertyManager = _PropertyManager;
class BPMN {
}
BPMN.PROPERTIES_XML_USER = `<BPMN>
	<DefineCollection>
		<!-- 流程属性: 标志、名称、版本、迁移表设置、忽略表单状态、查询撤销工作项信息、表单的反向模板定义、关闭实例触发器、驳回后是否锁定工作项、自定义流程图信息扩展类、自定义流程不同时机触发事件的扩展类 -->
		<!-- 未定义属性: 迁移表设置 -->
		<Define Key="Process" Caption="流程" Extends="">
			<PropertyCollection>
				<Property Key="Key" Caption="标志" Control="TextEditor" Editable="false" UpdateAttributeOnly="true"/>
				<Property Key="Version" Caption="版本" Control="NumberEditor" Editable="false" Visible="false" UpdateAttributeOnly="true"/>
				<Property Key="Caption" Caption="名称" Control="TextEditor" Editable="false" Visible="false" UpdateAttributeOnly="true"/>
				<Property Key="FormKey" Caption="绑定表单" Control="TempButtonEditor"  OnButtonClick="Macro_ShowWorkflowBindDialog()" Editable="true" UpdateAttributeOnly="true"/>
				<!--<Property Key="FormKey" Caption="权限表单" Control="Combobox" OnInitialize="=Macro_GetWorkflowFormKeyList()" Editable="true" UpdateAttributeOnly="true"/>-->
				<!--<Property Key="FormKey" Caption="权限表单" Control="YigoCodeDict" Editable="true" OnValueChanged="SetPara('PermFormKey', {{self.value}})" UpdateAttributeOnly="true"/>-->
				<!--<Property Key="FormKey" Caption="权限表单" Control="YigoDict" Editable="true"/>-->
				<Property Key="PermCollection|Perm" Type="Collection" Caption="权限设置" DefaultValue="=GetPermShowText()" DefaultValue="设置" Control="ButtonEditor" OnButtonClick="Macro_ShowPermDialog()" Editable="true" UpdateAttributeOnly="true"/>
			</PropertyCollection>
		</Define>
		
		<!-- 属性: 数字编号、标志、名称、默认图片、已通过状态图片、当前状态节点图片、自有节点状态、是否可以撤销工作项、撤销工作项通用名称、节点撤销事件、是否同步 -->
		<Define Key="Element" Caption="基础属性" Extends="">
			<PropertyCollection>
				<Property Key="Caption" Caption="名称" Control="TextEditor" Editable="true"/>
			</PropertyCollection>
		</Define>
		
		<!-- 流 -->
		<Define Key="Transition" Caption="流属性" Extends="Element">
			<PropertyCollection>
				<Property Key="TargetNodeKey" Caption="目标节点" Control="TextEditor" Editable="false"/>
				<Property Key="StraightLine" Caption="流样式" Type="Collection"  DefaultValue="=GetPermShowText()" DefaultValue="设置" Control="ButtonEditor" OnButtonClick="Macro_ShowTransitionGraphic()" Editable="true" UpdateAttributeOnly="true" Description="流样式设置"/>
			</PropertyCollection>
		</Define>
		<Define Key="Association" Caption="关联流" Extends="Transition"/>
		<Define Key="ExceptionFlow" Caption="异常流" Extends="Transition"/>
		<Define Key="SequenceFlow" Caption="顺序流" Extends="Transition">
			<PropertyCollection>
				<Property Key="Condition" Caption="条件值" Control="TempButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('Condition', 'VALUE_CONDITION')" DefaultValue="true" Editable="true"/>
				<!--<Property Key="Status" Caption="状态" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey(), GetWorkflowKey())" Editable="true"/>-->
			</PropertyCollection>
		</Define>
		
		<!-- 属性: 自有节点状态、是否可以撤销工作项、撤销工作项通用名称、节点撤销事件、是否同步、默认图片、已通过状态图片、当前状态节点图片 -->
		<!-- 未定义属性: RefType="New" -->
		<Define Key="Node" Caption="节点属性" Extends="Element">
			<PropertyCollection>
				<!--<Property Key="BPMState" Caption="自有节点状态" Control="NumberEditor" Editable="true"/>-->
			</PropertyCollection>
		</Define>

		<!-- 事件 -->
		<Define Key="Event" Extends="Node"/>	
		<!-- 属性: 开始事件 -->
		<Define Key="Begin" Caption="起始事件" Extends="Event">
			<PropertyCollection>
				<Property Key="Status" Caption="开始状态" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey(), GetWorkflowKey())" Editable="true"/>
			</PropertyCollection>
		</Define>
		<!-- 属性: 状态标志、工作项创建事件、工作项完成事件、权限设置、绑定字段标志、绑定字段值、工作项撤销条件 -->
		<Define Key="State" Caption="状态节点" Extends="Event">
			<PropertyCollection>
				<Property Key="Status" Caption="状态标志" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey(), GetWorkflowKey())"/>
				<Property Key="FieldKey" Caption="绑定字段" Control="Combobox" OnInitialize="=Macro_GetStatusFieldList(GetWorkflowFormKey())"/>
				<Property Key="FieldValue" Caption="绑定字段值" Control="Combobox" OnInitialize="=Macro_GetStatusValueList(GetWorkflowFormKey())"/>
				<Property Key="RevokeCondition" Caption="撤销条件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('RevokeCondition', 'CONDITION')"/>
			</PropertyCollection>
		</Define>
		<!-- 属性: 分支结束事件 -->
		<Define Key="BranchEnd" Caption="分支结束" Extends="Event"/>
		<!-- 属性: 结束事件 -->
		<Define Key="End" Caption="结束事件" Extends="Event">
			<PropertyCollection>
				<Property Key="Status" Caption="结束状态" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey(), GetWorkflowKey())" Editable="true"/>
			</PropertyCollection>
		</Define>
		
		<!-- 网关 -->
		<Define Key="BaseGateWay" Caption="网关" Extends="Node"/>
		<Define Key="Join" Caption="合并网关" Extends="BaseGateWay"/>
		<Define Key="Fork" Caption="分支网关" Extends="BaseGateWay"/>
		<Define Key="ExclusiveFork" Caption="互斥网关" Extends="BaseGateWay"/>
		<Define Key="ComplexJoin" Caption="复杂网关" Extends="BaseGateWay"/>
		<Define Key="Decision" Caption="选择网关" Extends="BaseGateWay">
			<PropertyCollection>
				<Property Key="Condition" Caption="选择条件" Control="TempButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('Condition', 'VALUE_CONDITION')" Editable="true" Description="选择条件"/>
			</PropertyCollection>
		</Define>
		<Define Key="GateWay" Caption="路由网关" Extends="BaseGateWay">
			<PropertyCollection>
				<Property Key="Condition" Caption="流转条件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('Condition', 'VALUE_CONDITION')" Editable="true" Description="流转条件"/>
			</PropertyCollection>
		</Define>
		
		<!-- 活动 -->
		<Define Key="Activity" Caption="工作项" Extends="Node"></Define>
		<Define Key="ManualTask" Caption="人工任务" Icon="&#xe923;" Extends="Activity"></Define>
		
		<Define Key="Task" Caption="任务" Extends="Activity">
			<PropertyCollection>
				<!-- 待处理 -->
				<Property Key="RevokeCondition" Caption="撤销条件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('RevokeCondition', 'CONDITION')" Editable="true"/>
				<Property Key="CreateTrigger" Caption="工作项创建事件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('CreateTrigger', 'ACTION')" Editable="true" Description=""/>
				<Property Key="FinishTrigger" Caption="工作项完成事件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('FinishTrigger', 'ACTION')" Editable="true" Description=""/>
				<Property Key="AutoIgnoreNoParticipator" Caption="无参与者略过" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true" Description="无参与者自动略过"/>
				<Property Key="AutoCommitContainSameParticipator" Caption="包含来源参与者自动提交" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true" Description="包含上一参与者自动略过"/>
				<Property Key="AutoCommitSameParticipator" Caption="等于来源参与者自动提交" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true" Description="等于上一参与者自动略过"/>
				<Property Key="ParticipatorCollection" Type="Collection" Caption="参与者集合" Control="ButtonEditor" OnButtonClick="Macro_ShowParticipatorCollectionDialog(GetSelectNodeXml('ParticipatorCollection'))" Editable="true" Visible="false" Description="参与者集合"/>
				<Property Key="OperationCollection" Type="Collection" Caption="操作集合"  DefaultValue="=GetCollectionShowText('OperationCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowOperationCollectionDialog(GetSelectNodeXml('OperationCollection'))" Editable="true" Description="操作集合" Visible="false"/>
			</PropertyCollection>
		</Define>
		
		<Define Key="ServiceTask" Caption="系统任务" Icon="&#xe609;" Extends="Activity">
			<PropertyCollection>
				<!-- 待处理 -->
				<Property Key="Action" Type="CDATA" Caption="操作" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('Action', 'ACTION')" Editable="true" Description=""/>
			</PropertyCollection>
		</Define>
		
		<Define Key="UserTask" Caption="用户任务" Icon="&#xe7f1;" Extends="Task"></Define>
		
		<Define Key="Audit" Caption="审批任务" Icon="&#xe656;" Extends="Task">
			<PropertyCollection>
				<Property Key="Perm" Type="Collection" Caption="权限设置" DefaultValue="=GetPermShowText()" DefaultValue="设置" Control="ButtonEditor" OnButtonClick="Macro_ShowPermDialog()" Editable="true" UpdateAttributeOnly="true"/>
				<Property Key="DenyToLastNode" Caption="驳回上一步" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false" Editable="true"/>
				<Property Key="DenyNodeKey" Caption="驳回目标节点" Control="Combobox" OnInitialize="=ListWorkflowNodes()" Visible="GetPropertyValue('DenyToLastNode', 'false')=='false'" Editable="true"/>
			</PropertyCollection>
		</Define>
		
		<Define Key="DataMap" Caption="映射任务" Icon="&#xe6bd;" Extends="Task">
			<PropertyCollection>
				<Property Key="MidDataMap" Caption="中间层映射" Control="Combobox" OnInitialize="{list.boolean}" Editable="false"/>
				<Property Key="SyncTriggerType" Caption="同步机制" Control="Combobox" OnInitialize="NoOpt,无操作;BillSave,数据保存;InstanceStart,实例启动;Async,实例结束" Editable="false"/>
				<Property Key="DataMapCondition" Caption="完成条件" Control="ButtonEditor" OnInitialize="{bpmn.input.formula}" Editable="false"/>
				<Property Key="BillDataMapInfoCollection" Type="Collection" Caption="映射集合" Control="ButtonEditor" OnInitialize="{bpmn.input.datamap.collection}" Editable="false"/>
			</PropertyCollection>
		</Define>
		
		<Define Key="Countersign" Caption="会签任务" Icon="&#xe6bd;" Extends="Task">
			<PropertyCollection>
				<Property Key="FinishType" Caption="完成类型" Control="Combobox" OnInitialize="{bpmn.countersign.condition.type}" Editable="true"/>
				<Property Key="FinishCondition" Caption="完成条件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('FinishCondition', 'CONDITION')" Visible="GetPropertyValue('FinishType', 'None')=='Custom'" Editable="true"/>
				<Property Key="FinishCondition" Caption="完成条件" Control="TextEditor" Visible="GetPropertyValue('FinishType', 'None')=='Proportion'" Editable="true"/>		
				<Property Key="FinishCondition" Caption="完成条件" Control="NumberEditor" Visible="GetPropertyValue('FinishType', 'None')=='Number'" Editable="true"/>		
				<Property Key="FinishCondition" Caption="完成条件" Control="TextEditor" Visible="GetPropertyValue('FinishType', 'None')=='None'" Editable="false"/>
				<Property Key="ValidType" Caption="成立类型" Control="Combobox" OnInitialize="{bpmn.countersign.condition.type}" Editable="true"/>
				<Property Key="ValidCondition" Caption="成立条件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('ValidCondition', 'CONDITION')" Visible="GetPropertyValue('ValidType', 'None')=='Custom'" Editable="true"/>
				<Property Key="ValidCondition" Caption="成立条件" Control="TextEditor" Visible="GetPropertyValue('ValidType', 'None')=='Proportion'" Editable="true"/>		
				<Property Key="ValidCondition" Caption="成立条件" Control="NumberEditor" Visible="GetPropertyValue('ValidType', 'None')=='Number'" Editable="true"/>		
				<Property Key="ValidCondition" Caption="成立条件" Control="TextEditor" Visible="GetPropertyValue('ValidType', 'None')=='None'" Editable="false"/>
				<Property Key="PassType" Caption="通过类型" Control="Combobox" OnInitialize="{bpmn.countersign.condition.type}" Editable="true"/>
				<Property Key="PassCondition" Caption="通过条件" Control="ButtonEditor" OnButtonClick="Macro_ShowUserFormulaDialog('PassCondition', 'CONDITION')" Visible="GetPropertyValue('PassType', 'None')=='Custom'" Editable="true"/>
				<Property Key="PassCondition" Caption="通过条件" Control="TextEditor" Visible="GetPropertyValue('PassType', 'None')=='Proportion'" Editable="true"/>		
				<Property Key="PassCondition" Caption="通过条件" Control="NumberEditor" Visible="GetPropertyValue('PassType', 'None')=='Number'" Editable="true"/>		
				<Property Key="PassCondition" Caption="通过条件" Control="TextEditor" Visible="GetPropertyValue('PassType', 'None')=='None'" Editable="false"/>
			</PropertyCollection>
		</Define>
		
		<Define Key="MultiUserTask" Caption="多人任务" Icon="&#xe61b;" Extends="UserTask">
			 <PropertyCollection>
				 <Property Key="InOrder" Caption="顺序执行" Control="Combobox" OnInitialize="{list.boolean}" Editable="false"/>
			</PropertyCollection>
		</Define>
		
		<Define Key="MultiAudit" Caption="多人审批" Icon="&#xe602;" Extends="Audit"></Define>
		
		<Define Key="StateAction" Caption="状态机" Icon="&#xe603;" Extends="Activity">
			<PropertyCollection>
				<Property Key="ParticipatorCollection" Type="Collection" Caption="参与者集合" Control="ButtonEditor" OnButtonClick="Macro_ShowParticipatorCollectionDialog(GetSelectNodeXml('ParticipatorCollection'))" Editable="false" Visible="false" Description="参与者集合"/>
				<Property Key="RevokeCondition" Caption="撤销条件" Control="ButtonEditor" OnInitialize="{bpmn.input.formula}" Editable="false"/>
				<Property Key="Key" Caption="操作标志" Control="TextEditor" Node="Operation" Group="公共操作" Editable="false"/>
				<Property Key="Operation" Type="Collection" Caption="操作"  DefaultValue="=GetCollectionShowText('Operation')" Control="ButtonEditor" OnButtonClick="Macro_ShowOperationDialog('<OperationCollection>' + IIF(GetSelectNodeXml('Operation') == '', '<Operation/>', GetSelectNodeXml('Operation')) + '</OperationCollection>')" Editable="true" Description="操作"/>

				<!-- <Property Key="Caption" Caption="操作名称" Control="TextEditor" Node="Operation" Group="公共操作" Editable="false"/>
				<Property Key="Enable" Caption="可用性" Control="ButtonEditor" Node="Operation" Group="公共操作" Editable="false"/>
				<Property Key="Visible" Caption="可见性" Control="ButtonEditor" Node="Operation" Group="公共操作" Editable="false"/>
				<Property Key="Icon" Caption="图标" Control="ButtonEditor" Node="Operation" OnInitialize="{input.image}" Group="公共操作" Editable="false"/>
				<Property Key="TemplateKey" Caption="模板标志" Control="TextEditor" Node="Operation" Group="公共操作" Editable="false"/>
				<Property Key="Action" Type="CDATA" Caption="行为" Control="ButtonEditor" OnButtonClick="{bpmn.input.formula}" Editable="false" Group="公共操作" Description=""/> -->
 			</PropertyCollection>
		</Define>
		
		<Define Key="SubProcess" Caption="子流程" Extends="Task">
			<PropertyCollection>
				<Property Key="SyncMode" Caption="执行顺序" Control="Combobox" DefaultValue="Sync" OnInitialize="Sync,同步;Async,异步" Editable="false"/>
				<Property Key="AutoStartAction" Caption="自动开始" Control="ButtonEditor" OnInitialize="{bpmn.input.formula}" Editable="false"/>
				<Property Key="SubProcessKey" Caption="子流程标志" Control="Combobox" OnInitialize="=Macro_GetWorkflowKeyList()" Editable="false"/>
			</PropertyCollection>
		</Define>
		
		<Define Key="Inline" Caption="内联流程" Extends="Activity">
			<PropertyCollection>
				<Property Key="InlineProcessKey" Caption="内联流程标志" Control="Combobox" OnInitialize="=Macro_GetWorkflowKeyList()" Editable="false"/>
			</PropertyCollection>
		</Define>
	</DefineCollection>
	</BPMN>`;
BPMN.PROPERTIES_XML_DEV = `<BPMN>
<DefineCollection>
	<!-- 流程属性: 标志、名称、版本、迁移表设置、忽略表单状态、查询撤销工作项信息、表单的反向模板定义、关闭实例触发器、驳回后是否锁定工作项、自定义流程图信息扩展类、自定义流程不同时机触发事件的扩展类 -->
	<!-- 未定义属性: 迁移表设置 -->
	<Define Key="Process" Caption="流程" Extends="">
		<PropertyCollection>
			<Property Key="Key" Caption="标志" Control="TextEditor" Editable="false"/>
			<Property Key="Version" Caption="版本" Control="NumberEditor" Editable="false" UpdateAttributeOnly="true"/>
			<Property Key="Caption" Caption="名称" Control="TextEditor" Editable="true"/>
			<Property Key="FormKey" Caption="绑定表单" Control="TempButtonEditor"  OnButtonClick="Macro_ShowWorkflowBindDialog()" Editable="true" UpdateAttributeOnly="true"/>
			<Property Key="PermCollection|Perm" Type="Collection" Caption="权限设置" DefaultValue="=GetPermShowText()" Control="ButtonEditor" OnButtonClick="Macro_ShowPermDialog()" Editable="true" UpdateAttributeOnly="true"/>
			<Property Key="DMTable" Type="Collection" Caption="迁移设置" DefaultValue="=GetCollectionShowText('DMTable')" Control="ButtonEditor" OnButtonClick="Macro_ShowDMTableDialog(GetDMTableXml())" Editable="true"/>
			<Property Key="IgnoreFormState" Caption="忽略表单状态" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Description="忽略表单状态"/>
			<Property Key="QueryRetreatWorkitem" Caption="查询撤销工作项" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="true" Description="查询撤销工作项信息"/>
			<Property Key="TemplateKey" Caption="反向模板" Control="TextEditor" DefaultValue="" Editable="true" Description="表单的反向模板定义"/>
			<Property Key="KillInstanceTrigger" Caption="实例关闭触发" Control="TextEditor" DefaultValue="" Editable="true" Description="关闭实例触发器"/>	
			<Property Key="LockWorkitem" Caption="驳回锁定工作项" Control="Combobox" OnInitialize="True,是;False,否" DefaultValue="True" Description="驳回后是否锁定工作项"/>
			
			<Property Key="BPMGraphInfoPath" Node="Expand" Caption="流程图扩展类" Control="TextEditor" DefaultValue="" Description="自定义流程图信息扩展类" Group="扩展类"/>
			<Property Key="WorkFlowHookPath" Node="Expand" Caption="触发事件扩展类" Control="TextEditor" DefaultValue="" Description="自定义流程不同时机触发事件的扩展类" Group="扩展类"/>
		</PropertyCollection>
	</Define>
	
	<!-- 属性: 数字编号、标志、名称、默认图片、已通过状态图片、当前状态节点图片、自有节点状态、是否可以撤销工作项、撤销工作项通用名称、节点撤销事件、是否同步 -->
	<Define Key="Element" Caption="基础属性" Extends="">
		<PropertyCollection>
			<Property Key="ID" Caption="数字编号" Control="NumberEditor" Editable="false"/>
			<Property Key="Key" Caption="标志" Control="TextEditor" Editable="true"/>
			<Property Key="Caption" Caption="名称" Control="TextEditor" Editable="true"/>
		</PropertyCollection>
	</Define>
	
	<!-- 流 -->
	<Define Key="Transition" Caption="流属性" Extends="Element">
		<PropertyCollection>
			<Property Key="TargetNodeKey" Caption="目标节点" Control="TextEditor" Editable="false"/>
			<Property Key="StraightLine" Caption="流图形样式" Node="TransitionGraphic" DefaultValue="StraightLine" Control="StraightLineButtonBox" Editable="true"/>
			<Property Key="Style" Caption="流样式" Node="TransitionGraphic" Control="TextEditor" Editable="true"/>
		</PropertyCollection>
	</Define>
	<Define Key="Association" Caption="关联流" Extends="Transition"/>
	<Define Key="ExceptionFlow" Caption="异常流" Extends="Transition"/>
	<Define Key="SequenceFlow" Caption="顺序流" Extends="Transition">
		<PropertyCollection>
			<Property Key="State" Caption="状态" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey(), GetWorkflowKey())" Editable="true"/>
			<Property Key="Condition" Caption="条件值" Control="TempButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" DefaultValue = "true" Editable="true"/>
		</PropertyCollection>
	</Define>
	
	<!-- 属性: 自有节点状态、是否可以撤销工作项、撤销工作项通用名称、节点撤销事件、是否同步、默认图片、已通过状态图片、当前状态节点图片 -->
	<!-- 未定义属性: RefType="New" -->
	<Define Key="Node" Caption="节点属性" Extends="Element">
		<PropertyCollection>
			<Property Key="BPMState" Caption="自有节点状态" Control="NumberEditor" Editable="true"/>
			<Property Key="WorkitemRevoke" Caption="可撤销" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="true" Editable="true" Description="可以撤销工作项"/>
			<Property Key="RetreatCaption" Caption="撤销名称" Control="TextEditor" Editable="true" Description="撤销工作项通用名称"/>
			<Property Key="RevokeTrigger" Caption="撤销事件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Description="节点撤销事件"/>
			<Property Key="IsSync" Caption="同步" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true"/>
			
			<!-- 待处理 -->
			<Property Key="Image" Caption="默认图片" Control="TextEditor" Node="NodeGraphic" Group="图形属性"/>
			<Property Key="LastImage" Caption="当前图片" Control="TextEditor" Node="NodeGraphic" Group="图形属性"/>
			<Property Key="PastImage" Caption="通过图片" Control="TextEditor" Node="NodeGraphic" Group="图形属性"/>
			
			<Property Key="X" Caption="X" Control="NumberEditor" Node="NodeGraphic" Visible="false" Group="图形属性" Editable="false"/>
			<Property Key="Y" Caption="Y" Control="NumberEditor" Node="NodeGraphic" Visible="false" Group="图形属性" Editable="false"/>
			<Property Key="Width" Caption="宽度" Control="NumberEditor" Node="NodeGraphic" Group="图形属性"/>
			<Property Key="Height" Caption="高度" Control="NumberEditor" Node="NodeGraphic" Group="图形属性"/>
		</PropertyCollection>
	</Define>
	
	
	<!-- 事件 -->
	<Define Key="Event" Extends="Node"/>	
	<!-- 属性: 开始事件 -->
	<Define Key="Begin" Caption="起始事件" Extends="Event">
		<PropertyCollection>
			<Property Key="Status" Caption="开始状态" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey(), GetWorkflowKey())" Editable="true"/>
		</PropertyCollection>
	</Define>
	<!-- 属性: 状态标志、工作项创建事件、工作项完成事件、权限设置、绑定字段标志、绑定字段值、工作项撤销条件 -->
	<Define Key="State" Caption="状态节点" Extends="Event">
		<PropertyCollection>
			<Property Key="Status" Caption="状态标志" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey(), GetWorkflowKey())"/>
			<Property Key="CreateTrigger" Caption="创建事件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true"/>
			<Property Key="FinishTrigger" Caption="完成事件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true"/>
			<Property Key="Perm" Type="Collection" Caption="权限设置" DefaultValue="=GetPermShowText()" Control="ButtonEditor" OnButtonClick="Macro_ShowPermDialog()" Editable="true" UpdateAttributeOnly="true"/>
			<Property Key="ParticipatorCollection" Type="Collection" Caption="参与者集合" DefaultValue="=GetCollectionShowText('ParticipatorCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowParticipatorCollectionDialog(GetSelectNodeXml('ParticipatorCollection'))" Editable="true" Description="参与者集合" Group="审批属性"  />
		    <Property Key="FieldKey" Caption="绑定字段" Control="Combobox" OnInitialize="=Macro_GetStatusFieldList(GetWorkflowFormKey())"/>
			<Property Key="FieldValue" Caption="绑定字段值" Control="Combobox" OnInitialize="=Macro_GetStatusValueList(GetWorkflowFormKey())"/>
			<Property Key="RevokeCondition" Caption="撤销条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true"/>
		</PropertyCollection>
	</Define>
	<!-- 属性: 分支结束事件 -->
	<Define Key="BranchEnd" Caption="分支结束" Extends="Event"/>
	<!-- 属性: 结束事件 -->
	<Define Key="End" Caption="结束事件" Extends="Event">
		<PropertyCollection>
		<Property Key="Status" Caption="结束状态" Control="Combobox" OnInitialize="=Macro_GetStatusList(GetWorkflowFormKey(), GetWorkflowKey())" Editable="true"/>
		</PropertyCollection>
	</Define>
	
	<!-- 网关 -->
	<Define Key="BaseGateWay" Caption="网关" Extends="Node"/>
	<Define Key="Join" Caption="合并网关" Extends="BaseGateWay"/>
	<Define Key="Fork" Caption="分支网关" Extends="BaseGateWay"/>
	<Define Key="ExclusiveFork" Caption="互斥网关" Extends="BaseGateWay"/>
	<Define Key="ComplexJoin" Caption="复合网关" Extends="BaseGateWay">
		<PropertyCollection>
			<Property Key="JoinCount" Caption="合并数量" Control="NumberEditor" DefaultValue="0" Group="复合网关"/>
			<Property Key="JoinCondition" Type="CDATA" Caption="合并条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Group="复合网关" Description="合并条件"/>
		</PropertyCollection>
	</Define>
	<Define Key="Decision" Caption="选择网关" Extends="BaseGateWay">
		<PropertyCollection>
			<Property Key="Condition" Caption="选择条件" Control="TempButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Description="选择条件"/>
		</PropertyCollection>
	</Define>
	<Define Key="GateWay" Caption="路由网关" Extends="BaseGateWay">
		<PropertyCollection>
			<Property Key="Condition" Caption="流转条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Description="流转条件"/>
		</PropertyCollection>
	</Define>
	
	<!-- 活动 -->
	<Define Key="Activity" Caption="工作项" Extends="Node"></Define>
	<Define Key="ManualTask" Caption="人工任务" Icon="&#xe923;" Extends="Activity"></Define>
	
	<Define Key="Task" Caption="任务" Extends="Activity">
		<PropertyCollection>
			<!-- 待处理 -->
			<Property Key="TimerItemCollection" Type="Collection" Caption="超时设置" DefaultValue="=GetCollectionShowText('TimerItemCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowTimerItemCollectionDialog(GetSelectNodeXml('TimerItemCollection'))" Editable="true" Description="用户超时集合"/>
			<Property Key="RevokeCondition" Caption="撤销条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true"/>
			<Property Key="CreateTrigger" Caption="工作项创建事件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Description=""/>
			<Property Key="FinishTrigger" Caption="工作项完成事件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Description=""/>
			<Property Key="AutoIgnoreNoParticipator" Caption="无参与者略过" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true" Description="无参与者自动略过"/>
			<Property Key="AutoCommitContainSameParticipator" Caption="包含来源参与者自动提交" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true" Description="包含上一参与者自动略过"/>
			<Property Key="AutoCommitSameParticipator" Caption="等于来源参与者自动提交" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true" Description="等于上一参与者自动略过"/>
			<Property Key="Perm" Type="Collection" Caption="权限设置" DefaultValue="=GetPermShowText()" Control="ButtonEditor" OnButtonClick="Macro_ShowPermDialog()" Editable="true" UpdateAttributeOnly="true"/>
			<Property Key="OperationCollection" Type="Collection" Caption="操作集合"  DefaultValue="=GetCollectionShowText('OperationCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowOperationCollectionDialog(GetSelectNodeXml('OperationCollection'))" Editable="true" Description="操作集合"/>
			<Property Key="AssistanceCollection" Type="Collection" Caption="辅助节点集合" DefaultValue="=GetCollectionShowText('AssistanceCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowAssistanceCollectionDialog(GetSelectNodeXml('AssistanceCollection'))" Editable="true" Description="辅助节点集合"/>
			<Property Key="ParticipatorCollection" Type="Collection" Caption="参与者集合" DefaultValue="=GetCollectionShowText('ParticipatorCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowParticipatorCollectionDialog(GetSelectNodeXml('ParticipatorCollection'))" Editable="true" Description="参与者集合"/>
		</PropertyCollection>
	</Define>
	
	<Define Key="ServiceTask" Caption="系统任务" Icon="&#xe609;" Extends="Node">
		<PropertyCollection>
			<!-- 待处理 -->
			<Property Key="Action" Type="CDATA" Caption="操作" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Description=""/>
		</PropertyCollection>
	</Define>
	
	<Define Key="UserTask" Caption="用户任务" Icon="&#xe7f1;" Extends="Task"></Define>
	
	<Define Key="Audit" Caption="审批任务" Icon="&#xe656;" Extends="Task">
		<PropertyCollection>
			<Property Key="DenyToLastNode" Caption="驳回上一步" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false" Editable="true"/>
			<Property Key="DenyNodeKey" Caption="驳回目标节点" Control="Combobox" OnInitialize="=ListWorkflowNodes()" Visible="GetPropertyValue('DenyToLastNode', 'false')=='false'" Editable="true"/>
		</PropertyCollection>
	</Define>
	
    <Define Key="DataMap" Caption="映射任务" Icon="&#xe6bd;" Extends="Task">
    	<PropertyCollection>
    		<Property Key="MidDataMap" Caption="中间层映射" Control="Combobox" OnInitialize="{list.boolean}" DefaultValue="false" Editable="true"/>
    		<Property Key="SyncTriggerType" Caption="同步机制" Control="Combobox" OnInitialize="NoOpt,无操作;BillSave,数据保存;InstanceStart,实例启动;Async,实例结束" DefaultValue="NoOpt" Editable="true"/>
			<Property Key="DataMapCondition" Caption="完成条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true"/>
			<Property Key="BillDataMapInfoCollection" Type="Collection" Caption="映射集合" DefaultValue="=GetCollectionShowText('BillDataMapInfoCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowBillDataMapInfoCollectionDialog(GetSelectNodeXml('BillDataMapInfoCollection'))" Editable="true"/>
		</PropertyCollection>
    </Define>
    
	<Define Key="Countersign" Caption="会签任务" Icon="&#xe6bd;" Extends="Task">
	<PropertyCollection>
		<Property Key="FinishType" Caption="完成类型" Control="Combobox" OnInitialize="{bpmn.countersign.condition.type}" Editable="true"/>
		<Property Key="FinishCondition" Caption="完成条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Visible="GetPropertyValue('FinishType', 'None')=='Custom'" Editable="true"/>
		<Property Key="FinishCondition" Caption="完成条件" Control="TextEditor" Visible="GetPropertyValue('FinishType', 'None')=='Proportion'" Editable="true"/>		
		<Property Key="FinishCondition" Caption="完成条件" Control="NumberEditor" Visible="GetPropertyValue('FinishType', 'None')=='Number'" Editable="true"/>		
		<Property Key="FinishCondition" Caption="完成条件" Control="TextEditor" Visible="GetPropertyValue('FinishType', 'None')=='None'" Editable="false"/>
		<Property Key="ValidType" Caption="成立类型" Control="Combobox" OnInitialize="{bpmn.countersign.condition.type}" Editable="true"/>
		<Property Key="ValidCondition" Caption="成立条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Visible="GetPropertyValue('ValidType', 'None')=='Custom'" Editable="true"/>
		<Property Key="ValidCondition" Caption="成立条件" Control="TextEditor" Visible="GetPropertyValue('ValidType', 'None')=='Proportion'" Editable="true"/>		
		<Property Key="ValidCondition" Caption="成立条件" Control="NumberEditor" Visible="GetPropertyValue('ValidType', 'None')=='Number'" Editable="true"/>		
		<Property Key="ValidCondition" Caption="成立条件" Control="TextEditor" Visible="GetPropertyValue('ValidType', 'None')=='None'" Editable="false"/>
		<Property Key="PassType" Caption="通过类型" Control="Combobox" OnInitialize="{bpmn.countersign.condition.type}" Editable="true"/>
		<Property Key="PassCondition" Caption="通过条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Visible="GetPropertyValue('PassType', 'None')=='Custom'" Editable="true"/>
		<Property Key="PassCondition" Caption="通过条件" Control="TextEditor" Visible="GetPropertyValue('PassType', 'None')=='Proportion'" Editable="true"/>		
		<Property Key="PassCondition" Caption="通过条件" Control="NumberEditor" Visible="GetPropertyValue('PassType', 'None')=='Number'" Editable="true"/>		
		<Property Key="PassCondition" Caption="通过条件" Control="TextEditor" Visible="GetPropertyValue('PassType', 'None')=='None'" Editable="false"/>
	</PropertyCollection>
</Define>
	
	<Define Key="MultiUserTask" Caption="多人任务" Icon="&#xe61b;" Extends="UserTask">
		 <PropertyCollection>
		 	<Property Key="InOrder" Caption="顺序执行" Control="Combobox" OnInitialize="{list.boolean}" Editable="true"/>
		</PropertyCollection>
	</Define>
	
    <Define Key="MultiAudit" Caption="多人审批" Icon="&#xe602;" Extends="Audit"></Define>
    
	<Define Key="StateAction" Caption="状态机" Icon="&#xe603;" Extends="Activity">
		<PropertyCollection>
			<Property Key="ParticipatorCollection" Type="Collection" Caption="参与者集合" DefaultValue="=GetCollectionShowText('ParticipatorCollection')" Control="ButtonEditor" OnButtonClick="Macro_ShowParticipatorCollectionDialog(GetSelectNodeXml('ParticipatorCollection'))" Editable="true" Description="参与者集合"/>
			<Property Key="RevokeCondition" Caption="撤销条件" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true"/>
			<Property Key="Operation" Type="Collection" Caption="操作"  DefaultValue="=GetCollectionShowText('Operation')" Control="ButtonEditor" OnButtonClick="Macro_ShowOperationDialog('<OperationCollection>' + IIF(GetSelectNodeXml('Operation') == '', '<Operation/>', GetSelectNodeXml('Operation')) + '</OperationCollection>')" Editable="true" Description="操作"/>

			<!--<Property Key="Key" Caption="操作标志" Control="TextEditor" Node="Operation" Group="公共操作" Editable="true"/>
			<Property Key="Caption" Caption="操作名称" Control="TextEditor" Node="Operation" Group="公共操作" Editable="true"/>
			<Property Key="Enable" Caption="可用性" Control="ButtonEditor" Node="Operation" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Group="公共操作" Editable="true"/>
			<Property Key="Visible" Caption="可见性" Control="ButtonEditor" Node="Operation" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Group="公共操作" Editable="true"/>
			<Property Key="Icon" Caption="图标" Control="ButtonEditor" Node="Operation" OnInitialize="{input.image}" Group="公共操作" Editable="true"/>
			<Property Key="TemplateKey" Caption="模板标志" Control="TextEditor" Node="Operation" Group="公共操作" Editable="true"/>
			<Property Key="Action" Type="CDATA" Caption="行为" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true" Group="公共操作" Description=""/> -->
		</PropertyCollection>
	</Define>
	
	<Define Key="SubProcess" Caption="子流程" Extends="Task">
		<PropertyCollection>
			<Property Key="SyncMode" Caption="执行顺序" Control="Combobox" DefaultValue="Sync" OnInitialize="Sync,同步;Async,异步" Editable="true"/>
			<Property Key="AutoStartAction" Caption="自动开始" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})" Editable="true"/>
			<Property Key="SubProcessKey" Caption="子流程标志" Control="Combobox" OnInitialize="=Macro_GetWorkflowKeyList()" Editable="true"/>
		</PropertyCollection>
	</Define>
	
	<Define Key="Inline" Caption="内联流程" Extends="Activity">
		<PropertyCollection>
			<Property Key="InlineProcessKey" Caption="内联流程标志" Control="Combobox" OnInitialize="=Macro_GetWorkflowKeyList()" Editable="true"/>
		</PropertyCollection>
	</Define>
</DefineCollection>
</BPMN>`;
const _WfDevPropertyDefine = class _WfDevPropertyDefine2 extends AbstractPropertyDefine {
  constructor() {
    super(new PropertyManager(BPMN.PROPERTIES_XML_DEV));
  }
  static getInstance() {
    return _WfDevPropertyDefine2.instance;
  }
};
_WfDevPropertyDefine.instance = new _WfDevPropertyDefine();
let WfDevPropertyDefine = _WfDevPropertyDefine;
class DomUtil {
  static parseEls(sHtml) {
    var objE = document.createElement("div");
    objE.innerHTML = sHtml.trim();
    return objE.childNodes;
  }
  static parseEl(sHtml) {
    var els = this.parseEls(sHtml);
    return els[0];
  }
  static findParentElByTagName(el, tagName) {
    var tmpEl = el;
    while (tmpEl != null && tmpEl.tagName != "BODY") {
      if (tmpEl.tagName == tagName) {
        break;
      }
      tmpEl = tmpEl.parentElement;
    }
    return tmpEl;
  }
  static findParentElByClassName(el, clsName) {
    var tmpEl = el;
    while (tmpEl != null && tmpEl.tagName != "BODY") {
      if (tmpEl.classList.contains(clsName)) {
        break;
      }
      tmpEl = tmpEl.parentElement;
    }
    return tmpEl;
  }
  static isInDialog(el) {
    if (!el.parentElement) {
      return false;
    } else if (el.classList.contains("dialog") || el.classList.contains("CodeMirror-hints")) {
      return true;
    }
    return DomUtil.isInDialog(el.parentElement);
  }
  // 获取 当前 滚动条的长度， 水平 && 垂直方向
  static getScrollPosition() {
    let x, y;
    if (!!window.pageXOffset) {
      x = window.pageXOffset;
      y = window.pageYOffset;
    } else {
      x = (document.documentElement || document.body.parentNode || document.body).scrollLeft;
      y = (document.documentElement || document.body.parentNode || document.body).scrollTop;
    }
    return { x, y };
  }
  // 获取 dom 到视口左侧和顶部的相对位置
  static offsetViewPosition(el) {
    let rect = el.getBoundingClientRect();
    return {
      offsetViewLeft: rect.left,
      offsetViewTop: rect.top
    };
  }
  // 相对于body的偏移量
  static offsetBodyPosition(el) {
    let { x, y } = DomUtil.getScrollPosition();
    let { offsetViewLeft, offsetViewTop } = DomUtil.offsetViewPosition(el);
    return {
      offsetBodyLeft: offsetViewLeft + x,
      offsetBodyTop: offsetViewTop + y
    };
  }
  static offset(fromEl, toEl) {
    let fromOffset = DomUtil.offsetBodyPosition(fromEl);
    let toOffset = DomUtil.offsetBodyPosition(toEl);
    return {
      offsetLeft: fromOffset.offsetBodyLeft - toOffset.offsetBodyLeft,
      offsetTop: fromOffset.offsetBodyTop - toOffset.offsetBodyTop
    };
  }
  static offsetParent(fromEl) {
    var parent = fromEl.parentElement ? fromEl.parentElement : document.body;
    return DomUtil.offset(fromEl, parent);
  }
  static queryElement(container, el) {
    if (container == null || el == null)
      return null;
    if (container.getEl() == el) {
      return container;
    }
    if (container.getChildren() != null) {
      var findResult = null;
      for (let child of container.getChildren()) {
        findResult = DomUtil.queryElement(child, el);
        if (findResult != null) {
          return findResult;
        }
      }
    }
    return null;
  }
}
class BaseStyleFactory {
  getIcon() {
    return "layui-icon";
  }
  getBpmWorkspace() {
    return ["djs-container"];
  }
  getToolBox() {
    return ["djs-palette"];
  }
  getToolboxSeparator() {
    return ["separator"];
  }
  getPropertyPanel() {
    return ["property-pane"];
  }
  getToolbar() {
    return ["bpm-toolbar"];
  }
  getList() {
    return ["component-list"];
  }
  getToolbarSeparator() {
    return ["vr"];
  }
  getTabPaneSkin() {
    return {
      tab: "layui-tab",
      tab_title: "layui-tab-title",
      //tab_content: "layui-tab-content",
      tab_content: "",
      tab_item: "layui-tab-item",
      tab_nav_this: "layui-this",
      tab_close: "layui-tab-close"
    };
  }
  getMenuStyle() {
    return {
      menu: "cmd-change-menu__overlay",
      menu_header: "cmd-change-menu__header",
      menu_title: "cmd-change-menu__title",
      menu_body: "cmd-change-menu__body",
      menu_group: "cmd-change-menu__results",
      menu_item: "cmd-change-menu__entry",
      menu_item_content: "md-change-menu__entry-content",
      menu_item_caption: "cmd-change-menu__name"
    };
  }
  getTableSkin() {
    return {
      table: "layui-table",
      table_view: "layui-table-view",
      table_box: "layui-table-box",
      table_header: "layui-table-header",
      table_cell: "layui-table-cell",
      table_body: "layui-table-body",
      table_main: "layui-table-main",
      table_page: "layui-table-page"
    };
  }
  getCheckboxSkin() {
    return {
      checkbox: "el-checkbox",
      checkbox_input: "el-checkbox__input",
      checkbox_inner: "el-checkbox__inner",
      checkbox_original: "el-checkbox__original",
      checkbox_label: "el-checkbox__label"
    };
  }
  getCollapseSkin() {
    return {
      collapse: "yg_collapse",
      collapse_text: "yg_collapse_text"
    };
  }
  getPrintSkin() {
    return {
      print_board: "print-board",
      print_paper: "print_paper",
      print_page: "print_page",
      print_grid: "print-grid",
      print_section: "print-section",
      print_row: "print-row",
      print_cell: "print-cell",
      print_v_ruler: "v_ruler",
      print_h_ruler: "h_ruler"
    };
  }
  getExcelSkin() {
    return {
      excel_board: "excel-board",
      excel_paper: "excel",
      excel_page: "excel",
      excel_grid: "excel-grid",
      excel_section: "excel-section",
      excel_row: "excel-row",
      excel_cell: "excel-cell"
    };
  }
  getTreeSkin() {
    return {
      tree: "yg-tree",
      tree_item: "yg-tree-item",
      tree_item_node: "yg-tree-node"
    };
  }
}
const _StyleFactoryMananger = class _StyleFactoryMananger2 {
  constructor() {
    this.styleFactory = new BaseStyleFactory();
  }
  getStyleFactory() {
    return this.styleFactory;
  }
  static getInstance() {
    return _StyleFactoryMananger2.instance;
  }
};
_StyleFactoryMananger.instance = new _StyleFactoryMananger();
let StyleFactoryMananger = _StyleFactoryMananger;
class HtmlXElement {
  constructor(data) {
    if (data instanceof Element) {
      this.htmlElement = data;
    } else {
      this.htmlElement = document.createElement(data);
    }
  }
  click() {
    this.getHtmlElement().click();
  }
  getHtmlElement() {
    return this.htmlElement;
  }
  setInnerText(text) {
    this.htmlElement.innerText = text;
  }
  getInnerText() {
    return this.htmlElement.innerText;
  }
  setAttribute(name, value2) {
    this.htmlElement.setAttribute(name, value2);
  }
  getAttribute(name) {
    return this.htmlElement.getAttribute(name);
  }
  removeAttribute(name) {
    this.getHtmlElement().removeAttribute(name);
  }
  setStyle(key2, value2) {
    this.htmlElement.style[key2] = value2;
  }
  addClass(cls) {
    this.htmlElement.classList.add(cls);
  }
  removeClass(cls) {
    this.htmlElement.classList.remove(cls);
  }
  toggleClass(cls) {
    this.htmlElement.classList.toggle(cls);
  }
  hasClass(cls) {
    return this.htmlElement.classList.contains(cls);
  }
  contains(child) {
    return this.htmlElement.contains(child.getHtmlElement());
  }
  appendChild(child) {
    this.getHtmlElement().appendChild(child.getHtmlElement());
  }
  appendTo(parent) {
    parent.getHtmlElement().appendChild(this.getHtmlElement());
  }
  removeChild(child) {
    this.htmlElement.removeChild(child.getHtmlElement());
  }
  addEventListener(name, fun, useCapture) {
    this.htmlElement.addEventListener(name, fun, useCapture);
  }
  removeEventListener(name, fun, useCapture) {
    this.htmlElement.removeEventListener(name, fun, useCapture);
  }
  blur() {
    this.htmlElement.blur();
  }
  parentEl() {
    if (!this.htmlElement.parentElement)
      return null;
    return new HtmlXElement(this.htmlElement.parentElement);
  }
  focus() {
    this.htmlElement.focus();
  }
  getImpl() {
    return this.htmlElement;
  }
  getScrollTop() {
    return this.getHtmlElement().scrollTop;
  }
  setScrollTop(top) {
    this.getHtmlElement().scrollTop = top;
  }
  getScrollLeft() {
    return this.getHtmlElement().scrollLeft;
  }
  setScrollLeft(left) {
    this.getHtmlElement().scrollLeft = left;
  }
  getNodeType() {
    return this.getHtmlElement().nodeType;
  }
  getOffsetLeft() {
    return this.getHtmlElement().offsetLeft;
  }
  getOffsetTop() {
    return this.getHtmlElement().offsetTop;
  }
  getHtmlClientHeight() {
    return this.getHtmlElement().clientHeight;
  }
  getHtmlClientWidth() {
    return this.getHtmlElement().clientWidth;
  }
  getHtmlOffsetWidth() {
    return this.getHtmlElement().offsetWidth;
  }
  getBoundingClientRect() {
    return this.getHtmlElement().getBoundingClientRect();
  }
  setOncontextmenu(fn) {
    this.getHtmlElement().oncontextmenu = fn;
  }
  getChildren() {
    var children = [];
    var len = this.getHtmlElement().childNodes.length;
    for (var i = 0; i < len; i++) {
      var child = this.getHtmlElement().childNodes[i];
      children.push(new HtmlXElement(child));
    }
    return children;
  }
}
class AbstractDomElement {
  constructor(initEl) {
    this.styleFactory = StyleFactoryMananger.getInstance().getStyleFactory();
    this.children = [];
    let tmpEl = initEl || this.createEl();
    if (tmpEl instanceof Element) {
      this.xEl = new HtmlXElement(tmpEl);
    } else {
      this.xEl = tmpEl;
    }
  }
  createEl(tag = "div") {
    return new HtmlXElement(tag);
  }
  setID(id) {
    this.setStyle("id", id);
  }
  setText(caption) {
    this.xEl.setInnerText(caption);
  }
  getText() {
    return this.xEl.getInnerText();
  }
  setAttr(name, value2) {
    this.xEl.setAttribute(name, value2);
  }
  getAttr(name) {
    return this.xEl.getAttribute(name);
  }
  setStyleHeight(height) {
    this.setStyle("height", height.toString());
  }
  setStyleWidth(width) {
    this.setStyle("width", width.toString());
  }
  setStyle(key2, value2) {
    this.xEl.setStyle(key2, value2);
  }
  setStyles(styles) {
    for (var key2 in styles) {
      this.setStyle(key2, styles[key2]);
    }
  }
  addClass(cls) {
    if (cls) {
      this.xEl.addClass(cls);
    }
  }
  addClassArray(clsArray = []) {
    for (let c of clsArray) {
      this.addClass(c);
    }
  }
  removeClass(cls) {
    this.xEl.removeClass(cls);
  }
  toggleClass(cls) {
    this.xEl.toggleClass(cls);
  }
  hasClass(cls) {
    return this.xEl.hasClass(cls);
  }
  getEl() {
    return this.xEl.getHtmlElement();
  }
  parentEl() {
    if (!this.getEl().parentElement)
      return null;
    return this.getEl().parentElement;
  }
  addChild(child) {
    if (child) {
      this.children.push(child);
      this.mountChild(child);
    }
  }
  removeChild(child) {
    if (child) {
      var index = this.children.indexOf(child);
      if (index >= 0) {
        this.children.splice(index, 1);
      }
      this.unmountChild(child);
    }
  }
  getChildAt(index) {
    return this.children[index];
  }
  getChildren() {
    return this.children;
  }
  getChildCount() {
    return this.children.length;
  }
  clearChildren() {
    for (let child of this.children) {
      this.unmountChild(child);
    }
    this.children = [];
  }
  render(parentEl) {
    if (!parentEl.contains(this.getEl())) {
      parentEl.appendChild(this.getEl());
    }
  }
  hasChild(child) {
    if (this.children == null)
      return false;
    return this.children.indexOf(child) > -1;
  }
  mountChild(child) {
    if (child && !this.xEl.getHtmlElement().contains(child.getEl())) {
      this.xEl.getHtmlElement().appendChild(child.getEl());
    }
  }
  unmountChild(child) {
    if (child && this.xEl.getHtmlElement().contains(child.getEl())) {
      this.xEl.getHtmlElement().removeChild(child.getEl());
    }
  }
  addEventListener(name, fun, useCapture = false) {
    this.xEl.addEventListener(name, fun, useCapture);
  }
  removeEventListener(name, fun, useCapture = false) {
    this.xEl.removeEventListener(name, fun, useCapture);
  }
  hover(funOver, funOut) {
    this.xEl.addEventListener("mouseover", funOver, false);
    this.xEl.addEventListener("mouseout", funOut, false);
  }
  findElement(el) {
    if (!el) {
      return null;
    }
    if (this.getEl() == el) {
      return this;
    }
    if (this.getChildren() != null) {
      for (let child of this.getChildren()) {
        var find = child.findElement(el);
        if (find != null)
          return find;
      }
    }
    return null;
  }
  markSelect(b) {
    b ? this.addClass("selected") : this.removeClass("selected");
  }
  resize(width, height) {
  }
  fireResized(width, height) {
  }
  blur() {
    this.getEl().blur();
  }
  getScrollTop() {
    return this.xEl.getScrollTop();
  }
  setScrollTop(top) {
    this.xEl.setScrollTop(top);
  }
  getScrollLeft() {
    return this.xEl.getScrollLeft();
  }
  setScrollLeft(left) {
    this.xEl.setScrollLeft(left);
  }
  getNodeType() {
    return this.xEl.getNodeType();
  }
  getOffsetLeft() {
    return this.xEl.getOffsetLeft();
  }
  getOffsetTop() {
    return this.xEl.getOffsetTop();
  }
  getHtmlClientHeight() {
    return this.xEl.getHtmlClientHeight();
  }
  getHtmlClientWidth() {
    return this.xEl.getHtmlClientWidth();
  }
  getHtmlOffsetWidth() {
    return this.xEl.getHtmlOffsetWidth();
  }
  getBoundingClientRect() {
    return this.xEl.getBoundingClientRect();
  }
  setOncontextmenu(fn) {
    this.xEl.setOncontextmenu(fn);
  }
  appendTo(parent) {
    parent.appendChild(this.getEl());
  }
  display(parent) {
  }
}
class ButtonElement extends AbstractDomElement {
  constructor(text = "") {
    super();
    this.setText(text);
  }
  createEl() {
    return document.createElement("button");
  }
}
class DivElement extends AbstractDomElement {
  constructor() {
    super();
  }
}
let InputElement$1 = class InputElement2 extends AbstractDomElement {
  createEl() {
    return document.createElement("input");
  }
  getValue() {
    var input = this.getEl();
    return input.value;
  }
  setValue(value2) {
    var input = this.getEl();
    input.value = value2;
  }
  setPlaceholder(placehoder) {
    var input = this.getEl();
    input.placeholder = placehoder;
  }
};
class SpanElement extends AbstractDomElement {
  constructor(caption = "") {
    super();
    this.setText(caption);
  }
  setValue(caption) {
    this.setText(caption);
  }
  createEl() {
    return document.createElement("span");
  }
}
class JComponent {
  constructor(domElement) {
    this.styleFactory = StyleFactoryMananger.getInstance().getStyleFactory();
    this.width = SizeInfo.AUTO_SIZE;
    this.height = SizeInfo.AUTO_SIZE;
    this.x = -1;
    this.y = -1;
    this.xspan = 1;
    this.yspan = 1;
    this.domElement = domElement;
  }
  setKey(key2) {
    this.key = key2;
  }
  getKey() {
    return this.key;
  }
  setTitle(title) {
    this.getEl().setAttribute("title", title);
  }
  setWidth(width) {
    this.width = width;
    this.getDomElement().setStyleWidth(width);
  }
  getWidth() {
    return this.width;
  }
  setHeight(height) {
    this.height = height;
    this.getDomElement().setStyleHeight(height);
  }
  getHeight() {
    return this.height;
  }
  getHeightValue() {
    return this.height ? this.height.getValue() : 0;
  }
  setText(text) {
    this.getDomElement().setText(text);
  }
  getShowText() {
    return this.getDomElement().getText();
  }
  getX() {
    return this.x;
  }
  setX(x) {
    this.x = x;
  }
  getXSpan() {
    return this.xspan;
  }
  setXSpan(xspan) {
    this.xspan = xspan;
  }
  getY() {
    return this.y;
  }
  setY(y) {
    this.y = y;
  }
  getYSpan() {
    return this.yspan;
  }
  setYSpan(yspan) {
    this.yspan = yspan;
  }
  setLocation(x, y, xSpan = 1, ySpan = 1) {
    this.setX(x);
    this.setY(y);
    this.setXSpan(xSpan);
    this.setYSpan(ySpan);
  }
  addClass(cls) {
    this.getDomElement().addClass(cls);
  }
  addClassArray(clsArray = []) {
    this.getDomElement().addClassArray(clsArray);
  }
  removeClass(cls) {
    this.getDomElement().removeClass(cls);
  }
  addEventListener(name, fun, useCapture = false) {
    this.getDomElement().addEventListener(name, fun, useCapture);
  }
  removeEventListener(name, fun, useCapture = false) {
    this.getDomElement().removeEventListener(name, fun, useCapture);
  }
  getDomElement() {
    return this.domElement;
  }
  getEl() {
    return this.domElement.getEl();
  }
  /**
   * 挂载
   * @param child
   */
  mountChild(child) {
    child && this.getDomElement().addChild(child.getDomElement());
  }
  unmountChild(child) {
    child && this.getDomElement().removeChild(child.getDomElement());
  }
  setDisplay(visible) {
    this.getDomElement().setStyle("display", visible ? "block" : "none");
  }
  unmountAll() {
    this.getDomElement().clearChildren();
  }
  setStyle(key2, value2) {
    this.domElement.setStyle(key2, value2);
  }
  resize(width, height) {
    this.setWidth(SizeInfo.valueOfPX(width));
    this.setHeight(SizeInfo.valueOfPX(height));
  }
  render(parentEl) {
    this.domElement.render(parentEl);
  }
  display() {
  }
  fireResized(width, height) {
  }
  lostFocus() {
  }
}
class AbstractControl extends JComponent {
  constructor(element) {
    super(element);
    this.getDomElement().addEventListener("change", (event) => {
      this.fnOnValueChange && this.fnOnValueChange(this);
    });
  }
  initControl(initialValue) {
  }
  setOnButtonClick(fn) {
  }
  setOnValueChanged(fn) {
    this.fnOnValueChange = fn;
  }
  setEditable(editable) {
  }
  setValue(value2) {
    this.value = value2;
  }
  getValue() {
    return this.value;
  }
  getShowText() {
    return this.value;
  }
  setShowText(showText) {
  }
  caretLast() {
  }
  getInputDomElement() {
    return this.getDomElement();
  }
}
class SpanIcon extends AbstractDomElement {
  constructor(cls) {
    super();
    this.addClass(cls);
  }
  createEl() {
    return document.createElement("span");
  }
}
class DownArrow extends AbstractControl {
  constructor() {
    super(new ButtonElement());
    this.setStyle("padding", "0px");
    var downArrow = new SpanIcon("iconfont");
    downArrow.addClass("icon-xiajiantou-cu");
    this.getDomElement().addChild(downArrow);
  }
}
class TextEditor extends AbstractControl {
  constructor() {
    super(new InputElement$1());
    this.setStyle("border", "0px");
    this.setStyle("outline", "none");
  }
  createEl() {
    return document.createElement("input");
  }
  setPlaceholder(placeholder) {
    this.getDomElement().setPlaceholder(placeholder);
  }
  setValue(value2) {
    super.setValue(value2);
    var inputEl = this.getEl();
    inputEl.value = value2;
  }
  getValue() {
    var inputEl = this.getEl();
    return inputEl.value;
  }
  getShowText() {
    return this.getValue();
  }
  setShowText(showText) {
  }
  setEditable(editable) {
    var inputEl = this.getEl();
    if (editable) {
      inputEl.removeAttribute("readonly");
    } else {
      inputEl.setAttribute("readonly", "true");
    }
  }
  caretLast() {
    var el = this.getEl();
    var pos = this.getShowText() ? this.getShowText().length : 0;
    if (el.setSelectionRange) {
      el.focus();
      el.setSelectionRange(pos, pos);
    }
  }
  setAttr(name, value2) {
    this.getEl().setAttribute(name, value2);
  }
}
class ColorEditor extends AbstractControl {
  constructor() {
    super(new SpanElement());
    this.textEditor = new TextEditor();
    this.button = new DownArrow();
    this.getDomElement().addChild(this.textEditor.getDomElement());
    this.getDomElement().addChild(this.button.getDomElement());
    this.colorContainer = new ColorContainer$2();
    var self = this;
    this.button.addEventListener("click", function(event) {
      self.colorContainer.setValue(self.getValue());
      self.getDomElement().addChild(self.colorContainer);
      var { offsetBodyLeft, offsetBodyTop } = DomUtil.offsetBodyPosition(self.button.getEl());
      console.log(offsetBodyLeft + ":" + offsetBodyTop);
    }, true);
    this.colorContainer.addEventListener("click", (e) => {
      var el = e.target;
      if (el.classList.contains("color_cancel")) {
        self.getDomElement().removeChild(self.colorContainer);
      } else if (el.classList.contains("color_clear")) {
        self.setValue("");
        self.getDomElement().removeChild(self.colorContainer);
        this.onValueChangeFunc && this.onValueChangeFunc(this);
      } else if (el.classList.contains("color_confirm")) {
        self.setValue(self.colorContainer.getValue());
        self.getDomElement().removeChild(self.colorContainer);
        this.onValueChangeFunc && this.onValueChangeFunc(this);
      }
    }, true);
  }
  setOnValueChanged(fn) {
    this.onValueChangeFunc = fn;
  }
  setValue(value2) {
    super.setValue(value2);
    this.textEditor.setValue(value2);
    this.textEditor.setStyle("background-color", value2);
  }
  getValue() {
    return this.textEditor.getValue();
  }
  setHeight(height) {
    this.textEditor.setHeight(height);
    this.button.setHeight(SizeInfo.valueOfPX(height.getValue() - 2));
  }
  setWidth(width) {
    var w = width.getValue();
    this.textEditor.setWidth(SizeInfo.valueOfPX(w - 27));
    this.button.setWidth(SizeInfo.valueOfPX(27));
  }
  lostFocus() {
    this.getDomElement().removeChild(this.colorContainer);
  }
}
let ColorItem$2 = class ColorItem2 extends AbstractDomElement {
  constructor(color) {
    super();
    this.color = color;
    this.addClass("property-color-item");
    this.setStyle("background", color);
    this.setStyle("width", "14px");
    this.setStyle("height", "14px");
    this.setStyle("margin", "1px");
    this.setStyle("cursor", "pointer");
    this.setStyle("border-width", "1px");
  }
  getColor() {
    return this.color;
  }
};
let ColorContainer$2 = class ColorContainer2 extends AbstractDomElement {
  constructor() {
    super();
    this.width = 310;
    this.colorDivWidth = 160;
    this.color_array = [
      "#ffffff",
      "#e5e4e4",
      "#d9d8d8",
      "#c0bdbd",
      "#a7a4a4",
      "#8e8a8b",
      "#827e7f",
      "#767173",
      "#5c585a",
      "#000000",
      "#fefcdf",
      "#fef4c4",
      "#feed9b",
      "#fee573",
      "#ffed43",
      "#f6cc0b",
      "#f6cc0b",
      "#c9a601",
      "#ad8e00",
      "#8c7301",
      "#ffded3",
      "#ffc4b0",
      "#ff9d7d",
      "#ff7a4e",
      "#ff6600",
      "#e95d00",
      "#d15502",
      "#ba4b01",
      "#a44201",
      "#8d3901",
      "#ffd2d0",
      "#ffbab7",
      "#fe9a95",
      "#ff7a73",
      "#ff483f",
      "#fe2419",
      "#f10b00",
      "#d40a00",
      "#940000",
      "#6d201b",
      "#ffdaed",
      "#ffb7dc",
      "#ffa1d1",
      "#ff84c3",
      "#ff57ac",
      "#fd1289",
      "#ec0078",
      "#d6006d",
      "#bb005f",
      "#9b014f",
      "#fcd6fe",
      "#fbbcff",
      "#f9a1fe",
      "#f784fe",
      "#f564fe",
      "#f546ff",
      "#f328ff",
      "#d801e5",
      "#c001cb",
      "#8f0197",
      "#e2f0fe",
      "#c7e2fe",
      "#add5fe",
      "#92c7fe",
      "#6eb5ff",
      "#48a2ff",
      "#2690fe",
      "#0162f4",
      "#013add",
      "#0021b0",
      "#d3fdff",
      "#acfafd",
      "#7cfaff",
      "#4af7fe",
      "#1de6fe",
      "#01deff",
      "#00cdec",
      "#01b6de",
      "#00a0c2",
      "#0084a0",
      "#edffcf",
      "#dffeaa",
      "#d1fd88",
      "#befa5a",
      "#a8f32a",
      "#8fd80a",
      "#79c101",
      "#3fa701",
      "#307f00",
      "#156200",
      "#d4c89f",
      "#daad88",
      "#c49578",
      "#c2877e",
      "#ac8295",
      "#c0a5c4",
      "#969ac2",
      "#92b7d7",
      "#80adaf",
      "#9ca53b"
    ];
    this.setStyle("position", "absolute");
    this.setStyle("z-index", "66666666");
    this.setStyle("width", this.width + "px");
    this.setStyle("height", "180px");
    this.setStyle("margin", "1px");
    this.setStyle("background-color", "#eee");
    this.setStyle("border", "solid 2px #ddd");
    this.setStyle("right", "0px");
    this.colorDiv = new DivElement();
    this.colorDiv.setStyle("display", "flex");
    this.colorDiv.setStyle("width", this.colorDivWidth + "px");
    this.colorDiv.setStyle("height", this.colorDivWidth + "px");
    this.colorDiv.setStyle("background-color", "#cec7c7");
    this.colorDiv.setStyle("flex-direction", "row");
    this.colorDiv.setStyle("flex-wrap", "wrap");
    this.colorDiv.setStyle("justify-content", "center");
    this.colorDiv.setStyle("align-items", "center");
    this.colorDiv.setStyle("margin-top", "8px");
    this.colorDiv.setStyle("margin-left", "8px");
    this.colorDiv.setAttr("tabindex", "0");
    this.colorDiv.addEventListener("click", (e) => {
      var el = e.target;
      if (el.classList.contains("property-color-item")) {
        var item = this.colorDiv.findElement(el);
        this.setValue(item.getColor());
      }
    });
    for (let color of this.color_array) {
      var colorItem = new ColorItem$2(color);
      this.colorDiv.addChild(colorItem);
    }
    this.addChild(this.colorDiv);
    let setLabelStyle = function(el) {
      el.setStyle("position", "absolute");
      el.setStyle("right", "85px");
      el.setStyle("height", "20px");
      el.setStyle("line-height", "20px");
    };
    let self = this;
    let setInputStyle = function(el) {
      el.setAttr("type", "number");
      el.setAttr("min", "0");
      el.setAttr("max", "255");
      el.setAttr("step", "1");
      el.setStyle("position", "absolute");
      el.setStyle("text-align", "center");
      el.setStyle("width", "60px");
      el.setStyle("height", "20px");
      el.setStyle("right", "15px");
      el.setStyle("padding-left", "15px");
      el.addEventListener("change", () => {
        self.inputChanged();
      });
    };
    let Color_R_Label = new SpanElement();
    setLabelStyle(Color_R_Label);
    Color_R_Label.setText("红色(R)");
    Color_R_Label.setStyle("top", "5px");
    this.addChild(Color_R_Label);
    this.Color_R_Input = new InputElement$1();
    setInputStyle(this.Color_R_Input);
    this.Color_R_Input.setStyle("top", "5px");
    this.addChild(this.Color_R_Input);
    let Color_G_Label = new SpanElement();
    setLabelStyle(Color_G_Label);
    Color_G_Label.setText("绿色(G)");
    Color_G_Label.setStyle("top", "30px");
    this.addChild(Color_G_Label);
    this.Color_G_Input = new InputElement$1();
    setInputStyle(this.Color_G_Input);
    this.Color_G_Input.setStyle("top", "30px");
    this.addChild(this.Color_G_Input);
    let Color_B_Label = new SpanElement();
    setLabelStyle(Color_B_Label);
    Color_B_Label.setText("蓝色(B)");
    Color_B_Label.setStyle("top", "55px");
    this.addChild(Color_B_Label);
    this.Color_B_Input = new InputElement$1();
    setInputStyle(this.Color_B_Input);
    this.Color_B_Input.setStyle("top", "55px");
    this.addChild(this.Color_B_Input);
    let Color_Opacity_Label = new SpanElement();
    setLabelStyle(Color_Opacity_Label);
    Color_Opacity_Label.setText("透 明 度");
    Color_Opacity_Label.setStyle("top", "80px");
    this.addChild(Color_Opacity_Label);
    this.Color_Opacity_Input = new InputElement$1();
    setInputStyle(this.Color_Opacity_Input);
    this.Color_Opacity_Input.setStyle("top", "80px");
    this.Color_Opacity_Input.setAttr("min", "0");
    this.Color_Opacity_Input.setAttr("max", "1");
    this.Color_Opacity_Input.setAttr("step", "0.1");
    this.addChild(this.Color_Opacity_Input);
    this.Selected_Color = new DivElement();
    this.Selected_Color.setStyle("position", "absolute");
    this.Selected_Color.setStyle("right", "90px");
    this.Selected_Color.setStyle("top", "105px");
    this.Selected_Color.setStyle("width", "40px");
    this.Selected_Color.setStyle("height", "40px");
    this.Selected_Color.setStyle("border", "solid 2px #999");
    this.addChild(this.Selected_Color);
    let Color_16Str_Label = new SpanElement();
    setLabelStyle(Color_16Str_Label);
    Color_16Str_Label.setText("十六进制值：");
    Color_16Str_Label.setStyle("top", "105px");
    Color_16Str_Label.setStyle("right", "12px");
    this.addChild(Color_16Str_Label);
    this.Color_16Str_Input = new InputElement$1();
    this.Color_16Str_Input.setStyle("position", "absolute");
    this.Color_16Str_Input.setStyle("top", "124px");
    this.Color_16Str_Input.setStyle("right", "10px");
    this.Color_16Str_Input.setStyle("width", "75px");
    this.Color_16Str_Input.setStyle("height", "20px");
    this.Color_16Str_Input.setStyle("text-align", "center");
    this.addChild(this.Color_16Str_Input);
    let setButtonStyle = function(el) {
      el.setStyle("position", "absolute");
      el.setStyle("top", "150px");
      el.setStyle("width", "36px");
      el.setStyle("height", "18px");
      el.setStyle("line-height", "14px");
    };
    let clearBtn = new ButtonElement();
    clearBtn.setText("清空");
    clearBtn.addClass("color_clear");
    setButtonStyle(clearBtn);
    clearBtn.setStyle("right", "95px");
    this.addChild(clearBtn);
    let cancelBtn = new ButtonElement();
    cancelBtn.setText("取消");
    cancelBtn.addClass("color_cancel");
    setButtonStyle(cancelBtn);
    cancelBtn.setStyle("right", "48px");
    this.addChild(cancelBtn);
    let confirmBtn = new ButtonElement();
    confirmBtn.setText("确认");
    confirmBtn.addClass("color_confirm");
    setButtonStyle(confirmBtn);
    confirmBtn.setStyle("right", "10px");
    this.addChild(confirmBtn);
  }
  inputChanged() {
    let R_Value = this.Color_R_Input.getValue();
    let G_Value = this.Color_G_Input.getValue();
    let B_Value = this.Color_B_Input.getValue();
    let opacity = this.Color_Opacity_Input.getValue();
    let color = "rgb(" + R_Value + " " + G_Value + " " + B_Value + " / " + opacity + ")";
    this.Selected_Color.setStyle("background-color", color);
    this.Color_16Str_Input.setValue(this.rgbaToHex(R_Value, G_Value, B_Value, opacity));
  }
  setValue(color) {
    for (let child of this.colorDiv.getChildren()) {
      var item = child;
      item.removeClass("property-color-item-focus");
      if (color == item.getColor()) {
        item.addClass("property-color-item-focus");
      }
    }
    let rgba = this.hexToRgbA(color);
    this.Color_R_Input.setValue(rgba.r);
    this.Color_G_Input.setValue(rgba.g);
    this.Color_B_Input.setValue(rgba.b);
    this.Color_Opacity_Input.setValue(rgba.a);
    this.Selected_Color.setStyle("background-color", color);
    this.Color_16Str_Input.setValue(color);
  }
  getValue() {
    return this.Color_16Str_Input.getValue();
  }
  rgbaToHex(r, g, b, a) {
    let str_r = parseInt(r, 10).toString(16);
    let str_g = parseInt(g, 10).toString(16);
    let str_b = parseInt(b, 10).toString(16);
    let str_a = Math.round(parseFloat(a) * 255).toString(16);
    if (a == "1") {
      return "#" + str_r + str_g + str_b;
    } else {
      return "#" + str_r + str_g + str_b + str_a;
    }
  }
  hexToRgbA(hex) {
    let hexColor = hex.slice(1);
    if (hexColor.length === 3) {
      hexColor = hexColor.split("").map(function(v) {
        return v + v;
      }).join("");
    }
    let rgba = [
      parseInt(hexColor.substring(0, 2), 16),
      // 红色
      parseInt(hexColor.substring(2, 4), 16),
      // 绿色
      parseInt(hexColor.substring(4, 6), 16),
      // 蓝色
      parseInt(hexColor.substring(6, 8), 16) / 255
      // 透明度
    ];
    return { r: rgba[0], g: rgba[1], b: rgba[2], a: Number.isNaN(rgba[3]) ? 1 : rgba[3] };
  }
  setLocation(left, top) {
    this.setStyle("left", left + "px");
    this.setStyle("top", top + "px");
  }
  getWidth() {
    return this.width;
  }
};
class Span extends AbstractControl {
  constructor(caption) {
    super(new SpanElement());
    this.setText(caption);
  }
  setValue(caption) {
    super.setValue(caption);
    this.setText(caption);
  }
  createEl() {
    return document.createElement("span");
  }
}
class DomElement extends AbstractDomElement {
  constructor(el) {
    super(el);
  }
  createEl() {
    return this.getEl();
  }
}
class WfDefines {
}
WfDefines.PAPER_W = 2400;
WfDefines.PAPER_H = 1500;
WfDefines.USER_PROPERTY_WIDTH = 400;
WfDefines.DEV_TOOLBOX_WIDTH = 50;
WfDefines.G_CIRCLE_R = 20;
WfDefines.G_RECT_W = 80;
WfDefines.G_RECT_H = 50;
WfDefines.G_RECT_R = 10;
WfDefines.G_COLOR_STROKE_NORMAL = "#000000";
WfDefines.G_COLOR_STROKE_DENY = "#ff0000";
WfDefines.G_COLOR_STROKE_HOVER = "#0095ff";
WfDefines.G_COLOR_STROKE_SELECT = "#0096ff";
WfDefines.G_WIDTH_STROKE_NORMAL = 1;
WfDefines.G_WIDTH_STROKE_HOVER = 2;
WfDefines.G_WIDTH_STROKE_SELECT = 2;
WfDefines.CLASS_HANDLER = "handler";
class YigoGrid extends AbstractControl {
  constructor(grid, el, operationDispatcher) {
    var _a;
    super(new DomElement(el));
    this.grid = grid;
    this.$el = $(el);
    this.operationDispatcher = operationDispatcher;
    this.form = (_a = this.operationDispatcher) == null ? void 0 : _a.getForm();
  }
  async init() {
    var width = WfDefines.USER_PROPERTY_WIDTH - 15;
    await this.clearRows();
    await this.grid.setEnable(true);
    if (this.grid) {
      this.grid.el && this.grid.el.setGridWidth(width);
      var height = this.grid.height ? this.grid.height : 0;
      height = height < 60 ? 60 : height;
      this.setGridHeight(height);
    }
  }
  setGridHeight(height) {
    this.grid.el && this.grid.el.setGridHeight(height);
  }
  async clearRows() {
    if (this.grid) {
      var dataModel = this.grid.dataModel;
      if (!dataModel || !dataModel.data) {
        return;
      }
      await this.deleteAllRows();
      if (this.grid.el && this.grid.el[0]) {
        this.grid.dataModel.data.length = 0;
        this.grid.hideCount = 0;
        this.grid.rowIDMask = 0;
        this.grid.rowIDMap = {};
        this.grid.el[0].cleanSelection();
        this.grid.el[0].p.editCells = [];
        this.grid.el[0].p.records = 0;
        this.grid.el[0].p.page = 1;
        this.grid.el[0].p.lastpage = 1;
        this.grid.el[0].p.reccount = 0;
        this.grid.el[0].grid.bDiv.scrollTop = 0;
        this.grid.el[0].grid.bDiv.scrollLeft = 0;
      }
    }
  }
  async deleteAllRows() {
    return this.grid.clearGridData();
  }
  setCellEnable(rowIndex, colIndex, enable) {
    this.grid.setCellEnable(rowIndex, colIndex, enable);
  }
  async setValueAt(rowIndex, colIndex, value2) {
    await this.grid.setValueAt(rowIndex, colIndex, value2);
  }
  async insertRow(rowIndex) {
    var row = await this.grid.insertRow(rowIndex, true);
    return row;
  }
  /* appendEmptyRow(rowIndex: number) : number {
       return this.grid.appendEmptyRow(rowIndex);
   }*/
  setValue(value2) {
  }
  getValue() {
    return void 0;
  }
  getShowText() {
    return void 0;
  }
}
class Button extends AbstractControl {
  constructor(text = "") {
    super(new ButtonElement());
    this.setCaption(text);
  }
  setOnClickListener(fun) {
    this.getDomElement().addEventListener("click", fun, false);
  }
  setCaption(text) {
    this.getDomElement().setText(text);
  }
}
class ButtonEditor extends AbstractControl {
  constructor() {
    super(new SpanElement(""));
    this.textEditor = new TextEditor();
    this.textEditor.setEditable(false);
    this.button = new Button("...");
    this.button.setStyle("padding", "0px");
    this.getDomElement().addChild(this.textEditor.getDomElement());
    this.getDomElement().addChild(this.button.getDomElement());
  }
  setOnButtonClick(fn) {
    this.button.addEventListener("click", fn, true);
  }
  setValue(value2) {
    super.setValue(value2);
    this.textEditor.setValue(value2);
  }
  setShowText(text) {
    this.textEditor.setValue(text);
  }
  getShowText() {
    return this.textEditor.getValue();
  }
  setText(text) {
    this.textEditor.setValue(text);
  }
  setHeight(height) {
    this.textEditor.setHeight(height);
    this.button.setHeight(height);
  }
  setWidth(width) {
    var w = width.getValue();
    this.textEditor.setWidth(SizeInfo.valueOfPX(w - 24));
    this.button.setWidth(SizeInfo.valueOfPX(24));
  }
}
class TempButtonEditor extends AbstractControl {
  constructor() {
    super(new SpanElement(""));
    this.textEditor = new TextEditor();
    this.textEditor.setEditable(true);
    this.button = new Button("...");
    this.button.setStyle("padding", "0px");
    this.getDomElement().addChild(this.textEditor.getDomElement());
    this.getDomElement().addChild(this.button.getDomElement());
    let self = this;
    this.textEditor.addEventListener("blur", () => {
      self.setValue(this.getShowText());
    });
  }
  setOnButtonClick(fn) {
    this.button.addEventListener("click", fn, true);
  }
  setValue(value2) {
    super.setValue(value2);
    this.textEditor.setValue(value2);
  }
  setShowText(text) {
    this.textEditor.setValue(text);
  }
  getShowText() {
    return this.textEditor.getValue();
  }
  setText(text) {
    this.textEditor.setValue(text);
  }
  setHeight(height) {
    this.textEditor.setHeight(height);
    this.button.setHeight(height);
  }
  setWidth(width) {
    var w = width.getValue();
    this.textEditor.setWidth(SizeInfo.valueOfPX(w - 24));
    this.button.setWidth(SizeInfo.valueOfPX(24));
  }
}
class GlobalStyle {
}
GlobalStyle.SCROLL_MARGIN = "hx-scroll-margin";
GlobalStyle.CLS_ISCHECKED = "is-checked";
GlobalStyle.CLS_YG_CHECKBOX = "yg-checkbox";
GlobalStyle.CLS_YG_CHECKBOX_INPUT = "yg-checkbox-input";
GlobalStyle.CLS_YG_CHECKBOX_INNER = "yg-checkbox-inner";
GlobalStyle.CLS_YG_CHECKBOX_ORIGINAL = "yg-checkbox-original";
GlobalStyle.CLS_YG_CHECKBOX_LABEL = "yg-checkbox-label";
GlobalStyle.CLS_AREA_CELL_COLLAPSED = "area-cell-collapsed";
class BooleanControl extends AbstractControl {
  constructor(element) {
    super(element);
    this.setValue(true);
  }
  isChecked() {
    return this.getValue();
  }
  setChecked(bChecked) {
    this.setValue(bChecked);
  }
}
const _Checkbox = class _Checkbox2 extends BooleanControl {
  constructor(text) {
    super(new DomElement(DomUtil.parseEl(_Checkbox2.TEMPLATE)));
    this.$el = $(this.getDomElement().getEl());
    this.$elInput = $(`.${GlobalStyle.CLS_YG_CHECKBOX_INPUT}`, this.$el);
    this.$elOriginalInput = $(`.${GlobalStyle.CLS_YG_CHECKBOX_ORIGINAL}`, this.$el);
    this.$elLabel = $(`.${GlobalStyle.CLS_YG_CHECKBOX_LABEL}`, this.$el);
    this.$elLabel.text(text);
    this.$elOriginalInput.on("click", () => {
      var bCheck = this.getValue();
      this.setChecked(!bCheck);
    });
    this.initStyle();
  }
  initStyle() {
    var skin = this.styleFactory.getCheckboxSkin();
    this.$el.addClass(skin.checkbox);
    this.$elInput.addClass(skin.checkbox_input);
    $(`.${GlobalStyle.CLS_YG_CHECKBOX_INNER}`, this.$el).addClass(skin.checkbox_inner);
    this.$elOriginalInput.addClass(skin.checkbox_original);
    this.$elLabel.addClass(skin.checkbox_label);
  }
  isChecked() {
    return this.$elOriginalInput.prop("checked");
  }
  setChecked(checked) {
    this.setValue(checked);
    this.$elInput.removeClass(GlobalStyle.CLS_ISCHECKED);
    checked && this.$elInput.addClass(GlobalStyle.CLS_ISCHECKED);
    this.$elOriginalInput.prop("checked", checked);
  }
};
_Checkbox.TEMPLATE = `<label class="${GlobalStyle.CLS_YG_CHECKBOX}">
        <span class="${GlobalStyle.CLS_YG_CHECKBOX_INPUT}">
            <input type="checkbox" class="${GlobalStyle.CLS_YG_CHECKBOX_ORIGINAL}">
            <span class="${GlobalStyle.CLS_YG_CHECKBOX_INNER}"></span>
        </span>
        <span class="${GlobalStyle.CLS_YG_CHECKBOX_LABEL}"/>
    </label>`;
let Checkbox = _Checkbox;
class InputElement extends AbstractDomElement {
  createEl() {
    return document.createElement("select");
  }
}
class Combobox extends AbstractControl {
  constructor() {
    super(new InputElement());
  }
  initControl(initialValue) {
    this.getEl().innerHTML = "";
    if (initialValue instanceof Array) {
      this.items = initialValue;
    } else if (initialValue instanceof Function) {
      this.items = initialValue();
    } else if (TypeUtil.isStr(initialValue)) {
      var strInitialValue = initialValue;
      this.items = this.createItems(strInitialValue);
    }
    if (this.items) {
      for (let item of this.items) {
        this.addItem(item.text, item.value);
      }
    }
  }
  setValue(value2) {
    super.setValue(value2);
    var selectEl = this.getEl();
    selectEl.value = value2;
  }
  getValue() {
    var selectEl = this.getEl();
    return selectEl.value;
  }
  getShowText() {
    if (this.items) {
      var value2 = this.getValue();
      for (let item of this.items) {
        if (item.value.toString() == value2.toString()) {
          return item.text ? item.text : "";
        }
      }
    }
    return "";
  }
  addItem(text, value2) {
    var selectEl = this.getEl();
    var optionEl = document.createElement("option");
    optionEl.text = text;
    optionEl.value = value2;
    selectEl.appendChild(optionEl);
  }
  createItems(strInitialValue) {
    var aStr = strInitialValue.split(";");
    var items = [];
    for (let str of aStr) {
      var aItem = str.indexOf(",") > -1 ? str.split(",") : str.split(":");
      if (aItem.length == 1) {
        items.push(this.createItem(aItem[0], aItem[0]));
      } else if (aItem.length == 2) {
        items.push(this.createItem(aItem[0], aItem[1]));
      }
    }
    return items;
  }
  createItem(value2, text) {
    return { text, value: value2 };
  }
}
class LabelElement extends AbstractDomElement {
  constructor(caption) {
    super();
    this.setText(caption);
  }
  setValue(caption) {
    this.setText(caption);
  }
  createEl() {
    return document.createElement("label");
  }
}
class Label extends AbstractControl {
  constructor(caption) {
    super(new LabelElement(caption));
    this.setText(caption);
  }
}
class NumberEditor extends TextEditor {
  constructor() {
    super();
    var inputEl = this.getEl();
    inputEl.type = "number";
  }
  caretLast() {
  }
}
class DataMapTextEditor extends TextEditor {
  constructor() {
    super();
  }
  setShowText(showText) {
    super.setValue(showText);
  }
}
class AElement extends AbstractDomElement {
  createEl() {
    return document.createElement("a");
  }
}
class Hyperlink extends AbstractControl {
  constructor() {
    super(new AElement());
  }
  setOnClickListener(fun) {
    this.getDomElement().addEventListener("click", fun, false);
  }
}
class ComboBoxEditor extends AbstractControl {
  constructor() {
    super(new DivElement());
    this.addClass("combobox-editor");
    this.input = new InputElement$1();
    this.input.addEventListener("focus", () => {
      this.refreshDisplayItems(true);
      this.comboboxView.setStyle("display", "block");
    });
    this.input.addEventListener("blur", () => {
      var _a;
      if (!((_a = this.input) == null ? void 0 : _a.getValue())) {
        this.setValue("");
      }
      this.comboboxView.setStyle("display", "none");
    });
    this.input.addEventListener("input", () => {
      this.refreshDisplayItems(false);
    });
    this.getDomElement().addChild(this.input);
    this.comboboxView = new DivElement();
    this.comboboxView.addClass("itemview");
    this.getDomElement().addChild(this.comboboxView);
  }
  refreshDisplayItems(allshow) {
    var _a, _b;
    let value2 = ((_a = this.input) == null ? void 0 : _a.getValue()) ? (_b = this.input) == null ? void 0 : _b.getValue() : "";
    if (value2.length == 0)
      allshow = true;
    for (var index = 0; index < this.comboboxView.getChildCount(); index++) {
      var item = this.comboboxView.getChildAt(index);
      var itemValue = item.getAttr("value") ? item.getAttr("value") : "";
      if (!itemValue.includes(value2) && !allshow) {
        item.setStyle("display", "none");
      } else {
        item.setStyle("display", "block");
      }
    }
  }
  initControl(initialValue) {
    var _a;
    if (initialValue instanceof Array) {
      this.items = initialValue;
    } else if (initialValue instanceof Function) {
      this.items = initialValue();
    } else if (TypeUtil.isStr(initialValue)) {
      var strInitialValue = initialValue;
      this.items = this.createItems(strInitialValue);
    }
    if (this.items) {
      for (let item of this.items) {
        this.addItem(item.text, item.value);
      }
    }
    this.comboboxView.setStyle("minWidth", this.getWidth().toString());
    this.comboboxView.setStyle("maxWidth", "99%");
    (_a = this.input) == null ? void 0 : _a.getEl().focus();
  }
  setValue(value2) {
    var _a, _b, _c;
    super.setValue(value2);
    if (value2) {
      (_a = this.input) == null ? void 0 : _a.setValue(this.getShowText());
    } else {
      (_b = this.input) == null ? void 0 : _b.setValue("");
      (_c = this.selectItem) == null ? void 0 : _c.setStyle("background", "#fff");
      this.selectItem = void 0;
    }
  }
  getShowText() {
    if (this.selectItem) {
      var text = this.selectItem.getEl().innerText;
      return text ? text : "";
    } else {
      for (var index = 0; index < this.comboboxView.getChildCount(); index++) {
        var item = this.comboboxView.getChildAt(index);
        if (item.getAttr("value") == this.getValue()) {
          this.selectItem = item;
          this.selectItem.setStyle("background", "#87CEFA");
          return item.getEl().innerText;
        }
      }
    }
    return "";
  }
  addItem(text, value2) {
    var item = new DivElement();
    item.getEl().innerText = text;
    item.setAttr("value", value2);
    item.setStyle("padding", "1px 4px");
    item.addEventListener("mouseover", () => {
      item.setStyle("background", "#eee");
    });
    item.addEventListener("mouseout", () => {
      item.setStyle("background", "#fff");
      if (item == this.selectItem) {
        item.setStyle("background", "#87CEFA");
      }
    });
    item.addEventListener("mousedown", () => {
      if (this.selectItem) {
        this.selectItem.setStyle("background", "#fff");
      }
      item.setStyle("background", "#87CEFA");
      this.selectItem = item;
      this.comboboxView.setStyle("display", "none");
      this.setValue(item.getAttr("value"));
    });
    this.comboboxView.addChild(item);
  }
  createItems(strInitialValue) {
    var aStr = strInitialValue.split(";");
    var items = [];
    for (let str of aStr) {
      var aItem = str.indexOf(",") > -1 ? str.split(",") : str.split(":");
      if (aItem.length == 1) {
        items.push(this.createItem(aItem[0], aItem[0]));
      } else if (aItem.length == 2) {
        items.push(this.createItem(aItem[0], aItem[1]));
      }
    }
    return items;
  }
  createItem(value2, text) {
    return { text, value: value2 };
  }
}
class DefSizeEditor extends AbstractControl {
  constructor(isPxFixed) {
    super(new SpanElement());
    this.textEditor = new NumberEditor();
    this.defSizes = new Combobox();
    this.defSizes.initControl([
      { text: "", value: "" },
      { text: "px", value: "px" },
      { text: "%", value: "%" },
      { text: "pref", value: "pref" },
      { text: "unit", value: "unit" },
      { text: "inherit", value: "inherit" },
      { text: "dp", value: "dp" },
      { text: "auto", value: "auto" }
    ]);
    this.isPxFixed = isPxFixed;
    if (isPxFixed) {
      this.defSizes.setValue("px");
      this.defSizes.getDomElement().setAttr("disabled", "disabled");
    }
    this.defSizes.setStyle("background-color", "#efefef");
    this.defSizes.setStyle("border", "solid 1px #ddd");
    this.defSizes.setStyle("border-radius", "2px");
    this.defSizes.setStyle("font-size", "14px");
    this.getDomElement().addChild(this.textEditor.getDomElement());
    this.getDomElement().addChild(this.defSizes.getDomElement());
    this.textEditor.addEventListener("blur", () => {
      this.setValueToControl();
    });
    this.defSizes.addEventListener("change", () => {
      this.setValueToControl();
    });
  }
  setValueToControl() {
    let sizeType = this.defSizes.getValue();
    let value2 = "";
    if (sizeType == "px" || sizeType == "%" || sizeType == "dp" || sizeType == "unit") {
      value2 = this.textEditor.getValue();
      value2 = value2.length == 0 ? "0" : value2;
      value2 = value2 + sizeType;
      this.textEditor.setEditable(true);
    } else {
      value2 = this.defSizes.getValue();
      this.textEditor.setValue("");
      this.textEditor.setEditable(false);
    }
    this.setValue(value2);
  }
  setValue(value2) {
    super.setValue(value2);
    let valueStr = value2 + "";
    if (valueStr.endsWith("px") || valueStr.endsWith("dp")) {
      this.textEditor.setValue(valueStr.substring(0, valueStr.length - 2));
      this.defSizes.setValue(valueStr.substring(valueStr.length - 2));
      this.textEditor.setEditable(true);
    } else if (valueStr.endsWith("%")) {
      this.textEditor.setValue(valueStr.substring(0, valueStr.length - 1));
      this.defSizes.setValue("%");
      this.textEditor.setEditable(true);
    } else if (valueStr.endsWith("unit")) {
      this.textEditor.setValue(valueStr.replace("unit", ""));
      this.defSizes.setValue("unit");
      this.textEditor.setEditable(true);
    } else {
      this.textEditor.setValue("");
      this.defSizes.setValue(valueStr);
      this.textEditor.setEditable(false);
    }
    if (this.isPxFixed) {
      this.defSizes.setValue("px");
      this.textEditor.setEditable(true);
    }
  }
  setOnValueChanged(fn) {
  }
  setHeight(height) {
    this.textEditor.setHeight(height);
    this.defSizes.setHeight(height);
  }
  setWidth(width) {
    this.textEditor.setWidth(SizeInfo.valueOfPX(width.getValue() - 60));
    this.defSizes.setWidth(SizeInfo.valueOfPX(60));
  }
}
class EXCEL {
}
EXCEL.D_TH_COLUMN_WIDTH = 35;
EXCEL.D_TH_COLUMN_HEIGHT = 60;
EXCEL.D_COLUMN_WIDTH = 80;
EXCEL.D_MAX_ROW_SIZE = 31;
EXCEL.D_MAX_COL_SIZE = 31;
EXCEL.PREFIX = "./yesui-vnode/webpluginx";
EXCEL.D_ROW_HEIGHT = 40;
EXCEL.D_ROW_Type = "Fix";
EXCEL.D_FONT_NAME = "SimSun";
EXCEL.D_FONT_SIZE = 12;
EXCEL.PROPERTIES_XML = `<EXCEL>
<DefineCollection>
    <Define Key="Workbook" Caption="EXCEL模板" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="标志" Control="TextEditor" Editable = "false"/>
            <Property Key="Caption" Caption="名称" Control="TextEditor"/>
            <Property Key="FormKey" Caption="绑定表单" Control="ButtonEditor" OnButtonClick="Macro_ShowWorkflowBindDialog()" Editable = "false"/>
        </PropertyCollection>
    </Define>
    <Define Key="Sheet" Caption="页" Extends="">
        <PropertyCollection>
            <Property Key="Name" Caption="名称" Control="TextEditor"/>
        </PropertyCollection>
    </Define>
    <Define Key="Column" Caption="列属性" Extends="">
        <PropertyCollection>
            <Property Key="ColumnIndex" Caption="列号" Control="NumberEditor" Editable = "false"/>
            <Property Key="Width" Caption="宽度" Control="NumberEditor" DefaultValue="80"/>
        </PropertyCollection>
    </Define>
    <Define Key="Row" Caption="行属性" Extends="">
        <PropertyCollection>
            <Property Key="Type" Caption="类型" Control="Combobox" OnInitialize="Head,表头数据行;DetailHead,明细头;Detail,明细行;Group,分组行;Fix,固定行;" DefaultValue="Fix"/>
            <Property Key="RowIndex" Caption="行号" Control="NumberEditor" Editable = "false"/>
            <Property Key="GridKey" Caption="表标志" Control="TextEditor"/>
            <Property Key="TableKey" Caption="数据源表" Control="Combobox" OnInitialize="=Macro_GetTableKeyList(GetRefFormKey(),GetRowType())" Visible="GetRowType()=='Detail'" />
            <Property Key="GroupDefination" Caption="分组字段" Control="TextEditor" />
            <Property Key="GroupLevel" Caption="分组层级" Control="NumberEditor" DefaultValue="0"/>
            <Property Key="GroupPosition" Caption="分组行位置" Control="Combobox" OnInitialize="head,head;tail,tail;all,all;"/>
            <Property Key="GroupHeadRowCount" Caption="头部分组行的个数" Control="NumberEditor" DefaultValue="0" />
            <Property Key="GroupTailRowCount" Caption="尾部分组行的个数" Control="NumberEditor" DefaultValue="0" />
        </PropertyCollection>
    </Define>
    <Define Key="Cell" Caption="单元格属性" Extends="">
        <PropertyCollection>
            <Property Key="CellIndex" Caption="单元格列号" Control="NumberEditor" DefaultValue="-1" Editable = "false"/>
            <Property Key="SourceType" Caption="内容类型" Control="Combobox" OnInitialize="Field,字段;Formula,公式;Const,常量;" DefaultValue="Field"/>
            <Property Key="Definition" Caption="内容" Control="ButtonEditor" OnButtonClick='Macro_ShowFormulaDialog("{self.key}",{{self.value}})'/>
            <Property Key="MergedColumnSpan" Caption="占用列数" Control="NumberEditor" DefaultValue="1"/>
            <Property Key="MergedRowSpan" Caption="占用行数" Control="NumberEditor" DefaultValue="1"/>
            <Property Key="ColumnExpand" Caption="扩展" Control="ButtonEditor" OnButtonClick="ShowModal('D_ExcelColumnExpand',{FormKey:{GetPrintAttrValue('FormKey')},ExcelKey:{GetPrintAttrValue('Key')}, XML:{GetSheetXML()}, ColumnIndex:{GetExcelColumnIndex()},RowIndex: {GetExcelRowIndex()}});" />
            <Property Key="TableKey" Caption="对应数据源标识" Control="Combobox" OnInitialize="=Macro_GetTableKeys(GetRefFormKey())" />
            <Property Key="GroupLevel" Caption="分组级别" Control="NumberEditor" DefaultValue="0"  />
            <Property Key="GroupPosition" Caption="分组行位置" Control="Combobox" OnInitialize="head,head;tail,tail;all,all;"/>
            <Property Key="GroupHeadRowCount" Caption="头部分组行的个数" Control="NumberEditor" DefaultValue="0" />
            <Property Key="GroupTailRowCount" Caption="尾部分组行的个数" Control="NumberEditor" DefaultValue="0" />
        </PropertyCollection>
    </Define>
</DefineCollection>
</EXCEL>
`;
class PRINT {
}
PRINT.D_COLUMN_WIDTH = 100;
PRINT.PREFIX = EXCEL.PREFIX;
PRINT.D_ROW_HEIGHT = 30;
PRINT.D_FONT_NAME = "SimSun";
PRINT.D_FONT_SIZE = 12;
PRINT.PROPERTIES_XML = `<PRINT>
<DefineCollection>
    <Define Key="Report" Caption="打印模板" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="标志" Control="TextEditor" Editable = "false"/>
            <Property Key="Caption" Caption="名称" Control="TextEditor"/>
            <Property Key="FormKey" Caption="绑定表单" Control="ButtonEditor" OnButtonClick="Macro_ShowWorkflowBindDialog()" Editable = "false"/>
            <Property Key="Group" Caption="报表组" Control="TextEditor"/>
            <Property Key="Default" Caption="表单默认模板" Control="Combobox" OnInitialize="true,是;false,否" DefaultValue="true"/>

            <Property Key="PageOrientation" Caption="页方向" Control="Combobox" OnInitialize="Portrait,纵向;Landscape,横向" DefaultValue="Portrait" Group="页面设置"/>
            <Property Key="PageWidth" Caption="页宽度" Control="NumberEditor" Group="页面设置"/>
            <Property Key="PageHeight" Caption="页高度" Control="NumberEditor" Group="页面设置"/>
            <Property Key="LeftMargin" Caption="左边距" Control="NumberEditor" DefaultValue="0" Group="页面设置"/>
            <Property Key="RightMargin" Caption="右边距" Control="NumberEditor" DefaultValue="0" Group="页面设置"/>
            <Property Key="TopMargin" Caption="上边距" Control="NumberEditor"  DefaultValue="0" Group="页面设置"/>
            <Property Key="BottomMargin" Caption="下边距" Control="NumberEditor" DefaultValue="0" Group="页面设置"/>
            <Property Key="VirtualPage" Caption="虚页打印" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false" Group="页面设置"/>
        
            <Property Key="PaperOrientation" Caption="纸张方向" Control="Combobox" OnInitialize="Portrait,纵向;Landscape,横向" DefaultValue="Portrait" Group="纸张设置"/>
            <Property Key="PaperWidth" Caption="纸张宽度" Control="NumberEditor" Group="纸张设置"/>
            <Property Key="PaperHeight" Caption="纸张高度" Control="NumberEditor" Group="纸张设置"/>
        </PropertyCollection>
    </Define>
    <Define Key="Table" Caption="数据表" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="标志" Control="TextEditor"/>
            <Property Key="Caption" Caption="名称" Control="TextEditor"/>
            <Property Key="ParentKey" Caption="父表格" Control="TextEditor"/>
        </PropertyCollection>
    </Define>
    <Define Key="Section" Caption="表区域" Extends="">
        <PropertyCollection>
            <Property Key="Type" Caption="类型" Control="Combobox" OnInitialize="PageHead,页眉;Paragraph,段落;Table,表格;PageTail,页尾" DefaultValue="Paragraph"/>
            <Property Key="SplitRow" Caption="拆行" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="Key" Caption="标志" Control="TextEditor"/>
            <Property Key="Caption" Caption="名称" Control="TextEditor"/>
            <Property Key="MinFillRowCount" Caption="最小明细填充数据行数" Control="TextEditor"/>
            <Property Key="PageBreakPolicy" Caption="分页策略" Control="Combobox" OnInitialize="None,无分页;GroupHead,根据分组头分页;" DefaultValue="None"/>
        </PropertyCollection>
    </Define>
    <Define Key="Column" Caption="列属性" Extends="">
        <PropertyCollection>
            <Property Key="Type" Caption="类型" Control="Combobox" OnInitialize="Fix, 固定列;Expand,扩展列;Group,分组列;Total,汇总列;" DefaultValue="Fix"/>
            <Property Key="Width" Caption="宽度" Control="NumberEditor"/>
            <Property Key="Visible" Caption="列可见性" Control="TextEditor"/>
            <Property Key="ExpandKey" Caption="列扩展标识" Control="Combobox" OnInitialize="=Macro_GetColumnExpandKey()"/>
            <Property Key="Lock" Caption="横向锁定" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
        </PropertyCollection>
    </Define>
    <Define Key="Row" Caption="行属性" Extends="">
        <PropertyCollection>
            <Property Key="Type" Caption="类型" Control="Combobox" OnInitialize=",未设置;TableTitleHead,表格标题头;DetailHead,明细头;LinkPrev,承上行;Detail,明细;LinkNext,启下行;DetailTail,明细尾;TableParagraph,表格段落;Group,分组行;TableTitleTail,表格标题尾" DefaultValue=""/>
            <Property Key="Height" Caption="高度" Control="NumberEditor"/>
            <Property Key="BackColor" Caption="背景色" Control="ColorEditor"/>
            <Property Key="TableKey" Caption="来源表"  Control="Combobox" OnInitialize="=GetPrintTableKey()"/>
            <Property Key="GroupKey" Caption="行分组标识" Control="Combobox" OnInitialize="=Macro_GetRowGroupKey()"/>
            <Property Key="GroupLevel" Caption="分组层级" Control="NumberEditor" DefaultValue="-1"/>
            <Property Key="LineBreak" Caption="拆行" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="PageBreak" Caption="页分隔符" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="DtlCountEveryPage" Caption="每页行数" Control="NumberEditor" DefaultValue="0"/>
        </PropertyCollection>
    </Define>
    <Define Key="Cell" Caption="单元格属性" Extends="">
        <PropertyCollection>
            <Property Key="Key" Caption="标识" Control="TextEditor"/>
            <Property Key="Caption" Caption="名称" Control="TextEditor"/>
            <Property Key="CellText" Caption="内容" Type="CDATA" Control="ButtonEditor" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})"/>
            <Property Key="Type" Caption="类型" Control="Combobox" OnInitialize="Text,文本;Image,图片"  DefaultValue="Text" />
            <Property Key="SourceType" Caption="数据来源类型" Control="Combobox" OnInitialize=",文本;Field,字段域;Formula,表达式;Interface,接口;PageNo,页码;Const,常量;System,系统域" />
            <Property Key="TableKey" Caption="表标识"Control="Combobox" OnInitialize="=GetPrintTableKey()" Visible="GetPropertyValue('SourceType', '')=='Field'"/> <!--表字段和表标识应当是获取的下拉框 下面这些属性应该是随着数据来源类型可见性发生变化-->
            <Property Key="FieldKey" Caption="表字段" Control="Combobox" OnInitialize="=GetPrintTableFieldKeyByTableKey(GetPrintCellTableKey())" Visible="GetPropertyValue('SourceType', '')=='Field'"/>
            <Property Key="Formula" Caption="表达式" Control="ButtonEditor" Visible="GetPropertyValue('SourceType', '')=='Formula'" OnButtonClick="Macro_ShowFormulaDialog('{self.key}',{{self.value}})"/>
            <Property Key="Impl" Caption="接口" Control="TextEditor" Visible="GetPropertyValue('SourceType', '')=='Interface'"/>
            <Property Key="PageNo" Caption="页码" Control="Combobox" Visible="GetPropertyValue('SourceType', '')=='PageNo'" OnInitialize="PageOfCount,总页数;Page,页码"/>
            <Property Key="SystemContent" Caption="系统域" Control="Combobox" OnInitialize=",未设置;Page,页数;PageOfCount,总页数;RowIndexOfTotal,行序号;RowIndexOfPage,页内行序号" Visible="GetPropertyValue('SourceType', '')=='System'"/>
            <Property Key="ImageSourceType" Caption="图片文件来源类型" Control="Combobox" Visible="GetPropertyValue('Type', 'Text')=='Image'" OnInitialize="Data,数据;Resource,资源;URL,URL" DefaultValue="Data"/>
            <Property Key="Path" Caption="路径" Control="TextEditor" Visible="GetPropertyValue('Type', 'Text')=='Image'"/>
            <Property Key="GroupType" Caption="分组类型" Control="Combobox" OnInitialize="None,无分组;RowGroup,行分组;RowTreeGroup,树形行分组;" DefaultValue="None"/>
            <Property Key="SortType" Caption="排序类型" Control="Combobox" OnInitialize="None,无排序;Asc,升序;Desc,降序;" DefaultValue="None"/>
           
            <Property Key="MergeDetail" Caption="合并明细区域" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="MergeTopGroup" Caption="合并分组头" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="MergeBottomGroup" Caption="合并分组尾" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
<!--            <Property Key="IsRowExpand" Caption="行扩展" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>-->
            <Property Key="ColumnExpand" Caption="列扩展" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="IsPrimary" Caption="主键" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="IsSummary" Caption="总结信息" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="FillEmptyContent" Caption="套打" Control="Combobox" OnInitialize="{list.boolean}"  DefaultValue="false"/>
            <Property Key="Overflow" Caption="内容溢出" Control="Combobox" OnInitialize="0,不处理;1,调整内容适应大小;2,调整大小适应内容;3,自动换行" DefaultValue="0" />
            <Property Key="Padding" Caption="内边距" Control="TextEditor"/>
<!--            <Property Key="LeftMargin" Caption="左边距" Control="NumberEditor"/>-->
<!--            <Property Key="TopMargin" Caption="顶边距" Control="NumberEditor"/>-->
<!--            <Property Key="RightMargin" Caption="右边距" Control="NumberEditor"/>-->
<!--            <Property Key="BottomMargin" Caption="底边距" Control="NumberEditor"/>-->
        </PropertyCollection>
    </Define>
</DefineCollection>
</PRINT>
`;
const _StraightLineButtonBox = class _StraightLineButtonBox2 extends AbstractControl {
  constructor(key2, buttonContainerItems, values, width, height) {
    super(new ButtonElement(""));
    this.buttonText = new Button("");
    this.button = new Button("");
    this.button.setStyle("background", 'url("' + PRINT.PREFIX + '/css/img/arrow0.png") center no-repeat');
    this.button.setStyle(" background-size", "100%");
    this.buttonText.setStyle("border-right", "solid 1px #DDD");
    this.setStyle("border", "solid 1px #DDD");
    this.setStyle("margin-left", "4px");
    this.setStyle("border-radius", "3px");
    this.setStyle("margin-top", "2px");
    this.getDomElement().addChild(this.buttonText.getDomElement());
    this.getDomElement().addChild(this.button.getDomElement());
    this.buttonContainer = new ButtonContainer$4(buttonContainerItems, values, width.toString(), height.toString());
    this.setKey(key2);
    var self = this;
    this.button.addEventListener("click", function(event) {
      if (self.getDomElement().getChildCount() > 2) {
        self.getDomElement().removeChild(self.buttonContainer);
      } else {
        self.getDomElement().addChild(self.buttonContainer);
        self.buttonContainer.getEl().focus();
      }
    }, true);
    this.buttonContainer.addEventListener("mousedown", (e) => {
      var el = e.target;
      if (el.classList.contains("property-Container-item")) {
        var item = self.buttonContainer.findElement(el);
        self.setValue(item.getEl().getAttribute("value"));
        self.getDomElement().removeChild(self.buttonContainer);
        this.fnOnValueChange && this.fnOnValueChange(this);
      }
    }, true);
    this.buttonContainer.addEventListener("blur", (e) => {
      e.target;
      setTimeout(function() {
        self.getDomElement().removeChild(self.buttonContainer);
      }, 1);
    }, true);
  }
  setOnButtonClick(fn) {
    this.button.addEventListener("click", fn, true);
  }
  setValue(value2) {
    this.buttonText.setStyle("background", 'url("' + PRINT.PREFIX + "/css/img/arrow" + _StraightLineButtonBox2.values.indexOf(value2) + '.png") center no-repeat');
    super.setValue(value2);
    this.buttonText.setValue(value2);
  }
  getValue() {
    return this.buttonText.getValue();
  }
  setShowText(text) {
    this.buttonText.setValue(text);
  }
  getShowText() {
    return this.buttonText.getValue();
  }
  setText(text) {
    this.buttonText.setValue(text);
  }
  setHeight(height) {
    this.setStyle("height", height.toString());
    this.buttonText.setHeight(height);
    this.button.setHeight(height);
  }
  setWidth(width) {
    var w = width.getValue();
    this.setStyle("width", width.toString());
    this.buttonText.setWidth(SizeInfo.valueOfPX(w - 24));
    this.button.setWidth(SizeInfo.valueOfPX(24));
  }
};
_StraightLineButtonBox.values = ["StraightLine", "ChamferCurveHOne", "ChamferCurveVOne", "ChamferCurveHTwo", "ChamferCurveVTwo", "FilletCurveHOne", "FilletCurveVOne", "FilletCurveHTwo", "FilletCurveVTwo", "ObliqueCurveHTwo", "ObliqueCurveVTwo"];
let StraightLineButtonBox = _StraightLineButtonBox;
let ContainerItem$1 = class ContainerItem2 extends AbstractDomElement {
  constructor(background) {
    super();
    this.background = background;
    this.addClass("property-Container-item");
    this.setStyle("background", background);
    this.setStyle("width", "70px");
    this.setStyle("height", "20px");
    this.setStyle("margin", "2px");
    this.setStyle("cursor", "pointer");
    this.setStyle("border-width", "1px");
  }
  getContainer() {
    return this.background;
  }
};
let ButtonContainer$4 = class ButtonContainer2 extends AbstractDomElement {
  constructor(buttonContainerItems, values, width, height) {
    super();
    this.addClass("ButtonContainer");
    this.setStyle("position", "absolute");
    this.setStyle("z-index", "66666666");
    this.setStyle("display", "flex");
    this.setStyle("width", width);
    this.setStyle("height", height);
    this.setStyle("margin-top", "-6px");
    this.setStyle("flex-direction", "row");
    this.setStyle("flex-wrap", "wrap");
    this.setStyle("justify-content", "center");
    this.setStyle("align-items", "center");
    this.setStyle("background-color", "rgb(191 191 191)");
    this.setAttr("tabindex", "0");
    this.buttonContainerItems = buttonContainerItems;
    for (let i = 0; i < this.buttonContainerItems.length; i++) {
      var colorItem = new ContainerItem$1(this.buttonContainerItems[i]);
      colorItem.getEl().setAttribute("value", values[i]);
      this.addChild(colorItem);
    }
  }
};
class ControlFactory {
  constructor() {
  }
  static getYigoGridEl(key2, operationDispatcher) {
    var grid = ControlFactory.getYigoComponent(key2, operationDispatcher);
    if (grid) {
      var el = DomUtil.findParentElByClassName(grid.getEl().getElm(), "ui-ygrid");
      return el;
    } else {
      return null;
    }
  }
  static getYigoComponent(key2, operationDispatcher) {
    if (operationDispatcher) {
      return operationDispatcher.getComponent(key2);
    } else {
      return null;
    }
  }
  static async getPropertyGrid(key2, operationDispatcher) {
    var el = ControlFactory.getYigoGridEl(key2, operationDispatcher);
    if (el) {
      var gridComponent = ControlFactory.getYigoComponent(key2, operationDispatcher);
      var grid = new YigoGrid(gridComponent, el, operationDispatcher);
      await grid.init();
      return grid;
    }
    return void 0;
  }
  static createControl(control, config, operationDispatcher) {
    var uiControl = new TextEditor();
    switch (control) {
      case EComponentType.Label:
        uiControl = new Label("");
        break;
      case EComponentType.Hyperlink:
        uiControl = new Hyperlink();
        break;
      case EComponentType.TextEditor:
        uiControl = new TextEditor();
        break;
      case EComponentType.Checkbox:
        uiControl = new Checkbox("");
        break;
      case EComponentType.Combobox:
        uiControl = new Combobox();
        break;
      case EComponentType.ComboBoxEditor:
        uiControl = new ComboBoxEditor();
        break;
      case EComponentType.NumberEditor:
        uiControl = new NumberEditor();
        break;
      case EComponentType.ButtonEditor:
        uiControl = new ButtonEditor();
        break;
      case "StraightLineButtonBox":
        var images = [];
        for (let i = 0; i <= 10; i++) {
          images.push('url("' + PRINT.PREFIX + "/css/img/arrow" + i + '.png") center no-repeat');
        }
        var straightLineButtonBox = new StraightLineButtonBox(
          "UnderLine",
          images,
          StraightLineButtonBox.values,
          SizeInfo.valueOfPX(70),
          SizeInfo.valueOfPX(280)
        );
        straightLineButtonBox.setTitle("线图形样式");
        straightLineButtonBox.setWidth(SizeInfo.valueOfPX(50));
        straightLineButtonBox.setHeight(SizeInfo.valueOfPX(26));
        var value2 = "StraightLine";
        if (config.tagNode) {
          var child = config.tagNode.getChild("TransitionGraphic");
          if (child) {
            value2 = child.getAttributeValue("StraightLine", "StraightLine");
          }
        }
        straightLineButtonBox.setValue(value2);
        straightLineButtonBox.buttonText.setStyle("background", 'url("' + PRINT.PREFIX + "/css/img/arrow" + StraightLineButtonBox.values.indexOf(value2) + '.png") center no-repeat');
        straightLineButtonBox.buttonText.setStyle(" background-size", "100%");
        uiControl = straightLineButtonBox;
        uiControl.setOnValueChanged((e) => {
        });
        break;
      case EComponentType.TempButtonEditor:
        uiControl = new TempButtonEditor();
        break;
      case EComponentType.ColorEditor:
        uiControl = new ColorEditor();
        break;
      case EComponentType.DefSizeEditor:
        uiControl = new DefSizeEditor(false);
        break;
      case EComponentType.PxDefSizeEditor:
        uiControl = new DefSizeEditor(true);
        break;
      case EComponentType.YigoControl:
      case EComponentType.YigoDict:
      case EComponentType.YigoCodeDict:
        if (operationDispatcher) {
          uiControl = operationDispatcher.createYigoControl(config.key, control, config.component);
        }
        break;
      case EComponentType.DataMapTextEditor:
        uiControl = new DataMapTextEditor();
        break;
    }
    config && uiControl.setKey(config.key);
    return uiControl;
  }
}
class PropertyContants {
}
PropertyContants.CONTROL_HEIGHT = 30;
PropertyContants.PROPERTY_PANEL_WIDTH = 350;
const _GlobalVariable = class _GlobalVariable2 {
  static isInIFrame() {
    return window.DesignEnv == "IFrame";
  }
  static registerVariable(key2, obj) {
    _GlobalVariable2.mapVariables.set(key2, obj);
  }
  static getVarialble(key2) {
    if (!key2)
      return null;
    if (_GlobalVariable2.isVarialble(key2)) {
      var variable = _GlobalVariable2.mapVariables.get(key2);
      if (variable instanceof Function) {
        return variable();
      } else {
        return variable;
      }
    }
    return key2;
  }
  static isVarialble(str) {
    var s = str.trim();
    return s.startsWith("{") && s.endsWith("}");
  }
  static isFormula(str) {
    if (!str)
      return false;
    var s = str.trim();
    return s.startsWith("=");
  }
  static getFormula(str) {
    if (_GlobalVariable2.isFormula(str)) {
      return str.substring(1);
    }
    return str;
  }
  static hasVarialble(str) {
    return _GlobalVariable2.mapVariables.has(str);
  }
  /* public static getMode(): EDesignMode {
          return window.DesignMode ? window.DesignMode : EDesignMode.Product;
      }
  
      public static isProductMode(): boolean {
          return GlobalVariable.getMode() == EDesignMode.Product;
      }*/
};
_GlobalVariable.G_FORMULA_DICT = "BPMN_FormulaDefine";
_GlobalVariable.G_RUN_DICTFORMULA = "RunDictFormula";
_GlobalVariable.G_DevelopCode = "000";
_GlobalVariable.EMPTY_WORKFLOW = `<?xml version="1.0" encoding="UTF-8" standalone="no"?>
    <Process>
        <Begin ID="1" Key="Begin" Caption="起始">
            <NodeGraphic X="303" Y="131"/>
            <TransitionCollection>
                <SequenceFlow ID="3" Key="SequenceFlow" Caption="顺序流" TargetNodeKey="End"/>
            </TransitionCollection>
        </Begin>
        <End ID="2" Key="End" Caption="结束">
            <NodeGraphic X="303" Y="597"/>
        </End>
    </Process>`;
_GlobalVariable.V_LIST_BOOLEAN = "{list.boolean}";
_GlobalVariable.V_LIST_STATUS = "{list.status}";
_GlobalVariable.V_INPUT_IMAGE = "{input.image}";
_GlobalVariable.V_BPMN_INPUT_PERM = "{bpmn.input.perm}";
_GlobalVariable.V_BPMN_INPUT_FORMULA = "{bpmn.input.formula}";
_GlobalVariable.V_BPMN_LIST_STATE = "{bpmn.list.state}";
_GlobalVariable.V_BPMN_LIST_SUBPROCESS = "{bpmn.list.subprocess}";
_GlobalVariable.V_BPMN_COUNTERSIGN_CONDITION_TYPE = "{bpmn.countersign.condition.type}";
_GlobalVariable.V_BPMN_INPUT_TIMERITEM_C = "{bpmn.input.timeritem.collection}";
_GlobalVariable.V_BPMN_INPUT_OPERATION_C = "{bpmn.input.operation.collection}";
_GlobalVariable.V_BPMN_INPUT_ASSISTANCE_C = "{bpmn.input.assistance.collection}";
_GlobalVariable.V_BPMN_INPUT_PARTICIPATOR_C = "{bpmn.input.participator.collection}";
_GlobalVariable.V_SELF_VALUE = "{self.value}";
_GlobalVariable.V_SELF_KEY = "{self.key}";
_GlobalVariable.mapVariables = /* @__PURE__ */ new Map([
  [_GlobalVariable.V_LIST_BOOLEAN, [{ text: "是", value: "true" }, { text: "否", value: "false" }]],
  [_GlobalVariable.V_LIST_STATUS, [{ text: "初始", value: "init" }, { text: "审批中", value: "Auditing" }, { text: "已审批", value: "Audited" }]],
  [_GlobalVariable.V_BPMN_COUNTERSIGN_CONDITION_TYPE, [{ text: "无", value: "None" }, { text: "数量", value: "Number" }, { text: "比例", value: "Proportion" }, { text: "自定义", value: "Custom" }]]
]);
let GlobalVariable = _GlobalVariable;
class YigoControl extends AbstractControl {
  constructor(component, optExecutor) {
    super(new DomElement(component.getEl().getElm()));
    this.component = component;
  }
  getShowText() {
    return this.component.getShowText();
  }
  getValue() {
    return this.component.getValue();
  }
  setHeight(height) {
    super.setHeight(height);
    this.component.setHeight(height.getValue());
  }
  setWidth(width) {
    super.setWidth(width);
    this.component.setWidth(width.getValue());
  }
}
class PropertyUIControl extends AbstractDomElement {
  constructor(propertyItem, callback, stateDelegate, optDispatcher) {
    super();
    this.focused = false;
    this.curTotalWidth = 0;
    this.curHeight = 0;
    this.addClass("property-control-line");
    this.setStyle("line-height", PropertyContants.CONTROL_HEIGHT + "px");
    this.propertyItem = propertyItem;
    this.callback = callback;
    this.stateDelegate = stateDelegate;
    this.optDispatcher = optDispatcher;
    this.init(propertyItem);
  }
  getPropertyItem() {
    return this.propertyItem;
  }
  createEl() {
    return document.createElement("li");
  }
  updateUI() {
    this.init(this.propertyItem);
  }
  init(propertyItem) {
    this.labelControl = new Span(propertyItem.caption);
    this.labelControl.setStyle("display", "inline-block");
    this.labelControl.addClass("property-control-base");
    this.labelControl.addClass("property-label");
    this.addChild(this.labelControl.getDomElement());
    this.spanResizer = new Span("");
    this.spanResizer.setStyle("position", "absolute");
    this.spanResizer.setStyle("display", "inline-block");
    this.spanResizer.addClass("property-control-base");
    this.spanResizer.addClass("property-label");
    this.spanResizer.addClass("property-resize-ltr");
    this.addChild(this.spanResizer.getDomElement());
    this.spanResizer.getDomElement().hover(() => {
      this.stateDelegate.setResizeState();
    }, () => {
      if (!this.stateDelegate.getCurrentState().isLeftMouseButtonDowning()) {
        this.stateDelegate.setNormalState();
      }
    });
    this.textControl = new Span("");
    var editorControl = ControlFactory.createControl(this.propertyItem.control, { key: propertyItem.key, component: propertyItem.component }, this.optDispatcher);
    this.initControl(editorControl).then(() => {
      this.setEditControlValue(editorControl, propertyItem).then((value2) => {
        var text = editorControl.getShowText();
        if (this.textControl) {
          this.textControl.setText(!text && value2 ? value2 : text);
          this.textControl.setStyle("display", "inline-block");
          this.textControl.addClass("property-control-base");
          this.textControl.addClass("property-label");
          if (propertyItem.control == "ColorEditor") {
            this.textControl.setStyle("background-color", value2);
          }
        }
      });
    });
    this.addChild(this.textControl.getDomElement());
    var bEditable = this.isEditableItem(this.propertyItem);
    if (this.optDispatcher && !this.optDispatcher.isEditable() || !bEditable) {
      this.labelControl.addClass("property-disable");
      this.textControl.addClass("property-disable");
    }
  }
  // 目前没有遇到要支持公式的情况，引入公式，就需要引入异步，代码结构冲击较大，暂不做公式处理
  isEditableItem(propertyItem) {
    var bContextEditable = true;
    if (this.optDispatcher) {
      bContextEditable = this.optDispatcher.isEditable();
    }
    return bContextEditable && TypeUtil.toBoolean(propertyItem.editable);
  }
  setFocused(bFocused) {
    if (bFocused == this.focused)
      return;
    bFocused ? this.focus() : this.unfocus();
  }
  isFocused() {
    return this.focused;
  }
  getValue() {
    return this.editorControl ? this.editorControl.getValue() : this.callback.getValue(this.propertyItem);
  }
  focus() {
    if (this.focused)
      return;
    this.focused = true;
    this.labelControl && this.labelControl.removeClass("property-unfocused");
    this.labelControl && this.labelControl.addClass("property-focused");
    var bEditable = this.isEditableItem(this.propertyItem);
    if (!bEditable)
      return;
    var height = this.textControl ? this.textControl.getDomElement().getHtmlClientHeight() : 0;
    var width = this.textControl ? this.textControl.getDomElement().getHtmlClientWidth() - 5 : 0;
    this.textControl && this.removeChild(this.textControl.getDomElement());
    this.editorControl && this.removeChild(this.editorControl.getDomElement());
    if (this.propertyItem.component) {
      throw new Error("异常方法调用，相关代码需修复");
    } else {
      this.editorControl = ControlFactory.createControl(this.propertyItem.control, { key: this.propertyItem.key, component: this.propertyItem.component, tagNode: this.callback.getCurTagNode() }, this.optDispatcher);
    }
    this.editorControl.setOnValueChanged((control) => {
      this.fnOnPropertyValueChange(this);
    });
    this.editorControl.addClass("property-control-base");
    this.editorControl.addClass("property-input");
    this.editorControl.setWidth(SizeInfo.valueOfPX(width));
    this.editorControl.setHeight(SizeInfo.valueOfPX(height - 1));
    this.editorControl.setOnButtonClick(() => {
      var clickEvent = this.propertyItem.onbuttonclick;
      if (clickEvent) {
        clickEvent = clickEvent.replace(GlobalVariable.V_SELF_KEY, this.propertyItem.key);
        clickEvent = clickEvent.replace(GlobalVariable.V_SELF_VALUE, this.editorControl ? this.editorControl.getValue() : "");
      }
      clickEvent && this.optDispatcher && this.optDispatcher.eval(clickEvent);
    });
    this.initControl(this.editorControl).then(() => {
      if (this.editorControl) {
        this.setEditControlValue(this.editorControl, this.propertyItem).then((value2) => {
          this.editorControl && this.editorControl.caretLast();
        });
      }
    });
    this.addChild(this.editorControl.getDomElement());
  }
  isUserMode() {
    if (!this.optDispatcher)
      return false;
    return this.optDispatcher.getMode() == EDesignMode.User;
  }
  async setEditControlValue(editorControl, propertyItem) {
    var value2 = this.callback.getValue(propertyItem);
    editorControl.setValue(value2);
    if (TypeUtil.isStr(value2) && this.optDispatcher && this.isUserMode()) {
      var formulaID = await this.optDispatcher.queryFormulaDictID(value2);
      if (formulaID > 0) {
        var formulaName = await this.optDispatcher.queryFormulaDictName(formulaID);
        if (!this.optDispatcher.isDevFormulaID(formulaID) && propertyItem.key != GlobalConstants.S_FormKey) {
          formulaName && editorControl.setShowText(formulaName);
        }
      }
    } else {
      var defaultvalue = propertyItem.defaultvalue;
      if (defaultvalue && GlobalVariable.isFormula(defaultvalue) && this.optDispatcher) {
        var formula = GlobalVariable.getFormula(defaultvalue);
        defaultvalue = await this.optDispatcher.eval(formula);
      } else if (GlobalVariable.hasVarialble(defaultvalue)) {
        defaultvalue && (defaultvalue = GlobalVariable.getVarialble(defaultvalue));
      } else {
        defaultvalue = value2;
      }
      defaultvalue && editorControl.setShowText(defaultvalue);
    }
    editorControl.caretLast();
    return value2;
  }
  setPropertyValue(value2, text) {
    var _a, _b;
    this.callback.setValue(this.propertyItem, value2);
    (_a = this.editorControl) == null ? void 0 : _a.setValue(value2);
    text && ((_b = this.editorControl) == null ? void 0 : _b.setShowText(text));
    if (this.textControl) {
      text ? this.textControl.setShowText(text) : this.textControl.setShowText(value2);
    }
  }
  setOnPropertyValueChanged(fn) {
    this.fnOnPropertyValueChange = fn;
  }
  async initControl(editor) {
    if (!editor)
      return;
    var oninitialize = this.propertyItem.oninitialize;
    if (oninitialize && GlobalVariable.isFormula(oninitialize) && this.optDispatcher) {
      var formula = GlobalVariable.getFormula(oninitialize);
      oninitialize = await this.optDispatcher.eval(formula);
    } else {
      oninitialize && (oninitialize = GlobalVariable.getVarialble(oninitialize));
    }
    oninitialize && editor.initControl(oninitialize);
  }
  unfocus() {
    var _a, _b;
    if (!this.focused)
      return;
    this.focused = false;
    this.labelControl && this.labelControl.removeClass("property-focused");
    this.labelControl && this.labelControl.addClass("property-unfocused");
    var bEditable = this.isEditableItem(this.propertyItem);
    if (!bEditable || !this.editorControl)
      return;
    this.textControl && this.removeChild(this.textControl.getDomElement());
    var text = this.editorControl.getShowText();
    this.removeChild(this.editorControl.getDomElement());
    (_a = this.textControl) == null ? void 0 : _a.setText(text);
    if (this.editorControl instanceof ColorEditor) {
      (_b = this.textControl) == null ? void 0 : _b.setStyle("background-color", this.editorControl.getValue());
    }
    var value2 = this.editorControl.getValue();
    this.textControl && this.addChild(this.textControl.getDomElement());
    this.callback.setValue(this.propertyItem, value2);
  }
  updateUnfocusControl() {
  }
  resize(width, height) {
    if (width == 0)
      return;
    this.curTotalWidth = width;
    this.curHeight = height;
    var leftWidth = width * PropertyUIPanel.PROP_RATIO - 6;
    var rightWidth = width * (1 - PropertyUIPanel.PROP_RATIO) - 6;
    var curHeight = height - 1;
    var leftWidthInfo = SizeInfo.valueOfPX(leftWidth);
    var rightWidthInfo = SizeInfo.valueOfPX(rightWidth);
    var heightInfo = SizeInfo.valueOfPX(curHeight);
    this.labelControl && this.labelControl.setWidth(leftWidthInfo);
    this.labelControl && this.labelControl.setHeight(heightInfo);
    this.spanResizer && this.spanResizer.setHeight(heightInfo);
    this.textControl && this.textControl.setWidth(rightWidthInfo);
    this.textControl && this.textControl.setHeight(heightInfo);
    this.editorControl && this.editorControl.setWidth(rightWidthInfo);
    this.editorControl && this.editorControl.setHeight(heightInfo);
    this.editorControl && this.editorControl.fireResized(rightWidthInfo, heightInfo);
    this.editorControl && this.editorControl.lostFocus();
  }
  resizeByRatio(ratio) {
    this.resize(this.curTotalWidth, this.curHeight);
  }
}
class Events {
}
Events.COMMON_SELECT_CHANGE = "common_select_change";
Events.Click = "click";
Events.MouseDown = "mousedown";
Events.MouseOver = "mouseover";
Events.MouseOut = "mouseout";
Events.MouseEnter = "mouseenter";
Events.MouseLeave = "mouseleave";
Events.Focus = "focus";
Events.VauleChanged = "valuechanged";
Events.Blur = "blur";
Events.Tab = {
  NAV_SELECT: "tab-nav-select",
  NAV_CLOSE: "tab-nav-close"
};
Events.Tree = {
  ITEM_CLICK: "tree-item-click",
  ITEM_DBCLICK: "tree-item-dbclick",
  EXPAND: "tree_event_expand",
  COLLAPASE: "tree_event_collapase"
};
const _ToggleArrowLabel = class _ToggleArrowLabel2 extends AbstractDomElement {
  constructor(caption, expanded, clsExpandIcon = _ToggleArrowLabel2.DEFAULT_EXPAND_ICON, clsCollapseIcon = _ToggleArrowLabel2.DEFAULT_COLLAPSE_ICON) {
    super();
    this.toggleArrow = new SpanIcon("iconfont");
    this.expanded = expanded;
    this.clsExpandIcon = clsExpandIcon;
    this.clsCollapseIcon = clsCollapseIcon;
    this.spanText = new Label(caption);
    this.addChild(this.toggleArrow);
    this.addChild(this.spanText.getDomElement());
    this.updateUI();
    var self = this;
    this.toggleArrow.addEventListener("click", function(e) {
      self.toggle();
    }, true);
  }
  initExpandAndCollapseIcon(clsExpandIcon, clsCollapseIcon) {
    this.clsExpandIcon = clsExpandIcon;
    this.clsCollapseIcon = clsCollapseIcon;
  }
  setText(text) {
    this.spanText.setValue(text);
  }
  addTextClass(clsText) {
    this.spanText.addClass(clsText);
  }
  setToggleListener(toggleListener) {
    this.toggleListener = toggleListener;
  }
  isExpanded() {
    return this.expanded;
  }
  toggle() {
    this.expanded = !this.expanded;
    this.toggleListener && this.toggleListener.toggle(this.expanded);
    this.updateUI();
  }
  expand() {
    this.expanded = true;
    this.toggleArrow.removeClass(this.clsExpandIcon);
    this.toggleArrow.addClass(this.clsCollapseIcon);
  }
  collapse() {
    this.expanded = false;
    this.toggleArrow.removeClass(this.clsCollapseIcon);
    this.toggleArrow.addClass(this.clsExpandIcon);
  }
  setTextStyle(name, value2) {
    this.spanText.setStyle(name, value2);
  }
  updateUI() {
    this.expanded ? this.expand() : this.collapse();
  }
};
_ToggleArrowLabel.DEFAULT_EXPAND_ICON = "icon-jiahaozhankai";
_ToggleArrowLabel.DEFAULT_COLLAPSE_ICON = "icon-jianhaoshouqi";
let ToggleArrowLabel = _ToggleArrowLabel;
class GroupElement extends AbstractDomElement {
  constructor(caption, expanded) {
    super();
    this.caption = caption;
    this.title = new ToggleArrowLabel(this.caption, expanded);
    this.title.addClass("property-title");
    this.title.addTextClass("property-title-caption");
    this.addChild(this.title);
    this.title.setToggleListener({ toggle: (bExpanded) => {
      bExpanded ? this.displayGroup() : this.unDisplayGroup();
      this.resetHeight();
    } });
  }
  createEl() {
    return document.createElement("ul");
  }
  isExpanded() {
    return this.title.isExpanded();
  }
  unDisplayGroup() {
    var tmpChildren = [];
    for (let child of this.getChildren()) {
      if (child != this.title) {
        tmpChildren.push(child);
      }
    }
    for (let child of tmpChildren) {
      this.removeChild(child);
    }
  }
  displayGroup() {
  }
}
class PropertyUIGroup extends GroupElement {
  constructor(propertyGroup, callback, stateDelegate, optDispatcher) {
    super(propertyGroup.caption, propertyGroup.expanded);
    this.propertyControls = [];
    this.curWidth = 0;
    this.addClass("property-group");
    this.propertyGroup = propertyGroup;
    this.callback = callback;
    this.optDispatcher = optDispatcher;
    this.stateDelegate = stateDelegate;
    this.isExpanded() && this.displayGroup();
  }
  setOnEventListener(eventListener) {
    this.eventListener = eventListener;
  }
  unfocus() {
    var control;
    for (let child of this.getChildren()) {
      if (child != this.title) {
        control = child;
        control.unfocus();
      }
    }
  }
  getPropertyControl(key2) {
    for (let propertyControl of this.propertyControls) {
      if (propertyControl.getPropertyItem().key == key2) {
        return propertyControl;
      }
    }
    return void 0;
  }
  displayGroup() {
    this.propertyControls = [];
    for (let propertyItem of this.propertyGroup.properties) {
      var propertyControl = new PropertyUIControl(propertyItem, this.callback, this.stateDelegate, this.optDispatcher);
      this.propertyControls.push(propertyControl);
      propertyControl.addEventListener("click", (e) => {
        var _a;
        e.preventDefault();
        var paras = Paras.newInstance().setElement(e.target);
        (_a = this.eventListener) == null ? void 0 : _a.notifyEvent(Events.Focus, paras);
      }, true);
      propertyControl.setOnPropertyValueChanged((control) => {
        var _a;
        var paras = Paras.newInstance().setElement(control);
        (_a = this.eventListener) == null ? void 0 : _a.notifyEvent(Events.VauleChanged, paras);
        if (control.propertyItem.key == WfConstants.ATTR_DenyToLastNode) {
          if (control.getValue() != "true") {
            control.unfocus();
            this.propertyControls[1].setFocused(true);
          }
        }
      });
    }
    this.updateVisiableAndEditable();
  }
  async updateVisiableAndEditable() {
    this.clearChildren();
    this.title && this.addChild(this.title);
    for (let propertyControl of this.propertyControls) {
      var propertyItem = propertyControl.getPropertyItem();
      var visiable = this.optDispatcher ? await this.optDispatcher.asyncEval(propertyItem.visible) : TypeUtil.toBoolean(propertyItem.visible);
      if (visiable) {
        propertyControl.resize(this.curWidth, PropertyContants.CONTROL_HEIGHT);
        this.addChild(propertyControl);
      }
    }
    if (this.getChildCount() <= 1) {
      this.removeChild(this.title);
    }
    this.resetHeight();
  }
  resize(width, height) {
    this.curWidth = width;
    for (let child of this.getChildren()) {
      child.resize(width, PropertyContants.CONTROL_HEIGHT);
    }
  }
  resizeByRatio(ratio) {
    for (let child of this.getChildren()) {
      if (child instanceof PropertyUIControl) {
        child.resizeByRatio(ratio);
      }
    }
  }
  getInnerHeight() {
    var total = PropertyContants.CONTROL_HEIGHT;
    for (let child of this.getChildren()) {
      if (child instanceof PropertyUIControl) {
        total += PropertyContants.CONTROL_HEIGHT;
      }
    }
    return total;
  }
  resetHeight() {
    this.stateDelegate.getView().resetHeight();
  }
}
class AbstractOptStateDelegate {
  constructor(view) {
    this.view = view;
  }
  setInitState(initState) {
    this.initState = initState;
    this.reset();
  }
  getInitState() {
    return this.initState;
  }
  setCurrentState(state) {
    this.currentState = state;
  }
  getCurrentState() {
    return this.currentState;
  }
  getView() {
    return this.view;
  }
  reset() {
    if (this.currentState == this.initState) {
      return;
    }
    var orgState = this.currentState;
    this.setCurrentState(this.initState);
    orgState && orgState.reset();
  }
}
class AbstractOptState {
  constructor(delegate) {
    this.leftMouseButtonDowning = false;
    this.delegate = delegate;
    delegate.getView;
  }
  getDelegate() {
    return this.delegate;
  }
  getView() {
    return this.delegate.getView();
  }
  reset() {
    this.delegate.reset();
  }
  dragstart(x, y, event) {
  }
  dragmove(dx, dy, x, y, event) {
  }
  dragend(event) {
  }
  isLeftMouseButtonDowning() {
    return this.leftMouseButtonDowning;
  }
  mousedown(e) {
    if (e.button == 0) {
      this.leftMouseButtonDowning = true;
    }
  }
  mouseup(e) {
    this.leftMouseButtonDowning = false;
  }
  getOffset(e, beginX, beginY) {
    var { x, y } = this.getPosition(e);
    var offsetX = x - beginX;
    var offsetY = y - beginY;
    return { offsetX, offsetY };
  }
  getPosition(e) {
    var { offsetBodyLeft, offsetBodyTop } = this.getOffsetFromBody();
    var { parentoffsetTop, parentOffsetLeft } = this.getScrollOffset(e.target, this.getViewEl());
    var x = e.clientX - offsetBodyLeft + parentOffsetLeft;
    var y = e.clientY - offsetBodyTop + parentoffsetTop;
    return { x, y };
  }
  getScrollOffset(fromEl, toEl) {
    if (!fromEl) {
      return { parentoffsetTop: 0, parentOffsetLeft: 0 };
    }
    if (fromEl == toEl) {
      return { parentoffsetTop: fromEl.scrollTop, parentOffsetLeft: fromEl.scrollLeft };
    }
    var { parentoffsetTop, parentOffsetLeft } = this.getScrollOffset(fromEl.parentElement, toEl);
    var curOffsetTop = fromEl.scrollTop;
    var curOffsetLeft = fromEl.scrollLeft;
    return { parentoffsetTop: curOffsetTop + parentoffsetTop, parentOffsetLeft: curOffsetLeft + parentOffsetLeft };
  }
  getOffsetFromBody() {
    return DomUtil.offsetBodyPosition(this.getViewEl());
  }
}
class AbstractPropertyState extends AbstractOptState {
  constructor(delegate) {
    super(delegate);
    this.view = delegate.getView();
  }
  getView() {
    return this.view;
  }
  getViewEl() {
    return this.view.getEl();
  }
}
let NormalState$5 = class NormalState2 extends AbstractPropertyState {
  mousedown(e) {
  }
  mousemove(e) {
  }
  mouseup(e) {
  }
};
let ResizeState$2 = class ResizeState2 extends AbstractPropertyState {
  constructor() {
    super(...arguments);
    this.startX = -1;
    this.orgRatio = -1;
  }
  mousedown(e) {
    super.mousedown(e);
    var { x, y } = this.getPosition(e);
    this.startX = x;
    this.orgRatio = this.view.getRatio();
  }
  mousemove(e) {
    if (!this.isLeftMouseButtonDowning())
      return;
    var { x, y } = this.getPosition(e);
    var offsetX = x - this.startX;
    var totalWidth = this.getView().getEl().clientWidth;
    var leftWidth = totalWidth * this.orgRatio;
    totalWidth * (1 - this.orgRatio);
    leftWidth += offsetX;
    if (leftWidth < 10)
      return;
    if (leftWidth > totalWidth - 10)
      return;
    var newRatio = leftWidth / totalWidth;
    this.view.setRatio(newRatio);
  }
  mouseup(e) {
    super.mouseup(e);
    this.getDelegate().setNormalState();
  }
};
class PropertyStateDelegate extends AbstractOptStateDelegate {
  constructor(view) {
    super(view);
    this.normalState = new NormalState$5(this);
    this.resizeState = new ResizeState$2(this);
    this.setInitState(this.normalState);
  }
  setNormalState() {
    this.setCurrentState(this.normalState);
  }
  setResizeState() {
    this.setCurrentState(this.resizeState);
  }
}
const _PropertyUIPanel = class _PropertyUIPanel2 extends AbstractDomElement {
  constructor(propertyGroups, callback, optDispatcher) {
    super();
    this.propertyGroups = propertyGroups;
    this.callback = callback;
    this.optDispatcher = optDispatcher;
    this.stateDelegate = new PropertyStateDelegate(this);
    this.addClassArray(this.styleFactory.getPropertyPanel());
    this.setStyle("position", "relative");
    this.init(propertyGroups);
    this.initEvents();
  }
  init(propertyGroups) {
    this.clearChildren();
    if (propertyGroups) {
      for (let group of propertyGroups) {
        var uiGroup = new PropertyUIGroup(group, this.callback, this.stateDelegate, this.optDispatcher);
        this.addChild(uiGroup);
        uiGroup.setOnEventListener(this);
      }
      this.resetHeight();
    }
  }
  /**
   * 事件注册
   */
  initEvents() {
    this.addEventListener("mousedown", (e) => {
      this.stateDelegate.getCurrentState().mousedown(e);
    });
    this.addEventListener("mousemove", (e) => {
      this.stateDelegate.getCurrentState().mousemove(e);
    });
    this.addEventListener("mouseup", (e) => {
      this.stateDelegate.getCurrentState().mouseup(e);
    });
  }
  notifyEvent(cmd, paras) {
    switch (cmd) {
      case Events.Focus:
        this.focus(paras.getElement());
        break;
      case Events.VauleChanged:
        this.fireValueChanged(paras.getElement());
        break;
    }
  }
  focus(el) {
    var lineEl = DomUtil.findParentElByClassName(el, "property-control-line");
    var propertyLine = this.findElement(lineEl);
    if (!propertyLine || propertyLine.isFocused()) {
      return;
    }
    this.unfocus();
    propertyLine.setFocused(true);
  }
  setPropertyValue(key2, value2, text) {
    var group;
    for (let child of this.getChildren()) {
      group = child;
      var uiControl = group.getPropertyControl(key2);
      uiControl == null ? void 0 : uiControl.setPropertyValue(value2, text);
    }
  }
  setFocus(key2) {
    var group;
    for (let child of this.getChildren()) {
      group = child;
      var uiControl = group.getPropertyControl(key2);
      uiControl == null ? void 0 : uiControl.setFocused(true);
    }
  }
  unfocus() {
    var group;
    for (let child of this.getChildren()) {
      group = child;
      group.unfocus();
    }
  }
  fireValueChanged(propertyUIControl) {
    if (!propertyUIControl)
      return;
    var propItem = propertyUIControl.getPropertyItem();
    if (propItem) {
      this.callback.setValue(propItem, propertyUIControl.getValue());
      this.updateVisiableAndEditable();
    }
  }
  async updateVisiableAndEditable() {
    for (var child of this.getChildren()) {
      if (child instanceof PropertyUIGroup) {
        if (child.isExpanded()) {
          await child.updateVisiableAndEditable();
        }
      }
    }
  }
  resize(width, height) {
    this.setStyleWidth(SizeInfo.valueOfPX(width));
    this.setStyleHeight(SizeInfo.valueOfPX(height));
    this.resetHeight();
  }
  getRatio() {
    return _PropertyUIPanel2.PROP_RATIO;
  }
  setRatio(ratio) {
    _PropertyUIPanel2.PROP_RATIO = ratio;
    for (let child of this.getChildren()) {
      if (child instanceof PropertyUIGroup) {
        child.resizeByRatio(ratio);
      }
    }
  }
  getInnerHeight() {
    var total = 0;
    for (let child of this.getChildren()) {
      if (child instanceof PropertyUIGroup) {
        var uiGroup = child;
        total += uiGroup.getInnerHeight();
      }
    }
    return total;
  }
  resetHeight() {
    var realHeight = this.getInnerHeight() + 10;
    this.setStyleHeight(SizeInfo.valueOfPX(realHeight));
    this.resetChildSize();
  }
  resetChildSize() {
    var parentEl = this.getEl().parentElement;
    parentEl && this.setStyleWidth(SizeInfo.valueOfPX(parentEl.clientWidth));
    for (let child of this.getChildren()) {
      if (parentEl) {
        child.resize(parentEl.clientWidth, this.getEl().clientHeight);
      }
    }
  }
};
_PropertyUIPanel.PROP_RATIO = 0.5;
let PropertyUIPanel = _PropertyUIPanel;
class PropertyPlugin {
  constructor(optDispatcher) {
    this.mapProperties = {};
    this.optDispatcher = optDispatcher;
  }
  register(componentName, propertyDefine) {
    this.mapProperties[componentName] = propertyDefine;
  }
  getPropertyGroupArray(componentName) {
    return this.mapProperties[componentName];
  }
  commit() {
    if (this.propertyPanel) {
      this.propertyPanel.unfocus();
    }
  }
  setPropertyValue(key2, value2, text) {
    var _a;
    (_a = this.propertyPanel) == null ? void 0 : _a.setPropertyValue(key2, value2, text);
  }
  setFocus(key2) {
    var _a;
    (_a = this.propertyPanel) == null ? void 0 : _a.setFocus(key2);
  }
  display(componentName, callback, parent, viewContainer) {
    var len = parent.childNodes.length;
    for (var i = len - 1; i >= 0; i--) {
      var child = parent.childNodes[i];
      if (child.nodeType == 1) {
        parent.removeChild(child);
      }
    }
    var propertyGroups = this.getPropertyGroupArray(componentName);
    this.propertyPanel = new PropertyUIPanel(propertyGroups, callback, this.optDispatcher);
    parent.appendChild(this.propertyPanel.getEl());
    this.createDrag(parent, viewContainer);
    this.propertyPanel.resize(parent.clientWidth, parent.clientHeight);
    window.addEventListener("resize", (e) => {
      var _a;
      (_a = this.propertyPanel) == null ? void 0 : _a.resize(parent.clientWidth, parent.clientHeight);
    });
    window.addEventListener("click", (e) => {
      var _a, _b;
      var el = DomUtil.findParentElByClassName(e.target, "property-control-line");
      if (!this.isModalDialog()) {
        var propertyLine = (_a = this.propertyPanel) == null ? void 0 : _a.findElement(el);
        if (!propertyLine && !DomUtil.isInDialog(e.target)) {
          (_b = this.propertyPanel) == null ? void 0 : _b.unfocus();
          return;
        }
      }
    }, true);
  }
  createDrag(parent, viewContainer) {
    if (!viewContainer)
      return;
    var drag = document.createElement("div");
    drag.classList.add("drag-bar");
    parent.style.position = "relative";
    parent.appendChild(drag);
    var self = this;
    let rightWrap = parent.parentNode;
    let isResizing = false;
    var minWidth = 30;
    function moveHandle(e) {
      var _a;
      if (!isResizing)
        return;
      const wrapRect = rightWrap.getBoundingClientRect();
      let newWidth = e.clientX - wrapRect.left;
      if (newWidth < minWidth)
        newWidth = minWidth;
      let rightWidth = wrapRect.width - newWidth;
      if (rightWidth < minWidth) {
        rightWidth = minWidth;
        newWidth = wrapRect.width - rightWidth;
      }
      let str = rightWrap.style.gridTemplateColumns;
      var newStr = str.replace(/(\s+)\d+px$/, ` ${rightWidth}px`);
      rightWrap.style.gridTemplateColumns = newStr;
      viewContainer == null ? void 0 : viewContainer.resize(newWidth, parent.clientHeight);
      (_a = self.propertyPanel) == null ? void 0 : _a.resize(rightWidth, parent.clientHeight);
    }
    function mouseupHandle() {
      isResizing = false;
      document.removeEventListener("mouseup", mouseupHandle);
      document.removeEventListener("mousemove", moveHandle);
    }
    drag.addEventListener("mousedown", function() {
      isResizing = true;
      document.addEventListener("mouseup", mouseupHandle);
      document.addEventListener("mousemove", moveHandle);
    });
  }
  isModalDialog() {
    return false;
  }
}
class DevPropertyPlugin extends PropertyPlugin {
  constructor(optDispatcher) {
    super(optDispatcher);
  }
  /**
   * 判断当前是否为弹出模态窗口状态
   * 
   * @returns 
   */
  isModalDialog() {
    if (!this.optDispatcher)
      return false;
    var form2 = this.optDispatcher.getForm();
    return !!form2.dialog;
  }
}
class JPanel extends JComponent {
  constructor(layout) {
    super(new DivElement());
    this.bMount = false;
    this.baseLayout = layout;
  }
  getTypeName() {
    return EComponentType.Panel;
  }
  setLayout(layout) {
    this.baseLayout = layout;
  }
  getLayout() {
    return this.baseLayout;
  }
  addComponent(component) {
    if (this.baseLayout) {
      var layoutItem = this.baseLayout.addLayoutItem(component);
      return layoutItem;
    }
    throw new Error("need define layout");
  }
  removeComponent(component) {
    if (this.baseLayout) {
      this.baseLayout.removeLayoutItem(component);
      return;
    }
    throw new Error("need define layout");
  }
  addEmptyLayoutItem() {
    if (this.baseLayout) {
      return this.baseLayout.addLayoutItem(null);
    }
    throw new Error("need define layout");
  }
  removeAll() {
    this.unmountAll();
    this.baseLayout && this.baseLayout.removeAll();
  }
  display() {
    this.unmountAll();
    this.mountChildren();
    this.layout();
  }
  undisplay(parent) {
    throw new Error("Method not implemented.");
  }
  reLayout(width, height) {
    this.setWidth(width);
    this.setHeight(height);
    this.mountChildren();
    this.layout();
  }
  unmountAll() {
    super.unmountAll();
    this.bMount = false;
  }
  layout() {
    this.baseLayout && this.baseLayout.layout(this);
  }
  /**
   * 挂载子节点
   */
  mountChildren() {
    if (this.baseLayout && !this.bMount) {
      for (let item of this.baseLayout.getLayoutItems()) {
        this.mountChild(item.getNode());
      }
      this.bMount = true;
    }
  }
}
class AbstractLayout {
  constructor() {
    this.areaRange = null;
    this.layoutItems = new ArrayList();
  }
  setAreaRange(areaRange) {
    this.areaRange = areaRange;
  }
  getAreaRange() {
    return this.areaRange;
  }
  setVGap(gap) {
    this.vGap = gap;
  }
  setHGap(gap) {
    this.hGap = gap;
  }
  addLayoutItem(node) {
    var item = this.createLayoutItem();
    item.setNode(node);
    this.layoutItems.add(item);
    return item;
  }
  removeLayoutItem(node) {
    for (let item of this.layoutItems.getList()) {
      if (item.getNode() == node) {
        item.setNode(null);
        this.layoutItems.remove(item);
        return;
      }
    }
  }
  removeAll() {
    for (let item of this.layoutItems.getList()) {
      item.setNode(null);
    }
    this.layoutItems.clearAll();
  }
  getLayoutItem(index) {
    return this.layoutItems.get(index);
  }
  getLayoutItems() {
    return this.layoutItems.getList();
  }
}
class BaseLayoutItem {
  constructor() {
    this.node = null;
  }
  setNode(node) {
    this.node = node;
  }
  getNode() {
    return this.node;
  }
  resize(width, height) {
  }
}
class BaseLayout extends AbstractLayout {
  constructor() {
    super();
  }
  layout(container) {
    this.layoutChildren(container);
  }
  layoutChildren(container) {
    for (let layoutItem of this.layoutItems.getList()) {
      let node = layoutItem.getNode();
      node && node.display();
    }
  }
  createLayoutItem() {
    return new BaseLayoutItem();
  }
}
class ContainerPanel extends JPanel {
  constructor() {
    super(new BaseLayout());
    this.setStyle("overflow", "auto");
  }
  addComponent(component) {
    var layoutItem = super.addComponent(component);
    return layoutItem;
  }
}
class PropertyContainer extends ContainerPanel {
  constructor(propertyPlugin) {
    super();
    this.propertyPlugin = propertyPlugin;
  }
  getPropertyPlugin() {
    return this.propertyPlugin;
  }
}
class GridLayoutItem extends BaseLayoutItem {
  constructor() {
    super(...arguments);
    this.x = 0;
    this.y = 0;
    this.xSpan = 1;
    this.ySpan = 1;
  }
  setX(x) {
    this.x = x;
  }
  getX() {
    return this.x;
  }
  setY(y) {
    this.y = y;
  }
  getY() {
    return this.y;
  }
  setXSpan(xSpan) {
    this.xSpan = xSpan;
  }
  getXSpan() {
    return this.xSpan;
  }
  setYSpan(ySpan) {
    this.ySpan = ySpan;
  }
  getYSpan() {
    return this.ySpan;
  }
}
class H5GridLayout extends AbstractLayout {
  constructor() {
    super();
    this.layoutRows = [];
    this.layoutColumns = [];
  }
  setRowSize(index, size) {
    this.layoutRows[index] = size;
  }
  addRow(rowSize) {
    this.layoutRows.push(rowSize);
  }
  setColumnSize(index, size) {
    this.layoutColumns[index] = size;
  }
  addColumn(columnSize) {
    this.layoutColumns.push(columnSize);
  }
  layout(container) {
    container.setStyle("display", "grid");
    container.setStyle("width", container.getWidth().toString());
    container.setStyle("height", container.getHeight().toString());
    this.vGap && container.setStyle("row-gap", this.vGap.toString());
    this.hGap && container.setStyle("column-gap", this.hGap.toString());
    container.setStyle("grid-template-columns", this.getGridTemplateColumnsString());
    container.setStyle("grid-template-rows", this.getGridTemplateRowsString());
    let child = null;
    for (let layoutItem of this.layoutItems.getList()) {
      child = layoutItem.getNode();
      if (child != null) {
        var style = this.getGridAreaString(layoutItem);
        child.setStyle("grid-area", style);
        child.display();
      }
    }
  }
  createLayoutItem() {
    return new GridLayoutItem();
  }
  getGridAreaString(item) {
    var startX = item.getX();
    var endX = item.getX() + item.getXSpan() - 1;
    var startY = item.getY();
    var endY = item.getY() + item.getYSpan() - 1;
    return startY + "/ " + startX + "/ " + endY + "/ " + endX;
  }
  getGridTemplateColumnsString() {
    var str = "";
    for (let layoutColumn of this.layoutColumns) {
      str += " " + layoutColumn.toString();
    }
    return str;
  }
  getGridTemplateRowsString() {
    var str = "";
    for (let layoutRow of this.layoutRows) {
      str += " " + layoutRow.toString();
    }
    return str;
  }
}
class H5GridPanel extends JPanel {
  constructor() {
    super(new H5GridLayout());
  }
  initGrid(rows, columns, rowGap = SizeInfo.PX2, colGap = SizeInfo.PX2) {
    rowGap && this.setRowGap(rowGap);
    colGap && this.setColumnGap(colGap);
    for (let columnSize of columns) {
      this.addColumn(columnSize);
    }
    for (let rowSize of rows) {
      this.addRow(rowSize);
    }
  }
  addColumn(width) {
    this.getLayout().addColumn(width);
  }
  addRow(height) {
    this.getLayout().addRow(height);
  }
  setRowGap(rowGap) {
    this.getLayout().setVGap(rowGap);
  }
  setColumnGap(colGap) {
    this.getLayout().setHGap(colGap);
  }
  addComponent(component, x = 0, y = 0, xSpan = 1, ySpan = 1) {
    var layoutItem = super.addComponent(component);
    layoutItem.setX(x);
    layoutItem.setY(y);
    layoutItem.setXSpan(xSpan);
    layoutItem.setYSpan(ySpan);
    return layoutItem;
  }
}
class BorderPanel extends H5GridPanel {
  constructor(left, right, top, bottom) {
    super();
    this.setStyle("overflow", "hidden");
    this.initGrid(
      [SizeInfo.valueOfPX(top), SizeInfo.AUTO_SIZE, SizeInfo.valueOfPX(bottom)],
      [SizeInfo.valueOfPX(left), SizeInfo.AUTO_SIZE, SizeInfo.valueOfPX(right)],
      null,
      null
    );
  }
  setTop(topElement) {
    this.topNode && this.removeComponent(this.topNode);
    this.topNode = topElement;
    return this.addComponent(topElement, 1, 1, 4, 1);
  }
  setLeft(leftElement) {
    this.leftNode && this.removeComponent(this.leftNode);
    this.leftNode = leftElement;
    return this.addComponent(leftElement, 1, 2, 1, 1);
  }
  hasLeft() {
    return !!this.leftNode;
  }
  setRight(rightElement) {
    this.rightNode && this.removeComponent(this.rightNode);
    this.rightNode = rightElement;
    return this.addComponent(rightElement, 3, 2, 1, 1);
  }
  setBottom(bottomElement) {
    this.bottomNode && this.removeComponent(this.bottomNode);
    this.bottomNode = bottomElement;
    return this.addComponent(bottomElement, 1, 3, 4, 1);
  }
  setCenter(centerElement) {
    if (this.centerNode) {
      this.removeComponent(this.centerNode);
    }
    this.centerNode = centerElement;
    return this.addComponent(centerElement, 2, 2, 1, 1);
  }
}
class AbstractDesignView extends BorderPanel {
  constructor(propertyWidth, propertyUIContainer) {
    super(0, propertyWidth, 0, 0);
    this.propertyUIContainer = propertyUIContainer;
  }
  getPropertyUIContainer() {
    return this.propertyUIContainer;
  }
}
class DesignVariable {
}
DesignVariable.D_PROPERTY_WIDTH = 350;
DesignVariable.D_M_PROPERTY_WIDTH = 450;
let DevDesignView$1 = class DevDesignView2 extends AbstractDesignView {
  constructor(viewContainer, optDispatcher) {
    super(DesignVariable.D_PROPERTY_WIDTH, new PropertyContainer(new DevPropertyPlugin(optDispatcher)));
    this.viewContainer = viewContainer;
    this.propertyPlugin = this.propertyUIContainer.getPropertyPlugin();
    this.propertyUIContainer.setStyle("float", "right");
    this.setCenter(viewContainer);
    this.setRight(this.propertyUIContainer);
    var PD = WfDevPropertyDefine.getInstance();
    this.propertyPlugin.register(WfConstants.NODE_Process, PD.getPropertyDefines(WfConstants.NODE_Process));
    this.propertyPlugin.register(WfConstants.NODE_Flow_Sequence, PD.getPropertyDefines(WfConstants.NODE_Flow_Sequence));
    this.propertyPlugin.register(WfConstants.NODE_Event_Begin, PD.getPropertyDefines(WfConstants.NODE_Event_Begin));
    this.propertyPlugin.register(WfConstants.NODE_Event_State, PD.getPropertyDefines(WfConstants.NODE_Event_State));
    this.propertyPlugin.register(WfConstants.NODE_Event_End, PD.getPropertyDefines(WfConstants.NODE_Event_End));
    this.propertyPlugin.register(WfConstants.NODE_Event_BranchEnd, PD.getPropertyDefines(WfConstants.NODE_Event_BranchEnd));
    this.propertyPlugin.register(WfConstants.NODE_Gateway_GateWay, PD.getPropertyDefines(WfConstants.NODE_Gateway_GateWay));
    this.propertyPlugin.register(WfConstants.NODE_Gateway_ComplexJoin, PD.getPropertyDefines(WfConstants.NODE_Gateway_ComplexJoin));
    this.propertyPlugin.register(WfConstants.NODE_Gateway_Decision, PD.getPropertyDefines(WfConstants.NODE_Gateway_Decision));
    this.propertyPlugin.register(WfConstants.NODE_Gateway_ExclusiveFork, PD.getPropertyDefines(WfConstants.NODE_Gateway_ExclusiveFork));
    this.propertyPlugin.register(WfConstants.NODE_Gateway_Fork, PD.getPropertyDefines(WfConstants.NODE_Gateway_Fork));
    this.propertyPlugin.register(WfConstants.NODE_Gateway_Join, PD.getPropertyDefines(WfConstants.NODE_Gateway_Join));
    this.propertyPlugin.register(WfConstants.NODE_Task_Audit, PD.getPropertyDefines(WfConstants.NODE_Task_Audit));
    this.propertyPlugin.register(WfConstants.NODE_Task_Service, PD.getPropertyDefines(WfConstants.NODE_Task_Service));
    this.propertyPlugin.register(WfConstants.NODE_Task_Manual, PD.getPropertyDefines(WfConstants.NODE_Task_Manual));
    this.propertyPlugin.register(WfConstants.NODE_Task_User, PD.getPropertyDefines(WfConstants.NODE_Task_User));
    this.propertyPlugin.register(WfConstants.NODE_Task_DataMap, PD.getPropertyDefines(WfConstants.NODE_Task_DataMap));
    this.propertyPlugin.register(WfConstants.NODE_Task_CounterSign, PD.getPropertyDefines(WfConstants.NODE_Task_CounterSign));
    this.propertyPlugin.register(WfConstants.NODE_Task_MultiUser, PD.getPropertyDefines(WfConstants.NODE_Task_MultiUser));
    this.propertyPlugin.register(WfConstants.NODE_Task_MultiAudit, PD.getPropertyDefines(WfConstants.NODE_Task_MultiAudit));
    this.propertyPlugin.register(WfConstants.NODE_Task_StateAction, PD.getPropertyDefines(WfConstants.NODE_Task_StateAction));
    this.propertyPlugin.register(WfConstants.NODE_SubProcess, PD.getPropertyDefines(WfConstants.NODE_SubProcess));
    this.propertyPlugin.register(WfConstants.NODE_Inline, PD.getPropertyDefines(WfConstants.NODE_Inline));
  }
  resize(parentWidth, parentHeight) {
    var width = parentWidth - DesignVariable.D_PROPERTY_WIDTH;
    this.viewContainer.resize(width, parentHeight);
    this.propertyUIContainer.setHeight(SizeInfo.valueOfPX(parentHeight));
  }
};
const _WfUserPropertyDefine = class _WfUserPropertyDefine2 extends AbstractPropertyDefine {
  constructor() {
    super(new PropertyManager(BPMN.PROPERTIES_XML_USER));
  }
  static getInstance() {
    return _WfUserPropertyDefine2.instance;
  }
};
_WfUserPropertyDefine.instance = new _WfUserPropertyDefine();
let WfUserPropertyDefine = _WfUserPropertyDefine;
class Tab {
  constructor(key2, caption, emitter) {
    this.selected = false;
    this.key = key2;
    this.caption = caption;
    this.nav = new TabNav(this, emitter);
    this.content = new TabContent(this);
  }
  getKey() {
    return this.key;
  }
  getCaption() {
    return this.caption;
  }
  getNav() {
    return this.nav;
  }
  getContent() {
    return this.content;
  }
  setView(view) {
    this.content.setView(view);
  }
  getView() {
    return this.content.getView();
  }
  isSelected() {
    return this.selected;
  }
  select() {
    this.selected = true;
    this.nav.select();
    this.content.select();
  }
  unselect() {
    this.selected = false;
    this.nav.unselect();
    this.content.unselect();
  }
}
class TabNav extends AbstractDomElement {
  constructor(tab, emitter) {
    super();
    this.tab = tab;
    this.setText(tab.getCaption());
    this.skin = StyleFactoryMananger.getInstance().getStyleFactory().getTabPaneSkin();
    this.addEventListener("click", function(e) {
      emitter.emit(Events.Tab.NAV_SELECT, tab);
    });
  }
  getTab() {
    return this.tab;
  }
  createEl() {
    return super.createEl("li");
  }
  select() {
    this.addClass(this.skin.tab_nav_this);
  }
  unselect() {
    this.removeClass(this.skin.tab_nav_this);
  }
}
class TabContent extends AbstractDomElement {
  constructor(tab) {
    super();
    this.tab = tab;
    this.skin = StyleFactoryMananger.getInstance().getStyleFactory().getTabPaneSkin();
    this.addClass(this.skin.tab_item);
    this.setStyle("height", 150);
  }
  getTab() {
    return this.tab;
  }
  setView(view) {
    this.view = view;
  }
  getView() {
    return this.view;
  }
  display() {
    this.view && this.view.display(this);
  }
  undisplay() {
    this.view && this.view.undisplay(this);
  }
  select() {
    this.addClass("swing-show");
    this.display();
  }
  unselect() {
    this.removeClass("swing-show");
    this.undisplay();
  }
}
const TEMPLATE_TAB_CONTAINER = `
<div>
    <ul class="tab-nav-group"></ul>
    <div class="tab-content-group"></div>
</div>`;
class TabbedPaneElement extends AbstractDomElement {
  createEl() {
    return DomUtil.parseEl(TEMPLATE_TAB_CONTAINER);
  }
}
class EventHub {
  constructor() {
    this.cache = {};
  }
  // 缓存订阅的事件   
  // {
  //     'xxx事件': [fn1, fn2, fn3]
  // }
  // 把fn 推进this.cache[eventName]数组里
  on(eventName, fn) {
    this.cache[eventName] = this.cache[eventName] || [];
    this.cache[eventName].push(fn);
  }
  // 依次执行this.cache[eventName]数组里的函数
  emit(eventName, params) {
    (this.cache[eventName] || []).forEach((fn) => fn(params));
  }
  // 取消订阅的事件
  off(eventName, fn) {
    let index = this.indexOf(this.cache[eventName], fn);
    index !== -1 && this.cache[eventName].splice(index, 1);
  }
  /**
  * 帮助函数
  * @param array 
  * @param item 
  */
  indexOf(array, item) {
    if (array === void 0)
      return -1;
    let index = -1;
    for (let i = 0; i < array.length; i++) {
      if (array[i] === item) {
        index = i;
        break;
      }
    }
    return index;
  }
}
class JTabbedPane extends JComponent {
  constructor() {
    super(new TabbedPaneElement());
    this.emitter = new EventHub();
    this.tabs = new ArrayList();
    this.navGroup = new DomElement(this.getEl().querySelector("ul.tab-nav-group"));
    this.contentGroup = new DomElement(this.getEl().querySelector("div.tab-content-group"));
    var skin = this.styleFactory.getTabPaneSkin();
    this.addClass(skin.tab);
    this.navGroup.addClass(skin.tab_title);
    this.contentGroup.addClass(skin.tab_content);
    var self = this;
    this.emitter.on(Events.Tab.NAV_SELECT, function(tab) {
      self.selectTab(tab);
    });
    this.emitter.on(Events.Tab.NAV_CLOSE, function(tab) {
      self.removeTab(tab);
    });
  }
  addTab(key2, caption) {
    var tab = new Tab(key2, caption, this.emitter);
    this.navGroup.addChild(tab.getNav());
    this.contentGroup.addChild(tab.getContent());
    this.tabs.add(tab);
    return tab;
  }
  removeTabByKey(key2) {
    var tab = this.getTabByKey(key2);
    this.removeTab(tab);
  }
  selectTab(tab) {
    if (tab) {
      this.unSelectAll();
      tab.select();
    }
  }
  getSelectedTab() {
    for (let tab of this.tabs.getList()) {
      if (tab.isSelected())
        return tab;
    }
    return null;
  }
  select(index) {
    var tab = this.tabs.get(index);
    this.selectTab(tab);
  }
  close(index) {
    var tab = this.tabs.get(index);
    this.removeTab(tab);
  }
  closeAll() {
    for (let tab of this.tabs.getList()) {
      this.navGroup.removeChild(tab.getNav());
      this.contentGroup.removeChild(tab.getContent());
    }
    this.tabs.clearAll();
  }
  getTabByKey(key2) {
    for (let tab of this.tabs.getList()) {
      if (tab.getKey() == key2) {
        return tab;
      }
    }
    return null;
  }
  setNavHeight(height) {
    this.navGroup.setStyleHeight(SizeInfo.valueOf(height, ESizeType.px));
  }
  removeTab(tab) {
    if (tab != null) {
      this.navGroup.removeChild(tab.getNav());
      this.contentGroup.removeChild(tab.getContent());
      var index = this.tabs.remove(tab);
      if (index < this.tabs.getSize()) {
        this.select(index);
      } else if (index > 0) {
        this.select(index - 1);
      }
    }
  }
  display() {
    var tab = this.getSelectedTab();
    if (tab) {
      tab.getContent().display();
    }
  }
  unSelectAll() {
    for (let tab of this.tabs.getList()) {
      tab.unselect();
    }
  }
}
class BasePropertyView {
  constructor(groups, callback, optDispatcher) {
    this.propertyPanel = new PropertyUIPanel(groups, callback, optDispatcher);
    this.propertyPanel.setStyle("border", "none");
  }
  setPropertyValue(key2, value2, text) {
    this.propertyPanel.setPropertyValue(key2, value2, text);
  }
  setFocus(key2) {
    this.propertyPanel.setFocus(key2);
  }
  display(parent) {
    parent.addChild(this.propertyPanel);
  }
  focus(el) {
    this.propertyPanel.focus(el.getHtmlElement());
  }
  unfocus() {
    this.propertyPanel.unfocus();
  }
  undisplay(parent) {
    parent.removeChild(this.propertyPanel);
  }
  resize(width, height) {
    if (width.getType() == ESizeType.px && height.getType() == ESizeType.px) {
      this.propertyPanel.setStyleWidth(width);
      this.propertyPanel.setStyleHeight(height);
      this.propertyPanel.resize(width.getValue(), height.getValue());
    }
  }
}
class ParticipatorUIGroupItem extends GroupElement {
  constructor(caption, expanded, grid, callback) {
    super(caption, expanded);
    this.grid = grid;
    this.addClass("property-group");
    this.callback = callback;
    this.displayGroup();
  }
  setOnEventListener(eventListener) {
    this.eventListener = eventListener;
  }
  unfocus() {
  }
  displayGroup() {
    this.grid && this.addChild(new DomElement(this.grid.$el[0]));
  }
  resize(width, height) {
  }
  resetHeight() {
  }
}
class WfTagNodeUtil {
  static getOperationAction(tagNode) {
    var tmpNode = tagNode.getChild(GlobalConstants.S_Action);
    return tmpNode ? tmpNode.getCDATAValue() : "";
  }
  static getParticipatorFormula(tagNode) {
    if (tagNode.getTagName() == GlobalConstants.S_MidFormula || tagNode.getTagName() == GlobalConstants.S_Query) {
      return tagNode.getCDATAValue();
    } else {
      return "";
    }
  }
}
class ParticipatorUIGroup extends AbstractDomElement {
  constructor(operationDispatcher) {
    super();
    this.optDispatcher = operationDispatcher;
    this.addClassArray(this.styleFactory.getPropertyPanel());
  }
  loadProperty(participatorProperty, callback) {
    this.clearChildren();
    this.participatorProperty = participatorProperty;
    this.callback = callback;
    ControlFactory.getPropertyGrid(GlobalConstants.S_Operator, this.optDispatcher).then((gridOperator) => {
      if (gridOperator) {
        var uiGroup = new ParticipatorUIGroupItem("操作员选择", true, gridOperator, callback);
        this.addChild(uiGroup);
        uiGroup.setOnEventListener(this);
        this.initDictoryGrid(gridOperator, "Operator");
      }
    });
    ControlFactory.getPropertyGrid(GlobalConstants.S_Role, this.optDispatcher).then((gridRole) => {
      if (gridRole) {
        var uiGroup = new ParticipatorUIGroupItem("角色选择", true, gridRole, callback);
        this.addChild(uiGroup);
        uiGroup.setOnEventListener(this);
        this.initDictoryGrid(gridRole, "Role");
      }
    });
    ControlFactory.getPropertyGrid(GlobalConstants.S_Participator, this.optDispatcher).then((gridParticipator) => {
      if (gridParticipator) {
        var uiGroup = new ParticipatorUIGroupItem("自定义参与者", true, gridParticipator, callback);
        this.addChild(uiGroup);
        uiGroup.setOnEventListener(this);
        this.initParticipatorGrid(gridParticipator);
      }
    });
  }
  notifyEvent(cmd, paras) {
    switch (cmd) {
      case Events.Focus:
        this.focus(paras.getElement());
        break;
    }
  }
  focus(el) {
  }
  unfocus() {
  }
  clearRows() {
  }
  async initDictoryGrid(grid, gridItemKey) {
    var row = 0;
    var collection = this.callback.getValue(this.participatorProperty);
    for (let node of collection.getChildren()) {
      if (node.getTagName() == GlobalConstants.S_Dictionary) {
        var tagNode = node;
        var itemKey = tagNode.getAttributeValue(GlobalConstants.S_ItemKey);
        if (gridItemKey == itemKey) {
          var itemIDs = tagNode.getAttributeValue(GlobalConstants.S_ItemID);
          if (itemIDs) {
            var ids = String(itemIDs);
            var arrItemIDs = ids.split(":");
            for (let id of arrItemIDs) {
              var dictID = parseInt(id);
              if (dictID > 0) {
                await grid.setValueAt(row, 0, dictID);
                row = await grid.insertRow(-1);
              }
            }
          }
          var itemCodes = tagNode.getAttributeValue(GlobalConstants.S_Code);
          if (itemCodes) {
            var codes = String(itemCodes);
            var arrItemCodes = codes.split(":");
            for (let code of arrItemCodes) {
              var dictID = await this.optDispatcher.queryDictID(itemKey, code);
              if (dictID > 0) {
                await grid.setValueAt(row, 0, dictID);
                row = await grid.insertRow(-1);
              }
            }
          }
        }
      }
    }
  }
  async initParticipatorGrid(participatorGrid) {
    var row = 0;
    var collection = this.callback.getValue(this.participatorProperty);
    for (let node of collection.getChildren()) {
      if (node.getTagName() == GlobalConstants.S_MidFormula || node.getTagName() == GlobalConstants.S_Query) {
        var tagNode = node;
        var formula = WfTagNodeUtil.getParticipatorFormula(tagNode);
        var id = await this.optDispatcher.queryFormulaDictID(formula);
        await participatorGrid.setValueAt(row, 0, id);
        await participatorGrid.setValueAt(row, 1, formula);
        await participatorGrid.setValueAt(row, 2, tagNode.toXml(true));
        row = await participatorGrid.insertRow(-1);
      }
    }
  }
  resize(width, height) {
    for (let child of this.getChildren()) {
      child.resize(width, height);
    }
  }
}
class ParticipatorPropertyView {
  constructor(operationDispatcher, participatorProperty, callback) {
    this.participatorUIGroup = new ParticipatorUIGroup(operationDispatcher);
    this.participatorProperty = participatorProperty;
    this.callback = callback;
  }
  focus(el) {
  }
  unfocus() {
  }
  display(parentDomElement, width, height) {
    this.loadProperty(this.participatorProperty, this.callback);
    parentDomElement.addChild(this.participatorUIGroup);
  }
  undisplay(parentEl) {
    parentEl.removeChild(this.participatorUIGroup);
  }
  resize(width, height) {
  }
  loadProperty(participatorProperty, callback) {
    this.participatorUIGroup.loadProperty(participatorProperty, callback);
  }
}
class OperationPropertyView {
  constructor(operationDispatcher, operationProperty, callback) {
    this.operationDispatcher = operationDispatcher;
    this.operationProperty = operationProperty;
    this.callback = callback;
  }
  async fillDataToGrid(collection, grid) {
    var row = 0;
    var optDispatcher = this.operationDispatcher;
    for (let node of collection.getChildren()) {
      if (node instanceof TagNode) {
        var tagNode = node;
        var action = WfTagNodeUtil.getOperationAction(tagNode);
        var id = await optDispatcher.queryFormulaDictID(action);
        await grid.setValueAt(row, 0, id);
        await grid.setValueAt(row, 1, action);
        await grid.setValueAt(row, 2, tagNode.toXml(true));
        row = await grid.insertRow(-1);
      }
    }
  }
  focus(el) {
  }
  unfocus() {
  }
  display(parentDomElement) {
    this.loadProperty(this.operationProperty, this.callback).then((optGrid) => {
      this.grid = optGrid;
      optGrid && parentDomElement.addChild(optGrid.getDomElement());
    });
  }
  undisplay(parentEl) {
    this.grid && parentEl.removeChild(this.grid.getDomElement());
  }
  resize(width, height) {
    if (!this.grid)
      return;
    if (width.getType() == ESizeType.px && height.getType() == ESizeType.px) {
      this.grid.$el.width(width.getValue());
      this.grid.$el.height(height.getValue());
    }
  }
  async loadProperty(operationProperty, callback) {
    this.operationProperty = operationProperty;
    this.callback = callback;
    const optGrid = await ControlFactory.getPropertyGrid(GlobalConstants.S_Operation, this.operationDispatcher);
    if (!optGrid)
      return;
    var collection = this.callback.getValue(this.operationProperty);
    this.fillDataToGrid(collection, optGrid);
    return optGrid;
  }
}
class BPMPropertyUIPanel extends JTabbedPane {
  constructor(operationDispatcher) {
    super();
    this.operationDispatcher = operationDispatcher;
    this.addClassArray(this.styleFactory.getPropertyPanel());
  }
  loadProperty(groups, callback) {
    this.tabBase = this.addTab("Base", "基础");
    this.basePropertyView = new BasePropertyView(groups, callback, this.operationDispatcher);
    var view = this.basePropertyView;
    this.tabBase.setView(view);
    var propertyItem = this.getPropertyItem(WfConstants.NODE_ParticipatorCollection, groups);
    if (propertyItem) {
      this.tabParticipator = this.addTab("Participator", "参与者");
      var viewParticipator = new ParticipatorPropertyView(this.operationDispatcher, propertyItem, callback);
      this.tabParticipator.setView(viewParticipator);
    }
    propertyItem = this.getPropertyItem(WfConstants.NODE_OperationCollection, groups);
    if (propertyItem) {
      this.tabOperation = this.addTab("Operation", "操作项");
      var viewOperation = new OperationPropertyView(this.operationDispatcher, propertyItem, callback);
      this.tabOperation.setView(viewOperation);
    }
    this.select(0);
  }
  setPropertyValue(key2, value2, text) {
    var _a;
    (_a = this.basePropertyView) == null ? void 0 : _a.setPropertyValue(key2, value2, text);
  }
  setFocus(key2) {
    var _a;
    (_a = this.basePropertyView) == null ? void 0 : _a.setFocus(key2);
  }
  getPropertyItem(key2, groups) {
    if (groups) {
      for (let group of groups) {
        for (let item of group.properties) {
          if (item.key == key2) {
            return item;
          }
        }
      }
    }
    return void 0;
  }
  notifyEvent(cmd, paras) {
    switch (cmd) {
      case Events.Focus:
        this.focus(paras.getElement());
        break;
    }
  }
  focus(el) {
    var _a;
    (_a = this.tabBase) == null ? void 0 : _a.getView().focus(el);
  }
  unfocus() {
    var _a;
    (_a = this.tabBase) == null ? void 0 : _a.getView().unfocus();
  }
  display(width, height) {
    var _a;
    (_a = this.tabBase) == null ? void 0 : _a.getView().display(this.tabBase.getContent(), width, height);
  }
  resize(width, height) {
    var _a, _b, _c;
    var widthInfo = SizeInfo.valueOfPX(width - 5);
    var heightInfo = SizeInfo.valueOfPX(height - 40 - 5);
    (_a = this.tabBase) == null ? void 0 : _a.getView().resize(widthInfo, heightInfo);
    (_b = this.tabParticipator) == null ? void 0 : _b.getView().resize(widthInfo, heightInfo);
    (_c = this.tabOperation) == null ? void 0 : _c.getView().resize(widthInfo, heightInfo);
  }
}
class BPMPropertyPlugin {
  constructor(operationDispatcher) {
    this.mapProperties = {};
    this.operationDispatcher = operationDispatcher;
  }
  setFocus(key2) {
    var _a;
    (_a = this.propertyPanel) == null ? void 0 : _a.setFocus(key2);
  }
  setPropertyValue(key2, value2, text) {
    var _a;
    (_a = this.propertyPanel) == null ? void 0 : _a.setPropertyValue(key2, value2, text);
  }
  register(componentName, propertyDefine) {
    this.mapProperties[componentName] = propertyDefine;
  }
  getPropertyGroupArray(componentName) {
    return this.mapProperties[componentName];
  }
  commit() {
    if (this.propertyPanel) {
      this.propertyPanel.unfocus();
    }
  }
  display(componentName, callback, parent) {
    this.propertyPanel && parent.removeChild(this.propertyPanel.getEl());
    this.propertyPanel = void 0;
    var propertyGroups = this.getPropertyGroupArray(componentName);
    var tmpPropertyPanel = new BPMPropertyUIPanel(this.operationDispatcher);
    tmpPropertyPanel.loadProperty(propertyGroups, callback);
    parent.appendChild(tmpPropertyPanel.getEl());
    tmpPropertyPanel.display(SizeInfo.valueOfPX(parent.clientWidth), SizeInfo.valueOfPX(parent.clientWidth));
    tmpPropertyPanel.resize(parent.clientWidth, parent.clientHeight);
    this.propertyPanel = tmpPropertyPanel;
    window.addEventListener("resize", (e) => {
      var _a;
      (_a = this.propertyPanel) == null ? void 0 : _a.resize(parent.clientWidth, parent.clientHeight);
    });
  }
}
class UserDesignView extends AbstractDesignView {
  constructor(viewContainer, operationDispatcher) {
    super(WfDefines.USER_PROPERTY_WIDTH, new PropertyContainer(new BPMPropertyPlugin(operationDispatcher)));
    this.viewContainer = viewContainer;
    this.propertyPlugin = this.propertyUIContainer.getPropertyPlugin();
    this.propertyUIContainer.setStyle("float", "right");
    this.setCenter(viewContainer);
    this.setRight(this.propertyUIContainer);
    var PD = WfUserPropertyDefine.getInstance();
    this.propertyPlugin.register(WfConstants.NODE_Process, PD.getPropertyDefines(WfConstants.NODE_Process));
    this.propertyPlugin.register(WfConstants.NODE_Flow_Sequence, PD.getPropertyDefines(WfConstants.NODE_Flow_Sequence));
    this.propertyPlugin.register(WfConstants.NODE_Event_Begin, PD.getPropertyDefines(WfConstants.NODE_Event_Begin));
    this.propertyPlugin.register(WfConstants.NODE_Event_State, PD.getPropertyDefines(WfConstants.NODE_Event_State));
    this.propertyPlugin.register(WfConstants.NODE_Event_End, PD.getPropertyDefines(WfConstants.NODE_Event_End));
    this.propertyPlugin.register(WfConstants.NODE_Event_BranchEnd, PD.getPropertyDefines(WfConstants.NODE_Event_BranchEnd));
    this.propertyPlugin.register(WfConstants.NODE_Gateway_GateWay, PD.getPropertyDefines(WfConstants.NODE_Gateway_GateWay));
    this.propertyPlugin.register(WfConstants.NODE_Gateway_ComplexJoin, PD.getPropertyDefines(WfConstants.NODE_Gateway_ComplexJoin));
    this.propertyPlugin.register(WfConstants.NODE_Gateway_Decision, PD.getPropertyDefines(WfConstants.NODE_Gateway_Decision));
    this.propertyPlugin.register(WfConstants.NODE_Gateway_ExclusiveFork, PD.getPropertyDefines(WfConstants.NODE_Gateway_ExclusiveFork));
    this.propertyPlugin.register(WfConstants.NODE_Gateway_Fork, PD.getPropertyDefines(WfConstants.NODE_Gateway_Fork));
    this.propertyPlugin.register(WfConstants.NODE_Gateway_Join, PD.getPropertyDefines(WfConstants.NODE_Gateway_Join));
    this.propertyPlugin.register(WfConstants.NODE_Task_Audit, PD.getPropertyDefines(WfConstants.NODE_Task_Audit));
    this.propertyPlugin.register(WfConstants.NODE_Task_Service, PD.getPropertyDefines(WfConstants.NODE_Task_Service));
    this.propertyPlugin.register(WfConstants.NODE_Task_Manual, PD.getPropertyDefines(WfConstants.NODE_Task_Manual));
    this.propertyPlugin.register(WfConstants.NODE_Task_User, PD.getPropertyDefines(WfConstants.NODE_Task_User));
    this.propertyPlugin.register(WfConstants.NODE_Task_DataMap, PD.getPropertyDefines(WfConstants.NODE_Task_DataMap));
    this.propertyPlugin.register(WfConstants.NODE_Task_CounterSign, PD.getPropertyDefines(WfConstants.NODE_Task_CounterSign));
    this.propertyPlugin.register(WfConstants.NODE_Task_MultiUser, PD.getPropertyDefines(WfConstants.NODE_Task_MultiUser));
    this.propertyPlugin.register(WfConstants.NODE_Task_MultiAudit, PD.getPropertyDefines(WfConstants.NODE_Task_MultiAudit));
    this.propertyPlugin.register(WfConstants.NODE_Task_StateAction, PD.getPropertyDefines(WfConstants.NODE_Task_StateAction));
    this.propertyPlugin.register(WfConstants.NODE_SubProcess, PD.getPropertyDefines(WfConstants.NODE_SubProcess));
    this.propertyPlugin.register(WfConstants.NODE_Inline, PD.getPropertyDefines(WfConstants.NODE_Inline));
  }
  resize(parentWidth, parentHeight) {
    var width = parentWidth - WfDefines.USER_PROPERTY_WIDTH;
    this.viewContainer.resize(width, parentHeight);
    this.propertyUIContainer.setHeight(SizeInfo.valueOfPX(parentHeight));
  }
}
class MathUtil {
  static offsetByTan(distance, tan, directX, directY) {
    if (tan == Number.MAX_SAFE_INTEGER) {
      return { offsetX: 0, offsetY: distance * directY };
    }
    var sin = Math.sqrt(tan * tan / (1 + tan * tan));
    var cos = Math.sqrt(1 / (1 + tan * tan));
    var offset = { offsetX: distance * cos * directX, offsetY: distance * sin * directY };
    return offset;
  }
  static tan(x1, y1, x2, y2) {
    if (x1 == x2)
      return Number.MAX_SAFE_INTEGER;
    return (y2 - y1) / (x2 - x1);
  }
  static isPercentage(v) {
    return v && /^(\d{1,2}%)$|^(100%)$/.test(v);
  }
}
const _I18N = class _I18N2 {
  static register(key2, text) {
    _I18N2.map.set(key2, text);
  }
  static getString(key2) {
    var v = _I18N2.map.get(key2);
    if (!v) {
      v = _I18N2.map.get(key2.toLowerCase());
      if (!v) {
        return key2;
      }
    }
    return v;
  }
};
_I18N.map = /* @__PURE__ */ new Map([
  [WfConstants.NODE_Process, WfConstants.C_Process],
  [WfConstants.NODE_Hand, WfConstants.C_Hand],
  [WfConstants.NODE_Flow_Sequence, WfConstants.C_Flow_Sequence],
  [WfConstants.NODE_Event_Begin, WfConstants.C_Event_Begin],
  [WfConstants.NODE_Event_BranchEnd, WfConstants.C_Event_BranchEnd],
  [WfConstants.NODE_Event_End, WfConstants.C_Event_End],
  [WfConstants.NODE_Event_State, WfConstants.C_Event_State],
  [WfConstants.NODE_Gateway, WfConstants.C_Gateway],
  [WfConstants.NODE_Gateway_GateWay, WfConstants.C_Gateway_GateWay],
  [WfConstants.NODE_Gateway_Decision, WfConstants.C_Gateway_Decision],
  [WfConstants.NODE_Gateway_Join, WfConstants.C_Gateway_Join],
  [WfConstants.NODE_Gateway_Fork, WfConstants.C_Gateway_Fork],
  [WfConstants.NODE_Gateway_ExclusiveFork, WfConstants.C_Gateway_ExclusiveFork],
  [WfConstants.NODE_Gateway_ComplexJoin, WfConstants.C_Gateway_ComplexJoin],
  [WfConstants.NODE_Task, WfConstants.C_Task],
  [WfConstants.NODE_Task_Audit, WfConstants.C_Task_Audit],
  [WfConstants.NODE_Task_Service, WfConstants.C_Task_Service],
  [WfConstants.NODE_Task_Manual, WfConstants.C_Task_Manual],
  [WfConstants.NODE_Task_User, WfConstants.C_Task_User],
  [WfConstants.NODE_Task_DataMap, WfConstants.C_Task_DataMap],
  [WfConstants.NODE_Task_CounterSign, WfConstants.C_Task_CounterSign],
  [WfConstants.NODE_Task_MultiUser, WfConstants.C_Task_MultiUser],
  [WfConstants.NODE_Task_StateAction, WfConstants.C_Task_StateAction],
  [WfConstants.NODE_Task_MultiAudit, WfConstants.C_Task_MultiAudit],
  [WfConstants.NODE_SubProcess, WfConstants.C_SubProcess],
  [WfConstants.NODE_Inline, WfConstants.C_Inline],
  [ActionNames.model_node_remove, WfConstants.C_Remove],
  [GlobalConstants.S_TRUE, "是"],
  [GlobalConstants.S_FALSE, "否"]
]);
let I18N = _I18N;
class AbstractWfElement {
  constructor(xmlNode) {
    this.xmlNode = xmlNode ? xmlNode : new TagNode(this.getType());
    if (!this.getCaption()) {
      this.setCaption(this.getDefaultCaption());
    }
  }
  getID() {
    return this.xmlNode.getAttributeValue(GlobalConstants.S_ID);
  }
  setID(id) {
    this.xmlNode.setAttributeValue(GlobalConstants.S_ID, id);
  }
  getKey() {
    return this.xmlNode.getAttributeValue(GlobalConstants.S_Key);
  }
  setKey(key2) {
    this.xmlNode.setAttributeValue(GlobalConstants.S_Key, key2);
  }
  getCaption() {
    return this.xmlNode.getAttributeValue(GlobalConstants.S_Caption);
  }
  setCaption(caption) {
    this.xmlNode.setAttributeValue(GlobalConstants.S_Caption, caption);
  }
  getGSection() {
    return this.gSection;
  }
  /**
   * 获取节点中的控制节点
   */
  getControlNode() {
    return this.gSection;
  }
  updataView() {
    this.setLocation(this.getX(), this.getY());
    this.updateCaption(this.getCaption());
    this.xmlNode.isSelected() ? this.markSelected() : this.markUnSelected();
  }
  updateCaption(caption) {
    if (this.gCaptionElement) {
      this.gCaptionElement.getHtmlElement().innerHTML = caption;
    }
  }
  initGSection(section) {
    this.gSection = section;
    this.drawGraphic(section);
    this.drawSymbo();
    this.gCaptionElement = this.drawCaption();
    this.update();
    this.dblClickHandler && this.gSection.dblclick(this.dblClickHandler);
  }
  getCaptionArea() {
    var gCaption = this.gCaptionElement;
    return {
      x: this.getX() + (gCaption ? gCaption.getBBox().x : 0),
      y: this.getY() + (gCaption ? gCaption.getBBox().y : 0),
      width: gCaption ? gCaption.getBBox().width : 80,
      height: gCaption ? gCaption.getBBox().height : 30
    };
  }
  getGCaption() {
    return this.gCaptionElement;
  }
  setXmlNode(xmlNode) {
    this.xmlNode = xmlNode;
  }
  initXmlNode(xmlNode) {
    this.xmlNode = xmlNode;
    this.update();
  }
  update() {
    this.gSection.transformTo(this.getX(), this.getY());
    this.updataView();
  }
  getX() {
    return this.ensureGraphicTagNode().getAttributeValueInt(WfConstants.ATTR_X, 0);
  }
  getY() {
    return this.ensureGraphicTagNode().getAttributeValueInt(WfConstants.ATTR_Y, 0);
  }
  setLocation(x, y) {
    this.ensureGraphicTagNode().setAttributeValue(WfConstants.ATTR_X, String(x));
    this.ensureGraphicTagNode().setAttributeValue(WfConstants.ATTR_Y, String(y));
    this.gSection.transformTo(x, y);
  }
  /**
  * 获取选择框绘制范围
  */
  getBounds() {
    return { x: this.getX(), y: this.getY(), width: this.getWidth(), height: this.getHeight() };
  }
  /**
   * 获取中心点位置
   * @returns 
   */
  getCenter() {
    var bounds = this.getBounds();
    var centerX = bounds.x + bounds.width / 2;
    var centerY = bounds.y + bounds.height / 2;
    return { x: centerX, y: centerY };
  }
  getTagNode() {
    return this.xmlNode;
  }
  isSelected() {
    return this.xmlNode.isSelected();
  }
  hitHtmlElement(el) {
    return this.gSection.getHtmlElement().contains(el);
  }
  remove() {
    this.gSection.remove();
  }
  setOptHandler(handler) {
    this.optHandler = handler;
  }
  setOnDblClick(dblclick) {
    this.dblClickHandler = dblclick;
  }
  getDefaultCaption() {
    return I18N.getString(this.getType());
  }
}
let AbstractLink$1 = class AbstractLink2 extends AbstractWfElement {
  constructor() {
    super();
    this.normalStrokeColor = WfDefines.G_COLOR_STROKE_NORMAL;
    this.normalStrokeWidth = WfDefines.G_WIDTH_STROKE_NORMAL;
    this.arrowStyle = {};
  }
  getWidth() {
    return 0;
  }
  getHeight() {
    return 0;
  }
  drawCaption() {
    var center = this.getCenter();
    var bHideCaption = this.isNeedHideCaption();
    var showCaption = !bHideCaption && this.isDefaultCaption() ? this.getCondition() : this.getCaption();
    var text = this.gSection.text(center.x, center.y, showCaption).attr({
      //'fill': '#e1cbff',
      //'stroke': '#9e9e9e',
      "text-anchor": "middle",
      "font-size": 12,
      "font-family": "楷体",
      "font-style": "italic",
      "font-weight": 600
    });
    text.setVisiable(!bHideCaption);
    return text;
  }
  isNeedHideCaption() {
    return this.isDefaultCaption() && this.isDefaultCondition();
  }
  initGSection(section) {
    var _a;
    super.initGSection(section);
    this.dblClickHandler && ((_a = this.getGCaption()) == null ? void 0 : _a.dblclick(this.dblClickHandler));
  }
  updateCaptionLoc() {
    var center = this.getCenter();
    var gCaption = this.getGCaption();
    gCaption == null ? void 0 : gCaption.attr({ x: center.x, y: center.y - 10 });
    var bHideCaption = this.isNeedHideCaption();
    var showCaption = !bHideCaption && this.isDefaultCaption() ? this.getCondition() : this.getCaption();
    !bHideCaption && this.updateCaption(I18N.getString(showCaption));
    gCaption == null ? void 0 : gCaption.setVisiable(!bHideCaption);
    if (this.fromNode && this.toNode) {
      var pos = this.getPos(this.fromNode.getBounds(), this.toNode.getBounds());
      var tan = MathUtil.tan(pos.x1, pos.y1, pos.x2, pos.y2);
      var d = Math.atan(tan) * 180 / Math.PI;
      if (d >= 0 && d <= 45 || d >= 135 && d <= 180) {
        gCaption == null ? void 0 : gCaption.transform(d, center.x + 8, center.y - 8);
      } else {
        gCaption == null ? void 0 : gCaption.transform(d, center.x, center.y);
      }
    }
  }
  getCaptionArea() {
    var center = this.getCenter();
    return {
      x: center.x,
      y: center.y,
      width: 80,
      height: 30
    };
  }
  getCenter() {
    var cx = 0, cy = 0;
    if (this.fromNode && this.toNode) {
      var pos = this.getPos(this.fromNode.getBounds(), this.toNode.getBounds());
      cx = (pos.x1 + pos.x2) / 2;
      cy = (pos.y1 + pos.y2) / 2;
    }
    return { x: cx, y: cy };
  }
  setLocation(x, y) {
  }
  drawSymbo() {
  }
  getFromID() {
    var _a;
    var tagNode = this.getTagNode();
    var tagFrom = (_a = tagNode.getParent()) == null ? void 0 : _a.getParent();
    return tagFrom == null ? void 0 : tagFrom.getAttributeValue(GlobalConstants.S_ID);
  }
  getToKey() {
    return this.getTagNode().getAttributeValue(WfConstants.ATTR_TargetNodeKey);
  }
  setFromNode(fromNode) {
    this.fromNode = fromNode;
    this.drawLink();
  }
  getFromNode() {
    return this.fromNode;
  }
  getToNode() {
    return this.toNode;
  }
  setToNode(toNode) {
    this.toNode = toNode;
    this.drawLink();
  }
  drawGraphic() {
    var child = this.xmlNode.getChild("TransitionGraphic");
    if (child) {
      child.getAttributeValue("StraightLine", "StraightLine");
    }
    var optSection = this.gSection.section();
    optSection.setVisiable(false);
    optSection.circle(0, 0, 12);
    optSection.text(0, 8, "+").attr({ "text-anchor": "middle", fill: "white", "font-weight": "bold", "font-size": 25 });
    this.group = {
      line: this.gSection.path(""),
      hide: this.gSection.path(""),
      triangle: this.gSection.path(""),
      fromHandler: this.gSection.circle(0, 0, 0),
      toHandler: this.gSection.circle(0, 0, 0),
      optSymbo: optSection
    };
    this.selectSymbo = this.gSection.section();
    this.selectSymbo.add(this.group.fromHandler);
    this.selectSymbo.add(this.group.toHandler);
    this.selectSymbo.add(this.group.optSymbo);
    return this.group.line;
  }
  hitHtmlElement(el) {
    var _a;
    return this.group.line.getHtmlElement() == el || this.group.hide.getHtmlElement() == el || this.group.triangle.getHtmlElement() == el || ((_a = this.getGCaption()) == null ? void 0 : _a.getHtmlElement()) == el;
  }
  setVisiable(b) {
    this.group && this.group.line.setVisiable(b);
    this.group && this.group.triangle.setVisiable(b);
    this.group && this.group.fromHandler.setVisiable(b);
    this.group && this.group.toHandler.setVisiable(b);
  }
  getNormalStrokeColor() {
    return this.normalStrokeColor;
  }
  drawLink() {
    if (this.fromNode && this.toNode) {
      var pos = this.getPos(this.fromNode.getBounds(), this.toNode.getBounds());
      this.group.hide.attr({ "path": pos.linestr }).attr(this.arrowStyle).attr({ stroke: this.getNormalStrokeColor() }).attr({ "stroke-width": 6, "stroke-opacity": "0.0" });
      this.group.line.attr({ "path": pos.linestr }).attr(this.arrowStyle).attr({ stroke: this.getNormalStrokeColor() });
      this.group.triangle.attr({ "path": pos.trianglestr }).attr(this.arrowStyle);
      var r = 6;
      var x1 = pos.x1, y1 = pos.y1, x2 = pos.x2, y2 = pos.y2;
      var signX = x2 == x1 ? 1 : (x2 - x1) / Math.abs(x2 - x1);
      var signY = y2 == y1 ? 1 : (y2 - y1) / Math.abs(y2 - y1);
      var tan = MathUtil.tan(x1, y1, x2, y2);
      var selectStrokeColor = WfDefines.G_COLOR_STROKE_SELECT;
      var selectStrokeWidth = WfDefines.G_WIDTH_STROKE_SELECT;
      var attrHandler = {
        r,
        "stroke": selectStrokeColor,
        "stroke-opacity": "0.0",
        "strokeWidth": selectStrokeWidth,
        "fill": "none",
        class: WfDefines.CLASS_HANDLER
      };
      var offsetFrom = MathUtil.offsetByTan(6, tan, signX, signY);
      var posFrom = { cx: x1 + offsetFrom.offsetX, cy: y1 + offsetFrom.offsetY };
      this.group.fromHandler.attr(posFrom).attr(attrHandler);
      var offsetTo = MathUtil.offsetByTan(18, tan, signX, signY);
      var posTo = { cx: x2 - offsetTo.offsetX, cy: y2 - offsetTo.offsetY };
      this.group.toHandler.attr(posTo).attr(attrHandler);
      var cx = (x1 + x2) / 2, cy = (y1 + y2) / 2;
      this.group.optSymbo.transformTo(cx, cy);
      var attrOpt = {
        "stroke": selectStrokeColor,
        "stroke-opacity": "0.0",
        "strokeWidth": selectStrokeWidth,
        "fill": selectStrokeColor,
        class: WfDefines.CLASS_HANDLER
      };
      this.group.optSymbo.attr(attrOpt);
      this.group.optSymbo.setVisiable(true);
      this.isSelected() ? this.markSelected() : this.markUnSelected();
      this.optHandler && this.group.optSymbo.mousedown(this.optHandler);
      this.updateCaptionLoc();
    }
  }
  getControlNode() {
    return this.group.hide;
  }
  //private optSymbo?: IGElement;
  markSelected() {
    this.markUnHovered();
    var selectStrokeColor = WfDefines.G_COLOR_STROKE_SELECT;
    var selectStrokeWidth = WfDefines.G_WIDTH_STROKE_SELECT;
    this.group.line && this.group.line.attr({ "stroke": selectStrokeColor, "strokeWidth": selectStrokeWidth });
    this.group.triangle && this.group.triangle.attr({ "stroke": selectStrokeColor, "strokeWidth": selectStrokeWidth, "fill": selectStrokeColor });
    var selectAttr = { "fill": selectStrokeColor, "stroke-opacity": "0.5" };
    this.group.fromHandler.attr(selectAttr);
    this.group.toHandler.attr(selectAttr);
    var selectAttr2 = { "fill": selectStrokeColor, "stroke-opacity": "0" };
    this.group.optSymbo.attr(selectAttr2);
  }
  getSelectSymbo() {
    return this.selectSymbo;
  }
  getOptSymbo() {
    return this.group.optSymbo;
  }
  markUnSelected() {
    if (!this.group) {
      return;
    }
    this.group.line && this.group.line.attr({ stroke: this.getNormalStrokeColor(), "strokeWidth": this.normalStrokeWidth });
    this.group.triangle && this.group.triangle.attr({ stroke: this.getNormalStrokeColor(), "strokeWidth": this.normalStrokeWidth, "fill": this.getNormalStrokeColor() });
    var unSelectAttr = { "fill": "none", "stroke-opacity": "0.0" };
    this.group.fromHandler.attr(unSelectAttr);
    this.group.toHandler.attr(unSelectAttr);
    this.group.optSymbo.setVisiable(false);
  }
  markHovered() {
    if (this.isSelected())
      return;
    var hoverStrokeColor = WfDefines.G_COLOR_STROKE_HOVER;
    var hoverStrokeWidth = WfDefines.G_WIDTH_STROKE_HOVER;
    this.group.line && this.group.line.attr({ stroke: hoverStrokeColor, "strokeWidth": hoverStrokeWidth });
    this.group.triangle && this.group.triangle.attr({ stroke: hoverStrokeColor, "strokeWidth": hoverStrokeWidth, "fill": hoverStrokeColor });
  }
  markUnHovered() {
    if (this.isSelected())
      return;
    this.group.line && this.group.line.attr({ stroke: this.getNormalStrokeColor(), "strokeWidth": this.normalStrokeWidth });
    this.group.triangle && this.group.triangle.attr({ stroke: this.getNormalStrokeColor(), "strokeWidth": this.normalStrokeWidth, "fill": this.getNormalStrokeColor() });
  }
  getPos(node1, node2) {
    var conn = this.getConnection(node1, node2), fromx = conn.x1, fromy = conn.y1, tox = conn.x2, toy = conn.y2, signX = tox == fromx ? 1 : (tox - fromx) / Math.abs(tox - fromx), signY = toy == fromy ? 1 : (toy - fromy) / Math.abs(toy - fromy), c = tox == fromx ? Math.PI / 2 : Math.abs(Math.atan((toy - fromy) / (tox - fromx))), triangleX1 = (tox - Math.cos(c - Math.PI / 12) * 10 * signX).toFixed(1), triangleY1 = (toy - Math.sin(c - Math.PI / 12) * 10 * signY).toFixed(1), triangleX2 = (tox - Math.cos(c + Math.PI / 12) * 10 * signX).toFixed(1), triangleY2 = (toy - Math.sin(c + Math.PI / 12) * 10 * signY).toFixed(1);
    return {
      x1: fromx,
      y1: fromy,
      x2: tox,
      y2: toy,
      linestr: "M" + fromx + "," + fromy + " L" + tox + "," + toy,
      trianglestr: "M" + tox + "," + toy + " L" + triangleX1 + "," + triangleY1 + " L" + triangleX2 + "," + triangleY2 + " L" + tox + "," + toy
    };
  }
  getConnection(bb1, bb2) {
    var off1 = 0, off2 = 0;
    var p = [
      /* NORTH 1 */
      { x: bb1.x + bb1.width / 2, y: bb1.y - off1 },
      /* SOUTH 1 */
      { x: bb1.x + bb1.width / 2, y: bb1.y + bb1.height + off1 },
      /* WEST */
      { x: bb1.x - off1, y: bb1.y + bb1.height / 2 },
      /* EAST  1 */
      { x: bb1.x + bb1.width + off1, y: bb1.y + bb1.height / 2 },
      /* NORTH 2 */
      { x: bb2.x + bb2.width / 2, y: bb2.y - off2 },
      /* SOUTH 2 */
      { x: bb2.x + bb2.width / 2, y: bb2.y + bb2.height + off2 },
      /* WEST  2 */
      { x: bb2.x - off2, y: bb2.y + bb2.height / 2 },
      /* EAST  2 */
      { x: bb2.x + bb2.width + off2, y: bb2.y + bb2.height / 2 }
    ];
    var d = /* @__PURE__ */ new Map(), dis = [];
    for (var i = 0; i < 4; i++) {
      for (var j = 4; j < 8; j++) {
        var dx = Math.abs(p[i].x - p[j].x);
        var dy = Math.abs(p[i].y - p[j].y);
        if (i == j - 4 || (i != 3 && j != 6 || p[i].x < p[j].x) && (i != 2 && j != 7 || p[i].x > p[j].x) && (i != 0 && j != 5 || p[i].y > p[j].y) && (i != 1 && j != 4 || p[i].y < p[j].y)) {
          dis.push(dx + dy);
          d.set(dis[dis.length - 1].toFixed(3), [i, j]);
        }
      }
    }
    var res = dis.length == 0 ? [0, 4] : d.get(Math.min.apply(Math, dis).toFixed(3));
    return { x1: p[res[0]].x, y1: p[res[0]].y, x2: p[res[1]].x, y2: p[res[1]].y };
  }
  isDefaultCondition() {
    var condition = this.getCondition();
    return "TRUE" == condition.toUpperCase();
  }
  isDefaultCaption() {
    return this.getDefaultCaption() == this.getCaption();
  }
  getCondition() {
    return this.getTagNode().getAttributeValue(GlobalConstants.S_Condition, "True");
  }
  getX() {
    return 0;
  }
  getY() {
    return 0;
  }
  ensureGraphicTagNode() {
    var xmlGraphicNode = this.xmlNode.getChild(WfConstants.NODE_TransitionGraphic);
    if (!xmlGraphicNode) {
      xmlGraphicNode = new TagNode(WfConstants.NODE_TransitionGraphic);
      this.xmlNode.addChild(xmlGraphicNode);
    }
    return xmlGraphicNode;
  }
};
let SequenceFlow$1 = class SequenceFlow2 extends AbstractLink$1 {
  constructor() {
    super();
  }
  getType() {
    return WfConstants.NODE_Flow_Sequence;
  }
  getDefaultCaption() {
    return WfConstants.C_Flow_Sequence;
  }
  newInstance() {
    return new SequenceFlow2();
  }
};
const _Unicode = class _Unicode2 {
  static get(key2) {
    var code = _Unicode2.map.get(key2);
    return code ? code : key2;
  }
};
_Unicode.map = /* @__PURE__ */ new Map([
  [WfConstants.NODE_Task_Audit, WfConstants.U_Task_Audit],
  [WfConstants.NODE_Task_Service, WfConstants.U_Task_Service],
  [WfConstants.NODE_Task_Manual, WfConstants.U_Task_Manual],
  [WfConstants.NODE_Task_User, WfConstants.U_Task_User],
  [WfConstants.NODE_Task_DataMap, WfConstants.U_Task_DataMap],
  [WfConstants.NODE_Task_CounterSign, WfConstants.U_Task_CounterSign],
  [WfConstants.NODE_Task_MultiUser, WfConstants.U_Task_MultiUser],
  [WfConstants.NODE_Task_MultiAudit, WfConstants.U_Task_MultiAudit],
  [WfConstants.NODE_Task_StateAction, WfConstants.U_Task_StateAction],
  [WfConstants.NODE_SubProcess, WfConstants.U_SubProcess],
  [WfConstants.NODE_Inline, WfConstants.U_Inline]
]);
let Unicode = _Unicode;
class AbstractNode extends AbstractWfElement {
  // private gMenu?: GPopMenu;
  markSelected() {
    this.markUnHovered();
    if (this.selectedRect)
      return;
    var bounds = this.getBounds();
    var selectRectX1 = -6, selectRectX2 = bounds.width + 12, selectRectY1 = -6, selectRectY2 = bounds.height + 12;
    this.selectedRect = this.gSection.rect(selectRectX1, selectRectY1, selectRectX2, selectRectY2).attr({
      fill: "none",
      stroke: WfDefines.G_COLOR_STROKE_SELECT,
      "fill-opacity": "0.5",
      "strokeWidth": 1,
      "stroke-dasharray": "3,3"
    });
    selectRectX2 -= 8;
    selectRectY2 -= 8;
    var trianglestr = "M" + selectRectX2 + "," + selectRectY2 + " L" + (selectRectX2 - 12) + "," + selectRectY2 + " L" + selectRectX2 + "," + (selectRectY2 - 12) + " L" + selectRectX2 + "," + selectRectY2;
    this.optSymbo = this.gSection.path(trianglestr).attr({ fill: WfDefines.G_COLOR_STROKE_SELECT, "fill-opacity": "0.5" });
    this.optSymbo.hover((e) => {
      var _a;
      return (_a = this.optSymbo) == null ? void 0 : _a.attr({ "fill-opacity": "1" });
    }, (e) => {
      var _a;
      return (_a = this.optSymbo) == null ? void 0 : _a.attr({ "fill-opacity": "0.5" });
    });
    this.optHandler && this.optSymbo.mousedown(this.optHandler);
  }
  ensureGraphicTagNode() {
    var xmlGraphicNode = this.xmlNode.getChild(WfConstants.NODE_NodeGraphic);
    if (!xmlGraphicNode) {
      xmlGraphicNode = new TagNode(WfConstants.NODE_NodeGraphic);
      this.xmlNode.addChild(xmlGraphicNode);
    }
    return xmlGraphicNode;
  }
  getSelectSymbo() {
    return this.selectedRect;
  }
  markUnSelected() {
    this.markUnHovered();
    if (this.selectedRect) {
      this.selectedRect.remove();
      this.selectedRect = void 0;
    }
    if (this.optSymbo) {
      this.optSymbo.remove();
      this.optSymbo = void 0;
    }
  }
  markHovered() {
    if (this.isSelected())
      return;
    var bounds = this.getBounds();
    this.hoverRect = this.gSection.rect(-6, -6, bounds.width + 12, bounds.height + 12).attr({
      fill: "none",
      stroke: WfDefines.G_COLOR_STROKE_HOVER,
      "fill-opacity": "0.5",
      "strokeWidth": 1,
      "stroke-dasharray": "3,3"
    });
  }
  markUnHovered() {
    if (this.isSelected())
      return;
    if (this.hoverRect) {
      this.hoverRect.remove();
      this.hoverRect = void 0;
    }
  }
}
class BaseRectNode extends AbstractNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  drawGraphic(gSection) {
    var el = gSection.rect(0, 0, this.getWidth(), this.getHeight(), WfDefines.G_RECT_R).attr({
      fill: "#fff",
      stroke: WfDefines.G_COLOR_STROKE_NORMAL,
      "fill-opacity": "0.1",
      "strokeWidth": 1
    });
    return el;
  }
  drawCaption() {
    var bounds = this.getBounds();
    var caption = this.getCaption();
    var text = this.gSection.text(bounds.width / 2, bounds.height / 2 + 5, caption);
    text.attr({ "text-anchor": "middle", "font-size": 12 });
    return text;
  }
  getWidth() {
    return WfDefines.G_RECT_W;
  }
  getHeight() {
    return WfDefines.G_RECT_H;
  }
}
class AbstractTaskNode extends BaseRectNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  drawSymbo() {
    this.gSection.text(0, 20, ``).attr({
      class: "iconfont",
      "font-size": 22
    }).getHtmlElement().innerHTML = Unicode.get(this.getType());
  }
}
class AuditNode extends AbstractTaskNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  getType() {
    return WfConstants.NODE_Task_Audit;
  }
  newInstance(xmlNode) {
    return new AuditNode(xmlNode);
  }
}
class BaseCircleNode extends AbstractNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  drawCaption() {
    var bounds = this.getBounds();
    var caption = this.getCaption();
    var text = this.gSection.text(bounds.width / 2, bounds.height + 18, caption).attr({ "text-anchor": "middle", "font-size": 12 });
    return text;
  }
  getWidth() {
    return WfDefines.G_CIRCLE_R * 2;
  }
  getHeight() {
    return WfDefines.G_CIRCLE_R * 2;
  }
  drawSymbo() {
  }
}
class BeginNode extends BaseCircleNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  drawGraphic(gSection) {
    var r = this.getWidth() / 2;
    var el = gSection.circle(r, r, r).attr({
      fill: "#fff",
      stroke: WfDefines.G_COLOR_STROKE_NORMAL,
      "fill-opacity": "0.1",
      "strokeWidth": 1
    });
    return el;
  }
  getType() {
    return WfConstants.NODE_Event_Begin;
  }
  newInstance(xmlNode) {
    return new BeginNode(xmlNode);
  }
}
class EndNode extends BaseCircleNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  getType() {
    return WfConstants.NODE_Event_End;
  }
  drawGraphic(gSection) {
    var r = this.getWidth() / 2;
    var group = gSection.section();
    var el1 = gSection.circle(r, r, r).attr({
      fill: "#fff",
      stroke: WfDefines.G_COLOR_STROKE_NORMAL,
      "fill-opacity": "0.1",
      "strokeWidth": 2
    });
    var el2 = gSection.circle(r, r, r / 2).attr({
      fill: WfDefines.G_COLOR_STROKE_NORMAL
    });
    group.add(el1);
    group.add(el2);
    return group;
  }
  newInstance(xmlNode) {
    return new EndNode(xmlNode);
  }
}
class StateNode extends BaseCircleNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  getType() {
    return WfConstants.NODE_Event_State;
  }
  drawGraphic(gSection) {
    var r = this.getWidth() / 2;
    var group = gSection.section();
    var el1 = gSection.circle(r, r, r).attr({
      fill: "#fff",
      stroke: WfDefines.G_COLOR_STROKE_NORMAL,
      "fill-opacity": "0.1",
      "strokeWidth": 1
    });
    var el2 = gSection.circle(r, r, r / 2).attr({
      fill: "#fff",
      stroke: WfDefines.G_COLOR_STROKE_NORMAL,
      "fill-opacity": "0.1",
      "strokeWidth": 2
    });
    group.add(el1);
    group.add(el2);
    return group;
  }
  newInstance(xmlNode) {
    return new StateNode(xmlNode);
  }
}
class BaseDiamondNode extends AbstractNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  drawGraphic(gSection) {
    var rw = 25, rh = 25;
    var polygon = gSection.polygon([0, rh, rw, 0, 2 * rw, rh, rw, 2 * rh, 0, rh]).attr({
      fill: "#fff",
      stroke: "#000",
      "fill-opacity": "0.1",
      "strokeWidth": 1
    });
    return polygon;
  }
  drawCaption() {
    var bounds = this.getBounds();
    var caption = this.getCaption();
    var text = this.gSection.text(bounds.width / 2, bounds.height + 18, caption);
    text.attr({ "text-anchor": "middle", "font-size": 12 });
    return text;
  }
  getWidth() {
    return WfDefines.G_RECT_H;
  }
  getHeight() {
    return WfDefines.G_RECT_H;
  }
}
class JoinNode extends BaseDiamondNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  drawSymbo() {
    var pathAttr = { stroke: "#000", strokeWidth: 1 };
    var w = this.getBounds().width, h2 = this.getBounds().height;
    this.gSection.path("M" + (w / 2 - 15) + " " + h2 / 2 + "L" + (w / 2 + 15) + " " + h2 / 2).attr(pathAttr);
    this.gSection.path("M" + (w / 2 - 5) + " " + (h2 / 2 + 10) + "L" + (w / 2 + 6) + " " + h2 / 2).attr(pathAttr);
    this.gSection.path("M" + (w / 2 - 5) + " " + (h2 / 2 - 10) + "L" + (w / 2 + 6) + " " + h2 / 2).attr(pathAttr);
  }
  getType() {
    return WfConstants.NODE_Gateway_Join;
  }
  newInstance(xmlNode) {
    return new JoinNode(xmlNode);
  }
}
class ForkNode extends BaseDiamondNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  drawSymbo() {
    var pathAttr = { stroke: "#000", strokeWidth: 1 };
    var w = this.getBounds().width, h2 = this.getBounds().height;
    this.gSection.path("M" + (w / 2 - 15) + " " + h2 / 2 + "L" + (w / 2 + 15) + " " + h2 / 2).attr(pathAttr);
    this.gSection.path("M" + (w / 2 + 5) + " " + (h2 / 2 + 10) + "L" + (w / 2 - 6) + " " + h2 / 2).attr(pathAttr);
    this.gSection.path("M" + (w / 2 + 5) + " " + (h2 / 2 - 10) + "L" + (w / 2 - 6) + " " + h2 / 2).attr(pathAttr);
  }
  getType() {
    return WfConstants.NODE_Gateway_Fork;
  }
  newInstance(xmlNode) {
    return new ForkNode(xmlNode);
  }
}
class ExclusiveForkNode extends BaseDiamondNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  drawSymbo() {
    var pathAttr = { stroke: "#000", strokeWidth: 1 };
    var w = this.getBounds().width, h2 = this.getBounds().height;
    this.gSection.path("M" + (w / 2 - 5) + " " + (h2 / 2 - 5) + "L" + (w / 2 + 5) + " " + (h2 / 2 + 5)).attr(pathAttr);
    this.gSection.path("M" + (w / 2 - 5) + " " + (h2 / 2 + 5) + "L" + (w / 2 + 5) + " " + (h2 / 2 - 5)).attr(pathAttr);
  }
  getType() {
    return WfConstants.NODE_Gateway_ExclusiveFork;
  }
  newInstance(xmlNode) {
    return new ExclusiveForkNode(xmlNode);
  }
}
class ComplexJoinNode extends BaseDiamondNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  drawSymbo() {
    var pathAttr = { stroke: "#000", strokeWidth: 1 };
    var w = this.getBounds().width, h2 = this.getBounds().height;
    this.gSection.path("M" + (w / 2 - 5) + " " + (h2 / 2 - 5) + "L" + (w / 2 + 5) + " " + (h2 / 2 + 5)).attr(pathAttr);
    this.gSection.path("M" + (w / 2 - 5) + " " + (h2 / 2 + 5) + "L" + (w / 2 + 5) + " " + (h2 / 2 - 5)).attr(pathAttr);
    this.gSection.path("M" + (w / 2 - 7) + " " + h2 / 2 + "L" + (w / 2 + 7) + " " + h2 / 2).attr(pathAttr);
    this.gSection.path("M" + w / 2 + " " + (h2 / 2 - 7) + "L" + w / 2 + " " + (h2 / 2 + 7)).attr(pathAttr);
  }
  getType() {
    return WfConstants.NODE_Gateway_ComplexJoin;
  }
  newInstance(xmlNode) {
    return new ComplexJoinNode(xmlNode);
  }
}
class DecisionNode extends BaseDiamondNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  drawSymbo() {
    var w = this.getBounds().width, h2 = this.getBounds().height;
    this.gSection.text(w / 2, h2 / 2 + 5, "?").attr({ "text-anchor": "middle", "font-weight": "bold", "font-size": 20 });
  }
  getType() {
    return WfConstants.NODE_Gateway_Decision;
  }
  newInstance(xmlNode) {
    return new DecisionNode(xmlNode);
  }
}
class GatewayNode extends BaseDiamondNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  drawSymbo() {
    var pathAttr = { stroke: "#000", fill: "none", strokeWidth: 1 };
    var w = this.getBounds().width;
    this.gSection.circle(w / 2, w / 2, w / 4).attr(pathAttr);
  }
  getType() {
    return WfConstants.NODE_Gateway;
  }
  newInstance(xmlNode) {
    return new GatewayNode(xmlNode);
  }
}
class ServiceNode extends AbstractTaskNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  getType() {
    return WfConstants.NODE_Task_Service;
  }
  newInstance(xmlNode) {
    return new ServiceNode(xmlNode);
  }
}
class ManualNode extends AbstractTaskNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  getType() {
    return WfConstants.NODE_Task_Manual;
  }
  newInstance(xmlNode) {
    return new ManualNode(xmlNode);
  }
}
class UserNode extends AbstractTaskNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  getType() {
    return WfConstants.NODE_Task_User;
  }
  newInstance(xmlNode) {
    return new UserNode(xmlNode);
  }
}
class DataMapNode extends AbstractTaskNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  getType() {
    return WfConstants.NODE_Task_DataMap;
  }
  newInstance(xmlNode) {
    return new DataMapNode(xmlNode);
  }
}
class CounterSignNode extends AbstractTaskNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  getType() {
    return WfConstants.NODE_Task_CounterSign;
  }
  newInstance(xmlNode) {
    return new CounterSignNode(xmlNode);
  }
}
class MultiUserNode extends AbstractTaskNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  getType() {
    return WfConstants.NODE_Task_MultiUser;
  }
  newInstance(xmlNode) {
    return new MultiUserNode(xmlNode);
  }
}
class MultiAuditNode extends AbstractTaskNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  getType() {
    return WfConstants.NODE_Task_MultiAudit;
  }
  newInstance(xmlNode) {
    return new MultiAuditNode(xmlNode);
  }
}
class StateActionNode extends AbstractTaskNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  getType() {
    return WfConstants.NODE_Task_StateAction;
  }
  newInstance(xmlNode) {
    return new StateActionNode(xmlNode);
  }
}
class AbstractProcess extends BaseRectNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  drawSymbo() {
    var x = this.getWidth() / 2;
    var y = this.getHeight() + 2;
    this.gSection.text(x, y, ``).attr({
      "text-anchor": "middle",
      class: "iconfont",
      "font-size": 22
    }).getHtmlElement().innerHTML = Unicode.get(this.getType());
  }
}
class InlineProcessNode extends AbstractProcess {
  constructor(xmlNode) {
    super(xmlNode);
  }
  getType() {
    return WfConstants.NODE_Inline;
  }
  newInstance(xmlNode) {
    return new InlineProcessNode(xmlNode);
  }
}
class SubProcessNode extends AbstractProcess {
  constructor(xmlNode) {
    super(xmlNode);
  }
  getType() {
    return WfConstants.NODE_SubProcess;
  }
  newInstance(xmlNode) {
    return new SubProcessNode(xmlNode);
  }
}
class BranchEndNode extends BaseCircleNode {
  constructor(xmlNode) {
    super(xmlNode);
  }
  drawGraphic(gSection) {
    var r = this.getWidth() / 2;
    var el = gSection.circle(r, r, r).attr({
      fill: "#fff",
      stroke: WfDefines.G_COLOR_STROKE_NORMAL,
      "fill-opacity": "0.1",
      "strokeWidth": 4
    });
    return el;
  }
  getType() {
    return WfConstants.NODE_Event_BranchEnd;
  }
  newInstance(xmlNode) {
    return new BranchEndNode(xmlNode);
  }
}
const _ViewElementFactory = class _ViewElementFactory2 {
  constructor() {
    this.mapElements = /* @__PURE__ */ new Map();
    this.mapElements.set(WfConstants.NODE_Flow_Sequence, new SequenceFlow$1());
    this.mapElements.set(WfConstants.NODE_Event_Begin, new BeginNode());
    this.mapElements.set(WfConstants.NODE_Event_BranchEnd, new BranchEndNode());
    this.mapElements.set(WfConstants.NODE_Event_End, new EndNode());
    this.mapElements.set(WfConstants.NODE_Event_State, new StateNode());
    this.mapElements.set(WfConstants.NODE_Gateway_GateWay, new GatewayNode());
    this.mapElements.set(WfConstants.NODE_Gateway_Join, new JoinNode());
    this.mapElements.set(WfConstants.NODE_Gateway_Fork, new ForkNode());
    this.mapElements.set(WfConstants.NODE_Gateway_ExclusiveFork, new ExclusiveForkNode());
    this.mapElements.set(WfConstants.NODE_Gateway_ComplexJoin, new ComplexJoinNode());
    this.mapElements.set(WfConstants.NODE_Gateway_Decision, new DecisionNode());
    this.mapElements.set(WfConstants.NODE_Task_Audit, new AuditNode());
    this.mapElements.set(WfConstants.NODE_Task_Service, new ServiceNode());
    this.mapElements.set(WfConstants.NODE_Task_Manual, new ManualNode());
    this.mapElements.set(WfConstants.NODE_Task_User, new UserNode());
    this.mapElements.set(WfConstants.NODE_Task_DataMap, new DataMapNode());
    this.mapElements.set(WfConstants.NODE_Task_CounterSign, new CounterSignNode());
    this.mapElements.set(WfConstants.NODE_Task_MultiUser, new MultiUserNode());
    this.mapElements.set(WfConstants.NODE_Task_MultiAudit, new MultiAuditNode());
    this.mapElements.set(WfConstants.NODE_Task_StateAction, new StateActionNode());
    this.mapElements.set(WfConstants.NODE_Inline, new InlineProcessNode());
    this.mapElements.set(WfConstants.NODE_SubProcess, new SubProcessNode());
  }
  get(tag) {
    return this.mapElements.get(tag);
  }
  static create(xmlNode) {
    var _a;
    return (_a = _ViewElementFactory2.instance.get(xmlNode.getTagName())) == null ? void 0 : _a.newInstance(xmlNode);
  }
  static createShadowGraphic(tag, gSection) {
    var _a;
    var xmlNode = new TagNode(tag);
    return (_a = _ViewElementFactory2.instance.get(tag)) == null ? void 0 : _a.newInstance(xmlNode).drawGraphic(gSection);
  }
};
_ViewElementFactory.instance = new _ViewElementFactory();
let ViewElementFactory = _ViewElementFactory;
const _ShadowLink$1 = class _ShadowLink2 extends AbstractLink$1 {
  constructor() {
    super();
  }
  drawGraphic() {
    this.shadowLine = this.gSection.path("");
    return this.shadowLine;
  }
  drawShadowToLink(toRect) {
    if (this.fromNode) {
      var pos = this.getPos(this.fromNode.getBounds(), toRect);
      this.shadowLine && this.shadowLine.attr({ "path": pos.linestr }).attr(_ShadowLink2.style);
    }
  }
  drawShadowFromLink(fromRect) {
    if (this.toNode) {
      var pos = this.getPos(fromRect, this.toNode.getBounds());
      this.shadowLine && this.shadowLine.attr({ "path": pos.linestr }).attr(_ShadowLink2.style);
    }
  }
  getType() {
    return WfConstants.NODE_Flow_Sequence;
  }
  getDefaultCaption() {
    return "";
  }
  newInstance() {
    return new _ShadowLink2();
  }
};
_ShadowLink$1.style = { stroke: WfDefines.G_COLOR_STROKE_NORMAL, "fill-opacity": "0.5", "strokeWidth": 1, "stroke-dasharray": "5,3" };
let ShadowLink$1 = _ShadowLink$1;
class AbstractWfOptState extends AbstractOptState {
  constructor(view, delegate) {
    super(delegate);
    this.type = "";
    this.view = view;
  }
  getViewEl() {
    return this.view.getEl();
  }
  getView() {
    return this.view;
  }
  setType(type) {
    this.type = type;
  }
  getType() {
    return this.type;
  }
  reset() {
    var _a;
    (_a = this.shadowLink) == null ? void 0 : _a.remove();
    this.shadowLink = void 0;
    this.getDelegate().reset();
  }
  ensureShadowLink() {
    if (this.shadowLink)
      return this.shadowLink;
    this.shadowLink = new ShadowLink$1();
    this.shadowLink.initGSection(this.view.getPaper().section());
    return this.shadowLink;
  }
}
class ChangeLineFormNodeState extends AbstractWfOptState {
  constructor(view, delegate) {
    super(view, delegate);
  }
  setLink(link) {
    this.link = link;
    this.ensureShadowLink().setToNode(link.getToNode());
  }
  dragstart(x, y, event) {
  }
  dragmove(dx, dy, x, y, e) {
    this.ensureShadowLink().drawShadowFromLink({ x: e.offsetX, y: e.offsetY, width: 4, height: 4 });
  }
  dragend(event) {
    var _a, _b;
    var node = this.view.hitNode(event.offsetX, event.offsetY);
    if (this.link && node && node != ((_a = this.link) == null ? void 0 : _a.getFromNode())) {
      var orgFromTag = (_b = this.link.getFromNode()) == null ? void 0 : _b.getTagNode();
      var fromTag = node.getTagNode();
      orgFromTag && this.view.doChangeLineFromNodeCmd(fromTag, orgFromTag, this.link.getTagNode());
    }
    this.reset();
  }
  mousedown(e) {
  }
  mousemove(e) {
  }
  mouseup(e) {
  }
  reset() {
    super.reset();
    this.link = void 0;
  }
}
class ChangeLineToNodeState extends AbstractWfOptState {
  constructor(view, delegate) {
    super(view, delegate);
  }
  setLink(link) {
    this.link = link;
    this.ensureShadowLink().setFromNode(link.getFromNode());
  }
  dragstart(x, y, event) {
  }
  dragmove(dx, dy, x, y, e) {
    this.ensureShadowLink().drawShadowToLink({ x: e.offsetX, y: e.offsetY, width: 4, height: 4 });
  }
  dragend(event) {
    var _a;
    var node = this.view.hitNode(event.offsetX, event.offsetY);
    if (this.link && node && node != ((_a = this.link) == null ? void 0 : _a.getToNode())) {
      this.view.doChangeLineToNodeCmd(this.link.getTagNode(), node.getKey());
    }
    this.reset();
  }
  mousedown(e) {
  }
  mousemove(e) {
  }
  mouseup(e) {
  }
  reset() {
    super.reset();
    this.link = void 0;
  }
}
class NewLinkAndNodeState extends AbstractWfOptState {
  constructor(view, delegate) {
    super(view, delegate);
    this.linkType = "";
    this.nodeType = "";
    this.shadowX = 0;
    this.shadowY = 0;
  }
  dragstart(x, y, event) {
  }
  dragmove(dx, dy, x, y, event) {
  }
  dragend(event) {
  }
  mousedown(e) {
    if (this.shadow) {
      this.shadow.getBBox().width / 2;
      this.shadow.getBBox().height / 2;
      this.shadow.remove();
      this.shadow = void 0;
    }
    this.view.doNewNodeCmd(this.nodeType, this.shadowX, this.shadowY);
    var node = this.view.hitNode(this.shadowX, this.shadowY);
    this.view.doNewLinkCmd(this.linkType, this.fromTag, node == null ? void 0 : node.getKey());
    this.getDelegate().reset();
    this.shadowX = 0;
    this.shadowY = 0;
  }
  setToNodeType(nodeType) {
    this.nodeType = nodeType;
    this.setType(nodeType);
  }
  setLinkType(linkType) {
    this.linkType = linkType;
  }
  setFromNode(fromNode) {
    this.fromTag = fromNode.getTagNode();
    this.ensureShadowLink().setFromNode(fromNode);
  }
  mousemove(e) {
    this.shadow = this.ensureShadow();
    if (this.shadow) {
      var dx = this.shadow.getBBox().width / 2;
      var dy = this.shadow.getBBox().height / 2;
      this.shadowX = e.offsetX - dx;
      this.shadowY = e.offsetY - dy;
      this.shadow.attr({ transform: "T" + [this.shadowX, this.shadowY] });
    }
    if (this.fromTag) {
      this.ensureShadowLink().drawShadowToLink({ x: e.offsetX, y: e.offsetY, width: 4, height: 4 });
    }
  }
  mouseup(e) {
  }
  ensureShadow() {
    if (this.shadow)
      return this.shadow;
    this.shadow = ViewElementFactory.createShadowGraphic(this.nodeType, this.view.getPaper());
    return this.shadow;
  }
}
let NewLinkState$1 = class NewLinkState2 extends AbstractWfOptState {
  constructor(view, delegate) {
    super(view, delegate);
  }
  dragstart(x, y, event) {
  }
  dragmove(dx, dy, x, y, event) {
  }
  dragend(event) {
  }
  mousedown(e) {
    var node = this.view.hitNode(e.offsetX, e.offsetY);
    this.view.getSelectionModel().select(node == null ? void 0 : node.getTagNode());
    if (!this.fromTag && node instanceof AbstractNode) {
      this.setFromNode(node);
      return;
    }
    var toTag;
    if (!this.toNodeKey && node instanceof AbstractNode) {
      toTag = node.getTagNode();
      this.toNodeKey = node.getKey();
    }
    if (this.fromTag && this.toNodeKey && this.fromTag != toTag) {
      this.view.doNewLinkCmd(this.getType(), this.fromTag, this.toNodeKey);
      this.reset();
    }
    if (e.button == 2) {
      this.reset();
    }
  }
  setFromNode(fromNode) {
    this.fromTag = fromNode.getTagNode();
    this.ensureShadowLink().setFromNode(fromNode);
  }
  mousemove(e) {
    if (this.fromTag) {
      this.ensureShadowLink().drawShadowToLink({ x: e.offsetX, y: e.offsetY, width: 4, height: 4 });
    }
  }
  mouseup(e) {
  }
  reset() {
    super.reset();
    this.fromTag = void 0;
    this.toNodeKey = void 0;
  }
};
class NewNodeState extends AbstractWfOptState {
  constructor(view, delegate) {
    super(view, delegate);
    this.shadowX = 0;
    this.shadowY = 0;
  }
  dragstart(x, y, event) {
    this.shadow = this.ensureShadow();
  }
  dragmove(dx, dy, x, y, event) {
    this.shadow = this.ensureShadow();
    this.shadow && this.shadow.attr({ transform: "T" + [x, y] });
  }
  dragend(event) {
    this.shadow && this.shadow.remove();
    this.getDelegate().reset();
  }
  mousedown(e) {
  }
  mousemove(e) {
    this.shadow = this.ensureShadow();
    if (this.shadow) {
      var dx = this.shadow.getBBox().width / 2;
      var dy = this.shadow.getBBox().height / 2;
      this.shadowX = e.offsetX - dx;
      this.shadowY = e.offsetY - dy;
      this.shadow.attr({ transform: "T" + [this.shadowX, this.shadowY] });
    }
  }
  mouseup(e) {
    if (this.shadow) {
      this.shadow.getBBox().width / 2;
      this.shadow.getBBox().height / 2;
      this.shadow.remove();
      this.shadow = void 0;
    }
    this.view.doNewNodeCmd(this.getType(), this.shadowX, this.shadowY);
    this.getDelegate().reset();
    this.shadowX = 0;
    this.shadowY = 0;
  }
  ensureShadow() {
    if (this.shadow)
      return this.shadow;
    this.shadow = ViewElementFactory.createShadowGraphic(this.getType(), this.view.getPaper());
    return this.shadow;
  }
}
let NormalState$4 = class NormalState3 extends AbstractWfOptState {
  constructor(view, delegate) {
    super(view, delegate);
    this.offsetX = 0;
    this.offsetY = 0;
    this.dragVirtuals = new ArrayList();
  }
  dragstart(x, y, event) {
    this.offsetX = 0;
    this.offsetY = 0;
    var selectItems = this.view.getSelectionModel().getSelectionItems();
    for (let item of selectItems) {
      var node = this.view.findElement(item.getTagNode());
      if (node instanceof AbstractWfElement) {
        var wfNode = node;
        var bound = wfNode.getBounds();
        var rect = this.view.getPaper().rect(bound.x, bound.y, bound.width, bound.height, WfDefines.G_RECT_R);
        rect.attr({
          fill: "none",
          stroke: "#0095ff",
          "fill-opacity": "0.1",
          "strokeWidth": 1
        });
        this.dragVirtuals.add(rect);
      }
    }
  }
  dragmove(dx, dy, x, y, event) {
    if (Math.abs(dx) < 1 || Math.abs(dy) < 1) {
      return;
    }
    this.offsetX = dx;
    this.offsetY = dy;
    this.view.drawDragVirtual(this.dragVirtuals.getList(), dx, dy);
  }
  dragend(event) {
    if (Math.abs(this.offsetX) < 1 && Math.abs(this.offsetY) < 1)
      return;
    this.view.doMoveNodeCmd(this.offsetX, this.offsetY);
    this.reset();
  }
  mousedown(e) {
    var el = e.target;
    var node = this.view.hitHtmlElement(el);
    this.view.unSelectAllDenyFlows();
    this.view.getSelectionModel().select(node == null ? void 0 : node.getTagNode());
  }
  mousemove(e) {
  }
  mouseup(e) {
    this.reset();
  }
  reset() {
    for (let elem of this.dragVirtuals.getList()) {
      elem.remove();
    }
    this.dragVirtuals.clearAll();
  }
};
class OptOnLineState extends AbstractWfOptState {
  constructor(view, delegate) {
    super(view, delegate);
  }
  setLink(link) {
    this.link = link;
  }
  dragstart(x, y, event) {
  }
  dragmove(dx, dy, x, y, event) {
  }
  dragend(event) {
  }
  mousedown(e) {
    this.target = e.target;
  }
  mousemove(e) {
  }
  mouseup(e) {
    if (this.link && e.target && e.target == this.target)
      ;
    this.reset();
  }
}
class UnableOptState extends AbstractWfOptState {
  constructor(view, delegate) {
    super(view, delegate);
  }
  dragstart(x, y, event) {
  }
  dragmove(dx, dy, x, y, event) {
  }
  dragend(event) {
  }
  mousedown(e) {
    var el = e.target;
    var node = this.view.hitHtmlElement(el);
    this.view.unSelectAllDenyFlows();
    this.view.getSelectionModel().select(node == null ? void 0 : node.getTagNode());
  }
  mousemove(e) {
  }
  mouseup(e) {
  }
}
class OptStateDelegate extends AbstractOptStateDelegate {
  constructor(view) {
    super(view);
    this.normalState = new NormalState$4(view, this);
    this.setInitState(this.normalState);
    this.newNodeState = new NewNodeState(view, this);
    this.newLinkState = new NewLinkState$1(view, this);
    this.newLinkAndNodeState = new NewLinkAndNodeState(view, this);
    this.changeLineFromNodeState = new ChangeLineFormNodeState(view, this);
    this.changeLineToNodeState = new ChangeLineToNodeState(view, this);
    this.optOnLineState = new OptOnLineState(view, this);
    this.unableState = new UnableOptState(view, this);
  }
  setNewNodeState(type) {
    this.newNodeState.setType(type);
    this.setCurrentState(this.newNodeState);
  }
  setNewLinkAndNodeState(fromNode, toNodeType, linkType) {
    this.newLinkAndNodeState.setToNodeType(toNodeType);
    this.newLinkAndNodeState.setLinkType(linkType);
    this.newLinkAndNodeState.setFromNode(fromNode);
    this.setCurrentState(this.newLinkAndNodeState);
  }
  setNewLinkState(type) {
    this.newLinkState.setType(type);
    this.setCurrentState(this.newLinkState);
    return this.newLinkState;
  }
  setChangeLineFromNodeState(link) {
    this.changeLineFromNodeState.setLink(link);
    this.setCurrentState(this.changeLineFromNodeState);
  }
  setChangeLineToNodeState(link) {
    this.changeLineToNodeState.setLink(link);
    this.setCurrentState(this.changeLineToNodeState);
  }
  setOptOnLineState(link) {
    this.optOnLineState.setLink(link);
    this.setCurrentState(this.optOnLineState);
  }
  setUnableState() {
    this.setCurrentState(this.unableState);
  }
}
class MoveNodeCmd {
  constructor(view, offsetX, offsetY) {
    this.offsetX = 0;
    this.offsetY = 0;
    this.oldX = -1;
    this.oldY = -1;
    this.view = view;
    this.nodes = view.getSelectionModel().doCacheTagNodes4Node();
    this.offsetX = offsetX;
    this.offsetY = offsetY;
  }
  do() {
    var xmlEntity = this.view.getXmlEntity();
    if (!xmlEntity)
      return false;
    for (let node of this.nodes) {
      if (node.getTagName() == WfConstants.NODE_Flow_Sequence) {
        continue;
      }
      var nodeGraphic = xmlEntity.ensureNode(WfConstants.NODE_NodeGraphic, node);
      this.oldX = nodeGraphic.getAttributeValueInt(WfConstants.ATTR_X, 0);
      this.oldY = nodeGraphic.getAttributeValueInt(WfConstants.ATTR_Y, 0);
      var x = this.oldX + this.offsetX;
      var y = this.oldY + this.offsetY;
      if (x < 10)
        x = 10;
      if (y < 10)
        y = 10;
      if (x > WfDefines.PAPER_W - 10)
        x = WfDefines.PAPER_W - 10;
      if (y > WfDefines.PAPER_H - 10)
        y = WfDefines.PAPER_H - 10;
      nodeGraphic.setAttributeValue(WfConstants.ATTR_X, String(x));
      nodeGraphic.setAttributeValue(WfConstants.ATTR_Y, String(y));
      xmlEntity.update(node, false);
    }
    return true;
  }
  undo() {
    var xmlEntity = this.view.getXmlEntity();
    if (!xmlEntity)
      return;
    for (let node of this.nodes) {
      if (node.getTagName() == WfConstants.NODE_Flow_Sequence) {
        continue;
      }
      var nodeGraphic = xmlEntity.ensureNode(WfConstants.NODE_NodeGraphic, node);
      this.oldX > -1 && nodeGraphic.setAttributeValue(WfConstants.ATTR_X, String(this.oldX));
      this.oldY > -1 && nodeGraphic.setAttributeValue(WfConstants.ATTR_Y, String(this.oldY));
      xmlEntity.update(node, false);
    }
  }
}
class WfNodeUtil {
  /**
   * 判断节点是否可以删除，开始和结束节点必须保留各一个
   * @param xmlEntity 
   * @param tagNode 
   * @returns 
   */
  static canRemove(xmlEntity, tagNode) {
    var tagName = tagNode.getTagName();
    if (tagName == WfConstants.NODE_Event_Begin || tagName == WfConstants.NODE_Event_End) {
      var beginCount = 0, endCount = 0;
      var children = xmlEntity.getTagRoot().getChildren();
      for (let child of children) {
        var node = child;
        if (node.getTagName() == WfConstants.NODE_Event_Begin)
          beginCount++;
        if (node.getTagName() == WfConstants.NODE_Event_End)
          endCount++;
      }
      if (tagName == WfConstants.NODE_Event_Begin)
        return beginCount > 1;
      if (tagName == WfConstants.NODE_Event_End)
        return endCount > 1;
    }
    return true;
  }
  static createNode(xmlEntity, id, type, x, y) {
    var tagNode = xmlEntity.getNodeFactory().createTagNode(type);
    tagNode.setAttributeValue(GlobalConstants.S_ID, id);
    tagNode.setAttributeValue(GlobalConstants.S_Key, type + GlobalConstants.SP_KEY + String(id));
    tagNode.setAttributeValue(GlobalConstants.S_Caption, I18N.getString(type));
    var xmlGraphicNode = xmlEntity.ensureNode(WfConstants.NODE_NodeGraphic, tagNode);
    xmlGraphicNode.setAttributeValue(WfConstants.ATTR_X, String(x));
    xmlGraphicNode.setAttributeValue(WfConstants.ATTR_Y, String(y));
    return tagNode;
  }
  static ensurePermNode(xmlEntity, curNode) {
    var tagNode = curNode instanceof TagNode ? curNode : xmlEntity.getTagRoot();
    var isRoot = tagNode == xmlEntity.getTagRoot();
    var permNode;
    if (isRoot) {
      var permCollection = tagNode.ensureChild(WfConstants.NODE_PermCollection);
      permNode = permCollection.ensureChild(WfConstants.NODE_Perm);
    } else {
      permNode = tagNode.ensureChild(WfConstants.NODE_Perm);
    }
    return permNode;
  }
  static ensureDMTableNode(xmlEntity) {
    var tagNode = xmlEntity.getTagRoot();
    return tagNode.ensureChild(WfConstants.NODE_DMTable);
  }
  /**
   * 根据新增节点类型计算出新增节点最左端x坐标及最上端y坐标
   * @param type 节点类型
   * @param x 节点中心x坐标
   * @param y 节点中心y坐标
   * @returns 
   */
  static cacleNodeLoc(type, x, y) {
    if (type == WfConstants.NODE_Event_State) {
      x = x - WfDefines.G_CIRCLE_R;
      y = y - WfDefines.G_CIRCLE_R;
    }
    if (type == WfConstants.NODE_Task_Audit || type == WfConstants.NODE_Task_CounterSign || type == WfConstants.NODE_Task_DataMap || type == WfConstants.NODE_Task_Manual || type == WfConstants.NODE_Task_MultiAudit || type == WfConstants.NODE_Task_MultiUser || type == WfConstants.NODE_Task_Service || type == WfConstants.NODE_Task_StateAction || type == WfConstants.NODE_Task_User) {
      x = x - WfDefines.G_RECT_W / 2;
      y = y - WfDefines.G_RECT_H / 2;
    }
    if (type == WfConstants.NODE_Gateway_ComplexJoin || type == WfConstants.NODE_Gateway_Decision || type == WfConstants.NODE_Gateway_ExclusiveFork || type == WfConstants.NODE_Gateway_Fork || type == WfConstants.NODE_Gateway || type == WfConstants.NODE_Gateway_Join) {
      x = x - WfDefines.G_RECT_H / 2;
      y = y - WfDefines.G_RECT_H / 2;
    }
    return { leftx: x, topy: y };
  }
}
class NewNodeCmd {
  constructor(xmlEntity, id, type, x, y) {
    this.x = 0;
    this.y = 0;
    this.xmlEntity = xmlEntity;
    this.id = String(id);
    this.type = type;
    this.x = Math.ceil(x);
    this.y = Math.ceil(y);
  }
  do() {
    this.tagNode = WfNodeUtil.createNode(this.xmlEntity, this.id, this.type, this.x, this.y);
    this.xmlEntity.addNode(this.tagNode);
    this.xmlEntity.getTagRoot().resetLineIndex(new Var(0));
    return true;
  }
  undo() {
    this.tagNode && this.xmlEntity.removeNode(this.tagNode);
  }
}
let NewLinkCmd$1 = class NewLinkCmd2 {
  constructor(xmlEntity, id, type, fromTag, toNodeKey) {
    this.xmlEntity = xmlEntity;
    this.id = String(id);
    this.type = type;
    this.fromTag = fromTag;
    this.toNodeKey = toNodeKey;
  }
  do() {
    if (this.toNodeKey == this.fromTag.getAttributeValue("Key")) {
      return false;
    }
    this.tagLink = this.xmlEntity.getNodeFactory().createTagNode(this.type);
    this.tagLink.setAttributeValue(GlobalConstants.S_ID, this.id);
    this.tagLink.setAttributeValue(GlobalConstants.S_Key, this.type + GlobalConstants.SP_KEY + this.id);
    this.tagLink.setAttributeValue(GlobalConstants.S_Caption, I18N.getString(this.type));
    this.tagLink.setAttributeValue(WfConstants.ATTR_TargetNodeKey, this.toNodeKey);
    var tagCollection = this.xmlEntity.ensureNode(WfConstants.NODE_TransitionCollection, this.fromTag);
    this.xmlEntity.addNode(this.tagLink, tagCollection);
    this.xmlEntity.getTagRoot().resetLineIndex(new Var(0));
    return true;
  }
  undo() {
    this.tagLink && this.xmlEntity.removeNode(this.tagLink);
  }
};
class GElement {
  constructor(snapEl) {
    this.snapEl = snapEl;
    this.children = new ArrayList();
  }
  setVisiable(visible) {
    this.getHtmlElement().style["display"] = visible ? "block" : "none";
  }
  isVisiable() {
    var display = this.getHtmlElement().style["display"];
    return display != "none";
  }
  add(gl) {
    this.children.add(gl);
    var node = gl.getGNode();
    this.snapEl.add(node);
    return this;
  }
  getChildren() {
    return this.children.getList();
  }
  remove() {
    this.children.clearAll();
    this.snapEl.remove();
    return this;
  }
  getGNode() {
    return this.snapEl;
  }
  getHtmlElement() {
    return this.snapEl.node;
  }
  getBBox() {
    return this.snapEl.getBBox();
  }
  transformTo(x, y) {
    this.snapEl.attr({ transform: "T" + [x, y] });
    return this;
  }
  transform(a, x, y) {
    var matrix = Snap.matrix();
    matrix.rotate(a, x, y);
    this.snapEl.transform(matrix.toTransformString());
    return this;
  }
  addClass(cls) {
    this.snapEl.addClass(cls);
    return this;
  }
  attr(params) {
    this.snapEl.attr(params);
    return this;
  }
  click(handler, thisArg) {
    this.snapEl.click(handler, thisArg);
    return this;
  }
  dblclick(handler, thisArg) {
    this.snapEl.dblclick(handler, thisArg);
    return this;
  }
  mousedown(handler, thisArg) {
    this.snapEl.mousedown(handler, thisArg);
    return this;
  }
  mousemove(handler, thisArg) {
    this.snapEl.mousemove(handler, thisArg);
    return this;
  }
  mouseout(handler, thisArg) {
    this.snapEl.mouseout(handler, thisArg);
    return this;
  }
  mouseover(handler, thisArg) {
    this.snapEl.mouseover(handler, thisArg);
    return this;
  }
  mouseup(handler, thisArg) {
    this.snapEl.mouseup(handler, thisArg);
    return this;
  }
  touchstart(handler, thisArg) {
    this.snapEl.touchstart(handler, thisArg);
    return this;
  }
  touchmove(handler, thisArg) {
    this.snapEl.touchmove(handler, thisArg);
    return this;
  }
  touchend(handler, thisArg) {
    this.snapEl.touchend(handler, thisArg);
    return this;
  }
  touchcancel(handler, thisArg) {
    this.snapEl.touchcancel(handler, thisArg);
    return this;
  }
  hover(hoverInHandler, hoverOutHandler, inThisArg, outThisArg) {
    this.snapEl.hover(hoverInHandler, hoverOutHandler, inThisArg, outThisArg);
    return this;
  }
  drag(onMove, onStart, onEnd, moveThisArg, startThisArg, endThisArg) {
    this.snapEl.drag(onMove, onStart, onEnd, moveThisArg, startThisArg, endThisArg);
    return this;
  }
}
class GSection extends GElement {
  constructor(section) {
    super(section);
    this.paper = this.getGNode();
  }
  section(varargs) {
    var section = this.paper.g();
    return new GSection(section);
  }
  circle(x, y, r) {
    var elem = this.paper.circle(x, y, r);
    return new GElement(elem);
  }
  ellipse(x, y, rx, ry) {
    var elem = this.paper.ellipse(x, y, rx, ry);
    return new GElement(elem);
  }
  image(src, x, y, width, height) {
    var elem = this.paper.image(src, x, y, width, height);
    return new GElement(elem);
  }
  line(x1, y1, x2, y2) {
    var elem = this.paper.line(x1, y1, x2, y2);
    return new GElement(elem);
  }
  path(pathSpec) {
    var elem = this.paper.path(pathSpec);
    return new GElement(elem);
  }
  polygon(varargs) {
    var elem = this.paper.polygon(varargs);
    return new GElement(elem);
  }
  polyline(varargs) {
    var elem = this.paper.polyline(varargs);
    return new GElement(elem);
  }
  rect(x, y, width, height, rx, ry) {
    var elem = this.paper.rect(x, y, width, height, rx, ry);
    return new GElement(elem);
  }
  text(x, y, text) {
    var elem = this.paper.text(x, y, text);
    return new GElement(elem);
  }
  symbol(vbx, vby, vbw, vbh) {
    var elem = this.paper.symbol(vbx, vby, vbw, vbh);
    return new GElement(elem);
  }
  clear() {
    this.paper.clear();
  }
}
class GPaper extends GSection {
  constructor(width, height) {
    super(Snap(width, height));
  }
}
let DeleteElementCmd$1 = class DeleteElementCmd2 {
  constructor(view, tagNodes) {
    this.links = [];
    this.view = view;
    this.tagNodes = tagNodes;
  }
  do() {
    var xmlEntity = this.view.getXmlEntity();
    for (let tagNode of this.tagNodes) {
      if (xmlEntity && !WfNodeUtil.canRemove(xmlEntity, tagNode)) {
        throw new Error(`${I18N.getString(tagNode.getTagName())}节点不能删除，必须保留至少一个!`);
      }
      var viewNode = this.view.findElement(tagNode);
      if (viewNode instanceof AbstractNode) {
        for (let link of this.view.getRelationLinks(viewNode)) {
          if (this.links.indexOf(link.getTagNode()) == -1) {
            this.links.push(link.getTagNode());
          }
        }
      }
    }
    for (let node of this.tagNodes) {
      xmlEntity == null ? void 0 : xmlEntity.removeNode(node);
    }
    for (let link of this.links) {
      xmlEntity == null ? void 0 : xmlEntity.removeNode(link);
    }
    return true;
  }
  undo() {
    var xmlEntity = this.view.getXmlEntity();
    for (let node of this.tagNodes) {
      xmlEntity == null ? void 0 : xmlEntity.addNode(node, node.getParent());
    }
    for (let link of this.links) {
      xmlEntity == null ? void 0 : xmlEntity.addNode(link, link.getParent());
    }
  }
};
class ChangeLineFromNodeCmd {
  constructor(xmlEntity, fromTag, orgFromTag, toLinkTag) {
    this.xmlEntity = xmlEntity;
    this.fromTag = fromTag;
    this.orgFromTag = orgFromTag;
    this.toLinkTag = toLinkTag;
  }
  do() {
    this.xmlEntity.removeNode(this.toLinkTag);
    var transCollection = this.xmlEntity.ensureNode(WfConstants.NODE_TransitionCollection, this.fromTag);
    this.xmlEntity.addNode(this.toLinkTag, transCollection);
    return true;
  }
  undo() {
    this.xmlEntity.removeNode(this.toLinkTag);
    var transCollection = this.xmlEntity.ensureNode(WfConstants.NODE_TransitionCollection, this.orgFromTag);
    this.xmlEntity.addNode(this.toLinkTag, transCollection);
  }
}
class ChangeLineToNodeCmd {
  constructor(xmlEntity, linkTag, toKey) {
    this.orgToKey = "";
    this.xmlEntity = xmlEntity;
    this.linkTag = linkTag;
    this.toKey = toKey;
  }
  do() {
    this.orgToKey = this.linkTag.getAttributeValue(WfConstants.ATTR_TargetNodeKey);
    this.linkTag.setAttributeValue(WfConstants.ATTR_TargetNodeKey, this.toKey);
    this.xmlEntity.update(this.linkTag, false);
    return true;
  }
  undo() {
    this.linkTag.setAttributeValue(WfConstants.ATTR_TargetNodeKey, this.orgToKey);
    this.xmlEntity.update(this.linkTag, false);
  }
}
class LiElement extends AbstractDomElement {
  createEl() {
    return document.createElement("li");
  }
}
class PopupPanel extends AbstractDomElement {
  constructor() {
    super();
    this.bHide = true;
    this.hide();
    this.bHide = true;
  }
  setContent(content) {
    this.clearChildren();
    this.content = content;
    this.addChild(content);
  }
  initSytles(left, top, width, height) {
    this.setStyle("display", "block");
    this.setStyle("top", top + "px");
    this.setStyle("left", left + "px");
    this.setStyle("z-index", 99);
    this.setStyles({ width: width + "px", "height": height + "px" });
    this.setStyle("position", "absolute");
  }
  hide() {
    this.bHide = true;
    this.setStyle("display", "none");
    var parent = this.getEl().parentElement;
    if (parent) {
      parent.removeChild(this.getEl());
    }
  }
  show(left, top, width, height, parent) {
    this.bHide = false;
    this.initSytles(left, top, width, height);
    this.setStyle("display", "block");
    if (!parent.contains(this.getEl())) {
      parent.appendChild(this.getEl());
      this.initSytles(left, top, width, height);
      this.setStyle("display", "block");
    }
  }
  isShowing() {
    return !this.bHide;
  }
}
class Menu extends PopupPanel {
  constructor(title = "") {
    super();
    this.menuStyle = this.styleFactory.getMenuStyle();
    this.addClass(this.menuStyle.menu);
    this.setAttr("tabindex", "0");
    this.menuBody = new DivElement();
    this.menuBody.addClass(this.menuStyle.menu_body);
    this.setContent(this.menuBody);
    let menu = this;
    this.addEventListener("blur", (e) => {
      setTimeout(function() {
        menu.hide();
      }, 10);
    });
  }
  setTitle(title) {
  }
  addMenuItem(key2, caption) {
    var menuItem = new MenuItem(key2, caption);
    this.menuBody.addChild(menuItem.getDomElement());
    return menuItem;
  }
  clearChildren() {
    this.menuBody.clearChildren();
  }
}
Menu.TEMPLATE_MENU = `
            <div class="menu">
                <div class="menu_header"><h3 class="menu_title">添加节点</h3></div>
                <div class="menu_body"/>
            </div>
            `;
class MenuItem extends JComponent {
  constructor(key2, caption) {
    super(new LiElement());
    this.setKey(key2);
    this.menuStyle = this.styleFactory.getMenuStyle();
    this.addClass(this.menuStyle.menu_item);
    this.elMenuItemContent = new DivElement();
    this.elMenuItemContent.addClass(this.menuStyle.menu_item_content);
    this.getDomElement().addChild(this.elMenuItemContent);
    this.elCaption = new SpanElement(caption);
    this.elCaption.addClass(this.menuStyle.menu_item_caption);
    this.elMenuItemContent.addChild(this.elCaption);
  }
}
MenuItem.TEMPLATE_MENU_ITEM = `
                <li class="menu_item">
                    <div class="menu_content"/>
                </li>`;
class AddNodeOnLineCmd {
  constructor(view, id, type, link) {
    this.cmds = [];
    this.view = view;
    this.id = id;
    this.type = type;
    this.link = link;
  }
  do() {
    var xmlEntity = this.view.getXmlEntity();
    if (!xmlEntity || !this.link)
      return false;
    var gl = this.link.getOptSymbo();
    var x = WfNodeUtil.cacleNodeLoc(this.type, gl.getBBox().cx, gl.getBBox().cy).leftx;
    var y = WfNodeUtil.cacleNodeLoc(this.type, gl.getBBox().cx, gl.getBBox().cy).topy;
    var cmd0 = new NewNodeCmd(xmlEntity, this.id, this.type, x, y);
    cmd0.do();
    this.cmds.push(cmd0);
    var toNode = this.view.getViewNode(String(this.id));
    var orgToKey = this.link.getToKey();
    if (toNode) {
      var tagLink = this.link.getTagNode();
      var cmd1 = new ChangeLineToNodeCmd(xmlEntity, tagLink, toNode.getKey());
      cmd1.do();
      this.cmds.push(cmd1);
      var linkID = this.view.newID();
      var cmd2 = new NewLinkCmd$1(xmlEntity, linkID, WfConstants.NODE_Flow_Sequence, toNode.getTagNode(), orgToKey);
      cmd2.do();
      this.cmds.push(cmd2);
    } else {
      return false;
    }
    return true;
  }
  undo() {
    var xmlEntity = this.view.getXmlEntity();
    if (!xmlEntity)
      return;
    for (var i = this.cmds.length - 1; i >= 0; i--) {
      this.cmds[i].undo();
    }
  }
}
class ChangeCaptionCmd {
  constructor(xmlEntity, tagNode, caption) {
    this.oldCaption = "";
    this.xmlEntity = xmlEntity;
    this.tagNode = tagNode;
    this.caption = caption;
  }
  do() {
    this.oldCaption = this.tagNode.getAttributeValue(GlobalConstants.S_Caption);
    this.tagNode.setAttributeValue(GlobalConstants.S_Caption, this.caption);
    this.xmlEntity.update(this.tagNode, true);
    return true;
  }
  undo() {
    this.tagNode.setAttributeValue(GlobalConstants.S_Caption, this.oldCaption);
    this.xmlEntity.update(this.tagNode, true);
  }
}
const _WfActionUtil = class _WfActionUtil2 {
  static isUnableAction(nodeType, action) {
    if (!_WfActionUtil2.mapUnableAction.has(nodeType)) {
      return false;
    }
    var unableActions = _WfActionUtil2.mapUnableAction.get(nodeType);
    return unableActions.indexOf(action) !== -1;
  }
};
_WfActionUtil.ACTION_ON_LINE = [
  WfConstants.NODE_Event_State,
  WfConstants.NODE_Task_Audit,
  WfConstants.NODE_Task_Service,
  WfConstants.NODE_Task_CounterSign,
  WfConstants.NODE_Gateway_Decision,
  ActionNames.model_node_remove
];
_WfActionUtil.ACTION_ON_NODE = [
  WfConstants.NODE_Event_State,
  WfConstants.NODE_Task_Audit,
  WfConstants.NODE_Task_Service,
  WfConstants.NODE_Task_CounterSign,
  WfConstants.NODE_Gateway_Decision,
  WfConstants.NODE_Flow_Sequence,
  ActionNames.model_node_remove
];
_WfActionUtil.mapUnableAction = /* @__PURE__ */ new Map([
  [WfConstants.NODE_Event_Begin, [ActionNames.model_node_remove]],
  [WfConstants.NODE_Event_End, [WfConstants.NODE_Flow_Sequence, ActionNames.model_node_remove]]
]);
let WfActionUtil = _WfActionUtil;
class DenyFlow extends AbstractLink$1 {
  constructor() {
    super();
  }
  getType() {
    return WfConstants.NODE_Flow_Deny;
  }
  getDefaultCaption() {
    return WfConstants.C_Flow_Deny;
  }
  newInstance() {
    return new DenyFlow();
  }
  drawGraphic() {
    this.group = {
      line: this.gSection.path(""),
      hide: this.gSection.path(""),
      triangle: this.gSection.path(""),
      fromHandler: this.gSection.circle(0, 0, 0),
      toHandler: this.gSection.circle(0, 0, 0),
      optSymbo: this.gSection.section()
    };
    this.group.line.attr({ stroke: this.getNormalStrokeColor(), "fill-opacity": "0.5", "stroke-dasharray": "5,5" });
    super.setVisiable(false);
    return this.group.line;
  }
  drawLink() {
    if (this.fromNode && this.toNode) {
      var pos = this.getPos(this.fromNode.getBounds(), this.toNode.getBounds());
      this.group.line.attr({ "path": pos.linestr }).attr({ stroke: this.getNormalStrokeColor() });
      this.group.triangle.attr({ "path": pos.trianglestr });
    }
  }
  getNormalStrokeColor() {
    return WfDefines.G_COLOR_STROKE_DENY;
  }
}
class Custom extends AbstractControl {
  constructor(domElement) {
    super(domElement);
  }
}
class AbstractGraphicView extends BorderPanel {
  constructor(left, right, top, bottom) {
    super(left, right, top, bottom);
    this.bEditable = true;
    this.optStateDelegate = this.createOptStateDelegate();
  }
  setEditable(editable) {
    this.bEditable = editable;
  }
  isEditable() {
    return this.bEditable;
  }
  getOptStateDelegate() {
    return this.optStateDelegate;
  }
}
class WfGraphicView extends AbstractGraphicView {
  constructor(toolbox) {
    super(toolbox ? WfDefines.DEV_TOOLBOX_WIDTH : 0, 0, 0, 0);
    this.bShowDenyLinks = false;
    this.bShowSequenceLinks = true;
    this.setStyle("overflow", "auto");
    this.xmlEntity = new XmlEntity();
    this.mapNodes = /* @__PURE__ */ new Map();
    this.mapLinks = /* @__PURE__ */ new Map();
    this.paper = new GPaper(WfDefines.PAPER_W, WfDefines.PAPER_H);
    this.paper.attr({ "tabindex": 0 });
    this.paper.addClass("bpm-view");
    this.initViewMouseEvent(this.paper);
    toolbox && this.setLeft(toolbox);
    toolbox && toolbox.bindGraphicView(this);
    this.paperContainer = new ContainerPanel();
    var paperControl = new Custom(new DomElement(this.paper.getHtmlElement()));
    this.paperContainer.addComponent(paperControl);
    this.setCenter(this.paperContainer);
    var snapLineAttr = {
      "stroke-width": "1px",
      stroke: "#0095ff",
      "fill-opacity": "0.5",
      "strokeWidth": 1,
      "stroke-dasharray": "8, 8"
    };
    this.hSnapLine = this.paper.line(0, -1, WfDefines.PAPER_W, -1).attr(snapLineAttr);
    this.vSnapLine = this.paper.line(-1, 0, -1, WfDefines.PAPER_H).attr(snapLineAttr);
    this.linePopupMenu = new Menu();
    for (var action of WfActionUtil.ACTION_ON_LINE) {
      var menuItem = this.linePopupMenu.addMenuItem(action, I18N.getString(action));
      this.initLinkOpHandler(menuItem);
    }
    this.nodePopupMenu = new Menu();
    for (var action of WfActionUtil.ACTION_ON_NODE) {
      var menuItem = this.nodePopupMenu.addMenuItem(action, I18N.getString(action));
      this.initNodeOpHandler(menuItem);
    }
    this.popupInput = new PopupPanel();
    this.inputEl = new InputElement$1();
    this.popupInput.setContent(this.inputEl);
    this.initKeyListener();
  }
  createOptStateDelegate() {
    return new OptStateDelegate(this);
  }
  setEditable(editable) {
    super.setEditable(editable);
    editable ? this.getOptStateDelegate().reset() : this.getOptStateDelegate().setUnableState();
  }
  resize(width, height) {
    this.paperContainer.resize(this.hasLeft() ? width - WfDefines.DEV_TOOLBOX_WIDTH : width, height);
  }
  initKeyListener() {
    this.getEl().addEventListener("keyup", (e) => {
      if (e.key === "Enter") {
        this.doUpdateCaption();
        e.stopPropagation();
      }
    });
  }
  doUpdateCaption() {
    if (this.popupInput.isShowing()) {
      this.popupInput.hide();
      var curSeletable = this.getSelectionModel().getSingleSeletionItem();
      if (curSeletable) {
        var input = this.inputEl.getEl();
        this.doChangeCaptionCmd(curSeletable.getTagNode(), input.value);
        this.getSelectionModel().reset();
        this.getSelectionModel().select(curSeletable.getTagNode());
      }
    }
  }
  initNodeOpHandler(item) {
    item.addEventListener(Events.MouseDown, (event) => {
      var action = item.getKey();
      if (ActionNames.model_node_remove == action) {
        this.doDeleteElementCmd();
      } else if (WfConstants.NODE_Flow_Sequence == action) {
        var linkState = this.getOptStateDelegate().setNewLinkState(WfConstants.NODE_Flow_Sequence);
        var selectable = this.getSelectionModel().getSingleSeletionItem();
        var wfNode = this.findElement(selectable == null ? void 0 : selectable.getTagNode());
        if (wfNode instanceof AbstractNode) {
          linkState.setFromNode(wfNode);
        }
      } else {
        var selectable = this.getSelectionModel().getSingleSeletionItem();
        var wfNode = this.findElement(selectable == null ? void 0 : selectable.getTagNode());
        if (wfNode instanceof AbstractNode) {
          this.getOptStateDelegate().setNewLinkAndNodeState(wfNode, action, WfConstants.NODE_Flow_Sequence);
        }
      }
      this.hidePopMenu();
    }, true);
  }
  initLinkOpHandler(item) {
    item.addEventListener(Events.MouseDown, (event) => {
      var action = item.getKey();
      if (action == ActionNames.model_node_remove) {
        this.doDeleteElementCmd();
      } else {
        this.doAddNodeOnLineCmd(action);
      }
      this.hidePopMenu();
    }, true);
  }
  /**
   * 初始化视图面板的鼠标事件
   * @param paper 
   */
  initViewMouseEvent(paper) {
    paper.mousedown((e) => this.getOptStateDelegate().getCurrentState().mousedown(e));
    paper.mousemove((e) => this.getOptStateDelegate().getCurrentState().mousemove(e));
    paper.mouseup((e) => this.getOptStateDelegate().getCurrentState().mouseup(e));
  }
  getXmlEntity() {
    return this.xmlEntity;
  }
  focus() {
    this.paper.getHtmlElement().focus();
  }
  showNodePopMenu(x, y) {
    if (!this.isEditable())
      return;
    var top = this.paperContainer.getEl().scrollTop;
    var left = this.paperContainer.getEl().scrollLeft;
    this.nodePopupMenu.show(x - left, y - top, 90, 220, this.paperContainer.getEl());
  }
  showLinePopMenu(x, y) {
    if (!this.isEditable())
      return;
    var top = this.paperContainer.getEl().scrollTop;
    var left = this.paperContainer.getEl().scrollLeft;
    this.linePopupMenu.show(x - left, y - top, 90, 180, this.paperContainer.getEl());
  }
  showPopupInput(x, y, width, height, text) {
    if (!this.isEditable())
      return;
    var input = this.inputEl.getEl();
    input.value = text;
    this.inputEl.setStyleWidth(SizeInfo.valueOfPX(width + 12));
    this.inputEl.setStyleHeight(SizeInfo.valueOfPX(height + 6));
    this.setCaretPosition(input, text ? text.length : 0);
    var top = this.paperContainer.getEl().scrollTop;
    var left = this.paperContainer.getEl().scrollLeft;
    this.popupInput.show(x - left, y - top, width, height, this.paperContainer.getEl());
  }
  setCaretPosition(control, pos) {
    if (control.setSelectionRange) {
      control.focus();
      control.setSelectionRange(pos, pos);
    }
  }
  hidePopMenu() {
    this.nodePopupMenu.hide();
    this.linePopupMenu.hide();
  }
  getPaper() {
    return this.paper;
  }
  update(tagNode) {
    var node = this.findNode(tagNode);
    if (node) {
      node.updataView();
      if (node instanceof AbstractLink$1) {
        this.updateLink(node);
      } else {
        this.updateLinkByNode(node);
      }
    }
  }
  findNode(tagNode) {
    var node = this.findNodeInCollection(tagNode, this.mapNodes.values());
    if (node)
      return node;
    node = this.findNodeInCollection(tagNode, this.mapLinks.values());
    return node;
  }
  findNodeInCollection(tagNode, nodes) {
    if (!tagNode)
      return null;
    for (let node of nodes) {
      if (node.getTagNode().getTagName() == tagNode.getTagName() && node.getID() == tagNode.getAttributeValue("ID")) {
        return node;
      }
    }
    return null;
  }
  getSelectionModel() {
    return this.xmlEntity.getSelectionModel();
  }
  getBeginNode() {
    return this.beginNode;
  }
  getEndNode() {
    return this.endNode;
  }
  load(xmlEntity) {
    this.xmlEntity = xmlEntity;
    var node = xmlEntity.getRoot();
    this.clearElements();
    this.loadNodes(node);
    this.loadLinks();
    this.initDenyLinks();
    var selectItem = this.xmlEntity.getSelectionModel().getSingleSeletionItem();
    if (selectItem) {
      var selectNode = this.findNode(selectItem.getTagNode());
      selectNode && this.xmlEntity.getSelectionModel().select(selectNode.getTagNode());
    }
  }
  getPropertyDefine() {
    return WfDevPropertyDefine.getInstance();
  }
  loadLinks() {
    for (let linkView of this.mapLinks.values()) {
      this.updateLink(linkView);
    }
  }
  isMultiNode(node) {
    if (!node)
      return false;
    if (node.getNodeType() != ENodeType.TAG)
      return false;
    var tagNode = node;
    return tagNode.getTagName() == WfConstants.NODE_AssistanceCollection;
  }
  loadNodes(node) {
    if (this.isMultiNode(node.getParent()))
      return;
    if (node.getNodeType() == ENodeType.ROOT || node.getNodeType() == ENodeType.TAG) {
      var tagNode = node;
      var wfNode = this.addViewElement(tagNode);
      if (tagNode.getTagName() == WfConstants.NODE_Event_Begin) {
        this.beginNode = wfNode;
      } else if (tagNode.getTagName() == WfConstants.NODE_Event_End) {
        this.endNode = wfNode;
      }
      for (let child of tagNode.getChildren()) {
        this.loadNodes(child);
      }
    }
  }
  addViewElement(node) {
    var viewElement = ViewElementFactory.create(node);
    if (!viewElement)
      return void 0;
    viewElement.setOnDblClick((e) => {
      var curSeletable = this.getSelectionModel().getSingleSeletionItem();
      if (curSeletable) {
        var wfElement = this.findElement(curSeletable.getTagNode());
        var gCaption = wfElement == null ? void 0 : wfElement.getGCaption();
        if (wfElement && gCaption) {
          var area = wfElement.getCaptionArea();
          this.showPopupInput(area.x, area.y, area.width, area.height, wfElement ? wfElement.getCaption() : "");
        }
      }
    });
    viewElement.setXmlNode(node);
    viewElement.initGSection(this.paper.section());
    viewElement.initXmlNode(node);
    this.initNodeEvent(viewElement);
    if (viewElement instanceof AbstractNode) {
      this.mapNodes.set(viewElement.getID(), viewElement);
    } else if (viewElement instanceof AbstractLink$1) {
      this.initLinkEvent(viewElement);
      this.mapLinks.set(viewElement.getID(), viewElement);
    }
    return viewElement;
  }
  updateLink(linkView) {
    var fromID = linkView.getFromID();
    var toKey = linkView.getToKey();
    linkView.setFromNode(this.getViewNode(fromID));
    linkView.setToNode(this.findViewNode(toKey));
  }
  /**
   * 节点位置变化后，重新绘制相关联的线
   * 
   */
  updateLinkByNode(updatedNode) {
    var nodeKey = updatedNode == null ? void 0 : updatedNode.getKey();
    for (let transition of this.mapLinks.values()) {
      var fromID = transition.getFromID();
      var node = this.getViewNode(fromID);
      var toKey = transition.getToKey();
      if (nodeKey == (node == null ? void 0 : node.getKey()) || nodeKey == toKey) {
        transition.drawLink();
      }
    }
    this.updateDenyLink(updatedNode.getTagNode());
  }
  updateDenyLink(tagNode) {
    var nodeID = tagNode.getAttributeValue(GlobalConstants.S_ID);
    var bDenyToLastNode = tagNode.getAttributeValueBoolean(WfConstants.ATTR_DenyToLastNode, false);
    var denyNodeKey = tagNode.getAttributeValue(WfConstants.ATTR_DenyNodeKey, "");
    var denyKey = this.parseDenyKey(nodeID);
    var denyLink = this.mapLinks.get(denyKey);
    if (!bDenyToLastNode && denyNodeKey) {
      this.ensureDenyLink(nodeID, denyNodeKey);
    } else if (denyLink) {
      this.removeWfNode(denyLink);
    }
    this.drawDenyFlow();
  }
  drawDenyFlow() {
    for (let denyFlow of this.mapLinks.values()) {
      if (denyFlow instanceof DenyFlow) {
        denyFlow.drawLink();
      }
    }
  }
  ensureDenyLink(formNodeID, denyNodeKey) {
    var denyLinkKey = this.parseDenyKey(formNodeID);
    var denyFlow;
    if (this.mapLinks.has(denyLinkKey)) {
      denyFlow = this.mapLinks.get(denyLinkKey);
    } else {
      denyFlow = new DenyFlow();
      denyFlow.setID(denyLinkKey);
      denyFlow.setKey(denyLinkKey);
      denyFlow.initGSection(this.paper.section());
      denyFlow.setVisiable(this.bShowDenyLinks);
      this.mapLinks.set(denyLinkKey, denyFlow);
    }
    var fromNode = this.getViewNode(formNodeID);
    var toNode = this.findViewNode(denyNodeKey);
    denyFlow.setFromNode(fromNode);
    denyFlow.setToNode(toNode);
    return denyFlow;
  }
  initDenyLinks() {
    for (let node of this.mapNodes.values()) {
      this.initDenyLink(node);
    }
  }
  initDenyLink(node) {
    var bDenyToLastNode = node.getTagNode().getAttributeValueBoolean(WfConstants.ATTR_DenyToLastNode, false);
    var denyNodeKey = node.getTagNode().getAttributeValue(WfConstants.ATTR_DenyNodeKey, "");
    if (!bDenyToLastNode && denyNodeKey) {
      this.ensureDenyLink(node.getID(), denyNodeKey);
    }
  }
  setDenyFlowDisplay(b) {
    this.bShowDenyLinks = b;
    for (let link of this.mapLinks.values()) {
      if (link instanceof DenyFlow) {
        link.setVisiable(b);
      }
    }
  }
  setSequenceFlowDisplay(b) {
    this.bShowSequenceLinks = b;
    for (let link of this.mapLinks.values()) {
      if (link instanceof SequenceFlow$1) {
        link.setVisiable(b);
      }
    }
  }
  parseDenyKey(curNodeID) {
    return `${curNodeID}__deny`;
  }
  initLinkEvent(link) {
    var selectSymobo = link.getSelectSymbo();
    var children = selectSymobo == null ? void 0 : selectSymobo.getChildren();
    if (children && children.length >= 2) {
      var formHandle = children[0];
      var toHandle = children[1];
      formHandle.mousedown((e) => {
        if (!this.isEditable())
          return;
        this.getOptStateDelegate().setChangeLineFromNodeState(link);
        e.stopPropagation();
      });
      toHandle.mousedown((e) => {
        if (!this.isEditable())
          return;
        this.getOptStateDelegate().setChangeLineToNodeState(link);
        e.stopPropagation();
      });
      var onDragMove = (dx, dy, x, y, event) => {
        this.getOptStateDelegate().getCurrentState().dragmove(dx, dy, x, y, event);
      };
      var onDragStart = (x, y, event) => {
        this.getOptStateDelegate().getCurrentState().dragstart(x, y, event);
      };
      var onDragEnd = (event) => {
        this.getOptStateDelegate().getCurrentState().dragend(event);
      };
      formHandle.drag(onDragMove, onDragStart, onDragEnd);
      toHandle.drag(onDragMove, onDragStart, onDragEnd);
    }
    link.setOptHandler((e) => {
      var gEL = link.getOptSymbo();
      var x = gEL.getBBox().cx;
      var y = gEL.getBBox().cy;
      this.showLinePopMenu(x + 15, y + 10);
      e.stopPropagation();
    });
  }
  /**
   * 初始化节点事件
   * 
   * @param wfNode
   */
  initNodeEvent(wfNode) {
    if (!wfNode)
      return;
    var controlNode = wfNode.getControlNode();
    controlNode.mousedown((e) => {
      this.focus();
      this.getOptStateDelegate().getCurrentState().mousedown(e);
      e.stopPropagation();
    });
    controlNode.hover(() => wfNode.markHovered(), () => wfNode.markUnHovered());
    var onDragMove = (dx, dy, x, y, event) => {
      this.getOptStateDelegate().getCurrentState().dragmove(dx, dy, x, y, event);
    };
    var onDragStart = (x, y, event) => {
      this.getOptStateDelegate().getCurrentState().dragstart(x, y, event);
    };
    var onDragEnd = (event) => {
      this.getOptStateDelegate().getCurrentState().dragend(event);
    };
    controlNode.drag(onDragMove, onDragStart, onDragEnd);
    wfNode.setOptHandler((e) => {
      this.showNodePopMenu(e.offsetX, e.offsetY);
      e.stopPropagation();
    });
  }
  getViewLink(id) {
    if (!id)
      return void 0;
    return this.mapLinks.get(id);
  }
  getViewNode(id) {
    if (!id)
      return void 0;
    return this.mapNodes.get(id);
  }
  getNodeKeys() {
    return this.mapNodes.keys();
  }
  getNodes() {
    return this.mapNodes.values();
  }
  getLinks() {
    return this.mapLinks.values();
  }
  findViewNode(nodeKey) {
    for (let node of this.mapNodes.values()) {
      if (node.getKey() == nodeKey) {
        return node;
      }
    }
    return void 0;
  }
  drawDragVirtual(elems, dx, dy) {
    var selectItems = this.getSelectionModel().getSelectionItems();
    if (selectItems.length == 0) {
      return;
    }
    var firstItem = selectItems[0];
    var firstNode = this.findElement(firstItem.getTagNode());
    if (firstNode instanceof AbstractNode) {
      this.snap(elems[0]);
    }
    for (let elem of elems) {
      elem.attr({ transform: "T" + [dx, dy] });
    }
  }
  snap(snapElem) {
    for (let value2 of this.mapNodes.values()) {
      if (this.snapToVNode(snapElem, value2)) {
        break;
      }
    }
    for (let value2 of this.mapNodes.values()) {
      if (this.snapToHNode(snapElem, value2)) {
        break;
      }
    }
  }
  doMoveNodeCmd(offsetX, offsetY) {
    var firstSelectItem = this.getSelectionModel().getSingleSeletionItem();
    var wfElement = this.findElement(firstSelectItem == null ? void 0 : firstSelectItem.getTagNode());
    if (!wfElement)
      return;
    var snapX = this.vSnapLine.getBBox().x;
    var snapY = this.hSnapLine.getBBox().y;
    if (snapX > 0) {
      offsetX = snapX - wfElement.getCenter().x;
    }
    if (snapY > 0) {
      offsetY = snapY - wfElement.getCenter().y;
    }
    var cmd = new MoveNodeCmd(this, offsetX, offsetY);
    this.getCmdQueue().doCmd(cmd);
    this.resetVSnapLine();
    this.resetHSnapLine();
  }
  doNewNodeCmd(type, x, y) {
    if (!this.xmlEntity)
      return;
    var cmd = new NewNodeCmd(this.xmlEntity, this.newID(), type, x, y);
    this.getCmdQueue().doCmd(cmd);
  }
  doNewLinkCmd(type, fromTag, toKey) {
    if (!this.xmlEntity || !fromTag || !toKey)
      return;
    var cmd = new NewLinkCmd$1(this.xmlEntity, this.newID(), type, fromTag, toKey);
    this.getCmdQueue().doCmd(cmd);
  }
  doDeleteElementCmd() {
    var cmd = new DeleteElementCmd$1(this, this.getSelectionModel().doCacheTagNodes());
    this.getCmdQueue().doCmd(cmd);
  }
  doChangeLineFromNodeCmd(fromTag, orgFromTag, toLinkTag) {
    if (!this.xmlEntity || !fromTag || !toLinkTag)
      return;
    var cmd = new ChangeLineFromNodeCmd(this.xmlEntity, fromTag, orgFromTag, toLinkTag);
    this.getCmdQueue().doCmd(cmd);
  }
  doChangeLineToNodeCmd(linkTag, toKey) {
    if (!this.xmlEntity || !linkTag)
      return;
    var cmd = new ChangeLineToNodeCmd(this.xmlEntity, linkTag, toKey);
    this.getCmdQueue().doCmd(cmd);
  }
  doAddNodeOnLineCmd(type) {
    if (!this.xmlEntity)
      return;
    var selectable = this.getSelectionModel().getSingleSeletionItem();
    var tagLink = selectable == null ? void 0 : selectable.getTagNode();
    var wfElement = this.findElement(tagLink);
    if (wfElement) {
      var cmd = new AddNodeOnLineCmd(this, this.newID(), type, wfElement);
      this.getCmdQueue().doCmd(cmd);
    }
  }
  doChangeCaptionCmd(tagNode, caption) {
    if (!this.xmlEntity || !tagNode)
      return;
    var cmd = new ChangeCaptionCmd(this.xmlEntity, tagNode, caption);
    this.getCmdQueue().doCmd(cmd);
  }
  undoCmd() {
    this.getCmdQueue().undoCmd();
  }
  redoCmd() {
    this.getCmdQueue().redoCmd();
  }
  getCmdQueue() {
    return this.xmlEntity.getCmdQueue();
  }
  hitHtmlElement(el) {
    if (el == this.paper.getHtmlElement()) {
      return void 0;
    }
    for (let node of this.mapNodes.values()) {
      if (node.hitHtmlElement(el)) {
        return node;
      }
    }
    for (let node of this.mapLinks.values()) {
      if (node.hitHtmlElement(el)) {
        return node;
      }
    }
    return void 0;
  }
  hitNode(x, y) {
    var selected;
    var tempForests = Number.MAX_SAFE_INTEGER;
    for (let node of this.mapNodes.values()) {
      var bounds = node.getGSection().getBBox();
      if (x > bounds.x && y > bounds.y && x < bounds.x + bounds.width && y < bounds.y + bounds.height) {
        var forests = bounds.width * bounds.height;
        if (forests < tempForests) {
          selected = node;
          tempForests = forests;
        }
      }
    }
    return selected;
  }
  getRelationLinks(node) {
    var links = [];
    var nodeKey = node.getKey();
    for (let transition of this.mapLinks.values()) {
      var fromID = transition.getFromID();
      var fromNode = this.getViewNode(fromID);
      var toKey = transition.getToKey();
      if (nodeKey == (fromNode == null ? void 0 : fromNode.getKey()) || nodeKey == toKey) {
        links.push(transition);
      }
    }
    return links;
  }
  removeWfNode(node) {
    if (!node)
      return;
    node.getGSection().remove();
    this.mapNodes.delete(node.getID());
    this.mapLinks.delete(node.getID());
    var denyKey = this.parseDenyKey(node.getID());
    var denyLink = this.mapLinks.get(denyKey);
    denyLink && this.removeWfNode(denyLink);
  }
  newID() {
    return this.xmlEntity.genNextNodeID();
  }
  notifyEvent(cmd, paras) {
    this.hidePopMenu();
    var node = paras.getElement();
    switch (cmd) {
      case ActionNames.model_node_add:
        var element = this.addViewElement(node);
        if (element instanceof AbstractLink$1)
          this.updateLink(element);
        element == null ? void 0 : element.updataView();
        this.getSelectionModel().select(node);
        break;
      case ActionNames.model_node_remove:
        var wfElement = this.findElement(node);
        this.removeWfNode(wfElement);
        break;
      case ActionNames.model_node_update:
        this.update(node);
        break;
      case ActionNames.model_node_update_select:
        this.doUpdateCaption();
        this.update(node);
        break;
    }
  }
  findElement(xmlNode) {
    if (!xmlNode)
      return void 0;
    for (let node of this.mapNodes.values()) {
      if (xmlNode == node.getTagNode()) {
        return node;
      }
    }
    for (let node of this.mapLinks.values()) {
      if (xmlNode == node.getTagNode()) {
        return node;
      }
    }
    return void 0;
  }
  /**
   * 清除所有驳回线的选中状态（驳回线在xml模型中并不存在，所以不能通过模型监听的方式实现状态变化控制）
   */
  unSelectAllDenyFlows() {
    for (let node of this.mapLinks.values()) {
      if (node instanceof DenyFlow) {
        node.getTagNode().setSelected(false);
        node.markUnSelected();
      }
    }
  }
  snapToVNode(snapElem, snapToNode) {
    if (!snapElem)
      return false;
    var box = snapElem.getBBox();
    var center = snapToNode.getCenter();
    var toX = center.x;
    var dx = Math.abs(toX - box.cx);
    if (dx <= 20) {
      this.vSnapLine.attr({ x1: toX, x2: toX });
      return true;
    } else {
      this.resetVSnapLine();
    }
    return false;
  }
  snapToHNode(snapElem, snapToNode) {
    if (!snapElem)
      return false;
    var box = snapElem.getBBox();
    var center = snapToNode.getCenter();
    var toY = center.y;
    var dy = Math.abs(toY - box.cy);
    if (dy <= 20) {
      this.hSnapLine.attr({ y1: toY, y2: toY });
      return true;
    } else {
      this.resetHSnapLine();
    }
    return false;
  }
  resetVSnapLine() {
    this.vSnapLine.attr({ x1: -1, x2: -1 });
  }
  resetHSnapLine() {
    this.hSnapLine.attr({ y1: -1, y2: -1 });
  }
  clearElements() {
    for (let node of this.mapNodes.values()) {
      node.remove();
    }
    for (let node of this.mapLinks.values()) {
      node.remove();
    }
    this.mapLinks.clear();
    this.mapNodes.clear();
  }
  /*  private updateMaxID(wfElement?: AbstractWfElement): void {
       if (!wfElement) return;
       var id = wfElement.getID() ? parseInt(wfElement.getID()): 0;
       this.maxID = Math.max(this.maxID, id);
   } */
}
class SelectionChangeListener {
  constructor(propertyContainer, propertyIO) {
    this.propertyContainer = propertyContainer;
    this.propertyIO = propertyIO;
  }
  changeSelection(selectable, viewContainer) {
    if (!selectable.isSelected())
      return;
    var propertyUIContainer = this.propertyContainer.getPropertyUIContainer();
    var propertyPlugin = propertyUIContainer.getPropertyPlugin();
    propertyPlugin.commit();
    this.propertyIO.prepare(selectable);
    propertyPlugin.display(this.propertyIO.getTagName(), this.propertyIO, propertyUIContainer.getEl(), viewContainer);
  }
}
class BaseOperationExecutor {
  constructor() {
  }
  getMode() {
    return EDesignMode.Dev;
  }
  createYigoControl(key2, type) {
    return new TextEditor();
  }
  isDevFormulaID(devFormulaID) {
    return true;
  }
  async queryFormulaDictID(code) {
    return -1;
  }
  async queryFormulaDictName(dictID) {
    return "";
  }
  async queryDictID(dictKey, code) {
    return -1;
  }
  setEditable(b) {
  }
  isEditable() {
    return true;
  }
  getForm() {
  }
  eval(exp) {
    if ("true".toLowerCase() == exp) {
      return true;
    }
    if ("false".toLowerCase() == exp) {
      return false;
    }
  }
  asyncEval(exp) {
    if ("true".toLowerCase() == exp) {
      return true;
    }
    if ("false".toLowerCase() == exp) {
      return false;
    }
  }
  getComponent(key2) {
  }
  create() {
    throw new Error("Method not implemented.");
  }
  save() {
    throw new Error("Method not implemented.");
  }
  load(xml) {
    throw new Error("Method not implemented.");
  }
  delete() {
    throw new Error("Method not implemented.");
  }
}
class OperationDispatcher {
  constructor() {
    this.curExecutor = new BaseOperationExecutor();
  }
  getMode() {
    return this.curExecutor.getMode();
  }
  createYigoControl(key2, type, component) {
    return this.curExecutor.createYigoControl(key2, type, component);
  }
  isDevFormulaID(devFormulaID) {
    return this.curExecutor.isDevFormulaID(devFormulaID);
  }
  async queryDictID(dictKey, code) {
    return await this.curExecutor.queryDictID(dictKey, code);
  }
  async queryFormulaDictName(dictID) {
    return await this.curExecutor.queryFormulaDictName(dictID);
  }
  async queryFormulaDictID(code) {
    return await this.curExecutor.queryFormulaDictID(code);
  }
  setExecutor(executor) {
    this.curExecutor = executor;
  }
  setEditable(b) {
    this.curExecutor.setEditable(b);
  }
  isEditable() {
    return this.curExecutor.isEditable();
  }
  getForm() {
    return this.curExecutor.getForm();
  }
  getComponent(key2) {
    return this.curExecutor.getComponent(key2);
  }
  async eval(exp) {
    if (exp == null || exp == void 0)
      return null;
    if (exp.toUpperCase() == "TRUE")
      return true;
    if (exp.toUpperCase() == "FALSE")
      return false;
    return await this.curExecutor.eval(exp);
  }
  async asyncEval(exp) {
    if (exp == null || exp == void 0)
      return null;
    if (exp.toUpperCase() == "TRUE")
      return true;
    if (exp.toUpperCase() == "FALSE")
      return false;
    return await this.curExecutor.asyncEval(exp);
  }
  create() {
    this.curExecutor.create();
  }
  save(xml) {
    this.curExecutor.save(xml);
  }
  load(xml) {
    this.curExecutor.load(xml);
  }
  delete() {
    this.curExecutor.delete();
  }
}
class CommonConstant {
}
CommonConstant.PREFIX = "yesui-vnode/webpluginx";
CommonConstant.SELECT_FIELD_URL = "/css/img/selectField.png";
CommonConstant.Delete_Button_Url = "/css/img/deleteButton.png";
CommonConstant.ATTR_Height = "Height";
CommonConstant.ATTR_Width = "Width";
CommonConstant.ATTR_X = "X";
CommonConstant.ATTR_Y = "Y";
CommonConstant.ATTR_TableKey = "TableKey";
CommonConstant.ATTR_FieldKey = "FieldKey";
CommonConstant.ATTR_FormKey = "FormKey";
CommonConstant.ATTR_Type = "Type";
CommonConstant.ATTR_DataSource = "DataSource";
CommonConstant.ATTR_EntityFormKey = "EntityFormKey";
CommonConstant.ATTR_IsPrimary = "IsPrimary";
CommonConstant.ATTR_Extend = "Extend";
CommonConstant.ATTR_SourceTableKey = "SourceTableKey";
CommonConstant.ATTR_ObjectKey = "ObjectKey";
CommonConstant.ROW_HEIGHT = 30;
CommonConstant.TYPE_SOURCE = "sourceType";
CommonConstant.TYPE_FeedbackIndex = "Index";
CommonConstant.Type_Source_SourceTable = "sourceTable";
CommonConstant.Type_Source_TargetTable = "targetTable";
CommonConstant.Type_Source_FeedBackTable = "feedbackTable";
CommonConstant.NODE_DataMapKey = "Key";
CommonConstant.NODE_SourceTable = "SourceTable";
CommonConstant.NODE_TargetTable = "TargetTable";
CommonConstant.NODE_SourceTableCollection = "SourceTableCollection";
CommonConstant.NODE_TargetTableCollection = "TargetTableCollection";
CommonConstant.NODE_FeedbackCollection = "FeedbackCollection";
CommonConstant.NODE_FeedbackObject = "FeedbackObject";
CommonConstant.NODE_FeedbackTable = "FeedbackTable";
CommonConstant.NODE_SrcDataObjectKey = "SrcDataObjectKey";
CommonConstant.NODE_TgtDataObjectKey = "TgtDataObjectKey";
CommonConstant.NODE_FeedbackDataObjectKey = "DataObjectKey";
CommonConstant.NODE_FeedbackObjectKey = "ObjectKey";
CommonConstant.NODE_SrcFormKey = "SrcFormKey";
CommonConstant.NODE_TgtFormKey = "TgtFormKey";
CommonConstant.NODE_FormKey = "FormKey";
CommonConstant.NODE_Definition = "Definition";
CommonConstant.NODE_FeedFormKey = "FeedFormKey";
CommonConstant.NODE_FieldKey = "FieldKey";
CommonConstant.NODE_Condition = "Condition";
CommonConstant.NODE_PostTrigger = "PostTrigger";
CommonConstant.NODE_PostFormulaTrigger = "PostFormulaTrigger";
CommonConstant.NODE_TargetFieldKey = "TargetFieldKey";
CommonConstant.NODE_TargetTableKey = "TargetTableKey";
CommonConstant.NODE_OpSign = "OpSign";
CommonConstant.NODE_MaxKey = "MaxKey";
CommonConstant.NODE_OpSign_Value = "Assign";
CommonConstant.NODE_Table_Key = "Key";
CommonConstant.NODE_SourceField = "SourceField";
CommonConstant.NODE_FeedbackTableKey = "TableKey";
CommonConstant.NODE_Table = "Table";
CommonConstant.NODE_TargetField = "TargetField";
CommonConstant.C_TargetField = "目标字段";
CommonConstant.NODE_Type = "Type";
CommonConstant.Type_Field = "Field";
CommonConstant.Type_Const = "Const";
CommonConstant.Type_Formula = "Formula";
CommonConstant.TEXT_SourceTable = "(源)  ";
CommonConstant.TEXT_feedBackTable = "(反填   )";
CommonConstant.TEXT_TargetTable = "(目标   )";
CommonConstant.Const_DefaultValue = "请双击单元格修改常量";
CommonConstant.Formula_DefaultValue = "请双击单元格修改公式";
CommonConstant.DefaultValue = "请双击单元格增加二开字段";
CommonConstant.Node_Type_Span = "SPAN";
CommonConstant.Node_Type_Input = "INPUT";
CommonConstant.Node_Type_Button = "BUTTON";
CommonConstant.Node_Type_Img = "IMG";
CommonConstant.Node_Type_Td = "TD";
CommonConstant.S_ID = "ID";
CommonConstant.S_Key = "Key";
CommonConstant.S_Caption = "Caption";
CommonConstant.NODE_Flow_Sequence = "SequenceFlow";
CommonConstant.NODE_TransitionGraphic = "TransitionGraphic";
CommonConstant.G_COLOR_STROKE_NORMAL = "#000000";
CommonConstant.G_COLOR_STROKE_SELECT = "#0096ff";
CommonConstant.G_COLOR_STROKE_VEST = "#FF0000";
CommonConstant.G_WIDTH_STROKE_NORMAL = 1;
CommonConstant.G_WIDTH_STROKE_SELECT = 2;
CommonConstant.NODE_DataMap = "Map";
CommonConstant.C_DataMap = "数据映射";
CommonConstant.NODE_FEEDBACK = "Feedback";
CommonConstant.NODE_FeedbackField = "FeedbackField";
CommonConstant.FeedLigature = "FeedLigature";
CommonConstant.VestLigature = "VestLigature";
CommonConstant.LinkType_Normal = 0;
CommonConstant.LinkType_SourceTypeKey = 1;
CommonConstant.LinkType_Focus = 2;
CommonConstant.LinkType_Focus_SourceTypeKey = 4;
CommonConstant.EdgeType_Normal = "Normal";
CommonConstant.EdgeType_Focus = "Focus";
CommonConstant.SERVICE = "SERVICE";
class PropertyIO {
  constructor(tagNodeContainer) {
    this.tagNodeContainer = tagNodeContainer;
  }
  prepare(selectable) {
    this.curTagNode = selectable ? selectable.getTagNode() : this.tagNodeContainer.getTagRoot();
  }
  getCurTagNode() {
    return this.curTagNode;
  }
  getTagName() {
    return this.curTagNode ? this.curTagNode.getTagName() : this.tagNodeContainer.getTagRoot().getTagName();
  }
  setValue(propertyItem, propertyValue) {
    var tagNode = this.setPropertyValue(propertyItem, propertyValue);
    if (this.isChildNode) {
      tagNode && this.tagNodeContainer.update(tagNode.getParent(), propertyItem.updateAttributeOnly);
    } else {
      tagNode && this.tagNodeContainer.update(tagNode, propertyItem.updateAttributeOnly);
    }
  }
  getValue(propertyItem) {
    if (!this.curTagNode)
      return "";
    var tagNode = this.getProertyNode(propertyItem, this.curTagNode);
    if (!tagNode) {
      return propertyItem.defaultvalue;
    }
    var text = tagNode.getAttributeValue(propertyItem.textAttributeKey);
    switch (propertyItem.type) {
      case XMLElementType.ATTRIBUTE:
        let key2 = propertyItem.key;
        if (key2 == "sourceContent") {
          key2 = "Definition";
        }
        if (tagNode.hasAttribute(key2)) {
          return tagNode.getAttributeValue(key2);
        } else {
          if (propertyItem.tag == CommonConstant.NODE_SourceField && key2 == CommonConstant.NODE_Definition) {
            return tagNode.getAttributeValue(CommonConstant.S_Key);
          }
          if (!text) {
            return propertyItem.defaultvalue ? propertyItem.defaultvalue : "";
          } else {
            return text;
          }
        }
      case XMLElementType.CDATA:
        var tmpNode = tagNode.getChild(propertyItem.key);
        return tmpNode ? tmpNode.getCDATAValue() : "";
      case XMLElementType.COLLECTION:
        var collection = tagNode.ensureChild(propertyItem.key);
        return collection;
    }
  }
  static setPropertyValue(curTagNode, propertyItem, propertyValue) {
    if (!curTagNode || !propertyItem)
      return void 0;
    var tagNode = PropertyIO.ensureProertyNode(propertyItem, curTagNode);
    if (curTagNode.getTagName() === "Handle" && tagNode.getTagName() === "Font") {
      if (!tagNode.hasAttribute("Bold")) {
        tagNode.setAttributeValue("Bold", "true");
      }
    }
    if ((tagNode.getTagName() == "Audit" || tagNode.getTagName() == "MultiAudit") && propertyItem.key == "DenyToLastNode" && propertyValue == "true") {
      tagNode.removeAttribute("DenyNodeKey");
    }
    switch (propertyItem.type) {
      case XMLElementType.ATTRIBUTE:
        let key2 = propertyItem.key;
        if (key2 == "sourceContent") {
          key2 = "Definition";
        }
        if (propertyItem.defaultvalue == propertyValue) {
          tagNode.removeAttribute(key2);
        } else {
          tagNode.setAttributeValue(key2, propertyValue);
        }
        break;
      case XMLElementType.CDATA:
        var tmpNode = tagNode.ensureChild(propertyItem.key);
        tmpNode.setCDATAValue(propertyValue);
        if (!propertyValue) {
          tagNode.removeChild(tmpNode);
        }
        break;
      case XMLElementType.COLLECTION:
        break;
    }
    return tagNode;
  }
  setPropertyValue(propertyItem, propertyValue) {
    var curTagNode = this.curTagNode;
    if (!curTagNode || !propertyItem)
      return void 0;
    var tagNode = this.ensureProertyNode(propertyItem, curTagNode);
    if (tagNode == null) {
      return tagNode;
    }
    if (curTagNode.getTagName() === "Handle" && tagNode.getTagName() === "Font") {
      if (!tagNode.hasAttribute("Bold")) {
        tagNode.setAttributeValue("Bold", "true");
      }
    }
    if ((tagNode.getTagName() == "Audit" || tagNode.getTagName() == "MultiAudit") && propertyItem.key == "DenyToLastNode" && propertyValue == "true") {
      tagNode.removeAttribute("DenyNodeKey");
    }
    switch (propertyItem.type) {
      case XMLElementType.ATTRIBUTE:
        let key2 = propertyItem.key;
        if (key2 == "sourceContent") {
          key2 = "Definition";
        }
        if (propertyItem.defaultvalue == propertyValue) {
          tagNode.removeAttribute(key2);
        } else {
          tagNode.setAttributeValue(key2, propertyValue);
        }
        break;
      case XMLElementType.CDATA:
        var tmpNode = tagNode.ensureChild(propertyItem.key);
        tmpNode.setCDATAValue(propertyValue);
        if (!propertyValue) {
          tagNode.removeChild(tmpNode);
        }
        break;
      case XMLElementType.COLLECTION:
        break;
    }
    return tagNode;
  }
  static ensureProertyNode(propertyItem, curTagNode) {
    var tagNode = curTagNode;
    if (propertyItem.type == XMLElementType.ATTRIBUTE && propertyItem.node) {
      var tmpNode = curTagNode.ensureChild(propertyItem.node);
      if (tmpNode)
        tagNode = tmpNode;
    }
    if (propertyItem.tag != curTagNode.getTagName()) {
      var findTagNode = PropertyIO.findTagNodeFromParent(propertyItem.tag, curTagNode);
      if (findTagNode)
        tagNode = findTagNode;
    }
    return tagNode;
  }
  ensureProertyNode(propertyItem, curTagNode) {
    var tagNode = curTagNode;
    if (propertyItem.type == XMLElementType.ATTRIBUTE && propertyItem.node) {
      var tmpNode = curTagNode.ensureChild(propertyItem.node);
      if (tmpNode) {
        tagNode = tmpNode;
        this.isChildNode = true;
      }
    } else {
      this.isChildNode = false;
    }
    if (propertyItem.tag != curTagNode.getTagName()) {
      var findTagNode = PropertyIO.findTagNodeFromParent(propertyItem.tag, curTagNode);
      if (findTagNode)
        tagNode = findTagNode;
    }
    return tagNode;
  }
  getProertyNode(propertyItem, curTagNode) {
    var tagNode = curTagNode;
    if (propertyItem.type == XMLElementType.ATTRIBUTE && propertyItem.node) {
      return curTagNode.getChild(propertyItem.node);
    }
    if (propertyItem.tag != curTagNode.getTagName()) {
      var findTagNode = PropertyIO.findTagNodeFromParent(propertyItem.tag, curTagNode);
      if (findTagNode)
        tagNode = findTagNode;
    }
    return tagNode;
  }
  static findTagNodeFromParent(findTag, tagNode) {
    if (!tagNode)
      return null;
    if (tagNode.getTagName() == findTag) {
      return tagNode;
    } else {
      return PropertyIO.findTagNodeFromParent(findTag, tagNode.getParent());
    }
  }
}
class Overlays {
  //表单当前panel下的所有折叠控件集合       
  constructor(formkey, panel) {
    this.formkey = formkey;
    this.panel = panel;
    this.tdMap = /* @__PURE__ */ new Map();
  }
  addcontrols(com, x, y) {
    let controls = new Controls(x, y);
    controls.addcontrol(com);
    controls.setCuurentSelectcom(com);
    this.tdMap.set(controls.key, controls);
  }
  emptyMap(controls) {
    this.tdMap.forEach((value2, key2, map2) => {
      value2.emptyOverlaycontrols();
    });
  }
  gettdMap(x, y) {
    let key2 = x + "-" + y;
    return this.tdMap.get(key2);
  }
  addtdMap(x, y) {
    let controls = new Controls(x, y);
    this.tdMap.set(controls.key, controls);
    return controls;
  }
  setCuurentSelectcom(com, item) {
    let x = item.x, y = item.y, xSpan = item.xSpan || 1, ySpan = item.ySpan || 1;
    for (var i = 0; i < xSpan; i++) {
      for (var j = 0; j < ySpan; j++) {
        let map2 = this.gettdMap(x + i, y + j);
        map2.setCuurentSelectcom(com);
      }
    }
  }
  clearCurrentSelectcom(com, item) {
    let x = item.x, y = item.y, xSpan = item.xSpan || 1, ySpan = item.ySpan || 1;
    for (var i = 0; i < xSpan; i++) {
      for (var j = 0; j < ySpan; j++) {
        let map2 = this.gettdMap(x + i, y + j);
        let cuurentSelectcom = map2.getCuurentSelectcom();
        map2.oldSelectcom = cuurentSelectcom;
        map2.setCuurentSelectcom(void 0);
      }
    }
  }
}
class Controls {
  constructor(X, Y) {
    this.X = X;
    this.Y = Y;
    this.key = X + "-" + Y;
    this.cuurentSelectcom = void 0;
    this.needCollapse = false;
    this.overlaycontrols = /* @__PURE__ */ new Map();
  }
  setCuurentSelectcom(com) {
    var _a;
    this.oldSelectcom = this.cuurentSelectcom || this.oldSelectcom;
    if (((_a = this.cuurentSelectcom) == null ? void 0 : _a.cssClass.indexOf("overlays-control")) >= 0) {
      this.cuurentSelectcom.cssClass = this.cuurentSelectcom.cssClass.replace("overlays-control", "");
    }
    this.cuurentSelectcom = com;
  }
  getCuurentSelectcom() {
    return this.cuurentSelectcom;
  }
  addcontrol(com, item) {
    var control;
    control = { com, item };
    this.overlaycontrols.set(com.key, control);
    if (this.overlaycontrols.size > 1) {
      this.needCollapse = true;
    }
  }
  getOldSelectcom() {
    return this.oldSelectcom;
  }
  hasControl(key2) {
    return this.overlaycontrols.get(key2) ? true : false;
  }
  getControl(key2) {
    return this.overlaycontrols.get(key2).com;
  }
  getControlItem(key2) {
    return this.overlaycontrols.get(key2).item;
  }
  emptyOverlaycontrols() {
    this.overlaycontrols = /* @__PURE__ */ new Map();
    this.oldSelectcom = this.cuurentSelectcom;
    this.cuurentSelectcom = void 0;
  }
}
class ServiceParams {
}
class ErpDesignerHelper {
  static ResetSelectedBorder() {
    if (!ErpDesignerGlobal.buttonInsertBefore)
      return;
    ErpDesignerGlobal.buttonInsertBefore.css("top", "-1000px");
    ErpDesignerGlobal.buttonInsertAfter.css("top", "-1000px");
    ErpDesignerGlobal.buttonInsertBefore1.css("top", "-1000px");
    ErpDesignerGlobal.buttonInsertAfter1.css("top", "-1000px");
    ErpDesignerGlobal.buttonInsertBefore2.css("top", "-1000px");
    ErpDesignerGlobal.buttonInsertAfter2.css("top", "-1000px");
    ErpDesignerGlobal.buttonSonRow.css("top", "-1000px");
    ErpDesignerGlobal.buttonNewRow.css("top", "-1000px");
    ErpDesignerGlobal.buttonDeleteRow.css("top", "-1000px");
    ErpDesignerGlobal.buttonQuote.css("top", "-1000px");
    ErpDesignerGlobal.buttonPanQuote.css("top", "-1000px");
    ErpDesignerGlobal.buttonDelete.css("top", "-1000px");
    ErpDesignerGlobal.buttonMultyDelete.css("top", "-1000px");
    ErpDesignerGlobal.buttonInsert.css("top", "-1000px");
    ErpDesignerGlobal.compositeComponentInsert.css("top", "-1000px");
    ErpDesignerGlobal.compositeComInsertToGrid.css("top", "-1000px");
    ErpDesignerGlobal.insertEmbed.css("top", "-1000px");
    ErpDesignerGlobal.buttonReplace.css("top", "-1000px");
    ErpDesignerGlobal.addSelectComponent.css("top", "-1000px");
    ErpDesignerGlobal.buttonaddPanelRow.css("top", "-1000px");
    ErpDesignerGlobal.buttonaddTableRow.css("top", "-1000px");
    ErpDesignerGlobal.buttonDeleteTableRow.css("top", "-1000px");
    ErpDesignerGlobal.buttonOperation.css("top", "-1000px");
    ErpDesignerGlobal.buttonInsertTabItem.css("top", "-1000px");
    ErpDesignerGlobal.buttonMoveTabItemAfter.css("top", "-1000px");
    ErpDesignerGlobal.buttonMoveTabItemFront.css("top", "-1000px");
    ErpDesignerGlobal.nw.css("top", "-1000px");
    ErpDesignerGlobal.ne.css("top", "-1000px");
    ErpDesignerGlobal.sw.css("top", "-1000px");
    ErpDesignerGlobal.se.css("top", "-1000px");
    ErpDesignerGlobal.$top.css("top", "-1000px");
    ErpDesignerGlobal.$left.css("top", "-1000px");
    ErpDesignerGlobal.$bottom.css("top", "-1000px");
    ErpDesignerGlobal.$right.css("top", "-1000px");
  }
  static isHiddenByVest(metaForm, compKey, parentCompKey) {
    if (!ErpDesigner.selectedComponentKey)
      return false;
    if (!metaForm.extend)
      return false;
    if (!parentCompKey)
      return false;
    let metaComp = metaForm.getComponent(parentCompKey);
    if (!metaComp)
      return false;
    let columns = metaComp.columns;
    if (!columns)
      return false;
    for (let i = 0; i < columns.length; i++) {
      let column = columns[i];
      if ("Column:" + column.key !== compKey && column.metaGridColumnKey !== compKey) {
        continue;
      }
      if (column.visible === "return False;") {
        return true;
      }
    }
    return false;
  }
  static createSelectedBorder() {
    let $form = ErpDesignerGlobal.$from;
    if (ErpDesignerGlobal.nw) {
      this.deleteSelectedBorder();
    }
    ErpDesignerGlobal.nw = $('<div class="design-location selectedPoint" style="cursor: nw-resize;"></div>');
    ErpDesignerGlobal.ne = $('<div class="design-location selectedPoint" style="cursor: ne-resize;"></div>');
    ErpDesignerGlobal.sw = $('<div class="design-location selectedPoint" style="cursor: sw-resize;"></div>');
    ErpDesignerGlobal.se = $('<div class="design-location selectedPoint" style="cursor: se-resize;"></div>');
    ErpDesignerGlobal.$top = $('<div class="design-location selectedBorder" style="cursor: move; height: 4px; border-top: 1px solid #330099;"></div>');
    ErpDesignerGlobal.$left = $('<div class="design-location selectedBorder" style="cursor: move; width: 4px; border-left: 1px solid #330099;"></div>');
    ErpDesignerGlobal.$bottom = $('<div class="design-location selectedBorder" style="cursor: move; height: 4px; border-bottom: 1px solid #330099;"></div>');
    ErpDesignerGlobal.$right = $('<div class="design-location selectedBorder" style="cursor: move; width: 4px; border-right: 1px solid #330099;"></div>');
    ErpDesignerGlobal.buttonDelete = $('<span id="buttonDelete" class="design-location selectedButton" title="删除" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonMultyDelete = $('<span id="buttonMultyDelete" class="design-location selectedButton" title="多选删除" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonInsertBefore = $('<span id="buttonInsertBefore" class="design-location selectedButton" title="前插列" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonInsertBefore1 = $('<span id="buttonInsertBefore1" class="design-location selectedButton" title="前插列" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonInsertAfter = $('<span id="buttonInsertAfter" class="design-location selectedButton" title="后插列" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonInsertAfter1 = $('<span id="buttonInsertAfter1" class="design-location selectedButton" title="后插列" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonInsertBefore2 = $('<span id="buttonInsertBefore2" class="design-location selectedButton" title="前插组件" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonInsertAfter2 = $('<span id="buttonInsertAfter2" class="design-location selectedButton" title="后插组件" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonInsert = $('<span id="buttonInsert" class="design-location selectedButton" title="新增组件" style="top:-1000px"/>');
    ErpDesignerGlobal.compositeComponentInsert = $('<span id="compositeComponentInsert" class="design-location selectedButton" title="新增复合组件" style="top:-1000px"/>');
    ErpDesignerGlobal.compositeComInsertToGrid = $('<span id="compositeComInsertToGrid" class="design-location selectedButton" title="新增复合组件" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonQuote = $('<span id="buttonQuote" class="design-location selectedButton" title="引入组件" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonPanQuote = $('<span id="buttonPanQuote" class="design-location selectedButton" title="引入组件" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonSonRow = $('<span id="buttonSonRow" class="design-location selectedButton" title="添加子序列" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonNewRow = $('<span id="buttonNewRow" class="design-location selectedButton" title="后插入行" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonaddPanelRow = $('<span id="buttonaddPanelRow" class="design-location selectedButton" title="行操作" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonaddTableRow = $('<span id="buttonaddTableRow" class="design-location selectedButton" title="新增视图行" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonDeleteTableRow = $('<span id="buttonDeleteTableRow" class="design-location selectedButton" title="删除视图行" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonOperation = $('<span id="buttonOperation" class="design-location selectedButton" title="添加操作" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonDeleteRow = $('<span id="buttonDeleteRow" class="design-location selectedButton" title="删除单元格对应行" style="top:-1000px"/>');
    ErpDesignerGlobal.insertEmbed = $('<span id="insertEmbed" class="design-location selectedButton" title="外嵌组件" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonReplace = $('<span id="buttonReplace" class="design-location selectedButton" title="替换父面板" style="top:-1000px"/>');
    ErpDesignerGlobal.addSelectComponent = $('<span id="addSelectComponent" class="design-location selectedButton" title="为表格添加查询组件" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonInsertTabItem = $('<span id="buttonInsertTabItem" class="design-location selectedButton" title="新增tabItem" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonMoveTabItemAfter = $('<span id="buttonMoveTabItemAfter" class="design-location selectedButton" title="向后移动tabItem" style="top:-1000px"/>');
    ErpDesignerGlobal.buttonMoveTabItemFront = $('<span id="buttonMoveTabItemFront" class="design-location selectedButton" title="向前移动tabItem" style="top:-1000px"/>');
    [
      ErpDesignerGlobal.nw,
      ErpDesignerGlobal.ne,
      ErpDesignerGlobal.sw,
      ErpDesignerGlobal.se,
      ErpDesignerGlobal.$top,
      ErpDesignerGlobal.$left,
      ErpDesignerGlobal.$bottom,
      ErpDesignerGlobal.$right,
      ErpDesignerGlobal.buttonDelete,
      ErpDesignerGlobal.buttonMultyDelete,
      ErpDesignerGlobal.buttonInsertBefore,
      ErpDesignerGlobal.buttonInsertAfter,
      ErpDesignerGlobal.buttonInsertBefore1,
      ErpDesignerGlobal.buttonInsertAfter1,
      ErpDesignerGlobal.buttonInsert,
      ErpDesignerGlobal.compositeComponentInsert,
      ErpDesignerGlobal.buttonSonRow,
      ErpDesignerGlobal.buttonQuote,
      ErpDesignerGlobal.buttonPanQuote,
      ErpDesignerGlobal.buttonNewRow,
      ErpDesignerGlobal.buttonDeleteRow,
      ErpDesignerGlobal.insertEmbed,
      ErpDesignerGlobal.buttonReplace,
      ErpDesignerGlobal.buttonaddPanelRow,
      ErpDesignerGlobal.buttonaddTableRow,
      ErpDesignerGlobal.buttonDeleteTableRow,
      ErpDesignerGlobal.buttonOperation,
      ErpDesignerGlobal.addSelectComponent,
      ErpDesignerGlobal.buttonInsertBefore2,
      ErpDesignerGlobal.buttonInsertAfter2,
      ErpDesignerGlobal.compositeComInsertToGrid,
      ErpDesignerGlobal.buttonInsertTabItem,
      ErpDesignerGlobal.buttonMoveTabItemAfter,
      ErpDesignerGlobal.buttonMoveTabItemFront
    ].forEach(function(ele, index, self) {
      ele.appendTo($form);
    });
  }
  static deleteSelectedBorder() {
    ErpDesignerGlobal.nw.remove();
    ErpDesignerGlobal.ne.remove();
    ErpDesignerGlobal.sw.remove();
    ErpDesignerGlobal.se.remove();
    ErpDesignerGlobal.$top.remove();
    ErpDesignerGlobal.$left.remove();
    ErpDesignerGlobal.$bottom.remove();
    ErpDesignerGlobal.$right.remove();
    ErpDesignerGlobal.buttonDelete.remove();
    ErpDesignerGlobal.buttonMultyDelete.remove();
    ErpDesignerGlobal.buttonInsertBefore.remove();
    ErpDesignerGlobal.buttonInsertBefore1.remove();
    ErpDesignerGlobal.buttonInsertAfter.remove();
    ErpDesignerGlobal.buttonInsertAfter1.remove();
    ErpDesignerGlobal.buttonInsertBefore2.remove();
    ErpDesignerGlobal.buttonInsertAfter2.remove();
    ErpDesignerGlobal.buttonInsert.remove();
    ErpDesignerGlobal.compositeComponentInsert.remove();
    ErpDesignerGlobal.compositeComInsertToGrid.remove();
    ErpDesignerGlobal.buttonQuote.remove();
    ErpDesignerGlobal.buttonPanQuote.remove();
    ErpDesignerGlobal.buttonSonRow.remove();
    ErpDesignerGlobal.buttonNewRow.remove();
    ErpDesignerGlobal.buttonaddPanelRow.remove();
    ErpDesignerGlobal.buttonaddTableRow.remove();
    ErpDesignerGlobal.buttonDeleteTableRow.remove();
    ErpDesignerGlobal.buttonOperation.remove();
    ErpDesignerGlobal.buttonDeleteRow.remove();
    ErpDesignerGlobal.insertEmbed.remove();
    ErpDesignerGlobal.buttonReplace.remove();
    ErpDesignerGlobal.addSelectComponent.remove();
    ErpDesignerGlobal.buttonInsertTabItem.remove();
    ErpDesignerGlobal.buttonMoveTabItemAfter.remove();
    ErpDesignerGlobal.buttonMoveTabItemFront.remove();
    ErpDesignerGlobal.nw = null;
    ErpDesignerGlobal.ne = null;
    ErpDesignerGlobal.sw = null;
    ErpDesignerGlobal.se = null;
    ErpDesignerGlobal.$top = null;
    ErpDesignerGlobal.$left = null;
    ErpDesignerGlobal.$bottom = null;
    ErpDesignerGlobal.$right = null;
    ErpDesignerGlobal.buttonDelete = null;
    ErpDesignerGlobal.buttonInsertBefore = null;
    ErpDesignerGlobal.buttonInsertBefore1 = null;
    ErpDesignerGlobal.buttonInsertAfter = null;
    ErpDesignerGlobal.buttonInsertAfter1 = null;
    ErpDesignerGlobal.buttonInsertBefore2 = null;
    ErpDesignerGlobal.buttonInsertAfter2 = null;
    ErpDesignerGlobal.buttonInsert = null;
    ErpDesignerGlobal.compositeComponentInsert = null;
    ErpDesignerGlobal.compositeComInsertToGrid = null;
    ErpDesignerGlobal.buttonQuote = null;
    ErpDesignerGlobal.buttonPanQuote = null;
    ErpDesignerGlobal.buttonSonRow = null;
    ErpDesignerGlobal.buttonNewRow = null;
    ErpDesignerGlobal.buttonaddPanelRow = null;
    ErpDesignerGlobal.buttonaddTableRow = null;
    ErpDesignerGlobal.buttonDeleteTableRow = null;
    ErpDesignerGlobal.buttonOperation = null;
    ErpDesignerGlobal.buttonDeleteRow = null;
    ErpDesignerGlobal.insertEmbed = null;
    ErpDesignerGlobal.buttonReplace = null;
    ErpDesignerGlobal.addSelectComponent = null;
    ErpDesignerGlobal.buttonInsertTabItem = null;
    ErpDesignerGlobal.buttonMoveTabItemAfter = null;
    ErpDesignerGlobal.buttonMoveTabItemFront = null;
  }
  static updateZIndex(zindex) {
    if (!ErpDesignerGlobal.nw)
      return;
    ErpDesignerGlobal.nw.css("zIndex", zindex);
    ErpDesignerGlobal.ne.css("zIndex", zindex);
    ErpDesignerGlobal.sw.css("zIndex", zindex);
    ErpDesignerGlobal.se.css("zIndex", zindex);
    ErpDesignerGlobal.$top.css("zIndex", zindex);
    ErpDesignerGlobal.$left.css("zIndex", zindex);
    ErpDesignerGlobal.$bottom.css("zIndex", zindex);
    ErpDesignerGlobal.$right.css("zIndex", zindex);
    ErpDesignerGlobal.buttonInsertBefore.css("zIndex", zindex);
    ErpDesignerGlobal.buttonInsertAfter.css("zIndex", zindex);
    ErpDesignerGlobal.buttonInsertBefore1.css("zIndex", zindex);
    ErpDesignerGlobal.buttonInsertAfter1.css("zIndex", zindex);
    ErpDesignerGlobal.buttonInsertBefore2.css("zIndex", zindex);
    ErpDesignerGlobal.buttonInsertAfter2.css("zIndex", zindex);
    ErpDesignerGlobal.buttonSonRow.css("zIndex", zindex);
    ErpDesignerGlobal.buttonNewRow.css("zIndex", zindex);
    ErpDesignerGlobal.buttonDeleteRow.css("zIndex", zindex);
    ErpDesignerGlobal.buttonMultyDelete.css("zIndex", zindex);
    ErpDesignerGlobal.buttonQuote.css("zIndex", zindex);
    ErpDesignerGlobal.buttonPanQuote.css("zIndex", zindex);
    ErpDesignerGlobal.buttonDelete.css("zIndex", zindex);
    ErpDesignerGlobal.buttonInsert.css("zIndex", zindex);
    ErpDesignerGlobal.compositeComponentInsert.css("zIndex", zindex);
    ErpDesignerGlobal.compositeComInsertToGrid.css("zIndex", zindex);
    ErpDesignerGlobal.insertEmbed.css("zIndex", zindex);
    ErpDesignerGlobal.buttonReplace.css("zIndex", zindex);
    ErpDesignerGlobal.addSelectComponent.css("zIndex", zindex);
    ErpDesignerGlobal.buttonaddPanelRow.css("zIndex", zindex);
    ErpDesignerGlobal.buttonOperation.css("zIndex", zindex);
    ErpDesignerGlobal.buttonaddTableRow.css("zIndex", zindex);
    ErpDesignerGlobal.buttonDeleteTableRow.css("zIndex", zindex);
    ErpDesignerGlobal.buttonInsertTabItem.css("zIndex", zindex);
    ErpDesignerGlobal.buttonMoveTabItemAfter.css("zIndex", zindex);
    ErpDesignerGlobal.buttonMoveTabItemFront.css("zIndex", zindex);
  }
  static getFormByKey(formList, formKey) {
    for (let i = 0; i < formList.length; i++) {
      if (formKey === formList[i].formKey) {
        return formList[i];
      }
    }
    return null;
  }
  static clearMultySelect() {
    if (!ErpDesignerGlobal.multySelectCom)
      return;
    ErpDesignerGlobal.multySelectCom.forEach(function(com) {
      com.unbind();
      com.removeClass("multySelect");
    });
    ErpDesignerGlobal.multySelectCom = [];
  }
}
class OpenedXML {
  constructor() {
    this.filePath = null;
    this.caption = null;
    this.component = null;
    this.xmlEditor = null;
  }
}
const _ErpDesignerSrc = class _ErpDesignerSrc2 {
  // 取行的原值
  static getLineOrgValue(editor, change) {
    let editingContent = editor.editingContent, cursor = editor.doc.getCursor(), ch = cursor.ch, lines = [];
    for (let i = editingContent.startLine; i <= editingContent.newEndLine; i++) {
      lines.push(editor.doc.getLine(i));
    }
    let str = lines.join("\r\n"), left = str.substr(0, str.length - lines[lines.length - 1].length + ch), origin = change.origin;
    if (origin == "+input" || origin == "paste" || origin == "*compose") {
      left = left.substr(0, left.length - change.text.join("\r\n").length);
    }
    if (origin == "+input" || origin == "paste" || origin == "+delete" || origin == "cut" || origin == "*compose") {
      if (change.removed.length > 0) {
        left = left + change.removed.join("\r\n");
      }
    }
    let orgValue = left + str.substr(str.length - lines[lines.length - 1].length + ch);
    return orgValue;
  }
  static async BPMNProcess() {
    await new Request().getData({
      cmd: "BPMNProcess",
      service: "WebPluginService"
    });
  }
  static xmlChangeHandler(formKey, editor, change) {
    let origin = change.origin;
    if (!(origin == "+input" || origin == "+delete" || origin == "paste" || origin == "cut" || origin == "*compose")) {
      return;
    }
    let editingContent = editor.editingContent;
    if (!editingContent) {
      editingContent = editor.editingContent = {};
    }
    if (editingContent.startLine == void 0) {
      let cursor = editor.doc.getCursor(), newLine = cursor.line;
      editingContent.startLine = newLine - change.text.length + 1;
      editingContent.orgEndLine = editingContent.startLine + change.removed.length - 1;
      editingContent.newEndLine = newLine;
      editingContent.formKey = formKey;
      editingContent.orgValue = this.getLineOrgValue(editor, change);
    } else {
      editingContent.newEndLine = editingContent.newEndLine + change.text.length - 1;
      if (change.removed.length > change.text.length) {
        editingContent.orgEndLine = editingContent.orgEndLine + change.removed.length - change.text.length;
        let tmp = editingContent.orgValue + change.removed.join("\r\n");
        tmp = tmp.substr(0, tmp.length - change.text.join("\r\n").length) + editor.doc.getLine(editor.doc.getCursor().line);
        editingContent.orgValue = tmp;
      }
    }
    ErpDesignerFuns.xmlAttrMatch(editor, change);
    let sourceTabForm = ErpDesignerUI.DesignActionForm[1], toolbar = sourceTabForm && sourceTabForm.getComponent("D_YToolBar1");
    if (toolbar) {
      setTimeout(() => {
        if (toolbar.yesCom && !toolbar.yesCom.isDestroyed) {
          toolbar.yesCom.resizeFun();
        }
      }, 500);
    }
  }
  static async showXml(filePath, caption, formKey, tabHeight) {
    if (!tabHeight) {
      let tabPanel2 = ErpDesignerUI.designPanel.getComponent("TabPanel1");
      let totalHeight = $(document.body).height();
      tabHeight = totalHeight - $(tabPanel2.getEl().getElm()).children(0).outerHeight();
    }
    let xmlRegex = "(.xml)$";
    let re = new RegExp(xmlRegex);
    if (!filePath) {
      return;
    }
    let bpmToken = filePath.indexOf("BPM");
    let preStr = filePath.substring(bpmToken - 1, bpmToken);
    let nextStr = filePath.substring(bpmToken + 3, bpmToken + 4);
    if (bpmToken != -1 && (preStr == "/" || preStr == "\\") && nextStr == "." && re.test(filePath.toLowerCase())) {
      if ($("#workFlowFrameId")) {
        $("#workFlowFrameId").remove();
      }
      if ($("#workFlowShadeId")) {
        $("#workFlowShadeId").remove();
      }
      $("<input id='bpmFilePath' type='hidden'/>").val(filePath).prependTo("body");
      $("<iframe id='workFlowFrameId' name='workFlowFrameId' scrolling='no' style='position:fixed;margin:auto;left:0;right:0;top:0;bottom:0;width:60%;height:600px;background-color:#fff;z-index: 9999;border-radius: 5px;'  frameborder='no' marginheight='0' marginwidth='0' allowTransparency='false'></iframe>").prependTo("body");
      $("#workFlowFrameId").attr("src", "../erp/project/bpm/html/workflowAndBills.html");
      $("<div id='workFlowShadeId' style='display:block;position:absolute;left:0px;top:0px;background:rgba(0, 0, 0, 0.4);width:100%;height:100%;filter:alpha(opacity=60);opacity:0.6;z-Index:999;'/>").prependTo("body");
    }
    if (!ErpDesignerUI.sourceForm) {
      return;
    }
    let tabPanel = CodeMirrorWorkSpace.XMLEditor.tabpanel;
    tabPanel.setHeight(tabHeight - 25);
    $(tabPanel.getEl().getElm()).height(tabHeight - 25);
    let openXml = _ErpDesignerSrc2.openedXmls.get(filePath);
    if (openXml) {
      if (openXml.component) {
        tabPanel.setActiveTab(openXml.component.key);
        tabPanel.doLayout();
      }
      return;
    }
    openXml = new OpenedXML();
    _ErpDesignerSrc2.openedXmls.set(filePath, openXml);
    openXml.filePath = filePath;
    openXml.caption = caption.split("\\")[caption.split("\\").length - 1].split(".xml")[0];
    openXml.formKey = filePath.replace(/\//gm, "\\").split("\\")[filePath.split("\\").length - 1].split(".xml")[0];
    let fileContent = await ErpDesignerService.loadFileContent(filePath, true);
    openXml.isNew = fileContent.isNew;
    openXml.isEditBeforeLoad = fileContent.isEditBeforeLoad;
    let content = fileContent.content;
    let componentHeight = tabPanel.getHeight() - tabPanel.getEl().getElm().children[0].offsetHeight - 28;
    let XMLEditorBuilder = CompBuilder.get(ControlType.TEXTEDITOR);
    let noopForm = await ErpDesignerService.getMetaDesignerForm("D_NoopForm", !ErpDesignerUI.delayedProcessScope, void 0, void 0);
    let component = openXml.component = XMLEditorBuilder.build(
      noopForm,
      {
        tagName: "texteditor",
        type: ControlType.TEXTEDITOR,
        caption,
        key: "XMLEditor" + this.xmlEditorIndex++,
        width: tabPanel.getWidth(),
        height: componentHeight,
        value: filePath,
        properties: {}
      },
      {}
    );
    let com = ControlMapping.getInstance().get(component);
    component.setYesCom(com);
    tabPanel.meta.items.push(com);
    tabPanel.items.push(component);
    tabPanel.layoutItems.push(component);
    tabPanel.impl.layoutitems.push(component);
    tabPanel.impl.buildTitleVNode = this.buildTitleVNode;
    tabPanel.impl.renderChildren();
    tabPanel.afterAdd = ERPDESIGNER.afterAddComponentToTabPanel;
    component.getEl().addPostpatchHook(() => {
      _ErpDesignerSrc2.renderXmlEditor(component, filePath, openXml, formKey, content);
    });
    tabPanel.setActiveTab(component.key);
  }
  static buildTitleVNode(tabID, title) {
    var _a = YElement.buildFromVNode(h("a", { attrs: { href: "#" + tabID } }));
    let tabPanel = CodeMirrorWorkSpace.XMLEditor.tabpanel;
    _a.$addClass("ui-tans-anchor").$setAttr("role", "presentation");
    var _label = YElement.buildFromVNode(h("label", title)).$appendTo(_a);
    _label.$addClass("ui-anchor-label").$setAttr("title", title);
    var _span = YElement.buildFromVNode(h("span", {})).$appendTo(_a);
    _span.$addClass("ui-icon");
    _span.$addClass("ui-icon-close");
    _span.$setAttr("aria-controls", tabID);
    _span.$click((target) => {
      target.preventDefault();
      target.stopPropagation();
      var _this = tabPanel.impl;
      var itemId = target.target.getAttribute("aria-controls");
      var list = tabPanel.impl._head.$findByClassName("tab-list")[0];
      var now_index = ERPDESIGNER.Src.getTabIndex1(list, itemId);
      var com = _this.getCom(now_index);
      ErpDesignerUI.closeFilePath(com.meta.value);
    });
    return _a;
  }
  //item.getAttribute("aria-controls")
  static getTabIndex1(list, key2) {
    var tabIndex = -1;
    list.$findByTagName("li").forEach((item, index) => {
      if (item.getAttr("aria-controls") == key2) {
        tabIndex = index;
      }
    });
    return tabIndex;
  }
  //格式化xml代码
  static formateXml(xmlStr) {
    var text = xmlStr;
    text = "\n" + text.replace(/(<\w+)(\s.*?>)/g, function($0, name, props) {
      return name + "" + props.replace(/\s+(\w+=)/g, " $1");
    }).replace(/>\s*?</g, ">\n<");
    text = text.replace(/\n/g, "\r").replace(/<!--(.+?)-->/g, function($0, text2) {
      var ret = "<!--" + escape(text2) + "-->";
      return ret;
    }).replace(/\r/g, "\n");
    var rgx = /\n(<(([^\?]).+?)(?:\s|\s*?>|\s*?(\/)>)(?:.*?(?:(?:(\/)>)|(?:<(\/)\2>)))?)/mg;
    var nodeStack = [];
    var output = text.replace(rgx, function($0, all, name, isBegin, isCloseFull1, isCloseFull2, isFull1, isFull2) {
      var isClosed = isCloseFull1 == "/" || isCloseFull2 == "/" || isFull1 == "/" || isFull2 == "/";
      var prefix = "";
      if (isBegin == "!") {
        //!开头
        prefix = _ErpDesignerSrc2.setPrefix(nodeStack.length);
      } else {
        if (isBegin != "/") {
          prefix = _ErpDesignerSrc2.setPrefix(nodeStack.length);
          if (!isClosed) {
            nodeStack.push(name);
          }
        } else {
          nodeStack.pop();
          prefix = _ErpDesignerSrc2.setPrefix(nodeStack.length);
        }
      }
      var ret = "\n" + prefix + all;
      return ret;
    });
    var outputText = output.substring(1);
    outputText = outputText.replace(/\n/g, "\r").replace(/(\s*)<!--(.+?)-->/g, function($0, prefix, text2) {
      if (prefix.charAt(0) == "\r")
        prefix = prefix.substring(1);
      text2 = unescape(text2).replace(/\r/g, "\n");
      var ret = "\n" + prefix + "<!--" + text2.replace(/^\s*/mg, prefix) + "-->";
      return ret;
    });
    outputText = outputText.replace(/\s+$/g, "").replace(/\r/g, "\r\n");
    if (outputText.endsWith("</Form>")) {
      outputText = outputText + "\n";
    }
    return outputText;
  }
  //计算头函数	用来缩进
  static setPrefix(prefixIndex) {
    var result = "";
    var span = "    ";
    var output = [];
    for (var i = 0; i < prefixIndex; ++i) {
      output.push(span);
    }
    result = output.join("");
    return result;
  }
  static hasEdited(openedXml) {
    if (openedXml.isNew || openedXml.isEditBeforeLoad) {
      return true;
    }
    let xmlEditor = openedXml.xmlEditor;
    if (!xmlEditor) {
      return false;
    }
    let history = xmlEditor.doc.getHistory();
    if (!history) {
      return false;
    }
    let done = history.done;
    if (!done) {
      return false;
    }
    for (let i = 0, size = done.length; i < size; i++) {
      if (done[i].changes) {
        return true;
      }
    }
    return false;
  }
  static hasError(xmlEditor) {
    for (let line = 0, lineSize = xmlEditor.lineCount(); line < lineSize; line++) {
      let lineHandle = xmlEditor.doc.getLineHandle(line);
      let tmp = lineHandle.styles;
      if (tmp) {
        let lastStyle = tmp[tmp.length - 1];
        if (typeof lastStyle == "string" && lastStyle.indexOf("error") >= 0) {
          return true;
        }
      }
    }
    return false;
  }
  static async showXmlByFormKey(formKey, entryParas) {
    var _a;
    if (!ErpDesignerUI.D_FileTree || !CodeMirrorWorkSpace.XMLEditor)
      return;
    if (entryParas) {
      LoadingUtil.show();
      await this.showXmlByFormKey(entryParas, "");
      LoadingUtil.hide();
    }
    let filePaths = await ErpDesigner.DesignerSourceCache.get(formKey), filePathList = filePaths;
    if (!filePaths) {
      let activeForm = ErpDesignerUI.getActiveERPForm();
      let params = { cmd: "LoadFilePathsByFormKey", service: "DesignService", uiFormKey: formKey, entryParas, Container: activeForm.paras.map.ItemKey };
      filePaths = await new Request().getData(params);
      if (!filePaths || filePaths.length == 0)
        return;
      if (formKey !== "DictEdit") {
        ErpDesigner.DesignerSourceCache.put(formKey, filePaths);
      }
      filePathList = filePaths;
    }
    let formDependXML = this.formDependXMLs.get(formKey);
    if (!formDependXML) {
      formDependXML = new Array();
      for (let i = 0; i < filePathList.length; i++) {
        formDependXML.push(filePathList[i].filePath);
      }
      this.formDependXMLs.set(formKey, formDependXML);
    }
    let tabPanel = ErpDesignerUI.designPanel.getComponent("TabPanel1"), sourceTab = tabPanel.get("SourceTab");
    let totalHeight = $(document.body).height();
    let tabHeight = totalHeight - $(tabPanel.getEl().getElm()).children(0).outerHeight();
    sourceTab.needRender = true;
    sourceTab.setHeight(tabHeight);
    tabPanel.doLayout(tabPanel.getWidth(), tabPanel.getHeight());
    tabPanel.setHeight(totalHeight);
    if (tabPanel.activeTab !== 1) {
      $(".ui-anchor-label[title='文件树']").mousedown().mouseup().click();
      ErpDesignerUI.D_FileTree.rendered = true;
    }
    $("#" + sourceTab.formID + "_D_YToolBar1").css({ "width": "100%" });
    $("#" + sourceTab.formID + "_D_YToolBar1_toolbar").css({ "width": "100%" });
    let form2 = ErpDesignerUI.D_FileTree, grid = form2.getComponent("Grid1");
    sessionStorage.removeItem("TabFileTree_ID");
    sessionStorage.setItem("TabFileTree_ID", grid.getId());
    LoadingUtil.show();
    let needOpen = true;
    for (let i = 0; i < filePaths.length; i++) {
      if (i != 0) {
        needOpen = false;
      }
      await CodeMirrorWorkSpace.XMLEditor.showXml(filePaths[i].filePath, filePaths[i].caption, formKey, needOpen, tabHeight);
    }
    if (filePaths.length > 1 && ((_a = ErpDesigner.getActiveOpenedXml()) == null ? void 0 : _a.filePath) !== filePaths[0].filePath) {
      await CodeMirrorWorkSpace.XMLEditor.showXml(filePaths[0].filePath, filePaths[0].caption, formKey, needOpen, tabHeight);
    }
    LoadingUtil.hide();
    let rowCount = grid.getRowCount(), $grid = grid.getEl();
    if (rowCount <= 0 || !$grid)
      return;
    let cellDataAt = grid.getCellDataAt(grid.getFocusRowIndex(), grid.getFocusColIndex() - 2);
    if (!cellDataAt || cellDataAt.value != filePaths[0].filePath) {
      await _ErpDesignerSrc2.doExpandByAuto(grid, filePaths[0].filePath);
    }
  }
  static getRowIndex(grid, treeNode) {
    let index = -1;
    for (let rowIndex = 0; rowIndex < grid.getRowCount(); rowIndex++) {
      let rowData = grid.getRowDataAt(rowIndex);
      if (!rowData) {
        continue;
      }
      if (rowData.data[1].value == treeNode) {
        index = rowIndex;
        break;
      }
    }
    return index;
  }
  static async doExpandByAuto(grid, filePath, expand) {
    var _a;
    let isAutoLocateFileTree = ((_a = ErpDesignerUI.preferences.getComponent("AutoLocateFileTree")) == null ? void 0 : _a.getValue()) === "true";
    if (isAutoLocateFileTree || expand) {
      let params = { cmd: "LoadParentPathsByPath", service: "DesignService", path: filePath };
      let parentPaths = await new Request().getData(params);
      await this.doExpand(grid, parentPaths);
    }
  }
  static async doExpand(grid, parentPaths) {
    grid.selection.focusCol = 3;
    for (let i = 0; i < parentPaths.length; i++) {
      LoadingUtil.show();
      let treeNode = parentPaths[i];
      let rowIndex = this.getRowIndex(grid, treeNode);
      if (rowIndex >= 0) {
        grid.selection.focusRow = rowIndex;
        await grid.showChildren(rowIndex, true);
        let row = grid.getRowDataAt(rowIndex);
        if (row && row.childRows && row.childRows.length) {
          console.log("@@@@@@@@@@@@@@@@@@当前展开:", row.data[3].caption, "childRows:", row.childRows.length);
        } else if (row) {
          console.log("@@@@@@@@@@@@@@@@@@当前展开:", row.data[3].caption, "childRows:", 0);
        }
      }
      LoadingUtil.hide();
    }
    grid.refreshGrid();
  }
  static closeNotEditedXml(formKey) {
    for (let [filePath, tmp] of _ErpDesignerSrc2.openedXmls) {
      if (tmp.component && !this.hasEdited(tmp)) {
        ErpDesignerUI.closeFilePath(filePath);
      }
    }
  }
  static async lineChanged(openedXml, line) {
    if (line <= 0) {
      return;
    }
    let editor = openedXml.xmlEditor, lineCount = editor.lineCount(), matchingLine = line, tag = CodeMirror.findMatchingTag(
      editor,
      { line: matchingLine }
      /*, range*/
    ), tagName = tag && tag.open ? tag.open.tag : void 0;
    if (tagName != null && !(tagName.toLowerCase() == "ToolBar".toLowerCase())) {
      while (tagName === void 0 || this.componentTags.indexOf(tagName) < 0 || line < tag.open.from.line) {
        matchingLine = tag && tag.close ? tag.close.to.line + 1 : matchingLine + 1;
        if (matchingLine >= lineCount) {
          break;
        }
        tag = CodeMirror.findMatchingTag(
          editor,
          { line: matchingLine }
          /*, range*/
        );
        tagName = tag && tag.open ? tag.open.tag : void 0;
      }
    }
    if (tag && this.componentTags.indexOf(tagName) >= 0) {
      let tmp = / Key\=\"(\w+)\"/.exec(editor.getLine(tag.open.from.line));
      if (tmp && tmp.length > 1) {
        ErpDesigner.selectedFormKey = openedXml.caption;
        ErpDesigner.selectedComponentKey = tmp[1];
        let getTypeByTagName = function(tagName2) {
          let result;
          if (tagName2 === "GridColumn") {
            result = "columnheader";
          } else if (tagName2 === "GridCell") {
            result = "cell";
          } else {
            result = tagName2;
          }
          return result;
        };
        ErpDesigner.selectedType = getTypeByTagName(tagName);
        ErpDesigner.selectedGridTrIndex = ErpDesigner.selectedGridTrIndex || 0;
        ErpDesigner.selectedComponentKeyInSource = ErpDesigner.selectedComponentKey;
        ErpDesigner.selectedTypeInSource = ErpDesigner.selectedType;
        ErpDesigner.selectComponentRun(void 0, true);
        await ErpDesignerUI.locate();
      }
    }
  }
  static async RebuildTable(filePath, key2, type) {
    await new Request().getData({
      cmd: "RebuildTable",
      service: "DesignService",
      filePath,
      key: key2,
      type
    });
  }
  static async reloadXmlSource(filePath, temPath) {
    let openXml = _ErpDesignerSrc2.openedXmls.get(filePath);
    if (openXml) {
      let fileContent = await ErpDesignerService.loadFileContent(filePath, true, temPath);
      openXml.isNew = fileContent.isNew;
      openXml.isEditBeforeLoad = fileContent.isEditBeforeLoad;
      let content = fileContent.content, xmlEditor = openXml.xmlEditor, showContent = content.replace(/\r\n/g, "\r");
      xmlEditor.setValue(showContent);
      xmlEditor.clearHistory();
      if (!ErpDesignerUI.designPanel) {
        return;
      }
      if (ErpDesignerUI.DesignActionForm.length == 0) {
        ErpDesignerUI.DesignActionForm[0] = ErpDesignerUI.designPanel.getComponent("DesignTab").form;
        ErpDesignerUI.DesignActionForm[1] = ErpDesignerUI.designPanel.getComponent("SourceTab").form;
      }
      await ErpDesigner.resetFormOperationStatus(ErpDesignerUI.DesignActionForm[0]);
      await ErpDesigner.resetFormOperationStatus(ErpDesignerUI.DesignActionForm[1]);
      await ErpDesigner.updateActiveXmlCaption(openXml);
    }
  }
  static async loadUsages(cm) {
    const cursor = cm.getCursor();
    const token = cm.getTokenAt(cursor);
    let line = cursor.line;
    let lineStr = cm.getLine(line);
    let key2 = "";
    let type = "";
    let isDefinition = false;
    const MACRO = "Macro", TABLE = "Table", DICT = "Dict", DOMAIN = "Domain", DATA_ELEMENT = "DataElement";
    if (token.type === "atom") {
      key2 = _ErpDesignerSrc2.getMethodAtIndex(token.string, cursor.ch - token.start);
      type = MACRO;
    } else {
      const tokens = cm.getLineTokens(cursor.line);
      const attrToken = tokens.filter((f) => f.end == token.start - 1);
      if (attrToken == void 0 || attrToken.length === 0) {
        return;
      }
      if (StringUtil$1.startsWith(lineStr.trim(), "<Table") && StringUtil$1.equalsIgnoreCase(attrToken[0].string, "Key") || StringUtil$1.equalsIgnoreCase(attrToken[0].string, "TableKey")) {
        key2 = token.string.replace(/"/g, "");
        isDefinition = !StringUtil$1.equalsIgnoreCase(attrToken[0].string, "TableKey");
        type = TABLE;
      } else if ((StringUtil$1.startsWith(lineStr.trim(), "<Form") || StringUtil$1.startsWith(lineStr.trim(), "<DataObject")) && StringUtil$1.equalsIgnoreCase(attrToken[0].string, "Key")) {
        let dicIndex = 0;
        for (let i = 0; i < tokens.length; i++) {
          if (tokens[i].string === "FormType" || tokens[i].string === "SecondaryType") {
            dicIndex = i + 2;
          }
        }
        if (dicIndex !== 0 && tokens[dicIndex].string === '"Dict"') {
          key2 = token.string.replace(/"/g, "");
          type = DICT;
          isDefinition = true;
        }
      } else if ((StringUtil$1.startsWith(lineStr.trim(), "<Dict") || StringUtil$1.startsWith(lineStr.trim(), "<GridCell") || StringUtil$1.startsWith(lineStr.trim(), "<Format") || StringUtil$1.startsWith(lineStr.trim(), "<Column") || StringUtil$1.startsWith(lineStr.trim(), "<ItemFilter")) && StringUtil$1.equalsIgnoreCase(attrToken[0].string, "ItemKey")) {
        key2 = token.string.replace(/"/g, "");
        type = DICT;
      } else if (attrToken[0].string === "Visible" || attrToken[0].string === "Visible" || attrToken[0].string === "Enable" || attrToken[0].string === "IntegerValue" || attrToken[0].string === "BorderColor" || attrToken[0].string === "FormulaCaption" || attrToken[0].string === "DefaultFormulaValue" || attrToken[0].string === "CheckRule" || attrToken[0].string === "ValueChanging" || attrToken[0].string === "ValueChanged" || attrToken[0].string === "ErrorInfo") {
        key2 = _ErpDesignerSrc2.getMethodAtIndex(token.string.replace(/"/g, ""), cursor.ch - token.start);
        type = MACRO;
      } else if (StringUtil$1.startsWith(lineStr.trim(), "<Macro") && StringUtil$1.equalsIgnoreCase(attrToken[0].string, "Key")) {
        key2 = token.string.replace(/"/g, "");
        type = MACRO;
        isDefinition = true;
      } else if (StringUtil$1.startsWith(lineStr.trim(), "<DataElement") && StringUtil$1.equalsIgnoreCase(attrToken[0].string, "Key") || StringUtil$1.equalsIgnoreCase(attrToken[0].string, "DataElementKey")) {
        key2 = token.string.replace(/"/g, "");
        isDefinition = !StringUtil$1.equalsIgnoreCase(attrToken[0].string, "DataElementKey");
        type = DATA_ELEMENT;
      } else if (StringUtil$1.startsWith(lineStr.trim(), "<Domain") && StringUtil$1.equalsIgnoreCase(attrToken[0].string, "Key") || StringUtil$1.equalsIgnoreCase(attrToken[0].string, "DomainKey")) {
        key2 = token.string.replace(/"/g, "");
        isDefinition = !StringUtil$1.equalsIgnoreCase(attrToken[0].string, "DomainKey");
        type = DOMAIN;
      }
    }
    if (key2 && type) {
      let ranges = cm.listSelections(), range;
      if (ranges.length > 1) {
        range = ranges.filter((f) => f.anchor.line === cursor.line && f.anchor.ch === cursor.ch);
        if (range && range.length > 0) {
          cm.setSelection(range[0].from(), range[0].to());
        }
      }
      await _ErpDesignerSrc2.showPopup(cm, key2, type, isDefinition);
      if (this.mark) {
        this.mark.clear();
        this.mark = null;
      }
      let start, end;
      if (lineStr.indexOf(key2) === lineStr.lastIndexOf(key2)) {
        start = lineStr.indexOf(key2);
        end = lineStr.indexOf(key2) + key2.length;
      } else if ("Macro" === type && lineStr.indexOf(key2) !== lineStr.lastIndexOf(key2)) {
        let pos = 0;
        start = -1;
        while ((pos = lineStr.indexOf(key2, pos)) !== -1) {
          if (pos > cursor.ch) {
            break;
          }
          start = pos;
          pos += key2.length;
        }
        end = start + key2.length;
      } else {
        start = token.start;
        end = token.end;
      }
      this.mark = cm.markText({ line, ch: start }, {
        line,
        ch: end
      }, {
        className: "cm-overlay cm-searching"
      });
    }
  }
  // 显示弹出框的函数
  static async showPopup(editor, key2, type, isDefinition) {
    let openXml = ErpDesigner.getActiveOpenedXml();
    if (!key2 || !openXml) {
      return;
    }
    let filePath = openXml.filePath;
    let datas = {};
    let cur = editor.getCursor();
    let ch = cur.ch;
    let line = cur.line;
    let showList = [];
    let showList2 = [];
    let detailedInfo = [];
    let params = {
      filePath,
      line,
      column: ch,
      type,
      key: key2
    };
    let r = new Request();
    let interfaceName = !isDefinition ? "definition" : "references";
    r.addHeader("content-type", "application/json");
    let res = await r.getData(params, ErpDesigner.url + "textDocument/" + interfaceName);
    if (!(!!res.filePath || res.length > 0)) {
      return;
    }
    let infoMap = /* @__PURE__ */ new Map();
    if (!res.length || res.length === 1) {
      let target = !res.length ? res : res[0];
      let targetFilePath = target.filePath;
      let fileName = this.getFileNameByPath(targetFilePath);
      await this.jumpToTarget(key2, target.line + "", target.column + "", targetFilePath, fileName, type);
      return;
    }
    for (let i = 0; i < res.length; i++) {
      let showListItem;
      let detailedInfoItem;
      let targetFilePath = res[i].filePath;
      let fileName = this.getFileNameByPath(targetFilePath);
      let dataType = isDefinition ? "ref" : "def";
      let formKey = fileName.replace(".xml", "");
      let keyAndCaption = !res[i].fileCaption ? "" : "{n}表单key&caption:{n}" + formKey + " " + res[i].fileCaption;
      showList2.push(i);
      showListItem = fileName + " row:" + res[i].line + " col:" + res[i].column + " " + dataType;
      detailedInfoItem = "代码片段:{n}" + res[i].snapshot + keyAndCaption + "{n}位置:{n}" + res[i].line + "行" + res[i].column + "列{n}文件路径:{n}" + targetFilePath;
      infoMap.set(showListItem, targetFilePath + "@" + res[i].line + "@" + res[i].column + "@" + fileName);
      showList.push(showListItem);
      detailedInfo.push(detailedInfoItem);
    }
    datas.list = showList;
    datas.showList = showList2;
    datas.key = showList[0];
    datas.from = {};
    datas.from.line = line;
    datas.currentInputChar = "";
    datas.from.ch = ch - 1;
    datas.to = {};
    datas.to.line = line;
    datas.to.ch = ch;
    datas.yigoFrontFnsExplainData = detailedInfo;
    editor.showHint1({ completeSingle: false, completeOnSingleClick: false, ignorePick: true }, datas);
    document.querySelectorAll("li.CodeMirror-hint").forEach((item) => {
      item.addEventListener("dblclick", async () => {
        let content = item.textContent;
        if (!content)
          return;
        console.log("双击点击了：" + item.textContent);
        let info = infoMap.get(content);
        if (!info)
          return;
        let infos = info.split("@");
        if (infos.length !== 4)
          return;
        await this.jumpToTarget(key2, infos[1], infos[2], infos[0], infos[3], type);
      });
    });
  }
  static getMethodAtIndex(methodsString, index, splitKey) {
    const methods = splitKey ? methodsString.split(splitKey) : methodsString.split(/[,;]|(?:&&|\|\|)/);
    let currentLength = 0;
    let currentMethod = "";
    let result = "";
    for (let i = 0; i < methods.length; i++) {
      currentMethod = methods[i];
      if (currentLength + currentMethod.length >= index) {
        if (index === currentLength + currentMethod.length) {
          result = i > 0 ? methods[i - 1] : "";
          break;
        } else {
          result = currentMethod;
          break;
        }
      }
      currentLength += currentMethod.length + 1;
    }
    if (result.indexOf("(") === -1) {
      result = "";
    }
    if (result.substring(0, result.lastIndexOf("(")).indexOf("(") && !splitKey) {
      let pos = 0, startIndex = -1;
      while ((pos = result.indexOf("(", pos)) !== -1 && (pos = result.indexOf("(", pos)) < index - currentLength) {
        startIndex = pos;
        pos += 1;
      }
      result = result.substring(startIndex + 1);
    }
    result = result.replace("<![CDATA[", "");
    result = result.replace("]]>", "");
    result = result.trim();
    result = result.substring(result.indexOf("Macro_"));
    result = result.substring(0, result.indexOf("("));
    result = result.substring(result.lastIndexOf(".") + 1);
    result = result.substring(result.lastIndexOf("{") + 1);
    if (!result && !splitKey) {
      result = _ErpDesignerSrc2.getMethodAtIndex(methodsString, index, ";");
    }
    if (result.startsWith("!")) {
      result = result.substring(1);
    }
    if (result.indexOf(",") > -1) {
      return "";
    }
    return result;
  }
  static async jumpToTarget(key2, row, col, filePath, fileName, type) {
    let formKey = fileName.replace(".xml", "");
    let caption = filePath.substring(filePath.indexOf("solutions") + "solutions".length + 1);
    await CodeMirrorWorkSpace.XMLEditor.showXml(filePath, caption, formKey, true);
    let openedXML = _ErpDesignerSrc2.openedXmls.get(filePath);
    if (openedXML) {
      setTimeout(() => {
        let jumpToQuote = {
          line: parseInt(row) - 1,
          ch: parseInt(col) - 1
        };
        let xmlEditor = openedXML.xmlEditor;
        xmlEditor.setCursor(jumpToQuote);
        let lineStr = xmlEditor.getLine(jumpToQuote.line);
        let start, end;
        if (type === "Macro" || lineStr.indexOf(key2) === lineStr.lastIndexOf(key2)) {
          start = lineStr.indexOf(key2);
          end = lineStr.indexOf(key2) + key2.length;
        } else {
          let cursor = xmlEditor.getCursor();
          let token = xmlEditor.getTokenAt(cursor);
          start = token.start;
          end = start + key2.length;
        }
        this.mark = xmlEditor.markText({
          line: jumpToQuote.line,
          ch: start
        }, { line: jumpToQuote.line, ch: end }, {
          className: "cm-overlay cm-searching"
        });
      }, 200);
    }
    if (this.mark) {
      this.mark.clear();
      this.mark = null;
    }
  }
  static getFileNameByPath(filePath) {
    if (!filePath) {
      return "";
    }
    let lastIndex = filePath.lastIndexOf("/");
    if (lastIndex === -1) {
      lastIndex = filePath.lastIndexOf("\\");
    }
    return filePath.slice(lastIndex + 1);
  }
};
_ErpDesignerSrc.formDependXMLs = /* @__PURE__ */ new Map();
_ErpDesignerSrc.openedXmls = /* @__PURE__ */ new Map();
_ErpDesignerSrc.xmlEditorIndex = 0;
_ErpDesignerSrc.componentTags = [
  "ToolBar",
  "Operation",
  "OperationCollection",
  "FlexFlowLayoutPanel",
  "SplitPanel",
  "TabPanel",
  "GridLayoutPanel",
  "Embed",
  "SubDetail",
  "FlowLayoutPanel",
  "ColumnLayoutPanel",
  "Grid",
  "GridColumn",
  "GridCell",
  "GridRow",
  "Label",
  "RichEditor",
  "TimePicker",
  "MonthPicker",
  "PasswordEditor",
  "Image",
  "Separator",
  "TextEditor",
  "UTCDatePicker",
  "Dict",
  "NumberEditor",
  "ComboBox",
  "Button",
  "TextButton",
  "CheckBox",
  "BorderLayoutPanel",
  "RadioButton",
  "DatePicker",
  "TextArea",
  "CheckListBox",
  "DynamicDict",
  "ListView",
  "ListViewColumn",
  "DropdownButton"
];
_ErpDesignerSrc.mark = null;
let ErpDesignerSrc = _ErpDesignerSrc;
class DesignerForm extends FormExt {
  constructor(metaForm, appEnv) {
    super(metaForm, appEnv);
    if (metaForm.formID) {
      FormStack.removeForm(this.formID);
      this.formID = metaForm.formID;
      this.appEnv = appEnv;
      this.metaForm = metaForm;
      this.initParams(metaForm);
      this.setOperationState(metaForm.initState);
      this.formUUID = this.genFormUUID();
    }
  }
}
class DesignerFormFactory {
  static create(metaForm, appEnv, formID) {
    metaForm.formID = formID;
    return new DesignerForm(metaForm, appEnv);
  }
}
class IndexedDBCache {
  constructor(tableName) {
    this.tableName = tableName;
  }
  async get(key2) {
    var data = await ErpDesigner.indexedDB.get(this.tableName, key2);
    if (data) {
      return data.value;
    } else {
      return null;
    }
  }
  async clear() {
    await ErpDesigner.indexedDB.clear(this.tableName);
  }
  put(key2, value2) {
    let o = { key: key2, value: value2 };
    ErpDesigner.indexedDB.put(this.tableName, o);
  }
}
class TempCache {
  constructor(size) {
    this.cache = new LRUCache(size);
  }
  get(key2) {
    return $.Deferred((def) => {
      def.resolve(this.cache.get(key2));
    }).promise();
  }
  put(key2, value2) {
    this.cache.set(key2, value2);
  }
}
const _ErpDesignerUtil = class _ErpDesignerUtil2 {
  // 从后台获取关键字
  static async getKeyWordsFromBackend() {
    var yigoFnKw = await _ErpDesignerUtil2.getDesignerTableCacheByTableName("DesignerFormulaCache")().get("yigoFnKw");
    if (!yigoFnKw) {
      let params = {
        cmd: "ExpAutoComplete",
        service: "DesignService",
        dataType: "initKeyWords",
        currentFormKey: ""
      };
      let result = await new Request().getData(params);
      if (!result) {
        console.log("请求后台函数提醒功能失败");
        return;
      }
      let rs = $.parseJSON(result);
      if (rs) {
        if (rs.errors) {
          console.log(rs.errors);
          return;
        }
        if (rs.keyWords && rs.keyWords.length > 0) {
          yigoFnKw = rs.keyWords[0];
        }
      } else {
        console.log("rs为：" + rs);
      }
      _ErpDesignerUtil2.getDesignerTableCacheByTableName("DesignerFormulaCache")().put("yigoFnKw", yigoFnKw);
    }
    return yigoFnKw;
  }
  static getControlTypeStr(controlType) {
    let type = parseInt(controlType);
    switch (type) {
      case ControlType.FLEXFLOWLAYOUTPANEL:
        return "FlexFlowLayoutPanel";
      case ControlType.SPLITPANEL:
        return "SplitPanel";
      case ControlType.TABPANEL:
        return "TabPanel";
      case ControlType.GRIDLAYOUTPANEL:
        return "GridLayoutPanel";
      case ControlType.GRID:
        return "Grid";
      case ControlType.SUBDETAIL:
        return "SubDetail";
      case ControlType.CHECKBOX:
        return "CheckBox";
      case ControlType.COMBOBOX:
        return "ComboBox";
      case ControlType.DATEPICKER:
        return "DatePicker";
      case ControlType.DICT:
        return "Dict";
      case ControlType.HYPERLINK:
        return "HyperLink";
      case ControlType.LABEL:
        return "Label";
      case ControlType.NUMBEREDITOR:
        return "NumberEditor";
      case ControlType.RADIOBUTTON:
        return "RadioButton";
      case ControlType.TEXTBUTTON:
        return "TextButton";
      case ControlType.TEXTEDITOR:
        return "TextEditor";
      case ControlType.BUTTON:
        return "Button";
      case ControlType.TEXTAREA:
        return "TextArea";
      case ControlType.UTCDATEPICKER:
        return "UTCDatePicker";
      case ControlType.CHECKLISTBOX:
        return "CheckListBox";
      case ControlType.DYNAMICDICT:
        return "DynamicDict";
      case ControlType.RICHEDITOR:
        return "RichEditor";
      case ControlType.TIMEPICKER:
        return "TimePicker";
      case ControlType.MONTHPICKER:
        return "MonthPicker";
      case ControlType.PASSWORDEDITOR:
        return "PasswordEditor";
      case ControlType.SEPARATOR:
        return "Separator";
      case ControlType.IMAGE:
        return "Image";
      case ControlType.BORDERLAYOUTPANEL:
        return "BorderLayoutPanel";
      case ControlType.COLUMNLAYOUTPANEL:
        return "ColumnLayoutPanel";
      case ControlType.CUSTOMLAYOUTPANEL:
        return "CustomLayoutPanel";
      case ControlType.FLOWLAYOUTPANEL:
        return "FlowLayoutPanel";
      case ControlType.FLUIDTABLELAYOUTPANEL:
        return "FluidTabLayoutPanel";
      case ControlType.LISTVIEW:
        return "ListView";
      case ControlType.DROPDOWNBUTTON:
        return "DropdownButton";
      case ControlType.TOOLBAR:
        return "ToolBar";
      case ControlType.EMBED:
        return "Embed";
      case ControlType.FLEXGRIDLAYOUTPANEL:
        return "FlexGridLayoutPanel";
      case ControlType.CHART:
        return "Chart";
      case ControlType.TABLEVIEW:
        return "TableView";
      case ControlType.COLLECTIONVIEW:
        return "CollectionView";
      case ControlType.CONTAINER:
        return "Container";
      case ControlType.TABGROUP:
        return "TabGroup";
      case ControlType.SWITCH:
        return "Switch";
      case ControlType.LINEARLAYOUTPANLE:
        return "LinearLayoutPanel";
      case ControlType.EDITVIEW:
        return "EditView";
      case ControlType.CAROUSEL:
        return "Carousel";
      case ControlType.HOVERBUTTON:
        return "HoverButton";
      case ControlType.GIFIMAGE:
        return "GIFImage";
      case ControlType.VIDEOPLAYER:
        return "VideoPlayer";
      case ControlType.BARCODER:
        return "BarCoder";
      case ControlType.SCOREBAR:
        return "ScoreBar";
      case ControlType.NOTICEBAR:
        return "NoticeBar";
      case ControlType.PRICELABEL:
        return "PriceLabel";
      case ControlType.RELATIVETIME:
        return "RelativeTime";
      case ControlType.COLLAPSEPANEL:
        return "CollapsePanel";
      case ControlType.SLIDINGLAYOUTPANEL:
        return "SlidingLayoutPanel";
      case ControlType.REFRESHCONTROL:
        return "RefreshControl";
      case ControlType.WEBBROWSER:
        return "WebBrowser";
      default:
        return "未知类型,请再js中添加类型";
    }
  }
  static clearMetaForm(formKey, templateKey) {
    let docKey = this.appKey + "_" + formKey;
    let key2 = this.appKey + "_getMetaForm_" + formKey + "_" + (templateKey || "");
    ErpDesignerGlobal.doccache.put(docKey, null);
    ErpDesignerGlobal.cache.put(key2, null);
  }
  static layoutDesignDock() {
    if (!ErpDesignerUI.split)
      return;
    let body = $(document.body);
    let activeForm = ErpDesignerUI.getActiveERPForm();
    if (activeForm && (activeForm.dataObjectKey === "D_WEB" || activeForm.formKey == "MobileFormDesigner" || activeForm.metaForm.platform == 6 || activeForm.metaForm.extensionFormKey != null)) {
      if (ErpDesignerUI.split.items[1].tagName.toLowerCase() === "panel") {
        ErpDesignerUI.split.splitSizes[0].size = 2;
        ErpDesignerUI.split.splitSizes[0].oldSize = 2;
        ErpDesignerUI.split.splitSizes[1].size = body.width() - 7;
        ErpDesignerUI.split.splitSizes[1].oldSize = body.width() - 7;
      } else {
        ErpDesignerUI.split.splitSizes[1].size = 2;
        ErpDesignerUI.split.splitSizes[1].oldSize = 2;
        ErpDesignerUI.split.splitSizes[0].size = body.width() - 7;
        ErpDesignerUI.split.splitSizes[0].oldSize = body.width() - 7;
      }
      ErpDesignerUI.split.doDesigerLayout(body.width(), body.height());
    } else if (!(ErpDesignerUI.split.splitSizes[0].size.toString().endsWith("px") || ErpDesignerUI.split.splitSizes[0].size.toString().endsWith("px"))) {
      if (ErpDesignerUI.split.items[1].tagName.toLowerCase() === "panel") {
        ErpDesignerUI.split.splitSizes[0].size = "30%";
        ErpDesignerUI.split.splitSizes[0].oldSize = "30%";
        ErpDesignerUI.split.splitSizes[1].size = "70%";
        ErpDesignerUI.split.splitSizes[1].oldSize = "70%";
      } else {
        ErpDesignerUI.split.splitSizes[1].size = "30%";
        ErpDesignerUI.split.splitSizes[1].oldSize = "30%";
        ErpDesignerUI.split.splitSizes[0].size = "70%";
        ErpDesignerUI.split.splitSizes[0].oldSize = "70%";
      }
      ErpDesignerUI.split.doDesigerLayout(body.width(), body.height());
    }
  }
  static async initDesignElements(activeForm) {
    let formKey = activeForm.getFormKey();
    if (formKey !== "D_WebMap" && activeForm.dataObjectKey !== "D_WEB") {
      if (formKey == "MobileFormDesigner") {
        await ErpDesignerSrc.showXmlByFormKey(activeForm.entryPath, null);
        let fileFormFrame = activeForm.impl.el.getElm().querySelectorAll("iframe")[0];
        if (fileFormFrame)
          fileFormFrame.contentWindow.postMessage("activeFormChanged");
      } else {
        await ErpDesignerSrc.showXmlByFormKey(formKey, activeForm.paras.map.FormKey);
      }
      ErpDesignerUI.activeERPFormKey = formKey;
      await ErpDesigner.reloadComponentTreeByFormKey(formKey);
      ErpDesigner.selectComponentRun();
      ErpDesigner.hideSelectedBorder();
      return;
    }
    let form2 = ErpDesignerUI.D_FileTree, grid = form2.getComponent("Grid1");
    form2.getCellLocation("Key").column;
    if (!grid.getEl()) {
      $(".ui-anchor-label[title='文件树']").mousedown().mouseup().click();
      ErpDesignerUI.D_FileTree.rendered = true;
    }
    let tabPanel = ErpDesignerUI.designPanel.getComponent("TabPanel1"), tab = tabPanel.get("SourceTab");
    tab.needRender = true;
    tab.render();
    tabPanel.doLayout(tabPanel.getWidth(), tabPanel.getHeight());
    $("#" + tab.formID + "_D_YToolBar1").css({ "width": "100%" });
    $("#" + tab.formID + "_D_YToolBar1_toolbar").css({ "width": "100%" });
    sessionStorage.removeItem("TabFileTree_ID");
    sessionStorage.setItem("TabFileTree_ID", grid.getId());
    LoadingUtil.show();
    await CodeMirrorWorkSpace.XMLEditor.showXml(activeForm.WebMapPath, activeForm.WebMapCaption, activeForm.WebMapFormKey, true);
    LoadingUtil.hide();
    if (grid.getRowCount() <= 0 || !grid.getEl())
      return;
    await ErpDesignerSrc.doExpandByAuto(grid, activeForm.WebMapPath);
    await grid.getForm().getUIProcess().resetComponentStatus(grid);
  }
  static async treeClick(grid, ri, vspan, batch) {
    if (vspan == null || vspan.hasClass("cell-collapse")) {
      return grid.showChildren(ri, batch);
    } else {
      return grid.hideChildren(ri);
    }
  }
  static getColumnType(columnType) {
    let type = parseInt(columnType);
    switch (type) {
      case 1:
        return "Group";
      case 2:
        return "Detail";
      case 3:
        return "Total";
      case 4:
        return "TreeRow";
      case 0:
        return "Fix";
    }
  }
  //lijun 此处可能存在问题
  static getDesignerTableCacheByTableName(tableName) {
    let table = ErpDesigner.DesignerTableCaches.get(tableName);
    if (table != null) {
      return table;
    }
    table = function() {
      return {
        get: function(key2) {
          return this.getCache().get(key2);
        },
        put: function(key2, doc) {
          return this.getCache().put(key2, doc);
        },
        clear: function() {
          return this.getCache().clear();
        },
        getCache: function() {
          if (this.cache) {
            return this.cache;
          }
          if (ErpDesigner.indexedDB && ErpDesigner.indexedDB.isOpen()) {
            this.cache = new IndexedDBCache(tableName);
          } else {
            this.cache = new TempCache(30);
          }
          return this.cache;
        }
      };
    };
    ErpDesigner.DesignerTableCaches.put(tableName, table);
    return table;
  }
  static async checkUniqueCompKey(formKey, compKey, gridCellFlag) {
    let uniqueFlag = true;
    let params = new ServiceParams();
    params.formKey = formKey;
    params.columnKey = compKey;
    if (gridCellFlag)
      params.type = "MetaGridCell";
    let r = new Request();
    r.addHeader("content-type", "application/json");
    let res = await r.getData(params, ErpDesigner.url + "DesignerController/checkComponent");
    if (res.msg !== "false") {
      ErpDesignerUI.showTip("Key重复创建失败", "error");
      uniqueFlag = false;
    }
    return uniqueFlag;
  }
  static addBorderAndButton(oldSelectedType, buttonLeft, topOffset, isReport, $component, componentleft_left) {
    if (oldSelectedType) {
      var type = oldSelectedType.toLowerCase();
      switch (type) {
        case "grid":
        case "listview":
        case "subsetail":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft - 20 + "px").css("top", topOffset + 3 + "px");
          ErpDesignerGlobal.insertEmbed.css("left", buttonLeft - 20 + "px").css("top", topOffset + 33 + "px");
          ErpDesignerGlobal.buttonReplace.css("left", buttonLeft - 20 + "px").css("top", topOffset + 63 + "px");
          ErpDesignerGlobal.buttonInsert.css("left", buttonLeft - 20 + "px").css("top", topOffset + 93 + "px");
          ErpDesignerGlobal.compositeComponentInsert.css("left", buttonLeft - 20 + "px").css("top", topOffset + 123 + "px");
          if (isReport) {
            ErpDesignerGlobal.addSelectComponent.css("left", buttonLeft - 20 + "px").css("top", topOffset + 153 + "px");
          }
          break;
        case "tableview":
        case "collectionview":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          ErpDesignerGlobal.buttonaddTableRow.css("left", buttonLeft + "px").css("top", topOffset + 33 + "px");
          ErpDesignerGlobal.insertEmbed.css("left", buttonLeft + "px").css("top", topOffset + 63 + "px");
          break;
        case "tablerow":
        case "tableviewrow":
        case "tableviewdetailrow":
        case "collectionviewrow":
          ErpDesignerGlobal.buttonDeleteTableRow.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "panelindetailrow":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft - 20 + "px").css("top", topOffset + 3 + "px");
          ErpDesignerGlobal.buttonInsert.css("left", buttonLeft - 20 + "px").css("top", topOffset + 33 + "px");
          ErpDesignerGlobal.insertEmbed.css("left", buttonLeft - 20 + "px").css("top", topOffset + 63 + "px");
          break;
        case "flexgridlayoutpanel":
        case "gridlayoutpanel":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft - 20 + "px").css("top", topOffset + 3 + "px");
          ErpDesignerGlobal.insertEmbed.css("left", buttonLeft - 20 + "px").css("top", topOffset + 33 + "px");
          ErpDesignerGlobal.buttonReplace.css("left", buttonLeft - 20 + "px").css("top", topOffset + 63 + "px");
          ErpDesignerGlobal.buttonInsert.css("left", buttonLeft - 20 + "px").css("top", topOffset + 93 + "px");
          ErpDesignerGlobal.compositeComponentInsert.css("left", buttonLeft - 20 + "px").css("top", topOffset + 123 + "px");
          break;
        case "flexflowlayoutpanel":
        case "linearlayoutpanel":
        case "slidinglayoutpanel":
        case "splitpanel":
        case "tabpanel":
        case "flowlayoutpanel":
        case "chart":
        case "columnlayoutpanel":
        case "embed":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft - 20 + "px").css("top", topOffset + 3 + "px");
          ErpDesignerGlobal.insertEmbed.css("left", buttonLeft - 20 + "px").css("top", topOffset + 33 + "px");
          ErpDesignerGlobal.buttonReplace.css("left", buttonLeft - 20 + "px").css("top", topOffset + 63 + "px");
          ErpDesignerGlobal.buttonInsert.css("left", buttonLeft - 20 + "px").css("top", topOffset + 91 + "px");
          break;
        case "reseau":
          if ($component.prop("outerHTML").indexOf("gridcell") == -1) {
            ErpDesignerGlobal.buttonInsert.css("left", buttonLeft + "px").css("top", topOffset + 3 - 28 + "px");
            ErpDesignerGlobal.compositeComponentInsert.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
            ErpDesignerGlobal.buttonaddPanelRow.css("left", buttonLeft + "px").css("top", topOffset + 3 + 28 + "px");
          }
          break;
        case "toolbar":
        case "operationcollection":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "operation":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "columnheader":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          ErpDesignerGlobal.buttonInsertBefore.css("left", buttonLeft + "px").css("top", topOffset + 3 + 35 + "px");
          ErpDesignerGlobal.buttonInsertAfter.css("left", buttonLeft + "px").css("top", topOffset + 3 + 70 + "px");
          ErpDesignerGlobal.compositeComInsertToGrid.css("left", buttonLeft + "px").css("top", topOffset + 3 - 35 + "px");
          ErpDesignerGlobal.buttonSonRow.css("left", buttonLeft + "px").css("top", topOffset + 3 - 70 + "px");
          break;
        case "listview_columnheader":
        case "listviewcolumn":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          ErpDesignerGlobal.buttonInsertBefore1.css("left", buttonLeft + "px").css("top", topOffset + 3 + 35 + "px");
          ErpDesignerGlobal.buttonInsertAfter1.css("left", buttonLeft + "px").css("top", topOffset + 3 + 70 + "px");
          break;
        case "gridrow":
          ErpDesignerGlobal.buttonNewRow.css("left", componentleft_left + 60 + "px").css("top", topOffset + 3 + "px");
          ErpDesignerGlobal.buttonDeleteRow.css("left", componentleft_left + 60 + "px").css("top", topOffset + 38 + "px");
          break;
        case "richeditor":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft - 20 + "px").css("top", topOffset + 3 + "px");
          ErpDesignerGlobal.insertEmbed.css("left", buttonLeft - 20 + "px").css("top", topOffset + 33 + "px");
          break;
        case "fieldindetailrow":
        case "texteditor":
        case "dict":
        case "numbereditor":
        case "combobox":
        case "datepicker":
        case "utcdatepicker":
        case "button":
        case "checkbox":
        case "textarea":
        case "textbutton":
        case "label":
        case "checklistbox":
        case "dynamicdict":
        case "timepicker":
        case "monthpicker":
        case "passwordeditor":
        case "separator":
        case "image":
        case "radiobutton":
        case "hyperlink":
        case "dropdownbutton":
        case "switch":
        case "container":
        case "carousel":
        case "gifimage":
        case "videoplayer":
        case "barcoder":
        case "scorebar":
        case "relativetime":
        case "pricelabel":
        case "noticebar":
          if (ErpDesignerUI.getActiveERPForm().getComponent(ErpDesignerUI.parentKey) && ErpDesignerUI.getActiveERPForm().getComponent(ErpDesignerUI.parentKey).tagName.toLowerCase() === "flexgridlayoutpanel") {
            ErpDesignerGlobal.buttonInsertBefore2.css("left", buttonLeft + "px").css("top", topOffset + 3 - 34 + "px");
            ErpDesignerGlobal.buttonInsertAfter2.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
            ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 33 + "px");
          } else {
            ErpDesignerGlobal.buttonInsert.css("left", buttonLeft + "px").css("top", topOffset + 3 - 50 + "px");
            ErpDesignerGlobal.compositeComponentInsert.css("left", buttonLeft + "px").css("top", topOffset + 3 - 17 + "px");
            ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + 16 + "px");
            ErpDesignerGlobal.buttonaddPanelRow.css("left", buttonLeft + "px").css("top", topOffset + 3 + 49 + "px");
          }
          break;
        case "tabgroup":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "tabitem":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 - 60 + "px");
          ErpDesignerGlobal.buttonInsertTabItem.css("left", buttonLeft + "px").css("top", topOffset + 3 - 30 + "px");
          ErpDesignerGlobal.buttonMoveTabItemAfter.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          ErpDesignerGlobal.buttonMoveTabItemFront.css("left", buttonLeft + "px").css("top", topOffset + 3 + 30 + "px");
          break;
        case "editview":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "editviewcolumn":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "editviewgridlayoutemptyspan":
          ErpDesignerGlobal.buttonInsert.css("left", buttonLeft + "px").css("top", topOffset + 3 - 28 + "px");
          ErpDesignerGlobal.buttonaddPanelRow.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "editviewrootlinearlayout":
          ErpDesignerGlobal.buttonInsert.css("left", buttonLeft + "px").css("top", topOffset + 3 - 28 + "px");
          break;
        case "editviewchildlinearlayout":
          ErpDesignerGlobal.buttonInsert.css("left", buttonLeft + "px").css("top", topOffset + 3 - 28 + "px");
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "editviewchildgirdlayout":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "editviewchildflexflowlayout":
          ErpDesignerGlobal.buttonInsert.css("left", buttonLeft + "px").css("top", topOffset + 3 - 28 + "px");
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "editviewchildcolumnlayout":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "editviewchildsplitlayout":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "editviewchildtablayout":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "editviewchildflowlayout":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "editviewchildflexgridlayout":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "editviewchildlayout":
          ErpDesignerGlobal.buttonInsert.css("left", buttonLeft + "px").css("top", topOffset + 3 - 28 + "px");
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
        case "block":
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          break;
      }
    }
  }
  static async closeForm(form2) {
    let originalValue = form2.isOKClose;
    form2.isOKClose = "OK";
    await form2.fireClose();
    form2.isOKClose = originalValue;
  }
};
_ErpDesignerUtil.addBorderAndButtonByVest = function(selectedType, mergeToSource, $component, vestHideFlag, leftOffset, topOffset, width, height, buttonLeft) {
  if (mergeToSource) {
    _ErpDesignerUtil.addBorderAndButton(selectedType, buttonLeft, topOffset, false, $component, leftOffset);
    switch (selectedType && selectedType.toLowerCase()) {
      case "grid":
      case "listview":
      case "subsetail":
        break;
      case "tableview":
        ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
        ErpDesignerGlobal.buttonaddTableRow.css("left", buttonLeft + "px").css("top", topOffset + 33 + "px");
        ErpDesignerGlobal.insertEmbed.css("left", buttonLeft + "px").css("top", topOffset + 63 + "px");
        break;
      case "flexflowlayoutpanel":
      case "linearlayoutpanel":
      case "splitpanel":
      case "tabpanel":
      case "flowlayoutpanel":
      case "chart":
      case "columnlayoutpanel":
      case "embed":
      case "gridlayoutpanel":
      case "flexgridlayoutpanel":
        ErpDesignerGlobal.buttonDelete.css("left", buttonLeft - 20 + "px").css("top", topOffset + 3 + "px");
        ErpDesignerGlobal.insertEmbed.css("left", buttonLeft - 20 + "px").css("top", topOffset + 33 + "px");
        ErpDesignerGlobal.buttonReplace.css("left", buttonLeft - 20 + "px").css("top", topOffset + 63 + "px");
        ErpDesignerGlobal.compositeComponentInsert.css("left", buttonLeft - 20 + "px").css("top", topOffset + 123 + "px");
        ErpDesignerGlobal.buttonPanQuote.css("left", buttonLeft - 20 + "px").css("top", topOffset + 153 + "px");
        break;
      case "reseau":
        if ($component.prop("outerHTML").indexOf("gridcell") < 0) {
          ErpDesignerGlobal.buttonQuote.css("left", buttonLeft + "px").css("top", topOffset + 3 - 50 + "px");
        }
        break;
      case "toolbar":
      case "operationcollection":
        break;
      case "operation":
        break;
      case "columnheader":
        ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", "-1000px");
        if (!vestHideFlag) {
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
        }
        ErpDesignerGlobal.buttonSonRow.css("left", buttonLeft + "px").css("top", "-1000px");
        break;
      case "listview_columnheader":
      case "listviewcolumn":
        ErpDesignerGlobal.buttonInsertBefore1.css("left", buttonLeft + "px").css("top", "-1000px");
        ErpDesignerGlobal.buttonInsertAfter1.css("left", buttonLeft + "px").css("top", "-1000px");
        break;
      case "cell":
      case "gridfield":
      case "gridrow":
        break;
      case "fieldindetailrow":
      case "texteditor":
      case "dict":
      case "numbereditor":
      case "combobox":
      case "datepicker":
      case "utcdatepicker":
      case "button":
      case "checkbox":
      case "textarea":
      case "textbutton":
      case "label":
      case "checklistbox":
      case "dynamicdict":
      case "richeditor":
      case "timepicker":
      case "monthpicker":
      case "passwordeditor":
      case "separator":
      case "image":
      case "radiobutton":
      case "hyperlink":
      case "dropdownbutton":
      case "switch":
      case "container":
      case "carousel":
      case "gifimage":
      case "videoplayer":
      case "barcoder":
        ErpDesignerGlobal.buttonQuote.css("left", buttonLeft + "px").css("top", topOffset + 3 - 50 - 33 + "px");
        break;
    }
  } else {
    switch (selectedType && selectedType.toLowerCase()) {
      case "grid":
      case "listview":
      case "subsetail":
        ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
        ErpDesignerGlobal.insertEmbed.css("left", buttonLeft - 20 + "px").css("top", "-1000px");
        break;
      case "tableview":
        ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
        ErpDesignerGlobal.buttonaddTableRow.css("left", buttonLeft + "px").css("top", topOffset + 33 + "px");
        ErpDesignerGlobal.insertEmbed.css("left", buttonLeft + "px").css("top", topOffset + 63 + "px");
        break;
      case "flexflowlayoutpanel":
      case "linearlayoutpanel":
      case "splitpanel":
      case "tabpanel":
      case "flowlayoutpanel":
      case "chart":
      case "columnlayoutpanel":
      case "embed":
      case "gridlayoutpanel":
      case "flexgridlayoutpanel":
        ErpDesignerGlobal.buttonDelete.css("left", buttonLeft - 20 + "px").css("top", topOffset + 3 + "px");
        ErpDesignerGlobal.insertEmbed.css("left", buttonLeft - 20 + "px").css("top", topOffset + 33 + "px");
        ErpDesignerGlobal.buttonReplace.css("left", buttonLeft - 20 + "px").css("top", topOffset + 63 + "px");
        ErpDesignerGlobal.compositeComponentInsert.css("left", buttonLeft - 20 + "px").css("top", topOffset + 123 + "px");
        ErpDesignerGlobal.buttonPanQuote.css("left", buttonLeft - 20 + "px").css("top", topOffset + 91 + "px");
        break;
      case "reseau":
        if ($component.prop("outerHTML").indexOf("gridcell") < 0) {
          ErpDesignerGlobal.buttonaddPanelRow.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
          ErpDesignerGlobal.buttonQuote.css("left", buttonLeft + "px").css("top", topOffset + 3 - 35 + "px");
        }
        break;
      case "toolbar":
      case "operationcollection":
        break;
      case "operation":
        break;
      case "columnheader":
        ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", "-1000px");
        if (!vestHideFlag) {
          ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + "px");
        }
        ErpDesignerGlobal.buttonSonRow.css("left", buttonLeft + "px").css("top", "-1000px");
        break;
      case "listview_columnheader":
      case "listviewcolumn":
        ErpDesignerGlobal.buttonInsertBefore1.css("left", buttonLeft + "px").css("top", "-1000px");
        ErpDesignerGlobal.buttonInsertAfter1.css("left", buttonLeft + "px").css("top", "-1000px");
        break;
      case "cell":
      case "gridfield":
        break;
      case "gridrow":
        ErpDesignerGlobal.buttonNewRow.css("left", buttonLeft - 20 + "px").css("top", "-1000px");
        ErpDesignerGlobal.buttonDeleteRow.css("left", leftOffset + 60 + "px").css("top", topOffset + 38 + "px");
        break;
      case "fieldindetailrow":
      case "texteditor":
      case "dict":
      case "numbereditor":
      case "combobox":
      case "datepicker":
      case "utcdatepicker":
      case "button":
      case "checkbox":
      case "textarea":
      case "textbutton":
      case "label":
      case "checklistbox":
      case "dynamicdict":
      case "richeditor":
      case "timepicker":
      case "monthpicker":
      case "passwordeditor":
      case "separator":
      case "image":
      case "radiobutton":
      case "hyperlink":
      case "dropdownbutton":
      case "switch":
      case "container":
      case "carousel":
      case "gifimage":
      case "videoplayer":
      case "barcoder":
        ErpDesignerGlobal.buttonInsert.css("left", buttonLeft + "px").css("top", "-1000px");
        ErpDesignerGlobal.buttonQuote.css("left", buttonLeft + "px").css("top", topOffset + 3 - 50 + "px");
        ErpDesignerGlobal.compositeComponentInsert.css("left", buttonLeft + "px").css("top", topOffset + 3 - 17 + "px");
        ErpDesignerGlobal.buttonDelete.css("left", buttonLeft + "px").css("top", topOffset + 3 + 16 + "px");
        ErpDesignerGlobal.buttonaddPanelRow.css("left", buttonLeft + "px").css("top", topOffset + 3 + 49 + "px");
        break;
    }
  }
  return;
};
_ErpDesignerUtil.addBorderAndButtonByExtension = function addBorderAndButton(oldSelectedType, buttonLeft, topOffset, mergeToSource, isReport, $component, componentleft_left) {
  _ErpDesignerUtil.addBorderAndButton(oldSelectedType, buttonLeft, topOffset, isReport, $component, componentleft_left);
  switch (oldSelectedType && oldSelectedType.toLowerCase()) {
    case "reseau":
      ErpDesignerGlobal.buttonQuote.css("left", buttonLeft + "px").css("top", topOffset + 3 - 56 + "px");
      break;
    case "flexflowlayoutpanel":
    case "linearlayoutpanel":
    case "splitpanel":
    case "tabpanel":
    case "flowlayoutpanel":
    case "chart":
    case "columnlayoutpanel":
    case "embed":
      ErpDesignerGlobal.buttonQuote.css("left", buttonLeft - 20 + "px").css("top", topOffset + 3 - 31 + "px");
      break;
  }
};
let ErpDesignerUtil = _ErpDesignerUtil;
class ErpDesignerService {
  static async commitDiff(formKey, diffs, designerDocument, formDocument, entryParas, isNotOnlyReload) {
    var _a;
    let extensionFormKey = ErpDesignerUI.getActiveERPForm().metaForm.extensionFormKey;
    if (extensionFormKey) {
      formKey = extensionFormKey;
      diffs[0].formKey = extensionFormKey;
    }
    if (await ((_a = window.FormDesignEnvironment) == null ? void 0 : _a.commitDiff(formKey, diffs, designerDocument, formDocument, entryParas, isNotOnlyReload)))
      return true;
    const __ret = await this.commit(diffs, formKey, entryParas, designerDocument, formDocument);
    let form2 = __ret.form;
    formKey = __ret.formKey;
    let commitDiffDto = __ret.commitDiffDto;
    let result = commitDiffDto.result;
    let message = commitDiffDto.message;
    let filePathList = commitDiffDto.filePathList;
    let formKeyList = commitDiffDto.formKeyList;
    let documentDirty = commitDiffDto.documentDirty;
    if (result !== "Success") {
      let messageStr = message;
      const jsonRegex = /^\s*[\[{].*[\]}]\s*$/;
      if (jsonRegex.test(message)) {
        messageStr = JSON.parse(message).message;
      }
      ErpDesignerUI.showTipOrError(messageStr);
      return false;
    }
    form2 = ErpDesignerUI.getRealForm(form2);
    if (!ErpDesignerUI.reloadOnlyComment || isNotOnlyReload) {
      var reloadFormKey = ErpDesignerUI.getActiveERPForm().formKey;
      await ErpDesignerUI.reloadFormKey(form2, reloadFormKey);
      for (let i = 0; i < formKeyList.length; i++) {
        if (reloadFormKey !== formKeyList[i]) {
          await ErpDesignerUI.reloadFormKey(form2, formKeyList[i]);
        }
      }
    } else {
      await this.reloadOnlyComment(diffs, form2, diffs[0].key, "", formKeyList);
    }
    ErpDesignerHelper.ResetSelectedBorder();
    await this.commitDiffPost(diffs, formKey, form2, filePathList, formDocument, documentDirty, message);
    return true;
  }
  static async commitDiffPost(diffs, formKey, form2, filePathList, formDocument, documentDirty, message) {
    var _a;
    if (await ((_a = window.FormDesignContainer) == null ? void 0 : _a.commitDiffPost(diffs, formKey, form2, filePathList, formDocument, documentDirty, message)))
      return true;
    let key2 = diffs[0].key;
    diffs[0].parentKey;
    let needRefreshMenuTree = false;
    let needLocate = !$(".design-location.selectedBorder").is(":visible");
    let isNewCol = false;
    for (let i = 0; i < diffs.length; i++) {
      let metaObjectType2 = diffs[i].metaObjectType;
      if (metaObjectType2 == "DataSource") {
        needLocate = false;
      }
      if (diffs[i].caption || diffs[i].isButtonQuote != null && diffs[i].isButtonQuote) {
        needLocate = true;
        needRefreshMenuTree = true;
        if (metaObjectType2 == "GridField") {
          isNewCol = true;
        }
        break;
      } else if (diffs[i].isDelete) {
        needLocate = true;
        needRefreshMenuTree = true;
        if (metaObjectType2 == "GridFieldRow") {
          key2 = diffs[i].key;
        } else if (metaObjectType2 == "Operation" || metaObjectType2 == "OperationCollection" || metaObjectType2 == "Toolbar" || metaObjectType2 == "Embed") {
          key2 = formKey;
        } else {
          key2 = diffs[i].parentKey;
        }
        break;
      } else {
        if (!key2) {
          key2 = diffs[i].parentKey;
        }
        if (!ErpDesigner.selectComponentKey && metaObjectType2 != "DataSource") {
          needLocate = true;
        }
        if (diffs[i].isPropertyDiff) {
          for (let j = 0; j < diffs[i].properties.length; j++) {
            let property = diffs[i].properties[j];
            if (property.property == "Key" || property.property == "Caption" || property.property == "RowKey") {
              needRefreshMenuTree = true;
              break;
            }
          }
        }
      }
    }
    var controlType = diffs[0].controlType;
    let metaObjectType = diffs[0].metaObjectType;
    if (metaObjectType === "GridHeadColumn" || isNewCol) {
      ErpDesigner.toBeLocateType = "columnheader";
      controlType = "columnheader";
    } else if (metaObjectType === "GridField") {
      ErpDesigner.toBeLocateType = "cell";
      controlType = "cell";
    } else {
      ErpDesigner.toBeLocateType = controlType;
    }
    if (needRefreshMenuTree) {
      await ErpDesignerUI.refreshMenuTree();
      var temKey = key2;
      await ErpDesignerUI.nodeTreeLocate(form2, temKey, controlType);
      if (needLocate) {
        await ErpDesignerUI.nodeTreeLocate(form2, key2, controlType);
      } else {
        ErpDesigner.toBeLocateType = "";
        ErpDesigner.toBeLocateIdList = [];
      }
    } else {
      if (needLocate) {
        await ErpDesignerUI.nodeTreeLocate(form2, key2, controlType);
      } else {
        ErpDesigner.toBeLocateType = "";
        ErpDesigner.toBeLocateIdList = [];
      }
    }
    for (let i = 0; i < filePathList.length; i++) {
      await ErpDesignerSrc.reloadXmlSource(filePathList[i]);
    }
    let preferences = ErpDesignerUI.preferences, isShowDirtyData = false;
    if (preferences) {
      isShowDirtyData = preferences.getComponent("IsShowData").getValue() == "true";
    }
    if (isShowDirtyData && formDocument && formDocument.object_key) {
      let uiCommand2 = {
        content: {
          formKey: formDocument.object_key,
          documentDirty
        }
      };
      ErpDesigner.processDocumentDirty(form2, uiCommand2);
    }
    ErpDesignerUI.showTipOrError(message);
  }
  static async commitPropertyDiff(formKey, diffs, designerDocument, formDocument, entryParas, propertyKey) {
    if (!ErpDesignerUI.reloadOnlyComment) {
      return this.commitDiff(formKey, diffs, designerDocument, formDocument, entryParas);
    }
    const __ret = await this.commit(diffs, formKey, entryParas, designerDocument, formDocument);
    let form2 = __ret.form;
    formKey = __ret.formKey;
    let commitDiffDto = __ret.commitDiffDto;
    let result = commitDiffDto.result;
    let message = commitDiffDto.message;
    let filePathList = commitDiffDto.filePathList;
    let formKeyList = commitDiffDto.formKeyList;
    let documentDirty = commitDiffDto.documentDirty;
    if (result !== "Success") {
      let messageStr = message;
      const jsonRegex = /^\s*[\[{].*[\]}]\s*$/;
      if (jsonRegex.test(message)) {
        messageStr = JSON.parse(message).message;
      }
      ErpDesignerUI.showTipOrError(messageStr);
      return false;
    }
    form2 = ErpDesignerUI.getRealForm(form2);
    await this.reloadOnlyComment(diffs, form2, diffs[0].key, propertyKey, formKeyList);
    await this.commitDiffPost(diffs, formKey, form2, filePathList, formDocument, documentDirty, message);
    return true;
  }
  static async commit(diffs, formKey, entryParas, designerDocument, formDocument) {
    let extensionFormKey = "";
    let form2 = ErpDesignerUI.getActiveERPForm();
    if (form2.metaForm.extensionFormKey) {
      extensionFormKey = form2.metaForm.extensionFormKey;
    }
    diffs[0].paramsformKey = ErpDesignerUI.getActiveERPForm().formKey;
    formKey = formKey ? formKey : ErpDesignerUI.activeERPFormKey;
    diffs[0].formKey = extensionFormKey ? extensionFormKey : formKey;
    let params = new ServiceParams();
    params.cmd = "CommitDiff";
    params.service = "DesignService";
    params.formKey = extensionFormKey ? extensionFormKey : formKey;
    params.entryParas = entryParas;
    params.diffs = JSON.stringify(diffs);
    if (typeof designerDocument != "string" && designerDocument && !form2.getDefContainer.formKey) {
      params.designerDocument = JSON.stringify(DataUtil.toJSONDoc(designerDocument));
    }
    if (typeof formDocument != "string") {
      params.formDocument = JSON.stringify(DataUtil.toJSONDoc(formDocument));
      params.documentFormKey = params.formKey;
    }
    var openFormKeys = [];
    YIUI.FormStack.getFormList().forEach((form22) => {
      if (form22.projectKey != "webconfig") {
        openFormKeys.push(form22.getFormKey());
      }
    });
    params.openFormKeys = openFormKeys.toString();
    let commitDiffDto = await new Request().getData(params, ServletURL);
    return { form: form2, formKey, commitDiffDto };
  }
  static async reloadOnlyComment(diffs, form2, key2, propertyKey, formKeyList) {
    if (diffs[0].metaObjectType.indexOf("Grid") >= 0) {
      if (form2.getCellLocation(key2)) {
        await ErpDesignerUI.doRenderOnlyControl(form2, form2.getCellLocation(key2).key);
      } else {
        await ErpDesignerUI.doRenderOnlyControl(form2, diffs[0].parentKey);
      }
    } else if (diffs[0].metaObjectType.indexOf("Operation") >= 0) {
      await ErpDesignerUI.doRenderOnlyControl(form2, diffs[0].parentKey);
    } else if (form2.getComponent(key2)) {
      var pannel = form2.getComponent(key2).ownerCt;
      if (pannel && pannel.tagName == "TabPanel" && propertyKey == "Caption") {
        await ErpDesignerUI.doRenderOnlyControl(form2, pannel.key);
      } else if (diffs[0].isDelete) {
        await ErpDesignerUI.doRenderOnlyControl(form2, diffs[0].parentKey);
      } else {
        await ErpDesignerUI.doRenderOnlyControl(form2, key2);
      }
    } else {
      await ErpDesignerUI.doRenderOnlyControl(form2, diffs[0].parentKey);
    }
    var reloadFormKey = form2.formKey;
    setTimeout(async () => {
      for (let i = 0; i < formKeyList.length; i++) {
        if (reloadFormKey !== formKeyList[i]) {
          await ErpDesignerUI.reloadFormKey(form2, formKeyList[i]);
        }
      }
    }, 100);
  }
  static async loadFileContent(filePath, needLoad, temFilePath) {
    var params = {
      cmd: "LoadFileContent",
      service: "DesignService",
      filePath,
      temFilePath,
      needLoad
    };
    var r = new Request();
    return await r.getData(params);
  }
  static async getPropertyDefine() {
    var params = {
      cmd: "GetPropertyDefineXml",
      service: "DesignService"
    };
    var r = new Request();
    return await r.getData(params);
  }
  static async appDesignLogin() {
    var params = {
      cmd: "AppDesignLogin",
      service: "DesignService"
    };
    var r = new Request();
    return await r.getData(params);
  }
  //语法检测
  static async parseFormula(formKey, type, formula, fieldKey, content) {
    var params = {
      cmd: "ParseFormula",
      service: "DesignService",
      formKey,
      type,
      fieldKey,
      content,
      formula
    };
    var r = new Request();
    return await r.getData(params);
  }
  static async handlingMergeSingleFormDiff(document2, diff, type, cxt) {
    var commonDefParams = {
      document: JSON.stringify(DataUtil.toJSONDoc(document2)),
      diff: JSON.stringify([diff]),
      type
    };
    let r = new Request();
    r.addHeader("content-type", "application/json");
    let res = await r.getData(commonDefParams, ErpDesigner.url + "settingControl/handle" + type);
    if (res.UICommand && res.UICommand.length > 0) {
      let activeForm = ErpDesignerUI.getActiveERPForm();
      await ErpDesignerUI.doUICommands(activeForm, res.UICommand);
    }
    if (!res.error) {
      await ErpDesignerUtil.closeForm(cxt.form);
    }
    return true;
  }
  //表达式自动完成调用
  async Getmacroformula(formKey, index, content, type) {
    var params = {
      cmd: "Getmacroformula",
      service: "DesignService",
      formKey,
      index,
      content,
      type
    };
    var r = new Request();
    return await r.getData(params);
  }
  static async saveFileContent(filePath, content, key2) {
    let params = {
      cmd: "SaveFileContent",
      service: "DesignService",
      filePath,
      content,
      key: key2
    };
    var r = new Request();
    return await r.getData(params);
  }
  static async checkKeyLength(isSourceActive, content, uiFormKey, entryParas) {
    let params = {
      cmd: "CheckKeyLength",
      service: "DesignService",
      isSourceActive,
      content,
      uiFormKey,
      entryParas
    };
    var r = new Request();
    return await r.getData(params);
  }
  static async NewDomainORDataElement(filePath, projectKey, key2, fileType, operType, form2, pFormKey) {
    var doc = DataUtil.toJSONDoc(form2.getDocument());
    let params = {
      cmd: "NewDomainORDataElement",
      service: "DesignService",
      filePath,
      projectKey,
      key: key2,
      formKey: form2.formKey,
      formDocument: JSON.stringify(doc),
      fileType,
      operType,
      pFormKey
    };
    var r = new Request();
    return await r.getData(params);
  }
  static async webBpmDesign(filePath, projectKey, formKey, formCaption, operType) {
    let params = {
      cmd: "WebBpmDesign",
      service: "DesignService",
      filePath,
      projectKey,
      newFormKey: formKey,
      formCaption,
      operType
    };
    var r = new Request();
    return await r.getData(params);
  }
  async webReportDesign(filePath, projectKey, formKey, formCaption, operType) {
    let params = {
      cmd: "webReportDesign",
      service: "DesignService",
      filePath,
      projectKey,
      newFormKey: formKey,
      formCaption,
      operType
    };
    var r = new Request();
    return await r.getData(params);
  }
  static async getMetaDesignerFormMeta(formKey, calculateScope, merge) {
    let params = {
      cmd: "GetMetaDesignerForm",
      service: "DesignService",
      formKey,
      calculateScope
    };
    var r = await new Request().getData(params);
    if (Request.mode == 2 && merge == void 0 || merge != void 0 && merge)
      new MetaFormProcess(r.meta).process();
    if (r.message) {
      ErpDesignerUI.showTip(r.message, "error");
    }
    return r.meta;
  }
  static async getMetaDesignerForm(formKey, calculateScope, merge, formID) {
    let params = {
      cmd: "GetMetaDesignerForm",
      service: "DesignService",
      formKey,
      calculateScope
    };
    var r = await new Request().getData(params);
    if (Request.mode == 2 && merge == void 0 || merge != void 0 && merge)
      new MetaFormProcess(r.meta).process();
    if (r.message) {
      ErpDesignerUI.showTip(r.message, "error");
    }
    let metaForm = new MetaForm(r.meta);
    FormDependProvider.remove(r.meta);
    var emptyForm = DesignerFormFactory.create(metaForm, null, formID);
    if (calculateScope) {
      var formulaScope = r.formulaScope;
      if (formulaScope && formulaScope.fieldKey2Scope) {
        var result = {};
        for (let i = 0; i < formulaScope.fieldKey2Scope.length; i++) {
          const fieldKey = formulaScope.fieldKey2Scope[i].fieldKey;
          const scope = formulaScope.fieldKey2Scope[i].scope;
          result[fieldKey] = scope;
        }
        UIScopeTrees.scopeTrees[r.meta.key] = result;
        emptyForm.formulaScope = result;
        emptyForm.setFormulaScope(result);
      }
    }
    return emptyForm;
  }
  /**
   * 设计器专用
   * @param formKey
   * @param calculateScope
   */
  static async getDesignerFormCache(formKey) {
    let params = {
      cmd: "GetMetaDesignerForm",
      service: "DesignService",
      formKey,
      calculateScope: false
    };
    let designerFormMetaCache = await ErpDesignerUtil.getDesignerTableCacheByTableName("DesignerFormMetaCache")();
    var meta = await designerFormMetaCache.get(formKey);
    if (!meta) {
      var r = await new Request().getData(params);
      meta = r.meta;
      if (r.message) {
        ErpDesignerUI.showTip(r.message, "error");
      }
      designerFormMetaCache.put(formKey, meta);
    }
    let metaForm = new MetaForm(meta);
    FormDependProvider.remove(meta);
    var emptyForm = DesignerFormFactory.create(metaForm, null);
    return emptyForm;
  }
  /**
  * 设计器专用
  * @param formKey
  * @param calculateScope
  */
  static async SetEnvironmentRunType(runType) {
    let params = {
      cmd: "SetEnvironmentRunType",
      service: "DesignService",
      runType
    };
    var r = await new Request().getData(params);
    return r.meta;
  }
}
class DiffProperty {
  constructor() {
    this.property = null;
    this.orgValue = null;
    this.newValue = null;
    this.propertyIsCData = false;
    this.propertyValueByLocation = "";
  }
}
class ComboBoxExt extends ComboBox$1 {
  checkEnd(value2) {
    this.value = value2;
    var _this = this;
    if (("" + value2).trim() == "" || value2 == void 0 || value2 == null) {
      this.updateValue("", _this.impl.items);
      return;
    }
    super.checkItems().then((data) => {
      checkCompState(this);
      var data = _this.items;
      _this.updateValue(value2, data);
    });
  }
  updateValue(value2, items) {
    var _this = this;
    _this.impl.setValue(value2);
    var caption = _this.handler.getCaptionFromItems(_this.getMetaObj().properties, items, value2, _this.multiSelect);
    caption = _this.impl.getIntCaption(items, caption);
    _this.showText = caption;
    _this.impl.setShowText(caption);
    _this.impl.setTip(caption);
    if (!value2) {
      _this.impl.hideClearBtn();
    }
  }
}
class ComboBoxBuilderExt extends ComboBoxBuilder {
  create(meta) {
    if (DesignModeSetting.isDesignMode) {
      return new ComboBoxExt(meta);
    } else {
      return super.create(meta);
    }
  }
}
class DesignerContainer {
  constructor() {
  }
  add(form2) {
    var div = document.createElement("div");
    $(div).height("100%");
    FormRender.render(form2, div);
    $(div).prependTo($(document.body));
  }
  setShowCloseIcon(close) {
  }
  hide(form2) {
  }
  show(form2) {
  }
  close(form2) {
  }
  startTimeTasks(form2) {
  }
  closeTimerTasks(form2) {
  }
  closeAll() {
  }
}
class DesignGridLayoutPanel extends BasePanel {
  constructor(meta) {
    super(meta);
    this.extraLayout = meta.extraLayout;
  }
  async doPostShow() {
    let form2 = this.getForm();
    if (this.extraLayout) {
      let extraLayout = { ...this.extraLayout };
      let groupCollection = extraLayout.groupCollection;
      if (Array.isArray(groupCollection)) {
        for (let i = 0, group, expanded; i < groupCollection.length; i++) {
          group = groupCollection[i];
          if (group.expanded) {
            expanded = TypeConvertor.toString(group.expanded);
            const result = await form2.asyncEval(expanded, new ViewContext(form2));
            group.expanded = result;
          } else {
            group.expanded = true;
          }
        }
      } else {
        extraLayout.groupCollection = [];
      }
      this.extraLayout = extraLayout;
    }
  }
  doRender(container) {
    let self = this;
    container.addPostpatchHook(() => {
      self.doLayout();
    });
    const extraLayoutType = this.getExtraLayoutType();
    if (extraLayoutType == "Property" && false)
      ;
    else if (extraLayoutType == "Collapsible") {
      super.doRender(container);
    } else {
      if (DesignModeSetting.isDesignMode && this.key == "FavoritePanel") {
        this.yesCom.owner.topPadding = "0px";
      }
      super.doRender(container);
    }
  }
  doLayout(panelWidth, panelHeight) {
    super.doLayout(panelWidth, panelHeight);
    this.impl && this.impl.layout1 && this.impl.layout1(panelWidth, panelHeight);
    this.customLayoutRender && this.customLayoutRender.resize(panelWidth, panelHeight);
  }
  setHeight(height) {
    super.setHeight(height);
    this.customLayoutRender && this.customLayoutRender.resize(this.getWidth(), height);
  }
  afterRender() {
    !this.isPropertyLayout() && super.afterRender();
  }
  getExtraLayoutType() {
    return this.meta && this.meta.extraLayout ? this.meta.extraLayout.type : "";
  }
  isPropertyLayout() {
    const customLayoutType = this.getExtraLayoutType();
    return customLayoutType == "Property";
  }
  calcAutoHeight() {
    if (!this.impl)
      return 0;
    let autoHeight = 16;
    let heights = this.impl.heights;
    let sGridTemplateRows = this.impl.getEl().getStyle("grid-template-rows");
    if (sGridTemplateRows) {
      sGridTemplateRows = sGridTemplateRows.trim();
      heights = sGridTemplateRows.split(" ");
    }
    for (let i = 0, len = heights.length; i < len; i++) {
      var rowHeight = SizeUtil.getSize(heights[i]);
      autoHeight += rowHeight + (this.impl.rowGap ? this.impl.rowGap : 0);
    }
    return autoHeight;
  }
}
class DesignGridLayoutPanelBuilder extends PanelBuilder {
  initParas(form2, panel, meta) {
    super.initParas(form2, panel, meta);
    Utils.isUndefined(meta.forceLayout) && (panel.forceLayout = meta.forceLayout);
    var metaCols = meta.layout.columns, widths = [], minWidths = [];
    for (var i = 0, items = metaCols.items; i < items.length; i++) {
      widths.push(items[i].width);
      minWidths.push(parseInt(items[i].minWidth || 0, 10));
    }
    var metaRows = meta.layout.rows, heights = [];
    for (var i = 0, items = metaRows.items; i < items.length; i++) {
      var h2 = Utils.isUndefined(items[i].height) ? metaRows.rowHeight : items[i].height;
      heights.push(h2);
    }
    panel.rowGap = metaRows.rowGap;
    panel.columnGap = metaCols.columnGap;
    panel.widths = widths;
    panel.minWidths = minWidths;
    panel.heights = heights;
    panel.oddColumnColor = meta.oddColumnColor;
  }
  initLayout(form2, panel, meta) {
    super.initLayout(form2, panel, meta);
  }
  refreshLayoutItems(panel, layoutItems, group) {
    var item, groupPos, y;
    for (let i = 0, len = layoutItems.length; i < len; i++) {
      item = layoutItems[i];
      y = item.y;
      if (group.startRow >= y) {
        groupPos = i;
      }
      if (group.handle && group.handle.y >= y)
        ;
    }
    var _groupItem = {
      x: 0,
      startRow: group.startRow,
      endRow: group.endRow,
      startColumn: 1,
      endColumn: panel.widths.length,
      tagName: "ExtraGroup",
      owner: group
    };
    layoutItems.splice(groupPos + 1, 0, _groupItem);
  }
  create(meta) {
    return new DesignGridLayoutPanel(meta);
  }
}
const _ERPDesignerSearchResultFill = class _ERPDesignerSearchResultFill2 {
  /**
   * 处理字符串
   */
  static lcut(text, n) {
    if (text.length < n) {
      return text;
    }
    const re = /\b/g;
    let i = 0;
    while (re.test(text)) {
      if (text.length - re.lastIndex < n) {
        break;
      }
      i = re.lastIndex;
      re.lastIndex += 1;
    }
    return text.substring(i).replace(/^\s/, "");
  }
  /**
   * 处理搜索结果的描述cell
   */
  static enhanceSearchResultGridCell(rowData, cellData, $cell, ri, ci, vci) {
    if (cellData.key == _ERPDesignerSearchResultFill2.PREVIEW_TEXT_KEY) {
      const type = rowData.data[3];
      if (type.value == _ERPDesignerSearchResultFill2.FILE_LINE_TYPE) {
        const previewText = rowData.data[_ERPDesignerSearchResultFill2.PREVIEW_TEXT_INDEX].value;
        const startColumn = parseInt(rowData.data[_ERPDesignerSearchResultFill2.START_COLUMN_INDEX].value);
        const endColumn = parseInt(rowData.data[_ERPDesignerSearchResultFill2.END_COLUMN_INDEX].value);
        $cell.$empty();
        let div = YElement.buildFromVNode(h("div.ygrid-cell")).$appendTo($cell);
        let before = previewText.substring(0, startColumn), inside = previewText.substring(startColumn, endColumn), after = previewText.substring(endColumn);
        before = _ERPDesignerSearchResultFill2.lcut(before, _ERPDesignerSearchResultFill2.MAX_RIGHT_PREVIEW_CHARS);
        before = before.trimStart();
        let charsRemaining = _ERPDesignerSearchResultFill2.MAX_PREVIEW_CHARS - before.length;
        inside = inside.substr(0, charsRemaining);
        charsRemaining -= inside.length;
        after = after.substr(0, charsRemaining);
        YElement.buildFromVNode(h("span", before)).$appendTo(div);
        YElement.buildFromVNode(h("span.findInFileMatch", inside)).$appendTo(div);
        YElement.buildFromVNode(h("span", after)).$appendTo(div);
      }
    } else if (cellData.key == _ERPDesignerSearchResultFill2.DELETE_KEY) {
      $cell.$empty();
      $cell.$hide();
    } else if (cellData.key == _ERPDesignerSearchResultFill2.REPLACE_KEY) {
      $cell.$hide();
    }
  }
};
_ERPDesignerSearchResultFill.MAX_PREVIEW_CHARS = 250;
_ERPDesignerSearchResultFill.MAX_RIGHT_PREVIEW_CHARS = 26;
_ERPDesignerSearchResultFill.PREVIEW_TEXT_INDEX = 2;
_ERPDesignerSearchResultFill.START_COLUMN_INDEX = 5;
_ERPDesignerSearchResultFill.END_COLUMN_INDEX = 6;
_ERPDesignerSearchResultFill.PREVIEW_TEXT_KEY = "CaptionCell";
_ERPDesignerSearchResultFill.FILE_LINE_TYPE = "FileLineType";
_ERPDesignerSearchResultFill.DELETE_KEY = "DeleteCell";
_ERPDesignerSearchResultFill.REPLACE_KEY = "ReplaceCell";
let ERPDesignerSearchResultFill = _ERPDesignerSearchResultFill;
class DesignerYesVGridExt extends YesVGridExt {
  enhanceCell(rowData, cellData, $cell, ri, ci, vci) {
    var _a;
    const form2 = (_a = this.owner) == null ? void 0 : _a.form;
    if (form2 && "D_FileTree" === form2.getFormKey() && "SearchResultGrid" === this.owner.key) {
      ERPDesignerSearchResultFill.enhanceSearchResultGridCell(rowData, cellData, $cell, ri, ci, vci);
    }
  }
}
class DesignerYesGridBuilderExt extends YesGridBuilder {
  static create(options) {
    return new DesignerYesVGridExt(options);
  }
}
var CLS_AREA_CELL_COLLAPSED$1 = "area-cell-collapsed";
const sumAuto$1 = (sizes) => {
  var arr = [], autonum = 0;
  for (var i = 0; i < sizes.length; i++) {
    var size = sizes[i];
    if (Utils.isPercentage(size)) {
      arr.push(parseFloat(size));
    }
    if (size == "auto") {
      autonum++;
    }
  }
  if (arr.length == 0) {
    return "1fr";
  }
  return (100 - sum$1(arr)) / autonum + "fr";
};
const sum$1 = (arr) => {
  return arr.reduce((prev, curr, idx, arr2) => {
    return prev + curr;
  });
};
const getSize$1 = (sizes, minSizes, gap) => {
  var s = "";
  for (var i = 0, len = sizes.length; i < len; i++) {
    var size = sizes[i];
    var minSize = 0;
    if (minSizes.length > 0) {
      minSize = minSizes[i];
    }
    if (minSize <= 0)
      minSize = 0;
    if (Utils.isString(size) && size.indexOf("px") > 0) {
      size = parseInt(size);
    }
    if (Utils.isNumeric(size)) {
      if (i > 0) {
        size += gap;
      }
      size = size + "px";
      minSize && (size = "minmax(" + minSize + "px, " + size + ")");
    } else if (size == "pref") {
      size = "auto";
    } else if (Utils.isPercentage(size)) {
      size = parseInt(size) + "fr";
      size = "minmax(" + minSize + "px, " + size + ")";
    } else if (size == "auto") {
      size = sumAuto$1(sizes);
      size = "minmax(0px, " + size + ")";
    } else if (size.indexOf("dp") > -1) {
      size = size.replace("dp", "px");
      minSize && (size = "minmax(" + minSize + "px, " + size + ")");
    } else {
      minSize && (size = "minmax(" + minSize + "px, " + size + ")");
    }
    s += " " + size;
  }
  return s;
};
class DesignVGridLayoutCss3 extends VAutoLayout {
  constructor(options) {
    super(options);
    this.rowGap = options.rowGap;
    this.columnGap = options.columnGap;
    this.widths = options.widths;
    this.minWidths = options.minWidths;
    this.heights = options.heights;
    this.oddColumnColor = options.oddColumnColor;
    this.extraLayout = options.meta.extraLayout;
    console.log("this is gridlayoutcss3 constructor...................");
  }
  layout(panelWidth, panelHeight) {
    throw new Error("Method not implemented.");
  }
  setActiveItem(item) {
  }
  initParas(form2, btn, meta) {
  }
  getGroupByRowIndex(rowIndex) {
    var _groups = this.groups;
    var _group;
    if (_groups) {
      for (var key2 in _groups) {
        _group = _groups[key2];
        if (rowIndex >= _group.startRow && rowIndex <= _group.endRow) {
          return _group;
        }
      }
    }
  }
  getGroupByKey(groupKey) {
    return this.groups[groupKey];
  }
  getContainer(rowIndex) {
    var group = this.getGroupByRowIndex(rowIndex);
    if (group) {
      return group.el;
    } else {
      return this.el;
    }
  }
  createGroup() {
    var groups = {}, newGrop;
    var groupCollection = this.extraLayout.groupCollection, startRow, endRow;
    for (let i = 0, len = groupCollection.length, group, groupCt; i < len; i++) {
      group = groupCollection[i];
      startRow = group.startRow;
      endRow = group.endRow;
      groupCt = YElement.buildFromVNode(h("div.group", { attrs: {
        _row: startRow,
        _col: group.x,
        startRow,
        endRow
      } }));
      groupCt.$addStyle("display", "grid");
      var _groupOut = YElement.buildFromVNode(h("div.group-out")).$appendTo(this.el);
      _groupOut.$appendStyles(new Map(Object.entries({
        "grid-row-start": startRow + 1,
        "grid-row-end": endRow + 1,
        "grid-column-start": 1,
        "grid-column-end": `span ${this.widths.length}`
      })));
      groupCt.$appendTo(_groupOut);
      if (startRow > 0) {
        _groupOut.$addStyle("padding-top", `${this.rowGap}px`);
        groupCt.$addStyle("padding-top", `${this.rowGap}px`);
      }
      var widths = this.widths, minWidths = this.minWidths, heights = this.heights.slice(startRow, endRow + 1), rowGap = this.rowGap || 0, columnGap = this.columnGap || 0;
      var _w = getSize$1(widths, minWidths, columnGap);
      var _h = getSize$1(heights, [], rowGap);
      var newHeights = this.heights;
      this.heights.forEach((height, index) => {
        if (index + 1 >= startRow && index <= endRow) {
          newHeights.splice(index, 1, "pref");
        }
      });
      newHeights.push("1fr");
      this.el.$addStyle("grid-template-rows", getSize$1(newHeights, [], rowGap));
      groupCt.$addStyle("grid-template-rows", _h).$addStyle("grid-template-columns", _w).$addStyle("grid-column-gap", columnGap + "px");
      newGrop = {
        el: groupCt,
        startRow,
        endRow,
        heights
      };
      groups[group.key] = newGrop;
      this.renderCollapseControl(group, _groupOut);
    }
    this.groups = groups;
  }
  resetGroupStyle(groupKey, isAuto) {
    var group = this.groups[groupKey];
    var heights = group.heights, newHeights;
    if (!heights)
      return;
    if (isAuto) {
      newHeights = heights.map((item) => {
        item = "pref";
        return item;
      });
    } else {
      newHeights = heights;
    }
    group.el.$addStyle("grid-template-rows", getSize$1(newHeights, [], this.rowGap));
  }
  createLabel(group) {
    group.handle.y + 1;
    group.handle.x + 1;
    var el = YElement.buildFromVNode(h("div")).$addClass("ui-control ui-lbl ui-readonly group-lbl");
    var ct = YElement.buildFromVNode(h("div")).$addClass("yg_collapse erp-group-title").$appendTo(el);
    var span = YElement.buildFromVNode(h("span.iconfont")).$appendTo(ct);
    var expandedClass = "icon-jianhaoshouqi";
    var collapsedClass = "icon-jiahaozhankai";
    if (group.expanded) {
      span.$addClass(expandedClass);
    } else {
      span.$addClass(collapsedClass);
    }
    var lbl = YElement.buildFromVNode(h("label", group.caption)).$appendTo(ct);
    lbl.$addClass("yg_collapse_text");
    span.$click((e) => {
      var isExpanded = span.hasClass(expandedClass);
      if (isExpanded) {
        span.$removeClass(expandedClass).$addClass(collapsedClass);
      } else {
        span.$removeClass(collapsedClass).$addClass(expandedClass);
      }
      this.resetGroupStyle(group.key, isExpanded);
      this.updateGroupVisible(group.key, !isExpanded);
    });
    return el;
  }
  renderCollapseControl(control, container) {
    if (!this.el)
      return;
    var row = control.handle.y + 1;
    var col = control.handle.x + 1;
    var $cells = this.el.$find((vEl) => vEl.getAttr("_row") == row && vEl.getAttr("_col") == col);
    if (!$cells[0]) {
      var label = this.createLabel(control);
      if (control.handle.y != control.startRow) {
        var ct = YElement.buildFromVNode(h("div")).$appendTo(this.el);
        ct.$addStyle("grid-row-start", row);
        ct.$addStyle("grid-column-start", col);
        ct.$addStyle("_row", row);
        ct.$addStyle("_col", col);
        if (this.rowGap && row > 1) {
          ct.$addStyle("padding-top", this.rowGap + "px");
        }
        label.$appendTo(ct);
      } else {
        label.$prependTo(container);
      }
    }
  }
  updateAreaCollapse(groupKey, bCollapse) {
    if (!this.el)
      return;
    var customLayout = this.extraLayout;
    if (!customLayout)
      return;
    var groupItem = this.getGroupByKey(groupKey);
    if (!groupItem) {
      throw new Error("unknow groupkey:" + groupKey);
    }
    this.updateGroupVisible(groupItem.key, !bCollapse);
  }
  updateRowVisible(row, visible) {
    let vPanel = this.getContainer(row);
    vPanel.getChildElms().forEach((vCell, idx) => {
      if (vCell.getAttr("_row") == row) {
        if (visible) {
          vCell.$removeClass(CLS_AREA_CELL_COLLAPSED$1);
        } else {
          vCell.$addClass(CLS_AREA_CELL_COLLAPSED$1);
        }
      }
    });
  }
  updateGroupVisible(groupKey, visible) {
    var groupEl = this.getGroupByKey(groupKey).el;
    if (!groupEl)
      return;
    if (visible) {
      groupEl.$removeClass(CLS_AREA_CELL_COLLAPSED$1);
    } else {
      groupEl.$addClass(CLS_AREA_CELL_COLLAPSED$1);
    }
  }
  createHTML() {
    this.el.$addClass("ui-pnl").$addClass("ui-glpcss3");
    if (this.extraLayout) {
      this.createGroup();
    }
    return this.el;
  }
  beforeRenderItem(c, target, layoutItem, index) {
    if (layoutItem.y > 0 && !target.hasClass("firstRow")) {
      target.$parent().$addStyle("padding-top", `${this.rowGap}px`);
    }
    c.setWidth("100%");
    c.setHeight("100%");
  }
  /**
   * 返回控件comp即将被render到的dom
   * @param comp
   * @param layoutItem comp在items中的index
   */
  getItemTarget(comp, layoutItem, index) {
    if (comp.container) {
      return comp.container;
    }
    var item, row, col, xSpan, ySpan;
    item = layoutItem;
    col = item.x + 1;
    row = item.y + 1;
    xSpan = item.xSpan || 1;
    ySpan = item.ySpan || 1;
    var group = this.getGroupByRowIndex(item.y);
    var grouEl = group && group.el;
    if (grouEl) {
      row -= group.startRow;
    }
    var cssText = /* @__PURE__ */ new Map([
      ["grid-row-start", row],
      ["grid-column-start", col]
    ]);
    if (ySpan > 1) {
      cssText.set("grid-row-end", row + ySpan);
    }
    if (xSpan > 1) {
      cssText.set("grid-column-end", col + xSpan);
    }
    var target = YElement.buildFromVNode(
      h("div", { attrs: { _row: row, _col: col } })
    );
    if (grouEl) {
      target.$appendTo(grouEl);
    } else {
      target.$appendTo(this.el);
    }
    target.$appendStyles(cssText);
    var ct = YElement.buildFromVNode(h("div"));
    ct.$appendTo(target);
    comp.container = ct;
    if (row == 1) {
      ct.$addClass("firstRow");
    }
    return ct;
  }
  layoutRender() {
    var widths = this.widths, minWidths = this.minWidths, heights = this.heights;
    this.rowGap || 0;
    var columnGap = this.columnGap || 0;
    var w = getSize$1(widths, minWidths, 0);
    var h2 = getSize$1(heights, [], this.rowGap);
    this.el.$addStyle("grid-template-rows", h2).$addStyle("grid-template-columns", w).$addStyle("grid-column-gap", columnGap + "px");
    return;
  }
  afterRender() {
    super.afterRender();
    var groups = this.extraLayout && this.extraLayout.groupCollection;
    if (groups && groups.length > 0) {
      groups.forEach((group) => {
        this.updateGroupVisible(group.key, group.expanded);
      });
      this.el.$addStyle("flex", "unset");
    }
  }
  reduceVisible(visible, comp) {
    var ct = comp.container.$parent();
    if (visible) {
      ct.$addStyle("padding-top", `${this.rowGap}px`);
    } else {
      ct.$addStyle("padding-top", "unset");
    }
  }
}
var CLS_AREA_CELL_COLLAPSED = "area-cell-collapsed";
const sumAuto = (sizes) => {
  var arr = [], autonum = 0;
  for (var i = 0; i < sizes.length; i++) {
    var size = sizes[i];
    if (Utils.isPercentage(size)) {
      arr.push(parseFloat(size));
    }
    if (size == "auto") {
      autonum++;
    }
  }
  if (arr.length == 0) {
    return "1fr";
  }
  return (100 - sum(arr)) / autonum + "fr";
};
const sum = (arr) => {
  return arr.reduce((prev, curr, idx, arr2) => {
    return prev + curr;
  });
};
const getSize = (sizes, minSizes, gap) => {
  var s = "";
  for (var i = 0, len = sizes.length; i < len; i++) {
    var size = sizes[i];
    var minSize = 0;
    if (minSizes.length > 0) {
      minSize = minSizes[i];
    }
    if (minSize <= 0)
      minSize = 0;
    if (Utils.isString(size) && size.indexOf("px") > 0) {
      size = parseInt(size);
    }
    if (Utils.isNumeric(size)) {
      if (i >= 0) {
        size += gap;
      }
      size = "minmax(" + size + "px,max-content)";
      minSize && (size = "minmax(" + minSize + "px, " + size + ")");
    } else if (size == "pref") {
      size = "auto";
    } else if (Utils.isPercentage(size)) {
      size = parseInt(size) + "fr";
      size = "minmax(" + minSize + "px, " + size + ")";
    } else if (size == "auto") {
      size = sumAuto(sizes);
      size = "minmax(0px, " + size + ")";
    } else if (size.indexOf("dp") > -1) {
      size = size.replace("dp", "px");
      minSize && (size = "minmax(" + minSize + "px, " + size + ")");
    } else {
      minSize && (size = "minmax(" + minSize + "px, " + size + ")");
    }
    s += " " + size;
  }
  return s;
};
class VDesignerGridLayoutCss3 extends VAutoLayout {
  constructor(options) {
    super(options);
    this.rowGap = options.rowGap;
    this.columnGap = options.columnGap;
    this.widths = options.widths;
    this.minWidths = options.minWidths;
    this.heights = options.heights;
    this.oddColumnColor = options.oddColumnColor;
    this.extraLayout = options.meta.extraLayout;
    console.log("this is gridlayoutcss3 constructor...................");
  }
  layout(panelWidth, panelHeight) {
    throw new Error("Method not implemented.");
  }
  setActiveItem(item) {
  }
  initParas(form2, btn, meta) {
  }
  getGroupByRowIndex(rowIndex) {
    var _groups = this.groups;
    var _group;
    if (_groups) {
      for (var key2 in _groups) {
        _group = _groups[key2];
        if (rowIndex >= _group.startRow && rowIndex <= _group.endRow) {
          return _group;
        }
      }
    }
  }
  getGroupByKey(groupKey) {
    return this.groups[groupKey];
  }
  getContainer(rowIndex) {
    var group = this.getGroupByRowIndex(rowIndex);
    if (group) {
      return group.el;
    } else {
      return this.el;
    }
  }
  createGroup() {
    var groups = {}, newGrop;
    var groupCollection = this.extraLayout.groupCollection, startRow, endRow;
    for (let i = 0, len = groupCollection.length, group, groupCt; i < len; i++) {
      group = groupCollection[i];
      startRow = group.startRow;
      endRow = group.endRow;
      groupCt = YElement.buildFromVNode(h("div.group", {
        attrs: {
          _row: startRow,
          _col: group.x,
          startRow,
          endRow
        }
      }));
      groupCt.$addStyle("display", "grid");
      var _groupOut = YElement.buildFromVNode(h("div.group-out")).$appendTo(this.el);
      _groupOut.$appendStyles(new Map(Object.entries({
        "grid-row-start": startRow + 1,
        "grid-row-end": endRow + 1,
        "grid-column-start": 1,
        "grid-column-end": `span ${this.widths.length}`
      })));
      groupCt.$appendTo(_groupOut);
      if (startRow > 0) {
        _groupOut.$addStyle("padding-top", `${this.rowGap}px`);
        groupCt.$addStyle("padding-top", `${this.rowGap}px`);
      }
      var widths = this.widths, minWidths = this.minWidths, heights = this.heights.slice(startRow, endRow + 1), rowGap = this.rowGap || 0, columnGap = this.columnGap || 0;
      var _w = getSize(widths, minWidths, columnGap);
      var _h = getSize(heights, [], rowGap);
      var newHeights = this.heights;
      this.heights.forEach((height, index) => {
        if (index + 1 >= startRow && index + 1 <= endRow) {
          newHeights.splice(index, 1, "pref");
        }
      });
      this.el.$addStyle("grid-template-rows", getSize(newHeights, [], rowGap));
      groupCt.$addStyle("grid-template-rows", _h).$addStyle("grid-template-columns", _w).$addStyle("grid-column-gap", columnGap + "px");
      newGrop = {
        el: groupCt,
        startRow,
        endRow,
        heights
      };
      groups[group.key] = newGrop;
      this.renderCollapseControl(group, _groupOut);
    }
    this.groups = groups;
  }
  resetGroupStyle(groupKey, isAuto) {
    var group = this.groups[groupKey];
    var heights = group.heights, newHeights;
    if (!heights)
      return;
    if (isAuto) {
      newHeights = heights.map((item) => {
        item = "pref";
        return item;
      });
    } else {
      newHeights = heights;
    }
    group.el.$addStyle("grid-template-rows", getSize(newHeights, [], this.rowGap));
  }
  createLabel(group) {
    group.handle.y + 1;
    group.handle.x + 1;
    var el = YElement.buildFromVNode(h("div")).$addClass("ui-control ui-lbl ui-readonly group-lbl");
    var ct = YElement.buildFromVNode(h("div")).$addClass("yg_collapse erp-group-title").$appendTo(el);
    var span = YElement.buildFromVNode(h("span.iconfont")).$appendTo(ct);
    var expandedClass = "icon-jianhaoshouqi";
    var collapsedClass = "icon-jiahaozhankai";
    if (group.expanded) {
      span.$addClass(expandedClass);
    } else {
      span.$addClass(collapsedClass);
    }
    var lbl = YElement.buildFromVNode(h("label", group.caption)).$appendTo(ct);
    lbl.$addClass("yg_collapse_text");
    span.$click((e) => {
      var isExpanded = span.hasClass(expandedClass);
      if (isExpanded) {
        span.$removeClass(expandedClass).$addClass(collapsedClass);
      } else {
        span.$removeClass(collapsedClass).$addClass(expandedClass);
      }
      this.resetGroupStyle(group.key, isExpanded);
      this.updateGroupVisible(group.key, !isExpanded);
    });
    return el;
  }
  renderCollapseControl(control, container) {
    if (!this.el)
      return;
    var row = control.handle.y + 1;
    var col = control.handle.x + 1;
    var $cells = this.el.$find((vEl) => vEl.getAttr("_row") == row && vEl.getAttr("_col") == col);
    if (!$cells[0]) {
      var label = this.createLabel(control);
      if (control.handle.y != control.startRow) {
        var ct = YElement.buildFromVNode(h("div")).$appendTo(this.el);
        ct.$addStyle("grid-row-start", row);
        ct.$addStyle("grid-column-start", col);
        ct.$addStyle("_row", row);
        ct.$addStyle("_col", col);
        if (this.rowGap && row > 1) {
          ct.$addStyle("padding-top", this.rowGap + "px");
        }
        label.$appendTo(ct);
      } else {
        label.$prependTo(container);
      }
    }
  }
  updateAreaCollapse(groupKey, bCollapse) {
    if (!this.el)
      return;
    var customLayout = this.extraLayout;
    if (!customLayout)
      return;
    var groupItem = this.getGroupByKey(groupKey);
    if (!groupItem) {
      throw new Error("unknow groupkey:" + groupKey);
    }
    this.updateGroupVisible(groupItem.key, !bCollapse);
  }
  updateRowVisible(row, visible) {
    let vPanel = this.getContainer(row);
    vPanel.getChildElms().forEach((vCell, idx) => {
      if (vCell.getAttr("_row") == row) {
        if (visible) {
          vCell.$removeClass(CLS_AREA_CELL_COLLAPSED);
        } else {
          vCell.$addClass(CLS_AREA_CELL_COLLAPSED);
        }
      }
    });
  }
  updateGroupVisible(groupKey, visible) {
    var groupEl = this.getGroupByKey(groupKey).el;
    if (!groupEl)
      return;
    if (visible) {
      groupEl.$removeClass(CLS_AREA_CELL_COLLAPSED);
    } else {
      groupEl.$addClass(CLS_AREA_CELL_COLLAPSED);
    }
  }
  createHTML() {
    this.el.$addClass("ui-pnl").$addClass("ui-glpcss3");
    return this.el;
  }
  beforeRenderItem(c, target, layoutItem, index) {
    if (layoutItem.y >= 0) {
      target.$parent().$addStyle("padding-top", `${this.rowGap}px`);
    }
    if (layoutItem.x > 0) {
      target.$parent().$addStyle("padding-left", `${this.columnGap}px`);
    }
    c.setWidth("100%");
    c.setHeight("100%");
  }
  /**
   * 返回控件comp即将被render到的dom
   * @param comp
   * @param layoutItem comp在items中的index
   */
  getItemTarget(comp, layoutItem, index) {
    if (comp.container) {
      return comp.container;
    }
    var item, row, col, xSpan, ySpan;
    item = layoutItem;
    col = item.x;
    row = item.y;
    xSpan = item.xSpan || 1;
    ySpan = item.ySpan || 1;
    var cssText = /* @__PURE__ */ new Map([
      ["grid-row-start", row + 1],
      ["grid-column-start", col + 1]
    ]);
    if (ySpan > 1) {
      cssText.set("grid-row-end", row + ySpan + 1);
    }
    if (xSpan > 1) {
      cssText.set("grid-column-end", col + xSpan + 1);
    }
    var target = YElement.buildFromVNode(
      h("div", { attrs: { row, col }, class: { "overlay-grid": true } })
    );
    let parent, find;
    find = this.el.$find((el) => {
      return el.getHtmlTag() === "collapse" && el.getAttr("row") == row && el.getAttr("col") == col && el.getAttr("xSpan") == xSpan && el.getAttr("ySpan") == ySpan;
    });
    if (find.length > 0) {
      parent = find[0];
      target.$appendTo(parent);
    } else {
      let div = YElement.buildFromVNode(h("div", { attrs: { row, col } }));
      div.$appendStyles(cssText);
      target.$appendTo(div);
      div.$appendTo(this.el);
    }
    var ct = YElement.buildFromVNode(h("div"));
    ct.$appendTo(target);
    if (comp.cssClass.indexOf("overlays-control") >= 0) {
      target.$addClass("overlays-control");
    } else {
      target.$parent().$addClass("current");
    }
    comp.container = ct;
    return ct;
  }
  layoutRender() {
    var widths = this.widths, minWidths = this.minWidths, heights = this.heights;
    this.rowGap || 0;
    this.columnGap || 0;
    var w = getSize(widths, minWidths, 0);
    var h2 = getSize(heights, [], this.rowGap);
    this.el.$addStyle("grid-template-rows", h2).$addStyle("grid-template-columns", w);
    if (!widths || !heights) {
      throw new YIUI.ViewException(
        YIUI.ViewException.NO_WIDTH_OR_HEIGHT,
        YIUI.ViewException.formatMessage(YIUI.ViewException.NO_WIDTH_OR_HEIGHT)
      );
    }
    for (var i = 1; i <= heights.length; i++) {
      for (var j = 1; j <= widths.length; j++) {
        var cssText = /* @__PURE__ */ new Map([
          ["grid-row-start", i.toString()],
          ["grid-column-start", j.toString()]
        ]);
        var target = YElement.buildFromVNode(h("div", { attrs: { class: "overlay-grid ui-control" } }));
        let parent = YElement.buildFromVNode(h("div", { attrs: { row: i - 1, col: j - 1, class: "overlay-grid" } }));
        target.$appendTo(parent);
        let parent2 = YElement.buildFromVNode(h("div", { attrs: { row: i - 1, col: j - 1, class: "empty" } }));
        parent.$appendTo(parent2);
        parent2.$appendTo(this.el);
        parent2.$appendStyles(cssText);
      }
    }
    var items = this.layoutitems;
    this.renderOverlaysList(items, this.el);
    return;
  }
  afterRender() {
    super.afterRender();
  }
  updateVisible(item, overlay) {
    var _a, _b, _c, _d, _e, _f;
    let x = item.x, y = item.y, xSpan = item.xSpan || 1, ySpan = item.ySpan || 1;
    for (var i = 0; i < xSpan; i++) {
      for (var j = 0; j < ySpan; j++) {
        let map = overlay.gettdMap(x + i, y + j);
        let com = map.getCuurentSelectcom();
        let oldSelectcom = map.getOldSelectcom();
        com = this.getCom(com == null ? void 0 : com.key);
        oldSelectcom = this.getCom(oldSelectcom == null ? void 0 : oldSelectcom.key);
        if (!com) {
          map.overlaycontrols.forEach(
            (controle) => {
              var _a2, _b2;
              let xSpan2 = ((_a2 = controle.item) == null ? void 0 : _a2.xSpan) || 1;
              let ySpan2 = ((_b2 = controle.item) == null ? void 0 : _b2.ySpan) || 1;
              if (xSpan2 == 1 && ySpan2 == 1 && oldSelectcom.key != controle.com.key) {
                com = controle.com;
                map.cuurentSelectcom = com;
              }
            }
          );
        }
        if (oldSelectcom) {
          (_a = oldSelectcom.container.getElm()) == null ? void 0 : _a.classList.add("overlays-control");
          (_b = oldSelectcom.container.getElm()) == null ? void 0 : _b.parentNode.classList.add("overlays-control");
          (_c = oldSelectcom.container.getElm()) == null ? void 0 : _c.parentNode.parentNode.classList.remove("current");
        }
        if (com) {
          (_d = com.container.getElm()) == null ? void 0 : _d.classList.remove("overlays-control");
          (_e = com.container.getElm()) == null ? void 0 : _e.parentNode.classList.remove("overlays-control");
          (_f = com.container.getElm()) == null ? void 0 : _f.parentNode.parentNode.classList.add("current");
        }
      }
    }
  }
  renderOverlaysList(items, content) {
    let col, row, overlays, xSpan, ySpan, rowGap = this.rowGap || 0;
    if (items.length > 0) {
      overlays = ErpDesignerUI.getOverlays(this, this.getCom(0));
      if (!overlays) {
        overlays = ErpDesignerUI.addOverlays(this, this.getCom(0));
      }
      overlays.emptyMap();
    }
    for (var i = 0, len = items.length; i < len; i++) {
      let item = items[i];
      let com = this.getCom(i);
      col = item.x;
      row = item.y;
      xSpan = item.xSpan || 1;
      ySpan = item.ySpan || 1;
      for (let k = 0; k < xSpan; k++) {
        for (let j = 0; j < ySpan; j++) {
          let map = overlays.gettdMap(item.x + k, item.y + j);
          if (!map) {
            map = overlays.addtdMap(item.x + k, item.y + j);
          }
          if (!map.hasControl(com.key)) {
            map.addcontrol(com, item);
          }
          let emptyDiv = content.$find((el) => {
            var _a;
            return el.getAttr("row") == row + j && el.getAttr("col") == col + k && ((_a = el.getAttr("class")) == null ? void 0 : _a.indexOf("empty")) >= 0;
          });
          emptyDiv.forEach((el) => el.$remove());
          if (map.overlaycontrols.size > 1) {
            let collapse, find;
            find = content.$find((el) => {
              return el.getHtmlTag() === "collapse" && el.getAttr("row") == row + j && el.getAttr("col") == col + k && el.getAttr("xSpan") == 1 && el.getAttr("ySpan") == 1;
            });
            if (find.length == 0) {
              var cssText = /* @__PURE__ */ new Map([
                ["grid-row-start", row + 1],
                ["grid-column-start", col + 1]
              ]);
              collapse = YElement.buildFromVNode(h("collapse", { attrs: { row: row + j, col: col + k, xSpan: 1, ySpan: 1 } }));
              collapse.$appendStyles(cssText);
              collapse.$appendTo(content);
            } else {
              collapse = find[0];
            }
          }
        }
      }
      if (xSpan > 1 || ySpan > 1) {
        let collapse, find;
        find = content.$find((el) => {
          return el.getHtmlTag() === "collapse" && el.getAttr("row") == row && el.getAttr("col") == col && el.getAttr("xSpan") == xSpan && el.getAttr("ySpan") == ySpan;
        });
        if (find.length == 0) {
          let cssText2 = /* @__PURE__ */ new Map([
            ["grid-row-start", row + 1],
            ["grid-column-start", col + 1]
          ]);
          if (ySpan > 1) {
            cssText2.set("grid-row-end", row + ySpan + 1);
          }
          if (xSpan > 1) {
            cssText2.set("grid-column-end", col + xSpan + 1);
          }
          collapse = YElement.buildFromVNode(h("collapse", { attrs: { row, col, xSpan, ySpan } }));
          collapse.$appendStyles(cssText2);
          collapse.$appendTo(content);
        }
      }
    }
    let collapses = this.el.$findByTagName("collapse");
    collapses.forEach((collapse) => {
      let row2 = collapse.getAttr("row");
      let col2 = collapse.getAttr("col");
      let map = overlays.gettdMap(col2, row2);
      if ((map == null ? void 0 : map.overlaycontrols.size) > 1) {
        let btn = YElement.buildFromVNode(h("span", { attrs: { class: "iconfont icon-collapse_arrowdown control-overlays-btn" } })).$appendTo(collapse);
        let combox = YElement.buildFromVNode(h("div", { attrs: { class: "control-overlays" } })).$appendTo(collapse);
        if (row2 >= 0) {
          btn.$addStyle("top", rowGap - 15 + "px");
          combox.$addStyle("top", rowGap + "px");
          YElement.buildFromVNode(h("div", { attrs: { class: "control-overlays-head" } })).$setInnerText("控件切换").$appendTo(combox);
          let list = YElement.buildFromVNode(h("ul", { attrs: { class: "control-overlays-list" } })).$appendTo(combox);
          btn.$addListener("click", (e) => {
            var _a;
            e.stopPropagation();
            if (combox.hasClass("slidedown")) {
              list.getChildElms().forEach((el) => {
                el.$remove();
              });
              combox.$removeClass("slidedown");
            } else {
              let find = this.el.$find((el) => {
                return el.hasClass("slidedown");
              });
              find.forEach((combox2) => {
                let btn2 = combox2.$parent().$findByTagName("span", 2)[0];
                btn2 == null ? void 0 : btn2.getElm().click();
              });
              for (let [key2, val] of map.overlaycontrols.entries()) {
                let li = YElement.buildFromVNode(h("li")).$setInnerText(key2).$appendTo(list);
                if (key2 == ((_a = map.getCuurentSelectcom()) == null ? void 0 : _a.key)) {
                  li.$addClass("select");
                }
              }
              combox.$addClass("slidedown");
            }
          });
          list.$addListener("click", (e) => {
            e.stopPropagation();
            if (e.target.tagName !== "LI") {
              return;
            }
            let target = e.target;
            let key2 = target.innerText;
            let selectcom = map.getControl(key2);
            let comItem = map.getControlItem(key2);
            let cuurentSelectcom = map.getCuurentSelectcom();
            let cuurentSelectcomItem = map.getControlItem(cuurentSelectcom == null ? void 0 : cuurentSelectcom.key);
            if (key2 == cuurentSelectcom.key) {
              btn.getElm().click();
              return;
            } else {
              overlays.clearCurrentSelectcom(cuurentSelectcom, cuurentSelectcomItem);
              overlays.setCuurentSelectcom(selectcom, comItem);
              this.updateVisible(comItem, overlays);
              this.updateVisible(cuurentSelectcomItem, overlays);
            }
            btn.getElm().click();
          });
        }
      }
    });
    for (var i = 0, len = items.length; i < len; i++) {
      let com = this.getCom(i);
      let item = items[i];
      col = item.x;
      row = item.y;
      let tdMap = overlays.gettdMap(col, row);
      let cuurentSelectcom = tdMap.getCuurentSelectcom();
      if (!cuurentSelectcom) {
        let oldSelectcom = tdMap.getOldSelectcom();
        if (oldSelectcom && tdMap.hasControl(oldSelectcom.key)) {
          cuurentSelectcom = oldSelectcom;
          overlays.setCuurentSelectcom(oldSelectcom, tdMap.getControlItem(oldSelectcom.key));
        } else {
          cuurentSelectcom = com;
          overlays.setCuurentSelectcom(com, item);
        }
      }
      if (com.key != cuurentSelectcom.key) {
        com.cssClass = "overlays-control";
      }
    }
  }
}
class DesignYesGridPanelBuilder extends YesComponentBuilder {
  static create(options) {
    let form2 = FormStack.getForm(options.ofFormID);
    let renderType = ErpDesignerUI.gridLayoutRenderType;
    if (form2.formKey === "D_DesignTab_R" || form2.formKey.endsWith("_FormulaPopWin")) {
      return new DesignVGridLayoutCss3(options);
    }
    if (!renderType && DesignModeSetting.isDesignMode && form2.projectKey != "webconfig") {
      return new VDesignerGridLayoutCss3(options);
    }
    return new VGridLayout(options);
  }
}
class IndexedDBProxy {
  constructor(dbName) {
    this.dbName = dbName;
  }
  isOpen() {
    return this.db != null;
  }
  close() {
    this.db.close();
  }
  open(upgrade, version) {
    let self = this;
    const dbPromise = new Promise((resolve, reject) => {
      var request = indexedDB.open(self.dbName, version);
      if (upgrade) {
        request.onupgradeneeded = upgrade;
      }
      request.onsuccess = () => {
        ErpDesigner.DesignerFormulaCacheDB = request.result;
        ERPDESIGNER.DesignerFormulaCacheDB = ErpDesigner.DesignerFormulaCacheDB;
        self.db = request.result;
        resolve(self.db);
        console.log("indexdb open...");
      };
      request.onerror = (event) => {
        reject(event);
      };
    });
    return dbPromise;
  }
  _open() {
    var ret;
    if (this.db != null) {
      ret = $.Deferred(function(def) {
        return true;
      });
    } else {
      return this.opendb;
    }
    return ret;
  }
  _get(db, table, key2, tx) {
    return $.Deferred(function(def) {
      tx = tx || db.transaction(table, "readwrite");
      var store = tx.objectStore(table);
      var request = store.get(key2);
      request.onsuccess = function(e) {
        def.resolve(request.result);
      };
      request.onerror = def.reject;
    });
  }
  _getAll(db, table, tx) {
    return $.Deferred(function(def) {
      tx = tx || db.transaction(table, "readwrite");
      var store = tx.objectStore(table);
      var request = store.getAll();
      request.onsuccess = function(e) {
        def.resolve(request.result);
      };
      request.onerror = def.reject;
    });
  }
  _getByIndex(db, table, indexName, key2, tx) {
    return $.Deferred(function(def) {
      tx = tx || db.transaction(table, "readwrite");
      var store = tx.objectStore(table);
      var index = store.index(indexName);
      var request = index.get(IDBKeyRange.only(key2));
      request.onsuccess = function(e) {
        def.resolve(request.result);
      };
      request.onerror = def.reject;
    });
  }
  _put(db, table, value2, tx) {
    return $.Deferred(function(def) {
      tx = tx || db.transaction(table, "readwrite");
      var store = tx.objectStore(table);
      var request = store.put(value2);
      request.onsuccess = function() {
        def.resolve(request.result);
      };
      request.onerror = def.reject;
    });
  }
  _clear(db, table, tx) {
    return $.Deferred(function(def) {
      tx = tx || db.transaction(table, "readwrite");
      if (db.objectStoreNames.contains(table)) {
        var store = tx.objectStore(table);
        var request = store.clear();
        request.onsuccess = function() {
          console.log("clear ..." + this.dbName);
          def.resolve(request.result);
        };
        request.onerror = def.reject;
      }
    });
  }
  get(table, key2) {
    if (this.db != null) {
      return this._get(this.db, table, key2);
    }
    return this._open().then((def) => {
      return this._get(this.db, table, key2);
    });
  }
  getAll(table) {
    if (this.db != null) {
      return this._getAll(this.db, table);
    }
    return this._open().then((def) => {
      return this._getAll(this.db, table);
    });
  }
  getByIndex(table, indexName, key2) {
    if (this.db != null) {
      return this._getByIndex(this.db, table, indexName, key2);
    }
    return this._open().then((def) => {
      return this._getByIndex(this.db, table, indexName, key2);
    });
  }
  exists(table) {
    return this.db.objectStoreNames.contains(table);
  }
  put(table, value2) {
    if (this.db != null) {
      return this._put(this.db, table, value2);
    }
    return this._open().then((def) => {
      return this._put(this.db, table, value2);
    });
  }
  clear(table) {
    return this._clear(this.db, table);
  }
}
class ConfirmDialog {
  static createStyles() {
    const styleId = "confirm-dialog-styles";
    if (document.getElementById(styleId))
      return;
    const style = document.createElement("style");
    style.id = styleId;
    style.textContent = `
      .confirm-overlay {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.5);
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 10000;
        opacity: 0;
        animation: fadeIn 0.2s ease-out forwards;
        backdrop-filter: blur(4px);
      }
      
      @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
      }
      
      .confirm-dialog {
        background: white;
        border-radius: 12px;
        width: 90%;
        max-width: 420px;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
        transform: translateY(20px);
        animation: slideUp 0.3s cubic-bezier(0.2, 0, 0, 1) forwards;
        overflow: hidden;
      }
      
      @keyframes slideUp {
        from { transform: translateY(20px); }
        to { transform: translateY(0); }
      }
      
      .confirm-header {
        padding: 20px 24px 0;
        font-size: 18px;
        font-weight: 600;
        color: #333;
      }
      
      .confirm-body {
        padding: 20px 24px;
        color: #666;
        line-height: 1.5;
      }
      
      .confirm-footer {
        display: flex;
        padding: 16px 24px;
        justify-content: flex-end;
        gap: 12px;
        flex-wrap: wrap;
      }
      
      .confirm-button {
        padding: 10px 16px;
        border-radius: 6px;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.2s;
        border: none;
        min-width: 80px;
        flex: 1;
      }
      
      .confirm-button:hover {
        opacity: 0.9;
        transform: translateY(-1px);
      }
      
      .confirm-button:active {
        transform: translateY(0);
      }
      
      @media (max-width: 480px) {
        .confirm-footer {
          flex-direction: column;
        }
        
        .confirm-button {
          width: 100%;
        }
      }
    `;
    document.head.appendChild(style);
  }
  static show(options) {
    this.createStyles();
    const overlay = document.createElement("div");
    overlay.className = "confirm-overlay";
    const dialog = document.createElement("div");
    dialog.className = "confirm-dialog";
    dialog.innerHTML = `
      ${options.title ? `<div class="confirm-header">${options.title}</div>` : ""}
      <div class="confirm-body">${options.message}</div>
      <div class="confirm-footer">
        ${options.buttons.map((btn, index) => `
          <button 
            class="confirm-button" 
            style="background: ${btn.color || this.getDefaultColor(index)}"
            data-index="${index}"
          >
            ${btn.text}
          </button>
        `).join("")}
      </div>
    `;
    overlay.appendChild(dialog);
    document.body.appendChild(overlay);
    options.buttons.forEach((btn, index) => {
      const button = dialog.querySelector(`button[data-index="${index}"]`);
      button.addEventListener("click", () => {
        this.closeDialog(overlay);
        btn.handler();
      });
    });
    if (options.closeOnEsc !== false) {
      const handleKeyDown = (e) => {
        if (e.key === "Escape") {
          this.closeDialog(overlay);
        }
      };
      document.addEventListener("keydown", handleKeyDown);
      overlay.dataset.hasKeyListener = "true";
    }
    if (options.closeOnBackdropClick !== false) {
      overlay.addEventListener("click", (e) => {
        if (e.target === overlay) {
          this.closeDialog(overlay);
        }
      });
    }
  }
  static getDefaultColor(index) {
    const colors = ["#f5f5f5", "#2196F3", "#4CAF50"];
    return colors[index] || "#f5f5f5";
  }
  static closeDialog(overlay) {
    overlay.style.animation = "fadeOut 0.2s ease-out forwards";
    if (overlay.dataset.hasKeyListener) {
      document.removeEventListener("keydown", () => {
      });
    }
    overlay.addEventListener("animationend", () => {
      overlay.remove();
    }, { once: true });
    if (!document.getElementById("confirm-dialog-fadeout")) {
      const style = document.createElement("style");
      style.id = "confirm-dialog-fadeout";
      style.textContent = `
        @keyframes fadeOut {
          from { opacity: 1; }
          to { opacity: 0; }
        }
      `;
      document.head.appendChild(style);
    }
  }
}
class ElementSelector {
  // 新增：工具提示是否收起
  constructor(config = {}, document1 = document) {
    this.isActive = false;
    this.currentHighlighted = null;
    this.currentSelected = null;
    this.eventCallbacks = /* @__PURE__ */ new Map();
    this.isTooltipCollapsed = false;
    this.config = {
      highlightColor: "#4a6bdf",
      selectionColor: "#4caf50",
      tooltipBackground: "#333",
      tooltipTextColor: "white",
      enableAttributesTooltip: true,
      toolbarButtons: ["add", "delete", "edit"],
      excludeElements: ["script", "style", "link", "meta"],
      defaultCollapsed: false,
      // 默认不收起
      ...config
    };
    this.document = document1;
    this.isTooltipCollapsed = this.config.defaultCollapsed || false;
    const container = document.createElement("div");
    container.id = "element-selector-container";
    document.body.appendChild(container);
    this.shadowRoot = container.attachShadow({ mode: "open" });
    this.initStyles();
    this.initTooltip();
    this.handleMouseMove = this.handleMouseMove.bind(this);
  }
  // 初始化样式
  initStyles() {
    this.styleElement = document.createElement("style");
    this.styleElement.textContent = `
            .element-selector-tooltip {
                position: fixed;
                background: ${this.config.tooltipBackground};
                color: ${this.config.tooltipTextColor};
                padding: 10px 15px;
                border-radius: 6px;
                font-size: 13px;
                z-index: 10001;
                pointer-events: none;
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                max-width: 300px;
                transition: all 0.3s ease;
                opacity: 0;
                font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
                right: 10px;
                bottom: 10px;
            }
            
            .element-selector-tooltip.visible {
                opacity: 1;
                pointer-events: auto;
            }
            
            .element-selector-tooltip.collapsed {
                max-width: 150px;
                padding: 8px 12px;
            }
            
            .element-selector-tooltip-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
                margin-bottom: 8px;
                cursor: pointer;
            }
            
            .element-selector-tooltip-title {
                font-weight: 600;
                color: #4a6bdf;
                margin: 0;
            }
            
            .element-selector-tooltip-toggle {
                background: none;
                border: none;
                color: ${this.config.tooltipTextColor};
                cursor: pointer;
                font-size: 14px;
                padding: 2px 5px;
                border-radius: 3px;
            }
            
            .element-selector-tooltip-toggle:hover {
                background: rgba(255, 255, 255, 0.1);
            }
            
            .element-selector-tooltip-content {
                line-height: 1.5;
                transition: max-height 0.3s ease, opacity 0.3s ease;
                max-height: 500px;
                opacity: 1;
                overflow: hidden;
            }
            
            .element-selector-tooltip.collapsed .element-selector-tooltip-content {
                max-height: 0;
                opacity: 0;
                margin: 0;
            }
            
            .element-selector-tooltip-item {
                display: flex;
                margin-bottom: 3px;
            }
            
            .element-selector-tooltip-label {
                min-width: 70px;
                color: #aaa;
            }
            .element-selector-tooltip-value {
                flex: 1;
                color: white;
                word-break: break-word;
            }
            
            .element-selector-toolbar {
                position: fixed;
                display: flex;
                background: ${this.config.tooltipBackground};
                border-radius: 6px;
                padding: 5px;
                z-index: 10002;
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                opacity: 0;
                transform: translateY(-10px);
                transition: opacity 0.3s, transform 0.3s;
                pointer-events: none;
            }
            
            .element-selector-toolbar.visible {
                opacity: 1;
                transform: translateY(0);
                pointer-events: auto;
            }
            
            .element-selector-toolbar-button {
                background: none;
                border: none;
                color: ${this.config.tooltipTextColor};
                width: 32px;
                height: 32px;
                border-radius: 4px;
                display: flex;
                align-items: center;
                justify-content: center;
                cursor: pointer;
                margin: 0 3px;
                font-size: 16px;
            }
            
            .element-selector-toolbar-button:hover {
                background: rgba(255, 255, 255, 0.1);
            }
            
            .element-selector-toolbar-button.add::before {
                content: '+';
            }
            
            .element-selector-toolbar-button.delete::before {
                content: '×';
            }
            
            .element-selector-toolbar-button.edit::before {
                content: '✎';
            }
        `;
    this.shadowRoot.appendChild(this.styleElement);
  }
  // 初始化工具提示
  initTooltip() {
    if (!this.config.enableAttributesTooltip)
      return;
    this.tooltipElement = document.createElement("div");
    this.tooltipElement.className = "element-selector-tooltip";
    this.tooltipElement.innerHTML = `
            <div class="element-selector-tooltip-header">
                <div class="element-selector-tooltip-title">元素属性</div>
                <button class="element-selector-tooltip-toggle">−</button>
            </div>
            <div class="element-selector-tooltip-content">
                <div class="element-selector-tooltip-item">
                    <span class="element-selector-tooltip-label">Key:</span>
                    <span class="element-selector-tooltip-value" id="es-tt-meta-key">-</span>
                </div>
                <div class="element-selector-tooltip-item">
                    <span class="element-selector-tooltip-label">Caption:</span>
                    <span class="element-selector-tooltip-value" id="es-tt-caption">-</span>
                </div>
                <div class="element-selector-tooltip-item">
                    <span class="element-selector-tooltip-label">Type:</span>
                    <span class="element-selector-tooltip-value" id="es-tt-meta-type">-</span>
                </div>
            </div>
        `;
    const toggleButton = this.tooltipElement.querySelector(".element-selector-tooltip-toggle");
    if (toggleButton) {
      toggleButton.addEventListener("click", (e) => {
        e.stopPropagation();
        this.toggleTooltip();
      });
    }
    const header = this.tooltipElement.querySelector(".element-selector-tooltip-header");
    if (header) {
      header.addEventListener("click", (e) => {
        if (e.target === toggleButton)
          return;
        this.toggleTooltip();
      });
    }
    if (this.isTooltipCollapsed) {
      this.tooltipElement.classList.add("collapsed");
      const toggleBtn = this.tooltipElement.querySelector(".element-selector-tooltip-toggle");
      if (toggleBtn)
        toggleBtn.textContent = "+";
    }
    this.shadowRoot.appendChild(this.tooltipElement);
  }
  // 切换工具提示的收起/展开状态
  toggleTooltip() {
    this.isTooltipCollapsed = !this.isTooltipCollapsed;
    if (this.isTooltipCollapsed) {
      this.tooltipElement.classList.add("collapsed");
      const toggleBtn = this.tooltipElement.querySelector(".element-selector-tooltip-toggle");
      if (toggleBtn)
        toggleBtn.textContent = "+";
    } else {
      this.tooltipElement.classList.remove("collapsed");
      const toggleBtn = this.tooltipElement.querySelector(".element-selector-tooltip-toggle");
      if (toggleBtn)
        toggleBtn.textContent = "−";
    }
    this.triggerEvent("toggleTooltip", { collapsed: this.isTooltipCollapsed });
  }
  // 启动元素选择器
  start() {
    if (this.isActive)
      return;
    this.isActive = true;
    this.document.addEventListener("mousemove", this.handleMouseMove);
    this.triggerEvent("start");
  }
  // 停止元素选择器
  stop() {
    if (!this.isActive)
      return;
    this.isActive = false;
    this.document.removeEventListener("mousemove", this.handleMouseMove);
    if (this.currentHighlighted) {
      this.currentHighlighted.classList.remove("element-selector-highlighted");
      this.currentHighlighted = null;
    }
    if (this.currentSelected) {
      this.currentSelected.classList.remove("element-selector-selected");
      this.currentSelected = null;
    }
    if (this.tooltipElement) {
      this.tooltipElement.classList.remove("visible");
    }
    this.triggerEvent("stop");
  }
  // 处理鼠标移动事件
  handleMouseMove(e) {
    if (!this.isActive)
      return;
    let target = e.target;
    while (target && !target.getAttribute("meta-key") && target !== this.document.body) {
      if (!target.parentElement)
        break;
      target = target.parentElement;
    }
    if (this.shouldSkipElement(target)) {
      if (this.currentHighlighted) {
        this.currentHighlighted.classList.remove("element-selector-highlighted");
        this.currentHighlighted = null;
        if (this.tooltipElement) {
          this.tooltipElement.classList.remove("visible");
        }
      }
      return;
    }
    if (this.currentHighlighted && this.currentHighlighted !== target) {
      this.currentHighlighted.classList.remove("element-selector-highlighted");
    }
    if (target !== this.currentSelected) {
      target.classList.add("element-selector-highlighted");
      this.currentHighlighted = target;
      if (this.config.enableAttributesTooltip) {
        this.updateTooltip(target);
      }
    }
  }
  // 判断是否应该跳过元素
  shouldSkipElement(element) {
    var _a;
    if (!element || !element.getAttribute) {
      return true;
    }
    if (element.closest && element.closest("#element-selector-container")) {
      return true;
    }
    if ((_a = this.config.excludeElements) == null ? void 0 : _a.includes(element.tagName.toLowerCase())) {
      return true;
    }
    if (!element.getAttribute("meta-key") || element.getAttribute("meta-key") == "DesignerView" || element.getAttribute("meta-key") == "BodyContainer") {
      return true;
    }
    if (element === this.document.body || element === this.document.documentElement) {
      return true;
    }
    return false;
  }
  // 更新工具提示
  updateTooltip(element) {
    const key2 = this.shadowRoot.getElementById("es-tt-meta-key");
    const type = this.shadowRoot.getElementById("es-tt-meta-type");
    const caption = this.shadowRoot.getElementById("es-tt-caption");
    if (key2)
      key2.textContent = element.getAttribute("meta-key") || "无";
    if (type)
      type.textContent = element.getAttribute("meta-type") || "无";
    if (caption)
      caption.textContent = element.getAttribute("caption") || element.getAttribute("title") || "无";
    this.tooltipElement.classList.add("visible");
  }
  // 注册事件监听器
  on(event, callback) {
    if (!this.eventCallbacks.has(event)) {
      this.eventCallbacks.set(event, []);
    }
    this.eventCallbacks.get(event).push(callback);
  }
  // 触发事件
  triggerEvent(event, data) {
    const callbacks = this.eventCallbacks.get(event);
    if (callbacks) {
      callbacks.forEach((callback) => callback(data));
    }
  }
  // 获取当前选中的元素
  getSelectedElement() {
    return this.currentSelected;
  }
  // 切换工具提示状态（公开方法）
  toggleTooltipState() {
    this.toggleTooltip();
  }
  // 设置工具提示状态（公开方法）
  setTooltipState(collapsed) {
    if (this.isTooltipCollapsed !== collapsed) {
      this.toggleTooltip();
    }
  }
  // 获取工具提示状态（公开方法）
  getTooltipState() {
    return this.isTooltipCollapsed;
  }
  // 销毁实例
  destroy() {
    this.stop();
    const container = document.getElementById("element-selector-container");
    if (container) {
      document.body.removeChild(container);
    }
  }
}
class ErpDesignerEntry {
  loadScript() {
    return new Promise((resolve, reject) => {
      let script = document.createElement("script");
      script.type = "text/javascript";
      script.src = "/" + YIUI.webRoot + "lib/map/js/jquery-3.6.0.js";
      script.defer = true;
      script.async = false;
      script.onload = resolve;
      script.onerror = reject;
      document.head.appendChild(script);
    });
  }
  async getDesignerSettings() {
    ErpDesigner.url = ServletURL.replace("/servlet", "/");
    const designerSettings = await new Request().getData({}, ErpDesigner.url + "getProperties");
    await ErpDesignerService.SetEnvironmentRunType(1);
    ErpDesignerUI.showError = designerSettings.webdesignerShowError;
    ErpDesignerUI.webdesignerEnable = designerSettings.webdesignerEnable;
    ErpDesignerUI.xmlWordWrap = designerSettings.xmlWordWrap;
    ErpDesignerUI.delayedProcessScope = designerSettings.delayedProcessScope;
    ErpDesignerGlobal.xmlEditorFont = designerSettings.xmlEditorFont;
    ErpDesignerGlobal.initCacheID = designerSettings.initCacheID;
    ErpDesignerGlobal.xmlEditorFontSize = designerSettings.xmlEditorFontSize;
    ErpDesignerUI.reloadOnlyComment = designerSettings.reloadOnlyComment;
    ErpDesignerUI.fileTreeisDBClick = designerSettings.fileTreeRowClick;
    ErpDesignerUI.gridLayoutRenderType = designerSettings.renderType;
  }
  async initDesignSwitch() {
    if (window.Svr.Request.mode == 2 && DesignModeSetting.isDesignMode) {
      LoadingUtil.show();
      try {
        await this.loadScript();
        await this.initDesignUI();
        ErpDesignerGlobal.$from = $("#app");
        CompBuilder.reg(ControlType.COMBOBOX, new ComboBoxBuilderExt());
        CompBuilder.reg(ControlType.GRIDLAYOUTPANEL, new DesignGridLayoutPanelBuilder());
        ControlMapping.getInstance().reg(ControlType.GRIDLAYOUTPANEL, DesignYesGridPanelBuilder);
        ErpDesignerUI.designPanel = null;
        await this.loadDesignResources();
        ErpDesignerEntry.initFormula();
        ErpDesigner.showHiddenField();
        ErpDesigner.selectComponentByClick();
      } finally {
        ErpDesigner.canBeClosed = true;
        LoadingUtil.hide();
      }
      return;
    }
    const self = this;
    ErpDesignerEntry.waitForElementsReady(".nav-field-box.setting ul.nav-field-list", (elems) => {
      if (!elems || elems.length == 0) {
        return;
      }
      self.createDesignSwitch(elems[0]);
    });
  }
  static waitForElementsReady(selector, callback) {
    const startTime = (/* @__PURE__ */ new Date()).getTime();
    const waiting = function() {
      const isDocumentReady = document.readyState == "complete";
      const elems = isDocumentReady && document.querySelectorAll(selector);
      const isFind = elems && elems.length > 0;
      const timeout = (/* @__PURE__ */ new Date()).getTime() - startTime;
      if (isDocumentReady && (isFind || timeout > 1e4)) {
        callback.apply(window, [elems]);
      } else {
        setTimeout(waiting, 20);
      }
    };
    waiting();
  }
  async exitDesign() {
    CompBuilder.reg(ControlType.COMBOBOX, new ComboBoxBuilder());
    CompBuilder.reg(ControlType.GRIDLAYOUTPANEL, new GridLayoutPanelBuilder());
    ControlMapping.getInstance().reg(ControlType.GRIDLAYOUTPANEL, YesGridPanelBuilder);
    ControlMapping.getInstance().reg(ControlType.GRID, YesGridBuilderExt);
    await this.closeDesign();
    new MetaService().clear();
    await ErpDesignerService.SetEnvironmentRunType(1);
    LoadingUtil.hide();
    ErpDesigner.canBeClosed = false;
    ErpDesignerEntry.websocket && ErpDesignerEntry.websocket.close();
    ErpDesignerEntry.selector && ErpDesignerEntry.selector.destroy();
  }
  createDesignSwitch(target) {
    if (!target) {
      return;
    }
    let $designModeSwitch = document.getElementById("designSwitch");
    if (!$designModeSwitch) {
      $designModeSwitch = document.createElement("li");
      $designModeSwitch.id = "designSwitch";
      $designModeSwitch.classList.add("nav-field-items");
      $designModeSwitch.innerHTML = '<a class="designer" id="startDesign"><span>&#xE67A</span>' + I18N$1.getString("NAVIAGTION_DESIGNER", "设计") + "</a>";
      target.appendChild($designModeSwitch);
    }
    let switchToggleHandler = async () => {
      MainUIOptTracer.getInstance().traceOnClick(MainUIOptTracer.ClickType.NavigationClick, { isDesigner: true });
      if (DesignModeSetting.isDesignMode) {
        LoadingUtil.show();
        if (!ErpDesigner.canBeClosed) {
          setTimeout(() => {
            this.exitDesign();
          }, 1e3);
        } else {
          this.exitDesign();
        }
        return;
      }
      LoadingUtil.show(500);
      try {
        await this.initDesignUI();
        CompBuilder.reg(ControlType.COMBOBOX, new ComboBoxBuilderExt());
        CompBuilder.reg(ControlType.GRIDLAYOUTPANEL, new DesignGridLayoutPanelBuilder());
        ControlMapping.getInstance().reg(ControlType.GRIDLAYOUTPANEL, DesignYesGridPanelBuilder);
        ControlMapping.getInstance().reg(ControlType.GRID, DesignerYesGridBuilderExt);
        DesignModeSetting.isDesignMode = true;
        ErpDesignerUI.designPanel = null;
        await this.loadDesignResources();
        let form2 = ErpDesignerUI.getActiveERPForm();
        if (form2) {
          form2.diffs = [];
        }
        if (form2 && form2.dataObjectKey == "D_WEB") {
          await this.loadDesignDock("100%", "1px", "RightDesignPanelContainer", "horizontal");
        } else {
          await this.loadDesignDock("70%", "30%", "RightDesignPanelContainer", "horizontal");
        }
        ErpDesignerEntry.initFormula();
        ErpDesigner.showHiddenField();
        ErpDesignerEntry.selector = new ElementSelector({}, document.getElementsByClassName("mainWrap")[0]);
        ErpDesignerEntry.selector.start();
        ErpDesignerEntry.selector.on("select", (data) => {
          console.log("元素被选择:", data);
        });
        ErpDesigner.selectComponentByClick();
        await ErpDesigner.reloadActiveForm();
        var url = ErpDesigner.url.replace("http", "ws");
        ErpDesignerEntry.websocket = new WebSocket(url + "debugger");
        ErpDesignerEntry.websocket.onclose = (e) => {
          console.log(`连接关闭: code=${e.code}, reason=${e.reason}`);
        };
        ErpDesignerEntry.websocket.onmessage = (e) => {
          console.log(`收到消息：${e.data}`);
          if (e.data === "StartDebug") {
            let tabpanel = ErpDesignerUI.designPanel.getComponent("TabPanel1");
            tabpanel.setActiveTab("DebugTab");
            let cxt = new ViewContext(ErpDesignerUI.debugForm);
            ErpDesignerUI.debugForm.eval("Macro_LoadObject();", cxt).then(() => {
              ErpDesignerUI.debugForm.eval("RefreshDebuggerToolbar();HighlightDebugger();", cxt);
            });
          }
        };
        ErpDesignerEntry.websocket.onerror = (e) => {
          console.log("连接异常");
          console.error(e);
        };
        ErpDesignerEntry.websocket.onopen = (e) => {
          console.log("连接打开");
        };
      } finally {
        ErpDesigner.canBeClosed = true;
        LoadingUtil.hide();
      }
    };
    $designModeSwitch.removeEventListener("click", switchToggleHandler);
    $designModeSwitch.addEventListener("click", switchToggleHandler);
  }
  static async initFormula() {
    if (!ErpDesignerFuns.isInitDesigner) {
      await ErpDesignerEntry.initDesignCache();
    }
    var cxt = new ViewContext(ErpDesignerUI.DesignPanelform);
    var hasGetData = await ErpDesignerUtil.getDesignerTableCacheByTableName("DesignerFormulaCache")().get("hasGetData");
    if (!hasGetData) {
      await ErpDesignerFuns.getEditorFuncsData("macro", "D_DesignPanelForm", cxt, "", false, "DesignerFormulaCache");
      await ErpDesignerFuns.getEditorFuncsData("function", "D_DesignPanelForm", cxt, "", false, "DesignerFormulaCache");
    }
    await ErpDesignerFuns.getEditorFuncsData("form", "D_DesignPanelForm", cxt, "", false, "DesignerFormCache");
    await ErpDesignerFuns.addFormulaData(["DesignerFormulaCache"]);
    await ErpDesignerFuns.initXmlAttrData("DesignerXmlAttrCache");
  }
  async initDesignUI() {
    ErpDesignerUI.tipOptionMap = /* @__PURE__ */ new Map();
    ErpDesignerUI.tipOptionMap.set("success", { "position": "absolute", "padding": "3px 5px", "background": "#d1e7dd", "margin": "5 auto", "text-align": "center", "color": "#0f5132", "opacity": "0.8", "z-index": 999 });
    ErpDesignerUI.tipOptionMap.set("warning", { "position": "absolute", "padding": "3px 5px", "background": "#fff3cd", "margin": "5 auto", "text-align": "center", "color": "#664d03", "opacity": "0.8", "z-index": 999 });
    ErpDesignerUI.tipOptionMap.set("error", { "position": "absolute", "padding": "3px 5px", "background": "#eabe79", "margin": "5 auto", "text-align": "center", "color": "#ee1919", "opacity": "0.8", "z-index": 999 });
    this.addDesignCustomCss();
    await ErpDesignerEntry.initDesignCache();
    ErpDesignerGlobal.$from = $("#app .tabs-body");
  }
  addDesignCustomCss() {
    let sheets = document.styleSheets, styleSheet, relativePath = "";
    for (let i = 0, size = sheets.length; i < size; i++) {
      let sheet = sheets[i];
      if (!sheet)
        continue;
      if (sheet.href && sheet.href.indexOf("/core.css") >= 0) {
        styleSheet = sheets[i];
        break;
      }
      if (sheet.href && sheet.href.indexOf("/css/main.css") >= 0) {
        styleSheet = sheets[i];
        relativePath = "../";
        break;
      }
      if (sheet.href && sheet.href.indexOf("/css/mainh5") >= 0) {
        styleSheet = sheets[i];
        relativePath = "../";
        break;
      }
    }
    if (!styleSheet)
      return;
    styleSheet.addRule(".element-selector-highlighted", "outline: 2px solid #4caf50 !important; outline-offset: -3px; cursor: pointer;");
    styleSheet.addRule(".element-selector-selected", "outline: 2px solid #4caf50 !important; outline-offset: -3px;");
    styleSheet.addRule(".z_splitpanel .ui-spl", "overflow-y: auto !important;");
    styleSheet.addRule(".Y_designertoolbar ul.tbr-ul", "height: 25px ;line-height: 25px ");
    styleSheet.addRule(".Y_designertoolbar", "height: 25px !important; border: 0px !important; padding: 0 !important; ");
    styleSheet.addRule("div.selectedPoint", "background-color: white; position: absolute; width: 9px; height: 9px; border:1px solid #330099; border-radius: 4px;");
    styleSheet.addRule("div.selectedBorder", "cursor: move; position: absolute;");
    styleSheet.addRule(".selectedButton", "position: absolute; width: 25px; height: 25px; border:1px solid #330099");
    styleSheet.addRule("#buttonInsert", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsert:hover", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsert:active", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_click.png) center no-repeat;");
    styleSheet.addRule("#compositeComponentInsert", "background: url(" + relativePath + "images/erpdesigner/CompositeComponentInsert.png) center no-repeat;");
    styleSheet.addRule("#compositeComInsertToGrid", "background: url(" + relativePath + "images/erpdesigner/CompositeComponentInsert.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertBefore", "background: url(" + relativePath + "images/erpdesigner/datepicker_left_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertBefore:hover", "background: url(" + relativePath + "images/erpdesigner/datepicker_left_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertBefore:active", "background: url(" + relativePath + "images/erpdesigner/datepicker_left_click.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertBefore1", "background: url(" + relativePath + "images/erpdesigner/datepicker_left_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertBefore1:hover", "background: url(" + relativePath + "images/erpdesigner/datepicker_left_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertBefore1:active", "background: url(" + relativePath + "images/erpdesigner/datepicker_left_click.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertBefore2", "background: url(" + relativePath + "images/erpdesigner/datepicker_left_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertBefore2:hover", "background: url(" + relativePath + "images/erpdesigner/datepicker_left_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertBefore2:active", "background: url(" + relativePath + "images/erpdesigner/datepicker_left_click.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertAfter", "background: url(" + relativePath + "images/erpdesigner/datepicker_right_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertAfter:hover", "background: url(" + relativePath + "images/erpdesigner/datepicker_right_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertAfter:active", "background: url(" + relativePath + "images/erpdesigner/datepicker_right_click.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertAfter1", "background: url(" + relativePath + "images/erpdesigner/datepicker_right_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertAfter1:hover", "background: url(" + relativePath + "images/erpdesigner/datepicker_right_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertAfter1:active", "background: url(" + relativePath + "images/erpdesigner/datepicker_right_click.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertAfter2", "background: url(" + relativePath + "images/erpdesigner/datepicker_right_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertAfter2:hover", "background: url(" + relativePath + "images/erpdesigner/datepicker_right_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertAfter2:active", "background: url(" + relativePath + "images/erpdesigner/datepicker_right_click.png) center no-repeat;");
    styleSheet.addRule("#buttonQuote", "background: url(" + relativePath + "images/erpdesigner/D_Introduce_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonQuote:hover", "background: url(" + relativePath + "images/erpdesigner/D_Introduce_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonQuote:active", "background: url(" + relativePath + "images/erpdesigner/D_Introduce_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonQuoteBefore", "background: url(" + relativePath + "images/erpdesigner/D_Introduce_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonQuoteBefore:hover", "background: url(" + relativePath + "images/erpdesigner/D_Introduce_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonQuoteBefore:active", "background: url(" + relativePath + "images/erpdesigner/D_Introduce_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonQuoteAfter", "background: url(" + relativePath + "images/erpdesigner/D_Introduce_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonQuoteAfter:hover", "background: url(" + relativePath + "images/erpdesigner/D_Introduce_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonQuoteAfter:active", "background: url(" + relativePath + "images/erpdesigner/D_Introduce_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonPanQuote", "background: url(" + relativePath + "images/erpdesigner/D_Introduce_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonPanQuote:hover", "background: url(" + relativePath + "images/erpdesigner/D_Introduce_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonPanQuote:active", "background: url(" + relativePath + "images/erpdesigner/D_Introduce_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonSonRow", "background: url(" + relativePath + "images/erpdesigner/D_Grid_Child_Column.png) center no-repeat;");
    styleSheet.addRule("#buttonSonRow:hover", "background: url(" + relativePath + "images/erpdesigner/D_Grid_Child_Column.png) center no-repeat;");
    styleSheet.addRule("#buttonSonRow:active", "background: url(" + relativePath + "images/erpdesigner/D_Grid_Child_Column.png) center no-repeat;");
    styleSheet.addRule("#buttonNewRow", "background: url(" + relativePath + "images/erpdesigner/D_Grid_AddRow.png) center no-repeat;");
    styleSheet.addRule("#buttonNewRow:hover", "background: url(" + relativePath + "images/erpdesigner/D_Grid_AddRow.png) center no-repeat;");
    styleSheet.addRule("#buttonNewRow:active", "background: url(" + relativePath + "images/erpdesigner/D_Grid_AddRow.png) center no-repeat;");
    styleSheet.addRule("#buttonaddPanelRow", "background: url(" + relativePath + "images/erpdesigner/D_RowoPeration_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonaddPanelRow:hover", "background: url(" + relativePath + "images/erpdesigner/D_RowoPeration_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonaddPanelRow:active", "background: url(" + relativePath + "images/erpdesigner/D_RowoPeration_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonaddTableRow", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonaddTableRow:hover", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonaddTableRow:active", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_click.png) center no-repeat;");
    styleSheet.addRule("#buttonDeleteTableRow", "background: url(" + relativePath + "images/erpdesigner/Grid_delete_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonDeleteTableRow:hover", "background: url(" + relativePath + "images/erpdesigner/Grid_delete_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonDeleteTableRow:active", "background: url(" + relativePath + "images/erpdesigner/Grid_delete_hover.png) center no-repeat;");
    styleSheet.addRule("#addSelectComponent", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_hover.png) center no-repeat;");
    styleSheet.addRule("#addSelectComponent:hover", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_hover.png) center no-repeat;");
    styleSheet.addRule("#addSelectComponent:active", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_hover.png) center no-repeat;");
    styleSheet.addRule("#insertEmbed", "background: url(" + relativePath + "images/erpdesigner/D_Embed_hover.png) center no-repeat;");
    styleSheet.addRule("#insertEmbed:hover", "background: url(" + relativePath + "images/erpdesigner/D_Embed_hover.png) center no-repeat;");
    styleSheet.addRule("#insertEmbed:active", "background: url(" + relativePath + "images/erpdesigner/D_Embed_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonMultyDelete", "background: url(" + relativePath + "images/erpdesigner/Grid_delete_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonMultyDelete:hover", "background: url(" + relativePath + "images/erpdesigner/Grid_delete_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonMultyDelete:active", "background: url(" + relativePath + "images/erpdesigner/Grid_delete_click.png) center no-repeat;");
    styleSheet.addRule("#buttonDelete", "background: url(" + relativePath + "images/erpdesigner/Grid_delete_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonDelete:hover", "background: url(" + relativePath + "images/erpdesigner/Grid_delete_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonDelete:active", "background: url(" + relativePath + "images/erpdesigner/Grid_delete_click.png) center no-repeat;");
    styleSheet.addRule("#buttonDeleteRow", "background: url(" + relativePath + "images/erpdesigner/Grid_delete_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonDeleteRow:hover", "background: url(" + relativePath + "images/erpdesigner/Grid_delete_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonDeleteRow:active", "background: url(" + relativePath + "images/erpdesigner/Grid_delete_click.png) center no-repeat;");
    styleSheet.addRule("#buttonReplace", "background: url(" + relativePath + "images/erpdesigner/Grid_up_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonReplace:hover", "background: url(" + relativePath + "images/erpdesigner/Grid_up_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonReplace:active", "background: url(" + relativePath + "images/erpdesigner/Grid_up_click.png) center no-repeat;");
    styleSheet.addRule("#buttonOperation", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonOperation:hover", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonOperation:active", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_click.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertTabItem", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertTabItem:hover", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonInsertTabItem:active", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_click.png.png) center no-repeat;");
    styleSheet.addRule("#buttonMoveTabItemAfter", "background: url(" + relativePath + "images/erpdesigner/datepicker_right_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonMoveTabItemAfter:hover", "background: url(" + relativePath + "images/erpdesigner/datepicker_right_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonMoveTabItemAfter:active", "background: url(" + relativePath + "images/erpdesigner/datepicker_right_click.png) center no-repeat;");
    styleSheet.addRule("#buttonMoveTabItemFront", "background: url(" + relativePath + "images/erpdesigner/datepicker_left_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonMoveTabItemFront:hover", "background: url(" + relativePath + "images/erpdesigner/datepicker_left_hover.png) center no-repeat;");
    styleSheet.addRule("#buttonMoveTabItemFront:active", "background: url(" + relativePath + "images/erpdesigner/datepicker_left_click.png) center no-repeat;");
    styleSheet.addRule(".selectedPoint, .selectedBorder, .selectedButton", "display: none;");
    styleSheet.addRule(".designingForm .selectedPoint, .designingForm .selectedBorder, .designingForm .selectedButton", "display: block !important;");
    styleSheet.addRule(".handleAddClick", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_hover.png) center no-repeat;");
    styleSheet.addRule(".handleAddClick:hover", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_hover.png) center no-repeat;");
    styleSheet.addRule(".handleAddClick:active", "background: url(" + relativePath + "images/erpdesigner/Grid_icon_click.png) center no-repeat;");
    styleSheet.addRule(".handleAddClick", "margin-top:4px; height:32px; width:34px; border:1px solid #e6e6e6; border-top-right-radius:5px; border-top-left-radius:5px;");
    styleSheet.addRule(".newFormTabPanel .handleAddClick", "width: 15px; height: 15px");
    styleSheet.addRule(".designingForm .hoverLeft", "border-left: #33cdfa dotted 3px !important");
    styleSheet.addRule(".designingForm .hoverRight", "border-right: #33cdfa dotted 3px !important");
    styleSheet.addRule(".layui-btn", "cursor: pointer;\n    color: #fff;\n    background-color: #1E9FFF;\n    height: 22px;\n    padding: 0 5px;\n    line-height: 22px;");
    styleSheet.addRule(".designingForm .addPanel", "float: left; display: block;");
    styleSheet.addRule(".designingForm .ui-pnl div.ui-control .ui-hidden", "display: flex !important;");
    styleSheet.addRule(".designingForm .ui-pnl div.ui-control-out-grid", "display: flex !important;");
    styleSheet.addRule(".designingForm .ui-pnl div.ui-control-out-grid", "border:1px dashed #E0E0E0;");
    styleSheet.addRule(".designingForm .ui-pnl div.ui-control.ui-hidden label", "text-decoration: underline dashed !important;");
    styleSheet.addRule(".designingForm .ui-pnl div.ui-control.ui-hidden input", "text-decoration: underline dashed !important;");
    styleSheet.addRule(".designingForm .tab-body .ui-hidden", "display: flex !important;");
    styleSheet.addRule(".designingForm .tab-body .ui-fg", "display: grid !important;");
    styleSheet.addRule(".designingForm .tab-body .ui-hidden label", "text-decoration: underline dashed !important;");
    styleSheet.addRule(".designingForm .layout .ui-hidden", "display: flex !important;");
    styleSheet.addRule(".designingForm .layout .ui-hidden.innerLabel:before", "border-bottom: 1px dashed #606266");
    styleSheet.addRule(".designingForm .layout .ui-hidden.innerLabel:before", "top: -22px");
    styleSheet.addRule(".designingForm.tabs-body .ui-pnl, .designingForm .tab-body .ui-ygrid .ui-ygrid-bdiv", "overflow: auto !important;");
    styleSheet.addRule('.designingForm.tabs-body th[style*="display: none;"]', "display: table-cell !important;");
    styleSheet.addRule('.designingForm.tabs-body th[style*="display: none;"] > div', "text-decoration: underline dashed !important;");
    styleSheet.addRule('.designingForm.tabs-body col[style*="display:none;"]', "display: table-column !important;");
    styleSheet.addRule('.designingForm.tabs-body col[style*="display: none;"]', "display: table-column !important;");
    styleSheet.addRule('.designingForm.tabs-body td[style*="display:none;"]', "display: table-cell !important;");
    styleSheet.addRule('.designingForm.tabs-body td[style*="display: none;"]', "display: table-cell !important;");
    styleSheet.addRule(".designingForm.tabs-body .tbr-item", "display: block !important");
    styleSheet.addRule(".designingForm.tabs-body .tab-list li", "display: block !important");
    styleSheet.addRule('.designingForm.tabs-body li[style="display: none;"] > a > span', "text-decoration: underline dashed !important;");
    styleSheet.addRule(".designingForm.tabs-body .ui-hidden span", "color: #383838; text-decoration: underline dashed !important;");
    styleSheet.addRule('.designingForm.tabs-body .tab-list li[style="display: none;"]> a > label', "text-decoration: underline dashed !important; color: rgb(000, 000, 000) !important;");
    styleSheet.addRule(".designingForm table.layout > tr > td", "border-bottom:1px dashed #E0E0E0; border-right:1px dashed #E0E0E0;overflow:hidden");
    styleSheet.addRule(".designingForm div.ui-hidden", "display: block !important;");
    styleSheet.addRule("li.design_operation", "float: left !important;line-height: 25px !important;height: 25px !important;min-height:25px !important;margin:0 !important;");
    styleSheet.addRule("li.design_operation a .txt", "height: 16px; line-height: 16px; padding: 1px 6px;");
    styleSheet.addRule("li.design_operation .tbr-btn .icon", "top: 12px !important; left 8px !important;");
    styleSheet.addRule("div.Design_FlexGridLayoutPanel", "align-content: baseline !important;");
    styleSheet.addRule(".design_operation .quarantine", "display:none !important;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-tabpnl .tab-head", "height: 30px !important;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-tabpnl div.tab-body", "overflow: visible !important;");
    styleSheet.addRule(".RightDesignPanelContainer .txted-wrap", "width: 100% !important;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-tabpnl .tab-head .list", "height: 100% !important;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-tabpnl .tab-head .btn", "height: 25px !important;line-height: 25px !important;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-tabpnl .tab-head .next", "height: 25px !important;line-height: 25px !important;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-tabpnl .tab-head .zoom", "height: 25px !important;line-height: 25px !important;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-tabpnl .tab-head .prev", "height: 25px !important;line-height: 25px !important;");
    styleSheet.addRule(".RightDesignPanelContainer .list li", "line-height: 25px !important;height: 25px !important;min-height:25px !important;margin:0 !important;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-numed input", "padding-right:20px;");
    styleSheet.addRule('.RightDesignPanelContainer div[formkey="D_DesignPanel"] div.group-out:nth-of-type(n+2) div.group', "padding-top:0 !important;");
    styleSheet.addRule('div[formkey="D_SourceTab"] .wrap', "display: none !important;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-ygrid .ui-ygrid-header", "display: none;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-ygrid .ui-ygrid-view", "max-height: 200px; width:100% !important;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-ygrid .ui-ygrid-view", "overflow-x: hidden !important; top: -5px !important; height: 150px !important;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-ygrid .ui-ygrid-view .ui-ygrid-hdiv", "display: none;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-ygrid .ui-ygrid-view .ui-ygrid-bdiv table", "width:100% !important");
    styleSheet.addRule(".RightDesignPanelContainer .ui-ygrid .ui-ygrid-footer", "display: none;");
    styleSheet.addRule(".h-first .tabs-header", "width: 100% !important;");
    styleSheet.addRule(".h-first .tabs-body", "width: 100% !important;");
    styleSheet.addRule(".DesignerMenuAndFileTree .tab-head .list", "width: 100% !important;");
    styleSheet.addRule(".DesignerMenuAndFileTree .tab-body.top", "top: 26px !important;");
    styleSheet.addRule(".mainLeft", "height: 100%!important;");
    styleSheet.addRule(".DesignerMenuAndFileTree .tab-head", "height: 26px !important;");
    styleSheet.addRule(".DesignerMenuAndFileTree #listBox", "height: 100% !important;");
    styleSheet.addRule("#MenuTree", "height: 100% !important;display: flex !important;flex-direction: column !important;");
    styleSheet.addRule("#MenuTree .matchItems", "top: 41px !important;");
    styleSheet.addRule(".DesignerMenuAndFileTree .tab-head.top ul", "height: 25px !important;");
    styleSheet.addRule(".DesignerMenuAndFileTree .tab-head.top li", "height: 25px !important;;line-height: 25px !important;");
    styleSheet.addRule(".mainLeft div.errorinfo", "display: none;");
    styleSheet.addRule(".mainLeft .ui-ygrid .ui-ygrid-hdiv", "display: none;");
    styleSheet.addRule(".mainLeft .ui-ygrid .ui-ygrid-pager", "display: none;");
    styleSheet.addRule(".mainLeft .ui-ygrid .ui-ygrid-bdiv", "overflow-x: hidden !important; top: -2px !important;height:105% !important");
    styleSheet.addRule(".mainLeft .ui-ygrid .ui-ygrid-bdiv .ui-ygrid-btable", "width:100% !important");
    styleSheet.addRule(".mainLeft .tab-body.top", "position: absolute !important");
    styleSheet.addRule(".DesignerFileTree .layout", "width: inherit");
    styleSheet.addRule(".mainLeft .list", "width: inherit !important;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-tabpnl", "flex: none !important;");
    styleSheet.addRule(".RightDesignPanelContainer .list", "width: 100% !important;");
    styleSheet.addRule(".RightDesignPanelContainer .list.cover", "width: calc(100% - 110px) !important;");
    styleSheet.addRule(".RightDesignPanelContainer .head_zoom .list", "width: calc(100% - 40px) !important;");
    styleSheet.addRule(".RightDesignPanelContainer .head_zoom .list.cover", "width: calc(100% - 150px) !important;");
    styleSheet.addRule(".RightDesignPanelContainer div.errorinfo", "display: none;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-ygrid .ui-ygrid-hdiv", "display: none;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-ygrid .ui-ygrid-pager", "display: none;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-ygrid .ui-ygrid-view", "width:100% !important;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-ygrid .ui-ygrid-bdiv", "overflow-x: hidden !important; top: -10px !important; height: 150px !important;");
    styleSheet.addRule(".RightDesignPanelContainer .ui-ygrid .ui-ygrid-bdiv table", "width:100% !important");
    styleSheet.addRule(".RightDesignPanelContainer .ui-ygrid-view", "max-height: 160px;");
    styleSheet.addRule(".RightDesignPanelContainer .tab-head li span.ui-icon-close:after", 'content: "\\F178"; font-family: iconfont; font-size: 16px');
    styleSheet.addRule(".tipsClass span.ui-icon-close:after", 'content: "\\F178"; font-family: iconfont; font-size: 16px');
    styleSheet.addRule(".fileMatchItems", "position: absolute; width: auto; max-width: 800px; max-height: 500px; z-index: 111;  background-color: #fff; border: 1px solid #dadada; display: none; overflow: auto;");
    styleSheet.addRule(".fileMatchItems.open", "display: block;");
    styleSheet.addRule(".fileMatchItems li", "height: 25px; line-height: 25px; white-space: nowrap;");
    styleSheet.addRule(".fileMatchItems li a", "padding: 0 15px 0 10px; display: inline-flex; color: #74787a; overflow: hidden; text-overflow: ellipsis;");
    styleSheet.addRule(".fileMatchItems li a:hover, .fileMatchItems li.hover a", "background-color: #3797f0; color: #ffffff; cursor: pointer;");
    styleSheet.addRule(".designer .ui-ygrid tr.ygrow ", "width: 100%");
    styleSheet.addRule(".designer .ui-ygrid tr.ygrow td ", "flex: 1;border: none !important; font-size: 13px !important;");
    styleSheet.addRule(".designer .ui-ygrid tr.ygrow td:hover ", "background-color:#CCCCCC !important;");
    styleSheet.addRule(".WEBBPM", "width:1px !important ;display: none !important;");
    styleSheet.addRule(".MFormDesign", "width:1px !important ;display: none !important;");
    styleSheet.addRule(".DesignerFileTree .ui-ygrid tr.ygrow ", "width: 100%");
    styleSheet.addRule(".DesignerFileTree .ui-ygrid tr.ygrow td ", "flex: 1;border: none !important; font-size: 13px !important;");
    styleSheet.addRule(".DesignerFileTree .ui-ygrid tr.ygrow td:hover ", "background-color:#CCCCCC !important;");
    styleSheet.addRule(".DesignerFileTree .tab-body.top", "top: 41px !important;");
    styleSheet.addRule(".DesignerFileTree .ui-ygrid", "width:100% !important");
    styleSheet.addRule(".DesignerFileTree .ui-ygrid .ui-ygrid-view", "width:100% !important");
    styleSheet.addRule(".DesignerFileTree .ui-ygrid .ui-ygrid-view >div", "width:100% !important");
    styleSheet.addRule(".DesignerFileTree .ui-ygrid-view", "top:0px !important");
    styleSheet.addRule(".DesignerFileTree .ui-ygrid-header", "display: none;");
    styleSheet.addRule(".DesignerFileTree .ui-ygrid-btable", "width:100% !important");
    styleSheet.addRule(".DesignerFileTree .ui-ygrid-htable", "width:100% !important");
    styleSheet.addRule(".DesignerFileTree .ui-ygrid-htable .ui-th-column > div", "text-align: left;!important");
    styleSheet.addRule(".DesignerFileTree .ui-ygrid-hbox-ltr", "padding-right:0px !important");
    styleSheet.addRule(".DesignerFileTree .designertoolbar", "width:100% !important ;height: 20px;");
    styleSheet.addRule(".DesignerFileTree .designertoolbar .dp-btn", "display:none;!important");
    styleSheet.addRule(".DesignerFileTree .designertoolbarlist", "width:100% !important");
    styleSheet.addRule(".DesignerFileTree .designertoolbarlist li", "margin: 3px 3px 0px; !important;min-height: 20px !important;");
    styleSheet.addRule(".DesignerFileTree .designertoolbarlist li>a", "height:15px !important;min-height: 16px !important;");
    styleSheet.addRule(".DesignerFileTree .designertoolbarlist li>a .txt ", "height:15px !important;line-height: 16px !important;");
    styleSheet.addRule(".DesignerFileTree .tbr-ul.designertoolbarlist  .icon", "top: 2px !important;");
    styleSheet.addRule(".DesignerFileTree .designeFileTreeSearch", "width:100% !important");
    styleSheet.addRule(".DesignerFileTree .designeFileTreeSearch input", "width:100% !important");
    styleSheet.addRule(".RightDesignPanelContainer div[id$=SourceTab] div.innerLabel[id*=XMLEditor]:before", 'content:"" !important');
    styleSheet.addRule(".tabs-dropdown.slidedown", "position:absolute");
    styleSheet.addRule(".control-overlays ", "display:none;background:#ffffff;border:1px solid #e4e7ed");
    styleSheet.addRule(".control-overlays.slidedown", "display:block;z-index:101 ;animation : slidedown .3s forwards;position:absolute;right:5px;width:140px");
    styleSheet.addRule(".overlays", "position:relative");
    styleSheet.addRule(".control-overlays-btn", "position:absolute;right:5px; font-size:15px;z-index:99");
    styleSheet.addRule(".control-overlays-list li.select", "font-weight:500;color:var(--yigoBrandColor_Darken1, #6264a7)");
    styleSheet.addRule(".control-overlays-list li:hover", "background: #409eff; cursor: pointer");
    styleSheet.addRule(".control-overlays-list li", "font-size: 13px;height: 25px;line-height: 2.5rem;padding: 0 15px");
    styleSheet.addRule(".control-overlays-head", "border-bottom:1px solid #f0f0f0");
    styleSheet.addRule(".control-overlays-head", "font-size: 13px;height: 25px;line-height: 2.5rem;padding: 0 2px");
    styleSheet.addRule("tr td.overlays div.vnode.overlays-control", "display:none ; !important;");
    styleSheet.addRule(".ui-glpcss3", "display: grid; width: 100%;");
    styleSheet.addRule(".ui-glpcss3 .overlay-grid", "border-bottom: 1px dashed rgb(224, 224, 224);border-right: 1px dashed rgb(224, 224, 224);height: 100%;");
    styleSheet.addRule("collapse", "position:relative;display:none ;");
    styleSheet.addRule("collapse div.overlays-control", "display:none ; !important;");
    styleSheet.addRule(".ui-glpcss3>collapse", "display:none ;");
    styleSheet.addRule(".ui-glpcss3>div.empty", "display:block ;");
    styleSheet.addRule(".ui-glpcss3>div.current", "display:block ;");
    styleSheet.addRule(".ui-glpcss3>collapse.current", "display:block ;");
    styleSheet.addRule(".multySelect", "border: 2px dashed rgb(51,0,153) !important;");
    styleSheet.addRule(".multySelect", "cursor: move !important;");
    styleSheet.addRule(".DesignerFileTree .Y_SearchResultGrid .ygrid-cell .findInFileMatch", "background-color: rgba(234, 92, 0, 0.33);");
    styleSheet.addRule(".DesignerFileTree .Y_SearchResultGrid tr.ygfirstrow td:nth-child(3)", "width:100% !important");
    styleSheet.addRule(".DesignerFileTree .Y_SearchResultGrid", "min-width: 180px;");
    styleSheet.addRule(".DesignerFileTree .Y_SearchResultGrid tr.ygrow td", "border-right-color: #fff;border-bottom-color: #fff;");
    styleSheet.addRule("div.readonlycss .CodeMirror.cm-s-default.CodeMirror-wrap,div.readonlycss pre.CodeMirror-line", "background-color: whitesmoke;");
    styleSheet.addRule(".designingForm .ui-tbv .ui-tbview .ui-tbvbody .ui-tbvr", "border: 1px dashed rgb(224, 224, 224);");
    styleSheet.addRule(".designingForm .design-location", "z-index: 10");
    styleSheet.addRule(".designingForm .ui-control.ui-readonly", "pointer-events: unset");
    styleSheet.addRule(".ui-linear.KeyPanel", "overflow: visible");
    styleSheet.addRule('.RightDesignPanelContainer div[formkey="D_Breakpoint"]', "z-index: 20001;");
    styleSheet.addRule(".RightDesignPanelContainer .DebugTab_Container", "position: fixed; z-index: 20000;");
    styleSheet.addRule(".RightDesignPanelContainer .DebugTab_Container button", "background-color: unset !important; border: unset !important;");
    styleSheet.addRule(".RightDesignPanelContainer .DebugTab_Container tr.ygrow td:hover", "background-color: #f0f0f0 !important; color: unset !important;");
    styleSheet.addRule(".RightDesignPanelContainer .DebugTab_Container tr.ygrow td.ui-state-highlight, td.ui-cell-disabled.ui-state-highlight:hover", "background-color: #f0f0f0 !important; color: unset !important;");
    styleSheet.addRule('.RightDesignPanelContainer .DebugTab_Container div[meta-key="StackGrid"] tr.ygrow td.ui-state-highlight', "background-color: #eae4f7 !important;");
    styleSheet.addRule(".RightDesignPanelContainer .DebugTab_Container li.debugger_operation .quarantine", "display:none !important;");
    styleSheet.addRule(".RightDesignPanelContainer .DebugTab_Container li.debugger_operation a span.txt", "display:none !important;");
    styleSheet.addRule(".RightDesignPanelContainer .DebugTab_Container div.json-container", "background-color: #f0f0f0 !important;");
    styleSheet.addRule(".RightDesignPanelContainer .DebugTab_Container div.json-container .json-key", "margin-left: 0 !important; margin-right: 0 !important;");
    styleSheet.addRule(".RightDesignPanelContainer .DebugTab_Container div.json-container .empty-icon", "width: 0 !important;");
    styleSheet.addRule(".RightDesignPanelContainer .DebugTab_Container div.json-container .caret-icon", "width: unset !important; padding-right: 4px !important;");
    styleSheet.addRule(".RightDesignPanelContainer .DebugTab_Container div.ui-ygrid div.ui-ygrid-fhdiv", "border-right-width: 0 !important;");
    styleSheet.addRule(".RightDesignPanelContainer .DebugTab_Container div.ui-ygrid div.ui-ygrid-bdiv", "width: 2000px !important;");
    styleSheet.addRule(".RightDesignPanelContainer .DebugTab_Container div.ui-ygrid div.ui-ygrid-bdiv:hover", "overflow-x: scroll !important;");
    styleSheet.addRule('.RightDesignPanelContainer .DebugTab_Container td div[meta-key="AddButton"]', "position: fixed !important; right: 35px !important; left: unset !important;");
    styleSheet.addRule('.RightDesignPanelContainer .DebugTab_Container td div[meta-key="ClearButton"]', "position: fixed !important; right: 0 !important; left: unset !important;");
    styleSheet.addRule('.RightDesignPanelContainer .DebugTab_Container td[meta-key="BP_EditButton"]', "position: fixed !important; right: 35px !important; left: unset !important;");
    styleSheet.addRule('.RightDesignPanelContainer .DebugTab_Container td[meta-key="BP_DeleteButton"]', "position: fixed !important; right: 0px !important; left: unset !important;");
  }
  // 封装为异步函数
  static async getObjectStoreCount(databaseName) {
    return new Promise((resolve, reject) => {
      const TIMEOUT = 5e3;
      let isCompleted = false;
      let dbInstance = null;
      let request;
      const timeoutId = setTimeout(() => {
        var _a;
        if (!isCompleted) {
          isCompleted = true;
          try {
            if (dbInstance) {
              dbInstance.close();
            }
            (_a = request == null ? void 0 : request.abort) == null ? void 0 : _a.call(request);
          } catch (e) {
            console.warn("Abort error:", e);
          }
          reject(new Error(`Operation timed out after ${TIMEOUT}ms`));
        }
      }, TIMEOUT);
      try {
        request = indexedDB.open(databaseName);
        request.onsuccess = (event) => {
          if (isCompleted)
            return;
          isCompleted = true;
          clearTimeout(timeoutId);
          const db = event.target.result;
          dbInstance = db;
          try {
            const count = db.objectStoreNames;
            resolve(count);
          } finally {
            db.close();
          }
        };
        request.onerror = (event) => {
          if (isCompleted)
            return;
          isCompleted = true;
          clearTimeout(timeoutId);
          const error = event.target.error;
          reject(new Error(`Database error [${error == null ? void 0 : error.name}]: ${error == null ? void 0 : error.message}`));
        };
        request.onblocked = () => {
          if (isCompleted)
            return;
          isCompleted = true;
          clearTimeout(timeoutId);
          reject(new Error("Database blocked by other connections. Please close other tabs using this database."));
        };
        request.onupgradeneeded = (event) => {
          const db = event.target.result;
          dbInstance = db;
          db.close();
          if (!isCompleted) {
            isCompleted = true;
            clearTimeout(timeoutId);
            resolve(0);
          }
        };
      } catch (initialError) {
        isCompleted = true;
        clearTimeout(timeoutId);
        reject(new Error(`Initialization failed: ${initialError}`));
      }
    });
  }
  static async initDesignCache() {
    let res = await new Request().getData({}, ErpDesigner.url + "getFormulaKeys");
    ErpDesignerFuns.isInitDesigner = true;
    if (res) {
      var tables = res.FormulaKeys;
      let DB_NAME = "ERPDesignerCache", ESIGNER_FORMULA_TABLE_NAME = "DesignerFormulaCache", ESIGNER_SOURCE_TABLE_NAME = "DesignerSourceCache";
      tables.push("DesignerFormCache");
      tables.push("DesignerFormMetaCache");
      tables.push("DesignerFormTreeTableCache");
      tables.push("DesignerCacheID");
      tables.push("DesignerXmlAttrCache");
      ErpDesignerUI.IndexedDBTables = tables;
      let supportIndexedDB = "indexedDB" in window;
      if (supportIndexedDB) {
        console.log("support index db");
        ErpDesigner.upgrades = function(evt) {
          for (let i = 0, len = tables.length; i < len; i++) {
            ErpDesigner.upgrade(evt, tables[i]);
            ErpDesigner.indexedDBVersion = i;
          }
          console.debug("initDb.onupgradeneeded");
        };
        ErpDesigner.upgrade = function(evt, tableName) {
          if (evt.currentTarget.result.objectStoreNames.contains(tableName))
            ;
          else {
            let store = evt.currentTarget.result.createObjectStore(
              tableName,
              { keyPath: "key" }
            );
            store.createIndex("name", "key", { unique: true });
            console.debug("initDb.onupgradeneeded");
          }
        };
        ErpDesigner.indexedDB = new IndexedDBProxy(DB_NAME);
        await this.initializeDatabase(tables, DB_NAME, false);
      }
      ErpDesigner.DesignerTableCaches.put(ESIGNER_SOURCE_TABLE_NAME, ErpDesigner.DesignerSourceCache);
      let designerFormulaCache;
      ErpDesigner.DesignerFormulaCache = function() {
        if (!designerFormulaCache) {
          designerFormulaCache = {
            get: function(key2) {
              return this.getCache().get(key2);
            },
            put: function(key2, doc) {
              return this.getCache().put(key2, doc);
            },
            getCache: function() {
              if (this.cache) {
                return this.cache;
              }
              if (ErpDesigner.indexedDB && ErpDesigner.indexedDB.isOpen()) {
                this.cache = new IndexedDBCache(ESIGNER_FORMULA_TABLE_NAME);
              } else {
                this.cache = new TempCache(30);
              }
              return this.cache;
            }
          };
        }
        return designerFormulaCache;
      };
      ErpDesigner.DesignerTableCaches.put(ESIGNER_FORMULA_TABLE_NAME, ErpDesigner.DesignerFormulaCache);
    } else {
      return false;
    }
  }
  static async initializeDatabase(EXCLUDE_TABLES, DB_NAME, up) {
    const shouldClearTable = (table) => {
      return table !== "DesignerFormulaCache" && table !== "DesignerCacheID" && table !== "DesignerFormMetaCache" && table !== "DesignerFormTreeTableCache" && !table.includes("FormFieldTreeCache");
    };
    const clearDatabase = async (db2, tables) => {
      await Promise.all(tables.map(async (table) => {
        if (!ErpDesigner.indexedDB.exists(table))
          return;
        if (shouldClearTable(table)) {
          await ErpDesigner.indexedDB.clear(table);
        } else {
          const cache = ErpDesignerUtil.getDesignerTableCacheByTableName("DesignerCacheID")();
          const initCacheID = await cache.get("initCacheID");
          if (initCacheID !== ErpDesignerGlobal.initCacheID) {
            const tablesToClear = [
              "DesignerFormMetaCache",
              "DesignerFormTreeTableCache",
              "DesignerCacheID",
              "DesignerFormulaCache",
              ...table.includes("FormFieldTreeCache") ? [table] : []
            ];
            await Promise.all(tablesToClear.map((t) => ErpDesigner.indexedDB.clear(t)));
            await cache.put("initCacheID", ErpDesignerGlobal.initCacheID);
          }
        }
      }));
    };
    try {
      var db;
      if (!up) {
        var l = await this.getObjectStoreCount("ERPDesignerCache");
        if (l != 0) {
          for (let i = 0; i < l.length; i++) {
            if (!EXCLUDE_TABLES.includes(l[i])) {
              EXCLUDE_TABLES.push(l[i]);
            }
          }
        }
        if (ErpDesigner.indexedDB.isOpen()) {
          ErpDesigner.indexedDB.close();
        }
        db = await ErpDesigner.indexedDB.open(ErpDesigner.upgrades, EXCLUDE_TABLES.length);
        await clearDatabase(db, EXCLUDE_TABLES);
      } else {
        if (ErpDesigner.indexedDB.isOpen()) {
          ErpDesigner.indexedDB.close();
        }
        db = await ErpDesigner.indexedDB.open(ErpDesigner.upgrades, EXCLUDE_TABLES.length);
      }
      await new Promise((resolve, reject) => {
        const deleteRequest = indexedDB.deleteDatabase("YigoDictDB");
        deleteRequest.onsuccess = () => resolve();
        deleteRequest.onerror = (e) => reject(e.target.error);
      });
    } catch (error) {
      console.error("Database initialization failed:", error);
      try {
        await new Promise((resolve, reject) => {
          const deleteRequest = indexedDB.deleteDatabase(DB_NAME);
          deleteRequest.onsuccess = () => resolve();
          deleteRequest.onerror = (e) => reject(e.target.error);
        });
        const retryDb = await ErpDesigner.indexedDB.open(ErpDesigner.upgrades, EXCLUDE_TABLES.length);
        await clearDatabase(retryDb, EXCLUDE_TABLES);
        await new Promise((resolve, reject) => {
          const deleteRequest = indexedDB.deleteDatabase("YigoDictDB");
          deleteRequest.onsuccess = () => resolve();
          deleteRequest.onerror = (e) => reject(e.target.error);
        });
      } catch (retryError) {
        console.error("Retry failed:", retryError);
        throw retryError;
      }
    }
  }
  static async newDBY(tableName) {
    ErpDesignerUI.IndexedDBTables.push(tableName);
    var l = await this.getObjectStoreCount("ERPDesignerCache");
    if (l != 0) {
      for (let i = 0; i < l.length; i++) {
        if (!ErpDesignerUI.IndexedDBTables.includes(l[i])) {
          ErpDesignerUI.IndexedDBTables.push(l[i]);
        }
      }
    }
    await this.initializeDatabase(ErpDesignerUI.IndexedDBTables, "ERPDesignerCache", true);
  }
  async closeDesign() {
    let hasEdited = false;
    for (let [filePath, tmp] of ErpDesignerSrc.openedXmls) {
      if (tmp.component && ErpDesignerSrc.hasEdited(tmp)) {
        hasEdited = true;
        break;
      }
    }
    if (!hasEdited) {
      $("#closemenu").css("z-index", "1");
      ErpDesignerEntry.emptyDesignData();
      ErpDesignerEntry.hideDesignPanel();
      ErpDesigner.hideHiddenField();
      DesignModeSetting.isDesignMode = false;
      await ErpDesigner.reloadActiveForm();
      $(".DesignResources").remove();
      return;
    }
    ConfirmDialog.show({
      title: "信息",
      message: "你有修改并未保存的表单是否继续退出设计器?",
      closeOnBackdropClick: false,
      buttons: [
        { text: "直接退出", color: "#FFC107", handler: () => ErpDesignerEntry.exitDirectly() },
        { text: "保存并退出", color: "#4CAF50", handler: () => ErpDesignerEntry.exitSave() },
        { text: "取消", handler: () => function() {
          return;
        }() }
      ]
    });
  }
  static async exitDirectly() {
    LoadingUtil.show();
    ErpDesignerEntry.emptyDesignData();
    ErpDesignerEntry.hideDesignPanel();
    ErpDesigner.hideHiddenField();
    DesignModeSetting.isDesignMode = false;
    await ErpDesigner.reloadActiveForm();
    ErpDesignerUI.showTip("退出后,下次进入时将保留上一次的修改内容", "info");
    LoadingUtil.hide();
    $(".DesignResources").remove();
    return;
  }
  static async exitSave() {
    LoadingUtil.show();
    let params = { cmd: "SaveFilesCmd", service: "DesignService" };
    let uiCommands = await new Request().getData(params);
    if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
      LoadingUtil.hide();
      return;
    }
    ErpDesignerEntry.emptyDesignData();
    ErpDesignerEntry.hideDesignPanel();
    ErpDesigner.hideHiddenField();
    DesignModeSetting.isDesignMode = false;
    await ErpDesigner.reloadActiveForm();
    ErpDesigner.selectedComponentKey = null;
    let activeForm = ErpDesignerUI.getActiveERPForm();
    await ErpDesignerUI.doUICommands(activeForm, uiCommands);
    await ErpDesigner.resetFormOperationStatus(ErpDesignerUI.DesignActionForm[1]);
    await ErpDesigner.resetFormOperationStatus(ErpDesignerUI.DesignActionForm[0]);
    setTimeout(function() {
      ErpDesigner.hideSelectedBorder();
    }, 500);
    for (let [openedXmlKey, openedXml] of ErpDesignerSrc.openedXmls) {
      ErpDesignerSrc.hasEdited(openedXml) && await processOpenedXmlAfterSave(openedXml);
    }
    ErpDesignerUI.showTip("保存成功", "success");
    LoadingUtil.hide();
    $(".DesignResources").remove();
    return;
    async function processOpenedXmlAfterSave(openedXml) {
      openedXml.xmlEditor.clearHistory();
      openedXml.isNew = false;
      openedXml.isEditBeforeLoad = false;
      await ErpDesigner.updateActiveXmlCaption(openedXml);
      for (let diffs = ErpDesignerUI.diffs, i = 0, size = diffs.length; i < size; i++) {
        let diff = diffs[i];
        if (diff.filePath == openedXml.filePath) {
          diffs.splice(i, 1);
          size--;
          i--;
        }
      }
    }
  }
  async loadDesignResources() {
    let head = document.getElementsByTagName("head")[0];
    let cssArr = [
      "lib/map/codemirror/lib/codemirror.css",
      "lib/map/codemirror/theme/dracula.css",
      "lib/map/codemirror/addon/fold/foldgutter.css",
      "lib/map/codemirror/addon/hint/show-hint.css",
      "lib/map/codemirror/addon/lint/lint.css",
      "lib/map/codemirror/addon/hover/text-hover.css",
      "lib/map/codemirror/theme/material.css",
      "lib/map/codemirror/addon/dialog/dialog.css",
      "lib/map/codemirror/addon/scroll/simplescrollbars.css",
      "lib/map/codemirror/addon/search/matchesonscrollbar.css"
    ];
    for (let index = 0; index < cssArr.length; index++) {
      let link = document.createElement("link");
      link.href = "/" + YIUI.webRoot + cssArr[index];
      link.rel = "stylesheet";
      link.type = "text/css";
      $(link).addClass("DesignResources");
      head.appendChild(link);
    }
    let jsArr = [
      "lib/map/codemirror/lib/codemirror.js",
      "lib/map/codemirror/mode/clike/clike.js",
      "lib/map/codemirror/mode/javascript/javascript.js",
      "lib/map/codemirror/mode/sql/sql.js",
      "lib/map/codemirror/addon/fold/foldcode.js",
      "lib/map/codemirror/addon/fold/foldgutter.js",
      "lib/map/codemirror/addon/fold/brace-fold.js",
      "lib/map/codemirror/addon/fold/comment-fold.js",
      "lib/map/codemirror/addon/hint/show-hint.js",
      "lib/map/codemirror/addon/hint/sql-hint.js",
      "lib/map/codemirror/addon/hint/javascript-hint.js",
      "lib/map/codemirror/addon/hint/anyword-hint.js",
      "lib/map/codemirror/addon/hint/function-hint.js",
      "lib/map/codemirror/addon/edit/matchbrackets.js",
      "lib/map/codemirror/addon/edit/closebrackets.js",
      "lib/map/codemirror/addon/edit/closetag.js",
      "lib/map/codemirror/addon/selection/active-line.js",
      "lib/map/codemirror/mode/yigo/yigo.js",
      "lib/map/codemirror/mode/markdown/markdown.js",
      "lib/map/codemirror/addon/lint/lint.js",
      "lib/map/codemirror/addon/hover/text-hover.js",
      "lib/map/codemirror/addon/hover/token-hover.js",
      "lib/map/codemirror/addon/dialog/dialog.js",
      "lib/map/codemirror/addon/scroll/simplescrollbars.js",
      "lib/map/codemirror/addon/selection/active-line.js",
      "lib/map/codemirror/mode/xml/xml.js",
      "lib/map/codemirror/addon/fold/xml-fold.js",
      "lib/map/codemirror/addon/search/search.js",
      "lib/map/codemirror/addon/search/searchcursor.js",
      "lib/map/codemirror/addon/search/jump-to-line.js",
      "lib/map/codemirror/addon/search/matchesonscrollbar.js",
      "lib/map/codemirror/addon/search/match-highlighter.js",
      "lib/map/codemirror/addon/scroll/annotatescrollbar.js",
      "lib/map/codemirror/addon/display/autorefresh.js",
      "lib/map/js/jQueryExt.js"
    ];
    for (let index = 0; index < jsArr.length; index++) {
      await new Promise((resolve, reject) => {
        let script = document.createElement("script");
        script.type = "text/javascript";
        script.src = "/" + YIUI.webRoot + jsArr[index];
        script.defer = true;
        script.async = false;
        script.onload = resolve;
        script.onerror = reject;
        $(script).addClass("DesignResources");
        head.appendChild(script);
      });
    }
  }
  async loadDesignDock(leftSize, rightSize, rightClassName, orientation) {
    if (ErpDesignerUI.webdesignerEnable == null)
      return;
    let res = await new Request(null).getData({}, ErpDesigner.url + "getProperties");
    if (!res || !res.webdesignerEnable)
      return;
    await ErpDesignerService.SetEnvironmentRunType(2);
    ErpDesignerUI.showError = res.webdesignerShowError;
    if (ErpDesignerUI.designPanel) {
      $("#closemenu").css("z-index", "1");
      ErpDesigner.addAddPanel();
      return;
    }
    ErpDesignerUI.DesignAction = null;
    let builder = new FormBuilder("D_DesignPanelForm");
    builder.setContainer(new DesignerContainer());
    builder.setOperationState(OperationState.DEFAULT);
    let designPanelform = await ErpDesignerService.getDesignerFormCache("D_DesignPanelForm");
    await builder.build(designPanelform);
    let designDock = designPanelform.getComponent("Main_DesignContainer");
    designDock.items[0].getEl().addPostpatchHook(() => {
      var els = designDock.getEl().$findByClassName("spl-item", 2);
      var first = els[0];
      var second = els[1];
      first.$addStyle("flex-grow", "unset").$addStyle("flex-basis", "unset");
      second.$addStyle("flex-grow", "unset").$addStyle("flex-basis", "unset");
      $("div.wrapper").appendTo($('div[id$="BodyContainer"]'));
      designDock.items[1].items = [];
      let el = $(designDock.getEl().getElm());
      sessionStorage.setItem("id", el[0].id);
      el.addClass("z_splitpanel");
      designDock.items[0].hasLayout = true;
      designDock.items[1].hasLayout = true;
      designDock.items[0].doLayout = function(width, height) {
        $(window).resize();
      };
      let leftEl = $(designDock.items[1].getEl().getElm());
      leftEl.addClass(rightClassName).addClass("designer");
      let body = $(document.body);
      ErpDesignerUI.split.doDesigerLayout(body.width(), body.height());
    });
    ErpDesignerUI.split = designDock;
    ErpDesignerUI.split.doDesigerLayout = function(width, height) {
      ErpDesignerUI.split.doLayout(width, height);
    };
    let designMenuFileTab = await this.getDesignMenuFileTab();
    designMenuFileTab.setHeight("100%");
    ErpDesignerUI.D_SourceFileTreeTabs = designMenuFileTab;
    this.renderDesignMenuFileTab(designMenuFileTab);
    ErpDesignerUI.D_SourceFileTreeTabs.setStyle("DesignerMenuAndFileTree");
    let fileTreeContainer = designMenuFileTab.items[1];
    let fileTreePanel = await this.loadDesignFileTree(fileTreeContainer);
    ErpDesignerUI.D_FileTree = fileTreePanel;
    await this.loadDesignRightTab(designPanelform.getComponent("DesignPanelContainer"));
    let searchBox = fileTreePanel.getComponent("SearchBox");
    this.installSearchBoxEvent(searchBox);
    $("#closemenu").css("z-index", "1");
    ErpDesigner.addAddPanel();
    ErpDesignerUI.DesignPanelform = designPanelform;
  }
  async getDesignMenuFileTab() {
    let noopForm = await ErpDesignerService.getMetaDesignerForm("D_NoopForm", !ErpDesignerUI.delayedProcessScope, void 0, void 0);
    let menuFileTabOpts = {
      key: "DesignerMenuAndFileTree",
      width: "inherit",
      type: ControlType.TABPANEL,
      items: [
        {
          key: "DesignerMenuTree",
          caption: "菜单",
          type: ControlType.FLEXFLOWLAYOUTPANEL,
          layout: { type: LayoutType.AUTO, items: [] },
          items: []
        },
        { key: "DesignerFileTree", caption: "文件树", type: ControlType.CONTAINER, width: "100%" }
        // ,
        // { key: "DesignerSearch", caption: '搜索', type: ControlType.CONTAINER, width: '100%' }
      ],
      layout: {
        type: LayoutType.TAB,
        items: [
          {
            key: "DesignerMenuTree",
            caption: "菜单",
            type: ControlType.FLEXFLOWLAYOUTPANEL,
            layout: { type: LayoutType.AUTO, items: [] },
            items: []
          },
          { key: "DesignerFileTree", caption: "文件树", type: ControlType.CONTAINER, width: "100%" }
          // ,
          // { key: "DesignerSearch", caption: '搜索', type: ControlType.CONTAINER, width: '100%' }
        ]
      }
    };
    let menuFileTabBuilder = CompBuilder.get(ControlType.TABPANEL);
    return menuFileTabBuilder.build(noopForm, menuFileTabOpts);
  }
  renderDesignMenuFileTab(designMenuFileTab) {
    let $div2 = $("<div></div>").appendTo($(document.body));
    let com = ControlMapping.getInstance().get(designMenuFileTab);
    designMenuFileTab.setYesCom(com);
    designMenuFileTab.render($div2);
    $(".menutoggle").before($div2);
    let leftCtID = designMenuFileTab.id;
    sessionStorage.setItem("leftCtID", leftCtID);
    let $menuTree = $("<div id='MenuTree'></div>");
    $(".searchBox").appendTo($menuTree);
    $(".matchItems").appendTo($menuTree);
    $(".appItems").appendTo($menuTree);
    $("#listBox").appendTo($menuTree);
    let el0 = $(designMenuFileTab.items[0].getEl().getElm());
    let el1 = $(designMenuFileTab.items[1].getEl().getElm());
    $menuTree.appendTo(el0);
    el1.addClass("DesignerFileTree");
  }
  async loadDesignFileTree(container) {
    let builder = new FormBuilder("D_FileTree");
    builder.setContainer(container);
    builder.setOperationState(OperationState.DEFAULT);
    let fileTreeForm = await ErpDesignerService.getDesignerFormCache("D_FileTree");
    await builder.build(fileTreeForm);
    return fileTreeForm;
  }
  /** 添加搜索表单 */
  async loadDesignFileSearchView(container) {
    let builder = new FormBuilder("D_SourceTabSearch");
    builder.setContainer(container);
    builder.setOperationState(OperationState.DEFAULT);
    let searchForm = await ErpDesignerService.getDesignerFormCache("D_SourceTabSearch");
    await builder.build(searchForm);
    return searchForm;
  }
  async loadDesignRightTab(designPanelContainer) {
    let builder = new FormBuilder("D_DesignPanel");
    builder.setContainer(designPanelContainer);
    builder.setOperationState(OperationState.DEFAULT);
    let designPanel = await ErpDesignerService.getDesignerFormCache("D_DesignPanel");
    ErpDesignerUI.designPanel = designPanel;
    designPanel.getComponent("SourceTab").checkNeedRender = ErpDesigner.checkTabItemNeedRender(designPanel.getComponent("SourceTab"));
    designPanel.regEvent(FormEvent.CLOSE, function() {
      ErpDesignerUI.designPanel = null;
      ErpDesignerUI.propertyForm = null;
    });
    designPanel.regEvent(FormEvent.SHOWDOCUMENT, async (eventType, currentForm) => {
      let comp = currentForm.formAdapt.getComp("DesignTab");
      if (!comp.rendered) {
        comp.visible = true;
        let tab = currentForm.getComponent("TabPanel1");
        let oldActiveTab = tab.getActiveTab();
        await tab.setActiveTab("DesignTab");
        tab.setActiveTab(oldActiveTab);
      }
      ErpDesignerUI.propertyContainer = await this.loadDesignGraphForm(comp, currentForm);
      ErpDesignerUI.sourceForm = await this.loadDesignSourceForm(designPanel.formAdapt.getComp("SourceTab"), designPanel);
      ErpDesignerUI.preferences = await this.loadPreferencesForm(designPanel.formAdapt.getComp("PreferencesTab"), designPanel);
      ErpDesignerUI.debugForm = await this.loadDebugTabForm(designPanel.formAdapt.getComp("DebugTab"), designPanel);
      let activeForm = ErpDesignerUI.getActiveERPForm();
      if (activeForm) {
        let formKey = activeForm.formKey, caption = activeForm.caption;
        let tds = ErpDesignerUI.propertyContainer.impl.el.$findByTagName("td");
        for (let index = 0; index < tds.length; index++) {
          const td = tds[index];
          if (td.getAttr("title") == formKey + " " + caption) {
            td.$call("mousedown").$call("mouseup").$call("click");
            break;
          }
        }
      }
    });
    return await builder.build(designPanel);
  }
  async loadDesignGraphForm(container, parentForm) {
    let builder = new FormBuilder("D_DesignTab_R");
    builder.setContainer(container);
    builder.setParentForm(parentForm);
    builder.setOperationState(OperationState.DEFAULT);
    let graphForm = await ErpDesignerService.getDesignerFormCache("D_DesignTab_R");
    graphForm.getComponent("SplitPanel").layoutItems[1].size = $("body").height() - 70 - 200 - 150 + "px";
    graphForm.getComponent("SplitPanel").splitSizes[1].size = $("body").height() - 70 - 200 - 150 + "px";
    let activeForm = ErpDesignerUI.getActiveERPForm();
    if (activeForm) {
      if (activeForm.entryParas && activeForm.getDefContainer() && activeForm.paras.map.FormKey) {
        graphForm.setPara("ContainerKey", activeForm.paras.map.FormKey);
      } else {
        graphForm.setPara("ContainerKey", null);
      }
      graphForm.setPara("OwnerFormKey", activeForm.getFormKey());
    }
    let grid = graphForm.getComponent("Grid1");
    grid.onSetWidth_run = grid.onSetWidth;
    grid.onSetWidth = function(width) {
      this.onSetWidth_run(width);
      let $grid = this.getEl(), $uiygrid = $grid.closest(".ui-ygrid");
      let idx = graphForm.getCellLocation("Name").column;
      $grid.$table[0].grid.headers[idx].newWidth = $uiygrid.width() - 20;
      $grid.$table[0].grid.resizing = { idx };
      $grid.$table[0].grid.dragEnd();
    };
    grid.onSetHeight = function(height) {
    };
    return await builder.build(graphForm);
  }
  async loadDesignSourceForm(container, parentForm) {
    let builder = new FormBuilder("D_SourceTab");
    builder.setContainer(container);
    builder.setParentForm(parentForm);
    builder.setOperationState(OperationState.DEFAULT);
    let sourceTab = await ErpDesignerService.getDesignerFormCache("D_SourceTab");
    ErpDesignerUI.sourceForm = sourceTab;
    let activeForm = ErpDesignerUI.getActiveERPForm();
    if (activeForm) {
      sourceTab.setPara("OwnerFormKey", activeForm.getFormKey());
      if (activeForm.entryParas && activeForm.getDefContainer() && activeForm.paras.map.FormKey) {
        sourceTab.setPara("ContainerKey", activeForm.paras.map.FormKey);
      } else {
        sourceTab.setPara("ContainerKey", null);
      }
    }
    return await builder.build(sourceTab);
  }
  async loadDebugTabForm(container, parentForm) {
    let builder = new FormBuilder("D_DebugTab");
    builder.setContainer(container);
    builder.setParentForm(parentForm);
    builder.setOperationState(OperationState.DEFAULT);
    let debugTab = await ErpDesignerService.getDesignerFormCache("D_DebugTab");
    return await builder.build(debugTab);
  }
  async loadPreferencesForm(container, parentForm) {
    let builder = new FormBuilder("D_PreferencesTab");
    builder.setContainer(container);
    builder.setParentForm(parentForm);
    builder.setOperationState(OperationState.DEFAULT);
    let preferencesTab = await ErpDesignerService.getDesignerFormCache("D_PreferencesTab");
    ErpDesignerUI.preferences = preferencesTab;
    let activeForm = ErpDesignerUI.getActiveERPForm();
    if (activeForm) {
      preferencesTab.setPara("OwnerFormKey", activeForm.getFormKey());
      if (activeForm.entryParas && activeForm.getDefContainer() && activeForm.paras.map.FormKey) {
        preferencesTab.setPara("ContainerKey", activeForm.paras.map.FormKey);
      } else {
        preferencesTab.setPara("ContainerKey", null);
      }
    }
    return await builder.build(preferencesTab);
  }
  installSearchBoxEvent(searchtext) {
    let index = -1;
    let $searchtext = searchtext.getEl().getElm();
    $($searchtext).addClass("designeFileTreeSearch");
    let fileMatchItems = document.createElement("div");
    let top = $searchtext.getBoundingClientRect().bottom;
    fileMatchItems.style.top = top + "px";
    let ul = document.createElement("ul");
    $(fileMatchItems).addClass("fileMatchItems");
    fileMatchItems.appendChild(ul);
    $("body").append(fileMatchItems);
    $($searchtext).focusin(async (e) => {
      ErpDesignerEntry.showSearchResult();
    });
    searchtext.getEl().$addListener(
      "input",
      function(e) {
        clearTimeout(ErpDesignerEntry.timer);
        ErpDesignerEntry.timer = setTimeout(async function() {
          index = await ErpDesignerEntry.search(e, searchtext, index);
        }, 300);
      }
    );
    $($searchtext).bind("keydown", (e) => {
      let keyCode = e.keyCode;
      let $view = $(".fileMatchItems ul");
      let maxLen = $("li", $view).length;
      if (maxLen === 0)
        return;
      if (keyCode === 38) {
        index--;
        if (index === -1)
          index = maxLen - 1;
      } else if (keyCode === 40) {
        index++;
        if (index === maxLen)
          index = 0;
      } else if (keyCode === 9 || keyCode === 13 || keyCode === 108) {
        if (keyCode === 9) {
          $(document).mousedown();
        } else if (keyCode === 13) {
          $("li.hover a", $view).click();
          e.stopPropagation();
        }
        e.preventDefault();
      } else {
        return;
      }
      if (index === -1)
        return;
      $(".fileMatchItems li").removeClass("hover");
      let _li = $(".fileMatchItems li").eq(index);
      _li.addClass("hover");
    });
    $(".fileMatchItems").delegate(".item", "click", async function() {
      let path = $(this).data("path");
      let form2 = ErpDesignerUI.D_FileTree, grid = form2.getComponent("Grid1");
      let $grid = grid.getEl();
      let rowCount = grid.getRowCount();
      if (rowCount <= 0) {
        return;
      }
      if (!$grid) {
        return;
      }
      ErpDesignerUI.D_FileTree.getComponent("Grid1").getEl();
      ErpDesignerEntry.hideSearchResult();
      await ErpDesignerEntry.openMatchItem(path);
      await grid.getForm().getUIProcess().resetComponentStatus(grid);
    });
    $(document).on("mousedown", function(e) {
      let target = $(e.target);
      if (target.closest($(".fileMatchItems")).length === 0 && target.closest($(".searchBox .search")).length === 0 && target.closest($(".searchBox .searchtext")).length === 0) {
        ErpDesignerEntry.hideSearchResult();
      }
    });
  }
  static async openMatchItem(path) {
    let params = { cmd: "LoadNodeAttrByPath", service: "DesignService", path };
    let attr = await new Request().getData(params);
    let form2 = ErpDesignerUI.D_FileTree;
    let cxt = new ViewContext(form2);
    await form2.asyncEval(attr.FocusRowChangedFormula);
    let args = [attr.OID, attr.Key, attr.ParentKey, attr.Description, attr.Type, attr.IsInJar];
    if (attr.Type != "") {
      await OpenChase(null, "OpenChase", cxt, args);
    }
    await form2.asyncEval("ResetFormOperation()");
  }
  static async search(e, searchtext, index) {
    let keyCode = e.keyCode;
    if (keyCode === 38 || keyCode === 40 || keyCode === 13)
      return;
    let flag = await this.searchBoxFilter(searchtext);
    if (flag)
      index = -1;
    return index;
  }
  static async searchBoxFilter(searchtext) {
    let searchValue = $(searchtext.getEl().getElm()).find("input").val();
    if (!searchValue) {
      $(".fileMatchItems ul").children().remove();
      ErpDesignerEntry.hideSearchResult();
      return false;
    }
    let params = { cmd: "SearchFilePath", service: "DesignService", search: searchValue, maxCount: 40 };
    var fileMatchItems = await new Request().getData(params);
    $(".fileMatchItems ul").children().remove();
    let searchValueSplit = searchValue.trim().split(/\s+/);
    searchValueSplit = searchValueSplit.filter((item, index, arr) => {
      return arr.indexOf(item) === index;
    });
    for (let i = 0; fileMatchItems && i < fileMatchItems.length; i++) {
      let _li = $("<li></li>");
      try {
        let textSplit = fileMatchItems[i].text.split(/[\\/]/g);
        let myMap = /* @__PURE__ */ new Map();
        let a = 0;
        searchValueSplit.forEach(function(word) {
          let regex = new RegExp("(" + ErpDesignerEntry.escapeRegExp(word) + ")", "gi");
          textSplit[0] = textSplit[0].replace(regex, function(match) {
            let result = '<span style="float: left;color: blue">' + ErpDesignerEntry.escapeHtml(match) + "</span>";
            let temp = "@" + a + "@";
            myMap.set(temp, result);
            a = a + 1;
            return temp;
          });
        });
        for (let j = 0; j < a; j++) {
          let temp = "@" + j + "@";
          textSplit[0] = textSplit[0].replace(temp, myMap.get(temp));
        }
        textSplit[1] = '<span style="float: left;color: red">' + textSplit[1] + "</span>";
        let otherText = "\\";
        for (let j = 0; j < textSplit.length; j++) {
          if (j > 1) {
            if (j == textSplit.length - 1) {
              otherText = otherText + textSplit[j];
            } else {
              otherText = otherText + textSplit[j] + "\\";
            }
          }
        }
        otherText = '<span style="float: left">' + otherText + "</span>";
        let innerHtml = textSplit[0] + '<span style="float: left">\\</span>' + textSplit[1] + otherText;
        let _a = $("<a></a>");
        _a.addClass("item").data("path", fileMatchItems[i].path).html(innerHtml);
        _a.contents().each((index, element) => {
          if (element.nodeType === Node.TEXT_NODE && element.nodeValue.trim() !== "") {
            var $span = $("<span>").text(element.nodeValue.trim()).css({ "float": "left" });
            $(element).replaceWith($span);
          }
        });
        _a.appendTo(_li);
      } catch (e) {
        $("<a></a>").addClass("item").text(fileMatchItems[i].text).data("path", fileMatchItems[i].path).appendTo(_li);
      }
      _li.appendTo($(".fileMatchItems ul"));
    }
    if (fileMatchItems && fileMatchItems.length > 0) {
      ErpDesignerEntry.showSearchResult();
    } else {
      ErpDesignerEntry.hideSearchResult();
    }
    return true;
  }
  // 正则特殊字符转义，防止输入的内容含有特殊字符
  static escapeRegExp(text) {
    return text.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
  }
  // 防止XXS影响dom结构
  static escapeHtml(str) {
    const replacements = {
      "&": "&amp;",
      "<": "&lt;",
      ">": "&gt;",
      '"': "&quot;",
      "'": "&#039;"
      // 或者使用 '&apos;'，但并非所有浏览器都支持
    };
    return str.replace(/[&<>"']/g, (match) => replacements[match]);
  }
  static showSearchResult() {
    $(".fileMatchItems").addClass("open");
  }
  static hideSearchResult() {
    $(".fileMatchItems").removeClass("open");
  }
  static hideDesignPanel() {
    ErpDesignerHelper.ResetSelectedBorder();
    let leftCtID = sessionStorage.getItem("leftCtID");
    $("#" + leftCtID).before($(".searchBox"));
    $("#" + leftCtID).before($(".matchItems"));
    $("#" + leftCtID).before($(".appItems"));
    $("#" + leftCtID).before($("#listBox"));
    $("#" + leftCtID).remove();
    $(".nav").appendTo($(".wrapper"));
    $(".main").appendTo($(".wrapper"));
    $(".wrapper").prependTo($(document.body));
    $('div[formkey="D_DesignPanelForm"]').remove();
    $(".tbr-dpvw").remove();
    $(".cmb-vw").remove();
    $(".cmb-autovw").remove();
    let id = sessionStorage.getItem("id");
    if (id)
      $("#" + id).remove();
    else
      $(".z_splitpanel").remove();
    ErpDesignerUI.designPanel = null;
    ErpDesignerUI.sourceForm = null;
    ErpDesignerUI.D_FileTree = null;
    ErpDesignerUI.D_SourceFileTreeTabs = null;
    ErpDesignerUI.propertyContainer = null;
    ErpDesignerUI.propertyForm = null;
    $(window).trigger("resize");
  }
  static emptyDesignData() {
    let host = window.location.host;
    if (host.indexOf("localhost") < 0 && host.indexOf("127.0.0.1") < 0)
      return;
    for (let key2 in sessionStorage) {
      if (key2.indexOf("isClose") !== key2.length - 7)
        continue;
      sessionStorage.removeItem(key2);
    }
    ErpDesignerSrc.formDependXMLs = /* @__PURE__ */ new Map();
    ErpDesignerSrc.openedXmls = /* @__PURE__ */ new Map();
    ErpDesignerUI.DesignActionForm = [];
    ErpDesignerUI.xmlEditor = null;
    ErpDesigner.selectedFormKey = null;
    ErpDesigner.selectedComponentKey = null;
    ErpDesigner.selectComponentKey = null;
    ErpDesigner.selectedType = null;
    ErpDesigner.selectedGridTrIndex = null;
    ErpDesigner.selectedComponentKeyInRun = null;
    ErpDesigner.selectedTypeInRun = null;
    ErpDesigner.selectedGridTrIndexInRun = null;
    ErpDesigner.selectedComponentKeyInDesign = null;
    ErpDesigner.selectedComponentKeyInSource = null;
    ErpDesigner.selectedTypeInSource = null;
    ErpDesignerUI.split = null;
    ErpDesignerUI.selectNode = null;
    ErpDesignerGlobal.$from.unbind("mouseup").unbind("mousedown");
    for (let i = 0; i < FormStack.getFormList().length; i++) {
      let form2 = FormStack.getFormList()[i];
      if (form2.formKey.indexOf("D_") >= 0 && form2.projectKey === "webconfig") {
        form2.getRoot().destroy();
      }
    }
  }
}
const designerEditProperty = [
  "Visible",
  "DefaultValue",
  "Enable",
  "DefaultFormulaValue",
  "OnLoad",
  "ValueChanged",
  "Formula",
  "FormulaItems",
  "ItemChanged",
  "FormulaAbbrCaption",
  "RowInsert",
  "RowDelete",
  "RowClick",
  "RowDblClick",
  "FocusRowChanged",
  "OnClick",
  "KeyEnter",
  "Action",
  "CheckRule",
  "OnPostShow",
  "FormulaCaption",
  "ValueDependency",
  "ErrorInfo"
];
const enableProperty = ["Visible", "DefaultValue", "Enable", "Formula", "ValueDependency", "FormulaCaption", "ErrorInfo", "FormulaAbbrCaption"];
const disabledProperty = ["OnLoad", "OnPostShow", "KeyEnter", "OnClick", "FormulaItems", "Action", "OnRowDelete", "RowDelete", "RowClick", "RowDblClick", "RowInsert", "DefaultFormulaValue", "CheckRule", "ItemChanged", "ValueChanged", "FocusRowChanged", "RowExpand"];
class CodeMirrorUtil {
  static isDesignerEditProperty(key2) {
    return designerEditProperty.includes(key2);
  }
  static isEnableProperty(key2) {
    return enableProperty.includes(key2);
  }
  static isDisabledProperty(key2) {
    return disabledProperty.includes(key2);
  }
  static getForumlaOption(seft) {
    let option;
    if (seft.userdata == "XMLEditor") {
      option = {
        mode: "text/xml",
        lineNumbers: true,
        lineWrapping: ErpDesignerUI.xmlWordWrap,
        scrollbarStyle: "simple",
        styleActiveLine: true,
        readOnly: seft.enable,
        extraKeys: {
          "Ctrl-Q": function(cm) {
            cm.foldCode(cm.getCursor());
          },
          "Ctrl-F": function() {
            ErpDesignerUI.xmlEditor.execCommand("findPersistent");
          },
          "Shift-Ctrl-/": function(cm) {
            var Selections = cm.getSelections();
            for (let i = 0; i < Selections.length; i++) {
              let origin = Selections[i];
              let note = "<!-- " + origin + "-->";
              if (origin.indexOf("<!--") >= 0) {
                origin = origin.replaceAll("<!--", "").replaceAll("-->", "");
                cm.replaceSelection(origin);
              } else {
                cm.replaceSelection(note);
              }
            }
          },
          "Ctrl-/": function(cm) {
            let origin = cm.getLine(cm.getCursor().line);
            let note = "<!-- " + cm.getLine(cm.getCursor().line) + "-->";
            if (origin.indexOf("<!--") >= 0) {
              origin = origin.replaceAll("<!--", "").replaceAll("-->", "");
              cm.replaceRange(
                origin,
                { ch: 0, line: cm.getCursor().line },
                { ch: cm.getCursor().ch, line: cm.getCursor().line },
                null
              );
            } else {
              cm.replaceRange(
                note,
                { ch: 0, line: cm.getCursor().line },
                { ch: origin.length, line: cm.getCursor().line },
                null
              );
            }
          },
          "Ctrl-Alt-L": function(cm) {
            cm.replaceSelection(ErpDesignerSrc.formateXml(cm.getSelection()));
          },
          "Ctrl-F1": function(cm) {
            ErpDesignerSrc.loadUsages(cm);
          }
        },
        foldGutter: true,
        gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter"],
        methods: {}
      };
    } else if (seft.userdata == "FormulaEditor") {
      option = {
        indentWithTabs: true,
        smartIndent: true,
        styleActiveLine: true,
        lineNumbers: true,
        lineWrapping: true,
        matchBrackets: true,
        textWrapping: true,
        autoCloseTags: true,
        //自动关闭tag
        autoCloseBrackets: true,
        //自动括号
        foldGutter: true,
        autoRefresh: true,
        readOnly: seft.enable,
        gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter", "CodeMirror-lint-markers"],
        mode: "text/x-yigo",
        // mode: {name: "javascript", globalVars: true},
        extraKeys: {
          "Tab": "autocomplete",
          "F11": function(cm) {
            cm.setOption("fullScreen", !cm.getOption("fullScreen"));
          },
          "Esc": function(cm) {
            if (cm.getOption("fullScreen"))
              cm.setOption("fullScreen", false);
          }
        },
        textHover: true
      };
    } else {
      option = {
        mode: "text/xml",
        lineNumbers: true,
        lineWrapping: true,
        //换行
        gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter"],
        readOnly: seft.enable,
        foldGutter: true,
        styleActiveLine: true
      };
    }
    return option;
  }
  static async setYigoFnKw(codemirror) {
    let yigoFnKw = await ErpDesignerUtil.getKeyWordsFromBackend();
    codemirror.setOption("yigoFnKw", yigoFnKw);
  }
}
const { GetValue, LoadData, SetValue: SetValue$1 } = DataFun;
const { Close } = UIFun;
const { UICheck } = OptFun;
const afterSetFunctionTable = async function(evl, name, cxt, args) {
  LoadingUtil.show();
  let gridKey = args[0];
  cxt.form.getComponent(gridKey);
  LoadingUtil.hide();
};
const loadFormulaDataSource = async function(evl, name, cxt, args) {
  if (!ErpDesignerFuns.isInitDesigner) {
    await ErpDesignerEntry.initFormula();
  }
  var activeERPForm = ErpDesignerUI.getActiveERPForm();
  if (!activeERPForm) {
    activeERPForm = ErpDesignerUI.D_FileTree;
  }
  var formulaKeys = ErpDesignerFuns.getFormulaKeys();
  cxt.form.setPara("FormulaKeys", formulaKeys);
  var formSearch = ErpDesignerFuns.getFormSearch();
  var editFormKey = activeERPForm.formKey;
  if (editFormKey == "WEBEXCEL") {
    formSearch = activeERPForm.getPara("AssociationFormKey");
  }
  if (formSearch != "") {
    editFormKey = formSearch;
    cxt.form.getComponent("FormSearch").setValue(formSearch);
    cxt.form.getComponent("IsFuzzyQuery").setValue(false);
  }
  ErpDesignerUI.FormulaRequestNum = 0;
  if (cxt.form.getPara("FormulaDataSeted") === "true")
    return;
  cxt.form.setPara("FormulaDataSeted", "true");
  if (formulaKeys == "designer") {
    var hasGetData = await ErpDesignerUtil.getDesignerTableCacheByTableName("DesignerFormulaCache")().get("hasGetData");
    if (!hasGetData) {
      await ErpDesignerFuns.getEditorFuncsData("macro", activeERPForm && activeERPForm.formKey, cxt, "", false, "DesignerFormulaCache");
      await ErpDesignerFuns.getEditorFuncsData("function", activeERPForm && activeERPForm.formKey, cxt, "", false, "DesignerFormulaCache");
    }
    await ErpDesignerFuns.getEditorFuncsData("form", activeERPForm && activeERPForm.formKey, cxt, "", false, "DesignerFormCache");
    await ErpDesignerFuns.setFunctionTable(cxt, ["DesignerFormulaCache"]);
  } else {
    var unExistTableNames = [];
    var tableNames = formulaKeys.split(",");
    if (formulaKeys != "designer") {
      for (var tableName of tableNames) {
        var hasGetData = await ErpDesignerUtil.getDesignerTableCacheByTableName(tableName)().get("hasGetData");
        if (!hasGetData) {
          unExistTableNames.push(tableName);
        }
      }
    }
    if (unExistTableNames.length > 0) {
      await ErpDesignerFuns.getEditorFuncsData("function", "", cxt, unExistTableNames.join(), true);
    }
    await ErpDesignerFuns.getEditorFuncsData("form", editFormKey, cxt, unExistTableNames.join(), false, "DesignerFormCache");
    await ErpDesignerFuns.setFunctionTable(cxt, tableNames);
  }
  await cxt.form.eval("ShowData();", cxt, null);
};
const beautifyXmlSource = async function() {
  var openXml = ErpDesigner.getActiveOpenedXml();
  if (openXml) {
    var dataobjectParams = {
      formKey: ErpDesigner.getActiveOpenedXml().xmlEditor.getValue()
    };
    let r = new Request();
    r.addHeader("content-type", "application/json;charset=UTF-8");
    let res = await r.getData(dataobjectParams, ErpDesigner.url + "DesignerController/formatXML");
    if (res.msg.indexOf("false_") == 0) {
      ErpDesignerUI.showTip(res);
    } else {
      openXml.isNew = true;
      openXml.isEditBeforeLoad = true;
      var xmlEditor = openXml.xmlEditor, showContent = res.msg.replace(/\r\n/g, "\r");
      xmlEditor.setValue(showContent);
      xmlEditor.clearHistory();
      await ErpDesigner.updateActiveXmlCaption(openXml);
      ErpDesignerUI.showTip("操作成功!", "success");
    }
  }
};
const refreshCodeMirror = async function(evl, name, ctx, arg) {
  var popFormKey = arg.length > 0 ? arg[0] : "D_FormulaPopWin";
  var form2 = ErpDesignerHelper.getFormByKey(FormStack.getFormList(), popFormKey);
  var cxt = new ViewContext(form2);
  var args = [];
  args[0] = "SelectKeyHidden";
  var value2 = await GetValue(null, "SelectKeyHidden", cxt, args);
  args[0] = "IsDependencyField";
  var isDependencyField = await GetValue(null, "IsDependencyField", cxt, args);
  args[0] = "IsFunctionGrid";
  var IsFunctionGrid = await GetValue(null, "IsFunctionGrid", cxt, args);
  var SetDependencyHidden = $("span[id$=_SetDependencyHidden]").children("input")[0];
  args[0] = "DescriptionKey";
  var DescriptionKey = await GetValue(null, "DescriptionKey", cxt, args);
  $("iframe").contents().find("#description").html(DescriptionKey);
  let popupWinEditor = ErpDesignerFuns.popupWinEditor;
  if (!popupWinEditor) {
    popupWinEditor = form2.getComponent("ForumlaContent").impl.workSpace.currrentCodemirrorEditor;
  }
  if (isDependencyField == "true" && IsFunctionGrid == "false" && SetDependencyHidden && SetDependencyHidden.value == "1") {
    args[0] = "DependencyField";
    var DependencyField = await GetValue(null, "DependencyField", cxt, args);
    if (DependencyField) {
      var DependencyFields = DependencyField.split(",");
      if (DependencyFields && DependencyFields.length > 0) {
        var isExistField = false;
        for (var i = 0; i < DependencyFields.length; i++) {
          if (value2 == DependencyFields[i]) {
            isExistField = true;
            break;
          }
        }
        if (isExistField) {
          ErpDesignerUI.showTip(value2 + "已存依赖字段中，不可重复添加！", "warning");
          return;
        }
      }
      args[1] = DependencyField + "," + value2;
    } else {
      args[1] = value2;
    }
    await SetValue$1(null, "DependencyField", cxt, args);
  } else if (SetDependencyHidden && SetDependencyHidden.value != "1") {
    args[0] = "ForumlaContent";
    if (popupWinEditor.getValue()) {
      popupWinEditor.setValue(popupWinEditor.getValue() + "," + value2);
    } else {
      popupWinEditor.setValue(value2);
    }
    args[1] = popupWinEditor.getValue();
    await SetValue$1(null, "ForumlaContent", cxt, args);
  } else {
    if (popupWinEditor.getValue()) {
      popupWinEditor.setValue(popupWinEditor.getValue() + "," + value2);
    } else {
      popupWinEditor.setValue(value2);
    }
  }
};
function isShow(keyCode) {
  return keyCode === 8 || keyCode === 108 || keyCode === 110 || keyCode === 189 || keyCode === 190 || keyCode >= 65 && keyCode <= 90;
}
const DisplayCodeMirror = async function(self, name, ctx, arg) {
  var _a, _b;
  var popFormKey = arg.length > 0 ? arg[0] : "D_FormulaPopWin";
  var form2 = ErpDesignerHelper.getFormByKey(FormStack.getFormList(), popFormKey);
  var cxt = new ViewContext(form2);
  var $div = $("div.CodeMirror.cm-s-default.CodeMirror-wrap", (_b = (_a = form2.getRoot()) == null ? void 0 : _a.getEl()) == null ? void 0 : _b.getElm());
  if ($div && $div[0]) {
    return;
  }
  var input = $("div[id$=_ForumlaContent]").find("input")[0];
  input.style.disabled = "";
  input.focus();
  var yigoFnKw = await ErpDesignerUtil.getKeyWordsFromBackend();
  ErpDesignerFuns.popupWinEditor = CodeMirror.fromTextArea(input, {
    // theme: "dracula",
    indentWithTabs: true,
    smartIndent: true,
    styleActiveLine: true,
    lineNumbers: true,
    lineWrapping: true,
    matchBrackets: true,
    textWrapping: true,
    autoCloseTags: true,
    //自动关闭tag
    autoCloseBrackets: true,
    //自动括号
    foldGutter: true,
    gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter", "CodeMirror-lint-markers"],
    mode: "text/x-yigo",
    yigoFnKw,
    // mode: {name: "javascript", globalVars: true},
    extraKeys: {
      "Tab": "autocomplete",
      "F11": function(cm) {
        cm.setOption("fullScreen", !cm.getOption("fullScreen"));
      },
      "Esc": function(cm) {
        if (cm.getOption("fullScreen"))
          cm.setOption("fullScreen", false);
      }
    },
    textHover: true
  });
  ErpDesignerFuns.popupWinEditor.setSize("100%", "100%");
  ErpDesignerFuns.popupWinEditor.refresh();
  ErpDesignerFuns.popupWinEditor.setOption("readOnly", false);
  ErpDesignerFuns.popupWinEditor.setValue(ErpDesignerUI.editorValue);
  ErpDesignerFuns.popupWinEditor.on("focus", function(cm, event) {
  });
  ErpDesignerFuns.popupWinEditor.on("change", async function(cm, event) {
    if (ErpDesignerFuns.popupWinEditor.getOption("readOnly"))
      return;
    var afterValue = await ErpDesignerFuns.codeMirrorAutoComplete(isShow, event, cm, ErpDesignerFuns.popupWinEditor);
    afterValue = ErpDesignerFuns.popupWinEditor.getValue();
    var args = [];
    args[0] = "ForumlaContent";
    args[1] = afterValue;
    await SetValue$1(null, "ForumlaContent", cxt, args);
    args[0] = "ForumlaContents";
    await SetValue$1(null, "ForumlaContents", cxt, args);
  });
  ErpDesignerFuns.popupWinEditor.on("blur", async function(cm, event) {
    ErpDesignerUI.D_FormulaPopWinOK = false;
    var afterValue = await ErpDesignerFuns.codeMirrorAutoComplete(isShow, event, cm, ErpDesignerFuns.popupWinEditor);
    if (ErpDesignerUI.getActiveERPForm()) {
      await ErpDesignerService.parseFormula(ErpDesignerUI.getActiveERPForm().formKey, "One", afterValue, "Visible");
    } else {
      await ErpDesignerService.parseFormula(ErpDesignerUI.activeERPFormKey, "One", afterValue, "Visible");
    }
    ErpDesignerUI.D_FormulaPopWinOK = true;
  });
  ErpDesignerFuns.popupWinEditor.on("keyup", function(cm, event) {
    if (event.keyCode == 229) {
      var currentContent = ErpDesignerFuns.popupWinEditor.getValue();
      if (!currentContent) {
        return ErpDesignerFuns.popupWinEditor.getValue();
      }
      var charPos = 1;
      if (currentContent.indexOf("；") != -1) {
        charPos = currentContent.indexOf("；") + 1;
        ErpDesignerFuns.popupWinEditor.setValue(ErpDesignerFuns.popupWinEditor.getValue().replace(/\；/ig, ";"));
      } else if (currentContent.indexOf("，") != -1) {
        charPos = currentContent.indexOf("，") + 1;
        ErpDesignerFuns.popupWinEditor.setValue(ErpDesignerFuns.popupWinEditor.getValue().replace(/\，/ig, ","));
      } else if (currentContent.indexOf("（") != -1) {
        charPos = currentContent.indexOf("（") + 1;
        ErpDesignerFuns.popupWinEditor.setValue(ErpDesignerFuns.popupWinEditor.getValue().replace(/\（/ig, "("));
      } else if (currentContent.indexOf("）") != -1) {
        charPos = currentContent.indexOf("）") + 1;
        ErpDesignerFuns.popupWinEditor.setValue(ErpDesignerFuns.popupWinEditor.getValue().replace(/\）/ig, ")"));
      }
      if (charPos > 1) {
        for (var i = 1; i <= charPos; i++) {
          ErpDesignerFuns.popupWinEditor.execCommand("goCharRight");
        }
      }
    }
  });
};
const getPopupWinEditorEnable = async function() {
  return ErpDesignerUI.D_FormulaPopWinOK;
};
const setDesignCodeMirrorEditor = async function(evl, name, cxt, arry) {
  if (ErpDesignerUI.DesignCodeMirrorEditor == null && ErpDesignerUI.editor != null) {
    ErpDesignerUI.editor.setValue(arry[0]);
  } else if (ErpDesignerUI.DesignCodeMirrorEditor != null && ErpDesignerUI.editor == null && ErpDesignerUI.isUseCodeMirror) {
    ErpDesignerUI.DesignCodeMirrorEditor.setValue(arry[0]);
  }
  ErpDesignerUI.isUseCodeMirror = true;
};
const DisplayFormulaeditorCodeMirror = async function(self, name, cxt, arry) {
  var _a;
  var form2 = ErpDesignerHelper.getFormByKey(FormStack.getFormList(), "D_OperationToobar");
  if (form2 == null) {
    form2 = ErpDesignerHelper.getFormByKey(FormStack.getFormList(), "D_CommonDef");
  }
  $(
    "div.CodeMirror.cm-s-default.CodeMirror-wrap",
    (_a = form2.getRoot()) == null ? void 0 : _a.getEl()
  ).each(function() {
    $(this).remove();
  });
  setTimeout(async function() {
    var _a2, _b;
    var cxt2 = new ViewContext(form2);
    var input = $("div[id$=_" + arry[0] + "]").children("TextArea")[0];
    if (arry[0] === "OperationEditor1" || arry[0] === "OperationCollectionEditor1") {
      input = $("div[id$=_" + arry[0] + "]").children("input")[0];
    }
    if (!input)
      return false;
    input.style.disabled = "";
    $(
      "div.CodeMirror.cm-s-default.CodeMirror-wrap",
      (_b = (_a2 = form2.getRoot()) == null ? void 0 : _a2.getEl()) == null ? void 0 : _b.getElm()
    ).each(function() {
      $(this).remove();
    });
    var yigoFnKw = await ErpDesignerUtil.getKeyWordsFromBackend();
    ErpDesignerUI.DesignCodeMirrorEditor = CodeMirror.fromTextArea(input, {
      // theme: "dracula",
      indentWithTabs: true,
      smartIndent: true,
      styleActiveLine: true,
      lineNumbers: true,
      lineWrapping: true,
      matchBrackets: true,
      textWrapping: true,
      autoCloseTags: true,
      //自动关闭tag
      autoCloseBrackets: true,
      //自动括号
      foldGutter: true,
      gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter", "CodeMirror-lint-markers"],
      mode: "text/x-yigo",
      yigoFnKw,
      // mode: {name: "javascript", globalVars: true},
      extraKeys: {
        "Tab": "autocomplete",
        "F11": function(cm) {
          cm.setOption("fullScreen", !cm.getOption("fullScreen"));
        },
        "Esc": function(cm) {
          if (cm.getOption("fullScreen"))
            cm.setOption("fullScreen", false);
        }
      },
      textHover: true
    });
    ErpDesignerUI.DesignCodeMirrorEditor.setSize("100%", "100%");
    ErpDesignerUI.DesignCodeMirrorEditor.refresh();
    ErpDesignerUI.DesignCodeMirrorEditor.setOption("readOnly", false);
    if ((arry[0] === "OperationEditor1" || arry[0] === "OperationCollectionEditor1") && arry[1]) {
      ErpDesignerUI.DesignCodeMirrorEditor.setValue(arry[1]);
    }
    ErpDesignerUI.DesignCodeMirrorEditor.on("focus", function(cm, event) {
    });
    ErpDesignerUI.DesignCodeMirrorEditor.on("change", async function(cm, event) {
      if (ErpDesignerUI.DesignCodeMirrorEditor.getOption("readOnly"))
        return;
      var afterValue = await ErpDesignerFuns.codeMirrorAutoComplete(isShow, event, cm, ErpDesignerUI.DesignCodeMirrorEditor);
      afterValue = ErpDesignerUI.DesignCodeMirrorEditor.getValue();
      var args = [];
      args[0] = arry[0];
      if (arry[0] === "OperationEditor1" || arry[0] === "OperationCollectionEditor1") {
        args[0] = arry[0] + "s";
      }
      args[1] = afterValue;
      await SetValue$1(null, arry[0], cxt2, args);
    });
    ErpDesignerUI.DesignCodeMirrorEditor.on("blur", function(cm, event) {
    });
    ErpDesignerUI.DesignCodeMirrorEditor.on("keyup", function(cm, event) {
      if (event.keyCode == 229) {
        var currentContent = ErpDesignerUI.DesignCodeMirrorEditor.getValue();
        if (!currentContent) {
          return ErpDesignerUI.DesignCodeMirrorEditor.getValue();
        }
        var charPos = 1;
        if (currentContent.indexOf("；") != -1) {
          charPos = currentContent.indexOf("；") + 1;
          ErpDesignerUI.DesignCodeMirrorEditor.setValue(ErpDesignerUI.DesignCodeMirrorEditor.getValue().replace(/\；/ig, ";"));
        } else if (currentContent.indexOf("，") != -1) {
          charPos = currentContent.indexOf("，") + 1;
          ErpDesignerUI.DesignCodeMirrorEditor.setValue(ErpDesignerUI.DesignCodeMirrorEditor.getValue().replace(/\，/ig, ","));
        } else if (currentContent.indexOf("（") != -1) {
          charPos = currentContent.indexOf("（") + 1;
          ErpDesignerUI.DesignCodeMirrorEditor.setValue(ErpDesignerUI.DesignCodeMirrorEditor.getValue().replace(/\（/ig, "("));
        } else if (currentContent.indexOf("）") != -1) {
          charPos = currentContent.indexOf("）") + 1;
          ErpDesignerUI.DesignCodeMirrorEditor.setValue(ErpDesignerUI.DesignCodeMirrorEditor.getValue().replace(/\）/ig, ")"));
        }
        if (charPos > 1) {
          for (var i = 1; i <= charPos; i++) {
            ErpDesignerUI.DesignCodeMirrorEditor.execCommand("goCharRight");
          }
        }
      }
    });
  }, 1);
};
const ShowProperty = async function(evl, name, cxt, args) {
  ErpDesigner.selectedFormKey = args[6];
  ErpDesignerUI.activeERPFormKey = args[6];
  if ("activeERPFormKey" === args[6])
    ErpDesignerUI.activeERPFormKey = ErpDesignerUI.getActiveERPForm().formKey;
  if (args[2].toLowerCase() == "Macros".toLowerCase())
    return;
  if (args[2].toLowerCase() == "Operations".toLowerCase()) {
    ErpDesigner.selectedComponentKey = "Operations";
    return;
  }
  if (ErpDesigner.isInLocationAttrParent)
    return;
  let propertyFormKey = args[0], compKey = args[2], compType = args[3], rowIndex = args[4], parentKey = args[5], ownerParentFormKey = args[6];
  if (parentKey)
    ErpDesignerUI.parentKey = parentKey;
  if (!(compType.toLowerCase() == "Form".toLowerCase())) {
    if (ErpDesigner.selectedComponentKey == compKey && ErpDesigner.selectedType == "GridLayoutPanel" || ErpDesigner.selectedFormKey == "MobileFormDesigner")
      ;
    else {
      ErpDesigner.selectedComponentKey = compKey;
      ErpDesigner.selectedType = compType;
      ErpDesigner.selectedGridTrIndex = 0;
      if (ErpDesigner.selectedType === "columnheader" || ErpDesigner.selectedType === "cell" || ErpDesigner.selectedType === "GridField") {
        ErpDesigner.selectComponentRun(void 0, true);
      } else {
        ErpDesigner.selectComponentRun();
      }
    }
  }
  ErpDesigner.setSelectedTabInSource();
  ErpDesigner.selectedComponentKeyInDesign = compKey;
  let activeForm = ErpDesignerUI.getActiveERPForm();
  let showDocumentHandler = async function(propertyForm) {
    propertyForm.setPara("ContainerKey", null);
    if (activeForm.entryParas && activeForm.getDefContainer() && activeForm.paras.map.FormKey)
      propertyForm.setPara("ContainerKey", activeForm.paras.map.FormKey);
    propertyForm.setPara("OwnerFormKey", ErpDesignerUI.activeERPFormKey);
    propertyForm.setPara("compKey", args[2]);
    propertyForm.setPara("compType", compType);
    propertyForm.setPara("parentKey", parentKey);
    propertyForm.setPara("OwnerParentFormKey", ownerParentFormKey);
    propertyForm.setPara("d_rowIndex", rowIndex);
    let cxt2 = new ViewContext(propertyForm);
    await propertyForm.eval("LoadData();", cxt2, null);
    await ErpDesignerUI.refreshERPPropertyUI();
  };
  let formRenderBeforeHandler = function(propertyForm) {
    propertyForm.setPara("ContainerKey", null);
    if (activeForm.entryParas && activeForm.getDefContainer() && activeForm.paras.map.FormKey)
      propertyForm.setPara("ContainerKey", activeForm.paras.map.FormKey);
    propertyForm.setPara("OwnerFormKey", ErpDesignerUI.activeERPFormKey);
    propertyForm.setPara("OwnerParentFormKey", ownerParentFormKey);
    propertyForm.setPara("compKey", args[2]);
    propertyForm.setPara("compType", compType);
    propertyForm.setPara("parentKey", parentKey);
    propertyForm.setPara("d_rowIndex", rowIndex);
  };
  let formRenderAfterHandler = function(propertyForm) {
    if (!propertyForm || !propertyForm.getDocument())
      return;
    let tables = propertyForm.getDocument().tbls;
    if (!tables || tables.length == 0)
      return;
    for (let tablesKey in tables) {
      let colArray = tables[tablesKey].cols;
      if (!colArray || colArray.length === 0)
        return;
      new ViewContext(propertyForm);
      for (let i = 0; i < colArray.length; i++) {
        let fieldKey = colArray[i].key, propertyKey = fieldKey.substring(3), propertyInput, propertyInputParent;
        let component = propertyForm.getComponent(propertyKey);
        if (!component) {
          propertyKey = fieldKey.substring(2);
          component = propertyForm.getComponent(propertyKey);
        }
        if (!component) {
          propertyKey = fieldKey;
          component = propertyForm.getComponent(propertyKey);
        }
        if (!component) {
          continue;
        }
        let id = component.id;
        if (id == propertyForm.formID + "_" + propertyKey) {
          if (component.getEl()) {
            component.getEl().addPostpatchHook(() => {
              propertyInput = component.getEl().$findByTagName("input")[0];
              propertyInputParent = component.getEl();
              if (propertyInputParent) {
                propertyInputParent.$click(async function(e) {
                  CodeMirrorWorkSpace.FormulaEditor.updateCodemirror(component, propertyKey, component.getNowShowText(), propertyForm);
                  e.stopPropagation();
                });
              }
              let isCanEdit = CodeMirrorUtil.isDesignerEditProperty(propertyKey);
              if (isCanEdit) {
                propertyInput.getElm().addEventListener("keyup", async function(e) {
                  CodeMirrorWorkSpace.FormulaEditor.updateCodemirror(component, this.offsetParent.id.split("_")[1], $(this).val(), propertyForm);
                  e.stopPropagation();
                });
              }
            });
          }
        }
      }
    }
  };
  await ErpDesignerUI.propertyFormAction(activeForm, propertyFormKey, showDocumentHandler, formRenderAfterHandler, formRenderBeforeHandler);
  ErpDesignerGlobal.getfunsList(ErpDesignerFuns.funcList);
};
const setDataObjectSource = async function(evl, name, cxt, args) {
  ConfirmDialog.show({
    title: "信息",
    message: "切换数据对象来源将会删除当前表单所有DataBinding,你确定这么操作?",
    closeOnBackdropClick: false,
    buttons: [
      { text: "取消", handler: () => async function() {
        await LoadData(null, name, cxt, args);
        return;
      }() },
      { text: "确定", color: "#4CAF50", handler: () => async function() {
        var form2 = ErpDesignerUI.getActiveERPForm();
        var subKey = form2.formKey, dataObjectSourceValue = args[0];
        if (form2.formKey == "MobileFormDesigner") {
          subKey = form2.WebMapFormKey;
        }
        let params = {
          cmd: "SetDataObjectSource",
          service: "DesignService",
          subKey,
          projectKey: ErpDesignerUI.getActiveERPForm().projectKey,
          dataObjectSourceValue
        };
        let uiCommands = await new Request().getData(params);
        if (uiCommands == null || uiCommands == void 0) {
          ErpDesignerUI.showTip("修改失败");
        } else {
          if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
            return;
          }
          var activeForm = ErpDesignerUI.getActiveERPForm();
          await ErpDesignerUI.doUICommands(activeForm, uiCommands);
          await LoadData(null, name, cxt, args);
          $("li[key='Refresh']").unbind("click").click();
        }
        return;
      }() }
    ]
  });
};
const setSourceDataObject = async function(evl, name, cxt, args) {
  ConfirmDialog.show({
    title: "信息",
    message: "切换数据对象来源将会删除当前表单所有DataBinding,你确定这么操作?",
    closeOnBackdropClick: false,
    buttons: [
      { text: "取消", handler: () => async function() {
        await LoadData(null, name, cxt, args);
        return;
      }() },
      { text: "确定", color: "#4CAF50", handler: () => async function() {
        var form2 = ErpDesignerUI.getActiveERPForm();
        var subKey = form2.formKey;
        if (form2.formKey == "MobileFormDesigner") {
          subKey = form2.WebMapFormKey;
        }
        let sourceDataObjectValue = args[0], params = {
          cmd: "SetSourceDataObject",
          service: "DesignService",
          subKey,
          sourceDataObjectValue
        };
        try {
          var uiCommands = await new Request().getData(params);
          if (uiCommands == null || uiCommands == void 0) {
            ErpDesignerUI.showTip("修改失败");
          } else {
            if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
              await LoadData(null, name, cxt, args);
              $("li[key='Refresh']").unbind("click").click();
              return;
            }
            var activeForm = ErpDesignerUI.getActiveERPForm();
            await ErpDesignerUI.doUICommands(activeForm, uiCommands);
            await LoadData(null, name, cxt, args);
            $("li[key='Refresh']").unbind("click").click();
          }
        } catch (e) {
          ErpDesignerUI.showTip(JSON.parse(e.message).message);
          await LoadData(null, name, cxt, args);
          $("li[key='Refresh']").unbind("click").click();
        }
        return;
      }() }
    ]
  });
};
const LoadDataObject = async function(evl, name, cxt, args) {
  ErpDesignerUI.activeERPFormKey = args[6];
  ErpDesigner.selectedFormKey = args[6];
  var form2;
  if (ErpDesignerUI.selectNode) {
    form2 = ErpDesignerUI.getActiveERPForm();
  } else {
    form2 = ErpDesignerHelper.getFormByKey(FormStack.getFormList(), ErpDesigner.selectedFormKey);
    if (!form2) {
      form2 = ErpDesignerUI.getActiveERPForm();
    }
  }
  if (form2.formKey == "MobileFormDesigner") {
    let iframe = form2.impl.el.getElm().querySelectorAll("iframe")[0];
    form2 = iframe.contentWindow.ERPDESIGNER.UI.getActiveERPForm();
  }
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  form2.getCallParas().put("path", ErpDesignerUI.backstagePath);
  form2.getCallParas().put("Type", "");
  form2.getCallParas().put("ShowObjectType", "DataSource");
  if (form2.entryParas && form2.getDefContainer() && ErpDesignerUI.activeERPFormKey) {
    form2.getCallParas().put("ContainerKey", ErpDesignerUI.activeERPFormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_DataObject")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    ErpDesignerUI.DesignDivForm.setPara("OwnerFormKey", ErpDesignerUI.activeERPFormKey);
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const getFormulaFormVisible = async function() {
  return ErpDesignerFuns.getParaFromFormulaForm("isShowFormInfo", true);
};
const setEditorValue = async function(evl, name, cxt, args) {
  ErpDesignerUI.editorValue = args[0];
  if (args.length > 1) {
    ErpDesignerUI.isUseCodeMirror = args[1];
  }
};
const loadFormulaEditor = async function(evl, name, cxt, args) {
  var formKey = "D_FormulaPopWin";
  var value2 = args[0];
  ErpDesignerUI.editorValue = value2;
  var onLoad;
  if (args.length > 1 && args[1]) {
    onLoad = args[1];
  }
  var form2 = cxt.form;
  var isShowFormInfo = true;
  if (args.length > 2 && args[2]) {
    isShowFormInfo = args[2] && args[2] == "true";
  }
  var formulaKeys = "designer";
  if (args.length > 3 && args[3]) {
    formulaKeys = args[3];
  }
  var formSearch = "";
  if (args.length > 4 && args[4]) {
    formSearch = args[4];
  }
  let beforeBuilder = function(form22) {
    ErpDesignerUI.FormulaForm = form22;
    ErpDesignerUI.FormulaForm.setPara("formulaKeys", formulaKeys);
    ErpDesignerUI.FormulaForm.setPara("isShowFormInfo", isShowFormInfo);
    ErpDesignerUI.FormulaForm.setPara("formSearch", formSearch);
  };
  $.when(ErpDesignerUI.showRealModal(form2, formKey, [onLoad, beforeBuilder])).done(function(newForm) {
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.FormulaForm = null;
    });
    FormParasUtil.processCallParas(form2, newForm);
  });
};
const EntryDeleteDtl = async function(name, ctx, args) {
  var grid = ctx.form.getComponent("Grid1");
  var rowIndex = grid.getFocusRowIndex();
  return grid.deleteRow(rowIndex, true);
};
const getFormKey = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  return form2 && form2.formKey;
};
const setAssociationKey = async function(evl, name, cxt, args) {
  var activeForm = ErpDesignerUI.getActiveERPForm();
  if (!activeForm) {
    return;
  }
  let form2 = cxt.form;
  await form2.setValue("AssociationProject", activeForm.projectKey, cxt, false);
  await form2.setValue("AssociationForm", activeForm.formKey, cxt, true);
};
const D_ComboBoxQueryDef = function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var pr = ErpDesignerUI.propertyForm;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  form2.getCallParas().put("parentKey", ErpDesignerUI.parentKey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  var sourceSetttingForm = cxt.form;
  $.when(ErpDesignerUI.showRealModal(form2, "D_ComboBoxQueryDef")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
      if (args.length > 0 && (args[0] == "SourceSetting" || args[0] == "SourceSetting_Filter")) {
        ErpDesignerUI.DesignDivForm = sourceSetttingForm;
      }
    });
    if (args.length > 0) {
      cxt.form.getDocument();
      if (args[0] == "SourceSetting" || args[0] == "SourceSetting_Filter") {
        newForm.pFormID = cxt.form.formID;
        var newDocument = newForm.getDocument();
        var parentDocument = cxt.form.getDocument();
        let headTableKey = args[0] == "SourceSetting_Filter" ? "D_Filter_ComboBoxQueryDefHead" : "D_ComboBoxQueryDefHead";
        let paraCollectionKey = args[0] == "SourceSetting_Filter" ? "ED_Filter_ParameterCollection" : "ED_ParameterCollection";
        copyRowDatas(parentDocument.getByKey(headTableKey), newDocument.getByKey("D_ComboBoxQueryDefHead"));
        copyRowDatas(parentDocument.getByKey(paraCollectionKey), newDocument.getByKey("ED_ParameterCollection"));
        let showData = new ShowData(newForm);
        showData.show().then(() => {
          var SourceForm = newForm.getComponent("SourceForm");
          SourceForm && SourceForm.setValue(args[0]);
        });
      }
    }
  });
};
const D_ComboBoxSourceSetting = function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var pr = ErpDesignerUI.propertyForm;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  form2.getCallParas().put("parentKey", ErpDesignerUI.parentKey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_ComboBoxSourceSetting")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const D_CarouselSourceSetting = function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var pr = ErpDesignerUI.propertyForm;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  form2.getCallParas().put("parentKey", ErpDesignerUI.parentKey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_CarouselSourceSetting")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const D_RefreshHeaderSetting = function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var pr = ErpDesignerUI.propertyForm;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  form2.getCallParas().put("parentKey", ErpDesignerUI.parentKey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_RefreshHeaderSetting")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const D_RefreshFooterSetting = function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var pr = ErpDesignerUI.propertyForm;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  form2.getCallParas().put("parentKey", ErpDesignerUI.parentKey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_RefreshFooterSetting")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const D_PriceLabelItemSetting = function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var pr = ErpDesignerUI.propertyForm;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  form2.getCallParas().put("parentKey", ErpDesignerUI.parentKey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_PriceLabelItemCollection")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const AddNewBlock = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm == null)
    return;
  await UICheck(null, name, cxt, "");
  var blockKey = args[0];
  var isRoot = args[1];
  var rootPanelType = args[2];
  var popViewRootPanelType = args[3];
  var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm();
  for (let index in activeForm.metaForm.body.items) {
    let block = activeForm.metaForm.body.items[index];
    if (block.key == blockKey) {
      ErpDesignerUI.showTip("Key重复,创建失败");
      return;
    }
  }
  if (isRoot == "true" && rootPanelType == "PopView") {
    ErpDesignerUI.showTip("主block的根不能是PopView");
    return;
  }
  diff.formKey = activeForm.formKey;
  diff.metaObjectType = "Block";
  diff.key = blockKey;
  diff.reserveOne = "AddNewBlock";
  diff.reserveTwo = isRoot;
  diff.reserveThree = rootPanelType;
  diff.reserveFour = popViewRootPanelType;
  ErpDesigner.selectComponentKey = "";
  await ErpDesignerService.commitDiff(activeForm.formKey, [diff], null, null, activeForm.paras.map.FormKey).then(() => {
    ErpDesignerUI.DesignDivForm.fireClose();
    ErpDesigner.selectedType = "Block";
    ErpDesigner.selectComponentKey = blockKey;
  });
};
const ControlInSubDetail = function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  var controlKey = args[0];
  let subDetailCompMap = form2.metaForm.getSubDetailCompMap();
  for (let mapIndex in subDetailCompMap.keys()) {
    let compKey = subDetailCompMap.keys()[mapIndex];
    if (compKey == controlKey)
      return true;
  }
  return false;
};
const InSubDetailSetBindingCell = function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  var controlKey = args[0];
  let subDetailCompMap = form2.metaForm.getSubDetailCompMap();
  for (let mapIndex in subDetailCompMap.keys()) {
    let compKey = subDetailCompMap.keys()[mapIndex];
    if (compKey == controlKey) {
      return form2.eval("Macro_setBindingCellKeyByFieldKey", cxt, args);
    }
  }
  return "";
};
const CommitCarouselSourceSetting = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm == null)
    return;
  var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
  var propertyForm = ErpDesignerUI.propertyForm;
  propertyForm.formID;
  var propertyKey = propertyForm.getParas().get("compKey"), form2 = ErpDesignerUI.getActiveERPForm();
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  diff.formKey = activeForm.formKey;
  diff.metaObjectType = "CarouselSourceSetting";
  diff.ISContainer = true;
  diff.key = propertyKey;
  diff.parentKey = ErpDesignerUI.parentKey;
  await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, activeForm.getDocument(), activeForm.paras.map.FormKey);
};
const CommitRefreshFooterSetting = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm == null)
    return;
  var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
  var propertyForm = ErpDesignerUI.propertyForm;
  propertyForm.formID;
  var propertyKey = propertyForm.getParas().get("compKey"), form2 = ErpDesignerUI.getActiveERPForm();
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  diff.formKey = activeForm.formKey;
  diff.metaObjectType = "RefreshFooterSetting";
  diff.ISContainer = true;
  diff.key = propertyKey;
  diff.parentKey = ErpDesignerUI.parentKey;
  await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, activeForm.getDocument(), activeForm.paras.map.FormKey);
};
const CommitRefreshHeaderSetting = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm == null)
    return;
  var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
  var propertyForm = ErpDesignerUI.propertyForm;
  propertyForm.formID;
  var propertyKey = propertyForm.getParas().get("compKey"), form2 = ErpDesignerUI.getActiveERPForm();
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  diff.formKey = activeForm.formKey;
  diff.metaObjectType = "RefreshHeaderSetting";
  diff.ISContainer = true;
  diff.key = propertyKey;
  diff.parentKey = ErpDesignerUI.parentKey;
  await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, activeForm.getDocument(), activeForm.paras.map.FormKey);
};
const CommitPriceLabelItemSetting = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm == null)
    return;
  var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
  var propertyForm = ErpDesignerUI.propertyForm;
  propertyForm.formID;
  var propertyKey = propertyForm.getParas().get("compKey"), form2 = ErpDesignerUI.getActiveERPForm();
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  diff.formKey = activeForm.formKey;
  diff.metaObjectType = "PriceLabelItemSetting";
  diff.ISContainer = true;
  diff.key = propertyKey;
  diff.parentKey = ErpDesignerUI.parentKey;
  await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, activeForm.getDocument(), activeForm.paras.map.FormKey);
};
const CommitEditViewItemCollectionSetting = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm == null)
    return;
  var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
  var propertyForm = ErpDesignerUI.propertyForm;
  propertyForm.formID;
  var propertyKey = propertyForm.getParas().get("compKey"), form2 = ErpDesignerUI.getActiveERPForm();
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  diff.formKey = activeForm.formKey;
  diff.metaObjectType = "EditViewItemCollection";
  diff.ISContainer = true;
  diff.key = propertyKey;
  diff.parentKey = ErpDesignerUI.parentKey;
  await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, activeForm.getDocument(), activeForm.paras.map.FormKey);
};
const CommitSourceSetting = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm == null)
    return;
  var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
  var propertyForm = ErpDesignerUI.propertyForm;
  propertyForm.formID;
  var propertyKey = propertyForm.getParas().get("compKey"), form2 = ErpDesignerUI.getActiveERPForm();
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  diff.formKey = activeForm.formKey;
  diff.metaObjectType = "ComboBoxSourceSetting";
  diff.ISContainer = true;
  diff.key = propertyKey;
  diff.parentKey = ErpDesignerUI.parentKey;
  await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, activeForm.getDocument(), activeForm.paras.map.FormKey);
};
const LoadAllFieldsInSourceForm = async function(evl, name, cxt, args) {
  var form2 = cxt.form;
  var formKey = args[0];
  if (!formKey)
    return;
  await ErpDesignerService.getMetaDesignerFormMeta(formKey, false).then((metaFormJson) => {
    var _a, _b;
    var metaForm = new MetaForm(metaFormJson);
    var extFormFieldTable = form2.getDocument().getByKey("ED_NewExtensionForm");
    if (extFormFieldTable) {
      extFormFieldTable.clear();
      for (let keyIndex in metaForm.getComponentMap().keys()) {
        let key2 = metaForm.getComponentMap().keys()[keyIndex];
        var metaComp = metaForm.getComponent(key2);
        if (metaComp.tagName && metaComp.tagName.indexOf("Panel") < 0 && metaComp.tagName.indexOf("SubDetail") < 0 && metaComp.tagName.indexOf("ListView") < 0) {
          extFormFieldTable.addRow();
          extFormFieldTable.setByKey("FieldKey", key2);
          extFormFieldTable.setByKey("FieldCaption", metaComp.caption);
          extFormFieldTable.setByKey("FieldType", metaComp.tagName);
          extFormFieldTable.setByKey("IsRequired", ((_a = metaComp.dataBinding) == null ? void 0 : _a.required) ? 1 : 0);
          extFormFieldTable.setByKey("IsSelected", ((_b = metaComp.dataBinding) == null ? void 0 : _b.required) ? 1 : 0);
        }
      }
      form2.showDocument();
    }
  });
};
const LoadFieldsByParentKey = async function(evl, name, cxt, args) {
  var _a, _b;
  var form2 = cxt.form;
  var parentCompKey = args[0];
  var formKey = args[1];
  var extensionFormkey = args[2];
  let extensionFormJSON = await ErpDesignerService.getMetaDesignerFormMeta(extensionFormkey, false, false);
  let extensionForm = new MetaForm(extensionFormJSON);
  let parentComp = extensionForm.getDetailCompMap().get(parentCompKey);
  let isMatch = false;
  if (parentComp) {
    parentCompKey = parentComp.parentGridKey;
    isMatch = true;
  } else {
    let subDetailComp = extensionForm.getSubDetailCompMap().get(parentCompKey);
    if (subDetailComp) {
      parentCompKey = subDetailComp.parentSubDetail;
      isMatch = true;
    }
  }
  let metaFormJson = await ErpDesignerService.getMetaDesignerFormMeta(formKey, false, false);
  var metaForm = new MetaForm(metaFormJson);
  var sourceFormFieldTable = form2.getDocument().getByKey("ED_SelectSourceField");
  if (!sourceFormFieldTable)
    return;
  sourceFormFieldTable.clear();
  parentComp = metaForm.getComponent(parentCompKey);
  if (parentComp && parentComp.tagName == "Grid") {
    let gridCells = parentComp.rows[0].cells;
    for (let keyIndex in gridCells) {
      let gridCell = gridCells[keyIndex];
      if (extensionForm.getDetailCompMap().containsKey(gridCell.key))
        continue;
      sourceFormFieldTable.addRow();
      sourceFormFieldTable.setByKey("FieldKey", gridCell.key);
      sourceFormFieldTable.setByKey("FieldCaption", gridCell.caption);
      sourceFormFieldTable.setByKey("FieldType", ErpDesignerUtil.getControlTypeStr(gridCell.cellType));
      sourceFormFieldTable.setByKey("IsRequired", ((_a = gridCell.dataBinding) == null ? void 0 : _a.required) ? 1 : 0);
    }
  } else if (parentComp && parentComp.tagName == "SubDetail") {
    let addSubDetailCompIntoTable = function(comp) {
      var _a2;
      if (!extensionForm.getSubDetailCompMap().containsKey(comp.key)) {
        sourceFormFieldTable.addRow();
        sourceFormFieldTable.setByKey("FieldKey", comp.key);
        sourceFormFieldTable.setByKey("FieldCaption", comp.caption);
        sourceFormFieldTable.setByKey("FieldType", comp.type);
        sourceFormFieldTable.setByKey("IsRequired", ((_a2 = comp.dataBinding) == null ? void 0 : _a2.required) ? 1 : 0);
      }
      if (comp.iems && comp.items.length > 0) {
        for (let index in comp.items) {
          let subComp = comp.items[index];
          addSubDetailCompIntoTable(subComp);
        }
      }
    };
    addSubDetailCompIntoTable(parentComp.root);
  } else {
    if (isMatch)
      return;
    for (let keyIndex in metaForm.getComponentMap().keys()) {
      let key2 = metaForm.getComponentMap().keys()[keyIndex];
      var metaComp = metaForm.getComponent(key2);
      if (metaComp.tagName && metaComp.tagName.indexOf("Panel") < 0) {
        if (extensionForm.getComponent(key2))
          continue;
        sourceFormFieldTable.addRow();
        sourceFormFieldTable.setByKey("FieldKey", key2);
        sourceFormFieldTable.setByKey("FieldCaption", metaComp.caption);
        sourceFormFieldTable.setByKey("FieldType", metaComp.tagName);
        sourceFormFieldTable.setByKey("IsRequired", ((_b = metaComp.dataBinding) == null ? void 0 : _b.required) ? 1 : 0);
      }
    }
  }
};
const CommitSelectSourceField = async function(evl, name, cxt, args) {
  var _a;
  var form2 = cxt.form;
  var sourceFormFieldTable = form2.getDocument().getByKey("ED_SelectSourceField");
  sourceFormFieldTable.beforeFirst();
  let fieldKey, fieldCaption, fieldType, fieldTypeInt;
  while (sourceFormFieldTable.next()) {
    let selected = sourceFormFieldTable.getByKey("IsSelected");
    if (selected) {
      fieldKey = sourceFormFieldTable.getByKey("FieldKey");
      fieldCaption = sourceFormFieldTable.getByKey("FieldCaption");
      fieldType = sourceFormFieldTable.getByKey("FieldType");
      fieldTypeInt = ControlType[fieldType.toUpperCase()];
      break;
    }
  }
  if (fieldKey) {
    if (form2.getPara("Design_CreateType") == "QuoteComponent") {
      let diff = new Diff();
      diff.formKey = ErpDesignerUI.getActiveERPForm().metaForm.extendFormKey;
      diff.key = fieldKey;
      diff.caption = fieldCaption;
      diff.metaObjectType = "Field";
      diff.controlType = fieldType;
      diff.ISButtonQuote = true;
      diff.reserveOne = "extension";
      if (fieldType == "SubDetail") {
        diff.metaObjectType = "SubDetail";
      }
      let node = ErpDesignerUI.selectNode, parentID = node.attr("id");
      let parentComp = ErpDesignerUI.getActiveERPForm().getComponent(ErpDesignerUI.parentKey);
      if (ErpDesignerUI.parentKey && !parentComp) {
        if (ErpDesigner.selectedGridTrIndexKey) {
          let index = ErpDesigner.selectedGridTrIndexKey.indexOf("_");
          let detailRow = ErpDesignerUI.getActiveERPForm().getComponent(ErpDesigner.selectedGridTrIndexKey.substring(index + 1));
          if (detailRow) {
            for (let index2 in detailRow.data) {
              let rowData = detailRow.data[index2];
              if (rowData.rowType == "Detail") {
                parentComp = rowData.compMap[ErpDesignerUI.parentKey];
                break;
              }
            }
          }
        }
      }
      let selectedComp = ErpDesignerUI.getActiveERPForm().getComponent(ErpDesigner.selectedComponentKey);
      let tagType = parentComp ? parentComp.tagName.toLowerCase() : selectedComp.tagName.toLowerCase();
      if (tagType === "gridlayoutpanel" || tagType === "columnlayoutpanel1") {
        parentID = node.parent().parent().parent().attr("id");
        diff.x = node.attr("col");
        diff.y = node.parent().attr("row");
        if (node[0].nodeName != "TD") {
          parentID = node.parent().parent().parent().parent().attr("id");
          node = node.parent();
          diff.x = node.attr("col");
          diff.y = node.parent().attr("row");
        }
      } else if (tagType === "flexgridlayoutpanel") {
        parentID = node.parent().attr("id");
        diff.sideKey = ErpDesigner.selectedComponentKey;
        diff.insertAfter = ErpDesignerUI.insertAfter;
      } else {
        parentID = node.attr("id");
      }
      diff.parentKey = ErpDesignerUI.parentKey;
      if (parentID) {
        diff.parentKey = parentID.replace(parentID.substring(0, parentID.indexOf("_") + 1), "");
        if (ErpDesigner.selectedGridTrIndexKey) {
          diff.parentKey = (_a = diff.parentKey) == null ? void 0 : _a.substring(diff.parentKey.indexOf("_") + 1);
        }
      }
      if (tagType !== "flexgridlayoutpanel") {
        diff.x = parseInt(node.attr("col"));
        diff.y = parseInt(node.parent().attr("row"));
      }
      await ErpDesignerService.commitDiff(ErpDesignerUI.activeERPFormKey, [diff], null, form2.document, form2.metaForm.extensionFormKey);
      return;
    }
    let parentForm = form2.getParentForm();
    let typeMap = [217, 247, 253, 223, 316, 226, 264, 306];
    if (fieldTypeInt > 100 && fieldTypeInt < 1e3 && !typeMap.includes(fieldTypeInt)) {
      fieldTypeInt = fieldTypeInt * 10;
    }
    parentForm.getComponent("ControlType").setValue(fieldTypeInt, true);
    parentForm.getComponent("Key").setValue(fieldKey, true);
    parentForm.getComponent("Caption").setValue(fieldCaption, true);
    parentForm.getComponent("IsBindData").setValue("false", true);
  }
};
const LoadParaGroupDetail = async function(evl, name, cxt, args) {
  var detailList = cxt.form.getComponent("ParaGroupDetail");
  var paraDetail = args[0];
  if (detailList) {
    detailList.clearGridData();
    detailList.resetPage();
    for (let index = 0; index < paraDetail.length; index++) {
      let item = paraDetail[index];
      detailList.insertRow(detailList.getRowCount(), true).then((rowIndex2) => {
        let colIndex = detailList.findIndex("ParaKey");
        detailList.setValueAt(rowIndex2, colIndex, item.Key, false);
        colIndex = detailList.findIndex("ParaValue");
        detailList.setValueAt(rowIndex2, colIndex, item.Value, false);
        colIndex = detailList.findIndex("ParaCaption");
        detailList.setValueAt(rowIndex2, colIndex, item.Caption, false);
      });
    }
  }
};
var copyRowDatas = function(fromTable, toTable) {
  toTable.delAll();
  for (let rowIndex = 0; rowIndex < fromTable.getRowCount(); rowIndex++) {
    fromTable.setPos(rowIndex);
    toTable.addRow();
    for (let colIndex = 0; colIndex < toTable.getColumnCount(); colIndex++) {
      let col = toTable.getCol(colIndex);
      let fromColIndex = fromTable.indexByKey(col.getKey());
      if (fromColIndex > -1) {
        let value2 = fromTable.get(fromColIndex);
        toTable.setByKey(col.getKey(), value2);
      }
    }
  }
};
const CommitComboBoxQueryDef = async function(evl, name, cxt, args) {
  let SourceForm = cxt.form.getComponent("SourceForm");
  let SourceFormValue = SourceForm ? SourceForm.getValue() : null;
  if (SourceFormValue == "SourceSetting" || SourceFormValue == "SourceSetting_Filter") {
    let parentForm = FormStack.getForm(cxt.form.pFormID);
    var newDocument = cxt.form.getDocument();
    var parentDocument = parentForm.getDocument();
    let headTableKey = SourceFormValue == "SourceSetting_Filter" ? "D_Filter_ComboBoxQueryDefHead" : "D_ComboBoxQueryDefHead";
    let paraCollectionKey = SourceFormValue == "SourceSetting_Filter" ? "ED_Filter_ParameterCollection" : "ED_ParameterCollection";
    copyRowDatas(newDocument.getByKey("D_ComboBoxQueryDefHead"), parentDocument.getByKey(headTableKey));
    copyRowDatas(newDocument.getByKey("ED_ParameterCollection"), parentDocument.getByKey(paraCollectionKey));
    let showData = new ShowData(parentForm);
    showData.show();
    return;
  }
  var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
  var propertyForm = ErpDesignerUI.propertyForm, id = propertyForm.formID, propertyKey = propertyForm.getParas().get("compKey"), form2 = ErpDesignerUI.getActiveERPForm();
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  diff.formKey = activeForm.formKey;
  diff.metaObjectType = "QueryDef";
  diff.ISContainer = true;
  diff.key = propertyKey;
  let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, activeForm.paras.map.FormKey, null);
  if (!successFlag) {
    return;
  }
  $("#" + id + "_QueryDef").find("input").val("QueryDef");
};
const CommitChartDataSource = async function(evl, name, cxt, args) {
  var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
  var propertyForm = ErpDesignerUI.propertyForm;
  propertyForm.formID;
  var propertyKey = propertyForm.getParas().get("compKey"), form2 = ErpDesignerUI.getActiveERPForm();
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  diff.formKey = activeForm.formKey;
  diff.metaObjectType = "ChartDataSource";
  diff.ISContainer = true;
  diff.key = propertyKey;
  let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, activeForm.paras.map.FormKey, null);
  if (!successFlag) {
    return;
  }
};
const D_ChartDataSource = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  form2.getCallParas().put("ChartSourceType", args[0]);
  var pr = ErpDesignerUI.propertyForm;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_ChartDataSource")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    ErpDesignerUI.DesignDivForm.setPara("ChartSourceType", args[0]);
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const D_Dictfiltering = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.metaForm.extensionFormKey ? form2.metaForm.extensionFormKey : ErpDesignerUI.activeERPFormKey);
  var pr = ErpDesignerUI.propertyForm;
  var Type = pr.dataObjectKey;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  form2.getCallParas().put("Type", Type);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  let itemKey;
  var component = form2.getComponent(compKey);
  if (!component) {
    itemKey = cxt.form.getComponent("ItemKey").value;
  } else {
    itemKey = component.itemKey;
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_Dictfiltering")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.setPara("D_ItemKey", itemKey);
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const D_ColumnExpand = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var pr = ErpDesignerUI.propertyForm;
  pr.dataObjectKey;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  form2.getCallParas().put("parentKey", ErpDesignerUI.parentKey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_ColumnExpand")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const D_Gridfiltering = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var pr = ErpDesignerUI.propertyForm;
  var Type = pr.dataObjectKey;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  form2.getCallParas().put("Type", Type);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  let gridKey;
  var component = form2.getComponent(compKey);
  if (!component) {
    gridKey = cxt.form.getComponent("Key").value;
  } else {
    gridKey = component.Key;
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_GridFilter")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.setPara("GridKey", gridKey);
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const D_TraceCollection = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var pr = ErpDesignerUI.propertyForm;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_TraceCollection")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const D_ExtOptCollection = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var pr = ErpDesignerUI.propertyForm;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_ExtOptCollection")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const D_RowActionCollection = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var pr = ErpDesignerUI.propertyForm;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  if (ErpDesigner.selectedType == "TableViewRow" || ErpDesigner.selectedType == "TableRow") {
    form2.getCallParas().put("compKey", ErpDesignerUI.ownerDetail);
    form2.getCallParas().put("rowKey", compKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_RowActionCollectionSetting")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const D_IndicatorSetting = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var pr = ErpDesignerUI.propertyForm;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  $.when(ErpDesignerUI.showRealModal(form2, "D_IndicatorSetting")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const GetAllColumnsInTableRowData = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  var tableKey;
  let result = "";
  for (let index = 0; index < form2.formAdapt.getGridArray().length; index++) {
    let tableView = form2.formAdapt.getGridArray()[index];
    if (tableView.type != ControlType.TABLEVIEW)
      continue;
    for (let j = 0; j < tableView.items.length; j++) {
      let tableRow = tableView.items[j];
      if (tableRow.key == args[0]) {
        tableKey = tableRow.tableKey;
        break;
      }
    }
    if (tableKey)
      break;
  }
  if (tableKey) {
    let dataTable = form2.getDocument().getByKey(tableKey);
    for (let index = 0; index < dataTable.getColumnCount(); index++) {
      let column = dataTable.getCol(index);
      result += (result.length == 0 ? "" : ";") + column.key + "," + column.key + " " + (column.caption ? column.caption : "");
    }
  }
  return result;
};
const CommitIndicator = async function(evl, name, cxt, args) {
  await UICheck(null, name, cxt, "");
  if (ErpDesignerUI.DesignDivForm == null)
    return;
  var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
  var propertyForm = ErpDesignerUI.propertyForm;
  propertyForm.formID;
  var compKey = propertyForm.getParas().get("compKey"), form2 = ErpDesignerUI.getActiveERPForm();
  var tableView = form2.getComponent(ErpDesignerUI.parentKey);
  if (!tableView) {
    throw new Error("所在表格视图不存在");
  }
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  diff.formKey = activeForm.formKey;
  diff.metaObjectType = "IndicatorSetting";
  diff.ISContainer = true;
  diff.key = compKey;
  diff.parentKey = ErpDesignerUI.parentKey;
  await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, activeForm.getDocument(), activeForm.paras.map.FormKey);
};
const D_EditViewItemCollection = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var pr = ErpDesignerUI.propertyForm;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_EditViewItemCollectionSetting")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const LoadD_Layout = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.metaForm.extensionFormKey ? form2.metaForm.extensionFormKey : ErpDesignerUI.activeERPFormKey);
  var pr = ErpDesignerUI.propertyForm;
  var Type = pr.dataObjectKey;
  var par = pr.getParas();
  var p = par.get("compKey");
  form2.getCallParas().put("compKey", p);
  form2.getCallParas().put("Type", Type);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  if (ErpDesigner.selectedType == "EditViewRootGridLayout" || ErpDesigner.selectedType == "EditViewChildGridLayout") {
    form2.getCallParas().put("ChildLayoutKey", ErpDesigner.selectedLayoutKey);
    form2.getCallParas().put("compKey", ErpDesignerUI.parentKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_Layout")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const LoadAreaDesigner = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  let formKey = form2.metaForm.extensionFormKey ? form2.metaForm.extensionFormKey : form2.getFormKey();
  form2.getCallParas().put("OwnerFormKey", formKey);
  var pr = ErpDesignerUI.propertyForm;
  var Type = pr.dataObjectKey;
  var par = pr.getParas();
  var p = par.get("compKey");
  form2.getCallParas().put("compKey", p);
  form2.getCallParas().put("Type", Type);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "AreaDesigner")).done(function(newForm) {
    newForm.setPara("PanelKey", ErpDesigner.selectComponentKey);
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const LoadD_EmbedVar = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var pr = ErpDesignerUI.propertyForm;
  var Type = pr.dataObjectKey;
  var par = pr.getParas();
  var p = par.get("compKey");
  form2.getCallParas().put("compKey", p);
  form2.getCallParas().put("Type", Type);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_EmbedVar")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const popColorPicker = async function(evl, name, cxt, args) {
  var initColor = cxt.form.getComponent(args[0]).getValue();
  var dialog = new ColorPickerDialog({
    color: initColor || "#ffffff"
  });
  var color = await dialog.show();
  await SetValue$1(null, args[0], cxt, [args[0], color, "true"]);
};
const CommitTraceCollection = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
    var propertyForm = ErpDesignerUI.propertyForm, id = propertyForm.formID, propertyKey = propertyForm.getParas().get("compKey"), form2 = ErpDesignerUI.getActiveERPForm();
    if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
      diff.ContainerKey = form2.paras.map.FormKey;
    }
    diff.formKey = form2.getFormKey();
    diff.metaObjectType = "TraceCollection";
    diff.ISContainer = true;
    diff.key = propertyKey;
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, null, activeForm.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
    $("#" + id + "_TraceCollection").find("input").val("已设置");
  }
};
const CommitExtOptCollection = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
    var propertyForm = ErpDesignerUI.propertyForm, id = propertyForm.formID, propertyKey = propertyForm.getParas().get("compKey"), form2 = ErpDesignerUI.getActiveERPForm();
    if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
      diff.ContainerKey = form2.paras.map.FormKey;
    }
    diff.formKey = form2.getFormKey();
    diff.metaObjectType = "ExtOptCollection";
    diff.ISContainer = true;
    diff.key = propertyKey;
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, null, activeForm.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
    $("#" + id + "_ExtOptCollection").find("input").val("已设置");
  }
};
const CommitRowActionCollection = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
    var propertyForm = ErpDesignerUI.propertyForm;
    propertyForm.formID;
    var propertyKey = propertyForm.getParas().get("compKey"), form2 = ErpDesignerUI.getActiveERPForm();
    if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
      diff.ContainerKey = form2.paras.map.FormKey;
    }
    diff.formKey = form2.getFormKey();
    diff.metaObjectType = "RowActionCollection";
    diff.ISContainer = true;
    diff.key = propertyKey;
    if (ErpDesigner.selectedType == "TableViewRow" || ErpDesigner.selectedType == "TableRow") {
      diff.parentKey = ErpDesignerUI.ownerDetail;
      diff.controlType = "TableView";
    }
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, null, activeForm.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
  }
};
const HandlingLayout = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm) {
    var diff = new Diff(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
    var pF = ErpDesignerUI.propertyForm, p = pF.getParas().get("compKey"), form2 = ErpDesignerUI.getActiveERPForm();
    if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
      diff.ContainerKey = form2.paras.map.FormKey;
    }
    diff.formKey = form2.metaForm.extensionFormKey ? form2.metaForm.extensionFormKey : form2.getFormKey();
    diff.metaObjectType = args[0];
    diff.ISContainer = true;
    diff.key = p;
    if (ErpDesigner.selectedLayoutKey) {
      diff.reserveOne = ErpDesigner.selectedLayoutKey;
      diff.key = ErpDesignerUI.parentKey;
    }
    return await ErpDesignerService.handlingMergeSingleFormDiff(document2, diff, args[0], cxt);
  }
};
const NewDtl = async function(evl, name, cxt, args) {
  var TableMark = args[0], tbls = ErpDesignerUI.DesignDivForm && ErpDesignerUI.DesignDivForm.document ? ErpDesignerUI.DesignDivForm.document.tbls : [];
  for (var i = 0; i < tbls.length; i++) {
    var rows = tbls[i].allRows;
    for (var j = 0; j < rows.length; j++) {
      var vals = rows[j].vals;
      var state = rows[j].state;
      if (TableMark == vals[5] && state == 1) {
        return true;
      }
    }
  }
};
const NewDtl1 = async function(evl, name, cxt, args) {
  var tt = true;
  var val = 0;
  var TableMark = args[0], tbls = ErpDesignerUI.DesignDivForm.document.tbls, Tab2 = args[1], Tab1 = args[2], Tab22 = args[3];
  if (Tab2 == void 0) {
    Tab2 = null;
  }
  for (var i = 0; i < tbls.length; i++) {
    var rows1 = tbls[i].key;
    if (rows1.toLowerCase() == "ED_DataObjectCollection".toLowerCase() || rows1.toLowerCase() == "ED_TableCollection".toLowerCase()) {
      var rows3 = tbls[i].rows;
      for (var j = 0; j < rows3.length; j++) {
        var vals = rows3[j].vals[5];
        if (vals.toLowerCase() == TableMark.toLowerCase()) {
          val = rows3[j].vals[0];
        }
      }
    }
  }
  for (var i = 0; i < tbls.length; i++) {
    var rows1 = tbls[i].key;
    if (rows1.toLowerCase() == "ED_DataObjectField".toLowerCase() || rows1.toLowerCase() == "ED_TableFields".toLowerCase()) {
      var rows3 = tbls[i].rows;
      for (var j = 0; j < rows3.length; j++) {
        var vals = rows3[j].vals;
        if (val == vals[2] && Tab2 == vals[5] && Tab1.toLowerCase() == vals[6].toLowerCase() && Tab22.toLowerCase() == vals[7].toLowerCase()) {
          tt = false;
        }
      }
    }
  }
  return tt;
};
const NewDtl2 = async function(evl, name, cxt, args) {
  var tt = true;
  var val = 0;
  var TableMark = args[0], tbls = ErpDesignerUI.DesignDivForm.document.tbls;
  for (var i = 0; i < tbls.length; i++) {
    var rows1 = tbls[i].key;
    if (rows1.toLowerCase() == "ED_DataObjectCollection".toLowerCase() || rows1.toLowerCase() == "ED_TableCollection".toLowerCase()) {
      var rows3 = tbls[i].rows;
      for (var j = 0; j < rows3.length; j++) {
        var vals = rows3[j].vals[5];
        if (vals.toLowerCase() == TableMark.toLowerCase()) {
          val = rows3[j].vals[0];
        }
      }
    }
  }
  for (var i = 0; i < tbls.length; i++) {
    var rows1 = tbls[i].key;
    if (rows1.toLowerCase() == "ED_DataObjectField".toLowerCase() || rows1.toLowerCase() == "ED_TableFields".toLowerCase()) {
      var rows3 = tbls[i].rows;
      for (var j = 0; j < rows3.length; j++) {
        var vals = rows3[j].vals;
        if (val == vals[2]) {
          tt = false;
        }
      }
    }
  }
  return tt;
};
const CommitFieldProperty = async function(evl, name, cxt, args) {
  var propertyForm = ErpDesignerUI.propertyForm, condForm = ErpDesignerUI.DesignDivForm, id = propertyForm.formID, condSign = condForm.getValue("CondSign");
  if (condForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = condForm.getDocument();
    diff.formKey = activeForm.formKey;
    diff.metaObjectType = "FieldCondition";
    diff.ISContainer = true;
    if (propertyForm) {
      diff.key = propertyForm.getValue("Key");
      diff.controlType = propertyForm.getValue("ControlType");
    }
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, null, activeForm.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
    if (condSign == -1) {
      $("#" + id + "_Condition").find("input").val("");
    } else {
      $("#" + id + "_Condition").find("input").val("已设置");
    }
  }
};
const FormulaPopWinVisible = async function(evl, name, cxt, args) {
  return FormStack.getForm(cxt.form.pFormID).formKey != "D_NewMacro";
};
const CommitDataObjectCheckRule = async function(evl, name, cxt, args) {
  return await ErpDesignerFuns.CheckRule(args[0], args[1], void 0);
};
const CommitOperationToobar = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  var formStack = FormStack;
  var para = ErpDesignerUI.DesignDivForm.getPara("OwnerFormKey");
  var formList = formStack.getFormList();
  for (var i = 0; i < formList.length; i++) {
    if (formList[i].formKey == para) {
      form2 = formList[i];
      break;
    }
  }
  var diff = new Diff();
  var document2 = ErpDesignerUI.DesignDivForm.getDocument();
  form2.getParas().put("FormKey", form2.getFormKey());
  form2.getParas().put("EntryCaption", form2.caption);
  form2.getParas().put("OwnerFormKey", form2.getFormKey());
  diff.formKey = para;
  diff.metaObjectType = "DataOperationToobar";
  diff.key = para;
  var diffProperty = new DiffProperty();
  diffProperty.property = "DataOperationToobar";
  diffProperty.orgValue = "old";
  diffProperty.newValue = "new";
  diff.properties.push(diffProperty);
  var formDocument = form2.document;
  let successFlag = await ErpDesignerService.commitDiff(para, [diff], document2, formDocument, "", true);
  if (!successFlag) {
    return;
  }
  await ErpDesignerUtil.closeForm(cxt.form);
};
const showSelectedComponentInSource = async function(evl, name, cxt, args) {
  await ErpDesigner.showSelectedComponentInSource();
};
const setDesignAction = async function(evl, name, cxt, args) {
  var comp = cxt.form.getComponent("DesignTab");
  ErpDesignerUI.DesignActionForm[0] = comp.form;
  ErpDesignerUI.DesignActionForm[1] = cxt.form.getComponent("SourceTab").form;
  if (comp == void 0) {
    return false;
  }
  var tabComp = comp.ownerCt;
  if (tabComp.getActiveTab() === "DesignTab") {
    ErpDesignerUI.DesignAction = "DesignTab";
  } else if (tabComp.getActiveTab() === "SourceTab") {
    ErpDesignerUI.DesignAction = "SourceTab";
  }
};
const CommitDataSourceCheckRule = async function(evl, name, cxt, args) {
  return await ErpDesignerFuns.CheckRule(args[0], "DataObject", args[1]);
};
const CommitDataObject = async function(evl, name, cxt, args) {
  var _a;
  if (ErpDesignerUI.DesignDivForm) {
    let activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
    if (activeForm.formKey == "MobileFormDesigner") {
      return new Promise((resolve, reject) => {
        let iframe = activeForm.impl.el.getElm().querySelectorAll("iframe")[0];
        window.YIUI.commitDataObjectCallback = () => {
          resolve();
        };
        iframe.contentWindow.postMessage("commitDataObject");
      });
    }
    var diff = new Diff();
    for (var i = 0; i < document2.maps.table.ED_TableCollection.allRows.length; i++) {
      var state = document2.maps.table.ED_TableCollection.allRows[i].state;
      if (state == 1) {
        if (document2.maps.table.ED_TableCollection.allRows[i].vals[10] == 1)
          diff.reserveTwo = document2.maps.table.ED_TableCollection.allRows[i].vals[5];
      }
    }
    diff.formKey = activeForm.formKey;
    diff.metaObjectType = "DataSource";
    diff.key = (_a = activeForm.getDataObject()) == null ? void 0 : _a.key;
    var diffProperty = new DiffProperty();
    diffProperty.property = "DataObject";
    diffProperty.orgValue = "old";
    diffProperty.newValue = "new";
    diff.properties.push(diffProperty);
    diff.paramsformKey = activeForm.formKey;
    if (diff.key == null) {
      if (activeForm.entryParas != null && activeForm.getDefContainer()) {
        diff.key = activeForm.getDefContainer().form.getDataObject().key;
      }
    }
    if (activeForm.entryParas != null && activeForm.getDefContainer() && activeForm.paras.map.FormKey) {
      diff.ContainerKey = activeForm.paras.map.FormKey;
    }
    diff.ISContainer = true;
    var formDocument = activeForm.document;
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, formDocument, activeForm.paras.map.FormKey, true);
    ComboBoxHandler.clearCache();
    if (!successFlag) {
      return;
    }
  }
};
const HandlingGeneralConfiguration = async function(evl, name, cxt, args) {
  var diff = new Diff(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
  diff.filePath = sessionStorage.getItem(args[0] + "Path");
  diff.metaObjectType = args[0];
  diff.formKey = "D_" + args[0];
  diff.ISContainer = true;
  var commonDefParams = {
    document: JSON.stringify(DataUtil.toJSONDoc(document2)),
    diff: JSON.stringify([diff]),
    type: args[0]
  };
  let r = new Request();
  r.addHeader("content-type", "application/json");
  let res = await r.getData(commonDefParams, ErpDesigner.url + "settingControl/handle" + args[0]);
  if (res.UICommand && res.UICommand.length > 0) {
    let activeForm = ErpDesignerUI.getActiveERPForm();
    await ErpDesignerUI.doUICommands(activeForm, res.UICommand);
  }
  if (!res.error) {
    await ErpDesignerUtil.closeForm(cxt.form);
    sessionStorage.removeItem(args[0] + "Path");
    ComboBoxHandler.clearCache();
  }
};
const NewGridFiled = async function(evl, name, cxt, args) {
  var diff = new Diff(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
  diff.metaObjectType = "GridField";
  diff.formKey = ErpDesigner.selectedFormKey;
  diff.ISContainer = true;
  diff.key = "GridField";
  diff.caption = "GridField";
  diff.insertAfter = ErpDesignerUI.insertAfter;
  if (ErpDesigner.selectedComponentKey.startsWith("Column:")) {
    diff.sideKey = ErpDesigner.selectedComponentKey.substr(7);
  } else {
    diff.sideKey = ErpDesigner.selectedComponentKey;
  }
  diff.parentKey = ErpDesignerUI.parentKey;
  var commonDefParams = {
    document: JSON.stringify(DataUtil.toJSONDoc(document2)),
    diff: JSON.stringify([diff]),
    type: "NewGridFiled"
  };
  let r = new Request();
  r.addHeader("content-type", "application/json");
  let res = await r.getData(commonDefParams, ErpDesigner.url + "settingControl/handle" + args[0]);
  if (res.UICommand && res.UICommand.length > 0) {
    let activeForm = ErpDesignerUI.getActiveERPForm();
    await ErpDesignerUI.doUICommands(activeForm, res.UICommand);
  }
  if (!res.error) {
    await ErpDesignerUtil.closeForm(cxt.form);
    sessionStorage.removeItem(args[0] + "Path");
    ComboBoxHandler.clearCache();
  }
};
const HandlingMergeSingleFormDiff = async function(evl, name, cxt, args) {
  var diff = new Diff(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
  diff.metaObjectType = args[0];
  diff.formKey = ErpDesignerUI.activeERPFormKey;
  diff.ISContainer = true;
  var propertyForm = ErpDesignerUI.propertyForm;
  if (propertyForm) {
    var paras = propertyForm.getParas();
    var compKey = paras.get("compKey");
    diff.key = compKey;
  }
  var form2 = ErpDesignerUI.getActiveERPForm();
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  if (args.length > 1) {
    diff.reserveOne = args[1];
  }
  return await ErpDesignerService.handlingMergeSingleFormDiff(document2, diff, args[0], cxt);
};
const LoadDesignerGridTreeOneLevel = async (evl, name, cxt, args) => {
  checkParamNum(name, args, 1);
  const gridKey = TypeConvertor.toString(args[0]);
  const form2 = cxt.form;
  const grid = form2.getComponent(gridKey);
  if (!grid) {
    throw COMPONENT_NOT_EXISTS(gridKey);
  }
  const detailRow = grid.getDetailMetaRow();
  const rowTree = detailRow.rowTree;
  if (rowTree.treeType != TreeType.COMMON) {
    return;
  }
  const treeForeign = rowTree.foreign;
  const tableKey = args[1];
  const document2 = form2.getDocument();
  const table = document2.getByKey(tableKey);
  const currentRowIndex = grid.selection.focusRow;
  const rowData = grid.getRowDataAt(currentRowIndex);
  const bookmark = rowData.bkmkRow.getBookmark();
  table.setByBkmk(bookmark);
  var panelKey = args[2];
  var parentKey = args[3];
  var panelType, keyCache;
  panelType = table.get(table.indexByKey("PanelType"));
  const belongFormKey = table.get(table.indexByKey("BelongFormKey"));
  keyCache = panelKey;
  var designerFormMetaCache, childTableCache;
  if (tableKey == "ED_FormNodeTree")
    ;
  else {
    designerFormMetaCache = await ErpDesignerUtil.getDesignerTableCacheByTableName("DesignerFormTreeTableCache")();
    childTableCache = await designerFormMetaCache.get(keyCache);
  }
  var childTable;
  if (childTableCache) {
    childTable = DataUtil.fromJSONDataTable(childTableCache);
  }
  if (!childTable) {
    const parameters = form2.getParas();
    const params = {
      cmd: "LoadDesignerGridTreeOneLevel",
      service: "DesignService",
      formKey: form2.getFormKey(),
      tableKey,
      parentKey,
      belongFormKey,
      panelKey,
      panelType,
      parameters: parameters.toJSON()
    };
    const r = new Request(form2);
    childTable = await r.getData(params);
    var tblJson = DataUtil.toJSONDataTable(childTable);
    if (keyCache && designerFormMetaCache) {
      designerFormMetaCache.put(keyCache, tblJson);
    }
  }
  const start = table.size() + 1;
  for (let i = 0, size = childTable.size(); i < size; i++) {
    childTable.setPos(i);
    const childForeignValue = childTable.getByKey(treeForeign);
    if (childForeignValue != null && childForeignValue != 0) {
      continue;
    }
    childTable.setByKey(treeForeign, panelKey);
    childTable.setByKey("PanelKey", start + i);
  }
  return childTable;
};
const getColAllValue = async function(evl, name, cxt, args) {
  if (args.length != 2 && args.length != 3) {
    return;
  }
  let form2 = cxt.form, doc = form2.getDocument(), tableKey = args[0], columnKey = args[1], captionColumKey = args.length === 3 ? args[2] : "";
  let table = doc.getShadow(tableKey);
  if (!table) {
    table = doc.getByKey(tableKey);
  }
  let values = [];
  table.beforeFirst();
  while (table.next()) {
    if (captionColumKey === "") {
      values.push(table.getByKey(columnKey));
    } else {
      values.push(table.getByKey(columnKey) + "," + table.getByKey(captionColumKey));
    }
  }
  return values.join(";");
};
async function CheckViewExist(auxiliaryType, mark, migrationUpdateStrategy) {
  if (auxiliaryType != "Migration" || migrationUpdateStrategy != "KeysTableFocusChange") {
    return false;
  }
  var params = {
    cmd: "CheckViewExist",
    service: "DesignService",
    objectKey: mark
  };
  var uiCommands = await new Request().getData(params);
  if (uiCommands.length == 0) {
    return false;
  }
  await ErpDesignerUI.doUICommands(ErpDesignerUI.DesignDivForm, uiCommands);
  return true;
}
const CommitNewDataObject = async function(evl, name, cxt, args) {
  let auxiliaryType = cxt.form.getComponent("AuxiliaryType").getValue();
  let migrationUpdateStrategy;
  if (cxt.form.getComponent("MigrationUpdateStrategy") != null) {
    migrationUpdateStrategy = cxt.form.getComponent("MigrationUpdateStrategy").getValue();
  }
  let mark = cxt.form.getComponent("Mark").getValue();
  if (await CheckViewExist(auxiliaryType, mark, migrationUpdateStrategy))
    return;
  var diff = new Diff(), diff2 = new Diff(), diffs = [], document2 = ErpDesignerUI.DesignDivForm.getDocument();
  var formkey = sessionStorage.getItem("DataObjectFormkey");
  if (formkey == null) {
    formkey = document2.maps.table.ED_DataObjectHead.rows[0].vals[5];
  }
  diff.formKey = formkey;
  diff.metaObjectType = "DataObject";
  diff.reserveOne = "DataObject";
  diff.ISContainer = true;
  diffs.push(diff);
  if (ErpDesignerUI.DesignDivForm.dataObjectKey == "D_DataObject" && ErpDesignerUI.DesignDivForm.getPara("ShowObjectType") == "DataSource") {
    var activeForm = ErpDesignerUI.getActiveERPForm();
    diff.reserveThree = activeForm.formKey;
    diff2.formKey = activeForm.formKey;
    diff2.metaObjectType = "DataSource";
    diff2.key = activeForm.getDataObject().key;
    diff2.ISContainer = true;
    diff2.reserveOne = "OIDFilter";
    diffs.push(diff2);
  }
  var dataobjectParams = {
    formkey,
    document: JSON.stringify(DataUtil.toJSONDoc(document2)),
    diff: JSON.stringify(diffs)
  };
  var result = false;
  let r = new Request();
  r.addHeader("content-type", "application/json;charset=UTF-8");
  let res = await r.getData(dataobjectParams, ErpDesigner.url + "dataObjectController/handleDataObject");
  if (res) {
    if (res.code == 0) {
      if (res.xmlPath) {
        await ErpDesignerSrc.reloadXmlSource(res.xmlPath);
        if (ErpDesignerUI.DesignDivForm.dataObjectKey == "D_DataObject") {
          await ErpDesignerSrc.reloadXmlSource(res.xmlPath_form);
        }
        await ErpDesignerFuns.RefreshDataObjectProcessing(formkey);
        result = true;
      }
      await ErpDesignerUtil.closeForm(cxt.form);
    } else {
      ErpDesignerUI.showTip(res.msg);
      console.error(res.msg);
    }
  } else {
    console.error("数据对象操作失败");
  }
  if (result) {
    sessionStorage.removeItem("DataObjectFormkey");
    sessionStorage.removeItem("DataObjectFilePath");
  }
  ComboBoxHandler.clearCache();
  return result;
};
const CommitGridFilter = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
    var propertyForm = ErpDesignerUI.propertyForm;
    var formID = propertyForm.formID;
    var dataTableMap = document2.maps;
    var DetailLength = dataTableMap.get("ED_GridFilterDetail").rows.length;
    var paras = propertyForm.getParas();
    var compKey = paras.get("compKey");
    var form2 = ErpDesignerUI.getActiveERPForm();
    if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
      diff.ContainerKey = form2.paras.map.FormKey;
    }
    diff.formKey = form2.getFormKey();
    diff.metaObjectType = "GridFilter";
    diff.ISContainer = true;
    diff.key = compKey;
    diff.sideKey = propertyForm.dataObjectKey;
    diff.DictType = propertyForm.dataObjectKey;
    var diffProperty = new DiffProperty();
    diffProperty.property = "GridFilter";
    diffProperty.orgValue = "a";
    diffProperty.newValue = "b";
    form2.getComponent(compKey);
    diff.properties.push(diffProperty);
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, null, activeForm.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
    if (DetailLength == 0) {
      $("#" + formID + "_GridFilter").find("input").val("");
    } else {
      $("#" + formID + "_GridFilter").find("input").val("已设置");
    }
  }
};
const D_DropdownButton = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  form2.getCallParas().put("compKey", ErpDesignerUI.propertyForm.getParas().get("compKey"));
  $.when(ErpDesignerUI.showRealModal(form2, "D_DropdownButton")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const commitDropdownButtonForm = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
    var propertyForm = ErpDesignerUI.propertyForm;
    var formID = propertyForm.formID;
    var diffProperty = new DiffProperty();
    diff.formKey = ErpDesignerUI.getActiveERPForm().getFormKey();
    diff.metaObjectType = "DropdownButton";
    diff.key = propertyForm.getParas().get("compKey");
    diffProperty.property = "DropdownButton";
    diff.properties.push(diffProperty);
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, null, activeForm.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
    if (document2.maps.get("ED_DropdownButton").rows.length === 0) {
      $("#" + formID + "_DropdownButton").find("input").val("");
    } else {
      $("#" + formID + "_DropdownButton").find("input").val("已设置");
    }
  }
};
const CommitColumnExpand = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
    var propertyForm = ErpDesignerUI.propertyForm;
    var formID = propertyForm.formID;
    var dataTableMap = document2.maps;
    var DetailLength = dataTableMap.get("ED_ColumnExpand").rows.length;
    var paras = propertyForm.getParas();
    var compKey = paras.get("compKey");
    var form2 = ErpDesignerUI.getActiveERPForm();
    let expandDependency = dataTableMap.get("ED_ColumnExpand").getByKey("expanddependency");
    if (expandDependency && !/^[a-zA-Z]\w+/.test(expandDependency)) {
      ErpDesignerUI.showTip("拓展依赖不符合规范, 首位不能为数字", "error");
      return;
    }
    if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
      diff.ContainerKey = form2.paras.map.FormKey;
    }
    diff.formKey = form2.getFormKey();
    diff.metaObjectType = "ColumnExpand";
    diff.ISContainer = true;
    diff.key = compKey;
    diff.sideKey = propertyForm.dataObjectKey;
    diff.DictType = propertyForm.dataObjectKey;
    var diffProperty = new DiffProperty();
    diffProperty.property = "ColumnExpand";
    diffProperty.orgValue = "a";
    diffProperty.newValue = "b";
    form2.getComponent(compKey);
    diff.properties.push(diffProperty);
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, null, activeForm.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
    if (DetailLength == 0) {
      $("#" + formID + "_ColumnExpandTwo").find("input").val("");
    } else {
      $("#" + formID + "_ColumnExpandTwo").find("input").val("已设置");
    }
  }
  await ErpDesignerUtil.closeForm(cxt.form);
};
const CommitDictItemFilter = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
    var dataTableMap = document2.maps;
    var DetailLength = dataTableMap.get("ED_DictFilterValue").rows.length;
    var dictFilter = dataTableMap.get("ED_DictFilter");
    var ImplNum = dictFilter.indexMap.table.implclass;
    var QueryNum = dictFilter.indexMap.table.query;
    var Impl = "", Query = "";
    if (dictFilter.rows.length != 0) {
      Impl = dictFilter.rows[0].vals[ImplNum];
      Query = dictFilter.rows[0].vals[QueryNum];
    }
    var propertyForm = ErpDesignerUI.propertyForm;
    var formID = propertyForm.formID;
    var paras = propertyForm.getParas();
    var compKey = paras.get("compKey");
    var form2 = ErpDesignerUI.getActiveERPForm();
    if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
      diff.ContainerKey = form2.paras.map.FormKey;
    }
    diff.formKey = form2.getFormKey();
    diff.metaObjectType = "ItemFilter";
    diff.ISContainer = true;
    diff.key = compKey;
    diff.sideKey = propertyForm.dataObjectKey;
    diff.DictType = propertyForm.dataObjectKey;
    propertyForm.dataObjectKey;
    var diffProperty = new DiffProperty();
    diffProperty.property = "ItemFilter";
    diffProperty.orgValue = "a";
    diffProperty.newValue = "b";
    diff.properties.push(diffProperty);
    propertyForm.getDocument();
    form2.getComponent(compKey);
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, null, activeForm.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
    if (DetailLength == 0 && Impl == "" && Query == "") {
      $("#" + formID + "_DictFielding").find("input").val("");
    } else {
      $("#" + formID + "_DictFielding").find("input").val("已设置");
    }
  }
};
const checkColumn = async function(evl, name, cxt, args) {
  var type = args[0];
  if (type === "TableKey") {
    var data = {
      type,
      tableKey: args[1],
      formKey: args[2]
    };
    var msg = await ErpDesignerFuns.isHasColumnAndTable(data);
    sessionStorage.setItem("isAdd", msg.msg);
  } else if (type === "ColumnKey") {
    var data1 = {
      type,
      tableKey: args[1],
      columnKey: args[2],
      formKey: args[3]
    };
    ErpDesignerFuns.isHasColumnAndTable(data1);
  }
};
const isAdd = async function(evl, name, cxt, args) {
  if (sessionStorage.getItem("isAdd") != "success") {
    sessionStorage.removeItem("isAdd");
    return false;
  }
  return true;
};
const ClearDOSubDetail = async function(evl, name, cxt, args) {
  var grid = cxt.form.getComponent("Grid2");
  grid.clearGridData();
};
const PathOrCaption = async function(evl, name, cxt, args) {
  if (args[0] === "Path" && typeof ErpDesignerUI.path === "string") {
    return ErpDesignerUI.path;
  }
  if (args[0] === "Caption" && typeof ErpDesignerUI.caption === "string") {
    return ErpDesignerUI.caption;
  }
};
const CloseFormKey = async function(evl, name, cxt, args) {
  var first = args[0];
  if (first != "") {
    var splitElement = first.split("fileName=")[1].split("&")[0];
    for (var sessionStorageKey in sessionStorage) {
      if (sessionStorageKey.indexOf(splitElement) != -1) {
        sessionStorage.removeItem(sessionStorageKey);
      }
    }
  }
  for (let [argumentsKey, dataPath] of ErpDesignerUI.openFormPaths) {
    if (dataPath === first) {
      if (ErpDesignerUI.linkInfo.get(dataPath)) {
        var filePath = ErpDesignerUI.linkInfo.get(dataPath);
        ErpDesignerUI.linkInfo.delete(filePath + "_Path");
        ErpDesignerUI.linkInfo.delete(filePath + "_Key");
        ErpDesignerUI.linkInfo.delete(filePath + "_Caption");
        ErpDesignerUI.linkInfo.delete(dataPath);
      }
      ErpDesignerUI.openFormPaths.delete(argumentsKey);
    }
  }
};
const CloseWEBBPMForm = async function(evl, name, cxt, args) {
  var first = args[0];
  if (first != "") {
    var splitElement = first.split(".xml")[0];
    for (var sessionStorageKey in sessionStorage) {
      if (sessionStorageKey.indexOf(splitElement) != -1) {
        sessionStorage.removeItem(sessionStorageKey);
      }
    }
  }
  for (let [argumentsKey, dataPath] of ErpDesignerUI.openFormPaths) {
    if (dataPath === first) {
      if (ErpDesignerUI.linkInfo.get(dataPath)) {
        var filePath = ErpDesignerUI.linkInfo.get(dataPath);
        ErpDesignerUI.linkInfo.delete(filePath + "_Path");
        ErpDesignerUI.linkInfo.delete(filePath + "_Key");
        ErpDesignerUI.linkInfo.delete(filePath + "_Caption");
        ErpDesignerUI.linkInfo.delete(dataPath);
      }
      ErpDesignerUI.openFormPaths.delete(argumentsKey);
    }
  }
};
const GetFileTreeVisible = async function(evl, name, cxt, args) {
  let gridKey = args[0], type = args[1], form2 = cxt.form, grid = form2 && form2.getComponent(gridKey);
  if (!grid)
    return false;
  let rowIndex = grid.getFocusRowIndex();
  if (rowIndex < 0)
    return false;
  let value2 = grid.getValueByKey(rowIndex, "Type");
  if (type !== value2)
    return false;
  if (type == "project" || type == "solution" || type == "importsolution")
    return true;
  if (type == "fold" || type == "file") {
    let key2 = grid.getValueByKey(rowIndex, "Key");
    let projectKey = grid.getValueByKey(rowIndex, "ProjectKey");
    if (projectKey != "" && (args[2] == "Domain" || args[2] == "DataElement")) {
      return false;
    }
    let substr = key2.substr(key2.indexOf(projectKey) + projectKey.length + 1);
    if (substr.includes("\\" + args[2]) || substr.includes(args[2] + "\\")) {
      if (substr.includes("\\" + args[2])) {
        return substr.indexOf("\\" + args[2]) >= 0;
      } else {
        return substr.indexOf(args[2] + "\\") >= 0;
      }
    } else {
      return substr == args[2];
    }
  }
  return false;
};
const FileTreeCanDelete = async function(evl, name, cxt, args) {
  let gridKey = args[0], form2 = cxt.form, grid = form2 && form2.getComponent(gridKey);
  if (!grid)
    return false;
  let rowIndex = grid.getFocusRowIndex();
  let key2 = grid.getValueByKey(rowIndex, "Key");
  let type = grid.getValueByKey(rowIndex, "Type");
  if (type == "file") {
    let projectKey = grid.getValueByKey(rowIndex, "ProjectKey");
    let substr = key2.substr(key2.indexOf(projectKey) + projectKey.length + 1);
    return substr.indexOf("Form\\") >= 0 || substr.indexOf("DataObject\\") >= 0 || substr.indexOf("ExcelTemplate\\") >= 0 || substr.indexOf("Report\\") >= 0 || substr.indexOf("BPM\\") >= 0 || substr.indexOf("DataMigration\\") >= 0 || substr.indexOf("DataMap\\") >= 0;
  }
  return false;
};
const FileTreeCanRefresh = async function(evl, name, cxt, args) {
  let gridKey = args[0], form2 = cxt.form, grid = form2 && form2.getComponent(gridKey);
  if (!grid)
    return false;
  let rowIndex = grid.getFocusRowIndex();
  let type = grid.getValueByKey(rowIndex, "Type");
  if (type != "file") {
    return true;
  }
  return false;
};
const FileTreeCanCollapse = async function(evl, name, cxt, args) {
  let gridKey = args[0], form2 = cxt.form, grid = form2 && form2.getComponent(gridKey);
  if (!grid)
    return false;
  let rowIndex = grid.getFocusRowIndex();
  let type = grid.getValueByKey(rowIndex, "Type");
  if (type != "file") {
    return grid.getRowDataAt(rowIndex).expanded;
  }
  return false;
};
const isImportSolution = async function(evl, name, cxt, args) {
  let gridKey = args[0], form2 = cxt.form, grid = form2 && form2.getComponent(gridKey);
  if (!grid)
    return false;
  let rowIndex = grid.getFocusRowIndex();
  if (rowIndex < 0)
    return false;
  let value2 = grid.getValueByKey(rowIndex, "Type");
  return value2 === "importsolution";
};
const isNotInJar = async function(evl, name, cxt, args) {
  let gridKey = args[0], form2 = cxt.form, grid = form2 && form2.getComponent(gridKey);
  if (!grid)
    return true;
  let rowIndex = grid.getFocusRowIndex();
  if (rowIndex < 0)
    return true;
  let value2 = grid.getValueByKey(rowIndex, "IsInJar");
  return !value2 || value2 === "false";
};
const GetCreateProject = async function(evl, name, cxt, args) {
  var form2 = cxt.form;
  var pForm = FormStack.getForm(form2.pFormID);
  var gridKey = args[0];
  var grid = pForm && pForm.getComponent(gridKey);
  if (grid) {
    var rowIndex = grid.getFocusRowIndex();
    var projectKey = grid.getValueByKey(rowIndex, "ProjectKey");
    return projectKey;
  }
  return "";
};
const GetCreateSolution = async function(evl, name, cxt, args) {
  var form2 = cxt.form;
  var pForm = FormStack.getForm(form2.pFormID);
  var gridKey = args[0];
  var grid = pForm && pForm.getComponent(gridKey);
  if (grid) {
    var rowIndex = grid.getFocusRowIndex();
    var SolutionKey = grid.getValueByKey(rowIndex, "Key");
    var type = grid.getValueByKey(rowIndex, "Type");
    if (type == "project") {
      SolutionKey = grid.getValueByKey(rowIndex, "ParentKey");
    }
    return SolutionKey;
  }
  return "";
};
const GetCreatePath = async function(evl, name, cxt, args) {
  var form2 = cxt.form;
  var pForm = FormStack.getForm(form2.pFormID);
  var gridKey = args[0];
  var grid = pForm && pForm.getComponent(gridKey);
  if (grid) {
    var rowIndex = grid.getFocusRowIndex();
    var value2 = grid.getValueByKey(rowIndex, "Key");
    if (value2.endsWith(".xml")) {
      value2 = grid.getValueByKey(rowIndex, "ParentKey");
    }
    var valueIndex = value2.lastIndexOf(args[1]);
    return value2.substr(valueIndex + args[1].length + 1);
  }
  return "";
};
const RefreshDesignToolbar = async function(evl, name, cxt, args) {
  var form2 = cxt.form;
  if (form2) {
    await form2.resetUIStatus(FormUIStatusMask.OPERATION);
  }
};
const OpenChase = async function(evl, name, cxt, args) {
  const preOpenTime = ErpDesignerUI.OpenChaseBlockFun;
  ErpDesignerUI.OpenChaseBlockFun = Date.now();
  if (ErpDesignerUI.OpenChaseBlockFun - preOpenTime < 300) {
    return;
  }
  LoadingUtil.show();
  await OpenChase1(evl, name, cxt, args);
  LoadingUtil.hide();
};
const OpenChase1 = async function(evl, name, cxt, args) {
  if (args.length > 5 && args[0] == -1) {
    ErpDesignerUI.activeERPFormKey = ErpDesignerUI.linkInfo.get(args[1] + "_Key");
    args[1] = ErpDesignerUI.linkInfo.get(args[1] + "_Path");
    let path = args[1];
    args[2] = path.substring(0, path.lastIndexOf("\\"));
  }
  if (ErpDesignerUI.IsFirst && ErpDesignerUI.notIsCancel) {
    sessionStorage.removeItem("DataObjectFormkey");
    sessionStorage.removeItem("DataObjectFilePath");
    if (args[1].indexOf("\\") == -1) {
      args[1] = args[1].replace(/\//g, "\\");
    }
    var Xmlkey = args[1].replace(args[2], "").replace("\\", "");
    var OpenKey = Xmlkey.split(".xml");
    var BEopenxmlkey = OpenKey[0];
    var fileType = args[4];
    $(document.body);
    if (fileType === "Process" || fileType === "Report" || fileType === "Workbook" || fileType === "DataMigration" || fileType === "Map") {
      ErpDesignerUI.D_FileTree.setPara("WEBBPMPATH", args[1]);
      if (fileType === "Process") {
        await ErpDesignerUI.RunForm("WEBBPM", false);
      } else if (fileType === "Report") {
        await ErpDesignerUI.RunForm("WEBPRINT", false);
      } else if (fileType === "Workbook") {
        await ErpDesignerUI.RunForm("WEBEXCEL", false);
      } else if (fileType === "DataMigration") {
        await ErpDesignerUI.RunForm("WEBDATAMIGRATION", false);
      } else if (fileType === "Map") {
        await ErpDesignerUI.RunForm("WEBDATAMAP", false);
      }
    } else if (fileType === "Map" || fileType === "DataMigration") {
      $(".ui-anchor-label[title='源代码']").mousedown().mouseup().click();
      await ErpDesignerUI.RunForm("D_WebMap", false);
    } else if (fileType === "DataObject") {
      ErpDesignerFuns.openDataObject(args, BEopenxmlkey);
    } else if (fileType === "CommonDef" || fileType === "Setting" || fileType === "DomainDef" || fileType === "ParaTable" || fileType === "CommonDefVestCollection" || fileType === "Parameter" || fileType === "DataElementDef" || fileType === "NoRights" || fileType === "Enhance" || fileType === "IOSetting" || fileType === "Solution") {
      var tabPanel = ErpDesignerUI.designPanel.getComponent("TabPanel1"), tab = tabPanel.get("SourceTab");
      tab.needRender = true;
      tabPanel.doLayout(tabPanel.getWidth(), tabPanel.getHeight());
      var toolbar = $("#" + tab.formID + "_D_YToolBar1");
      var toolbarlist = $("#" + tab.formID + "_D_YToolBar1_toolbar");
      toolbar.css({ "width": "100%" });
      toolbarlist.css({ "width": "100%" });
      ErpDesignerFuns.loadCommonDefOrSetting(args, args[1], fileType);
      if (args[1].indexOf(".xml") == -1) {
        return;
      }
      $(".ui-anchor-label[title='源代码']").mousedown().mouseup().click();
      LoadingUtil.show();
      await CodeMirrorWorkSpace.XMLEditor.showXml(args[1], BEopenxmlkey, BEopenxmlkey, true);
      LoadingUtil.hide();
    } else if (fileType === "Entry") {
      $(".ui-anchor-label[title='源代码']").mousedown().mouseup().click();
      LoadingUtil.show();
      await CodeMirrorWorkSpace.XMLEditor.showXml(args[1], BEopenxmlkey, BEopenxmlkey, true);
      LoadingUtil.hide();
      var form2 = ErpDesignerUI.D_FileTree;
      form2.getCallParas().put("OwnerFormKey", "D_Entry");
      form2.getCallParas().put("path", args[1]);
      form2.getCallParas().put("Type", "");
      $.when(ErpDesignerUI.showRealModal(form2, "D_Entry")).done(function(newForm) {
        ErpDesignerUI.DesignDivForm = newForm;
        ErpDesignerUI.DesignDivForm.setPara("OwnerFormKey", "D_Entry");
        ErpDesignerUI.DesignDivForm.setComponentValue("FilePath", args[1], false);
        newForm.regEvent(FormEvent.CLOSE, function(opt) {
          ErpDesignerUI.DesignDivForm = null;
        });
      });
    } else if (fileType === "Form") {
      ErpDesignerUI.backstagePath = args[1];
      ErpDesignerUI.path = null;
      ErpDesignerUI.D_FileTree.setPara("FormPath", args[1]);
      var activeERPForm = ErpDesignerUI.getActiveERPForm();
      if (!Xmlkey && Xmlkey.indexOf(".xml") == -1 && !activeERPForm) {
        return;
      }
      var xmlKey = Xmlkey.split(".xml");
      var nowFormKey = activeERPForm == void 0 ? void 0 : activeERPForm.formKey;
      var parasFormKey;
      if (activeERPForm && activeERPForm.paras) {
        parasFormKey = activeERPForm.paras.getMap().FormKey;
      }
      if (BEopenxmlkey && BEopenxmlkey.endsWith("DictEdit") && !parasFormKey) {
        ErpDesignerUI.showTip("请使用菜单Tab界面打开此表单");
        return;
      }
      if (xmlKey.length > 1 && BEopenxmlkey !== nowFormKey && BEopenxmlkey !== parasFormKey) {
        if (!ErpDesignerUI.isNew) {
          await ErpDesignerUI.RunForm(BEopenxmlkey);
          ErpDesignerUI.IsFirst = true;
          return;
        } else {
          ErpDesignerUI.isNew = false;
        }
      }
    } else if (fileType === "BPM") {
      var parentForm = ErpDesignerUI.D_FileTree;
      parentForm.getCallParas().put("bpmPath", args[1]);
      $.when(ErpDesignerUI.showRealModal(parentForm, "BPM_Setting")).done(function(newForm) {
        ErpDesignerUI.DesignDivForm = newForm;
        newForm.regEvent(FormEvent.CLOSE, function(opt) {
          ErpDesignerUI.DesignDivForm = null;
        });
      });
      $(".ui-anchor-label[title='源代码']").mousedown().mouseup().click();
      LoadingUtil.show();
      await CodeMirrorWorkSpace.XMLEditor.showXml(args[1], BEopenxmlkey, BEopenxmlkey, true);
      LoadingUtil.hide();
    } else {
      if (args[1].indexOf(".xml") == -1) {
        return;
      }
      $(".ui-anchor-label[title='源代码']").mousedown().mouseup().click();
      LoadingUtil.show();
      await CodeMirrorWorkSpace.XMLEditor.showXml(args[1], BEopenxmlkey, BEopenxmlkey, true);
      LoadingUtil.hide();
    }
  }
  ErpDesignerUI.IsFirst = true;
};
const OpenDataMigration = async function(name, cxt, args) {
  ErpDesignerUI.activeERPFormKey = ErpDesignerUI.linkInfo.get(args[1] + "_Key");
  args[1] = ErpDesignerUI.linkInfo.get(args[1] + "_Path");
  let dataMigrationPath = args[1];
  let webformKey = args[0];
  if (ErpDesignerUI.IsFirst && ErpDesignerUI.notIsCancel) {
    if (args[1].indexOf("\\") == -1) {
      args[1] = args[1].replace(/\//g, "\\");
    }
    await ErpDesignerUI.RunDataMapForm(false, dataMigrationPath, webformKey, "WEBDATAMIGRATION");
    ErpDesignerUI.IsFirst = true;
  }
};
const OpenDataMap = async function(evl, name, cxt, args) {
  ErpDesignerUI.activeERPFormKey = ErpDesignerUI.linkInfo.get(args[1] + "_Key");
  args[1] = ErpDesignerUI.linkInfo.get(args[1] + "_Path");
  let dataMapPath = args[1];
  let webformKey = args[0];
  if (ErpDesignerUI.IsFirst && ErpDesignerUI.notIsCancel) {
    if (args[1].indexOf("\\") == -1) {
      args[1] = args[1].replace(/\//g, "\\");
    }
    ErpDesignerUI.RunDataMapForm(false, dataMapPath, webformKey, "WEBDATAMAP");
    ErpDesignerUI.IsFirst = true;
  }
};
const loadD_Separate = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var properformcombobox = ErpDesignerUI.propertyForm;
  var propertyKey = properformcombobox.getParas();
  var comkey = propertyKey.get("compKey");
  form2.getCallParas().put("compKey", comkey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_Separate")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const CommitSeparate = async function(evl, name, cxt, args) {
  if (!ErpDesignerUI.DesignDivForm)
    return;
  var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
  var backString = "";
  for (var i = 0; i < document2.tbls[0].rows.length; i++) {
    var Size = document2.tbls[0].rows[i].vals[6], Type = document2.tbls[0].rows[i].vals[7];
    if (Type == "1") {
      Type = "%";
    } else {
      Type = "px";
    }
    if (i == document2.tbls[0].rows.length - 1) {
      backString = backString + "{Size:" + Size + Type + "}";
    } else {
      backString = backString + "{Size:" + Size + Type + "};";
    }
  }
  diff.formKey = activeForm.formKey;
  diff.metaObjectType = "Separate";
  var diffProperty = new DiffProperty();
  diffProperty.property = "Separate";
  diffProperty.orgValue = "oldX";
  diffProperty.newValue = "newX";
  diff.properties.push(diffProperty);
  var properMacro = ErpDesignerUI.propertyForm, propertyKey = properMacro.getParas(), id = properMacro.formID;
  diff.key = propertyKey.get("compKey");
  ErpDesignerUI.enforceLayoutSplitPanelKey = diff.key;
  let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, null, activeForm.paras.map.FormKey);
  ErpDesignerUI.enforceLayoutSplitPanelKey = void 0;
  if (!successFlag) {
    return;
  }
  $("#" + id + "_Separate").find("input").val(backString);
};
const ComboBox = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var properformcombobox = ErpDesignerUI.propertyForm;
  var propertyKey = properformcombobox.getParas();
  var comkey = propertyKey.get("compKey");
  form2.getCallParas().put("compKey", comkey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_ComboBox")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const UICheckRuleCollection = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  form2.getCallParas().put("SelectComKey", ErpDesigner.selectComponentKey);
  var properformcombobox = ErpDesignerUI.propertyForm;
  var propertyKey = properformcombobox.getParas();
  var comkey = propertyKey.get("compKey");
  form2.getCallParas().put("compKey", comkey);
  var parentKey = propertyKey.get("parentKey");
  form2.getCallParas().put("parentKey", parentKey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_UICheckRuleCollection")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const GridTree = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  form2.getCallParas().put("SelectComKey", ErpDesigner.selectComponentKey);
  var properformcombobox = ErpDesignerUI.propertyForm;
  var propertyKey = properformcombobox.getParas();
  var comkey = propertyKey.get("compKey");
  form2.getCallParas().put("compKey", comkey);
  form2.getCallParas().put("parentKey", propertyKey.get("parentKey"));
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_GridTreeProperties")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const DictViewColumn = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  var properformcombobox = ErpDesignerUI.propertyForm;
  var comkey = properformcombobox.getValue("Key");
  form2.getCallParas().put("compKey", comkey);
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_DictViewColumn")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const Macro = async function(evl, name, cxt, args) {
  ErpDesignerUI.activeERPFormKey = args[6];
  ErpDesigner.selectedFormKey = args[6];
  var form2 = ErpDesignerUI.getActiveERPForm();
  var formStack = FormStack;
  var formList = formStack.getFormList();
  for (var j = 0; j < formList.length; j++) {
    if (formList[j].formKey == ErpDesignerUI.activeERPFormKey) {
      form2 = formList[j];
    }
  }
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_NewMacro")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const commitMacro = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = ErpDesignerUI.DesignDivForm.getDocument();
    diff.formKey = activeForm.formKey;
    diff.metaObjectType = "Macro";
    var diffProperty = new DiffProperty();
    diffProperty.property = "Macro";
    diffProperty.orgValue = "oldX";
    diffProperty.newValue = "newX";
    diff.properties.push(diffProperty);
    var properMacro = ErpDesignerUI.propertyForm;
    var propertyKey = properMacro.getParas();
    diff.key = propertyKey.get("compKey");
    await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, null, activeForm.paras.map.FormKey);
  }
};
const commitComboBOxForm = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm();
    activeForm.document;
    var document2 = ErpDesignerUI.DesignDivForm.getDocument();
    diff.formKey = activeForm.getFormKey();
    diff.metaObjectType = "comboBoxType";
    var diffProperty = new DiffProperty();
    diffProperty.property = "Item";
    diffProperty.orgValue = "oldX";
    diffProperty.newValue = "newX";
    diff.properties.push(diffProperty);
    diff.ISContainer = true;
    var properformcombobox = ErpDesignerUI.propertyForm;
    var propertyKey = properformcombobox.getParas();
    if (activeForm.entryParas && activeForm.getDefContainer() && activeForm.paras.map.FormKey) {
      activeForm.getCallParas().put("ContainerKey", activeForm.paras.map.FormKey);
    }
    diff.key = propertyKey.get("compKey");
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, void 0, activeForm.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
    try {
      var cols = document2.tbls[0].cols;
      var indexOf = (cols || []).findIndex(function(item) {
        return item.key === "Key";
      });
      var formID = properformcombobox.formID;
      var val = document2.tbls[0].rows[0].vals[indexOf];
      if (null != val) {
        $("#" + formID + "_Item").find("input").val("已设置");
      } else {
        $("#" + formID + "_Item").find("input").val("");
      }
    } catch (e) {
      $("#" + formID + "_Item").find("input").val("");
    }
  }
};
const commitGridRowTree = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm();
    activeForm.document;
    var document2 = ErpDesignerUI.DesignDivForm.getDocument();
    diff.formKey = activeForm.getFormKey();
    diff.metaObjectType = "GridRowTree";
    var diffProperty = new DiffProperty();
    diffProperty.property = "Item";
    diffProperty.orgValue = "oldX";
    diffProperty.newValue = "newX";
    diff.properties.push(diffProperty);
    diff.ISContainer = true;
    var properformcombobox = ErpDesignerUI.propertyForm;
    var propertyKey = properformcombobox.getParas();
    if (activeForm.entryParas && activeForm.getDefContainer() && activeForm.paras.map.FormKey) {
      activeForm.getCallParas().put("ContainerKey", activeForm.paras.map.FormKey);
    }
    diff.key = propertyKey.get("compKey");
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, void 0, activeForm.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
    try {
      var cols = document2.tbls[0].cols;
      var indexOf = (cols || []).findIndex(function(item) {
        return item.key === "Key";
      });
      var formID = properformcombobox.formID;
      var val = document2.tbls[0].rows[0].vals[indexOf];
      if (null != val) {
        $("#" + formID + "_RowTree").find("input").val("已设置");
      } else {
        $("#" + formID + "_RowTree").find("input").val("");
      }
    } catch (e) {
      $("#" + formID + "_Item").find("input").val("");
    }
  }
};
const commitUICheckRule = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm();
    activeForm.document;
    var document2 = ErpDesignerUI.DesignDivForm.getDocument();
    diff.formKey = activeForm.getFormKey();
    diff.metaObjectType = "UICheckRule";
    var diffProperty = new DiffProperty();
    diffProperty.property = "Item";
    diffProperty.orgValue = "oldX";
    diffProperty.newValue = "newX";
    diff.properties.push(diffProperty);
    diff.ISContainer = true;
    var properformcombobox = ErpDesignerUI.propertyForm;
    var propertyKey = properformcombobox.getParas();
    if (activeForm.entryParas && activeForm.getDefContainer() && activeForm.paras.map.FormKey) {
      activeForm.getCallParas().put("ContainerKey", activeForm.paras.map.FormKey);
    }
    diff.key = propertyKey.get("compKey");
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, void 0, activeForm.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
    try {
      var cols = document2.tbls[0].cols;
      var indexOf = (cols || []).findIndex(function(item) {
        return item.key === "Key";
      });
      var formID = properformcombobox.formID;
      var val = document2.tbls[0].rows[0].vals[indexOf];
      if (null != val) {
        $("#" + formID + "_UICheckRule").find("input").val("UICheckRuleCollection");
      } else {
        $("#" + formID + "_UICheckRule").find("input").val("");
      }
    } catch (e) {
      $("#" + formID + "_Item").find("input").val("");
    }
  }
};
const commitDictViewColumn = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm();
    activeForm.document;
    var document2 = ErpDesignerUI.DesignDivForm.getDocument();
    diff.formKey = activeForm.getFormKey();
    diff.metaObjectType = "DictViewColumn";
    var diffProperty = new DiffProperty();
    diffProperty.property = "Item";
    diffProperty.orgValue = "oldX";
    diffProperty.newValue = "newX";
    diff.properties.push(diffProperty);
    diff.ISContainer = true;
    var properformcombobox = ErpDesignerUI.propertyForm;
    diff.key = properformcombobox.getValue("Key");
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, void 0, activeForm.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
    try {
      var cols = document2.tbls[0].cols;
      var indexOf = (cols || []).findIndex(function(item) {
        return item.key === "Key";
      });
      var formID = properformcombobox.formID;
      var val = document2.tbls[0].rows[0].vals[indexOf];
      if (null != val) {
        $("#" + formID + "_Item").find("input").val("已设置");
      } else {
        $("#" + formID + "_Item").find("input").val("");
      }
    } catch (e) {
      $("#" + formID + "_Item").find("input").val("");
    }
  }
};
const ToolBar = async function(evl, name, cxt, args) {
  ErpDesignerUI.activeERPFormKey = args[6];
  ErpDesigner.selectedFormKey = args[6];
  let isExtensionForm = args[7];
  var form2 = ErpDesignerUI.getActiveERPForm();
  let beforeBuilder = function(form22) {
    ErpDesignerUI.DesignDivForm = form22;
    ErpDesignerUI.DesignDivForm.setPara("OwnerFormKey", ErpDesignerUI.activeERPFormKey);
  };
  $.when(ErpDesignerUI.showRealModal(form2, "D_OperationToobar", [null, beforeBuilder])).done(function(newForm) {
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
      ErpDesignerUI.isLoadToolBar = false;
      ErpDesignerUI.DesignCodeMirrorEditor = null;
    });
    if (isExtensionForm) {
      let macroFormulaRootEmbed = newForm.getComponent("MacroFormulaRootEmbed");
      macroFormulaRootEmbed.setVisible(false);
      let scriptListRootEmbed = newForm.getComponent("ScriptListRootEmbed");
      scriptListRootEmbed.setVisible(false);
      let queryCollectionRootEmbed = newForm.getComponent("QueryCollectionRootEmbed");
      queryCollectionRootEmbed.setVisible(false);
    }
  });
};
const D_EmbedVar = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.DesignDivForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), formDocument = activeForm.document, document2 = ErpDesignerUI.DesignDivForm.getDocument();
    diff.formKey = activeForm.getFormKey();
    diff.metaObjectType = "EmbedVar";
    var diffProperty = new DiffProperty();
    diffProperty.property = "Item";
    diffProperty.orgValue = "oldX";
    diffProperty.newValue = "newX";
    diff.properties.push(diffProperty);
    diff.ISContainer = true;
    var properformcombobox = ErpDesignerUI.propertyForm;
    var propertyKey = properformcombobox.getParas();
    diff.key = propertyKey.get("compKey");
    await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, formDocument, activeForm.paras.map.FormKey);
  }
};
const designerEntryByUpdate = async function(evl, name, cxt, args) {
  var subKey = args[3], parentKey = args[2], subType = args[0], newValue = args[4], name = args[1], params = {
    cmd: "UpdateEntry",
    service: "DesignService",
    subKey,
    parentKey,
    name,
    newValue,
    subType,
    filePath: args[5]
  }, uiCommands = await new Request().getData(params);
  if (uiCommands == null || uiCommands == void 0) {
    ErpDesignerUI.showTip("修改失败");
  } else {
    if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
      return;
    }
    var activeForm = ErpDesignerUI.getActiveERPForm();
    await ErpDesignerUI.doUICommands(activeForm, uiCommands);
    ErpDesignerUI.showTip("修改成功", "success");
  }
};
const checkAllSpec = async function(evl, name, cxt, args) {
  function checkSystemKey(evl2, name2, cxt2, args2) {
    var columnKey = args2[0];
    if (columnKey == SystemField.OID_SYS_KEY || columnKey == SystemField.SOID_SYS_KEY || columnKey == SystemField.POID_SYS_KEY || columnKey == SystemField.VERID_SYS_KEY || columnKey == "DocumentNumber" || columnKey == "SequenceValue" || columnKey == "ResetPattern" || columnKey == SystemField.DVERID_SYS_KEY) {
      return false;
    }
    return true;
  }
  function checkReportDataSource(cxt2) {
    if (isReportType(cxt2) == "Report") {
      return "PersistFalse";
    }
  }
  function checkVariableReport() {
    var activeForm = ErpDesignerUI.getActiveERPForm();
    if (activeForm && activeForm.type == FormType.REPORT) {
      if (activeForm.getComponent("StatisticalDimension") != null && (activeForm.getComponent("StatisticalDimension").getValue() == "" || activeForm.getComponent("StatisticalDimension").getValue() == null)) {
        ErpDesignerUI.showTip("统计维度没有设置默认值", "warning");
      }
      if (activeForm.getComponent("ShowCol") != null && (activeForm.getComponent("ShowCol").getValue() == "" || activeForm.getComponent("ShowCol").getValue() == null)) {
        ErpDesignerUI.showTip("显示列没有设置默认值", "warning");
      }
    }
  }
  async function checkKeyAndFileName(evl2, name2, cxt2, args2) {
    var activeERPForm = ErpDesignerUI.getActiveERPForm();
    var filePath = args2[0], content = args2[1];
    var params = {
      cmd: "CheckKeyAndFileName",
      service: "DesignService",
      filePath,
      content,
      InDataObject: ""
    }, uiCommands = await new Request().getData(params);
    if (uiCommands.length > 0) {
      await ErpDesignerUI.doUICommands(activeERPForm, uiCommands);
      return "false";
    }
  }
  var flag = args[0];
  args.shift();
  switch (flag) {
    case "checkBillModifyAndNew":
      return await checkBillModifyAndNew(evl, name, cxt, args);
    case "checkKeyAndFileName":
      return await checkKeyAndFileName(evl, name, cxt, args);
    case "checkSystemKey":
      return checkSystemKey(evl, name, cxt, args);
    case "checkBindingField":
      return checkBindingField(evl, name, cxt, args);
    case "checkIsReportNewTable":
      return isReportType(cxt);
    case "checkReportDataSource":
      return checkReportDataSource(cxt);
    case "checkVariableReport":
      return checkVariableReport();
    case "checkBindingPrecision":
      return checkBindingPrecision(evl, name, cxt, args);
  }
};
function isReportType(cxt) {
  var activeForm = ErpDesignerUI.getActiveERPForm();
  if (!activeForm || cxt.form.getPara("ShowObjectType") == "DataObject") {
    return "";
  }
  if (activeForm.type == FormType.REPORT) {
    return "Report";
  }
}
async function checkBillModifyAndNew(evl, name, cxt, args) {
  function checkReportHeadField(evl2, name2, cxt2, args2) {
    var columnKey2 = args2[2];
    var billType = args2[3];
    if (billType == FormType.REPORT && columnKey2 != null) {
      ErpDesignerUI.showTip("报表表头字段不建议绑定数据源", "warning");
    }
  }
  var flag = args[0];
  var result = await checkKeySpec(evl, name, cxt, args);
  if (result != "false") {
    if (flag == "newHead") {
      var columnKey = args[2], tableKey = args[4], controlType = args[5], isMultiDict = args[6], tbls = cxt.form.getParentForm().getDocument().tbls;
      if (isMultiDict != null && isMultiDict) {
        controlType = "MultiDict";
      }
      if (!await checkBindingType(evl, name, cxt, [columnKey, tableKey, controlType, tbls])) {
        return "false";
      }
      checkReportHeadField(evl, name, cxt, args);
    } else if (flag == "newGrid") {
      var columnKey = args[2], tableKey = args[3], controlType = args[4], isMultiDict = args[5], tbls = cxt.form.getParentForm().getDocument().tbls;
      if (isMultiDict != null && isMultiDict) {
        controlType = "MultiDict";
      }
      if (!await checkBindingType(evl, name, cxt, [columnKey, tableKey, controlType, tbls])) {
        return "false";
      }
    } else if (flag == "modify" && (args[1] == "Precision" || args[1] == "ColumnKey")) {
      var tableKey = args[2], columnKey = cxt.form.getComponent("ColumnKey").getValue();
      var fieldCom = cxt.form.getComponent("ControlType") == null ? cxt.form.getComponent("CellType") : cxt.form.getComponent("ControlType");
      if (fieldCom != null) {
        var controlType = fieldCom.getValue();
        var activeForm = ErpDesignerUI.getActiveERPForm();
        var tbls = activeForm.getDocument() ? activeForm.getDocument().tbls : null;
        if (tbls == null) {
          return true;
        }
        var multiDictCom = cxt.form.getComponent("AllowMultiSelection");
        var isMultiDict = multiDictCom != null ? multiDictCom.getValue() : "false";
        if (isMultiDict == "true") {
          controlType = "MultiDict";
        }
        let precision = cxt.form.getComponent("Precision").getValue().toNumber();
        if (!await checkBindingType(evl, name, cxt, [columnKey, tableKey, controlType, tbls, precision])) {
          return "false";
        }
      }
    }
  }
  return result;
}
function checkColumnType(controlType, columnType) {
  if (controlType == "TextEditor" || controlType == "TextArea" || controlType == "TextButton" || controlType == "RichEditor") {
    return true;
  }
  switch (columnType) {
    case DataType.INT:
      if (!(controlType == "NumberEditor" || controlType == "ComboBox" || controlType == "CheckListBox" || controlType == "DropdownButton" || controlType == "MonthPicker" || controlType == "CheckBox")) {
        ErpDesignerUI.showTip("操作失败，失败原因：此类控件数据源列标识类型不能为整型");
        return false;
      }
      break;
    case DataType.STRING:
      if (!(controlType == "MultiDict" || controlType == "ComboBox" || controlType == "CheckListBox" || controlType == "DropdownButton" || controlType == "CheckBox" || controlType == "RadioButton" || controlType == "PasswordEditor" || controlType == "Image" || controlType == "HyperLink" || controlType == "Label" || controlType == "TimePicker")) {
        ErpDesignerUI.showTip("操作失败，失败原因：此类控件数据源列标识类型不能为字符串");
        return false;
      }
      break;
    case DataType.DATE:
      if (controlType != "DatePicker") {
        //!(controlType == "UTCDatePicker") || controlType == "DatePicker"
        ErpDesignerUI.showTip("操作失败，失败原因：此类控件数据源列标识类型不能为日期");
        return false;
      }
      break;
    case DataType.DATETIME:
      if (controlType != "DatePicker") {
        ErpDesignerUI.showTip("操作失败，失败原因：此类控件数据源列标识类型不能为日期时间");
        return false;
      }
      break;
    case DataType.NUMERIC:
      if (controlType != "NumberEditor") {
        ErpDesignerUI.showTip("操作失败，失败原因：此类控件数据源列标识类型不能为数值类型");
        return false;
      }
      break;
    case DataType.LONG:
      if (!(controlType == "Dict" || controlType == "DynamicDict" || controlType == "NumberEditor" || controlType == "ComboBox" || controlType == "CheckListBox" || controlType == "DropdownButton" || controlType == "UTCDatePicker" || controlType == "TimePicker" || controlType == "MonthPicker")) {
        ErpDesignerUI.showTip("操作失败，失败原因：此类控件数据源列标识类型不能为长整型");
        return false;
      }
      break;
    case DataType.TEXT:
      ErpDesignerUI.showTip("操作失败，失败原因：此类控件数据源列标识类型不能为文本");
      return false;
  }
  return true;
}
async function checkNumPrecision(name, cxt, args) {
  var activeForm = ErpDesignerUI.getActiveERPForm();
  let formKey = activeForm.getFormKey();
  let tableKey = args[1];
  let columnKey = args[0];
  let precision = args[2];
  let columnType = args[3];
  let params = {
    cmd: "CheckNumPrecision",
    service: "DesignService",
    formKey,
    tableKey,
    columnKey,
    precision,
    columnType
  };
  let uiCommands = await new Request().getData(params);
  if (uiCommands == null)
    return true;
  ErpDesignerUI.doUICommands(activeForm, uiCommands);
  return false;
}
function checkBindingPrecision(evl, name, cxt, args) {
  let activeForm = ErpDesignerUI.getActiveERPForm();
  if (!activeForm && cxt.form.getPara("ShowObjectType") == "DataObject") {
    return "noCheck";
  }
  let tableKey = args[0], columnKey = args[1], columnType = args[2], dataTableMode = args[3], newPrecision = parseInt(args[4]);
  let bindingComp = null;
  let controlType;
  let compList = activeForm.getComponentList();
  if (dataTableMode == 1) {
    for (let key2 in compList) {
      let com = compList[key2];
      if (com.tableKey === tableKey) {
        bindingComp = com.getMetaCellByColumnKey(columnKey);
        break;
      }
    }
    if (bindingComp != null) {
      controlType = bindingComp.cellType;
    }
  } else {
    for (let key2 in compList) {
      let com = compList[key2];
      if (com.tableKey === tableKey && com.getColumnKey() === columnKey) {
        bindingComp = com;
        break;
      }
    }
    if (bindingComp != null) {
      controlType = bindingComp.type;
    }
  }
  if (controlType == 210) {
    let bindPrecision = bindingComp.precision;
    if (newPrecision < bindPrecision) {
      ErpDesignerUI.showTip("操作失败，失败原因：数值精度不能小于其绑定的数值控件的数值精度");
      return cxt.form.getOldValue();
    }
    if (columnType == 1005 && newPrecision != bindPrecision) {
      ErpDesignerUI.showTip("操作失败，失败原因：数据源列类型为数值类型，数值精度需要与其绑定的数值控件的数值精度一致");
      return cxt.form.getOldValue();
    }
  }
  return true;
}
function checkBindingField(evl, name, cxt, args) {
  var activeForm = ErpDesignerUI.getActiveERPForm();
  if (!activeForm && cxt.form.getPara("ShowObjectType") == "DataObject") {
    return "noCheck";
  }
  var tableKey = args[0], columnKey = args[1], columnType = args[2], dataTableMode = args[3];
  var bindingComp = null;
  var controlType;
  var isMultiDict = false;
  var compList = activeForm.getComponentList();
  if (dataTableMode == 1) {
    for (var key2 in compList) {
      var com = compList[key2];
      if (com.tableKey === tableKey) {
        bindingComp = com.getMetaCellByColumnKey(columnKey);
        break;
      }
    }
    if (bindingComp != null) {
      controlType = bindingComp.cellType;
      if (controlType == ControlType.DICT && bindingComp.editOptions["allowMultiSelection"] == true) {
        isMultiDict = true;
      }
    }
  } else {
    for (var key2 in compList) {
      var com = compList[key2];
      if (com.tableKey === tableKey && com.getColumnKey() === columnKey) {
        bindingComp = com;
        break;
      }
    }
    if (bindingComp != null) {
      controlType = bindingComp.type;
      if (controlType == ControlType.DICT && bindingComp.multiSelect) {
        isMultiDict = true;
      }
    }
  }
  if (controlType != void 0) {
    var controlTypeStr = ErpDesignerUtil.getControlTypeStr(controlType);
    if (isMultiDict) {
      controlTypeStr = "MultiDict";
    }
    columnType = parseInt(columnType);
    if (!checkColumnType(controlTypeStr, columnType)) {
      return cxt.form.getOldValue();
    }
  }
  return true;
}
async function checkBindingType(evl, name, cxt, args) {
  var columnKey = args[0], tableKey = args[1], controlType = args[2], tbls = args[3];
  var columnType;
  for (var i = 0; i < tbls.length; i++) {
    if (tbls[i].key == tableKey) {
      var column = tbls[i].getColByKey(columnKey, false);
      if (column != null && column != void 0) {
        columnType = column.getType();
        break;
      }
    }
  }
  if (checkColumnType(controlType, columnType)) {
    if (controlType == "NumberEditor") {
      let precision = args[4];
      if (precision == void 0) {
        if (columnType == 1001) {
          precision = 9;
        } else {
          precision = 16;
        }
      }
      return await checkNumPrecision(name, cxt, [columnKey, tableKey, precision, columnType]);
    }
    return true;
  }
  return false;
}
async function checkKeySpec(evl, name, cxt, args) {
  function isMirror(fieldKey) {
    if (!fieldKey.endsWith("_mirror")) {
      if (!/_mirror[1-9]$/.test(fieldKey)) {
        return false;
      }
    }
    return true;
  }
  function isSqlKeyWord(fieldKey) {
    var sqlKeyWords = [
      "ADD",
      "ALL",
      "ALTER",
      "ANALYZE",
      "AND",
      "AS",
      "ASC",
      "ASENSITIVE",
      "BEFORE",
      "BETWEEN",
      "BIGINT",
      "BINARY",
      "BLOB",
      "BOTH",
      "BY",
      "CALL",
      "CASCADE",
      "CASE",
      "CHANGE",
      "CHAR",
      "CHARACTER",
      "CHECK",
      "COLLATE",
      "COLUMN",
      "CONDITION",
      "CONNECTION",
      "CONSTRAINT",
      "CONTINUE",
      "CONVERT",
      "CREATE",
      "CROSS",
      "CURRENT_DATE",
      "CURRENT_TIME",
      "CURRENT_TIMESTAMP",
      "CURRENT_USER",
      "CURSOR",
      "DATABASE",
      "DATABASES",
      "DAY_HOUR",
      "DAY_MICROSECOND",
      "DAY_MINUTE",
      "DAY_SECOND",
      "DEC",
      "DECIMAL",
      "DECLARE",
      "DEFAULT",
      "DELAYED",
      "DELETE",
      "DESC",
      "DESCRIBE",
      "DETERMINISTIC",
      "DISTINCT",
      "DISTINCTROW",
      "DIV",
      "DOUBLE",
      "DROP",
      "DUAL",
      "EACH",
      "ELSE",
      "ELSEIF",
      "ENCLOSED",
      "ESCAPED",
      "EXISTS",
      "EXIT",
      "EXPLAIN",
      "FALSE",
      "FETCH",
      "FLOAT",
      "FLOAT4",
      "FLOAT8",
      "FOR",
      "FORCE",
      "FOREIGN",
      "FROM",
      "FULLTEXT",
      "GOTO",
      "GRANT",
      "GROUP",
      "HAVING",
      "HIGH_PRIORITY",
      "HOUR_MICROSECOND",
      "HOUR_MINUTE",
      "HOUR_SECOND",
      "IF",
      "IGNORE",
      "IN",
      "INDEX",
      "INFILE",
      "INNER",
      "INOUT",
      "INSENSITIVE",
      "INSERT",
      "INT",
      "INT1",
      "INT2",
      "INT3",
      "INT4",
      "INT8",
      "INTEGER",
      "INTERVAL",
      "INTO",
      "IS",
      "ITERATE",
      "JOIN",
      "KEY",
      "KEYS",
      "KILL",
      "LABEL",
      "LEADING",
      "LEAVE",
      "LEFT",
      "LIKE",
      "LIMIT",
      "LINEAR",
      "LINES",
      "LOAD",
      "LOCALTIME",
      "LOCALTIMESTAMP",
      "LOCK",
      "LONG",
      "LONGBLOB",
      "LONGTEXT",
      "LOOP",
      "LOW_PRIORITY",
      "MATCH",
      "MEDIUMBLOB",
      "MEDIUMINT",
      "MEDIUMTEXT",
      "MIDDLEINT",
      "MINUTE_MICROSECOND",
      "MINUTE_SECOND",
      "MOD",
      "MODIFIES",
      "NATURAL",
      "NOT",
      "NO_WRITE_TO_BINLOG",
      "NULL",
      "NUMERIC",
      "ON",
      "OPTIMIZE",
      "OPTION",
      "OPTIONALLY",
      "OR",
      "ORDER",
      "OUT",
      "OUTER",
      "OUTFILE",
      "PRECISION",
      "PRIMARY",
      "PROCEDURE",
      "PURGE",
      "RAID0",
      "RANGE",
      "READ",
      "READS",
      "REAL",
      "REFERENCES",
      "REGEXP",
      "RELEASE",
      "RENAME",
      "REPEAT",
      "REPLACE",
      "REQUIRE",
      "RESTRICT",
      "RETURN",
      "REVOKE",
      "RIGHT",
      "RLIKE",
      "SCHEMA",
      "SCHEMAS",
      "SECOND_MICROSECOND",
      "SELECT",
      "SENSITIVE",
      "SEPARATOR",
      "SET",
      "SHOW",
      "SMALLINT",
      "SPATIAL",
      "SPECIFIC",
      "SQL",
      "SQLEXCEPTION",
      "SQLSTATE",
      "SQLWARNING",
      "SQL_BIG_RESULT",
      "SQL_CALC_FOUND_ROWS",
      "SQL_SMALL_RESULT",
      "SSL",
      "STARTING",
      "STRAIGHT_JOIN",
      "TABLE",
      "TERMINATED",
      "THEN",
      "TINYBLOB",
      "TINYINT",
      "TINYTEXT",
      "TO",
      "TRAILING",
      "TRIGGER",
      "TRUE",
      "UNDO",
      "UNION",
      "UNIQUE",
      "UNLOCK",
      "UNSIGNED",
      "UPDATE",
      "USAGE",
      "USE",
      "USING",
      "UTC_DATE",
      "UTC_TIME",
      "UTC_TIMESTAMP",
      "VALUES",
      "VARBINARY",
      "VARCHAR",
      "VARCHARACTER",
      "VARYING",
      "WHEN",
      "WHERE",
      "WHILE",
      "WITH",
      "WRITE",
      "X509",
      "XOR",
      "YEAR_MONTH",
      "ZEROFILL"
    ];
    for (var i2 = 0; i2 < sqlKeyWords.length; i2++) {
      if (fieldKey.toLowerCase() == sqlKeyWords[i2].toLowerCase()) {
        return true;
      }
    }
    return false;
  }
  function isNonSenseSuffix(fieldKey) {
    if (/_[0-9a-zA-Z]$/.test(fieldKey) || /_[Cc][Oo][Pp][Yy]$/.test(fieldKey) || /_[Cc][Oo][Pp][Yy][0-9]$/.test(fieldKey)) {
      return true;
    }
    return false;
  }
  function isStatusField(key22, controlType2, columnKey2) {
    if (key22.toLowerCase() == "Status".toLowerCase()) {
      if (columnKey2 != "Status" || !(controlType2 == ControlType.COMBOBOX || controlType2 == 2040 || controlType2 == "ComboBox")) {
        return false;
      } else {
        return true;
      }
    }
    return true;
  }
  var flag = args[0];
  if (flag == "modify") {
    var propertyKey = args[1];
    var com = cxt.form.getComponent(propertyKey);
    let newValue = com.getValue();
    let oldValue = com.getOldValue();
    var key2;
    if (propertyKey == "Key") {
      key2 = newValue;
      if (isNonSenseSuffix(key2)) {
        ErpDesignerUI.showTip("操作失败，失败原因：字段标识不允许以无意义后缀结尾");
        com.setValue(oldValue);
        com.backupValue = oldValue;
        return "false";
      }
      if (isSqlKeyWord(key2)) {
        ErpDesignerUI.showTip("操作失败，失败原因：字段标识不允许使用SQL关键字");
        com.setValue(oldValue);
        com.backupValue = oldValue;
        return "false";
      }
    } else if (propertyKey == "ColumnKey") {
      if (newValue == "无字段") {
        return;
      }
      key2 = cxt.form.getComponent("Key").getValue();
    } else if (propertyKey == "BindingCellKey" || propertyKey == "Precision") {
      key2 = cxt.form.getComponent("Key").getValue();
    }
    let bindingCellComponent = cxt.form.getComponent("BindingCellKey");
    if (bindingCellComponent && bindingCellComponent.getValue() && bindingCellComponent.getValue().length > 0) {
      if (!isMirror(key2)) {
        ErpDesignerUI.showTip("操作失败，失败原因：镜像字段要以_mirror(_mirror1、_mirror2)结尾");
        com.setValue(oldValue);
        com.backupValue = oldValue;
        return "false";
      }
    } else {
      var fieldCom = cxt.form.getComponent("ControlType") == null ? cxt.form.getComponent("CellType") : cxt.form.getComponent("ControlType");
      if (fieldCom != null) {
        var controlType = fieldCom.getValue();
        if (cxt.form.getComponent("ColumnKey") == null) {
          return;
        }
        var columnKey = cxt.form.getComponent("ColumnKey").getValue();
        if (!isStatusField(key2, controlType, columnKey)) {
          ErpDesignerUI.showTip("操作失败，失败原因：不允许未绑定系统字段Status的非下拉框控件使用Status命名");
          com.setValue(oldValue);
          com.backupValue = oldValue;
          return "false";
        }
        switch (controlType) {
          case "Dict":
            if (!(newValue.endsWith("ID") || isMirror(newValue))) {
              ErpDesignerUI.showTip("操作失败，失败原因：字典标识或数据源列标识要以ID结尾");
              com.setValue(oldValue);
              com.backupValue = oldValue;
              return "false";
            }
            break;
          case "CheckBox":
            if (!(newValue.startsWith("Is") || isMirror(newValue))) {
              ErpDesignerUI.showTip("操作失败，失败原因：复选框标识或数据源列标识要以Is开头");
              com.setValue(oldValue);
              com.backupValue = oldValue;
              return "false";
            }
            break;
          case "DatePicker":
            if (!(newValue.endsWith("Time") || isMirror(newValue))) {
              ErpDesignerUI.showTip("操作失败，失败原因：时间控件标识或数据源列标识要以Time结尾");
              com.setValue(oldValue);
              com.backupValue = oldValue;
              return "false";
            }
            break;
          case "UTCDatePicker":
            if (!(newValue.endsWith("Date") || isMirror(newValue))) {
              ErpDesignerUI.showTip("操作失败，失败原因：日期控件标识或数据源列标识要以Date结尾");
              com.setValue(oldValue);
              com.backupValue = oldValue;
              return "false";
            }
            break;
        }
      }
    }
    if (propertyKey == "Key") {
      if (key2.length > 64) {
        ErpDesignerUI.showTip("标识不建议超过64位", "warning");
      }
      key2 = key2.substring(0, 1).toUpperCase() + newValue.substring(1);
      com.value = key2;
    }
  } else if (flag == "newHead" || flag == "newGrid") {
    var Key = args[1];
    var columnKey = args[2];
    if (isNonSenseSuffix(Key)) {
      ErpDesignerUI.showTip("操作失败，失败原因：标识不允许以无意义后缀结尾");
      return "false";
    }
    if (isSqlKeyWord(Key)) {
      ErpDesignerUI.showTip("操作失败，失败原因：字段标识不允许使用SQL关键字");
      return "false";
    }
    var fieldCom = cxt.form.getComponent("ControlType") == null ? cxt.form.getComponent("CellType") : cxt.form.getComponent("ControlType");
    if (fieldCom != null) {
      var controlType = fieldCom.getValue();
      if (!isStatusField(Key, controlType, columnKey)) {
        ErpDesignerUI.showTip("操作失败，失败原因：不允许未绑定系统字段Status的非下拉框控件使用Status命名");
        return "false";
      }
      switch (controlType) {
        case 2060:
        case ControlType.DICT:
          if (!(Key.endsWith("ID") || isMirror(Key))) {
            ErpDesignerUI.showTip("操作失败，失败原因：字典标识要以ID结尾");
            return "false";
          }
          if (columnKey != null && !columnKey.endsWith("ID")) {
            ErpDesignerUI.showTip("操作失败，失败原因：字典数据源列标识要以ID结尾");
            return "false";
          }
          break;
        case 2010:
        case ControlType.CHECKBOX:
          if (!(Key.startsWith("Is") || isMirror(Key))) {
            ErpDesignerUI.showTip("操作失败，失败原因：复选框标识要以Is开头");
            return "false";
          }
          if (columnKey != null && !columnKey.startsWith("Is")) {
            ErpDesignerUI.showTip("操作失败，失败原因：复选框数据源列标识要以Is开头");
            return "false";
          }
          break;
        case 2850:
        case ControlType.TIMEPICKER:
        case 2050:
        case ControlType.DATEPICKER:
          if (!(Key.endsWith("Time") || isMirror(Key))) {
            ErpDesignerUI.showTip("操作失败，失败原因：时间控件标识要以Time结尾");
            return "false";
          }
          if (columnKey != null && !columnKey.endsWith("Time")) {
            ErpDesignerUI.showTip("操作失败，失败原因：时间控件数据源列标识要以Time结尾");
            return "false";
          }
          break;
        case 2540:
        case ControlType.UTCDATEPICKER:
          if (!(Key.endsWith("Date") || isMirror(Key))) {
            ErpDesignerUI.showTip("操作失败，失败原因：日期控件标识要以Date结尾");
            return "false";
          }
          if (columnKey != null && !columnKey.endsWith("Date")) {
            ErpDesignerUI.showTip("操作失败，失败原因：日期控件数据源列标识要以Date结尾");
            return "false";
          }
          break;
      }
    }
    if (Key.length > 64) {
      ErpDesignerUI.showTip("标识不建议超过64位", "warning");
    }
    Key = Key.substring(0, 1).toUpperCase() + Key.substring(1);
    return Key;
  } else if (flag == "billKey") {
    var formKey = args[1];
    var configKey = args[2];
    var keyComps = formKey.split("_");
    if (keyComps.length > 1) {
      if (!(keyComps[0].toLowerCase() == configKey.split("config")[0].toLowerCase())) {
        ErpDesignerUI.showTip("建议表单标识以“模块名_”开头", "warning");
        keyComps[0] = keyComps[0].substring(0, 1).toUpperCase() + keyComps[0].substring(1);
      } else {
        keyComps[0] = keyComps[0].toUpperCase();
      }
      for (var i = 1; i < keyComps.length; i++) {
        keyComps[i] = keyComps[i].substring(0, 1).toUpperCase() + keyComps[i].substring(1);
      }
      formKey = keyComps.join("_");
    } else {
      formKey = formKey.substring(0, 1).toUpperCase() + formKey.substring(1);
      ErpDesignerUI.showTip("建议表单标识以“模块名_”开头", "warning");
    }
    return formKey;
  } else if (flag == "configKey") {
    var projectCaption = args[1];
    var keyRule = /^[a-zA-Z]\w+$/;
    if (keyRule.test(projectCaption)) {
      projectCaption = projectCaption.toUpperCase();
      if (projectCaption.length < 2 || projectCaption.length > 4) {
        ErpDesignerUI.showTip("建议模块命名长度为2-4个英文字符", "warning");
      }
    } else {
      ErpDesignerUI.showTip("建议模块命名全部为英文大写", "warning");
    }
    return projectCaption;
  }
}
const CommitPropertyDiff = async function(evl, name, cxt, args) {
  var attr = $(cxt.form.getRoot().getEl().getElm()).parent().parent().parent().attr("id");
  if (attr && !attr.endsWith("PropertyContainerRoot") && !attr.endsWith("BoundaryContainerRoot")) {
    return;
  }
  if (name != "CommitPropertyDiff" && !(name.toLowerCase() == "EditExpressionWin".toLowerCase())) {
    return;
  }
  var propertyForm = ErpDesignerUI.propertyForm, propertyKey = args[0], activeForm = ErpDesignerUI.getActiveERPForm(), formdocument = activeForm.document, diff = new Diff();
  diff.reserveOne = "CommitDiff";
  diff.parentKey = ErpDesignerUI.ownerDetail;
  diff.propertyValueByLocation = args[1];
  diff.formKey = activeForm.formKey;
  if (activeForm.getDefContainer() && activeForm.getDefContainer().form) {
    activeForm = activeForm.getDefContainer().form;
  }
  if (ErpDesignerUI.DesignDivForm) {
    propertyForm = ErpDesignerUI.DesignDivForm;
    diff.reserveOne = args[0];
  }
  if (args[0] == "ColumnKey" || args[0] == "Key" || args[0] == "BindingCellKey" || args[0] == "Precision") {
    var tableKey = args[2];
    if (args[0] == "Precision") {
      if (cxt.form.getFormKey() == "D_GridFieldModule") {
        tableKey = cxt.form.getComponent("RowTableKeys").getValue();
      } else {
        tableKey = cxt.form.getComponent("TableKey").getValue();
      }
    }
    var result = await checkAllSpec(evl, name, cxt, ["checkBillModifyAndNew", "modify", propertyKey, tableKey]);
    if (result == "false") {
      return;
    }
    if (args[0] == "ColumnKey") {
      diff.reserveTwo = args[2];
    }
  }
  if (args[0] == "RowType") {
    var com = cxt.form.getComponent(propertyKey);
    let oldValue1 = com.getOldValue();
    let value1 = com.getValue();
    if (oldValue1 != "Detail" && value1 == "Detail") {
      ErpDesignerUI.showTip("操作失败，失败原因：只能存在一个明细行");
      com.setValue(oldValue1);
      com.backupValue = oldValue1;
      return;
    }
  }
  if (args[0] == "BorderRadius") {
    var com = cxt.form.getComponent(propertyKey);
    let newValue1 = com.getValue();
    let oldValue2 = com.getOldValue();
    if (newValue1 < 0) {
      com.setValue(oldValue2);
      com.backupValue = oldValue2;
      return;
    }
  }
  if (args[0] == "TabOrder" || args[0] == "MaxLength") {
    var com = cxt.form.getComponent(propertyKey);
    let newValue1 = com.getValue();
    let oldValue2 = com.getOldValue();
    if (newValue1 < -1) {
      com.setValue(oldValue2);
      com.backupValue = oldValue2;
      return;
    }
  }
  if (args[0] == "StateMask") {
    var com = cxt.form.getComponent(propertyKey);
    let newValue1 = com.getValue();
    com.getOldValue();
    if (newValue1 == "") {
      com.setValue("Enable,Disable,Discard");
      com.backupValue = "Enable,Disable,Discard";
      return;
    }
  }
  if (args[0] == "CellType") {
    var com = cxt.form.getComponent(propertyKey);
    let items = com.items;
    let newValue2 = com.getValue();
    let oldValue2 = com.getOldValue();
    let isCorrctCT = false;
    for (let i = 0; i < items.length; i++) {
      if (items[i].value == newValue2) {
        isCorrctCT = true;
        break;
      }
    }
    if (!isCorrctCT) {
      com.setValue(oldValue2);
      com.backupValue = oldValue2;
      return;
    }
  }
  var com1;
  switch (args[0]) {
    case "Enable":
    case "Visible":
      com1 = cxt.form.getComponent(args[0] + "Dependency");
      break;
    case "DefaultFormulaValue":
      com1 = cxt.form.getComponent("ValueDependency");
      break;
    case "CheckRule":
      com1 = cxt.form.getComponent("CheckDependency");
      break;
    case "FormulaCaption":
      com1 = cxt.form.getComponent("CaptionDependency");
      break;
    default:
      com1 = null;
      break;
  }
  var Dependency;
  if (com1) {
    if (com1.getValue() && !(typeof com1.getValue() === "boolean")) {
      if (typeof com1.getValue() === "number" && !isNaN(com1.getValue())) {
        Dependency = String(com1.getValue());
      } else {
        Dependency = com1.getValue();
      }
    } else {
      if (typeof com1.getValue() === "boolean") {
        if (com1.getValue() === false) {
          Dependency = false;
          diff.trueOrfalse = false;
        } else {
          Dependency = true;
          diff.trueOrfalse = true;
        }
      } else {
        Dependency = com1.getValue();
      }
    }
    diff.reserveTwo = Dependency;
  }
  if (propertyForm.formKey.indexOf("GridField") !== -1) {
    diff.metaObjectType = "GridField";
    diff.controlType = propertyForm.getValue("CellType");
  } else if (propertyForm.formKey.indexOf("Form") !== -1) {
    diff.metaObjectType = "Form";
  } else if (propertyForm.formKey.indexOf("D_GridHeadColumn") !== -1) {
    diff.metaObjectType = "GridHeadColumn";
  } else if (propertyForm.formKey.indexOf("D_ListViewColumn") !== -1) {
    diff.metaObjectType = "ListViewField";
    diff.controlType = propertyForm.getValue("ColumnType");
  } else if (propertyForm.formKey.indexOf("Operation") !== -1 && propertyForm.formKey.toLowerCase() == "D_Operation".toLowerCase()) {
    diff.metaObjectType = "Operation";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("OperationCollection") !== -1) {
    diff.metaObjectType = "OperationCollection";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("Panel") !== -1) {
    diff.metaObjectType = "Panel";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("SubDetail") !== -1) {
    diff.metaObjectType = "SubDetail";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("GridRow") !== -1) {
    diff.metaObjectType = "GridRow";
  } else if (propertyForm.formKey.indexOf("Grid") !== -1) {
    diff.metaObjectType = "Grid";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("ListView") !== -1) {
    diff.metaObjectType = "ListView";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("Fieldinformation") != -1) {
    diff.metaObjectType = "Fieldinformation";
  } else if (propertyForm.formKey.indexOf("Field") !== -1) {
    diff.metaObjectType = "Field";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("BasicAttribute") != -1) {
    diff.metaObjectType = "BasicAttribute";
  } else if (propertyForm.formKey.indexOf("ToolBar") != -1) {
    diff.metaObjectType = "ToolBar";
  } else if (propertyForm.formKey.indexOf("Macro") != -1) {
    diff.metaObjectType = "Formula";
  } else if (propertyForm.formKey.indexOf("D_Embed") != -1) {
    diff.metaObjectType = "D_Embed";
  } else if (propertyForm.formKey.indexOf("D_DictView") != -1) {
    diff.metaObjectType = "D_DictView";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("Chart") != -1) {
    diff.metaObjectType = "Chart";
  }
  if (propertyKey == "CellType") {
    diff.metaObjectType = "GridCellType";
  }
  var diffProperty = new DiffProperty();
  var _propertyKey = propertyKey;
  if (propertyKey.match(new RegExp("^[A-Za-z0-9]*_[A-Za-z0-9]*$"))) {
    var words = propertyKey.split("_");
    _propertyKey = words[words.length - 1];
  }
  diffProperty.property = _propertyKey;
  var com = cxt.form.getComponent(propertyKey);
  if (!com) {
    return;
  }
  var oldValue, newValue;
  if (com.getOldValue() && typeof com.getOldValue() !== "boolean") {
    if (typeof com.getOldValue() === "number" && !isNaN(com.getOldValue()) || typeof com.getOldValue() === "object" && !isNaN(com.getOldValue())) {
      oldValue = String(com.getOldValue());
    } else {
      oldValue = com.getOldValue();
    }
  } else {
    if (typeof com.getOldValue() === "boolean") {
      if (com.getOldValue() === false) {
        oldValue = false;
      } else {
        oldValue = true;
      }
    } else {
      oldValue = com.getOldValue();
    }
  }
  if (com.getValue() && typeof com.getValue() !== "boolean") {
    if (typeof com.getValue() === "number" && !isNaN(com.getValue()) || typeof com.getValue() === "object" && !isNaN(com.getValue())) {
      newValue = String(com.getValue());
    } else {
      newValue = com.getValue();
    }
  } else {
    if (typeof com.getValue() === "boolean") {
      if (com.getValue() === false) {
        newValue = false;
        diff.trueOrfalse = false;
      } else {
        newValue = true;
        diff.trueOrfalse = true;
      }
    } else {
      newValue = com.getValue();
    }
  }
  try {
    var examinationOldValue;
    var examinationNewValue;
    examinationOldValue = String(com.getOldValue()).replace(/[\r\n]/g, "");
    examinationNewValue = String(com.getValue()).replace(/[\r\n]/g, "");
    examinationOldValue = examinationOldValue.replace(/\ +/g, "");
    examinationNewValue = examinationNewValue.replace(/\ +/g, "");
    if (examinationOldValue === examinationNewValue) {
      return;
    }
  } catch (e) {
    if (String(com.getOldValue()) === String(com.getValue())) {
      return;
    }
  }
  if (oldValue === null && newValue === "") {
    return;
  }
  if (newValue === null && oldValue === "") {
    return;
  }
  diffProperty.orgValue = oldValue;
  diffProperty.newValue = newValue;
  diffProperty.propertyParent = "";
  let uiCommands = await ErpDesignerService.parseFormula(ErpDesignerUI.getActiveERPForm().formKey, "One", newValue, args[0]);
  if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
    return;
  }
  switch (args[0]) {
    case "ColumnKey":
    case "TableKey":
    case "ValueValidation":
    case "ValueChanging":
    case "ValueChanged":
    case "ValueDependency":
    case "CheckDependency":
    case "CheckRule":
    case "Required":
    case "ErrorInfo":
      diffProperty.propertyValueByLocation = "DataBinding";
      break;
    case "ValueChangeAction":
      diffProperty.propertyValueByLocation = "DataBinding";
      diffProperty.propertyIsCData = true;
      break;
    case "DefaultFormulaValue":
    case "DefaultValue":
      if (propertyForm.formKey != "D_ListViewColumn") {
        diffProperty.propertyValueByLocation = "DataBinding";
      }
      break;
    case "DblClick":
      diffProperty.propertyValueByLocation = "DblClick";
      diffProperty.propertyIsCData = true;
      break;
    case "OnClick":
      diffProperty.propertyValueByLocation = "OnClick";
      diffProperty.propertyIsCData = true;
      break;
    case "KeyEnter":
      diffProperty.propertyValueByLocation = "KeyEnter";
      diffProperty.propertyIsCData = true;
      break;
    case "Activate":
      diffProperty.propertyValueByLocation = "Activate";
      diffProperty.propertyIsCData = true;
      break;
    case "ExpandType":
      diffProperty.propertyParent = "RowExpand";
      break;
    case "OnSelect":
      diffProperty.propertyValueByLocation = "OnSelect";
      diffProperty.propertyIsCData = true;
      break;
    case "CellKey":
      diffProperty.propertyParent = "RowExpand";
      ErpDesignerUI.needResetFormDocument = true;
      break;
    case "RowExpand":
      diffProperty.propertyValueByLocation = "RowExpand";
      diffProperty.propertyIsCData = true;
      break;
    case "ItemChanged":
      diffProperty.propertyValueByLocation = "ItemChanged";
      diffProperty.propertyIsCData = true;
      break;
    case "RowInsert":
      diffProperty.propertyValueByLocation = "RowInsert";
      diffProperty.propertyIsCData = true;
      break;
    case "OnRowDelete":
      diffProperty.propertyValueByLocation = "OnRowDelete";
      diffProperty.propertyIsCData = true;
      break;
    case "RowClick":
      diffProperty.propertyValueByLocation = "RowClick";
      diffProperty.propertyIsCData = true;
      break;
    case "RowDelete":
      diffProperty.propertyValueByLocation = "RowDelete";
      diffProperty.propertyIsCData = true;
      break;
    case "FocusRowChanged":
      diffProperty.propertyValueByLocation = "FocusRowChanged";
      diffProperty.propertyIsCData = true;
      break;
    case "FormulaItems":
      diffProperty.propertyValueByLocation = "FormulaItems";
      diffProperty.propertyIsCData = true;
      break;
    case "Action":
      diffProperty.propertyValueByLocation = "Action";
      diffProperty.propertyIsCData = true;
      break;
    case "RowDblClick":
      diffProperty.propertyValueByLocation = "RowDblClick";
      diffProperty.propertyIsCData = true;
      break;
    case "Font":
    case "Size":
    case "Bold":
    case "Italic":
      diffProperty.propertyValueByLocation = "Font";
      diffProperty.propertyParent = "Format";
      break;
    case "OnPostShow":
      diffProperty.propertyValueByLocation = "OnPostShow";
      diffProperty.propertyIsCData = true;
      break;
    case "FormOverflowX":
      diffProperty.propertyValueByLocation = "Body";
      diffProperty.property = "OverflowX";
      break;
    case "FormOverflowY":
      diffProperty.propertyValueByLocation = "Body";
      diffProperty.property = "OverflowY";
      break;
    case "Resizable":
      diffProperty.propertyValueByLocation = "Body";
      break;
    case "LeftMargin":
    case "RightMargin":
    case "TopMargin":
    case "BottomMargin":
      diffProperty.newValue = newValue + "px";
      if (args[1] === "FormBoundary") {
        diffProperty.propertyValueByLocation = "Body";
      }
      break;
    case "LeftPadding":
    case "BottomPadding":
    case "RightPadding":
    case "TopPadding":
      diffProperty.newValue = newValue + "px";
      break;
    case "OnLoad":
      diffProperty.propertyValueByLocation = "OnLoad";
      diffProperty.propertyIsCData = true;
      break;
    case "HighlightColor":
    case "ForeColor":
    case "BackColor":
      if (args[0] === "HAlign" && newValue === "-1") {
        diffProperty.newValue = "";
      }
      if (propertyForm.formKey === "D_FieldProperty" || propertyForm.formKey === "D_PanelProperty" || propertyForm.formKey === "D_ListViewColumn" || propertyForm.formKey === "D_Embed") {
        diffProperty.propertyValueByLocation = "Format";
      }
      break;
    case "VAlign":
    case "HAlign":
      if (args[0] === "HAlign" && newValue === "-1") {
        diffProperty.newValue = "";
      }
      if (propertyForm.formKey === "D_FieldProperty" || propertyForm.formKey === "D_ListViewColumn") {
        diffProperty.propertyValueByLocation = "Format";
      } else {
        diffProperty.propertyValueByLocation = "CellFormat";
      }
      break;
    case "Height":
      var value2 = propertyForm.getValue("HSizeType");
      if (value2 != null && value2 != "pref" && value2 != "auto" && value2 != "inherit") {
        if (newValue != "") {
          diffProperty.newValue = newValue + value2;
        } else {
          diffProperty.newValue = "0" + value2;
        }
      } else if (value2) {
        diffProperty.newValue = value2;
      } else {
        diffProperty.newValue = newValue + "px";
      }
      break;
    case "Width":
      var value2 = propertyForm.getValue("WSizeType");
      if (value2 != null && value2 != "pref" && value2 != "auto" && value2 != "inherit") {
        if (newValue != "") {
          diffProperty.newValue = newValue + value2;
        } else {
          diffProperty.newValue = "0" + value2;
        }
      } else if (value2) {
        diffProperty.newValue = value2;
      } else {
        diffProperty.newValue = newValue + "px";
      }
      break;
    case "PopWidth":
      diffProperty.propertyValueByLocation = "Body";
      var value2 = propertyForm.getValue("WSizeType");
      if (value2 != null && value2 != "pref" && value2 != "auto" && value2 != "inherit") {
        if (newValue != "") {
          diffProperty.newValue = newValue + value2;
        } else {
          diffProperty.newValue = "0" + value2;
        }
      } else if (value2) {
        diffProperty.newValue = value2;
      } else {
        diffProperty.newValue = newValue + "px";
      }
      break;
    case "MinHeight":
      var value2 = propertyForm.getValue("MSizeType");
      if (value2 != null && value2 != "pref" && value2 != "auto" && value2 != "inherit") {
        if (newValue != "") {
          diffProperty.newValue = newValue + value2;
        } else {
          diffProperty.newValue = "0" + value2;
        }
      } else if (value2) {
        diffProperty.newValue = value2;
      } else {
        diffProperty.newValue = newValue + "px";
      }
      break;
    case "PopHeight":
      diffProperty.propertyValueByLocation = "Body";
      var value2 = propertyForm.getValue("HSizeType");
      if (value2 != null && value2 != "pref" && value2 != "auto" && value2 != "inherit") {
        if (newValue != "") {
          diffProperty.newValue = newValue + value2;
        } else {
          diffProperty.newValue = "0" + value2;
        }
      } else if (value2) {
        diffProperty.newValue = value2;
      } else {
        diffProperty.newValue = newValue + "px";
      }
      break;
    case "SelectedValue":
      diffProperty.property = "Value";
      break;
    case "ListTableKey":
      diffProperty.property = "TableKey";
      break;
    case "GroupKeyT":
      diffProperty.property = "GroupKey";
      break;
    case "GroupKeyP":
      diffProperty.property = "GroupKey";
      break;
    case "ImageSource":
      diffProperty.property = "SourceType";
      break;
    case "ChartSourceType":
      diffProperty.property = "SourceType";
      break;
    case "WebBrowserSourceType":
      diffProperty.property = "SourceType";
      break;
    case "PageIndicatorCount":
      if (newValue < 3) {
        diffProperty.newValue = 3;
      }
      break;
    case "OnClose":
      diffProperty.propertyValueByLocation = "OnClose";
      diffProperty.propertyIsCData = true;
      break;
  }
  if (args[0] === "DefaultFormulaValue" || args[0] === "CheckRule" || args[0] === "ValueChanged") {
    if (diffProperty.newValue.length > 50 || diffProperty.newValue.indexOf("\r\n") != -1 || diffProperty.newValue.indexOf("\n") != -1 || diffProperty.newValue.indexOf("	") != -1 || diffProperty.newValue.indexOf("\r") != -1) {
      diffProperty.propertyIsCData = true;
    }
  }
  diff.key = propertyForm.getValue("Key");
  if (!diff.key) {
    diff.key = ErpDesigner.selectComponentKey;
  }
  diff.properties.push(diffProperty);
  let successFlag;
  if (propertyKey === "ColumnKey" || propertyKey === "RowTableKey") {
    successFlag = await ErpDesignerService.commitPropertyDiff(diff.formKey, [diff], void 0, formdocument, activeForm.paras.map.FormKey, propertyKey);
  } else if ((propertyKey == "Key" || propertyKey == "Caption") && name !== "CommitPropertyDiff") {
    return;
  } else {
    if (diff.controlType === "SplitPanel" && propertyKey === "Orientation") {
      ErpDesignerUI.enforceLayoutSplitPanelKey = diff.key;
    }
    successFlag = await ErpDesignerService.commitPropertyDiff(ErpDesignerUI.activeERPFormKey, [diff], void 0, formdocument, activeForm.paras.map.FormKey, propertyKey);
    ErpDesignerUI.enforceLayoutSplitPanelKey = void 0;
  }
  if (!successFlag) {
    return;
  }
  ErpDesignerUI.diffs.push(diff);
  if (propertyKey == "Key") {
    ErpDesigner.selectedComponentKey = newValue;
  }
  if ((propertyKey == "Key" || propertyKey == "Caption") && name !== "CommitPropertyDiff") {
    return;
  }
  setTimeout(async function() {
    if (propertyKey === "ColumnKey") {
      var formID = propertyForm.formID;
      var document2 = propertyForm.getDocument();
      var cols = document2.getByKey("ED_DataBinding").cols;
      var indexOf = (cols || []).findIndex(function(item) {
        return item.key === "GetColumnKey";
      });
      if (!document2.getByKey("ED_DataBinding").rows[0].vals[indexOf]) {
        return;
      }
      var val = document2.getByKey("ED_DataBinding").rows[0].vals[indexOf].split(" ")[0].replace(/\s/g, "");
      var reg = new RegExp("[a-zA-Z0-9_.,\\-/;\\[\\]‘\\\\${}^|~\\n\\r\\t ]{1,35}");
      if (reg.test(val)) {
        var dataobjectParams = {
          formKey: activeForm.formKey,
          columnKey: val
        };
        let r = new Request();
        r.addHeader("content-type", "application/json;charset=UTF-8");
        let res = await r.getData(dataobjectParams, ErpDesigner.url + "DesignerController/checkColumn");
        if (typeof res === "string") {
          $("#" + formID + "_ColumnKey").find("input").val(res);
          $("#" + formID + "_ColumnKey").attr("title", res);
        } else {
          $("#" + formID + "_ColumnKey").find("input").val("");
        }
      } else if (val == "无字段") {
        $("#" + formID + "_TableKey").find("input").val("无数据表");
        $("#" + formID + "_ColumnKey").find("input").val(val);
      } else {
        $("#" + formID + "_ColumnKey").find("input").val("");
      }
    } else if (diffProperty.newValue && propertyKey === "DefaultValue") {
      var formID = propertyForm.formID;
      await propertyForm.getComponent("DefaultFormulaValue").setValue("");
    } else if (diffProperty.newValue && propertyKey === "DefaultFormulaValue") {
      var formID = propertyForm.formID;
      await propertyForm.getComponent("DefaultValue").setValue("");
    } else if (diffProperty.newValue && propertyKey === "ItemKey" && diffProperty.newValue.endsWith("__Dic")) {
      await propertyForm.getComponent("StateMask").setValue("Enable,Disable,Discard");
    }
  }, 100);
  if (args[0] == "FormulaItems") {
    let com2 = activeForm.getComponent(diff.key);
    if (com2) {
      let metaObj = com2.getMetaObj();
      let prop = metaObj.properties;
      let items = await com2.handler.getFormulaItems(activeForm, prop);
      var data = {};
      data.key = prop.key;
      data.formKey = activeForm.getFormKey();
      let cache = com2.handler.getCache();
      cache.set(JSON.stringify(data), items);
    }
  }
};
const CommitDiff = async function(evl, name, cxt, args) {
  var attr = $(cxt.form.getRoot().getEl().getElm()).parent().parent().parent().attr("id");
  if (attr && !attr.endsWith("PropertyContainerRoot") && !attr.endsWith("BoundaryContainerRoot")) {
    return;
  }
  if (name != "CommitDiff" && !(name.toLowerCase() == "EditExpressionWin".toLowerCase())) {
    return;
  }
  var propertyForm = ErpDesignerUI.propertyForm, propertyKey = args[0], activeForm = ErpDesignerUI.getActiveERPForm(), formdocument = activeForm.document, diff = new Diff();
  diff.reserveOne = "CommitDiff";
  diff.parentKey = ErpDesignerUI.ownerDetail;
  diff.propertyValueByLocation = args[1];
  diff.formKey = activeForm.formKey;
  if (activeForm.getDefContainer() && activeForm.getDefContainer().form) {
    activeForm = activeForm.getDefContainer().form;
  }
  if (ErpDesignerUI.DesignDivForm) {
    propertyForm = ErpDesignerUI.DesignDivForm;
    diff.reserveOne = args[0];
  }
  if (args[0] == "ColumnKey" || args[0] == "Key" || args[0] == "BindingCellKey" || args[0] == "Precision") {
    var tableKey = args[2];
    if (args[0] == "Precision") {
      if (cxt.form.getFormKey() == "D_GridFieldModule") {
        tableKey = cxt.form.getComponent("RowTableKeys").getValue();
      } else {
        tableKey = cxt.form.getComponent("TableKey").getValue();
      }
    }
    var result = await checkAllSpec(evl, name, cxt, ["checkBillModifyAndNew", "modify", propertyKey, tableKey]);
    if (result == "false") {
      return;
    }
    if (args[0] == "ColumnKey") {
      diff.reserveTwo = args[2];
    }
  }
  if (args[0] == "RowType") {
    var com = cxt.form.getComponent(propertyKey);
    let oldValue1 = com.getOldValue();
    let value1 = com.getValue();
    if (oldValue1 != "Detail" && value1 == "Detail") {
      ErpDesignerUI.showTip("操作失败，失败原因：只能存在一个明细行");
      com.setValue(oldValue1);
      com.backupValue = oldValue1;
      return;
    }
  }
  if (args[0] == "BorderRadius") {
    var com = cxt.form.getComponent(propertyKey);
    let newValue1 = com.getValue();
    let oldValue2 = com.getOldValue();
    if (newValue1 < 0) {
      com.setValue(oldValue2);
      com.backupValue = oldValue2;
      return;
    }
  }
  if (args[0] == "TabOrder" || args[0] == "MaxLength") {
    var com = cxt.form.getComponent(propertyKey);
    let newValue1 = com.getValue();
    let oldValue2 = com.getOldValue();
    if (newValue1 < -1) {
      com.setValue(oldValue2);
      com.backupValue = oldValue2;
      return;
    }
  }
  if (args[0] == "StateMask") {
    var com = cxt.form.getComponent(propertyKey);
    let newValue1 = com.getValue();
    com.getOldValue();
    if (newValue1 == "") {
      com.setValue("Enable,Disable,Discard");
      com.backupValue = "Enable,Disable,Discard";
      return;
    }
  }
  if (args[0] == "CellType") {
    var com = cxt.form.getComponent(propertyKey);
    let items = com.items;
    let newValue2 = com.getValue();
    let oldValue2 = com.getOldValue();
    let isCorrctCT = false;
    for (let i = 0; i < items.length; i++) {
      if (items[i].value == newValue2) {
        isCorrctCT = true;
        break;
      }
    }
    if (!isCorrctCT) {
      com.setValue(oldValue2);
      com.backupValue = oldValue2;
      return;
    }
  }
  var com1;
  switch (args[0]) {
    case "Enable":
    case "Visible":
      com1 = cxt.form.getComponent(args[0] + "Dependency");
      break;
    case "DefaultFormulaValue":
      com1 = cxt.form.getComponent("ValueDependency");
      break;
    case "CheckRule":
      com1 = cxt.form.getComponent("CheckDependency");
      break;
    case "FormulaCaption":
      com1 = cxt.form.getComponent("CaptionDependency");
      break;
    default:
      com1 = null;
      break;
  }
  var Dependency;
  if (com1) {
    if (com1.getValue() && !(typeof com1.getValue() === "boolean")) {
      if (typeof com1.getValue() === "number" && !isNaN(com1.getValue())) {
        Dependency = String(com1.getValue());
      } else {
        Dependency = com1.getValue();
      }
    } else {
      if (typeof com1.getValue() === "boolean") {
        if (com1.getValue() === false) {
          Dependency = false;
          diff.trueOrfalse = false;
        } else {
          Dependency = true;
          diff.trueOrfalse = true;
        }
      } else {
        Dependency = com1.getValue();
      }
    }
    diff.reserveTwo = Dependency;
  }
  if (propertyForm.formKey.indexOf("GridField") !== -1) {
    diff.metaObjectType = "GridField";
    diff.controlType = propertyForm.getValue("CellType");
  } else if (propertyForm.formKey.indexOf("Form") !== -1) {
    diff.metaObjectType = "Form";
  } else if (propertyForm.formKey.indexOf("D_GridHeadColumn") !== -1) {
    diff.metaObjectType = "GridHeadColumn";
  } else if (propertyForm.formKey.indexOf("D_ListViewColumn") !== -1) {
    diff.metaObjectType = "ListViewField";
    diff.controlType = propertyForm.getValue("ColumnType");
  } else if (propertyForm.formKey.indexOf("Operation") !== -1 && propertyForm.formKey.toLowerCase() == "D_Operation".toLowerCase()) {
    diff.metaObjectType = "Operation";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("OperationCollection") !== -1) {
    diff.metaObjectType = "OperationCollection";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("Panel") !== -1) {
    diff.metaObjectType = "Panel";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("SubDetail") !== -1) {
    diff.metaObjectType = "SubDetail";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("GridRow") !== -1) {
    diff.metaObjectType = "GridRow";
  } else if (propertyForm.formKey.indexOf("Grid") !== -1) {
    diff.metaObjectType = "Grid";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("ListView") !== -1) {
    diff.metaObjectType = "ListView";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("Fieldinformation") != -1) {
    diff.metaObjectType = "Fieldinformation";
  } else if (propertyForm.formKey.indexOf("Field") !== -1) {
    diff.metaObjectType = "Field";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("BasicAttribute") != -1) {
    diff.metaObjectType = "BasicAttribute";
  } else if (propertyForm.formKey.indexOf("ToolBar") != -1) {
    diff.metaObjectType = "ToolBar";
  } else if (propertyForm.formKey.indexOf("Macro") != -1) {
    diff.metaObjectType = "Formula";
  } else if (propertyForm.formKey.indexOf("D_Embed") != -1) {
    diff.metaObjectType = "D_Embed";
  } else if (propertyForm.formKey.indexOf("D_DictView") != -1) {
    diff.metaObjectType = "D_DictView";
    diff.controlType = propertyForm.getValue("ControlType");
  } else if (propertyForm.formKey.indexOf("Chart") != -1) {
    diff.metaObjectType = "Chart";
  }
  if (propertyKey == "CellType") {
    diff.metaObjectType = "GridCellType";
  }
  var diffProperty = new DiffProperty();
  var _propertyKey = propertyKey;
  if (propertyKey.match(new RegExp("^[A-Za-z0-9]*_[A-Za-z0-9]*$"))) {
    var words = propertyKey.split("_");
    _propertyKey = words[words.length - 1];
  }
  diffProperty.property = _propertyKey;
  var com = cxt.form.getComponent(propertyKey);
  if (!com) {
    return;
  }
  var oldValue, newValue;
  if (com.getOldValue() && typeof com.getOldValue() !== "boolean") {
    if (typeof com.getOldValue() === "number" && !isNaN(com.getOldValue()) || typeof com.getOldValue() === "object" && !isNaN(com.getOldValue())) {
      oldValue = String(com.getOldValue());
    } else {
      oldValue = com.getOldValue();
    }
  } else {
    if (typeof com.getOldValue() === "boolean") {
      if (com.getOldValue() === false) {
        oldValue = false;
      } else {
        oldValue = true;
      }
    } else {
      oldValue = com.getOldValue();
    }
  }
  if (com.getValue() && typeof com.getValue() !== "boolean") {
    if (typeof com.getValue() === "number" && !isNaN(com.getValue()) || typeof com.getValue() === "object" && !isNaN(com.getValue())) {
      newValue = String(com.getValue());
    } else {
      newValue = com.getValue();
    }
  } else {
    if (typeof com.getValue() === "boolean") {
      if (com.getValue() === false) {
        newValue = false;
        diff.trueOrfalse = false;
      } else {
        newValue = true;
        diff.trueOrfalse = true;
      }
    } else {
      newValue = com.getValue();
    }
  }
  try {
    var examinationOldValue;
    var examinationNewValue;
    examinationOldValue = String(com.getOldValue()).replace(/[\r\n]/g, "");
    examinationNewValue = String(com.getValue()).replace(/[\r\n]/g, "");
    examinationOldValue = examinationOldValue.replace(/\ +/g, "");
    examinationNewValue = examinationNewValue.replace(/\ +/g, "");
    if (examinationOldValue === examinationNewValue) {
      return;
    }
  } catch (e) {
    if (String(com.getOldValue()) === String(com.getValue())) {
      return;
    }
  }
  if (oldValue === null && newValue === "") {
    return;
  }
  if (newValue === null && oldValue === "") {
    return;
  }
  diffProperty.orgValue = oldValue;
  diffProperty.newValue = newValue;
  diffProperty.propertyParent = "";
  let uiCommands = await ErpDesignerService.parseFormula(ErpDesignerUI.getActiveERPForm().formKey, "One", newValue, args[0]);
  if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
    return;
  }
  switch (args[0]) {
    case "ColumnKey":
    case "TableKey":
    case "ValueValidation":
    case "ValueChanging":
    case "ValueChanged":
    case "ValueDependency":
    case "CheckDependency":
    case "CheckRule":
    case "Required":
    case "ErrorInfo":
      diffProperty.propertyValueByLocation = "DataBinding";
      break;
    case "ValueChangeAction":
      diffProperty.propertyValueByLocation = "DataBinding";
      diffProperty.propertyIsCData = true;
      break;
    case "DefaultFormulaValue":
    case "DefaultValue":
      if (propertyForm.formKey != "D_ListViewColumn") {
        diffProperty.propertyValueByLocation = "DataBinding";
      }
      break;
    case "DblClick":
      diffProperty.propertyValueByLocation = "DblClick";
      diffProperty.propertyIsCData = true;
      break;
    case "OnClick":
      diffProperty.propertyValueByLocation = "OnClick";
      diffProperty.propertyIsCData = true;
      break;
    case "KeyEnter":
      diffProperty.propertyValueByLocation = "KeyEnter";
      diffProperty.propertyIsCData = true;
      break;
    case "Activate":
      diffProperty.propertyValueByLocation = "Activate";
      diffProperty.propertyIsCData = true;
      break;
    case "ExpandType":
      diffProperty.propertyParent = "RowExpand";
      break;
    case "OnSelect":
      diffProperty.propertyValueByLocation = "OnSelect";
      diffProperty.propertyIsCData = true;
      break;
    case "CellKey":
      diffProperty.propertyParent = "RowExpand";
      ErpDesignerUI.needResetFormDocument = true;
      break;
    case "RowExpand":
      diffProperty.propertyValueByLocation = "RowExpand";
      diffProperty.propertyIsCData = true;
      break;
    case "ItemChanged":
      diffProperty.propertyValueByLocation = "ItemChanged";
      diffProperty.propertyIsCData = true;
      break;
    case "RowInsert":
      diffProperty.propertyValueByLocation = "RowInsert";
      diffProperty.propertyIsCData = true;
      break;
    case "OnRowDelete":
      diffProperty.propertyValueByLocation = "OnRowDelete";
      diffProperty.propertyIsCData = true;
      break;
    case "RowClick":
      diffProperty.propertyValueByLocation = "RowClick";
      diffProperty.propertyIsCData = true;
      break;
    case "RowDelete":
      diffProperty.propertyValueByLocation = "RowDelete";
      diffProperty.propertyIsCData = true;
      break;
    case "FocusRowChanged":
      diffProperty.propertyValueByLocation = "FocusRowChanged";
      diffProperty.propertyIsCData = true;
      break;
    case "FormulaItems":
      diffProperty.propertyValueByLocation = "FormulaItems";
      diffProperty.propertyIsCData = true;
      break;
    case "Action":
      diffProperty.propertyValueByLocation = "Action";
      diffProperty.propertyIsCData = true;
      break;
    case "RowDblClick":
      diffProperty.propertyValueByLocation = "RowDblClick";
      diffProperty.propertyIsCData = true;
      break;
    case "Font":
    case "Size":
    case "Bold":
    case "Italic":
      diffProperty.propertyValueByLocation = "Font";
      diffProperty.propertyParent = "Format";
      break;
    case "OnPostShow":
      diffProperty.propertyValueByLocation = "OnPostShow";
      diffProperty.propertyIsCData = true;
      break;
    case "FormOverflowX":
      diffProperty.propertyValueByLocation = "Body";
      diffProperty.property = "OverflowX";
      break;
    case "FormOverflowY":
      diffProperty.propertyValueByLocation = "Body";
      diffProperty.property = "OverflowY";
      break;
    case "Resizable":
      diffProperty.propertyValueByLocation = "Body";
      break;
    case "LeftMargin":
    case "RightMargin":
    case "TopMargin":
    case "BottomMargin":
      diffProperty.newValue = newValue + "px";
      if (args[1] === "FormBoundary") {
        diffProperty.propertyValueByLocation = "Body";
      }
      break;
    case "LeftPadding":
    case "BottomPadding":
    case "RightPadding":
    case "TopPadding":
      diffProperty.newValue = newValue + "px";
      break;
    case "OnLoad":
      diffProperty.propertyValueByLocation = "OnLoad";
      diffProperty.propertyIsCData = true;
      break;
    case "HighlightColor":
    case "ForeColor":
    case "BackColor":
      if (args[0] === "HAlign" && newValue === "-1") {
        diffProperty.newValue = "";
      }
      if (propertyForm.formKey === "D_FieldProperty" || propertyForm.formKey === "D_PanelProperty" || propertyForm.formKey === "D_ListViewColumn" || propertyForm.formKey === "D_Embed") {
        diffProperty.propertyValueByLocation = "Format";
      }
      break;
    case "VAlign":
    case "HAlign":
      if (args[0] === "HAlign" && newValue === "-1") {
        diffProperty.newValue = "";
      }
      if (propertyForm.formKey === "D_FieldProperty" || propertyForm.formKey === "D_ListViewColumn") {
        diffProperty.propertyValueByLocation = "Format";
      } else {
        diffProperty.propertyValueByLocation = "CellFormat";
      }
      break;
    case "Height":
      var value2 = propertyForm.getValue("HSizeType");
      if (value2 != null && value2 != "pref" && value2 != "auto" && value2 != "inherit") {
        if (newValue != "") {
          diffProperty.newValue = newValue + value2;
        } else {
          diffProperty.newValue = "0" + value2;
        }
      } else if (value2) {
        diffProperty.newValue = value2;
      } else {
        diffProperty.newValue = newValue + "px";
      }
      break;
    case "Width":
      var value2 = propertyForm.getValue("WSizeType");
      if (value2 != null && value2 != "pref" && value2 != "auto" && value2 != "inherit") {
        if (newValue != "") {
          diffProperty.newValue = newValue + value2;
        } else {
          diffProperty.newValue = "0" + value2;
        }
      } else if (value2) {
        diffProperty.newValue = value2;
      } else {
        diffProperty.newValue = newValue + "px";
      }
      break;
    case "PopWidth":
      diffProperty.propertyValueByLocation = "Body";
      var value2 = propertyForm.getValue("WSizeType");
      if (value2 != null && value2 != "pref" && value2 != "auto" && value2 != "inherit") {
        if (newValue != "") {
          diffProperty.newValue = newValue + value2;
        } else {
          diffProperty.newValue = "0" + value2;
        }
      } else if (value2) {
        diffProperty.newValue = value2;
      } else {
        diffProperty.newValue = newValue + "px";
      }
      break;
    case "MinHeight":
      var value2 = propertyForm.getValue("MSizeType");
      if (value2 != null && value2 != "pref" && value2 != "auto" && value2 != "inherit") {
        if (newValue != "") {
          diffProperty.newValue = newValue + value2;
        } else {
          diffProperty.newValue = "0" + value2;
        }
      } else if (value2) {
        diffProperty.newValue = value2;
      } else {
        diffProperty.newValue = newValue + "px";
      }
      break;
    case "PopHeight":
      diffProperty.propertyValueByLocation = "Body";
      var value2 = propertyForm.getValue("HSizeType");
      if (value2 != null && value2 != "pref" && value2 != "auto" && value2 != "inherit") {
        if (newValue != "") {
          diffProperty.newValue = newValue + value2;
        } else {
          diffProperty.newValue = "0" + value2;
        }
      } else if (value2) {
        diffProperty.newValue = value2;
      } else {
        diffProperty.newValue = newValue + "px";
      }
      break;
    case "SelectedValue":
      diffProperty.property = "Value";
      break;
    case "ListTableKey":
      diffProperty.property = "TableKey";
      break;
    case "GroupKeyT":
      diffProperty.property = "GroupKey";
      break;
    case "GroupKeyP":
      diffProperty.property = "GroupKey";
      break;
    case "ImageSource":
      diffProperty.property = "SourceType";
      break;
    case "ChartSourceType":
      diffProperty.property = "SourceType";
      break;
    case "PageIndicatorCount":
      if (newValue < 3) {
        diffProperty.newValue = 3;
      }
      break;
    case "OnClose":
      diffProperty.propertyValueByLocation = "OnClose";
      diffProperty.propertyIsCData = true;
      break;
  }
  if (args[0] === "DefaultFormulaValue" || args[0] === "CheckRule" || args[0] === "ValueChanged") {
    if (diffProperty.newValue.length > 50 || diffProperty.newValue.indexOf("\r\n") != -1 || diffProperty.newValue.indexOf("\n") != -1 || diffProperty.newValue.indexOf("	") != -1 || diffProperty.newValue.indexOf("\r") != -1) {
      diffProperty.propertyIsCData = true;
    }
  }
  diff.key = propertyForm.getValue("Key");
  if (!diff.key) {
    diff.key = ErpDesigner.selectComponentKey;
  }
  diff.properties.push(diffProperty);
  if (sessionStorage.getItem("DataObjectFormkey")) {
    diff.formKey = sessionStorage.getItem("DataObjectFormkey");
    var dataobjectParams = {
      formkey: sessionStorage.getItem("DataObjectFormkey"),
      diff: JSON.stringify([diff])
    };
    let r = new Request();
    r.addHeader("content-type", "application/json;charset=UTF-8");
    let res = await r.getData(dataobjectParams, ErpDesigner.url + "dataObjectController/FieldinforOrBasicAttribute");
    if (res) {
      if (res.code == 0) {
        if (res.data) {
          var uiCommand2 = {
            content: res.data
          };
          await ErpDesignerSrc.reloadXmlSource(uiCommand2.content.xmlPath);
          await ErpDesignerFuns.RefreshDataObjectProcessing(sessionStorage.getItem("DataObjectFormkey"));
        }
      } else {
        console.error(res.msg);
      }
    } else {
      console.error("数据对象操作失败");
    }
  } else {
    let successFlag;
    if (propertyKey === "ColumnKey" || propertyKey === "RowTableKey") {
      successFlag = await ErpDesignerService.commitDiff(diff.formKey, [diff], void 0, formdocument, activeForm.paras.map.FormKey);
    } else if ((propertyKey == "Key" || propertyKey == "Caption") && name !== "CommitDiff") {
      return;
    } else {
      if (diff.controlType === "SplitPanel" && propertyKey === "Orientation") {
        ErpDesignerUI.enforceLayoutSplitPanelKey = diff.key;
      }
      successFlag = await ErpDesignerService.commitDiff(ErpDesignerUI.activeERPFormKey, [diff], void 0, formdocument, activeForm.paras.map.FormKey);
      ErpDesignerUI.enforceLayoutSplitPanelKey = void 0;
    }
    if (!successFlag) {
      return;
    }
    ErpDesignerUI.diffs.push(diff);
    if (propertyKey == "Key") {
      ErpDesigner.selectedComponentKey = newValue;
    }
    if ((propertyKey == "Key" || propertyKey == "Caption") && name !== "CommitDiff") {
      return;
    }
    setTimeout(async function() {
      if (propertyKey === "ColumnKey") {
        var formID = propertyForm.formID;
        var document2 = propertyForm.getDocument();
        var cols = document2.getByKey("ED_DataBinding").cols;
        var indexOf = (cols || []).findIndex(function(item) {
          return item.key === "GetColumnKey";
        });
        if (!document2.getByKey("ED_DataBinding").rows[0].vals[indexOf]) {
          return;
        }
        var val = document2.getByKey("ED_DataBinding").rows[0].vals[indexOf].split(" ")[0].replace(/\s/g, "");
        var reg = new RegExp("[a-zA-Z0-9_.,\\-/;\\[\\]‘\\\\${}^|~\\n\\r\\t ]{1,35}");
        if (reg.test(val)) {
          var dataobjectParams2 = {
            formKey: activeForm.formKey,
            columnKey: val
          };
          let r = new Request();
          r.addHeader("content-type", "application/json;charset=UTF-8");
          let res = await r.getData(dataobjectParams2, ErpDesigner.url + "DesignerController/checkColumn");
          if (typeof res === "string") {
            $("#" + formID + "_ColumnKey").find("input").val(res);
            $("#" + formID + "_ColumnKey").attr("title", res);
          } else {
            $("#" + formID + "_ColumnKey").find("input").val("");
          }
        } else if (val == "无字段") {
          $("#" + formID + "_TableKey").find("input").val("无数据表");
          $("#" + formID + "_ColumnKey").find("input").val(val);
        } else {
          $("#" + formID + "_ColumnKey").find("input").val("");
        }
      } else if (diffProperty.newValue && propertyKey === "DefaultValue") {
        var formID = propertyForm.formID;
        await propertyForm.getComponent("DefaultFormulaValue").setValue("");
      } else if (diffProperty.newValue && propertyKey === "DefaultFormulaValue") {
        var formID = propertyForm.formID;
        await propertyForm.getComponent("DefaultValue").setValue("");
      } else if (diffProperty.newValue && propertyKey === "ItemKey" && diffProperty.newValue.endsWith("__Dic")) {
        await propertyForm.getComponent("StateMask").setValue("Enable,Disable,Discard");
      }
    }, 100);
  }
  if (args[0] == "FormulaItems") {
    let com2 = activeForm.getComponent(diff.key);
    if (com2) {
      let metaObj = com2.getMetaObj();
      let prop = metaObj.properties;
      let items = await com2.handler.getFormulaItems(activeForm, prop);
      var data = {};
      data.key = prop.key;
      data.formKey = activeForm.getFormKey();
      let cache = com2.handler.getCache();
      cache.set(JSON.stringify(data), items);
    }
  }
};
const UploadBkImage = function(evl, name, cxt, args) {
  var key2 = args[0], form2 = cxt.form, com = form2.getComponent(key2);
  let fileChangeHandler = function() {
    let imgPath = $(this)[0].value.split("\\");
    let imgName = imgPath[imgPath.length - 1];
    if (com) {
      com.setValue(imgName, true, true, true);
    }
  };
  let $file = $('<input type="file" name="upload-file">');
  $file.change(fileChangeHandler);
  $file.click();
};
const OpenConditionForm = async function(evl, name, cxt, args) {
  var key2 = args[0], form2 = ErpDesignerUI.getActiveERPForm();
  form2.getCallParas().put("compKey", key2);
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_FieldQueryProperties")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const OpenMobileConditionForm = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  var pr = ErpDesignerUI.propertyForm;
  var paras = pr.getParas();
  var compKey = paras.get("compKey");
  form2.getCallParas().put("compKey", compKey);
  form2.getCallParas().put("OwnerFormKey", form2.getFormKey());
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    form2.getCallParas().put("ContainerKey", form2.paras.map.FormKey);
  }
  $.when(ErpDesignerUI.showRealModal(form2, "D_MobileFieldQueryProperties")).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const CommitMobileFieldProperty = async function(evl, name, cxt, args) {
  var propertyForm = ErpDesignerUI.propertyForm, condForm = ErpDesignerUI.DesignDivForm;
  propertyForm.formID;
  condForm.getValue("CondSign");
  if (condForm) {
    var diff = new Diff(), activeForm = ErpDesignerUI.getActiveERPForm(), document2 = condForm.getDocument();
    diff.formKey = activeForm.formKey;
    diff.metaObjectType = "FieldCondition";
    diff.ISContainer = true;
    if (propertyForm) {
      diff.key = propertyForm.getParas().get("compKey");
      diff.controlType = activeForm.getComponent(diff.key).tagName;
    }
    await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, null, activeForm.paras.map.FormKey);
  }
};
const extendvisible = async function(name, cxt) {
  var activeERPForm = ErpDesignerUI.getActiveERPForm();
  if (!activeERPForm) {
    return false;
  }
  if (activeERPForm.metaForm.mergeToSource) {
    return false;
  } else {
    if (activeERPForm.metaForm.extend != "") {
      return true;
    } else {
      return false;
    }
  }
};
const SourceDataObjectEnable = async function(name, cxt) {
  var activeERPForm = ErpDesignerUI.getActiveERPForm();
  if (activeERPForm.metaForm.mergeToSource) {
    return true;
  } else {
    if (activeERPForm.metaForm.extend != "") {
      return true;
    } else {
      return false;
    }
  }
};
const NewCollection = async function(evl, name, cxt, args) {
  var newForm = ErpDesignerUI.DesignDivForm, form2 = ErpDesignerUI.getActiveERPForm(), formKey = form2.formKey, diff = new Diff();
  var document2 = newForm.getDocument();
  var cols = document2.tbls[0].cols;
  var controlTypeNum = (cols || []).findIndex(function(item) {
    return item.key === "ControlType";
  });
  var keyNum = (cols || []).findIndex(function(item) {
    return item.key === "Key";
  });
  var captionNum = (cols || []).findIndex(function(item) {
    return item.key === "Caption";
  });
  var actionNum = (cols || []).findIndex(function(item) {
    return item.key === "Action";
  });
  var controlType = document2.tbls[0].rows[0].vals[controlTypeNum];
  var key2 = document2.tbls[0].rows[0].vals[keyNum];
  var caption = document2.tbls[0].rows[0].vals[captionNum];
  var action = document2.tbls[0].rows[0].vals[actionNum];
  diff.formKey = form2.formKey;
  diff.reserveOne = "NewCollection";
  diff.key = key2;
  diff.caption = caption;
  diff.reserveTwo = action;
  diff.parentKey = "";
  diff.controlType = controlType;
  diff.sideKey = ErpDesigner.selectedComponentKey;
  ErpDesignerUI.parentKey = diff.parentKey;
  if (controlType.equalsIgnoCase("Operation") && ErpDesigner.selectedType.toLowerCase() == "toolbar".toLowerCase() || controlType.toLowerCase() == "Operation".toLowerCase() && ErpDesigner.selectedType.toLowerCase() == "OperationCollection".toLowerCase()) {
    diff.metaObjectType = "Operation";
    ErpDesignerUI.MetaObjectType = diff.metaObjectType;
  } else {
    diff.metaObjectType = "OperationCollection";
    ErpDesignerUI.MetaObjectType = diff.metaObjectType;
  }
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  await ErpDesignerService.commitDiff(formKey, [diff], document2, form2.document, form2.paras.map.FormKey);
};
const NewCompByKey = async function(evl, name, cxt, args) {
  var controlType = ErpDesignerUtil.getControlTypeStr(args[0]), parentComp, form2 = ErpDesignerUI.getActiveERPForm(), formKey = form2.formKey, type = ErpDesigner.selectedType, diff = new Diff();
  if (controlType == "未知类型,请再js中添加类型") {
    ErpDesignerUI.showTip("请选择类型后才能添加");
    return;
  }
  diff.formKey = formKey;
  var newForm = ErpDesignerUI.DesignDivForm;
  var document2 = newForm.getDocument();
  var cols = document2.tbls[0].cols;
  var KeyNum = (cols || []).findIndex(function(item) {
    return item.key === "Key";
  });
  var CaptionNum = (cols || []).findIndex(function(item) {
    return item.key === "Caption";
  });
  var Key = document2.tbls[0].rows[0].vals[KeyNum];
  diff.caption = document2.tbls[0].rows[0].vals[CaptionNum];
  let checkFormKey = form2.metaForm.extensionFormKey ? form2.metaForm.extensionFormKey : form2.formKey;
  var examinationKey = await ErpDesignerUtil.checkUniqueCompKey(checkFormKey, Key);
  if (!examinationKey) {
    return;
  }
  var columnKey = diff.reserveThree, formType = form2.type;
  var result = await checkAllSpec(evl, name, cxt, ["checkBillModifyAndNew", "newHead", Key, columnKey, formType, controlType]);
  if (result == "false") {
    return;
  } else {
    if (result != "noCheck") {
      Key = result;
    }
  }
  diff.key = Key;
  if (ErpDesigner.selectedComponentKey && ErpDesigner.selectedComponentKey != formKey && ErpDesigner.selectedComponentKey.indexOf("Operation") != -1)
    ;
  else if (ErpDesigner.selectedComponentKey && ErpDesigner.selectedComponentKey != formKey && ErpDesigner.selectedComponentKey.indexOf("Operation") == -1) {
    parentComp = form2.getComponent(ErpDesigner.selectedComponentKey);
    if (ErpDesigner.selectedComponentKey && !parentComp) {
      if (ErpDesigner.selectedGridTrIndexKey) {
        let index = ErpDesigner.selectedGridTrIndexKey.indexOf("_");
        let detailRow = ErpDesignerUI.getActiveERPForm().getComponent(ErpDesigner.selectedGridTrIndexKey.substring(index + 1));
        if (detailRow) {
          for (let index2 in detailRow.data) {
            let rowData = detailRow.data[index2];
            if (rowData.rowType == "Detail") {
              parentComp = rowData.compMap[ErpDesigner.selectedComponentKey];
              break;
            }
          }
        }
      }
    }
    if (parentComp == null || type == "Field") {
      ErpDesignerUI.showTip("请选择父组件后才能添加");
      return;
    }
  } else {
    ErpDesignerUI.showTip("请选择父组件后才能添加");
    return;
  }
  if (controlType.indexOf("Panel") != -1) {
    if (type == "EditViewChildLayout" || type == "EditViewRootGridLayout" || type == "EditViewRootLinearLayout" || type == "EditViewChildGridLayout" || type == "EditViewChildLinearLayout" || type == "EditViewChildFlexFlowLayout" || type == "EditViewChildColumnLayout" || type == "EditViewChildSplitLayout" || type == "EditViewChildTabLayout" || type == "EditViewChildFlowLayout" || type == "EditViewChildFlexGridLayout") {
      if (ErpDesigner.selectedLayoutKey) {
        let layoutMap = form2.formAdapt.layoutMap;
        for (let comKey in layoutMap) {
          if (layoutMap.hasOwnProperty(comKey)) {
            let child = layoutMap[comKey];
            if (child && child[diff.key]) {
              ErpDesignerUI.showTip("Key重复,创建失败");
              return;
            }
          }
        }
        let parentViewLayout = form2.formAdapt.getLayout(parentComp.key, ErpDesigner.selectedLayoutKey);
        if (parentViewLayout) {
          if (parentViewLayout.type == 4) {
            diff.x = ErpDesignerUI.selectNode.attr("col");
            diff.y = ErpDesignerUI.selectNode.parent().attr("row");
          }
          diff.sideKey = "";
          diff.controlType = controlType;
          diff.metaObjectType = "Panel";
          diff.parentKey = ErpDesigner.selectedComponentKey;
          diff.reserveOne = ErpDesigner.selectedLayoutKey;
          if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
            diff.ContainerKey = form2.paras.map.FormKey;
          }
          let successFlag = await ErpDesignerService.commitDiff(formKey, [diff], null, null, form2.paras.map.FormKey);
          if (!successFlag) {
            return;
          }
        }
      }
    } else {
      var parentTagName = parentComp.tagName.toLowerCase();
      if (parentTagName == "tabpanel" || parentTagName == "splitpanel" || parentTagName == "flexflowlayoutpanel" || parentTagName == "linearlayoutpanel" || parentTagName == "borderlayoutpanel" || parentTagName == "flowlayoutpanel" || parentTagName == "slidinglayoutpanel") {
        if (parentTagName == "slidinglayoutpanel" && parentComp.firstPanel != null && parentComp.secondPanel != null) {
          ErpDesignerUI.showTip("侧滑面板已经存在两个子面板，不允许再新增新面板！");
          return;
        }
        diff.sideKey = "";
        diff.controlType = controlType;
        diff.create = args[1].toString();
        diff.metaObjectType = "Panel";
        diff.parentKey = ErpDesigner.selectedComponentKey;
        ErpDesignerUI.parentKey = diff.parentKey;
        if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
          diff.ContainerKey = form2.paras.map.FormKey;
        }
        var associat = newForm.getValue("AssociationTable");
        if (associat != null) {
          diff.associatedTable = associat;
          diff.cellList = newForm.getValue("CellList");
        }
        let successFlag = await ErpDesignerService.commitDiff(formKey, [diff], null, null, form2.paras.map.FormKey);
        if (!successFlag) {
          return;
        }
      } else if (parentTagName == "columnlayoutpanel" || parentTagName == "gridlayoutpanel") {
        var node = ErpDesignerUI.selectNode;
        diff.x = node.attr("col");
        diff.y = node.parent().attr("row");
        diff.sideKey = "";
        diff.controlType = controlType;
        diff.metaObjectType = "Panel";
        diff.parentKey = ErpDesigner.selectedComponentKey;
        ErpDesignerUI.parentKey = diff.parentKey;
        if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
          diff.ContainerKey = form2.paras.map.FormKey;
        }
        var associat = newForm.getValue("AssociationTable");
        if (associat != null) {
          diff.associatedTable = associat;
          diff.cellList = newForm.getValue("CellList");
        }
        let successFlag = await ErpDesignerService.commitDiff(formKey, [diff], null, null, form2.paras.map.FormKey);
        if (!successFlag) {
          return;
        }
      } else {
        ErpDesignerUI.showTip("父组件不匹配,添加失败");
      }
    }
  }
  if (controlType.toLowerCase() == "ToolBar".toLowerCase()) {
    var activeForm = ErpDesignerUI.getActiveERPForm(), formDocument = activeForm.document;
    diff.formKey = activeForm.formKey;
    diff.controlType = "ToolBar";
    diff.metaObjectType = "ToolBar";
    diff.parentKey = ErpDesigner.selectedComponentKey;
    diff.sideKey = "";
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], "", formDocument, activeForm.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
  }
  if (controlType.toLowerCase() == "Chart".toLowerCase()) {
    var parentTagName = form2.getComponent(ErpDesigner.selectedComponentKey).tagName.toLowerCase();
    diff.sideKey = "";
    diff.controlType = controlType;
    diff.metaObjectType = "Chart";
    diff.parentKey = ErpDesigner.selectedComponentKey;
    if (parentTagName == "columnlayoutpanel" || parentTagName == "gridlayoutpanel") {
      var node = ErpDesignerUI.selectNode;
      diff.x = node.attr("col");
      diff.y = node.parent().attr("row");
    }
    let successFlag = await ErpDesignerService.commitDiff(formKey, [diff], null, null, form2.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
  }
  if (controlType.indexOf("SubDetail") != -1) {
    var parentTagName = form2.getComponent(ErpDesigner.selectedComponentKey).tagName.toLowerCase();
    if (parentTagName == "tabpanel" || parentTagName == "splitpanel" || parentTagName == "flexflowlayoutpanel" || parentTagName == "flowlayoutpanel" || parentTagName == "columnlayoutpanel" || parentTagName == "gridlayoutpanel" || parentTagName == "linearlayoutpanel") {
      var activeForm = ErpDesignerUI.getActiveERPForm(), newForm = ErpDesignerUI.DesignDivForm, document2, formDocument = activeForm.document, diff = new Diff();
      diff.create = args[1].toString();
      diff.formKey = activeForm.formKey;
      var node = ErpDesignerUI.selectNode;
      ErpDesignerUI.X = node.attr("col");
      ErpDesignerUI.Y = node.parent().attr("row");
      document2 = newForm.getDocument();
      if (newForm.getValue("SubAssociatedTable") == 0) {
        var subTableKey = newForm.getValue("SubTableKey");
        var subTableName = newForm.getValue("SubTableName");
        if (!subTableKey) {
          ErpDesignerUI.showTip("新建表标识不能为空", "warning");
          return false;
        }
        if (!subTableName) {
          ErpDesignerUI.showTip("新建表名称不能为空", "warning");
          return false;
        }
        diff.subTableKey = subTableKey;
        diff.subTableName = subTableName;
        diff.key = form2.formKey;
        if (ErpDesigner.selectedComponentKey != null) {
          var diffProperty = new DiffProperty();
          diffProperty.property = "DataObject";
          diffProperty.orgValue = "old";
          diffProperty.newValue = "new";
          diff.properties.push(diffProperty);
          diff.ISContainer = true;
          diff.sideKey = "";
          diff.metaObjectType = "DataSource";
          var formDocument = form2.document;
          diff.parentKey = ErpDesigner.selectedFormKey;
          ErpDesignerUI.MetaObjectType = diff.metaObjectType;
          ErpDesignerUI.parentKey = diff.parentKey;
          diff.bindingGridKey = newForm.getValue("BindingGridKey");
          if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
            diff.ContainerKey = form2.paras.map.FormKey;
          }
          var subAssociated = newForm.getValue("SubAssociatedTable");
          if (subAssociated != null) {
            diff.subAssociatedTable = subAssociated;
          }
          let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
          if (!successFlag) {
            return;
          }
          ErpDesignerUI.isdataObjectSourceTime = true;
          var activeForm = form2, formDocument = activeForm.document, subDetail = newForm, diff = new Diff();
          diff.formKey = activeForm.formKey;
          diff.y = ErpDesignerUI.Y;
          diff.x = ErpDesignerUI.X;
          diff.key = subDetail.getValue("Key");
          diff.caption = subDetail.getValue("Caption");
          diff.subTableKey = subDetail.getValue("SubTableKey");
          diff.subTableName = subDetail.getValue("SubTableName");
          diff.controlType = ErpDesignerUtil.getControlTypeStr(subDetail.getValue("ControlType"));
          diff.sideKey = "";
          diff.metaObjectType = "SubDetail";
          diff.parentKey = ErpDesigner.selectedComponentKey;
          ErpDesignerUI.parentKey = ErpDesigner.selectedComponentKey;
          if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
            diff.ContainerKey = form2.paras.map.FormKey;
          }
          if (diff.controlType == "SubDetail") {
            diff.bindingGridKey = subDetail.getValue("BindingGridKey");
          }
          var associat = subDetail.getValue("SubAssociatedTable");
          if (associat != null) {
            diff.subAssociatedTable = associat;
          }
          successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, ErpDesignerUI.getActiveERPForm().document, activeForm.paras.map.FormKey);
          if (!successFlag) {
            return;
          }
          ErpDesignerUI.Y = null;
          ErpDesignerUI.X = null;
        }
      } else {
        diff.x = ErpDesignerUI.X;
        diff.y = ErpDesignerUI.Y;
        ErpDesignerUI.Y = null;
        ErpDesignerUI.X = null;
        diff.key = newForm.getValue("Key");
        diff.caption = newForm.getValue("Caption");
        diff.subTableKey = newForm.getValue("SubTableKey");
        diff.subTableName = newForm.getValue("SubTableName");
        diff.controlType = ErpDesignerUtil.getControlTypeStr(newForm.getValue("ControlType"));
        diff.sideKey = "";
        diff.metaObjectType = "SubDetail";
        diff.parentKey = ErpDesigner.selectedComponentKey;
        ErpDesignerUI.parentKey = ErpDesigner.selectedComponentKey;
        if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
          diff.ContainerKey = form2.paras.map.FormKey;
        }
        if (diff.controlType == "SubDetail") {
          diff.bindingGridKey = newForm.getValue("BindingGridKey");
        }
        var associat = newForm.getValue("SubAssociatedTable");
        if (associat != null) {
          diff.subAssociatedTable = associat;
        }
        let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, formDocument, activeForm.paras.map.FormKey);
        if (!successFlag) {
          return;
        }
      }
    } else {
      ErpDesignerUI.showTip("父组件不匹配,添加失败");
    }
  }
  if (controlType.indexOf("Grid") != -1 && controlType.length < 5) {
    var activeForm = ErpDesignerUI.getActiveERPForm(), newForm = ErpDesignerUI.DesignDivForm, document2, formDocument = activeForm.document, diff = new Diff();
    diff.create = args[1].toString();
    diff.formKey = activeForm.formKey;
    var node = ErpDesignerUI.selectNode;
    ErpDesignerUI.X = node.attr("col");
    ErpDesignerUI.Y = node.parent().attr("row");
    document2 = newForm.getDocument();
    if (newForm.getValue("AssociationTable") == 0) {
      var tableKey = newForm.getValue("TableKey");
      var tableName = newForm.getValue("TableName");
      if (!tableKey) {
        ErpDesignerUI.showTip("新建表标识不能为空", "warning");
        return false;
      }
      if (!tableName) {
        ErpDesignerUI.showTip("新建表名称不能为空", "warning");
        return false;
      }
      diff.sideKey = "";
      diff.key = form2.formKey;
      var diffProperty = new DiffProperty();
      diffProperty.property = "DataObject";
      diffProperty.orgValue = "old";
      diffProperty.newValue = "new";
      diff.properties.push(diffProperty);
      diff.ISContainer = true;
      var formDocument = form2.document;
      diff.metaObjectType = "DataSource";
      diff.parentKey = ErpDesigner.selectedFormKey;
      diff.tableKey = tableKey;
      diff.tableName = tableName;
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      ErpDesignerUI.MetaObjectType = diff.metaObjectType;
      var parentKey = ErpDesigner.selectedComponentKeyInDesign;
      let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
      ErpDesignerUI.isdataObjectSourceTime = true;
      var activeForm = form2, document2, formDocument = activeForm.document, subDetail = newForm, diff = new Diff();
      diff.y = ErpDesignerUI.Y;
      diff.x = ErpDesignerUI.X;
      diff.formKey = activeForm.formKey;
      document2 = subDetail.getDocument();
      diff.key = subDetail.getValue("Key");
      diff.caption = subDetail.getValue("Caption");
      diff.tableKey = subDetail.getValue("TableKey");
      diff.tableName = subDetail.getValue("TableName");
      diff.controlType = ErpDesignerUtil.getControlTypeStr(subDetail.getValue("ControlType"));
      diff.sideKey = "";
      diff.metaObjectType = controlType;
      diff.parentKey = parentKey;
      ErpDesignerUI.parentKey = diff.parentKey;
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      var associat = subDetail.getValue("AssociationTable");
      if (associat != null) {
        diff.associatedTable = associat;
        diff.cellList = newForm.getValue("CellList");
      }
      successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, ErpDesignerUI.getActiveERPForm().document, activeForm.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
      ErpDesignerUI.Y = null;
      ErpDesignerUI.X = null;
    } else {
      diff.x = ErpDesignerUI.X;
      diff.y = ErpDesignerUI.Y;
      diff.parentKey = ErpDesigner.selectedComponentKey;
      ErpDesignerUI.Y = null;
      ErpDesignerUI.X = null;
      let parentComp2 = ErpDesignerUI.getActiveERPForm().getComponent(ErpDesignerUI.parentKey);
      if (ErpDesignerUI.parentKey && !parentComp2) {
        if (ErpDesigner.selectedGridTrIndexKey) {
          let index = ErpDesigner.selectedGridTrIndexKey.indexOf("_");
          let detailRow = ErpDesignerUI.getActiveERPForm().getComponent(ErpDesigner.selectedGridTrIndexKey.substring(index + 1));
          if (detailRow) {
            for (let index2 in detailRow.data) {
              let rowData = detailRow.data[index2];
              if (rowData.rowType == "Detail") {
                parentComp2 = rowData.compMap[ErpDesignerUI.parentKey];
                break;
              }
            }
          }
        }
      }
      let selectedComp = ErpDesignerUI.getActiveERPForm().getComponent(ErpDesigner.selectedComponentKey);
      let tagType = parentComp2 ? parentComp2.tagName.toLowerCase() : selectedComp.tagName.toLowerCase();
      if (tagType === "gridlayoutpanel") {
        diff.parentKey = node.parent().parent().parent().attr("meta-key");
        diff.x = node.attr("col");
        diff.y = node.parent().attr("row");
        if (node[0].nodeName != "TD") {
          if (node.attr("meta-type") == "GridLayoutPanel") {
            diff.parentKey = node.attr("meta-key");
          } else if (node.attr("meta-key")) {
            var parentKey1 = node.parent().parent().parent().parent().attr("meta-key");
            if (parentKey1) {
              diff.parentKey = parentKey1;
            }
          }
          node = node.parent();
          diff.x = node.attr("col");
          diff.y = node.parent().attr("row");
        }
      }
      diff.key = newForm.getValue("Key");
      diff.caption = newForm.getValue("Caption");
      diff.tableKey = newForm.getValue("TableKey");
      diff.tableName = newForm.getValue("TableName");
      diff.controlType = ErpDesignerUtil.getControlTypeStr(newForm.getValue("ControlType"));
      diff.sideKey = "";
      diff.metaObjectType = "Grid";
      ErpDesignerUI.parentKey = ErpDesigner.selectedComponentKey;
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      var associat = newForm.getValue("AssociationTable");
      if (associat != null) {
        diff.associatedTable = associat;
        diff.cellList = newForm.getValue("CellList");
      }
      await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, formDocument, activeForm.paras.map.FormKey);
    }
  }
  if (controlType.indexOf("ListView") != -1) {
    var activeForm = ErpDesignerUI.getActiveERPForm(), newForm = ErpDesignerUI.DesignDivForm, document2, formDocument = activeForm.document, diff = new Diff();
    diff.formKey = activeForm.formKey;
    var node = ErpDesignerUI.selectNode;
    ErpDesignerUI.X = node.attr("col");
    ErpDesignerUI.Y = node.parent().attr("row");
    document2 = newForm.getDocument();
    if (newForm.getValue("AssociationTable") == 0) {
      var tableKey = newForm.getValue("TableKey");
      var tableName = newForm.getValue("TableName");
      diff.sideKey = "";
      diff.key = form2.formKey;
      var diffProperty = new DiffProperty();
      diffProperty.property = "DataObject";
      diffProperty.orgValue = "old";
      diffProperty.newValue = "new";
      diff.properties.push(diffProperty);
      diff.ISContainer = true;
      var formDocument = form2.document;
      diff.metaObjectType = "DataSource";
      diff.parentKey = ErpDesigner.selectedFormKey;
      diff.tableKey = tableKey;
      diff.tableName = tableName;
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      ErpDesignerUI.MetaObjectType = diff.metaObjectType;
      ErpDesignerUI.parentKey = diff.parentKey;
      let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
      ErpDesignerUI.isdataObjectSourceTime = true;
      var activeForm = form2, document2, formDocument = activeForm.document, subDetail = newForm, diff = new Diff();
      diff.y = ErpDesignerUI.Y;
      diff.x = ErpDesignerUI.X;
      diff.formKey = activeForm.formKey;
      document2 = subDetail.getDocument();
      diff.key = subDetail.getValue("Key");
      diff.caption = subDetail.getValue("Caption");
      diff.tableKey = subDetail.getValue("TableKey");
      diff.tableName = subDetail.getValue("TableName");
      diff.controlType = ErpDesignerUtil.getControlTypeStr(subDetail.getValue("ControlType"));
      diff.sideKey = "";
      diff.metaObjectType = controlType;
      diff.parentKey = ErpDesigner.selectedComponentKey;
      ErpDesignerUI.parentKey = ErpDesigner.selectedComponentKey;
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      var associat = subDetail.getValue("AssociationTable");
      if (associat != null) {
        diff.associatedTable = associat;
        diff.cellList = newForm.getValue("CellList");
      }
      successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, ErpDesignerUI.getActiveERPForm().document, activeForm.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
      ErpDesignerUI.Y = null;
      ErpDesignerUI.X = null;
    } else {
      diff.x = ErpDesignerUI.X;
      diff.y = ErpDesignerUI.Y;
      ErpDesignerUI.Y = null;
      ErpDesignerUI.X = null;
      diff.key = newForm.getValue("Key");
      diff.caption = newForm.getValue("Caption");
      diff.tableKey = newForm.getValue("TableKey");
      diff.tableName = newForm.getValue("TableName");
      diff.controlType = ErpDesignerUtil.getControlTypeStr(newForm.getValue("ControlType"));
      diff.sideKey = "";
      diff.metaObjectType = "ListView";
      diff.parentKey = ErpDesigner.selectedComponentKey;
      ErpDesignerUI.parentKey = ErpDesigner.selectedComponentKey;
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      var associat = newForm.getValue("AssociationTable");
      if (associat != null) {
        diff.associatedTable = associat;
        diff.cellList = newForm.getValue("CellList");
      }
      let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, formDocument, activeForm.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
    }
  }
  if (controlType.indexOf("Embed") != -1 && controlType.length < 6) {
    var newForm = ErpDesignerUI.DesignDivForm;
    var controlType = "Embed", form2 = ErpDesignerUI.getActiveERPForm(), diff = new Diff();
    diff.formKey = form2.formKey;
    var formDocument = form2.document;
    var document2 = newForm.getDocument();
    var cols = document2.tbls[0].cols;
    var KeyNum = (cols || []).findIndex(function(item) {
      return item.key === "Key";
    });
    var CaptionNum = (cols || []).findIndex(function(item) {
      return item.key === "Caption";
    });
    var Key = document2.tbls[0].rows[0].vals[KeyNum];
    diff.caption = document2.tbls[0].rows[0].vals[CaptionNum];
    diff.formKey = form2.formKey;
    var examinationKey = await ErpDesignerUtil.checkUniqueCompKey(form2.formKey, Key);
    if (!examinationKey) {
      return false;
    }
    diff.key = Key;
    if (controlType.indexOf("Embed") != -1) {
      var node = ErpDesignerUI.selectNode;
      ErpDesignerUI.X = node.attr("col");
      ErpDesignerUI.Y = node.parent().attr("row");
      diff.y = ErpDesignerUI.Y;
      diff.x = ErpDesignerUI.X;
      diff.sideKey = "";
      diff.controlType = controlType;
      diff.metaObjectType = "Panel";
      diff.parentKey = ErpDesigner.selectedComponentKey;
      diff.IsEmbed = true;
      var parent = (cols || []).findIndex(function(item) {
        return item.key === "ParentKey";
      });
      var parentKey = document2.tbls[0].rows[0].vals[parent];
      var form1 = (cols || []).findIndex(function(item) {
        return item.key === "FormKey";
      });
      var formKey = document2.tbls[0].rows[0].vals[form1];
      var root = (cols || []).findIndex(function(item) {
        return item.key === "RootKey";
      });
      var rootKey = document2.tbls[0].rows[0].vals[root];
      diff.reserveOne = parentKey;
      diff.reserveTwo = formKey;
      diff.reserveThree = rootKey;
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      ErpDesignerUI.MetaObjectType = diff.metaObjectType;
      ErpDesignerUI.parentKey = diff.parentKey;
      let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
    }
  }
  if (controlType.indexOf("Quote") != -1) {
    var parentTagName = form2.getComponent(ErpDesigner.selectedComponentKey).tagName.toLowerCase();
    if (parentTagName == "tabpanel" || parentTagName == "splitpanel" || parentTagName == "flexflowlayoutpanel" || parentTagName == "flowlayoutpanel") {
      form2.getCallParas().put("OwnerFormKey", ErpDesigner.selectedFormKey);
      $.when(ErpDesignerUI.showRealModal(form2, "D_QuotePanel")).done(function(newForm2) {
        ErpDesignerUI.DesignDivForm = newForm2;
        newForm2.regEvent(FormEvent.CLOSE, function(opt) {
          ErpDesignerUI.DesignDivForm = null;
        });
      });
    } else if (parentTagName == "columnlayoutpanel" || parentTagName == "gridlayoutpanel") {
      var node = ErpDesignerUI.selectNode;
      ErpDesignerUI.X = node.attr("col");
      ErpDesignerUI.Y = node.parent().attr("row");
      form2.getCallParas().put("OwnerFormKey", ErpDesigner.selectedFormKey);
      $.when(ErpDesignerUI.showRealModal(form2, "D_QuotePanel")).done(function(newForm2) {
        ErpDesignerUI.DesignDivForm = newForm2;
        newForm2.regEvent(FormEvent.CLOSE, function(opt) {
          ErpDesignerUI.DesignDivForm = null;
        });
      });
    } else {
      ErpDesignerUI.showTip("父组件不匹配,添加失败");
    }
  }
  if (controlType.indexOf("TableView") != -1 || controlType.indexOf("CollectionView") != -1) {
    var newForm = ErpDesignerUI.DesignDivForm;
    var form2 = ErpDesignerUI.getActiveERPForm();
    var diff = new Diff();
    diff.formKey = form2.formKey;
    var formDocument = form2.document;
    var document2 = newForm.getDocument();
    var cols = document2.tbls[0].cols;
    var KeyNum = (cols || []).findIndex(function(item) {
      return item.key === "Key";
    });
    var CaptionNum = (cols || []).findIndex(function(item) {
      return item.key === "Caption";
    });
    var Key = document2.tbls[0].rows[0].vals[KeyNum];
    diff.caption = document2.tbls[0].rows[0].vals[CaptionNum];
    diff.formKey = form2.formKey;
    var examinationKey = await ErpDesignerUtil.checkUniqueCompKey(form2.formKey, Key);
    if (!examinationKey) {
      return false;
    }
    diff.key = Key;
    var node = ErpDesignerUI.selectNode;
    ErpDesignerUI.X = node.attr("col");
    ErpDesignerUI.Y = node.parent().attr("row");
    diff.y = ErpDesignerUI.Y;
    diff.x = ErpDesignerUI.X;
    diff.sideKey = "";
    diff.controlType = controlType;
    diff.metaObjectType = controlType;
    diff.parentKey = ErpDesigner.selectedComponentKey;
    let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
  }
  if (controlType.indexOf("EditView") != -1) {
    var activeForm = ErpDesignerUI.getActiveERPForm(), newForm = ErpDesignerUI.DesignDivForm, document2, formDocument = activeForm.document, diff = new Diff();
    diff.create = args[1].toString();
    diff.formKey = activeForm.formKey;
    var node = ErpDesignerUI.selectNode;
    ErpDesignerUI.X = node.attr("col");
    ErpDesignerUI.Y = node.parent().attr("row");
    document2 = newForm.getDocument();
    if (newForm.getValue("AssociationTable") == 0) {
      var tableKey = newForm.getValue("TableKey");
      var tableName = newForm.getValue("TableName");
      if (!tableKey) {
        ErpDesignerUI.showTip("新建表标识不能为空", "warning");
        return false;
      }
      if (!tableName) {
        ErpDesignerUI.showTip("新建表名称不能为空", "warning");
        return false;
      }
      let eidtViewParentCompKey = ErpDesigner.selectedComponentKey;
      diff.sideKey = "";
      diff.key = form2.formKey;
      var diffProperty = new DiffProperty();
      diffProperty.property = "DataObject";
      diffProperty.orgValue = "old";
      diffProperty.newValue = "new";
      diff.properties.push(diffProperty);
      diff.ISContainer = true;
      var formDocument = form2.document;
      diff.metaObjectType = "DataSource";
      diff.parentKey = ErpDesigner.selectedFormKey;
      diff.tableKey = tableKey;
      diff.tableName = tableName;
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      ErpDesignerUI.MetaObjectType = diff.metaObjectType;
      ErpDesignerUI.parentKey = diff.parentKey;
      let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
      ErpDesignerUI.isdataObjectSourceTime = true;
      var activeForm = form2, document2, formDocument = activeForm.document, subDetail = newForm, diff = new Diff();
      diff.y = ErpDesignerUI.Y;
      diff.x = ErpDesignerUI.X;
      diff.formKey = activeForm.formKey;
      document2 = subDetail.getDocument();
      diff.key = subDetail.getValue("Key");
      diff.caption = subDetail.getValue("Caption");
      diff.tableKey = subDetail.getValue("TableKey");
      diff.tableName = subDetail.getValue("TableName");
      diff.controlType = ErpDesignerUtil.getControlTypeStr(subDetail.getValue("ControlType"));
      diff.sideKey = "";
      diff.metaObjectType = controlType;
      diff.parentKey = eidtViewParentCompKey;
      ErpDesignerUI.parentKey = eidtViewParentCompKey;
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      var associat = subDetail.getValue("AssociationTable");
      if (associat != null) {
        diff.associatedTable = associat;
      }
      successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, ErpDesignerUI.getActiveERPForm().document, activeForm.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
      ErpDesignerUI.Y = null;
      ErpDesignerUI.X = null;
    } else {
      diff.x = ErpDesignerUI.X;
      diff.y = ErpDesignerUI.Y;
      ErpDesignerUI.Y = null;
      ErpDesignerUI.X = null;
      diff.key = newForm.getValue("Key");
      diff.caption = newForm.getValue("Caption");
      diff.tableKey = newForm.getValue("TableKey");
      diff.tableName = newForm.getValue("TableName");
      diff.controlType = ErpDesignerUtil.getControlTypeStr(newForm.getValue("ControlType"));
      diff.sideKey = "";
      diff.metaObjectType = "EditView";
      diff.parentKey = ErpDesigner.selectedComponentKey;
      ErpDesignerUI.parentKey = ErpDesigner.selectedComponentKey;
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      var associat = newForm.getValue("AssociationTable");
      if (associat != null) {
        diff.associatedTable = associat;
      }
      await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, formDocument, activeForm.paras.map.FormKey);
    }
  }
  newForm.fireClose();
};
const AddNewTableRow = async function(evl, name, cxt, args) {
  let newForm = ErpDesignerUI.DesignDivForm, newFormDocument = newForm.getDocument(), form2 = ErpDesignerUI.getActiveERPForm(), formDocument = form2.document, diff = new Diff();
  diff.formKey = form2.formKey;
  diff.parentKey = ErpDesigner.selectComponentKey;
  diff.metaObjectType = "AddTableViewRow";
  ErpDesignerUI.parentKey = diff.parentKey;
  ErpDesignerUI.MetaObjectType = diff.metaObjectType;
  let tableView = form2.getComponent(diff.parentKey);
  let mainTable = newFormDocument.getByKey(newFormDocument.mainTableKey);
  if (tableView && mainTable) {
    mainTable.first();
    let rowType = mainTable.getByKey("RowType");
    if (rowType == "Detail" && tableView.detailRow != null) {
      ErpDesignerUI.showTip("TableView不允许存在两个明细行", "warning");
      return false;
    }
  }
  await ErpDesignerService.commitDiff(ErpDesigner.selectedFormKey, [diff], newFormDocument, formDocument, form2.paras.map.FormKey);
};
const NewTable = async function(evl, name, cxt, args) {
  if (args[0] === "Panel") {
    var newForm = ErpDesignerUI.DesignDivForm;
    var controlType = ErpDesignerUtil.getControlTypeStr(newForm.getValue("Panel"));
    if (newForm.getValue("AssociationTable") == 0 && newForm.getValue("SubAssociatedTable") == 1 || newForm.getValue("AssociationTable") == 1 && newForm.getValue("SubAssociatedTable") == 0) {
      var form2 = ErpDesignerUI.getActiveERPForm(), diff = new Diff();
      var document2 = newForm.getDocument();
      diff.formKey = form2.formKey;
      if (controlType == "Grid" || controlType == "ListView") {
        var tableKey = newForm.getValue("TableKey");
        var tableName = newForm.getValue("TableName");
        if (!tableKey) {
          ErpDesignerUI.showTip("新建表标识不能为空", "warning");
          return false;
        }
        if (!tableName) {
          ErpDesignerUI.showTip("新建表名称不能为空", "warning");
          return false;
        }
        if (ErpDesigner.selectedComponentKey != null) {
          diff.sideKey = "";
          diff.key = form2.formKey;
          var diffProperty = new DiffProperty();
          diffProperty.property = "DataObject";
          diffProperty.orgValue = "old";
          diffProperty.newValue = "new";
          diff.properties.push(diffProperty);
          diff.ISContainer = true;
          var formDocument = form2.document;
          diff.metaObjectType = "DataSource";
          diff.parentKey = ErpDesigner.selectedFormKey;
          diff.tableKey = tableKey;
          diff.tableName = tableName;
          if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
            diff.ContainerKey = form2.paras.map.FormKey;
          }
          ErpDesignerUI.MetaObjectType = diff.metaObjectType;
          ErpDesignerUI.parentKey = diff.parentKey;
          let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
          if (!successFlag) {
            return;
          }
          ErpDesignerUI.isdataObjectSourceTime = true;
          var controlType = ErpDesignerUtil.getControlTypeStr(newForm.getValue("Panel")), diff = new Diff();
          diff.formKey = form2.formKey;
          var cols = document2.tbls[0].cols;
          var KeyNum = (cols || []).findIndex(function(item) {
            return item.key === "Key";
          });
          var CaptionNum = (cols || []).findIndex(function(item) {
            return item.key === "Caption";
          });
          var Key = document2.tbls[0].rows[0].vals[KeyNum];
          diff.caption = document2.tbls[0].rows[0].vals[CaptionNum];
          diff.formKey = form2.formKey;
          var examinationKey = await ErpDesignerUtil.checkUniqueCompKey(form2.formKey, Key);
          if (!examinationKey) {
            return false;
          }
          diff.key = Key;
          if (ErpDesignerUtil.getControlTypeStr(newForm.getValue("Panel")) == "Grid") {
            if (newForm.getValue("AssociationTable") == 0) {
              var tableKey = newForm.getValue("TableKey");
              var tableName = newForm.getValue("TableName");
              diff.tableKey = tableKey;
              diff.tableName = tableName;
            }
            if (ErpDesigner.selectedComponentKey != null) {
              var parentComp = form2.getComponent(ErpDesigner.selectedComponentKey);
              let parentTagName = parentComp.tagName.toLowerCase();
              if (parentTagName == "tabpanel" || parentTagName == "splitpanel" || parentTagName == "flexflowlayoutpanel" || parentTagName == "gridlayoutpanel" || parentTagName == "borderlayoutpanel" || parentTagName == "borderlayoutpanel" || parentTagName == "flowlayoutpanel" || parentTagName == "columnlayoutpanel") {
                diff.sideKey = "";
                diff.controlType = controlType;
                diff.metaObjectType = "Grid";
                diff.associatedTable = newForm.getValue("AssociationTable");
                diff.parentKey = ErpDesigner.selectedComponentKey;
                if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
                  diff.ContainerKey = form2.paras.map.FormKey;
                }
                ErpDesignerUI.MetaObjectType = diff.metaObjectType;
                ErpDesignerUI.parentKey = diff.parentKey;
                let successFlag2 = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, ErpDesignerUI.getActiveERPForm().document, form2.paras.map.FormKey);
                if (!successFlag2) {
                  return;
                }
              }
            }
          } else if (ErpDesignerUtil.getControlTypeStr(newForm.getValue("Panel")) == "ListView") {
            if (newForm.getValue("AssociationTable") == 0) {
              var tableKey = newForm.getValue("TableKey");
              var tableName = newForm.getValue("TableName");
              diff.tableKey = tableKey;
              diff.tableName = tableName;
            }
            if (ErpDesigner.selectedComponentKey != null) {
              var parentComp = form2.getComponent(ErpDesigner.selectedComponentKey);
              let parentTagName = parentComp.tagName.toLowerCase();
              if (parentTagName == "tabpanel" || parentTagName == "splitpanel" || parentTagName == "flexflowlayoutpanel" || parentTagName == "gridlayoutpanel" || parentTagName == "borderlayoutpanel" || parentTagName == "borderlayoutpanel" || parentTagName == "flowlayoutpanel" || parentTagName == "columnlayoutpanel") {
                diff.sideKey = "";
                diff.controlType = controlType;
                diff.metaObjectType = "ListView";
                diff.associatedTable = newForm.getValue("AssociationTable");
                diff.parentKey = ErpDesigner.selectedComponentKey;
                if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
                  diff.ContainerKey = form2.paras.map.FormKey;
                }
                ErpDesignerUI.MetaObjectType = diff.metaObjectType;
                ErpDesignerUI.parentKey = diff.parentKey;
                let successFlag2 = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
                if (!successFlag2) {
                  return;
                }
              }
            }
          }
        }
      } else if (controlType.indexOf("SubDetail") != -1) {
        var subTableKey = newForm.getValue("SubTableKey");
        var subTableName = newForm.getValue("SubTableName");
        diff.subTableKey = subTableKey;
        diff.subTableName = subTableName;
        if (!subTableKey) {
          ErpDesignerUI.showTip("新建表标识不能为空", "warning");
          return false;
        }
        if (!subTableKey) {
          ErpDesignerUI.showTip("新建表名称不能为空", "warning");
          return false;
        }
        diff.key = form2.formKey;
        if (ErpDesigner.selectedComponentKey != null) {
          var diffProperty = new DiffProperty();
          diffProperty.property = "DataObject";
          diffProperty.orgValue = "old";
          diffProperty.newValue = "new";
          diff.properties.push(diffProperty);
          diff.ISContainer = true;
          diff.sideKey = "";
          diff.metaObjectType = "DataSource";
          var formDocument = form2.document;
          diff.parentKey = ErpDesigner.selectedFormKey;
          ErpDesignerUI.MetaObjectType = diff.metaObjectType;
          ErpDesignerUI.parentKey = diff.parentKey;
          diff.bindingGridKey = newForm.getValue("BindingGridKey");
          if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
            diff.ContainerKey = form2.paras.map.FormKey;
          }
          var subAssociated = newForm.getValue("SubAssociatedTable");
          if (subAssociated != null) {
            diff.subAssociatedTable = subAssociated;
          }
          let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
          if (!successFlag) {
            return;
          }
          ErpDesignerUI.isdataObjectSourceTime = true;
          var controlType = ErpDesignerUtil.getControlTypeStr(newForm.getValue("Panel")), diff = new Diff();
          diff.formKey = form2.formKey;
          var cols = document2.tbls[0].cols;
          var KeyNum = (cols || []).findIndex(function(item) {
            return item.key === "Key";
          });
          var CaptionNum = (cols || []).findIndex(function(item) {
            return item.key === "Caption";
          });
          var Key = document2.tbls[0].rows[0].vals[KeyNum];
          diff.caption = document2.tbls[0].rows[0].vals[CaptionNum];
          diff.formKey = form2.formKey;
          var examinationKey = await ErpDesignerUtil.checkUniqueCompKey(form2.formKey, Key);
          if (!examinationKey) {
            return false;
          }
          diff.key = Key;
          if (newForm.getValue("AssociationTable") == 1) {
            var subTableKey = newForm.getValue("SubTableKey");
            var subTableName = newForm.getValue("SubTableName");
            diff.subTableKey = subTableKey;
            diff.subTableName = subTableName;
          }
          if (ErpDesigner.selectedComponentKey != null) {
            diff.key = newForm.getValue("Key");
            diff.caption = newForm.getValue("Caption");
            diff.controlType = controlType;
            diff.sideKey = "";
            diff.metaObjectType = "SubDetail";
            diff.parentKey = ErpDesigner.selectedComponentKey;
            ErpDesignerUI.MetaObjectType = diff.metaObjectType;
            ErpDesignerUI.parentKey = diff.parentKey;
            diff.bindingGridKey = newForm.getValue("BindingGridKey");
            if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
              diff.ContainerKey = form2.paras.map.FormKey;
            }
            var subAssociated = newForm.getValue("SubAssociatedTable");
            if (subAssociated != null) {
              diff.subAssociatedTable = subAssociated;
            }
            let successFlag2 = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, ErpDesignerUI.getActiveERPForm().document, form2.paras.map.FormKey);
            if (!successFlag2) {
              return;
            }
          }
        }
      }
    }
    newForm.fireClose();
  }
  if (args[0] === "ControlType") {
    var newForm = ErpDesignerUI.DesignDivForm;
    var controlType = ErpDesignerUtil.getControlTypeStr(newForm.getValue("ControlType"));
    if (newForm.getValue("AssociationTable") == 0 && newForm.getValue("SubAssociatedTable") == 0) {
      var form2 = ErpDesignerUI.getActiveERPForm(), diff = new Diff();
      var document2 = newForm.getDocument();
      diff.formKey = form2.formKey;
      if (controlType == "Grid" || controlType == "ListView") {
        var tableKey = newForm.getValue("TableKey");
        var tableName = newForm.getValue("TableName");
        if (ErpDesigner.selectedComponentKey != null) {
          diff.sideKey = "";
          diff.key = form2.formKey;
          var diffProperty = new DiffProperty();
          diffProperty.property = "DataObject";
          diffProperty.orgValue = "old";
          diffProperty.newValue = "new";
          diff.properties.push(diffProperty);
          diff.ISContainer = true;
          var formDocument = form2.document;
          diff.metaObjectType = "DataSource";
          diff.parentKey = ErpDesigner.selectedFormKey;
          diff.tableKey = tableKey;
          diff.tableName = tableName;
          if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
            diff.ContainerKey = form2.paras.map.FormKey;
          }
          ErpDesignerUI.MetaObjectType = diff.metaObjectType;
          ErpDesignerUI.parentKey = diff.parentKey;
          let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
          if (!successFlag) {
            return;
          }
          ErpDesignerUI.isdataObjectSourceTime = true;
          var activeForm = form2, document2, formDocument = activeForm.document, subDetail = newForm, diff = new Diff();
          diff.y = ErpDesignerUI.Y;
          diff.x = ErpDesignerUI.X;
          diff.formKey = activeForm.formKey;
          document2 = subDetail.getDocument();
          diff.key = subDetail.getValue("Key");
          diff.caption = subDetail.getValue("Caption");
          diff.tableKey = subDetail.getValue("TableKey");
          diff.tableName = subDetail.getValue("TableName");
          diff.controlType = ErpDesignerUtil.getControlTypeStr(subDetail.getValue("ControlType"));
          diff.sideKey = "";
          diff.metaObjectType = controlType;
          diff.parentKey = ErpDesigner.selectedComponentKey;
          ErpDesignerUI.parentKey = ErpDesigner.selectedComponentKey;
          if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
            diff.ContainerKey = form2.paras.map.FormKey;
          }
          var associat = subDetail.getValue("AssociationTable");
          if (associat != null) {
            diff.associatedTable = associat;
            diff.cellList = newForm.getValue("CellList");
          }
          let successFlag2 = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, ErpDesignerUI.getActiveERPForm().document, activeForm.paras.map.FormKey);
          if (!successFlag2) {
            return;
          }
          ErpDesignerUI.Y = null;
          ErpDesignerUI.X = null;
        }
      } else if (controlType.indexOf("SubDetail") != -1) {
        var subTableKey = newForm.getValue("SubTableKey");
        var subTableName = newForm.getValue("SubTableName");
        diff.subTableKey = subTableKey;
        diff.subTableName = subTableName;
        diff.key = form2.formKey;
        if (ErpDesigner.selectedComponentKey != null) {
          var diffProperty = new DiffProperty();
          diffProperty.property = "DataObject";
          diffProperty.orgValue = "old";
          diffProperty.newValue = "new";
          diff.properties.push(diffProperty);
          diff.ISContainer = true;
          diff.sideKey = "";
          diff.metaObjectType = "DataSource";
          var formDocument = form2.document;
          diff.parentKey = ErpDesigner.selectedFormKey;
          ErpDesignerUI.MetaObjectType = diff.metaObjectType;
          ErpDesignerUI.parentKey = diff.parentKey;
          diff.bindingGridKey = newForm.getValue("BindingGridKey");
          if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
            diff.ContainerKey = form2.paras.map.FormKey;
          }
          var subAssociated = newForm.getValue("SubAssociatedTable");
          if (subAssociated != null) {
            diff.subAssociatedTable = subAssociated;
          }
          let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
          if (!successFlag) {
            return;
          }
          ErpDesignerUI.isdataObjectSourceTime = true;
          var activeForm = form2, formDocument = activeForm.document, subDetail = newForm, diff = new Diff();
          diff.formKey = activeForm.formKey;
          diff.y = ErpDesignerUI.Y;
          diff.x = ErpDesignerUI.X;
          diff.key = subDetail.getValue("Key");
          diff.caption = subDetail.getValue("Caption");
          diff.subTableKey = subDetail.getValue("SubTableKey");
          diff.subTableName = subDetail.getValue("SubTableName");
          diff.controlType = ErpDesignerUtil.getControlTypeStr(subDetail.getValue("ControlType"));
          diff.sideKey = "";
          diff.metaObjectType = "SubDetail";
          diff.parentKey = ErpDesigner.selectedComponentKey;
          ErpDesignerUI.parentKey = ErpDesigner.selectedComponentKey;
          if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
            diff.ContainerKey = form2.paras.map.FormKey;
          }
          if (diff.controlType == "SubDetail") {
            diff.bindingGridKey = subDetail.getValue("BindingGridKey");
          }
          var associat = subDetail.getValue("SubAssociatedTable");
          if (associat != null) {
            diff.subAssociatedTable = associat;
          }
          let successFlag2 = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, ErpDesignerUI.getActiveERPForm().document, activeForm.paras.map.FormKey);
          if (!successFlag2) {
            return;
          }
          ErpDesignerUI.Y = null;
          ErpDesignerUI.X = null;
        }
      }
    }
    newForm.fireClose();
  }
};
const AddSelectComponent = async function(evl, name, cxt, args) {
  var activeERPForm = ErpDesignerUI.getActiveERPForm();
  var EnterPanel = args[0], Component = args[1], formKey = args[2], gridKey = args[3], prefix = args[4], suffix = args[5], IsCreateOK = args[6], IsCreateReset = args[7], IsCreateLike = args[8];
  var params = {
    cmd: "AddSelectComponent",
    service: "DesignService",
    formKey,
    enterPanel: EnterPanel,
    component: Component,
    gridKey,
    prefix,
    suffix,
    isCreateOK: IsCreateOK,
    isCreateReset: IsCreateReset,
    isCreateLike: IsCreateLike
  };
  var r = new Request();
  var uiCommands = await r.getData(params);
  if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
    return;
  }
  ErpDesigner.selectedType = "Panel";
  await ErpDesignerUI.doUICommands(activeERPForm, uiCommands);
  ErpDesignerUI.DesignDivForm.fireClose();
};
const NewPanelKey = async function(evl, name, cxt, args) {
  var newForm = ErpDesignerUI.DesignDivForm;
  var controlType = ErpDesignerUtil.getControlTypeStr(newForm.getValue("Panel")), form2 = ErpDesignerUI.getActiveERPForm(), diff = new Diff();
  diff.formKey = form2.formKey;
  if (controlType == "未知类型,请再js中添加类型") {
    ErpDesignerUI.showTip("请选择面板后才能添加");
    return;
  }
  var formDocument = form2.document;
  var document2 = newForm.getDocument();
  var cols = document2.tbls[0].cols;
  var KeyNum = (cols || []).findIndex(function(item) {
    return item.key === "Key";
  });
  var CaptionNum = (cols || []).findIndex(function(item) {
    return item.key === "Caption";
  });
  var Key = document2.tbls[0].rows[0].vals[KeyNum];
  diff.caption = document2.tbls[0].rows[0].vals[CaptionNum];
  diff.formKey = form2.formKey;
  var examinationKey = await ErpDesignerUtil.checkUniqueCompKey(form2.formKey, Key);
  if (!examinationKey) {
    return false;
  }
  diff.key = Key;
  if (controlType.indexOf("Panel") != -1) {
    diff.sideKey = "";
    diff.controlType = controlType;
    diff.metaObjectType = "Panel";
    diff.parentKey = ErpDesigner.selectedComponentKey;
    if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
      diff.ContainerKey = form2.paras.map.FormKey;
    }
    ErpDesignerUI.MetaObjectType = diff.metaObjectType;
    ErpDesignerUI.parentKey = diff.parentKey;
    var associat = newForm.getValue("AssociationTable");
    if (associat != null) {
      diff.associatedTable = associat;
      diff.cellList = newForm.getValue("CellList");
    }
    let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
  } else if (controlType.indexOf("Embed") != -1) {
    diff.sideKey = "";
    diff.controlType = controlType;
    diff.create = args[1].toString();
    diff.metaObjectType = "Panel";
    diff.parentKey = ErpDesigner.selectedComponentKey;
    diff.IsEmbed = true;
    var parent = (cols || []).findIndex(function(item) {
      return item.key === "ParentKey";
    });
    var parentKey = document2.tbls[0].rows[0].vals[parent];
    var form1 = (cols || []).findIndex(function(item) {
      return item.key === "FormKey";
    });
    var formKey = document2.tbls[0].rows[0].vals[form1];
    var root = (cols || []).findIndex(function(item) {
      return item.key === "RootKey";
    });
    var rootKey = document2.tbls[0].rows[0].vals[root];
    diff.reserveOne = parentKey;
    diff.reserveTwo = formKey;
    diff.reserveThree = rootKey;
    if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
      diff.ContainerKey = form2.paras.map.FormKey;
    }
    ErpDesignerUI.MetaObjectType = diff.metaObjectType;
    ErpDesignerUI.parentKey = diff.parentKey;
    var associat = newForm.getValue("AssociationTable");
    if (associat != null) {
      diff.associatedTable = associat;
      diff.cellList = newForm.getValue("CellList");
    }
    let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
  } else if (controlType == "Grid") {
    if (newForm.getValue("AssociationTable") == 0) {
      var tableKey = newForm.getValue("TableKey");
      var tableName = newForm.getValue("TableName");
      diff.tableKey = tableKey;
      diff.tableName = tableName;
    }
    if (ErpDesigner.selectedComponentKey != null) {
      var parentComp = form2.getComponent(ErpDesigner.selectedComponentKey);
      let parentTagName = parentComp.tagName.toLowerCase();
      if (parentTagName == "tabpanel" || parentTagName == "splitpanel" || parentTagName == "flexflowlayoutpanel" || parentTagName == "gridlayoutpanel" || parentTagName == "borderlayoutpanel" || parentTagName == "borderlayoutpanel" || parentTagName == "flowlayoutpanel" || parentTagName == "columnlayoutpanel") {
        diff.sideKey = "";
        diff.controlType = controlType;
        diff.metaObjectType = "Grid";
        diff.associatedTable = newForm.getValue("AssociationTable");
        diff.parentKey = ErpDesigner.selectedComponentKey;
        diff.cellList = newForm.getValue("CellList");
        diff.create = args[1].toString();
        if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
          diff.ContainerKey = form2.paras.map.FormKey;
        }
        ErpDesignerUI.MetaObjectType = diff.metaObjectType;
        ErpDesignerUI.parentKey = diff.parentKey;
        let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
        if (!successFlag) {
          return;
        }
      }
    }
  } else if (controlType == "ListView") {
    if (newForm.getValue("AssociationTable") == 0) {
      var tableKey = newForm.getValue("TableKey");
      var tableName = newForm.getValue("TableName");
      diff.tableKey = tableKey;
      diff.tableName = tableName;
    }
    if (ErpDesigner.selectedComponentKey != null) {
      var parentComp = form2.getComponent(ErpDesigner.selectedComponentKey);
      let parentTagName = parentComp.tagName.toLowerCase();
      if (parentTagName == "tabpanel" || parentTagName == "splitpanel" || parentTagName == "flexflowlayoutpanel" || parentTagName == "gridlayoutpanel" || parentTagName == "borderlayoutpanel" || parentTagName == "borderlayoutpanel" || parentTagName == "flowlayoutpanel" || parentTagName == "columnlayoutpanel") {
        diff.sideKey = "";
        diff.controlType = controlType;
        diff.metaObjectType = "ListView";
        diff.associatedTable = newForm.getValue("AssociationTable");
        diff.parentKey = ErpDesigner.selectedComponentKey;
        diff.create = args[1].toString();
        if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
          diff.ContainerKey = form2.paras.map.FormKey;
        }
        ErpDesignerUI.MetaObjectType = diff.metaObjectType;
        ErpDesignerUI.parentKey = diff.parentKey;
        let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
        if (!successFlag) {
          return;
        }
      }
    }
  } else if (controlType.indexOf("SubDetail") != -1) {
    if (newForm.getValue("AssociationTable") == 0) {
      var subTableKey = newForm.getValue("SubTableKey");
      var subTableName = newForm.getValue("SubTableName");
      diff.subTableKey = subTableKey;
      diff.subTableName = subTableName;
    }
    if (ErpDesigner.selectedComponentKey != null) {
      diff.key = newForm.getValue("Key");
      diff.caption = newForm.getValue("Caption");
      diff.controlType = controlType;
      diff.sideKey = "";
      diff.metaObjectType = "SubDetail";
      diff.parentKey = ErpDesigner.selectedComponentKey;
      ErpDesignerUI.MetaObjectType = diff.metaObjectType;
      ErpDesignerUI.parentKey = diff.parentKey;
      diff.create = args[1].toString();
      diff.bindingGridKey = newForm.getValue("BindingGridKey");
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      var subAssociated = newForm.getValue("SubAssociatedTable");
      if (subAssociated != null) {
        diff.subAssociatedTable = subAssociated;
      }
      let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
    }
  } else if (controlType.indexOf("Chart") != -1) {
    if (ErpDesigner.selectedComponentKey != null) {
      diff.key = newForm.getValue("Key");
      diff.caption = newForm.getValue("Caption");
      diff.controlType = controlType;
      diff.sideKey = "";
      diff.metaObjectType = "Chart";
      diff.parentKey = ErpDesigner.selectedComponentKey;
      ErpDesignerUI.MetaObjectType = diff.metaObjectType;
      ErpDesignerUI.parentKey = diff.parentKey;
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
    }
  } else if (controlType.indexOf("WebBrowser") != -1) {
    if (ErpDesigner.selectedComponentKey != null) {
      diff.key = newForm.getValue("Key");
      diff.caption = newForm.getValue("Caption");
      diff.controlType = controlType;
      diff.sideKey = "";
      diff.metaObjectType = "WebBrowser";
      diff.parentKey = ErpDesigner.selectedComponentKey;
      ErpDesignerUI.MetaObjectType = diff.metaObjectType;
      ErpDesignerUI.parentKey = diff.parentKey;
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
    }
  } else {
    diff.sideKey = "";
    diff.controlType = controlType;
    diff.metaObjectType = "Field";
    diff.parentKey = ErpDesigner.selectedComponentKey;
    var ItemKeyCNum = (cols || []).findIndex(function(item) {
      return item.key === "DictItemkey";
    });
    var Itemkey = document2.tbls[0].rows[0].vals[ItemKeyCNum];
    diff.itemkey = Itemkey;
    if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
      diff.ContainerKey = form2.paras.map.FormKey;
    }
    ErpDesignerUI.MetaObjectType = diff.metaObjectType;
    ErpDesignerUI.parentKey = diff.parentKey;
    let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
  }
  newForm.fireClose();
};
const InsertEmbed = async function(evl, name, cxt, args) {
  var newForm = ErpDesignerUI.DesignDivForm;
  var controlType = ErpDesignerUtil.getControlTypeStr(newForm.getValue("Panel")), form2 = ErpDesignerUI.getActiveERPForm(), diff = new Diff();
  diff.formKey = form2.formKey;
  var formDocument = form2.document;
  var document2 = newForm.getDocument();
  var cols = document2.tbls[0].cols;
  var KeyNum = (cols || []).findIndex(function(item) {
    return item.key === "Key";
  });
  var CaptionNum = (cols || []).findIndex(function(item) {
    return item.key === "Caption";
  });
  var Key = document2.tbls[0].rows[0].vals[KeyNum];
  diff.caption = document2.tbls[0].rows[0].vals[CaptionNum];
  var AssociationTable = (cols || []).findIndex(function(item) {
    return item.key === "AssociationTable";
  });
  var AssociationTableKey = document2.tbls[0].rows[0].vals[AssociationTable];
  diff.formKey = form2.formKey;
  var examinationKey = await ErpDesignerUtil.checkUniqueCompKey(form2.formKey, Key);
  if (!examinationKey) {
    return false;
  }
  diff.key = Key;
  if (!(controlType.indexOf("Panel") != -1)) {
    diff.reserveOne = AssociationTableKey;
  }
  diff.sideKey = "";
  diff.controlType = controlType;
  diff.metaObjectType = "EmbedPanel";
  diff.parentKey = ErpDesigner.selectedComponentKey;
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  ErpDesignerUI.MetaObjectType = diff.metaObjectType;
  ErpDesignerUI.parentKey = diff.parentKey;
  let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
  if (!successFlag) {
    return;
  }
  newForm.fireClose();
};
const NewEmbedKey = async function(evl, name, cxt, args) {
  var newForm = ErpDesignerUI.DesignDivForm;
  var controlType = ErpDesignerUtil.getControlTypeStr(newForm.getValue("Panel")), form2 = ErpDesignerUI.getActiveERPForm(), diff = new Diff();
  diff.formKey = form2.formKey;
  var formDocument = form2.document;
  var document2 = newForm.getDocument();
  var cols = document2.tbls[0].cols;
  var KeyNum = (cols || []).findIndex(function(item) {
    return item.key === "Key";
  });
  var CaptionNum = (cols || []).findIndex(function(item) {
    return item.key === "Caption";
  });
  var Key = document2.tbls[0].rows[0].vals[KeyNum];
  diff.caption = document2.tbls[0].rows[0].vals[CaptionNum];
  diff.formKey = form2.formKey;
  var examinationKey = await ErpDesignerUtil.checkUniqueCompKey(form2, Key);
  if (!examinationKey) {
    return false;
  }
  diff.key = Key;
  if (controlType.indexOf("Embed") != -1) {
    diff.y = ErpDesignerUI.Y;
    diff.x = ErpDesignerUI.X;
    diff.sideKey = "";
    diff.controlType = controlType;
    diff.metaObjectType = "Panel";
    diff.parentKey = ErpDesigner.selectedComponentKey;
    diff.IsEmbed = true;
    var parent = (cols || []).findIndex(function(item) {
      return item.key === "ParentKey";
    });
    var parentKey = document2.tbls[0].rows[0].vals[parent];
    var form1 = (cols || []).findIndex(function(item) {
      return item.key === "FormKey";
    });
    var formKey = document2.tbls[0].rows[0].vals[form1];
    var root = (cols || []).findIndex(function(item) {
      return item.key === "RootKey";
    });
    var rootKey = document2.tbls[0].rows[0].vals[root];
    diff.reserveOne = parentKey;
    diff.reserveTwo = formKey;
    diff.reserveThree = rootKey;
    if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
      diff.ContainerKey = form2.paras.map.FormKey;
    }
    ErpDesignerUI.MetaObjectType = diff.metaObjectType;
    ErpDesignerUI.parentKey = diff.parentKey;
    let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
  }
  newForm.fireClose();
};
const AddNewPanelRow = async function(evl, name, cxt, args) {
  let newForm = ErpDesignerUI.DesignDivForm, document2 = newForm.getDocument(), form2 = ErpDesignerUI.getActiveERPForm(), formDocument = form2.document, diff = new Diff();
  diff.formKey = form2.formKey;
  if (ErpDesignerUI.gridLayoutRenderType) {
    if (ErpDesignerUI.selectNode[0].tagName == "DIV") {
      diff.parentKey = ErpDesignerUI.selectNode.parent().parent().parent().parent().attr("meta-key");
      diff.y = parseInt(ErpDesignerUI.selectNode.parent().parent().attr("row"));
      diff.x = parseInt(ErpDesignerUI.selectNode.parent().attr("col"));
    } else {
      diff.parentKey = ErpDesignerUI.selectNode.parent().parent().parent().attr("meta-key");
      diff.y = parseInt(ErpDesignerUI.selectNode.parent().attr("row"));
      diff.x = parseInt(ErpDesignerUI.selectNode.attr("col"));
    }
  } else {
    diff.parentKey = ErpDesignerUI.selectNode.parent().parent().parent().attr("meta-key");
    diff.x = parseInt(ErpDesignerUI.selectNode.parent().attr("col"));
    diff.y = parseInt(ErpDesignerUI.selectNode.parent().attr("row"));
  }
  diff.metaObjectType = "AddRowPanel";
  if (ErpDesigner.selectedType == "EditViewRootGridLayout" || ErpDesigner.selectedType == "EditViewChildGridLayout") {
    diff.metaObjectType = "AddRowLayout";
    diff.key = diff.parentKey;
    diff.parentKey = ErpDesigner.selectedComponentKey;
  }
  diff.addDirection = args[0];
  diff.sideKey = "";
  ErpDesignerUI.parentKey = diff.parentKey;
  ErpDesignerUI.MetaObjectType = diff.metaObjectType;
  let successFlag = await ErpDesignerService.commitDiff(ErpDesigner.selectedFormKey, [diff], document2, formDocument, form2.paras.map.FormKey);
  if (!successFlag) {
    return;
  }
  ErpDesignerUI.showTip("添加成功", "success");
};
const deletePanelRow = async function(evl, name, cxt, args) {
  let newForm = ErpDesignerUI.DesignDivForm, document2 = newForm.getDocument(), form2 = ErpDesignerUI.getActiveERPForm(), formDocument = form2.document, diff = new Diff();
  if (ErpDesignerUI.gridLayoutRenderType) {
    if (ErpDesignerUI.selectNode[0].tagName == "DIV") {
      diff.parentKey = ErpDesignerUI.selectNode.parent().parent().parent().parent().attr("meta-key");
      diff.y = parseInt(ErpDesignerUI.selectNode.parent().parent().attr("row"));
      diff.x = parseInt(ErpDesignerUI.selectNode.parent().attr("col"));
    } else {
      diff.parentKey = ErpDesignerUI.selectNode.parent().parent().parent().attr("meta-key");
      diff.y = parseInt(ErpDesignerUI.selectNode.parent().attr("row"));
      diff.x = parseInt(ErpDesignerUI.selectNode.attr("col"));
    }
  } else {
    diff.parentKey = ErpDesignerUI.selectNode.parent().parent().parent().attr("meta-key");
    diff.x = parseInt(ErpDesignerUI.selectNode.parent().attr("col"));
    diff.y = parseInt(ErpDesignerUI.selectNode.parent().attr("row"));
  }
  diff.metaObjectType = "DeleteRowPanel";
  if (ErpDesigner.selectedType == "EditViewRootGridLayout" || ErpDesigner.selectedType == "EditViewChildGridLayout") {
    diff.metaObjectType = "DeleteRowLayout";
    diff.key = diff.parentKey;
    diff.parentKey = ErpDesigner.selectedComponentKey;
  }
  diff.deleteDirection = args[0];
  diff.sideKey = "";
  ErpDesignerUI.parentKey = diff.parentKey;
  ErpDesignerUI.MetaObjectType = diff.metaObjectType;
  let successFlag = await ErpDesignerService.commitDiff(ErpDesigner.selectedFormKey, [diff], document2, formDocument, form2.paras.map.FormKey);
  if (!successFlag) {
    return;
  }
  ErpDesignerUI.showTip("删除成功", "success");
};
const OpenFileLocation = async function(evl, name, cxt, args) {
  var dataobjectParams, filePath;
  if (args && args.length > 1) {
    var form2 = cxt.form;
    var gridKey = args[1];
    var grid = form2 && form2.getComponent(gridKey);
    if (grid) {
      var rowIndex = grid.getFocusRowIndex();
      filePath = grid.getValueByKey(rowIndex, "Key");
    } else {
      return;
    }
    dataobjectParams = {
      formKey: filePath,
      type: args[0]
    };
  } else {
    var activeOpenedXml = ErpDesigner.getActiveOpenedXml();
    if (!activeOpenedXml) {
      return;
    }
    filePath = activeOpenedXml.filePath;
    dataobjectParams = {
      formKey: filePath,
      type: args[0]
    };
  }
  let r = new Request();
  r.addHeader("content-type", "application/json");
  let res = await r.getData(dataobjectParams, ErpDesigner.url + "DesignerController/openFileLocation");
  if (res && res.msg !== "操作成功!") {
    ErpDesignerUI.showTip("操作成功", "success");
  }
};
const NewCompositeComponent = async function(evl, name, cxt, args) {
  let x, y, parentKey, parentComponentKey, reserveTwo, reserveFour;
  let sideKey = "";
  let form2 = ErpDesignerUI.getActiveERPForm();
  let newForm = ErpDesignerUI.DesignDivForm, newDocument = newForm.getDocument(), cols = newDocument.maps.get(newDocument.mainTableKey).cols, vals = newDocument.maps.get(newDocument.mainTableKey).rows[0].vals;
  let compositeComponentTypeIdx = (cols || []).findIndex(function(item) {
    return item.key === "CompositeComponentType";
  });
  let key2 = vals[compositeComponentTypeIdx];
  let tableKeyIdx = (cols || []).findIndex(function(item) {
    return item.key === "NewTableKey";
  });
  let newTableKey = vals[tableKeyIdx];
  let dataFlagIdx = (cols || []).findIndex(function(item) {
    return item.key === "IsBindData";
  });
  let dataFlag = vals[dataFlagIdx];
  if (dataFlag == 1) {
    reserveTwo = vals[tableKeyIdx];
    reserveFour = "true";
  }
  let node = ErpDesignerUI.selectNode, parentID = node.attr("id");
  let tagType = ErpDesignerUI.parentKey != null ? ErpDesignerUI.getActiveERPForm().getComponent(ErpDesignerUI.parentKey).tagName.toLowerCase() : ErpDesignerUI.getActiveERPForm().getComponent(ErpDesigner.selectedComponentKey).tagName.toLowerCase();
  if (tagType === "gridlayoutpanel" || tagType === "columnlayoutpanel1") {
    parentID = node.parent().parent().parent().attr("id");
    parentComponentKey = node.parent().parent().parent().attr("meta-key");
    x = node.attr("col");
    y = node.parent().attr("row");
    if (node[0].nodeName != "TD") {
      parentID = node.parent().parent().parent().parent().attr("id");
      if (node.attr("meta-type") == "GridLayoutPanel") {
        parentComponentKey = node.attr("meta-key");
      } else if (node.attr("meta-key")) {
        var parentKey1 = node.parent().parent().parent().parent().attr("meta-key");
        if (parentKey1) {
          parentComponentKey = parentKey1;
        }
      }
      node = node.parent();
      x = node.attr("col");
      y = node.parent().attr("row");
    }
  } else if (tagType === "flexgridlayoutpanel") {
    parentID = node.parent().attr("id");
    sideKey = ErpDesigner.selectedComponentKey;
  } else {
    parentID = node.attr("id");
  }
  parentKey = ErpDesignerUI.parentKey;
  if (parentID) {
    parentKey = parentID.replace(parentID.substring(0, parentID.indexOf("_") + 1), "");
  }
  if (parentComponentKey) {
    parentKey = parentComponentKey;
  }
  if (tagType !== "flexgridlayoutpanel") {
    x = node.attr("col");
    y = node.parent().attr("row");
  }
  ErpDesignerUI.parentKey = parentKey;
  ErpDesignerUI.MetaObjectType = "Field";
  let designerDocument, formDocument;
  if (typeof newDocument != "string" && newDocument && !form2.getDefContainer.formKey) {
    designerDocument = JSON.stringify(DataUtil.toJSONDoc(newDocument));
  }
  if (typeof form2.formDocument != "string") {
    formDocument = JSON.stringify(DataUtil.toJSONDoc(form2.formDocument));
  }
  let params = {
    cmd: "newCompositeComponent",
    service: "DesignService",
    key: key2,
    tableKey: newTableKey,
    dataFlag,
    metaObjectType: "Field",
    x,
    y,
    parentKey,
    formKey: ErpDesignerUI.activeERPFormKey,
    designerDocument,
    formDocument,
    documentFormKey: form2.formKey,
    reserveTwo,
    reserveFour,
    sideKey,
    insertAfter: false,
    entryParas: form2.paras.map.FormKey
  };
  LoadingUtil.show();
  let uiCommands = await new Request().getData(params);
  LoadingUtil.hide();
  await ErpDesignerUI.doUICommands(form2, uiCommands);
  if (uiCommands && uiCommands[0]) {
    ErpDesignerHelper.ResetSelectedBorder();
    newForm.fireClose();
  }
};
const NewComponentKey = async function(evl, name, cxt, args) {
  let form2 = ErpDesignerUI.getActiveERPForm();
  let newForm = ErpDesignerUI.DesignDivForm, newDocument = newForm.getDocument(), cols = newDocument.tbls[0].cols, vals = newDocument.tbls[0].rows[0].vals;
  let keyIdx = (cols || []).findIndex(function(item) {
    return item.key === "Key";
  });
  let key2 = vals[keyIdx];
  let formKey = form2.metaForm.extensionFormKey ? form2.metaForm.extensionFormKey : form2.formKey;
  let examinationKey = await ErpDesignerUtil.checkUniqueCompKey(formKey, key2);
  if (!examinationKey)
    return;
  let captionIdx = (cols || []).findIndex(function(item) {
    return item.key === "Caption";
  });
  let itemKeyIdx = (cols || []).findIndex(function(item) {
    return item.key === "DictItemkey";
  });
  let dynamicItemKeyIdx = (cols || []).findIndex(function(item) {
    return item.key === "DynamicDictItemkey";
  });
  let multiSelectFlagIdx = (cols || []).findIndex(function(item) {
    return item.key === "IsAllowMultiSelection";
  });
  let dataFlagIdx = (cols || []).findIndex(function(item) {
    return item.key === "IsBindData";
  });
  let tableKeyIdx = (cols || []).findIndex(function(item) {
    return item.key === "NewTableKey";
  });
  let columnKeyIdx = (cols || []).findIndex(function(item) {
    return item.key === "ColumnKey";
  });
  let dataElementKeyIdx = (cols || []).findIndex(function(item) {
    return item.key === "DataElementKey";
  });
  let controlType = ErpDesignerUtil.getControlTypeStr(newForm.getValue("ControlType").toString().substr(0, 3));
  let diff = new Diff();
  diff.formKey = form2.formKey;
  diff.itemkey = vals[itemKeyIdx];
  diff.caption = vals[captionIdx];
  diff.reserveOne = vals[dynamicItemKeyIdx];
  diff.dataElementKey = vals[dataElementKeyIdx];
  diff.key = key2;
  diff.metaObjectType = "Field";
  diff.controlType = controlType;
  diff.sideKey = "";
  if (vals[dataFlagIdx] == 1) {
    diff.reserveTwo = vals[tableKeyIdx];
    diff.reserveThree = vals[columnKeyIdx];
    diff.reserveFour = "true";
  }
  let node = ErpDesignerUI.selectNode, parentID = node.attr("id");
  if (ErpDesigner.selectedType == "EditViewRootGridLayout" || ErpDesigner.selectedType == "EditViewRootLinearLayout" || ErpDesigner.selectedType == "EditViewChildGridLayout" || ErpDesigner.selectedType == "EditViewChildLinearLayout" || ErpDesigner.selectedType == "EditViewChildFlexFlowLayout" || ErpDesigner.selectedType == "EditViewChildColumnLayout" || ErpDesigner.selectedType == "EditViewChildSplitLayout" || ErpDesigner.selectedType == "EditViewChildTabLayout" || ErpDesigner.selectedType == "EditViewChildFlowLayout" || ErpDesigner.selectedType == "EditViewChildFlexGridLayout" || ErpDesigner.selectedType == "EditViewChildLayout") {
    diff.metaObjectType = "EditViewColumn";
    diff.parentKey = ErpDesignerUI.parentKey.split("@")[0];
    diff.x = parseInt(node.attr("col"));
    diff.y = parseInt(node.parent().attr("row"));
    ErpDesignerUI.parentKey = diff.parentKey;
    ErpDesignerUI.MetaObjectType = diff.metaObjectType;
    let tableKey2 = diff.reserveTwo, columnKey2 = diff.reserveThree;
    let result2 = await checkAllSpec(evl, name, cxt, ["checkBillModifyAndNew", "newHead", key2, columnKey2, form2.type, tableKey2, controlType, false]);
    if (result2 === "false")
      return;
    if (result2 !== "noCheck")
      diff.key = result2;
    diff.reserveOne = ErpDesigner.selectedLayoutKey;
    let successFlag2 = await ErpDesignerService.commitDiff(ErpDesignerUI.activeERPFormKey, [diff], newDocument, form2.document, form2.paras.map.FormKey);
    if (!successFlag2) {
      return;
    }
    newForm.fireClose();
    return;
  }
  let parentComp = ErpDesignerUI.getActiveERPForm().getComponent(ErpDesignerUI.parentKey);
  let inDetailRow = false;
  if (ErpDesignerUI.parentKey && !parentComp) {
    if (ErpDesigner.selectedGridTrIndexKey) {
      let index = ErpDesigner.selectedGridTrIndexKey.indexOf("_");
      let detailRow = ErpDesignerUI.getActiveERPForm().getComponent(ErpDesigner.selectedGridTrIndexKey.substring(index + 1));
      if (detailRow) {
        for (let index2 in detailRow.data) {
          let rowData = detailRow.data[index2];
          if (rowData.rowType == "Detail") {
            parentComp = rowData.compMap[ErpDesignerUI.parentKey];
            inDetailRow = true;
            break;
          }
        }
      }
    }
  }
  let selectedComp = ErpDesignerUI.getActiveERPForm().getComponent(ErpDesigner.selectedComponentKey);
  let tagType = ErpDesignerUI.parentKey != null ? parentComp == null ? void 0 : parentComp.tagName.toLowerCase() : selectedComp == null ? void 0 : selectedComp.tagName.toLowerCase();
  if (ErpDesigner.selectedType === "SlidingLayoutPanel") {
    ErpDesignerUI.showTip("侧滑面板只允许添加面板类型组件!");
    return;
  }
  var parentKey = "";
  if (tagType === "gridlayoutpanel" || tagType === "columnlayoutpanel1") {
    parentID = node.parent().parent().parent().attr("id");
    parentKey = node.parent().parent().parent().attr("meta-key");
    diff.x = node.attr("col");
    diff.y = node.parent().attr("row");
    if (node[0].nodeName != "TD") {
      parentID = node.parent().parent().parent().parent().attr("id");
      if (node.attr("meta-type") == "GridLayoutPanel") {
        parentKey = node.attr("meta-key");
      } else if (node.attr("meta-key")) {
        var parentKey1 = node.parent().parent().parent().parent().attr("meta-key");
        if (parentKey1) {
          parentKey = parentKey1;
        }
      }
      node = node.parent();
      diff.x = node.attr("col");
      diff.y = node.parent().attr("row");
    }
  } else if (tagType === "flexgridlayoutpanel") {
    parentID = node.parent().attr("id");
    diff.sideKey = ErpDesigner.selectedComponentKey;
    diff.insertAfter = ErpDesignerUI.insertAfter;
  } else if (tagType === "tablerow") {
    parentID = node.attr("id");
    parentID = parentID.replace("_" + ErpDesignerUI.parentKey, "");
  } else {
    parentID = node.attr("id");
  }
  diff.parentKey = ErpDesignerUI.parentKey;
  if (parentID && !inDetailRow) {
    diff.parentKey = parentID.replace(parentID.substring(0, parentID.lastIndexOf("_") + 1), "");
  }
  if (parentKey) {
    diff.parentKey = parentKey;
  }
  if (tagType !== "flexgridlayoutpanel") {
    diff.x = parseInt(node.attr("col"));
    diff.y = parseInt(node.parent().attr("row"));
  }
  let isMultiDict = vals[multiSelectFlagIdx] == 1;
  if (isMultiDict) {
    let diffProperty = new DiffProperty();
    diffProperty.newValue = "true";
    diffProperty.property = "AllowMultiSelection";
    diff.properties.push(diffProperty);
  }
  ErpDesignerUI.parentKey = diff.parentKey;
  ErpDesignerUI.MetaObjectType = diff.metaObjectType;
  let tableKey = diff.reserveTwo, columnKey = diff.reserveThree;
  let result = await checkAllSpec(evl, name, cxt, ["checkBillModifyAndNew", "newHead", key2, columnKey, form2.type, tableKey, controlType, isMultiDict]);
  if (result === "false")
    return;
  if (result !== "noCheck")
    diff.key = result;
  let successFlag = await ErpDesignerService.commitDiff(ErpDesignerUI.activeERPFormKey, [diff], newDocument, form2.document, form2.paras.map.FormKey);
  if (!successFlag) {
    return;
  }
  newForm.fireClose();
};
const NewComponentKeyExtend = async function(evl, name, cxt, args) {
  var newForm = ErpDesignerUI.DesignDivForm, form2 = ErpDesignerUI.getActiveERPForm(), formDocument = form2.document, diff = new Diff();
  var document2 = newForm.getDocument();
  var Key = newForm.getValue("ControlType").split("@")[0];
  var Caption = newForm.getValue("ControlType").split("@")[1];
  var controlType = newForm.getValue("ControlType").split("@")[2];
  var componentKey = newForm.getValue("ControlType").split("@")[3];
  var node = ErpDesignerUI.selectNode;
  if (node && node[0] && node[0].nodeName == "TD") {
    if (ErpDesigner.selectedComponentKey.toLowerCase() == componentKey.toLowerCase()) {
      diff.formKey = form2.formKey;
      diff.key = Key;
      diff.caption = Caption;
      var node = ErpDesignerUI.selectNode;
      var parentID = node.closest("*[id]").attr("id");
      diff.x = node.attr("col");
      diff.y = node.parent().attr("row");
      diff.parentKey = parentID.replace(parentID.substring(0, parentID.indexOf("_") + 1), "");
      ErpDesignerUI.parentKey = diff.parentKey;
      diff.metaObjectType = "Field";
      ErpDesignerUI.MetaObjectType = diff.metaObjectType;
      diff.controlType = controlType;
      diff.sideKey = "";
      diff.ISButtonQuote = true;
      let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
    } else {
      ErpDesignerUI.showTip("引入组件与父组件不匹配!");
      return;
    }
  } else {
    diff.formKey = form2.formKey;
    diff.key = Key;
    diff.caption = Caption;
    var node = ErpDesignerUI.selectNode.parent();
    var parentID = node.closest("*[id]").attr("id");
    diff.x = node.attr("col");
    diff.y = node.parent().attr("row");
    diff.parentKey = parentID.replace(parentID.substring(0, parentID.indexOf("_") + 1), "");
    ErpDesignerUI.parentKey = diff.parentKey;
    diff.metaObjectType = "Field";
    ErpDesignerUI.MetaObjectType = diff.metaObjectType;
    diff.controlType = controlType;
    diff.sideKey = "";
    diff.ISButtonQuote = true;
    let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
  }
};
const NewGridColumnExtend = async function(evl, name, cxt, args) {
  var activeForm = ErpDesignerUI.getActiveERPForm(), newForm = ErpDesignerUI.DesignDivForm, document2, formDocument = activeForm.document, diff = new Diff();
  diff.formKey = activeForm.formKey;
  document2 = newForm.getDocument();
  diff.key = newForm.getValue("ControlType").split("@")[0];
  diff.caption = newForm.getValue("ControlType").split("@")[1];
  diff.controlType = newForm.getValue("ControlType").split("@")[2];
  var componentKey = newForm.getValue("ControlType").split("@")[3];
  if (ErpDesignerUI.parentKey.toLowerCase() == componentKey.toLowerCase()) {
    if (ErpDesigner.selectedComponentKey.startsWith("Column:")) {
      diff.sideKey = ErpDesigner.selectedComponentKey.substr(7);
    } else {
      diff.sideKey = ErpDesigner.selectedComponentKey;
    }
    diff.insertAfter = ErpDesignerUI.insertAfter;
    diff.metaObjectType = "GridField";
    diff.parentKey = ErpDesignerUI.parentKey;
    diff.ISButtonQuote = true;
    if (activeForm.entryParas && activeForm.getDefContainer() && activeForm.paras.map.FormKey) {
      diff.ContainerKey = activeForm.paras.map.FormKey;
    }
    let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, formDocument, activeForm.paras.map.FormKey);
    if (!successFlag) {
      return;
    }
  } else {
    ErpDesignerUI.showTip("引入组件与父组件不匹配!");
    return;
  }
};
const NewPanelExtend = async function(evl, name, cxt, args) {
  var activeForm = ErpDesignerUI.getActiveERPForm(), newForm = ErpDesignerUI.DesignDivForm, document2, formDocument = activeForm.document, diff = new Diff();
  diff.formKey = activeForm.formKey;
  var form2 = activeForm;
  document2 = newForm.getDocument();
  diff.key = newForm.getValue("ControlType").split("@")[0];
  diff.caption = newForm.getValue("ControlType").split("@")[1];
  diff.controlType = newForm.getValue("ControlType").split("@")[2];
  var componentKey = newForm.getValue("ControlType").split("@")[3];
  if (ErpDesigner.selectedComponentKey.toLowerCase() == componentKey.toLowerCase()) {
    diff.ISButtonQuote = true;
    if (diff.controlType.indexOf("Panel") != -1) {
      diff.sideKey = "";
      diff.metaObjectType = "Panel";
      diff.parentKey = ErpDesigner.selectedComponentKey;
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      ErpDesignerUI.MetaObjectType = diff.metaObjectType;
      ErpDesignerUI.parentKey = diff.parentKey;
      await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
    } else if (diff.controlType == "Grid") {
      if (ErpDesigner.selectedComponentKey != null) {
        var parentComp = form2.getComponent(ErpDesigner.selectedComponentKey);
        let parentTagName = parentComp.tagName.toLowerCase();
        if (parentTagName == "tabpanel" || parentTagName == "splitpanel" || parentTagName == "flexflowlayoutpanel" || parentTagName == "gridlayoutpanel" || parentTagName == "borderlayoutpanel" || parentTagName == "borderlayoutpanel" || parentTagName == "flowlayoutpanel" || parentTagName == "columnlayoutpanel") {
          diff.sideKey = "";
          diff.metaObjectType = "Grid";
          diff.parentKey = ErpDesigner.selectedComponentKey;
          if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
            diff.ContainerKey = form2.paras.map.FormKey;
          }
          ErpDesignerUI.MetaObjectType = diff.metaObjectType;
          ErpDesignerUI.parentKey = diff.parentKey;
          await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
        }
      }
    } else if (diff.controlType.indexOf("SubDetail") != -1) {
      if (ErpDesigner.selectedComponentKey != null) {
        diff.sideKey = "";
        diff.metaObjectType = "SubDetail";
        diff.parentKey = ErpDesigner.selectedComponentKey;
        ErpDesignerUI.MetaObjectType = diff.metaObjectType;
        ErpDesignerUI.parentKey = diff.parentKey;
        if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
          diff.ContainerKey = form2.paras.map.FormKey;
        }
        await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, ErpDesignerUI.getActiveERPForm().document, form2.paras.map.FormKey);
      }
    } else {
      diff.insertAfter = ErpDesignerUI.insertAfter;
      diff.metaObjectType = "GridField";
      diff.parentKey = ErpDesignerUI.parentKey;
      if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
        diff.ContainerKey = form2.paras.map.FormKey;
      }
      await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, formDocument, activeForm.paras.map.FormKey);
    }
  } else {
    ErpDesignerUI.showTip("引入组件与父组件不匹配!");
    return;
  }
};
const NewGridColumnToCompositeCom = async function(evl, name, cxt, args) {
  let activeForm = ErpDesignerUI.getActiveERPForm(), activeFormKey = activeForm.formKey, newForm = ErpDesignerUI.DesignDivForm;
  if (!ErpDesignerUI.activeERPFormKey)
    ErpDesignerUI.activeERPFormKey = activeFormKey;
  let key2 = newForm.getValue("Key");
  let location = newForm.getValue("Locate");
  let isNewDataSource = newForm.getValue("IsNewDataSource"), tableKey, sideKey, insertAfter;
  if (isNewDataSource) {
    tableKey = activeForm.getComponent(ErpDesignerUI.parentKey).getTableKey();
  }
  if (ErpDesigner.selectedComponentKey.startsWith("Column:")) {
    sideKey = ErpDesigner.selectedComponentKey.substr(7);
  } else {
    sideKey = ErpDesigner.selectedComponentKey;
  }
  if (location > 0) {
    insertAfter = true;
  } else {
    insertAfter = false;
  }
  let designerDocument, formDocument;
  if (typeof newForm.getDocument() != "string" && newForm.getDocument() && !activeForm.getDefContainer.formKey) {
    designerDocument = JSON.stringify(DataUtil.toJSONDoc(newForm.getDocument()));
  }
  if (typeof activeForm.getDocument() != "string") {
    formDocument = JSON.stringify(DataUtil.toJSONDoc(activeForm.getDocument()));
  }
  let params = {
    cmd: "newCompositeComponent",
    service: "DesignService",
    key: key2,
    tableKey,
    metaObjectType: "GridField",
    parentKey: ErpDesignerUI.parentKey,
    formKey: activeFormKey,
    designerDocument,
    formDocument,
    documentFormKey: activeForm.formKey,
    reserveTwo: isNewDataSource,
    reserveFour: null,
    sideKey,
    insertAfter,
    entryParas: activeForm.paras.map.FormKey
  };
  LoadingUtil.show();
  let uiCommands = await new Request().getData(params);
  LoadingUtil.hide();
  await ErpDesignerUI.doUICommands(activeForm, uiCommands);
  ErpDesignerHelper.ResetSelectedBorder();
  newForm.fireClose();
};
const NewGridColumn = async function(evl, name, cxt, args) {
  let activeForm = ErpDesignerUI.getActiveERPForm(), activeFormKey = activeForm.formKey, newForm = ErpDesignerUI.DesignDivForm;
  if (!ErpDesignerUI.activeERPFormKey)
    ErpDesignerUI.activeERPFormKey = activeFormKey;
  let newCompKey = newForm.getValue("Key"), controlTypeStr = ErpDesignerUtil.getControlTypeStr(newForm.getValue("ControlType"));
  let isNewDataSource = newForm.getValue("IsNewDataSource"), tableKey, columnKey, dataElementKey;
  let isMultiDict = newForm.getValue("IsAllowMultiSelection") === 1;
  let specArgs = ["checkBillModifyAndNew", "newGrid", newCompKey];
  if (isNewDataSource) {
    tableKey = activeForm.getComponent(ErpDesignerUI.parentKey).getTableKey();
    columnKey = newForm.getValue("ColumnKey");
    dataElementKey = newForm.getValue("DataElementKey");
    specArgs.push(columnKey);
    specArgs.push(tableKey);
    specArgs.push(controlTypeStr);
    specArgs.push(isMultiDict);
  } else {
    specArgs.push(null);
  }
  let result = await checkAllSpec(evl, name, cxt, specArgs);
  if (result === "false")
    return;
  if (result !== "noCheck")
    newCompKey = result;
  let uniqueFlag = await ErpDesignerUtil.checkUniqueCompKey(activeFormKey, newCompKey, true);
  if (!uniqueFlag)
    return false;
  if (activeForm.metaForm.extend) {
    args[0] = "NewGridFiled";
    await NewGridFiled(evl, name, cxt, args);
    return;
  }
  let diff = new Diff();
  diff.formKey = activeFormKey;
  diff.key = newCompKey;
  diff.caption = newForm.getValue("Caption");
  diff.controlType = controlTypeStr;
  diff.itemkey = newForm.getValue("DictItemkey");
  diff.dataElementKey = dataElementKey;
  diff.reserveOne = columnKey;
  diff.reserveTwo = newForm.getValue("IsNewDataSource").toString();
  diff.reserveThree = newForm.getValue("DynamicDictItemkey");
  if (ErpDesigner.selectedComponentKey.startsWith("Column:")) {
    diff.sideKey = ErpDesigner.selectedComponentKey.substr(7);
  } else {
    diff.sideKey = ErpDesigner.selectedComponentKey;
  }
  diff.insertAfter = ErpDesignerUI.insertAfter;
  diff.parentKey = ErpDesignerUI.parentKey;
  diff.metaObjectType = "GridField";
  if (activeForm.entryParas && activeForm.getDefContainer() && activeForm.paras.map.FormKey) {
    diff.ContainerKey = activeForm.paras.map.FormKey;
  }
  if (isMultiDict) {
    let diffProperty = new DiffProperty();
    diffProperty.newValue = "true";
    diffProperty.property = "AllowMultiSelection";
    diff.properties.push(diffProperty);
  }
  let activeERPFormKey = ErpDesignerUI.activeERPFormKey, designDocument = newForm.getDocument(), activeDocument = activeForm.getDocument(), paraFormKey = activeForm.paras.map.FormKey;
  let successFlag = await ErpDesignerService.commitDiff(activeERPFormKey, [diff], designDocument, activeDocument, paraFormKey);
  if (!successFlag) {
    return;
  }
  newForm.fireClose();
};
const NewListViewCol = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm(), newForm = ErpDesignerUI.DesignDivForm, document2, formDocument = form2.document, diff = new Diff();
  diff.formKey = form2.formKey;
  document2 = newForm.getDocument();
  diff.key = newForm.getValue("Key");
  diff.caption = newForm.getValue("Caption");
  diff.controlType = ErpDesignerUtil.getControlTypeStr(newForm.getValue("ControlType"));
  diff.sideKey = ErpDesigner.selectedComponentKey;
  diff.insertAfter = ErpDesignerUI.insertAfter;
  diff.parentKey = ErpDesignerUI.parentKey;
  diff.metaObjectType = "ListViewColumn";
  diff.reserveOne = newForm.getValue("ColumnKey");
  diff.reserveTwo = newForm.getValue("IsNewDataSource").toString();
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
  if (!successFlag) {
    return;
  }
  newForm.fireClose();
};
const NewListView = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.getActiveERPForm();
  ErpDesignerUI.DesignDivForm;
  var document2, formDocument = form2.document, listView = ErpDesignerUI.DesignDivForm, diff = new Diff();
  diff.formKey = form2.formKey;
  document2 = listView.getDocument();
  diff.x = ErpDesignerUI.X;
  diff.y = ErpDesignerUI.Y;
  ErpDesignerUI.Y = null;
  ErpDesignerUI.X = null;
  diff.key = listView.getValue("Key");
  diff.caption = listView.getValue("Caption");
  diff.tableKey = listView.getValue("TableKey");
  diff.tableName = listView.getValue("TableName");
  diff.controlType = ErpDesignerUtil.getControlTypeStr(listView.getValue("ControlType"));
  diff.sideKey = "";
  diff.metaObjectType = "ListView";
  diff.parentKey = ErpDesigner.selectedComponentKey;
  ErpDesignerUI.parentKey = ErpDesigner.selectedComponentKey;
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  var associat = listView.getValue("AssociationTable");
  if (associat != null) {
    diff.associatedTable = associat;
  }
  let successFlag = await ErpDesignerService.commitDiff(form2.formKey, [diff], document2, formDocument, form2.paras.map.FormKey);
  if (!successFlag) {
    return;
  }
};
const commitLineChange = async function(evl, name, cxt, args) {
  let activeOpenedXml = ErpDesigner.getActiveOpenedXml();
  if (!activeOpenedXml) {
    return;
  }
  var formKey = activeOpenedXml.formKey;
  var filePath = activeOpenedXml.filePath;
  if (filePath.indexOf("\\Form\\") === -1) {
    ErpDesignerUI.showTip("此类文件暂时不支持,谢谢", "warning");
    return;
  }
  var editor = activeOpenedXml.xmlEditor;
  var newXml = editor.getValue();
  var diff = {
    sequence: ErpDesigner.allotId(),
    formKey,
    isPropertyDiff: false,
    filePath,
    newXml
  };
  if (!!formKey) {
    let successFlag = await ErpDesignerService.commitDiff(formKey, [diff], void 0, ErpDesignerUI.getActiveERPForm().document, ErpDesignerUI.getActiveERPForm().paras.map.FormKey);
    if (!successFlag) {
      return;
    }
    ErpDesignerUI.getActiveERPForm();
    await ErpDesigner.updateActiveXmlCaption(activeOpenedXml);
  }
  ErpDesignerUI.diffs.push(diff);
  if (editor.editingContent) {
    delete editor.editingContent.startLine;
  }
};
const NewColumn = async function(evl, name, cxt, args) {
  var activeForm = ErpDesignerUI.getActiveERPForm(), newForm = ErpDesignerUI.DesignDivForm, document2, formDocument = activeForm.document, diff = new Diff();
  diff.formKey = activeForm.formKey;
  document2 = newForm.getDocument();
  diff.key = newForm.getValue("Key");
  diff.caption = newForm.getValue("Caption");
  diff.controlType = ErpDesignerUtil.getColumnType(newForm.getValue("ControlType"));
  ErpDesignerUI.ColumnType = diff.controlType;
  diff.sideKey = ErpDesigner.selectedComponentKey;
  diff.insertAfter = ErpDesignerUI.insertAfter;
  diff.metaObjectType = "GridField";
  diff.parentKey = ErpDesignerUI.parentKey;
  if (activeForm.entryParas && activeForm.getDefContainer() && activeForm.paras.map.FormKey) {
    diff.ContainerKey = activeForm.paras.map.FormKey;
  }
  let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, formDocument, activeForm.paras.map.FormKey);
  if (!successFlag) {
    return;
  }
};
const NewRow = async function(evl, name, cxt, args) {
  var activeForm = ErpDesignerUI.getActiveERPForm(), newForm = ErpDesignerUI.DesignDivForm, document2, formDocument = activeForm.document, diff = new Diff();
  diff.formKey = activeForm.formKey;
  document2 = newForm.getDocument();
  diff.key = newForm.getValue("Key");
  diff.caption = newForm.getValue("Caption");
  diff.controlType = newForm.getValue("RowType");
  diff.reserveOne = newForm.getValue("GroupKey");
  diff.sideKey = ErpDesigner.selectedComponentKey;
  if (ErpDesignerUI.ownerDetail != null) {
    diff.parentKey = ErpDesignerUI.ownerDetail;
  } else {
    diff.parentKey = ErpDesignerUI.parentKey;
  }
  if (newForm.getValue("IsAfter") == 1) {
    diff.insertAfter = true;
  } else {
    diff.insertAfter = false;
  }
  diff.metaObjectType = "GridFieldRow";
  if (activeForm.entryParas && activeForm.getDefContainer() && activeForm.paras.map.FormKey) {
    diff.ContainerKey = activeForm.paras.map.FormKey;
  }
  let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, formDocument, activeForm.paras.map.FormKey);
  if (!successFlag) {
    return;
  }
  await ErpDesignerUtil.closeForm(cxt.form);
};
const designerNewToolBar = async function(evl, name, cxt, args) {
  var activeForm = ErpDesignerUI.getActiveERPForm(), formDocument = activeForm.document, diff = new Diff();
  diff.formKey = activeForm.formKey;
  diff.controlType = "ToolBar";
  diff.metaObjectType = "newToolBar";
  diff.parentKey = ErpDesigner.selectedComponentKey;
  let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], "", formDocument, activeForm.paras.map.FormKey);
  if (!successFlag) {
    return;
  }
};
const setReportWidth = async function(evl, name, cxt, args) {
  var value2 = args[0], key2 = args[1], form2 = cxt.form;
  var strs = value2.split(";");
  form2.setComponentValue(key2, strs[1], null);
};
const setReportHeight = async function(evl, name, cxt, args) {
  var value2 = args[0], key2 = args[1], form2 = cxt.form;
  var strs = value2.split(";");
  form2.setComponentValue(key2, strs[2], null);
};
const OperationVisibility = async function() {
  var activeForm = ErpDesignerUI.getActiveERPForm();
  if (!activeForm.defaultToolBar) {
    return true;
  } else {
    return false;
  }
};
const showSource = async function(evl, name, cxt, args) {
  ErpDesignerUI.notIsCancel = true;
  ErpDesignerUI.activeERPFormKey = args[2];
  ErpDesigner.selectedFormKey = args[2];
  if (args[3].indexOf("\\") == -1) {
    args[3] = args[3].replace(/\//g, "\\");
  }
  var lastThreeChar = args[3].split("\\")[args[3].split("\\").length - 1];
  if (lastThreeChar == "BPM") {
    await ErpDesignerGlobal.saveWebFormCache(args[0], void 0, args[2], args[0], "BPM_");
  } else if (lastThreeChar == "Report") {
    await ErpDesignerGlobal.saveWebFormCache(args[0], void 0, args[2], args[0], "Report_");
  } else if (lastThreeChar == "ExcelTemplate") {
    await ErpDesignerGlobal.saveWebFormCache(args[0], void 0, args[2], args[0], "Excel_");
  } else if (lastThreeChar.indexOf("Map") !== -1) {
    await ErpDesignerGlobal.openDataMap(args[2], args[0]);
  } else if (lastThreeChar === "DataObject") {
    $(".ui-anchor-label[title='源代码']").mousedown().mouseup().click();
    LoadingUtil.show();
    let tabPanel = ErpDesignerUI.designPanel.getComponent("TabPanel1");
    let totalHeight = $(document.body).height();
    let tabHeight = totalHeight - $(tabPanel.getEl().getElm()).children(0).outerHeight();
    await CodeMirrorWorkSpace.XMLEditor.showXml(args[0], args[1], args[2], true, tabHeight);
    LoadingUtil.hide();
  } else if (lastThreeChar === "DataMigration") {
    await ErpDesignerFuns.openDataMigration(args[2], args[0]);
  } else if (ErpDesignerUI.getActiveERPForm()) {
    var filePath = args[0], caption = args[1], formKey = args[2];
    if (caption.indexOf("DataObject") != -1 || caption.indexOf("Custom") != -1 || caption.indexOf("BPM") != -1 || caption.indexOf("DataMigration") != -1 || formKey == "") {
      LoadingUtil.show();
      await CodeMirrorWorkSpace.XMLEditor.showXml(filePath, caption, formKey, true);
      LoadingUtil.hide();
    } else if (ErpDesignerUI.getActiveERPForm().formKey.toLowerCase() == formKey.toLowerCase()) {
      LoadingUtil.show();
      await CodeMirrorWorkSpace.XMLEditor.showXml(filePath, caption, formKey, true);
      LoadingUtil.hide();
      await ErpDesigner.showSelectedComponentInSource();
    }
  }
};
const designerRun = async function(evl, name, cxt, args) {
  var tmp = ErpDesigner.getActiveOpenedXml();
  if (tmp) {
    var formKey = tmp.formKey;
    await ErpDesignerUI.RunForm(formKey);
  }
};
const designerNew = async function(name, cxt) {
  if (!ErpDesignerUI.isCreateFieldModel) {
    ErpDesignerUI.isCreateFieldModel = true;
  }
};
const designerShowNewDomainDialog = async function(evl, name, cxt, args) {
  await ErpDesignerUI.showRealModal(ErpDesignerUI.D_FileTree, "D_NewDomain", args);
};
const designerShowNewDataElementDialog = async function(evl, name, cxt, args) {
  await ErpDesignerUI.showRealModal(ErpDesignerUI.D_FileTree, "D_NewDataElement", args);
};
const designerShowNewWorkFlowDialog = async function(evl, name, cxt, args) {
  await ErpDesignerUI.showRealModal(ErpDesignerUI.D_FileTree, "D_NewWorkFlow", args);
};
const NewPrintDialog = async function(evl, name, cxt, args) {
  await ErpDesignerUI.showRealModal(ErpDesignerUI.D_FileTree, "D_NewPrint", args);
};
const NewExcelDialog = async function(evl, name, cxt, args) {
  await ErpDesignerUI.showRealModal(ErpDesignerUI.D_FileTree, "D_NewExcel", args);
};
const NewDomainORDataElement = async function(evl, name, cxt, args) {
  var projectKey = args[0];
  if (projectKey == "当前项目") {
    projectKey = ErpDesignerUI.getActiveERPForm().projectKey;
  }
  var key2 = args[1], fileType = args[2], operType = args[3];
  let form2 = cxt.form, filePath = "", pFormKey = "";
  if (args.length > 4) {
    pFormKey = args[4];
  } else {
    let grid = form2 && FormStack.getForm(form2.pFormID).getComponent("Grid1");
    let rowIndex = grid.getFocusRowIndex();
    filePath = grid.getValueByKey(rowIndex, "Key");
  }
  var result = await ErpDesignerService.NewDomainORDataElement(filePath, projectKey, key2, fileType, operType, form2, pFormKey);
  if (!result) {
    ErpDesignerUI.showTip("新增" + fileType + "失败");
    return false;
  }
  if (result) {
    var resultJson = JSON.parse(result);
    if (resultJson.code == 0) {
      ErpDesignerUI.showTip("新增" + fileType + "成功", "success");
      var uiCommands = resultJson.uICommands;
      var activeForm = ErpDesignerUI.getActiveERPForm();
      await ErpDesignerUI.doUICommands(activeForm, uiCommands);
      LoadingUtil.hide();
      args[0] = resultJson.filePath;
      return true;
    } else {
      ErpDesignerUI.showTip(resultJson.msg);
      LoadingUtil.hide();
      return false;
    }
  } else {
    ErpDesignerUI.showTip("新增" + fileType + "失败");
    LoadingUtil.hide();
    return false;
  }
};
const designerNewWorkFlow = async function(evl, name, cxt, args) {
  var projectKey = args[0];
  if (projectKey == "当前项目") {
    projectKey = ErpDesignerUI.getActiveERPForm().projectKey;
  }
  var formKey = args[1], formCaption = args[2];
  var result = await ErpDesignerService.webBpmDesign("", projectKey, formKey, formCaption, "NewWork");
  if (!result) {
    ErpDesignerUI.showTip("新增工作流失败");
    return false;
  }
  if (result) {
    var resultJson = JSON.parse(result);
    if (resultJson.code == 0) {
      ErpDesignerUI.showTip("新增工作流成功", "success");
      var uiCommands = resultJson.uICommands;
      var activeForm = ErpDesignerUI.getActiveERPForm();
      await ErpDesignerUI.doUICommands(activeForm, uiCommands);
      $("div.dialog.show").remove();
      $("div.jspanel-mask").hide();
      LoadingUtil.hide();
      args[0] = resultJson.filePath;
      ErpDesignerGlobal.saveWebFormCache(args[0], void 0, formKey, args[0], "BPM_");
      return true;
    } else {
      ErpDesignerUI.showTip(resultJson.msg);
      LoadingUtil.hide();
      return false;
    }
  } else {
    ErpDesignerUI.showTip("新增工作流失败");
    LoadingUtil.hide();
    return false;
  }
};
const NewSonGridColumn = async function(evl, name, cxt, args) {
  var activeForm = ErpDesignerUI.getActiveERPForm(), newForm = ErpDesignerUI.DesignDivForm, document2, formDocument = activeForm.document, diff = new Diff();
  diff.formKey = activeForm.formKey;
  document2 = newForm.getDocument();
  diff.key = newForm.getValue("Key");
  diff.caption = newForm.getValue("Caption");
  diff.itemkey = newForm.getValue("DictItemkey");
  diff.dataElementKey = newForm.getValue("DataElementKey");
  diff.controlType = ErpDesignerUtil.getControlTypeStr(newForm.getValue("ControlType"));
  diff.sideKey = ErpDesigner.selectedComponentKey;
  diff.insertAfter = ErpDesignerUI.insertAfter;
  diff.metaObjectType = "GridField";
  if (ErpDesigner.selectedComponentKey.startsWith("Column:")) {
    diff.parentKey = ErpDesigner.selectedComponentKey.substr(7);
  } else {
    diff.parentKey = ErpDesigner.selectedComponentKey;
  }
  diff.reserveOne = "AddSonRow";
  diff.reserveTwo = newForm.getValue("IsNewDataSource").toString();
  diff.reserveThree = newForm.getValue("ColumnKey");
  if (activeForm.entryParas && activeForm.getDefContainer() && activeForm.paras.map.FormKey) {
    diff.ContainerKey = activeForm.paras.map.FormKey;
  }
  let successFlag = await ErpDesignerService.commitDiff(activeForm.formKey, [diff], document2, formDocument, activeForm.paras.map.FormKey, true);
  if (!successFlag) {
    return;
  }
};
const NewDataObject = async function(evl, name, cxt, args) {
  await ErpDesignerUI.showRealModal(ErpDesignerUI.D_FileTree, "D_NewDataObject", args);
};
const addDataObject = async function(evl, name, cxt, args) {
  let key2 = args[0], caption = args[1], projectKey = args[2], extend2 = args[3];
  if (projectKey === "当前项目") {
    projectKey = ErpDesignerUI.getActiveERPForm().projectKey;
  }
  let params = {
    cmd: "NewDataObject",
    service: "DesignService",
    projectKey,
    key: key2,
    caption,
    extend: extend2,
    type: 1
  };
  LoadingUtil.show();
  var result = await new Request().getData(params);
  LoadingUtil.hide();
  let resultJson = JSON.parse(result);
  if (resultJson.code === 0) {
    ErpDesignerUI.showTip(resultJson.msg, "success");
    await ErpDesignerUI.doUICommands(ErpDesignerUI.getActiveERPForm(), resultJson.uICommands);
    return true;
  } else {
    ErpDesignerUI.showTip(resultJson.msg);
    return false;
  }
};
const commitExcel = async function(evl, name, cxt, args) {
  var projectKey = args[0];
  if (projectKey == "当前项目") {
    projectKey = ErpDesignerUI.getActiveERPForm().projectKey;
  }
  var projectKey = args[0], newFormKey = args[1], formCaption = args[2], associationForm = args[3], params = {
    cmd: "WebExcelDesign",
    service: "DesignService",
    projectKey,
    newFormKey,
    formCaption,
    associationForm
  };
  var r = new Request();
  var result = await r.getData(params);
  if (result) {
    var resultJson = JSON.parse(result);
    if (resultJson.code == 0) {
      var uiCommands = resultJson.uICommands;
      var activeForm = ErpDesignerUI.getActiveERPForm();
      await ErpDesignerUI.doUICommands(activeForm, uiCommands);
      await ErpDesignerUI.reloadFileTree(resultJson.filePath);
      ErpDesignerGlobal.saveWebFormCache(resultJson.filePath, void 0, newFormKey, resultJson.filePath, "Excel_");
      Close(null, name, cxt, "");
      ErpDesignerUI.showTip("新增Excel模板成功", "success");
    } else {
      ErpDesignerUI.showTip(resultJson.msg);
      LoadingUtil.hide();
      return false;
    }
  } else {
    LoadingUtil.hide();
    ErpDesignerUI.showTip("新增Excel模板失败");
    return false;
  }
};
const commitPrint = async function(evl, name, cxt, args) {
  var projectKey = args[0];
  if (projectKey == "当前项目") {
    projectKey = ErpDesignerUI.getActiveERPForm().projectKey;
  }
  var projectKey = args[0], newFormKey = args[1], formCaption = args[2], associationForm = args[3], createDefaultTemplate = args[4], params = {
    cmd: "WebPrintDesign",
    service: "DesignService",
    projectKey,
    newFormKey,
    formCaption,
    createDefaultTemplate,
    associationForm
  };
  var keyRule = /^[a-zA-Z]\w+$/;
  if (!keyRule.test(newFormKey)) {
    ErpDesignerUI.showTip("标识不符合规范");
    return;
  }
  var r = new Request();
  var result = await r.getData(params);
  if (result) {
    var resultJson = JSON.parse(result);
    if (resultJson.code == 0) {
      var uiCommands = resultJson.uICommands;
      var activeForm = ErpDesignerUI.getActiveERPForm();
      await ErpDesignerUI.doUICommands(activeForm, uiCommands);
      await ErpDesignerUI.reloadFileTree(resultJson.filePath);
      ErpDesignerGlobal.saveWebFormCache(resultJson.filePath, void 0, newFormKey, resultJson.filePath, "Report_");
      Close(null, name, cxt, "");
      ErpDesignerUI.showTip("新增打印模板成功", "success");
    } else {
      ErpDesignerUI.showTip(resultJson.msg);
      LoadingUtil.hide();
      return false;
    }
  } else {
    LoadingUtil.hide();
    ErpDesignerUI.showTip("新增打印模板失败");
    return false;
  }
};
const commitDataMap = async function(evl, name, cxt, args) {
  args[4];
  args[3];
  var projectKey = args[0];
  if (projectKey == "当前项目") {
    projectKey = ErpDesignerUI.getActiveERPForm().projectKey;
  }
  var sourceFormKey = args[1], targetFormKey = args[2], key2 = args[3], caption = args[4], Extend = args[5], mergeToSource = args[6], params = {
    cmd: "WebDataMapDesign",
    service: "DesignService",
    filePath: "",
    projectKey,
    sourceFormKey,
    targetFormKey,
    extend: Extend,
    mergeToSource,
    key: key2,
    caption,
    type: 1
  };
  LoadingUtil.show();
  var result = await new Request().getData(params);
  LoadingUtil.hide();
  if (result) {
    var resultJson = JSON.parse(result);
    if (resultJson.code == 0) {
      var uiCommands = resultJson.uICommands;
      var activeForm = ErpDesignerUI.getActiveERPForm();
      ErpDesignerUtil.closeForm(cxt.form);
      await ErpDesignerUI.doUICommands(activeForm, uiCommands);
      ErpDesignerUI.showTip("新增数据映射成功", "success");
      return;
    } else {
      ErpDesignerUI.showTip(resultJson.msg);
      return false;
    }
  } else {
    ErpDesignerUI.showTip("新增数据映射失败");
    return false;
  }
};
const NewDataMigration = async function(evl, name, cxt, args) {
  await ErpDesignerUI.showRealModal(ErpDesignerUI.D_FileTree, "D_NewDataMigration", args);
};
const CommitDataMigration = async function(evl, name, cxt, args) {
  var projectKey = args[0];
  if (projectKey == "当前项目") {
    projectKey = ErpDesignerUI.getActiveERPForm().projectKey;
  }
  var sourceFormKey = args[1], targetFormKey = args[2], key2 = args[3], caption = args[4], extend2 = args[5], params = {
    cmd: "WebDataMigration",
    service: "DesignService",
    filePath: "",
    projectKey,
    sourceFormKey,
    targetFormKey,
    key: key2,
    caption,
    extend: extend2,
    type: 1
  };
  var result = await new Request().getData(params);
  if (result) {
    var resultJson = JSON.parse(result);
    if (resultJson.code == 0) {
      var uiCommands = resultJson.uICommands;
      var activeForm = ErpDesignerUI.getActiveERPForm();
      await ErpDesignerUtil.closeForm(cxt.form);
      await ErpDesignerUI.doUICommands(activeForm, uiCommands);
      await ErpDesignerFuns.openDataMigration(args[3], resultJson.filePath);
      ErpDesignerUI.showTip("新增数据迁移成功", "success");
      return true;
    } else {
      ErpDesignerUI.showTip(resultJson.msg);
      LoadingUtil.hide();
      return false;
    }
  } else {
    ErpDesignerUI.showTip("新增数据迁移失败");
    LoadingUtil.hide();
    return false;
  }
};
const designerShowNewFormDialog = async function(evl, name, cxt, args) {
  ErpDesignerUI.isNew = true;
  await ErpDesignerUI.showRealModal(ErpDesignerUI.D_FileTree, "D_NewForm", args);
};
const NewEntryDialog = async function(evl, name, cxt, args) {
  ErpDesignerUI.isNew = true;
  await ErpDesignerUI.showRealModal(ErpDesignerUI.DesignDivForm, "D_NewEntry", args);
};
const NewEntryItemDialog = async function(evl, name, cxt, args) {
  ErpDesignerUI.isNew = true;
  await ErpDesignerUI.showRealModal(ErpDesignerUI.DesignDivForm, "D_NewEntryItem", args);
};
const designerShowNew = async function(name, cxt) {
  ErpDesignerUI.isNew = true;
  await ErpDesignerUI.showRealModal(ErpDesignerUI.designPanel, "D_Operating");
};
const designerShowNewProjectDialog = async function(evl, name, cxt, args) {
  ErpDesignerUI.isNew = true;
  await ErpDesignerUI.showRealModal(ErpDesignerUI.D_FileTree, "D_NewProject", args);
};
const NewDataMapXML = async function(evl, name, cxt, args) {
  await ErpDesignerUI.showRealModal(ErpDesignerUI.D_FileTree, "D_NewDataMap", args);
};
const designerNewExtensionForm = async function(evl, name, cxt, args) {
  await UICheck(null, name, cxt, "");
  var form2 = cxt.form;
  var doc = form2.document;
  var fieldsTableInSourceForm = doc.getByKey("ED_NewExtensionForm");
  var sourceFormKey = args[0], formKey = args[1], formCaption = args[2], projectKey = args[3], directory = args[4];
  if (projectKey == "当前项目") {
    projectKey = ErpDesignerUI.getActiveERPForm().projectKey;
  }
  var keyRule = /^[a-zA-Z]\w+$/;
  if (formKey == "") {
    ErpDesignerUI.showTip("标识不能为空", "warning");
    return;
  }
  if (!keyRule.test(formKey)) {
    ErpDesignerUI.showTip("标识不符合规范");
    return;
  }
  if (formCaption == "") {
    ErpDesignerUI.showTip("名称不能为空", "warning");
    return;
  }
  var result = await checkAllSpec(evl, name, cxt, ["checkBillModifyAndNew", "billKey", formKey, projectKey]);
  if (result != "noCheck") {
    formKey = result;
  }
  var params = {
    cmd: "NewExtensionForm",
    service: "DesignService",
    sourceFormKey,
    newFormKey: formKey,
    formCaption,
    projectKey,
    directory,
    fieldsTableInSourceForm: JSON.stringify(DataUtil.toJSONDataTable(fieldsTableInSourceForm))
  };
  var uiCommands = await new Request().getData(params);
  if (uiCommands == null || uiCommands == void 0) {
    ErpDesignerUI.showTip("表单名存在创建失败");
  } else {
    if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
      ErpDesignerUI.showTip("创建失败");
      return;
    }
    if ($.isArray(uiCommands)) {
      var activeForm = ErpDesignerUI.getActiveERPForm();
      await Close(null, name, cxt, "");
      await ErpDesignerUI.doUICommands(activeForm, uiCommands);
      ErpDesignerUI.showTip("创建成功", "success");
    }
  }
};
const designerNewForm = async function(evl, name, cxt, args) {
  await UICheck(null, name, cxt, "");
  var projectKey = args[0];
  if (projectKey == "当前项目") {
    projectKey = ErpDesignerUI.getActiveERPForm().projectKey;
  }
  var form2 = cxt.form;
  var doc = form2.document;
  var dataTable = doc.getByKey("ED_NewForm");
  var configKey = args[0], formType = args[1], formKey = args[2], formCaption = args[3], directory = args[4], IsDirectory = args[5], InDataObject = args[6], IsTemplate = args[7], ModuleSelect = args[13], Source = args[10], QueryConditions = args[8], IsBySql = args[11], newReportFormBySQL = args[12], AssociationForm = args[9], Platform = args[14], TablePrefix = dataTable.getByKey("TablePrefix");
  var keyRule = /^[a-zA-Z]\w+$/;
  if (formType == "0") {
    ErpDesignerUI.showTip("类型不能为空", "warning");
    return;
  }
  if (formKey == "") {
    ErpDesignerUI.showTip("标识不能为空", "warning");
    return;
  }
  if (!keyRule.test(formKey)) {
    ErpDesignerUI.showTip("标识不符合规范");
    return;
  }
  if (formCaption == "") {
    ErpDesignerUI.showTip("名称不能为空", "warning");
    return;
  }
  var result = await checkAllSpec(evl, name, cxt, ["checkBillModifyAndNew", "billKey", formKey, configKey]);
  if (result != "noCheck") {
    formKey = result;
  }
  LoadingUtil.show();
  var params = {
    cmd: "NewForm",
    service: "DesignService",
    projectKey,
    formType,
    newFormKey: formKey,
    formCaption,
    directory,
    IsDirectory,
    InDataObject,
    IsTemplate,
    ModuleSelect,
    Source,
    IsBySql,
    newReportFormBySQL,
    QueryConditions,
    AssociationForm,
    TablePrefix,
    Platform
  }, uiCommands = await new Request().getData(params);
  if (uiCommands == null || uiCommands == void 0) {
    ErpDesignerUI.showTip("表单名存在创建失败");
  } else {
    if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
      LoadingUtil.hide();
      return;
    }
    if ($.isArray(uiCommands)) {
      var activeForm = ErpDesignerUI.getActiveERPForm();
      await Close(null, name, cxt, "");
      await ErpDesignerUI.doUICommands(activeForm, uiCommands);
      ErpDesignerUI.showTip("创建成功", "success");
    }
  }
  LoadingUtil.hide();
};
const designerCopyForm = async function(evl, name, cxt, args) {
  await UICheck(null, name, cxt, "");
  var projectKey = args[0];
  if (projectKey == "当前项目") {
    projectKey = ErpDesignerUI.getActiveERPForm().projectKey;
  }
  var formKey = args[1], formCaption = args[2], directory = args[3], IsNewEntry = args[4], Source = args[5], AssociationForm = args[6];
  var keyRule = /^[a-zA-Z]\w+$/;
  if (projectKey == "") {
    ErpDesignerUI.showTip("未填写工程", "warning");
    return;
  }
  if (AssociationForm == "") {
    ErpDesignerUI.showTip("未选择关联表单", "warning");
    return;
  }
  if (directory == "") {
    ErpDesignerUI.showTip("未填写目录", "warning");
    return;
  }
  if (formKey == "") {
    ErpDesignerUI.showTip("标识不能为空", "warning");
    return;
  }
  if (!keyRule.test(formKey)) {
    ErpDesignerUI.showTip("标识不符合规范");
    return;
  }
  if (formCaption == "") {
    ErpDesignerUI.showTip("名称不能为空", "warning");
    return;
  }
  var params = {
    cmd: "CopyForm",
    service: "DesignService",
    projectKey,
    newFormKey: formKey,
    formCaption,
    directory,
    IsNewEntry,
    Source,
    AssociationForm
  }, uiCommands = await new Request().getData(params);
  var activeForm = ErpDesignerUI.getActiveERPForm();
  if (uiCommands != null && uiCommands.key != void 0) {
    ErpDesignerUI.showTip("uiCommands.content");
  } else {
    await Close(null, name, cxt, "");
    await ErpDesignerUI.doUICommands(activeForm, uiCommands);
    ErpDesignerUI.showTip("创建成功", "success");
  }
};
const designerReviseProject = async function(evl, name, cxt, args) {
  LoadingUtil.show();
  let projectKey = args[0], projectCaption = args[1], solutionKey = args[2], optType = args[3];
  if (optType === "New") {
    let result = await checkAllSpec(evl, name, cxt, ["checkBillModifyAndNew", "configKey", projectCaption, projectKey]);
    if (result !== "noCheck")
      projectCaption = result;
  }
  if (optType === "Delete") {
    let form2 = cxt.form, grid = form2.getComponent("Grid1"), rowIndex = grid.getFocusRowIndex(), type = grid.getValueByKey(rowIndex, "Type");
    projectKey = grid.getValueByKey(rowIndex, "ProjectKey");
    if (type == "project") {
      solutionKey = grid.getValueByKey(rowIndex, "ParentKey");
    } else {
      solutionKey = grid.getValueByKey(rowIndex, "Key");
    }
  }
  let params = { cmd: "ReviseProject", service: "DesignService", newProject: projectKey, ProjectCaption: projectCaption, Type: optType, SolutionKey: solutionKey };
  let uiCommands = await new Request().getData(params);
  if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
    return;
  }
  await ErpDesignerUI.doUICommands(ErpDesignerUI.getActiveERPForm(), uiCommands);
  LoadingUtil.hide();
};
const designerNewEntry = async function(evl, name, cxt, args) {
  let params = {
    cmd: "NewEntry",
    service: "DesignService",
    subKey: args[0],
    subType: args[1],
    subCaption: args[2],
    subOpen: args[3],
    subVisible: args[4],
    subIcon: args[5],
    subOnClick: args[6],
    parentKey: args[7],
    sideKey: args[8],
    filePath: ErpDesignerUI.DesignDivForm.getComponent("FilePath").getValue()
  };
  let uiCommands = await new Request().getData(params);
  let parentForm = cxt.getForm().getParentForm();
  let parentCxt = new ViewContext(parentForm);
  await parentForm.eval("Macro_LoadObject()", parentCxt, null);
  if (!uiCommands) {
    ErpDesignerUI.showTip("Key存在创建失败");
  } else {
    if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
      return;
    }
    var activeForm = ErpDesignerUI.getActiveERPForm();
    await ErpDesignerUI.doUICommands(activeForm, uiCommands);
    ErpDesignerUI.showTip("添加成功", "success");
  }
};
const confirmDialog = async function(evl, name, cxt, args) {
  ConfirmDialog.show({
    title: "提示",
    message: args[0],
    closeOnBackdropClick: false,
    buttons: [
      { text: "确定", color: "#4CAF50", handler: () => function() {
        return;
      }() }
    ]
  });
};
const designerEntryByDelete = async function(evl, name, cxt, args) {
  ConfirmDialog.show({
    title: "信息",
    message: "确定删除吗?,删除后无法还原,请谨慎操作!!!",
    closeOnBackdropClick: false,
    buttons: [
      { text: "取消", handler: () => function() {
        return;
      }() },
      { text: "确定", color: "#4CAF50", handler: () => async function() {
        var subKey = args[0], parentKey = args[1], subType = args[2], params = {
          cmd: "DeleteEntry",
          service: "DesignService",
          subKey,
          parentKey,
          subType,
          filePath: ErpDesignerUI.DesignDivForm.getComponent("FilePath").getValue()
        };
        let uiCommands = await new Request().getData(params);
        if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
          return;
        }
        var activeForm = ErpDesignerUI.getActiveERPForm();
        await ErpDesignerUI.doUICommands(activeForm, uiCommands);
        var grid = cxt.form.getComponent("detail");
        var rowIndex = grid.getFocusRowIndex();
        grid.deleteRow(rowIndex, true);
        ErpDesignerUI.showTip("删除成功", "success");
      }() }
    ]
  });
};
const designerNewEntryItem = async function(evl, name, cxt, args) {
  var subKey = args[0], subType = args[1], subCaption = args[2], subVisible = args[3], subEnable = args[4], subIcon = args[5], subOnClick = args[6], subParameters = args[7], subFormKey = args[8], subSingle = args[9], subTarget = args[10], parentKey = args[11], sideKey = args[12], params = {
    cmd: "NewEntryItem",
    service: "DesignService",
    subKey,
    subType,
    subCaption,
    subEnable,
    subVisible,
    subIcon,
    subOnClick,
    subParameters,
    subFormKey,
    subSingle,
    subTarget,
    parentKey,
    sideKey,
    filePath: ErpDesignerUI.DesignDivForm.getComponent("FilePath").getValue()
  }, uiCommands = await new Request().getData(params);
  let parentForm = cxt.getForm().getParentForm();
  let parentCxt = new ViewContext(parentForm);
  await parentForm.eval("Macro_LoadObject()", parentCxt, null);
  if (uiCommands == null || uiCommands == void 0) {
    ErpDesignerUI.showTip("Key存在创建失败");
  } else {
    var activeForm = ErpDesignerUI.getActiveERPForm();
    await ErpDesignerUI.doUICommands(activeForm, uiCommands);
    ErpDesignerUI.showTip("添加成功", "success");
  }
};
const designerNewExpandForm = async function(evl, name, cxt, args) {
  await UICheck(null, name, cxt, "");
  var projectKey = args[0];
  if (projectKey == "当前项目") {
    projectKey = ErpDesignerUI.getActiveERPForm().projectKey;
  }
  var associationForm = args[1], formKey = args[2], formCaption = args[3], directory = args[4], IsDirectory = args[5], Source = args[6], MergeToSource = args[7], params = {
    cmd: "NewExpandForm",
    service: "DesignService",
    projectKey,
    associationForm,
    newFormKey: formKey,
    formCaption,
    directory,
    IsDirectory,
    Source,
    MergeToSource
  }, uiCommands = await new Request().getData(params);
  if (uiCommands == null || uiCommands == void 0) {
    ErpDesignerUI.showTip("表单名存在创建失败");
  } else {
    if (uiCommands.name && uiCommands.name.endsWith("Exception")) {
      return;
    }
    await Close(null, name, cxt, "");
    var activeForm = ErpDesignerUI.getActiveERPForm();
    await ErpDesignerUI.doUICommands(activeForm, uiCommands);
    ErpDesignerUI.showTip("创建成功", "success");
  }
};
const linkWithActiveForm = async function(evl, name, cxt, args) {
  let activeForm = ErpDesignerUI.getActiveERPForm();
  if (!activeForm)
    return;
  let formKey = activeForm.getFormKey();
  if (formKey !== "D_WebMap") {
    LoadingUtil.show();
    if (formKey === "WEBDATAMAP") {
      await ErpDesignerSrc.showXmlByFormKey(formKey, void 0);
    } else {
      await ErpDesignerSrc.showXmlByFormKey(formKey, activeForm.paras.map.FormKey);
    }
    LoadingUtil.hide();
    return;
  }
  var form2 = ErpDesignerUI.D_FileTree, grid = form2.getComponent("Grid1");
  var colIndex = form2.getCellLocation("Key").column;
  LoadingUtil.show();
  await CodeMirrorWorkSpace.XMLEditor.showXml(activeForm.WebMapPath, activeForm.WebMapCaption, activeForm.WebMapFormKey, true);
  LoadingUtil.hide();
  var parentPaths = await new Request().getData({
    cmd: "LoadParentPathsByPath",
    service: "DesignService",
    path: activeForm.WebMapPath
  });
  var $grid = grid.getEl();
  let rowCount = grid.getRowCount();
  if (rowCount <= 0) {
    return;
  }
  let level = grid.getRowDataAt(0).treeLevel, startIndex = 0;
  if (!$grid) {
    return;
  }
  var el = ErpDesignerUI.D_FileTree.getComponent("Grid1").getEl();
  el.$table[0];
  for (let i = 0, size = parentPaths.length; i < size; i++) {
    let treeNode = parentPaths[i];
    for (let rowIndex = startIndex, rowCount2 = grid.getRowCount(); rowIndex < rowCount2; rowIndex++) {
      let rowData = grid.getRowDataAt(rowIndex);
      if (!rowData) {
        continue;
      }
      if (rowData.treeLevel == level && grid.getCellDataAt(rowIndex, colIndex)[0] == treeNode) {
        if (i == size - 1) {
          grid.getEl().setCellFocus(rowIndex, $grid[0].p.treeIndex);
          $grid[0].p.selectModel.focusRow = rowIndex;
          $grid[0].p.selectModel.focusCol = $grid[0].p.treeIndex + 1;
          let $row = $("tr:eq(" + (rowIndex + 1) + ")", $grid), $gridbdiv = $(".ui-ygrid-bdiv", $grid);
          $gridbdiv.animate({ scrollTop: $row[0].offsetTop }, "slow");
          $("tr:eq(" + (rowIndex + 1) + ") td:eq(" + $grid[0].p.treeIndex + ")", $grid).mousedown().mouseup();
        } else {
          let $row = $("tr:eq(" + (rowIndex + 1) + ")", $grid), $td = $("td:eq(" + ($grid[0].p.treeIndex + ($grid[0].p.rowSequences ? 1 : 0)) + ")", $row), $span = $("span.cell-tree-icon", $td);
          if ($span.hasClass("cell-collapse")) {
            $grid[0].p.selectModel.focusRow = rowIndex;
            $grid[0].p.selectModel.focusCol = $grid[0].p.treeIndex;
            $span.mousedown().mouseup();
            if ($span.hasClass("cell-tree-icon")) {
              await ErpDesignerUtil.treeClick(grid, el.getFocusRowIndex(), $span);
            }
          }
          startIndex = rowIndex + 1;
          break;
        }
      }
      if (rowData.treeLevel < level) {
        return;
      }
    }
    level++;
  }
};
const Relocate = async function(evl, name, cxt, args) {
  await ErpDesignerUI.locateactive();
};
const getActiveXMLPath = async function(evl, name, cxt, args) {
  var tmp = ErpDesigner.getActiveOpenedXml();
  return tmp ? tmp.filePath : "";
};
const getActiveFormOperationVisible = async function(evl, name, cxt, args) {
  var activeForm = ErpDesignerUI.getActiveERPForm();
  if (!activeForm) {
    return false;
  }
  if (activeForm && activeForm.formKey) {
    var Key;
    if (activeForm.formKey == "D_WebMap") {
      Key = activeForm.WebMapFormKey;
    } else {
      Key = activeForm.formKey;
    }
    var getReMakeXmlFileCount = await new Request().getData({
      cmd: "GetReMakeXmlFileCountCmd",
      service: "DesignService",
      Key
    });
    ErpDesignerUI.RedoCount = getReMakeXmlFileCount;
  }
  var hasEdited = false;
  var operation = args[0];
  var key2 = activeForm.formKey;
  if (!ErpDesignerSrc.formDependXMLs)
    return hasEdited;
  var formDependXMLs = ErpDesignerSrc.formDependXMLs.get(key2);
  if (formDependXMLs) {
    for (let openedXmlsKey of formDependXMLs) {
      var openedXml = ErpDesignerSrc.openedXmls.get(openedXmlsKey);
      if (!openedXml) {
        continue;
      }
      if (!hasEdited) {
        if (operation === "run") {
          hasEdited = openedXml && openedXml.formKey || hasEdited;
        } else if (operation === "save") {
          hasEdited = openedXml && ErpDesignerSrc.hasEdited(openedXml) || hasEdited;
        } else if (operation === "delete") {
          hasEdited = openedXml && !openedXml.isNew && !(openedXml.caption.toLowerCase() == "CommonDef".toLowerCase()) || hasEdited;
        } else if (operation === "cancel") {
          hasEdited = openedXml && ErpDesignerSrc.hasEdited(openedXml) || hasEdited;
        }
      }
    }
  }
  return hasEdited;
};
const getActiveXMLOperationVisible = async function(evl, name, cxt, args) {
  var activeForm = ErpDesignerUI.getActiveERPForm();
  if (activeForm && activeForm.formKey) {
    var Key;
    if (activeForm.formKey == "D_WebMap") {
      Key = activeForm.WebMapFormKey;
    } else {
      Key = activeForm.formKey;
    }
    var getReMakeXmlFileCount = await new Request().getData({
      cmd: "GetReMakeXmlFileCountCmd",
      service: "DesignService",
      Key
    });
    ErpDesignerUI.RedoCount = getReMakeXmlFileCount;
  }
  var openedXml = ErpDesigner.getActiveOpenedXml(), operation = args[0];
  if (openedXml && openedXml.xmlEditor && openedXml.xmlEditor.isReadOnly()) {
    return false;
  }
  if (operation === "run") {
    return openedXml && openedXml.formKey;
  } else if (operation === "save") {
    return openedXml && ErpDesignerSrc.hasEdited(openedXml);
  } else if (operation === "delete") {
    return openedXml && !openedXml.isNew && !(openedXml.caption.toLowerCase() == "CommonDef".toLowerCase());
  } else if (operation === "cancel") {
    return openedXml && ErpDesignerSrc.hasEdited(openedXml);
  } else if (operation === "Undo") {
    ErpDesignerUI.UndoCount = openedXml && ErpDesignerSrc.hasEdited(openedXml) && !(openedXml.caption.toLowerCase() == "CommonDef".toLowerCase());
    return ErpDesignerUI.UndoCount;
  } else if (operation === "NewWorkFlow") {
    return openedXml;
  } else if (operation === "newForm") {
    return true;
  } else if (operation == void 0) {
    return true;
  } else {
    throw new Error("getActiveXMLOperationVisible不支持参数：" + args);
  }
};
const RefreshParentToolbar = async function() {
  await ErpDesigner.resetFormOperationStatus(ErpDesignerUI.DesignActionForm[1]);
  await ErpDesigner.resetFormOperationStatus(ErpDesignerUI.DesignActionForm[0]);
};
const refreshXMLSource = async function(evl, name, cxt, args) {
  setTimeout(function() {
    for (let [filePath, tmp] of ErpDesignerSrc.openedXmls) {
      var xmlEditor = tmp.xmlEditor;
      if (xmlEditor) {
        xmlEditor.refresh();
      }
    }
  }, 0);
};
const isOpenActiveXml = async function(evl, name, cxt, args) {
  var $pnl = document.getElementsByClassName("ui-tabpnl ui-pnl");
  var pnlid = "";
  for (var i = 0; i < $pnl.length; i++) {
    var pid = $pnl[i].id;
    if (pid.endsWith("_TabPanel") || pid.endsWith("_TabPanel1")) {
      pnlid = pid;
    }
  }
  var $1 = $("#" + pnlid);
  $1.find("li").each(function() {
    $(this).unbind("click").click(ErpDesignerFuns.SwitchForm);
    $(this).unbind("dblclick").dblclick(ErpDesignerFuns.OpenForm);
  });
  var activeOpenedXml = ErpDesigner.getActiveOpenedXml();
  if (activeOpenedXml) {
    return true;
  }
  return false;
};
const ReMigrates = async function(evl, name, cxt, args) {
  var params = {
    cmd: "ReMigrate",
    service: "DesignService",
    objectKey: args[0]
  };
  var uiCommands = await new Request().getData(params);
  await ErpDesignerUI.doUICommands(ErpDesignerUI.DesignDivForm, uiCommands);
};
const saveFileContent = async function(evl, name, cxt, args) {
  async function processSaveUICommands(uiCommands2) {
    ErpDesigner.selectedComponentKey = null;
    var activeForm = ErpDesignerUI.getActiveERPForm();
    if (!uiCommands2 || uiCommands2.length == 0) {
      return;
    }
    await ErpDesignerUI.doUICommands(activeForm, uiCommands2);
    await ErpDesigner.resetFormOperationStatus(ErpDesignerUI.DesignActionForm[1]);
    await ErpDesigner.resetFormOperationStatus(ErpDesignerUI.DesignActionForm[0]);
    setTimeout(function() {
      ErpDesigner.hideSelectedBorder();
    }, 500);
  }
  async function processOpenedXmlAfterSave(openedXml2) {
    openedXml2.xmlEditor.clearHistory();
    openedXml2.isNew = false;
    openedXml2.isEditBeforeLoad = false;
    await ErpDesigner.updateActiveXmlCaption(openedXml2);
    for (var diffs = ErpDesignerUI.diffs, i2 = 0, size2 = diffs.length; i2 < size2; i2++) {
      var diff = diffs[i2];
      if (diff.filePath == openedXml2.filePath) {
        diffs.splice(i2, 1);
        size2--;
        i2--;
      }
    }
  }
  var xml = ErpDesigner.getActiveOpenedXml();
  var filePath = xml.filePath;
  var xmlContent = xml.xmlEditor.doc.getValue();
  if (xml && ErpDesignerSrc.hasEdited(xml)) {
    LoadingUtil.show();
    var result = await checkAllSpec(evl, name, cxt, ["checkKeyAndFileName", filePath, xmlContent]);
    LoadingUtil.hide();
    if (result == "false") {
      return;
    }
  }
  LoadingUtil.show();
  await checkAllSpec(evl, name, cxt, ["checkVariableReport"]);
  LoadingUtil.hide();
  var isSourceActive = ErpDesignerUI.designPanel.getComponent("TabPanel1").getActiveTab() === "SourceTab";
  if (isSourceActive) {
    var openedXml = ErpDesigner.getActiveOpenedXml();
    var value2 = openedXml.xmlEditor.doc.getValue();
    if (openedXml && ErpDesignerSrc.hasEdited(openedXml)) {
      LoadingUtil.show();
      let uiCommands2 = await ErpDesignerService.checkKeyLength(true, value2, "", "");
      if (uiCommands2 && uiCommands2.length > 0) {
        await ErpDesignerUI.doUICommands(ErpDesignerUI.getActiveERPForm(), uiCommands2);
        LoadingUtil.hide();
        return;
      }
      var filePath = openedXml.filePath, content = value2, key2 = openedXml.formKey, uiCommands1 = await ErpDesignerService.saveFileContent(filePath, content, key2);
      LoadingUtil.hide();
      if (!uiCommands1 || uiCommands1.name && uiCommands1.name.endsWith("Exception")) {
        return;
      }
      processSaveUICommands(uiCommands1);
      await processOpenedXmlAfterSave(openedXml);
    }
  } else {
    let activeERPForm = ErpDesignerUI.getActiveERPForm();
    LoadingUtil.show();
    var uiCommands = await ErpDesignerService.parseFormula(activeERPForm.formKey, "xml", "", "", "");
    LoadingUtil.hide();
    if (uiCommands && uiCommands[0]) {
      await ErpDesignerUI.doUICommands(activeERPForm, uiCommands);
    } else {
      let entryFormKey = (activeERPForm.formKey === "DictEdit" || activeERPForm.formKey.endsWith("DictEdit")) && !activeERPForm.paras.map.ItemKey ? activeERPForm.paras.map.FormKey : activeERPForm.paras.map.ItemKey;
      LoadingUtil.show();
      let uiCommands2 = await ErpDesignerService.checkKeyLength(false, "", activeERPForm.formKey, entryFormKey);
      if (uiCommands2 && uiCommands2.length > 0) {
        await ErpDesignerUI.doUICommands(activeERPForm, uiCommands2);
        LoadingUtil.hide();
        return;
      }
      var formKey = activeERPForm.formKey, params = {
        cmd: "SaveFilesByFormKey",
        service: "DesignService",
        uiFormKey: formKey,
        entryParas: entryFormKey
      }, uiCommands1 = await new Request().getData(params);
      LoadingUtil.hide();
      processSaveUICommands(uiCommands1);
      var filePaths = ErpDesignerSrc.formDependXMLs.get(formKey);
      for (var i = 0, size = filePaths.length; i < size; i++) {
        if (typeof filePaths[i] == "object") {
          for (var j = 0, fsize = filePaths[i].length; j < fsize; j++) {
            var openedXml = ErpDesignerSrc.openedXmls.get(filePaths[i][j]);
            ErpDesignerSrc.hasEdited(openedXml) && await processOpenedXmlAfterSave(openedXml);
          }
        } else {
          var openedXml = ErpDesignerSrc.openedXmls.get(filePaths[i]);
          ErpDesignerSrc.hasEdited(openedXml) && await processOpenedXmlAfterSave(openedXml);
        }
      }
    }
  }
};
const isBMP = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.getActiveERPForm().formKey.toLowerCase() == "D_WebMap".toLowerCase()) {
    return false;
  } else {
    return true;
  }
};
const refreshNowFileTreeChildren = async function(evl, name, cxt, args) {
  await ErpDesignerUI.RefreshNowFileTreeChildren();
};
const deleteFile = async function(evl, name, cxt, args) {
  ConfirmDialog.show({
    title: "信息",
    message: "当前操作将会删除整个表单，是否确认删除",
    closeOnBackdropClick: false,
    buttons: [
      { text: "取消", handler: () => function() {
        return;
      }() },
      { text: "确认", color: "#4CAF50", handler: () => async function() {
        LoadingUtil.show();
        var filePath = args[0], params = {
          cmd: "DeleteXmlFile",
          service: "DesignService",
          filePath
        };
        let uiCommands = await new Request().getData(params);
        var activeForm = ErpDesignerUI.getActiveERPForm();
        await ErpDesignerUI.doUICommands(activeForm, uiCommands);
        LoadingUtil.hide();
      }() }
    ]
  });
};
const deleteXmlFile = async function(evl, name, cxt, args) {
  ConfirmDialog.show({
    title: "信息",
    message: "当前操作将会删除整个表单，是否确认删除",
    closeOnBackdropClick: false,
    buttons: [
      { text: "取消", handler: () => function() {
        return;
      }() },
      { text: "确认", color: "#4CAF50", handler: () => async function() {
        LoadingUtil.show();
        var openedXml = ErpDesigner.getActiveOpenedXml();
        var filePath = openedXml.filePath, params = {
          cmd: "DeleteXmlFile",
          service: "DesignService",
          filePath
        };
        let uiCommands = await new Request().getData(params);
        var activeForm = ErpDesignerUI.getActiveERPForm();
        await ErpDesignerUI.doUICommands(activeForm, uiCommands);
        LoadingUtil.hide();
      }() }
    ]
  });
};
const ReductionXml = async function(evl, name, cxt, args) {
  var params = {
    cmd: "ReductionXml",
    service: "DesignService",
    reduKey: args[0] + "@" + args[1]
  }, r = new Request(), uiCommands = await r.getData(params);
  var activeForm = ErpDesignerUI.getActiveERPForm();
  await ErpDesignerUI.doUICommands(activeForm, uiCommands);
  if (uiCommands[0].key === "ShowError") {
    ErpDesignerUI.showTip("数据丢失无法还原表单");
  } else {
    ErpDesignerUI.showTip("还原成功", "success");
  }
};
const ReductionXmlByTemp = async function(evl, name, cxt, args) {
  var params = {
    cmd: "ReductionSnapshotXml",
    service: "DesignService",
    uiFormKey: args[0],
    type: args[1],
    filePath: args[2],
    temFilePath: args[3]
  }, r = new Request(), uiCommands = await r.getData(params);
  var activeForm = ErpDesignerUI.getActiveERPForm();
  await ErpDesignerUI.doUICommands(activeForm, uiCommands);
  if (uiCommands[0].key === "ShowError") {
    ErpDesignerUI.showTip("数据丢失无法还原表单");
  } else {
    ErpDesignerUI.showTip("还原成功", "success");
  }
};
const UnMakeXmlFile = async function(e) {
  await ErpDesignerGlobal.UnMakeXmlFile();
};
const ReMakeXmlFile = async function(e) {
  await ErpDesignerGlobal.ReMakeXmlFile();
};
const ReVisible = async function(evl, name, cxt, args) {
  if (ErpDesignerUI.RedoCount == 0) {
    return false;
  } else {
    return true;
  }
};
const sourceOPVisible = async function(evl, name, cxt, args) {
  var activeERPForm = ErpDesignerUI.getActiveERPForm();
  if (!activeERPForm) {
    return false;
  }
  var formKey = activeERPForm.formKey;
  if (formKey !== "D_WebMap") {
    return false;
  } else {
    return true;
  }
};
const ShowDesignAndDebug = async function(evl, name, cxt, args) {
  let activeForm = ErpDesignerUI.getActiveERPForm();
  if (!activeForm) {
    return false;
  }
  if (activeForm.formKey == "D_WebMap") {
    ErpDesignerUI.ShowDesignAndDebug = false;
  } else {
    ErpDesignerUI.ShowDesignAndDebug = true;
  }
  return ErpDesignerUI.ShowDesignAndDebug;
};
const cancelXmlFile = async function(evl, name, cxt, args) {
  var isSourceActive = ErpDesignerUI.designPanel.getComponent("TabPanel1").getActiveTab() === "SourceTab";
  var activeForm = ErpDesignerUI.getActiveERPForm();
  let isShowData = ErpDesignerUI.preferences.getComponent("IsShowData").getValue() == "true" ? true : false;
  let formDocument;
  try {
    formDocument = DataUtil.toJSONDoc(activeForm.document);
  } catch (error) {
    formDocument = null;
  }
  if (isSourceActive) {
    var openedXml = ErpDesigner.getActiveOpenedXml();
    if (!ErpDesignerSrc.hasEdited(openedXml)) {
      return;
    }
    var xmlEditor = openedXml.xmlEditor, formKey = openedXml.formKey, filePath = openedXml.filePath, content = xmlEditor.doc.getValue(), params = {
      cmd: "CancelXmlFile",
      service: "DesignService",
      uiFormKey: formKey,
      filePath,
      content
    };
    if (isShowData) {
      params.formDocument = JSON.stringify(formDocument);
      params.documentFormKey = activeForm.getFormKey();
    }
    var r = new Request(), uiCommands = await r.getData(params);
    ErpDesignerUI.notIsCancel = false;
    activeForm = ErpDesignerUI.getActiveERPForm();
    await ErpDesignerUI.doUICommands(activeForm, uiCommands);
    $("li[key='Refresh']").unbind("click").click();
    ErpDesigner.hideSelectedBorder();
  } else {
    var activeERPForm = ErpDesignerUI.getActiveERPForm();
    var key2 = activeERPForm.formKey;
    var formDependXMLs = ErpDesignerSrc.formDependXMLs.get(key2);
    if (formDependXMLs) {
      for (let openedXmlsKey of formDependXMLs) {
        var openedXml = ErpDesignerSrc.openedXmls.get(openedXmlsKey);
        if (!openedXml || !ErpDesignerSrc.hasEdited(openedXml)) {
          continue;
        }
        var xmlEditor = openedXml.xmlEditor, formKey = openedXml.formKey, filePath = openedXml.filePath, content = xmlEditor.doc.getValue(), params = {
          cmd: "CancelXmlFile",
          service: "DesignService",
          uiFormKey: formKey,
          filePath,
          content
        };
        if (isShowData) {
          params.formDocument = JSON.stringify(formDocument);
          params.documentFormKey = activeForm.getFormKey();
        }
        var r = new Request(), uiCommands = await r.getData(params);
        ErpDesignerUI.notIsCancel = false;
        var activeForm = ErpDesignerUI.getActiveERPForm();
        await ErpDesignerUI.doUICommands(activeForm, uiCommands);
      }
    }
    $("li[key='Refresh']").unbind("click").click();
    ErpDesigner.hideSelectedBorder();
  }
};
const NewLine = async function() {
  var activeOpenedXml = ErpDesigner.getActiveOpenedXml();
  if (!activeOpenedXml) {
    return;
  }
  var xmlEditor = activeOpenedXml.xmlEditor;
  var option = xmlEditor.getOption("lineWrapping");
  xmlEditor.setOption("lineWrapping", !option);
};
const parseFormula = async function(evl, name, cxt, args) {
  var activeERPForm = ErpDesignerUI.getActiveERPForm();
  if (args && args[0] && args.length > 0) {
    let uiCommands = await ErpDesignerService.parseFormula(activeERPForm.formKey, "One", args[0]);
    await ErpDesignerUI.doUICommands(activeERPForm, uiCommands);
  } else {
    let uiCommands = await ErpDesignerService.parseFormula(activeERPForm.formKey, "all");
    await ErpDesignerUI.doUICommands(activeERPForm, uiCommands);
  }
};
const SaveBpm = async function(evl, name, cxt, args) {
  var value2 = cxt.form.getComponent("DesignerView").getValue();
  value2 = XmlEntity.parse(value2).getXml(false);
  var webMapPath = cxt.form.WebMapPath, uiCommands1 = await ErpDesignerService.saveFileContent(webMapPath, value2, "");
  if (!uiCommands1 || uiCommands1.name && uiCommands1.name.endsWith("Exception")) {
    return;
  }
  await ErpDesignerUI.doUICommands(ErpDesignerUI.getActiveERPForm(), uiCommands1);
};
const SavePrint = async function(evl, name, cxt, args) {
  var value2 = cxt.form.getComponent("DesignerView").getValue();
  value2 = XmlEntity.parse(value2).getXml(false);
  var webMapPath = cxt.form.WebMapPath, uiCommands1 = await ErpDesignerService.saveFileContent(webMapPath, value2, "");
  if (!uiCommands1 || uiCommands1.name && uiCommands1.name.endsWith("Exception")) {
    return;
  }
  await ErpDesignerUI.doUICommands(ErpDesignerUI.getActiveERPForm(), uiCommands1);
};
const SaveExcel = async function(evl, name, cxt, args) {
  var value2 = cxt.form.getComponent("DesignerView").getValue();
  value2 = XmlEntity.parse(value2).getXml(false);
  console.warn("当前保存Excel文件路径为：" + cxt.form.WebMapPath);
  var webMapPath = cxt.form.WebMapPath, uiCommands1 = await ErpDesignerService.saveFileContent(webMapPath, value2, "");
  if (!uiCommands1 || uiCommands1.name && uiCommands1.name.endsWith("Exception")) {
    return;
  }
  await ErpDesignerUI.doUICommands(ErpDesignerUI.getActiveERPForm(), uiCommands1);
};
const NewBpmVersion = async function(evl, name, cxt, args) {
  var webMapPath = cxt.form.WebMapPath, result = await ErpDesignerService.webBpmDesign(webMapPath, cxt.form.projectKey, cxt.form.WebMapFormKey, cxt.form.formCaption, "NewBpmVersion");
  if (!result) {
    ErpDesignerUI.showTip("新增版本失败");
    return false;
  }
  if (result) {
    var resultJson = JSON.parse(result);
    if (resultJson.code == 0) {
      ErpDesignerUI.showTip("新增版本成功", "success");
      var uiCommands = resultJson.uICommands;
      var activeForm = ErpDesignerUI.getActiveERPForm();
      await ErpDesignerUI.doUICommands(activeForm, uiCommands);
      $("div.dialog.show").remove();
      $(".modal.dialog-mask").hide();
      LoadingUtil.hide();
      args[0] = resultJson.filePath;
      ErpDesignerGlobal.saveWebFormCache(args[0], void 0, resultJson.formKey, args[0], "BPM_");
      return true;
    } else {
      ErpDesignerUI.showTip(resultJson.msg);
      LoadingUtil.hide();
      return false;
    }
  } else {
    ErpDesignerUI.showTip("新增版本失败");
    LoadingUtil.hide();
    return false;
  }
};
const DeployBpm = async function(evl, name, cxt, args) {
  var webMapPath = cxt.form.WebMapPath, uiCommands1 = await ErpDesignerService.webBpmDesign(webMapPath, cxt.form.projectKey, cxt.form.WebMapFormKey, cxt.form.formCaption, "DeployBpm");
  if (!uiCommands1 || uiCommands1.name && uiCommands1.name.endsWith("Exception")) {
    return;
  }
  await ErpDesignerUI.doUICommands(ErpDesignerUI.getActiveERPForm(), uiCommands1);
};
const DeleteBpm = async function(evl, name, cxt, args) {
  var webMapPath = cxt.form.WebMapPath;
  ConfirmDialog.show({
    title: "信息",
    message: "当前操作将会删除整个表单，是否确认删除",
    closeOnBackdropClick: false,
    buttons: [
      { text: "取消", handler: () => function() {
        return;
      }() },
      { text: "确认", color: "#4CAF50", handler: () => async function() {
        var params = {
          cmd: "DeleteXmlFile",
          service: "DesignService",
          filePath: webMapPath
        }, r = new Request(), uiCommands = await r.getData(params);
        var activeForm = ErpDesignerUI.getActiveERPForm();
        await ErpDesignerUI.doUICommands(activeForm, uiCommands);
      }() }
    ]
  });
};
const initEditorFuncsData = async function(dataType, currentFormKey, cxt) {
  var params = {
    cmd: "ExpAutoComplete",
    service: "DesignService",
    dataType,
    currentFormKey
  };
  ErpDesignerUI.FormulaRequestNum++;
  var r = new Request();
  var data = await r.getData(params);
  localStorage.removeItem("isInitLoadingFuncList");
  if (!data) {
    console.log("请求后台函数提醒功能失败");
    return;
  }
  var rs = $.parseJSON(data);
  if (rs) {
    if (rs.errors) {
      ErpDesignerUI.showTip(rs.errors);
      return;
    }
    ErpDesignerFuns.updateFormulaDb(rs, "DesignerFormulaCache");
  }
};
const showRealModal = async function(evl, name, cxt, args) {
  var form2 = ErpDesignerUI.D_FileTree;
  form2.getCallParas().put("OwnerFormKey", ErpDesigner.selectedFormKey);
  $.when(ErpDesignerUI.showRealModal(form2, args[0])).done(function(newForm) {
    ErpDesignerUI.DesignDivForm = newForm;
    newForm.regEvent(FormEvent.CLOSE, function(opt) {
      ErpDesignerUI.DesignDivForm = null;
    });
  });
};
const ResetFormOperation = async function(evl, name, cxt, args) {
  await ErpDesigner.resetFormOperationStatus(cxt.form);
};
const DeleteDataObjectFormRow = async function(evl, name, cxt, args) {
  var form2 = cxt.form, com = cxt.grid, rowIndex = com.getFocusRowIndex();
  if (!form2) {
    return true;
  }
  var rowData = com.getRowDataAt(rowIndex);
  let columnKey = rowData.data[1].value;
  if (columnKey === "OID" || columnKey === "POID" || columnKey === "SOID" || columnKey === "VERID" || columnKey === "DVERID") {
    ErpDesignerUI.showTip("系统字段，不允许删除！", "warning");
    return false;
  }
  return true;
};
const ClickFileTree = async function(evl, name, cxt, args) {
  let title = args[0].replace(/\\/gm, "\\\\");
  let $cell = $(".DesignerFileTree .ui-ygrid-bdiv td[meta-key='Key'][title='" + title + "']").siblings("td[meta-key='Name']:visible").find("span.cell-tree-icon:visible");
  if ($cell.length < 1)
    return;
  let ts = cxt.grid.getEl().$table;
  let flag = $cell[0].getAttribute("class").indexOf("cell-collapse") != -1 ? true : false;
  let index = ts.getFocusRowIndex();
  setTimeout(async function() {
    let flag2 = $cell[0].getAttribute("class").indexOf("cell-collapse") != -1 ? true : false;
    if (flag !== flag2)
      return;
    let ts1 = cxt.grid.getEl().$table;
    if (index != ts1.getFocusRowIndex()) {
      return;
    }
    if (flag2) {
      await cxt.grid.showChildren(ts1.getFocusRowIndex());
    } else {
      await cxt.grid.hideChildren(ts1.getFocusRowIndex());
    }
    ts.doFrozen(true);
  }, 600);
};
const ClickNodeTree = async function(evl, name, cxt, args) {
  let grid = cxt.grid;
  grid.getEl().$table;
  grid.selectedFormKey;
  grid.selectedEntryParas;
  let activeForm = ErpDesignerUI.getActiveERPForm();
  activeForm.formKey;
  activeForm.entryParas;
};
const getActiveTab = function(evl, name, cxt, args) {
  let key2 = args[0], com = cxt.form.getComponent(key2);
  return com.getActiveTab();
};
const SetDesignMode = function(evl, name, cxt, args) {
  DesignModeSetting.isDesignMode = args[0];
};
const RefreshERPPropertyUI = async function(name, ctx, args) {
  ctx.form;
  return;
};
const designerNewSolution = async function(evl, name, cxt, args) {
  LoadingUtil.show();
  let params = {
    cmd: "NewSolution",
    service: "DesignService",
    key: args[0],
    caption: args[1],
    folderName: args[2]
  };
  let uiCommands = await new Request().getData(params);
  if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
    return;
  }
  await ErpDesignerUI.doUICommands(ErpDesignerUI.getActiveERPForm(), uiCommands);
  ErpDesignerUI.DesignDivForm.fireClose();
  LoadingUtil.hide();
};
const ImportSolutionDispose = async (evl, name, cxt, args) => {
  const form2 = cxt.form;
  let params = {
    cmd: "ImportSolution",
    service: "DesignService",
    newSolutionPath: args[0],
    isNew: args[1]
  };
  if (args.length > 2) {
    params.deleteSolutionPath = args[2];
  }
  const uiCommands = await new Request(form2).getData(params);
  await ErpDesignerUI.doUICommands(form2, uiCommands);
};
const convertGridDataToString = function(evl, name, cxt, args) {
  var strJson = [];
  var form2 = cxt.form;
  if (!form2)
    return JSON.stringify(str);
  for (let gridInfo of form2.getGridArray()) {
    var uiGrid = form2.getComponent(gridInfo.key);
    var rowCount = uiGrid.getRowCount();
    for (var row = 0; row < rowCount; row++) {
      var colCount = uiGrid.getColumnCount();
      var isSelect = uiGrid.getValueAt(row, 0);
      if (!isSelect)
        continue;
      var str = {};
      for (var col = 0; col < colCount; col++) {
        var column = uiGrid.getColumnAt(col);
        if (column.key == "IsSelect")
          continue;
        var cellValue = uiGrid.getValueAt(row, col);
        str[column.key] = cellValue;
      }
      strJson.push(str);
    }
  }
  return JSON.stringify(strJson);
};
const SetDesignPreferencesInfo = async function(evl, name, cxt, args) {
  let key2 = args[0];
  let value2 = args[1] == "true" ? true : false;
  if (key2 === "RenderType") {
    ErpDesignerUI.gridLayoutRenderType = value2;
    await ErpDesigner.reloadActiveForm();
  }
  if (key2 === "XmlWordWrap") {
    ErpDesignerUI.xmlWordWrap = value2;
  }
  if (key2 === "ShowError") {
    ErpDesignerUI.showError = value2;
  }
  if (key2 === "DelayedProcessScope") {
    ErpDesignerUI.delayedProcessScope = value2;
  }
  if (key2 === "ReloadOnlyComment") {
    ErpDesignerUI.reloadOnlyComment = value2;
  }
  if (key2 === "FileTreeRowClick") {
    ErpDesignerUI.fileTreeisDBClick = value2;
  }
};
const fileTreeisDBClick = async function(evl, name, cxt, args) {
  return ErpDesignerUI.fileTreeisDBClick;
};
const LoadFilesSearchData = async function(evl, name, cxt, args) {
  let form2 = cxt.form;
  let params = {
    cmd: "LoadFilesSearchData",
    service: "DesignService",
    searchText: args[1],
    isCaseSensitive: args[2],
    isWholeWord: args[3],
    isRegEx: args[4],
    fileTypes: args[5]
  };
  LoadingUtil.show();
  let grid = form2.getComponent(args[0].toString()), tableKey = grid.tableKey, doc = form2.getDocument();
  let oldTable = doc.getByKey(tableKey);
  oldTable.delAll();
  if (args[1].length > 0) {
    let parentKey = oldTable.parentKey, parentBkmk = -1;
    if (parentKey) {
      parentBkmk = doc.getByKey(parentKey).getBkmk();
    }
    let dataTable = await new Request().getData(params);
    DataUtil.append(dataTable, oldTable, parentBkmk);
    let ignoreKeys = [], metaCell;
    for (let i = 0, count = dataTable.getColumnCount(); i < count; i++) {
      metaCell = form2.getCellByDataBinding(tableKey, dataTable.getCol(i).getKey());
      if (metaCell) {
        ignoreKeys.push(metaCell.key);
      }
    }
    form2.setSysExpVals("IgnoreKeys", ignoreKeys);
  }
  form2.setCallPara("fRIndex", -1);
  await grid.load(true);
  LoadingUtil.hide();
  return grid.getHandler().dealWithSequence(form2, grid, 0);
};
const ShowSearchTreeOpt = async (evl, name, cxt, args) => {
  const gridKey = args[0];
  let form2 = cxt.form;
  let grid = form2.getComponent(gridKey);
  const beforeRIndex = grid.getFocusRowIndex();
  const afterRIndex = form2.getCallPara("fRIndex");
  form2.setCallPara("fRIndex", beforeRIndex);
  let $cell = grid.impl.el.$table.getCell(beforeRIndex, 7);
  $cell.$show();
  $cell = grid.impl.el.$table.getCell(beforeRIndex, 8);
  $cell.$show();
  if (afterRIndex >= 0) {
    $cell = grid.impl.el.$table.getCell(afterRIndex, 7);
    if ($cell) {
      $cell.$hide();
    }
    $cell = grid.impl.el.$table.getCell(afterRIndex, 8);
    if ($cell) {
      $cell.$hide();
    }
  }
};
const ReplaceFileSearchResult = async (evl, name, cxt, args) => {
  const gridKey = args[0];
  let form2 = cxt.form;
  let grid = form2.getComponent(gridKey);
  const focusRowIndex = grid.getFocusRowIndex();
  const rowData = grid.getRowDataAt(focusRowIndex);
  let filePath, matchArr = [], previewText, startColumn, endColumn;
  if (rowData.isLeaf) {
    filePath = rowData.data[1].value;
    previewText = rowData.data[2].value;
    startColumn = parseInt(rowData.data[5].value);
    endColumn = parseInt(rowData.data[6].value);
    matchArr.push({
      matchStr: previewText.substring(startColumn, endColumn),
      fOffset: rowData.data[12].value
    });
  } else {
    filePath = rowData.data[0].value;
    let childRows = rowData.childRows, childRowIndex, childRow;
    for (let i = childRows.length - 1; i >= 0; i--) {
      childRowIndex = grid.getAllRowIndexByID(childRows[i]);
      childRow = grid.getAllRowDataAt(childRowIndex);
      previewText = childRow.data[2].value;
      startColumn = parseInt(childRow.data[5].value);
      endColumn = parseInt(childRow.data[6].value);
      matchArr.push({
        matchStr: previewText.substring(startColumn, endColumn),
        fOffset: childRow.data[12].value
      });
    }
  }
  let params = {
    cmd: "ReplaceFileSearchResult",
    service: "DesignService",
    filePath,
    replaceStr: args[1],
    matchArr: JSON.stringify(matchArr)
  };
  LoadingUtil.show();
  await new Request().getData(params);
  LoadingUtil.hide();
};
const LoadSearchFiles = async (evl, name, cxt, args) => {
  let params = {
    cmd: "LoadSearchFilesContent",
    service: "DesignService"
  };
  LoadingUtil.show();
  let filesContent = await new Request().getData(params);
  for (var file of filesContent) {
    ErpDesigner.indexedDB.put("DesignerSearchFiles", file);
  }
  LoadingUtil.hide();
};
const ClearBindingFormCache = async function(evl, name, cxt, args) {
  const metaCache = new MetaCache();
  metaCache.clear();
};
const SetComponentGrid = async (evl, name, cxt, args) => {
  var form2 = cxt.form;
  var doc = DataUtil.toJSONDoc(form2.getDocument());
  var params = {
    cmd: "SetComponentGrid",
    service: "DesignService",
    metaFormKey: cxt.form.formKey,
    formDocument: JSON.stringify(doc),
    compositeComponentType: args[0],
    type: args[1]
  };
  let data = await new Request(cxt.form).getData(params);
  let dirtyDataTables = data.formDirtyDatas[0].dirtyData.dirtyDataTables;
  if (dirtyDataTables) {
    for (var i = 0; i < dirtyDataTables.length; i++) {
      var tableKey = dirtyDataTables[i].tableKey;
      var dataTable = dirtyDataTables[i].dataTable;
      dataTable = DataUtil.fromJSONDataTable(dataTable);
      var doc = form2.getDocument();
      doc.setByKey(tableKey, dataTable);
    }
    for (var i = 0; i < dirtyDataTables.length; i++) {
      var isGrid = dirtyDataTables[i].isGrid;
      if (!isGrid) {
        dirtyDataTables[i].oneTableFieldDirtyData;
      } else {
        var gridKey = dirtyDataTables[i].gridKey;
        var grid = form2.getComponent(gridKey);
        var doc = form2.getDocument();
        var tableKey = dirtyDataTables[i].tableKey;
        var dataTable = doc.getByKey(tableKey);
        dataTable.beforeFirst();
        grid.rootGroupBkmk = [];
        grid.pageInfo.currentPage = 1;
        await grid.load(true);
        grid.getHandler().dealWithSequence(form2, grid, 0);
      }
    }
  }
};
const hasTree = async (evl, name, cxt, args) => {
  let activeForm = ErpDesignerUI.getActiveERPForm();
  let comKey = args[0];
  let cellLocation = activeForm.getCellLocation(comKey);
  let gridKey = cellLocation.getKey();
  return activeForm.getComponent(gridKey).hasTree;
};
const expandFileTreeByOpenedXml = async function(evl, name, cxt, args) {
  let openXml = ErpDesigner.getActiveOpenedXml();
  if (!openXml) {
    return;
  }
  let filePath = openXml.filePath;
  let params = { cmd: "LoadParentPathsByPath", service: "DesignService", path: filePath };
  let parentPaths = await new Request().getData(params);
  let form2 = ErpDesignerUI.D_FileTree, grid = form2.getComponent("Grid1");
  await ErpDesignerSrc.doExpand(grid, parentPaths);
};
const expandFileTreeByActiveForm = async function(evl, name, cxt, args) {
  let form2 = ErpDesignerUI.getActiveERPForm(), formKey = form2.formKey, filePaths = await ErpDesigner.DesignerSourceCache.get(formKey);
  let filePath = filePaths[0].filePath;
  let params = { cmd: "LoadParentPathsByPath", service: "DesignService", path: filePath };
  let parentPaths = await new Request().getData(params);
  let fileTreeForm = ErpDesignerUI.D_FileTree, grid = fileTreeForm.getComponent("Grid1");
  await ErpDesignerSrc.doExpand(grid, parentPaths);
};
const SetXmlEditorFontSize = async function(evl, name, cxt, args) {
  let FontSize = args[0] == "inherit" ? args[0] : args[0] + "px";
  $('[id*="SourceTab"] [id*="XMLEditor"] .CodeMirror-sizer').css("font-size", FontSize);
  ErpDesignerGlobal.xmlEditorFontSize = FontSize;
};
const SetXmlEditorFont = async function(evl, name, cxt, args) {
  let Font = args[0];
  $('[id*="SourceTab"] [id*="XMLEditor"] .CodeMirror-sizer').css("font-family", Font);
  ErpDesignerGlobal.xmlEditorFont = Font;
};
const formulaFormatting = async function(evl, name, cxt, args) {
  var _a, _b;
  try {
    checkParamNum(name, args, 2);
    if (!args[0] || !args[0].match(/\s{8,}/)) {
      return args[0];
    }
    let targetContent = args[0].replace(/\n/g, "");
    let parentComponentKey = args[1];
    let comKey = (_b = (_a = cxt.form.getParentForm()) == null ? void 0 : _a.getComponent("Key")) == null ? void 0 : _b.value;
    if (!comKey) {
      return targetContent;
    }
    let dataObjectKey = cxt.form.getParentForm().dataObjectKey;
    let isCell = dataObjectKey === "D_GridFieldModule";
    let isCol = dataObjectKey === "D_GridHeadColumn";
    let filePaths = await ErpDesigner.DesignerSourceCache.get(ErpDesignerUI.getActiveERPForm().formKey);
    if (filePaths.length <= 0) {
      return targetContent;
    }
    let fileContent = await ErpDesignerService.loadFileContent(filePaths[0].filePath, true);
    let fileContentStr = fileContent.content;
    let fileContentStrArr = fileContentStr.split("\n");
    const regexStr = `\\bKey\\s*=\\s*"${comKey}"`;
    const regex = new RegExp(regexStr, "g");
    let matches;
    let startSpaceStr;
    let isCdata = true;
    for (let i = 0; i < fileContentStrArr.length; i++) {
      matches = fileContentStrArr[i].match(regex);
      if (matches) {
        if (isCell) {
          isCell = false;
          continue;
        }
        let match1 = fileContentStrArr[i].match(/^\s+/);
        startSpaceStr = match1 ? match1[0] : "";
        let escapeRegExp = targetContent.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        const regexStr1 = `\\b${parentComponentKey}\\s*=\\s*"${escapeRegExp}"`;
        const regex1 = new RegExp(regexStr1, "g");
        isCdata = !fileContentStrArr[i].match(regex1);
        break;
      }
    }
    if (startSpaceStr && startSpaceStr.length > 0) {
      startSpaceStr = isCdata ? startSpaceStr : startSpaceStr + " ";
      startSpaceStr = !isCdata && isCol ? startSpaceStr.substring(0, startSpaceStr.length - 8) : startSpaceStr;
      const regexStr2 = `${startSpaceStr}`;
      const regex2 = new RegExp(regexStr2, "g");
      targetContent = targetContent.replace(regex2, "\n");
    } else {
      return targetContent;
    }
    return targetContent;
  } catch (e) {
    return args[0];
  }
};
const isCheckBox = async function(evl, name, cxt, args) {
  let form2 = ErpDesignerUI.getActiveERPForm();
  let gridKey = ErpDesignerUI.parentKey;
  let grid = form2.getComponent(gridKey);
  if (!grid) {
    return "false";
  }
  let metaCell = grid.getMetaCellByColumnKey(args[0]);
  if (!metaCell) {
    if (grid.findIndex(args[0], false) && ControlType.CHECKBOX == grid.getColumnAt(grid.findIndex(args[0])).cellType) {
      return "true";
    }
    return "false";
  }
  if (ControlType.CHECKBOX == metaCell.cellType) {
    return "true";
  }
  return "false";
};
const RefreshDebugger = async function(evl, name, cxt, args) {
  setTimeout(function() {
    cxt.form.eval("Macro_LoadObject();", cxt).then(() => {
      cxt.form.eval("RefreshDebuggerToolbar();HighlightDebugger();", cxt);
    });
  }, 50);
};
const RefreshDebuggerToolbar = async function(evl, name, cxt, args) {
  setTimeout(function() {
    cxt.form.resetUIStatus(FormUIStatusMask.OPERATION);
  }, 10);
};
const HighlightDebugger = async function(evl, name, cxt, args) {
  setTimeout(() => {
    let $row = $("[meta-columnkey=Running][title=1]").parent("tr");
    $('[meta-key="BP_ScriptText"] span', $row).css("font-weight", "bold");
    $('[meta-key="STX_ScriptText"] span', $row).css("font-weight", "bold");
    $('[meta-key="STX_EvalResult"] span', $row).css("font-weight", "bold");
    $('[meta-key="STK_StackDesc"] span', $row).css("font-weight", "bold");
    let dataCellList = $('td[meta-cellkey="VRT_VariantValue"],td[meta-cellkey="STX_EvalResult"]');
    dataCellList.each(function() {
      let dataCell = $(this);
      dataCell.removeAttr("title");
      let dataDiv = dataCell.find("div.ygrid-cell");
      let dataLable = dataDiv.find(".cell--label");
      let data = dataLable.text();
      if (!data) {
        return;
      }
      if ($.trim(data) === "未执行" || $.trim(data) === "执行中" || $.trim(data) === "已执行") {
        return;
      }
      dataLable.remove();
      try {
        const tree = jsonview.create(data);
        jsonview.render(tree, dataDiv[0]);
      } catch (err) {
        console.error(err);
      }
    });
  }, 20);
};
const BPMNProcess = async function(evl, name, cxt, args) {
  var openedXml = ErpDesigner.getActiveOpenedXml();
  let filePath = openedXml.filePath;
  await new Request().getData({
    cmd: "BPMNProcess",
    isDesigner: args[0],
    filePath,
    service: "WebPluginService"
  });
};
const DesignerFun = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  AddNewBlock,
  AddNewPanelRow,
  AddNewTableRow,
  AddSelectComponent,
  BPMNProcess,
  ClearBindingFormCache,
  ClearDOSubDetail,
  ClickFileTree,
  ClickNodeTree,
  CloseFormKey,
  CloseWEBBPMForm,
  ComboBox,
  CommitCarouselSourceSetting,
  CommitChartDataSource,
  CommitColumnExpand,
  CommitComboBoxQueryDef,
  CommitDataMigration,
  CommitDataObject,
  CommitDataObjectCheckRule,
  CommitDataSourceCheckRule,
  CommitDictItemFilter,
  CommitDiff,
  CommitEditViewItemCollectionSetting,
  CommitExtOptCollection,
  CommitFieldProperty,
  CommitGridFilter,
  CommitIndicator,
  CommitMobileFieldProperty,
  CommitNewDataObject,
  CommitOperationToobar,
  CommitPriceLabelItemSetting,
  CommitPropertyDiff,
  CommitRefreshFooterSetting,
  CommitRefreshHeaderSetting,
  CommitRowActionCollection,
  CommitSelectSourceField,
  CommitSeparate,
  CommitSourceSetting,
  CommitTraceCollection,
  ControlInSubDetail,
  D_CarouselSourceSetting,
  D_ChartDataSource,
  D_ColumnExpand,
  D_ComboBoxQueryDef,
  D_ComboBoxSourceSetting,
  D_Dictfiltering,
  D_DropdownButton,
  D_EditViewItemCollection,
  D_EmbedVar,
  D_ExtOptCollection,
  D_Gridfiltering,
  D_IndicatorSetting,
  D_PriceLabelItemSetting,
  D_RefreshFooterSetting,
  D_RefreshHeaderSetting,
  D_RowActionCollection,
  D_TraceCollection,
  DeleteBpm,
  DeleteDataObjectFormRow,
  DeployBpm,
  DictViewColumn,
  DisplayCodeMirror,
  DisplayFormulaeditorCodeMirror,
  EntryDeleteDtl,
  FileTreeCanCollapse,
  FileTreeCanDelete,
  FileTreeCanRefresh,
  FormulaPopWinVisible,
  GetAllColumnsInTableRowData,
  GetCreatePath,
  GetCreateProject,
  GetCreateSolution,
  GetFileTreeVisible,
  GridTree,
  HandlingGeneralConfiguration,
  HandlingLayout,
  HandlingMergeSingleFormDiff,
  HighlightDebugger,
  ImportSolutionDispose,
  InSubDetailSetBindingCell,
  InsertEmbed,
  LoadAllFieldsInSourceForm,
  LoadAreaDesigner,
  LoadD_EmbedVar,
  LoadD_Layout,
  LoadDataObject,
  LoadDesignerGridTreeOneLevel,
  LoadFieldsByParentKey,
  LoadFilesSearchData,
  LoadParaGroupDetail,
  LoadSearchFiles,
  Macro,
  NewBpmVersion,
  NewCollection,
  NewColumn,
  NewCompByKey,
  NewComponentKey,
  NewComponentKeyExtend,
  NewCompositeComponent,
  NewDataMapXML,
  NewDataMigration,
  NewDataObject,
  NewDomainORDataElement,
  NewDtl,
  NewDtl1,
  NewDtl2,
  NewEmbedKey,
  NewEntryDialog,
  NewEntryItemDialog,
  NewExcelDialog,
  NewGridColumn,
  NewGridColumnExtend,
  NewGridColumnToCompositeCom,
  NewGridFiled,
  NewLine,
  NewListView,
  NewListViewCol,
  NewPanelExtend,
  NewPanelKey,
  NewPrintDialog,
  NewRow,
  NewSonGridColumn,
  NewTable,
  OpenChase,
  OpenChase1,
  OpenConditionForm,
  OpenDataMap,
  OpenDataMigration,
  OpenFileLocation,
  OpenMobileConditionForm,
  OperationVisibility,
  PathOrCaption,
  ReMakeXmlFile,
  ReMigrates,
  ReVisible,
  ReductionXml,
  ReductionXmlByTemp,
  RefreshDebugger,
  RefreshDebuggerToolbar,
  RefreshDesignToolbar,
  RefreshERPPropertyUI,
  RefreshParentToolbar,
  Relocate,
  ReplaceFileSearchResult,
  ResetFormOperation,
  SaveBpm,
  SaveExcel,
  SavePrint,
  SetComponentGrid,
  SetDesignMode,
  SetDesignPreferencesInfo,
  SetXmlEditorFont,
  SetXmlEditorFontSize,
  ShowDesignAndDebug,
  ShowProperty,
  ShowSearchTreeOpt,
  SourceDataObjectEnable,
  ToolBar,
  UICheckRuleCollection,
  UnMakeXmlFile,
  UploadBkImage,
  addDataObject,
  afterSetFunctionTable,
  beautifyXmlSource,
  cancelXmlFile,
  checkAllSpec,
  checkColumn,
  commitComboBOxForm,
  commitDataMap,
  commitDictViewColumn,
  commitDropdownButtonForm,
  commitExcel,
  commitGridRowTree,
  commitLineChange,
  commitMacro,
  commitPrint,
  commitUICheckRule,
  confirmDialog,
  convertGridDataToString,
  deleteFile,
  deletePanelRow,
  deleteXmlFile,
  designerCopyForm,
  designerEntryByDelete,
  designerEntryByUpdate,
  designerNew,
  designerNewEntry,
  designerNewEntryItem,
  designerNewExpandForm,
  designerNewExtensionForm,
  designerNewForm,
  designerNewSolution,
  designerNewToolBar,
  designerNewWorkFlow,
  designerReviseProject,
  designerRun,
  designerShowNew,
  designerShowNewDataElementDialog,
  designerShowNewDomainDialog,
  designerShowNewFormDialog,
  designerShowNewProjectDialog,
  designerShowNewWorkFlowDialog,
  expandFileTreeByActiveForm,
  expandFileTreeByOpenedXml,
  extendvisible,
  fileTreeisDBClick,
  formulaFormatting,
  getActiveFormOperationVisible,
  getActiveTab,
  getActiveXMLOperationVisible,
  getActiveXMLPath,
  getColAllValue,
  getFormKey,
  getFormulaFormVisible,
  getPopupWinEditorEnable,
  hasTree,
  initEditorFuncsData,
  isAdd,
  isBMP,
  isCheckBox,
  isImportSolution,
  isNotInJar,
  isOpenActiveXml,
  linkWithActiveForm,
  loadD_Separate,
  loadFormulaDataSource,
  loadFormulaEditor,
  parseFormula,
  popColorPicker,
  refreshCodeMirror,
  refreshNowFileTreeChildren,
  refreshXMLSource,
  saveFileContent,
  setAssociationKey,
  setDataObjectSource,
  setDesignAction,
  setDesignCodeMirrorEditor,
  setEditorValue,
  setReportHeight,
  setReportWidth,
  setSourceDataObject,
  showRealModal,
  showSelectedComponentInSource,
  showSource,
  sourceOPVisible
}, Symbol.toStringTag, { value: "Module" }));
const _ErpDesignerGlobal = class _ErpDesignerGlobal2 {
  static searchComponent(value2, form2) {
    if (value2) {
      value2 = value2.replace(/\s/g, "");
      let $node = ErpDesigner.getComponent(form2);
      ErpDesigner.selectedComponentKey = value2;
      ErpDesigner.selectComponentKey = value2;
      let component = form2.getComponent(value2);
      if (component) {
        ErpDesignerUI.openActiveTab(component);
      } else {
        let loc = form2.getCellLocation(value2);
        if (loc) {
          let gridKey = loc.key, grid = form2.getComponent(gridKey);
          ErpDesignerUI.openActiveTab(grid);
        }
      }
      ErpDesigner.selectedType = "Filed";
      $node = ErpDesigner.getComponent(form2);
      if (!$node[0]) {
        ErpDesigner.selectedType = "cell";
        $node = ErpDesigner.getComponent(form2);
      }
      if (!$node[0]) {
        ErpDesigner.selectedType = "GridField";
        $node = ErpDesigner.getComponent(form2);
      }
      if (!$node[0]) {
        ErpDesigner.selectedType = "columnheader";
        $node = ErpDesigner.getComponent(form2);
      }
      if ($node && $node[0]) {
        $node[0].click();
        if (ErpDesigner.selectedType === "cell") {
          $(".ui-ygrid-bdiv").animate({ scrollLeft: $node[0].offsetLeft }, "slow");
        }
        setTimeout(async function() {
          await ErpDesignerUI.locate();
          ErpDesigner.addSelectedBorder($node);
        }, 600);
      } else {
        ErpDesignerUI.showTip("未找到该ID对应的组件,请确认后输入");
      }
    }
  }
  static clickInit(activeForm, $closestComponent) {
    if (Request.mode == 2) {
      window.FormDesignContainer.clickInit(activeForm, $closestComponent);
      return;
    }
    _ErpDesignerGlobal2.$from.find("#compositeComponentInsert").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, false, "D_NewCompositeComponent", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#compositeComInsertToGrid").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, false, "D_NewCompositeComToGrid", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#buttonInsert").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, false, "D_NewComponent", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#buttonQuote").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, false, "D_ButtonQuote", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#buttonPanQuote").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, false, "D_QuotePanel", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#buttonInsertBefore").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, false, "D_NewCompModal", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#buttonInsertAfter").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, true, "D_NewCompModal", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#buttonInsertBefore1").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, false, "D_NewListViewModel", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#buttonInsertAfter1").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, true, "D_NewListViewModel", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#buttonSonRow").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, true, "D_NewSonComp", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#buttonNewRow").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, true, "D_NewRow", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#buttonaddPanelRow").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, true, "D_AddNewRow", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#buttonaddTableRow").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, true, "D_AddTableViewRow", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#buttonOperation").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, true, "D_Collection", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#insertEmbed").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, true, "D_InsertEmbed", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#buttonDeleteTableRow").off("click").click(async (e) => {
      let activeForm2 = ErpDesignerUI.getActiveERPForm(), formDocument = activeForm2.document;
      let diff = new Diff();
      diff.formKey = ErpDesigner.selectedFormKey;
      diff.key = ErpDesigner.selectedComponentKey;
      diff.metaObjectType = "DeleteTableViewRow";
      diff.parentKey = ErpDesignerUI.ownerDetail;
      diff.isDelete = true;
      let successFlag = await ErpDesignerService.commitDiff(ErpDesigner.selectedFormKey, [diff], "", formDocument, activeForm2.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
      _ErpDesignerGlobal2.$from.find("li[key='Refresh']").off("click").click();
      ErpDesigner.hideSelectedBorder();
      ErpDesignerUI.parentKey = null;
      ErpDesignerUI.MetaObjectType = null;
    });
    _ErpDesignerGlobal2.$from.find("#buttonDelete").off("click").click(async (e) => {
      var _a;
      if (!ErpDesignerUI.parentKey && ErpDesigner.selectedType != "Block") {
        ErpDesignerUI.showTip("提示:" + ErpDesigner.selectedComponentKey + " 为根面板不允许删除");
        return false;
      }
      let tmp = ErpDesigner.getClosestComponent(activeForm, $closestComponent.parent());
      let form2 = ErpDesignerUI.getActiveERPForm();
      let diff = new Diff();
      diff.formKey = ErpDesigner.selectedFormKey;
      if (ErpDesigner.selectedComponentKey && ErpDesigner.selectedComponentKey.startsWith("Column:")) {
        diff.key = ErpDesigner.selectedComponentKey.substr(7);
      } else {
        diff.key = ErpDesigner.selectedComponentKey;
      }
      let PF = ErpDesignerUI.propertyForm;
      if (!PF) {
        ErpDesignerUI.showTip("一些属性未加载,需要切换一下设计界面才能删除", "warning");
        return false;
      }
      let dataobjectkey = PF.dataObjectKey;
      let ISGrid = dataobjectkey.indexOf("Grid") != -1 && !(dataobjectkey == "D_GridHeadColumn");
      let IsPanel = dataobjectkey.indexOf("Panel") != -1;
      let IsField = dataobjectkey.indexOf("Field") != -1;
      let IsGridField = dataobjectkey.indexOf("GridField") != -1;
      let IsOperation = dataobjectkey.indexOf("Operation") != -1;
      let IsListView = dataobjectkey.indexOf("ListView") != -1;
      let IsListViewColumn = dataobjectkey.indexOf("ListViewColumn") != -1;
      if (IsListViewColumn) {
        IsListView = false;
      }
      let IsOperationCollection = dataobjectkey.indexOf("OperationCollection") != -1;
      if (IsPanel || IsListView) {
        diff.metaObjectType = "Panel";
      } else if (IsOperation && dataobjectkey.toLowerCase() == "Operation".toLowerCase()) {
        diff.metaObjectType = "Operation";
      } else if (IsOperationCollection) {
        diff.metaObjectType = "OperationCollection";
      } else if (IsGridField) {
        diff.metaObjectType = "GridField";
      } else if (ISGrid) {
        diff.metaObjectType = "Grid";
      } else if (IsField) {
        diff.metaObjectType = "Field";
      } else if (IsListViewColumn) {
        diff.metaObjectType = "ListViewColumn";
      } else {
        diff.metaObjectType = ErpDesigner.selectedType === "columnheader" || ErpDesigner.selectedType === "cell" ? "GridField" : ErpDesigner.selectedType;
      }
      if (IsPanel) {
        let parentCom = activeForm.getComponent(ErpDesignerUI.parentKey);
        if (parentCom && parentCom.type == ControlType.SLIDINGLAYOUTPANEL) {
          if (parentCom.firstPanel == null && parentCom.secondPanel == null && parentCom.mainPanel.key == diff.key) {
            ErpDesignerUI.showTip("侧滑面板的根面板不允许删除", "warning");
            return false;
          }
        } else {
          let blocks = activeForm.metaForm.body.items;
          for (let i = 0; i < blocks.length; i++) {
            if (blocks[i].key == ErpDesignerUI.parentKey) {
              ErpDesignerUI.showTip("层级(" + ErpDesignerUI.parentKey + ")的根面板不允许删除", "warning");
              return false;
            }
          }
        }
      }
      if (ErpDesigner.selectedType == "TabItem") {
        diff.metaObjectType = "TabItem";
        diff.key = ErpDesigner.selectComponentKey;
      } else if (ErpDesigner.selectedType == "EditViewColumn") {
        diff.metaObjectType = "EditViewColumn";
        diff.key = (_a = ErpDesigner.selectComponentKey) == null ? void 0 : _a.split("@")[1];
      } else if (ErpDesigner.selectedType == "Block") {
        diff.metaObjectType = "Block";
        diff.key = ErpDesigner.selectComponentKey;
      } else if (ErpDesigner.selectedType == "EditViewChildGridLayout" || ErpDesigner.selectedType == "EditViewChildLinearLayout" || ErpDesigner.selectedType == "EditViewChildFlexFlowLayout" || ErpDesigner.selectedType == "EditViewChildColumnLayout" || ErpDesigner.selectedType == "EditViewChildSplitLayout" || ErpDesigner.selectedType == "EditViewChildTabLayout" || ErpDesigner.selectedType == "EditViewChildFlowLayout" || ErpDesigner.selectedType == "EditViewChildFlexGridLayout" || ErpDesigner.selectedType == "EditViewChildLayout") {
        diff.metaObjectType = "EditViewChildLayout";
        diff.key = ErpDesigner.selectComponentKey;
      }
      diff.parentKey = ErpDesignerUI.parentKey;
      if (ErpDesignerUI.parentKey == void 0 && tmp && tmp[0]) {
        diff.parentKey = ErpDesigner.getComponentKey(activeForm, tmp).key;
      }
      diff.isDelete = true;
      LoadingUtil.show();
      let successFlag = await ErpDesignerService.commitDiff(ErpDesigner.selectedFormKey, [diff], "", form2.document, activeForm.paras.map.FormKey);
      LoadingUtil.hide();
      if (!successFlag) {
        return;
      }
      if (diff.metaObjectType && diff.metaObjectType.toLowerCase() == "toolbar".toLowerCase()) {
        ErpDesignerUI.getActiveERPForm().defaultToolBar = void 0;
      }
      ErpDesignerUI.parentKey = null;
      ErpDesignerUI.MetaObjectType = null;
    });
    _ErpDesignerGlobal2.$from.find("#buttonMultyDelete").off("click").click(async () => {
      let diffs;
      diffs = [];
      let form2 = ErpDesignerUI.getActiveERPForm();
      _ErpDesignerGlobal2.multySelectCom.forEach(
        function($closestComponent2) {
          let tmp = ErpDesigner.getClosestComponent(activeForm, $closestComponent2.parent());
          let componentKey = ErpDesigner.getComponentKey(activeForm, $closestComponent2);
          let diff = new Diff();
          diff.formKey = ErpDesigner.selectedFormKey;
          if (componentKey && componentKey.key.startsWith("Column:")) {
            diff.key = componentKey.key.substr(7);
          } else {
            diff.key = componentKey.key;
            ErpDesigner.selectedType = componentKey.type;
          }
          diff.parentKey = ErpDesignerUI.parentKey;
          let PF = ErpDesignerUI.propertyForm;
          if (!PF) {
            ErpDesignerUI.showTip("一些属性未加载,需要切换一下设计界面才能删除", "warning");
            return false;
          }
          let dataobjectkey = PF.dataObjectKey;
          let ISGrid = dataobjectkey.indexOf("Grid") != -1 && !(dataobjectkey == "D_GridHeadColumn");
          let IsPanel = dataobjectkey.indexOf("Panel") != -1;
          let IsField = dataobjectkey.indexOf("Field") != -1;
          let IsGridField = dataobjectkey.indexOf("GridField") != -1;
          let IsOperation = dataobjectkey.indexOf("Operation") != -1;
          let IsListView = dataobjectkey.indexOf("ListView") != -1;
          let IsListViewColumn = dataobjectkey.indexOf("ListViewColumn") != -1;
          let IsGridCell = dataobjectkey.indexOf("cell") != -1;
          if (IsListViewColumn) {
            IsListView = false;
          }
          let IsOperationCollection = dataobjectkey.indexOf("OperationCollection") != -1;
          if (IsPanel || IsListView) {
            diff.metaObjectType = "Panel";
          } else if (IsOperation && dataobjectkey.toLowerCase() == "Operation".toLowerCase()) {
            diff.metaObjectType = "Operation";
          } else if (IsOperationCollection) {
            diff.metaObjectType = "OperationCollection";
          } else if (IsGridCell) {
            diff.metaObjectType = "GridFieldRow";
          } else if (IsGridField) {
            diff.metaObjectType = "GridField";
          } else if (ISGrid) {
            diff.metaObjectType = "Grid";
          } else if (IsField) {
            diff.metaObjectType = "Field";
          } else if (IsListViewColumn) {
            diff.metaObjectType = "ListViewColumn";
          } else {
            diff.metaObjectType = ErpDesigner.selectedType === "columnheader" || ErpDesigner.selectedType === "cell" ? "GridField" : ErpDesigner.selectedType;
          }
          if (tmp && tmp[0]) {
            diff.parentKey = ErpDesigner.getComponentKey(activeForm, tmp).key;
          }
          diff.isDelete = true;
          diff.isMultyDelete = true;
          diffs.push(diff);
        }
      );
      LoadingUtil.show();
      let successFlag = await ErpDesignerService.commitDiff(ErpDesigner.selectedFormKey, diffs, "", form2.document, activeForm.paras.map.FormKey);
      LoadingUtil.hide();
      if (!successFlag) {
        return;
      }
      ErpDesignerHelper.clearMultySelect();
      ErpDesignerUI.parentKey = null;
      ErpDesignerUI.MetaObjectType = null;
    });
    _ErpDesignerGlobal2.$from.find("#buttonReplace").off("click").click(async function(e) {
      let tmp = ErpDesigner.getClosestComponent(activeForm, $closestComponent.parent());
      let form2 = ErpDesignerUI.getActiveERPForm();
      let diff = new Diff();
      diff.formKey = ErpDesigner.selectedFormKey;
      diff.key = ErpDesigner.selectedComponentKey;
      diff.metaObjectType = "buttonReplace";
      let component = form2.getComponent(diff.key);
      if (component && component.ownerCt && component.ownerCt.id === $(form2.getRoot().getEl().getElm()).attr("id")) {
        ErpDesignerUI.showTip("操作失败,上级为根面板,不能被替换", "warning");
        return;
      }
      if (!form2.getComponent(diff.key)) {
        ErpDesignerUI.showTip("操作失败,当前组件不支持,谢谢!", "warning");
        return;
      }
      diff.controlType = ErpDesignerUtil.getControlTypeStr(form2.getComponent(diff.key).type);
      diff.parentKey = ErpDesignerUI.parentKey;
      if (ErpDesignerUI.parentKey == void 0 && tmp && tmp[0]) {
        diff.parentKey = ErpDesigner.getComponentKey(activeForm, tmp).key;
      }
      let successFlag = await ErpDesignerService.commitDiff(diff.formKey, [diff], "", form2.document, activeForm.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
      ErpDesignerUI.parentKey = null;
      ErpDesignerUI.MetaObjectType = null;
    });
    _ErpDesignerGlobal2.$from.find("#addSelectComponent").off("click").click(function(e) {
      let activeForm2 = ErpDesignerUI.getActiveERPForm();
      activeForm2.getCallParas().put("OwnerFormKey", ErpDesigner.selectedFormKey);
      activeForm2.getCallParas().put("selectedComponentKey", ErpDesigner.selectedComponentKey);
      activeForm2.setPara("FormKey", ErpDesigner.selectedFormKey);
      activeForm2.setPara("GridKey", ErpDesigner.selectedComponentKey);
      $.when(ErpDesignerUI.showRealModal(activeForm2, "D_AddSelectComponent")).done(function(newForm) {
        ErpDesignerUI.DesignDivForm = newForm;
        newForm.regEvent(FormEvent.CLOSE, function() {
          ErpDesignerUI.DesignDivForm = null;
        });
      });
    });
    _ErpDesignerGlobal2.$from.find("#buttonDeleteRow").off("click").click(async function(e) {
      let activeForm2 = ErpDesignerUI.getActiveERPForm(), formDocument = activeForm2.document;
      let diff = new Diff();
      diff.formKey = ErpDesigner.selectedFormKey;
      diff.key = ErpDesigner.selectedComponentKey;
      diff.metaObjectType = "GridFieldRow";
      diff.parentKey = ErpDesignerUI.ownerDetail;
      diff.isDelete = true;
      let successFlag = await ErpDesignerService.commitDiff(ErpDesigner.selectedFormKey, [diff], "", formDocument, activeForm2.paras.map.FormKey);
      if (!successFlag) {
        return;
      }
      _ErpDesignerGlobal2.$from.find("li[key='Refresh']").off("click").click();
      ErpDesigner.hideSelectedBorder();
      ErpDesignerUI.parentKey = null;
      ErpDesignerUI.MetaObjectType = null;
    });
    _ErpDesignerGlobal2.$from.find("#buttonInsertBefore2").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, false, "D_NewComponent", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find("#buttonInsertAfter2").off("click").click((e) => {
      _ErpDesignerGlobal2.insertButton(e, activeForm, true, "D_NewComponent", $closestComponent);
    });
    _ErpDesignerGlobal2.$from.find(".handleAddClick").off("click").bind("click", function(e) {
      let activeForm2 = ErpDesignerUI.getActiveERPForm();
      activeForm2.getCallParas().put("OwnerFormKey", ErpDesigner.selectedFormKey);
      activeForm2.getCallParas().put("Design_CreateType", "Panel");
      $.when(ErpDesignerUI.showRealModal(activeForm2, "D_NewComponent")).done(function(newForm) {
        ErpDesignerUI.DesignDivForm = newForm;
        newForm.regEvent(FormEvent.CLOSE, function() {
          ErpDesignerUI.DesignDivForm = null;
        });
      });
    });
    _ErpDesignerGlobal2.$from.find("#buttonInsertTabItem").off("click").click(async (e) => {
      if (ErpDesigner.selectedType != "TabItem") {
        return;
      }
      let tmp = ErpDesigner.getClosestComponent(activeForm, $closestComponent.parent());
      let form2 = ErpDesignerUI.getActiveERPForm();
      let diff = new Diff();
      diff.formKey = ErpDesigner.selectedFormKey;
      diff.key = ErpDesigner.selectComponentKey;
      diff.metaObjectType = "TabItem";
      diff.parentKey = ErpDesignerUI.parentKey;
      diff.insertItemAfter = true;
      if (ErpDesignerUI.parentKey == void 0 && tmp && tmp[0]) {
        diff.parentKey = ErpDesigner.getComponentKey(activeForm, tmp).key;
      }
      LoadingUtil.show();
      await ErpDesignerService.commitDiff(ErpDesigner.selectedFormKey, [diff], "", form2.document, activeForm.paras.map.FormKey);
      LoadingUtil.hide();
    });
    _ErpDesignerGlobal2.$from.find("#buttonMoveTabItemAfter").off("click").click(async (e) => {
      if (ErpDesigner.selectedType != "TabItem") {
        return;
      }
      let tmp = ErpDesigner.getClosestComponent(activeForm, $closestComponent.parent());
      let form2 = ErpDesignerUI.getActiveERPForm();
      let diff = new Diff();
      diff.formKey = ErpDesigner.selectedFormKey;
      diff.key = ErpDesigner.selectComponentKey;
      diff.metaObjectType = "TabItem";
      diff.parentKey = ErpDesignerUI.parentKey;
      diff.moveItemAfter = true;
      if (ErpDesignerUI.parentKey == void 0 && tmp && tmp[0]) {
        diff.parentKey = ErpDesigner.getComponentKey(activeForm, tmp).key;
      }
      LoadingUtil.show();
      await ErpDesignerService.commitDiff(ErpDesigner.selectedFormKey, [diff], "", form2.document, activeForm.paras.map.FormKey);
      LoadingUtil.hide();
    });
    _ErpDesignerGlobal2.$from.find("#buttonMoveTabItemFront").off("click").click(async (e) => {
      if (ErpDesigner.selectedType != "TabItem") {
        return;
      }
      let tmp = ErpDesigner.getClosestComponent(activeForm, $closestComponent.parent());
      let form2 = ErpDesignerUI.getActiveERPForm();
      let diff = new Diff();
      diff.formKey = ErpDesigner.selectedFormKey;
      diff.key = ErpDesigner.selectComponentKey;
      diff.metaObjectType = "TabItem";
      diff.parentKey = ErpDesignerUI.parentKey;
      diff.moveItemFront = true;
      if (ErpDesignerUI.parentKey == void 0 && tmp && tmp[0]) {
        diff.parentKey = ErpDesigner.getComponentKey(activeForm, tmp).key;
      }
      LoadingUtil.show();
      await ErpDesignerService.commitDiff(ErpDesigner.selectedFormKey, [diff], "", form2.document, activeForm.paras.map.FormKey);
      LoadingUtil.hide();
    });
  }
  static insertButton(e, activeForm, insertAfter, openFormName, closestComponent) {
    LoadingUtil.show();
    ErpDesignerUI.insertAfter = insertAfter;
    activeForm.getCallParas().put("OwnerFormKey", activeForm.formKey);
    if ("D_NewCompModal".toLowerCase() == openFormName.toLowerCase() || "D_NormalVest_NewComponent".toLowerCase() == openFormName.toLowerCase() || "D_NewSonComp".toLowerCase() == openFormName.toLowerCase()) {
      if (ErpDesignerUI.parentKey != null) {
        activeForm.getCallParas().put("GridKey", ErpDesignerUI.parentKey);
      } else {
        activeForm.getCallParas().put("GridKey", ErpDesignerUI.ownerDetail);
      }
      activeForm.getCallParas().put("ParentCompKey", null);
    }
    if ("D_NewComponent".toLowerCase() == openFormName.toLowerCase()) {
      activeForm.getCallParas().put("Design_CreateType", "Component");
      if (ErpDesigner.selectedFormKey != null) {
        activeForm.getCallParas().put("ParentCompKey", ErpDesignerUI.parentKey);
      }
      if (activeForm.metaForm.extensionFormKey) {
        activeForm.getCallParas().put("ExtensionFormKey", activeForm.metaForm.extensionFormKey);
        activeForm.getCallParas().put("FormType", "Extension");
      }
    }
    if ("D_AddTableViewRow".toLowerCase() == openFormName.toLowerCase()) {
      activeForm.getCallParas().put("Design_CreateType", ErpDesigner.selectedType);
    }
    if ("D_ButtonQuote".toLowerCase() == openFormName.toLowerCase()) {
      if (activeForm.metaForm.extensionFormKey) {
        openFormName = "D_SelectSourceField";
        activeForm.getCallParas().put("Design_CreateType", "QuoteComponent");
        activeForm.getCallParas().put("FormKey", activeForm.metaForm.formKey);
        activeForm.getCallParas().put("ExtensionFormKey", activeForm.metaForm.extensionFormKey);
        if (ErpDesigner.selectedFormKey != null) {
          activeForm.getCallParas().put("ParentCompKey", ErpDesignerUI.parentKey);
        }
      }
    }
    $.when(ErpDesignerUI.showRealModal(activeForm, openFormName)).done(function(newForm) {
      var attrs = ErpDesignerUI.selectNode.attr("meta-type");
      if ("GridLayoutPanel" == attrs) {
        ErpDesignerUI.parentKey = ErpDesignerUI.selectNode.attr("meta-key");
      }
      ErpDesignerUI.DesignDivForm = newForm;
      newForm.regEvent(FormEvent.CLOSE, () => {
        ErpDesignerUI.DesignDivForm = null;
      });
      LoadingUtil.hide();
    });
  }
  static locationComponent(component) {
    let myCars = new Array();
    while (component != null) {
      myCars.push(component);
      component = component.ownerCt;
    }
    for (let i = myCars.length - 2; i >= 0; i--) {
      if (myCars[i].visible == false) {
        ErpDesignerUI.ishide = true;
      }
    }
    if (ErpDesignerUI.ishide) {
      for (let i = myCars.length - 2; i >= 0; i--) {
        let component1 = myCars[i];
        if (myCars[i].visible == false) {
          ErpDesignerUI.openActiveTab(component1);
          ErpDesignerUI.ishide = false;
        } else {
          ErpDesignerUI.openActiveTab(component1);
        }
      }
    } else {
      for (let i = myCars.length - 2; i >= 0; i--) {
        let component1 = myCars[i];
        ErpDesignerUI.openActiveTab(component1);
      }
    }
    return component;
  }
  static getColumnLocation(com, form2, componentKey) {
    if (form2.formAdapt.gridArray.length > 0) {
      for (let i in form2.formAdapt.gridArray) {
        let arrayElement = form2.formAdapt.gridArray[i];
        let comp = form2.formAdapt.getComp(arrayElement.key);
        if (!comp)
          return com;
        let orgMetaObj = comp.orgMetaObj;
        if (orgMetaObj && orgMetaObj.columns.length > 0) {
          com = this.find(com, orgMetaObj.columns, componentKey);
          if (com && com.metaGridColumnKey == componentKey) {
            return com;
          }
        }
      }
      return com;
    }
  }
  static find(com, columns, componentKey) {
    for (let j in columns) {
      if (columns[j] && columns[j].columns) {
        com = this.find(com, columns[j].columns, componentKey);
        if (com && com.metaGridColumnKey == componentKey) {
          return com;
        }
      }
      if (columns[j].metaGridColumnKey == componentKey) {
        com = columns[j];
        return com;
      }
    }
  }
  static async UnMakeXmlFile() {
    if (ErpDesignerUI.UndoCount) {
      let NowOpenForm = ErpDesignerUI.getActiveERPForm();
      let formKey = NowOpenForm.formKey;
      if (formKey == "D_WebMap") {
        formKey = NowOpenForm.WebMapFormKey;
      }
      let params = {
        cmd: "UnMakeXmlFile",
        service: "DesignService",
        uiFormKey: formKey
      }, r = new Request(), uiCommands = await r.getData(params);
      if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
        return;
      }
      await this.MakeXmlFile(uiCommands);
      setTimeout(function() {
        let designLabel1 = $(".RightDesignPanelContainer td[title^='" + formKey + " '][aria-describedby*='Grid1_column2']");
        if (designLabel1[0]) {
          designLabel1[0].dispatchEvent(new CustomEvent("mousedown", { detail: void 0, bubbles: true, cancelable: true }));
          designLabel1[0].dispatchEvent(new CustomEvent("mouseup", { detail: void 0, bubbles: true, cancelable: true }));
          designLabel1[0].click();
        }
      }, 600);
      ErpDesigner.hideSelectedBorder();
    } else {
      return;
    }
  }
  static async ReMakeXmlFile() {
    if (ErpDesignerUI.RedoCount == 0) {
      return;
    } else {
      let NowOpenForm = ErpDesignerUI.getActiveERPForm();
      let formKey = NowOpenForm.formKey;
      if (formKey == "D_WebMap") {
        formKey = NowOpenForm.WebMapFormKey;
      }
      let params = {
        cmd: "ReMakeXmlFile",
        service: "DesignService",
        uiFormKey: formKey
      }, r = new Request(), uiCommands = await r.getData(params);
      if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
        return;
      }
      await this.MakeXmlFile(uiCommands);
    }
  }
  static async MakeXmlFile(uiCommands) {
    try {
      let activeForm = ErpDesignerUI.getActiveERPForm();
      await ErpDesignerUI.doUICommands(activeForm, uiCommands);
    } catch (e) {
      return;
    }
  }
  static saveWebFormCache(dataMapPath, extend2, formKey, caption, type) {
    sessionStorage.removeItem("WebMapPath");
    sessionStorage.removeItem("WebMapFormKey");
    sessionStorage.removeItem("WebMapCaption");
    sessionStorage.removeItem("WebMapType");
    sessionStorage.setItem("WebMapPath", dataMapPath);
    sessionStorage.setItem("WebMapFormKey", formKey);
    sessionStorage.setItem("WebMapCaption", caption);
    sessionStorage.setItem("WebMapType", type);
    ErpDesignerUI.backstagePath = dataMapPath;
  }
  static async openDataMap(BEopenxmlkey, filePath) {
    let fileName = BEopenxmlkey;
    let params = {
      cmd: "WebDataMapDesign",
      service: "DesignService",
      filePath,
      projectKey: "",
      sourceFormKey: "",
      targetFormKey: "",
      key: "",
      caption: "",
      type: 2
    };
    let r = new Request();
    let result = await r.getData(params);
    if (result) {
      sessionStorage.removeItem("FormTypeMap_" + fileName);
      let resultJson = JSON.parse(result);
      let jsonFileContent = resultJson.jsonFileContent;
      let extend2 = jsonFileContent.extend;
      let caption = jsonFileContent.Caption;
      let linkDataMapCaption = resultJson.linkDataMapCaption;
      let linkDataMapPath = resultJson.linkDataMapPath;
      let sourceForm = resultJson.sourceForm;
      let targetForm = resultJson.targetForm;
      sessionStorage.removeItem("extend");
      if (extend2) {
        sessionStorage.setItem("extend", extend2);
      }
      let sourceCation = resultJson.sourceCaption;
      let targetCaption = resultJson.targetCaption;
      let data = {
        sourceCation,
        targetCaption,
        sourceForm,
        targetForm,
        extend: extend2
      };
      sessionStorage.removeItem("FormTypeMap_" + fileName);
      sessionStorage.setItem("FormTypeMap_" + fileName, "DataMap");
      sessionStorage.setItem("data" + fileName, JSON.stringify(data));
      sessionStorage.removeItem("Map_" + fileName);
      sessionStorage.setItem("Map_" + fileName, JSON.stringify(jsonFileContent));
      sessionStorage.removeItem("Map_" + fileName + "_filePath");
      sessionStorage.setItem("Map_" + fileName + "_filePath", filePath);
      let curPath = [window.location.protocol, "//", window.location.host, "/", ServletURL].join("");
      ErpDesignerUI.path = curPath + "project/bpm/html/map.html?fileName=" + fileName + "&Caption=" + caption;
      ErpDesignerUI.caption = caption;
      if (extend2) {
        ErpDesignerUI.linkInfo.set(filePath + "_Key", extend2);
        ErpDesignerUI.linkInfo.set(filePath + "_Path", linkDataMapPath);
        ErpDesignerUI.linkInfo.set(filePath + "_Caption", linkDataMapCaption);
        ErpDesignerUI.linkInfo.set(ErpDesignerUI.path, filePath);
      }
      this.saveWebFormCache(filePath, extend2, fileName, filePath, "Map_");
    } else {
      ErpDesignerUI.showTip("打开数据映射失败");
    }
  }
  static async openLinkDataMap(dataMapPath) {
    ErpDesignerUI.activeERPFormKey = ErpDesignerUI.linkInfo.get(dataMapPath + "_Key");
    await this.openDataMap(ErpDesignerUI.linkInfo.get(dataMapPath + "_Key"), ErpDesignerUI.linkInfo.get(dataMapPath + "_Path"));
    await ErpDesignerUI.RunForm("D_WebMap", false);
  }
  /**
  * 打开关联数据映射(ts版)
  * @returns {(function(): void)|*}
  */
  static async tsOpenLinkDataMap(dataMapPath) {
    ErpDesignerUI.activeERPFormKey = ErpDesignerUI.linkInfo.get(dataMapPath + "_Key");
    await this.openDataMap(ErpDesignerUI.linkInfo.get(dataMapPath + "_Key"), ErpDesignerUI.linkInfo.get(dataMapPath + "_Path"));
    await ErpDesignerUI.RunForm("WEBDATAMAP", false);
  }
  static async getfunsList(funcList) {
    let requests = [];
    let activeERPForm = ErpDesignerUI.getActiveERPForm();
    let hasGetData = await ErpDesignerUtil.getDesignerTableCacheByTableName("DesignerFormulaCache")().get("hasGetData");
    if (hasGetData) {
      return;
    }
    let requestMacro = new Promise(function(resolve) {
      resolve(initEditorFuncsData("macro", activeERPForm.formKey));
    });
    requests.push(requestMacro);
    if ((!funcList || funcList.length == 0) && !localStorage.getItem("isInitLoadingFuncList")) {
      localStorage.setItem("isInitLoadingFuncList", "true");
      let requestFunction = new Promise(function(resolve) {
        resolve(initEditorFuncsData("function", ""));
      });
      requests.push(requestFunction);
      Promise.all(requests).then(function(res) {
        console.log(res);
      }).catch(function(err) {
        console.log(err);
      });
    } else {
      if (funcList && funcList.length > 0) {
        Promise.all(requests).then(function(res) {
          console.log(res);
        }).catch(function(err) {
          console.log(err);
        });
      }
    }
  }
  static async pasteComponent(params) {
    var r = new Request();
    return await r.getData({ ...params, cmd: "PasteComponent", service: "DesignService" });
  }
};
_ErpDesignerGlobal.ttalId = 0;
_ErpDesignerGlobal.cache = new MetaCache();
_ErpDesignerGlobal.doccache = new IndexedDBCache$1("DocCache");
_ErpDesignerGlobal.xmlEditorFont = "inherit";
_ErpDesignerGlobal.initCacheID = 0;
_ErpDesignerGlobal.xmlEditorFontSize = "inherit";
(() => {
  let $form = document.getElementById("form");
  $form && $form.addEventListener("mouseup", function(e) {
    $(e.target);
  });
  let clipboardable = true;
  document.addEventListener("mouseover", function(e) {
    try {
      clipboardable = $(e.target).parents("div.designingForm").length > 0;
      if ($(e.target).parents("[formkey='MobileFormDesigner']").length > 0) {
        clipboardable = false;
      }
    } catch (e2) {
      console.warn("jquery资源或未加载完成！");
    }
  });
  setTimeout(function() {
    let $reche = void 0;
    let $formhead = document.getElementsByClassName("ui-tabs-header")[0];
    $formhead && $formhead.addEventListener("dblclick", function(e) {
      $reche = $(e.target);
      if ($reche.context.className.indexOf("ui-anchor-label") != -1) {
        setTimeout(async function() {
          if (DesignModeSetting.isDesignMode) {
            let form2 = ErpDesignerUI.getActiveERPForm();
            if (form2.paras && form2.paras.map && form2.paras.map.FormKey) {
              await ErpDesignerUI.RunForm(form2.paras.map.FormKey, false);
            } else {
              await ErpDesignerUI.reloadForm(form2);
            }
          }
        }, 1);
      }
    });
  }, 10);
  window.addEventListener("resize", () => {
    if (ErpDesignerUI.split) {
      ErpDesignerUtil.layoutDesignDock();
    }
    if (ErpDesignerUI.D_SourceFileTreeTabs) {
      let body = $(document.body);
      ErpDesignerUI.D_SourceFileTreeTabs.doLayout(body.width(), body.height());
    }
  });
  document.addEventListener("keydown", async (e) => {
    var _a;
    if (e.ctrlKey && e.shiftKey && e.keyCode == 65)
      ;
    if (ErpDesignerUI.webdesignerEnable === null) {
      return;
    } else if (e.ctrlKey && e.shiftKey && e.keyCode == 90) {
      if (!DesignModeSetting.isDesignMode || !ErpDesignerUI.getActiveERPForm()) {
        return;
      }
      let formKey = ErpDesignerUI.getActiveERPForm().formKey;
      if (formKey === "D_WebMap" || ErpDesignerUI.DesignAction == null || ErpDesignerUI.DesignAction == "DesignTab") {
        await _ErpDesignerGlobal.ReMakeXmlFile();
      } else {
        return;
      }
    } else if (e.ctrlKey && e.keyCode == 90) {
      if (!DesignModeSetting.isDesignMode || !ErpDesignerUI.getActiveERPForm()) {
        return;
      }
      let formKey = ErpDesignerUI.getActiveERPForm().formKey;
      if (formKey === "D_WebMap" || ErpDesignerUI.DesignAction == null || ErpDesignerUI.DesignAction == "DesignTab")
        ;
      else {
        return;
      }
    }
    if (DesignModeSetting.isDesignMode && e.ctrlKey) {
      let form2 = ErpDesignerUI.getActiveERPForm();
      if (!form2) {
        return;
      }
      if (e.keyCode == 67) {
        let selectedComponentKey = ErpDesigner.selectedComponentKey;
        if (!clipboardable || !selectedComponentKey) {
          return;
        }
        let componentKey = selectedComponentKey, component = form2.getComponent(componentKey);
        if (ErpDesigner.selectedType === "columnheader") {
          componentKey = selectedComponentKey.substr(7);
          component = form2.getCellLocation(componentKey);
        }
        if (!component || component.isPanel) {
          return;
        }
        _ErpDesignerGlobal.clipboard = {
          srcFormKey: form2.formKey,
          srcCompKey: selectedComponentKey
        };
        ErpDesignerUI.showTip("组件: " + componentKey + " 已复制到剪切板!", "success");
      }
      if (e.keyCode == 86) {
        let parentKey = ErpDesignerUI.parentKey;
        if (!clipboardable || !_ErpDesignerGlobal.clipboard || !parentKey) {
          return;
        }
        let parentComp = form2.getComponent(parentKey);
        let tagType = parentComp.tagName.toLowerCase();
        if (tagType === "gridlayoutpanel" || tagType === "columnlayoutpanel1") {
          let node = ErpDesignerUI.selectNode;
          if (!node.is("[col]")) {
            node = node.parent();
          }
          let x = node.attr("col");
          let y = node.parent().attr("row");
          let uiCommands = await _ErpDesignerGlobal.pasteComponent({ ..._ErpDesignerGlobal.clipboard, "formKey": form2.formKey, parentKey, x, y });
          if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
            return;
          }
          await ErpDesignerUI.doUICommands(form2, uiCommands);
        }
        if (tagType === "flexgridlayoutpanel" || ErpDesigner.selectedType === "columnheader" && _ErpDesignerGlobal.clipboard.srcCompKey.startsWith("Column:")) {
          let sideKey;
          if (ErpDesigner.selectedComponentKey !== parentKey) {
            sideKey = ErpDesigner.selectedComponentKey;
          }
          let uiCommands = await _ErpDesignerGlobal.pasteComponent({ ..._ErpDesignerGlobal.clipboard, "formKey": form2.formKey, parentKey, sideKey });
          if (!uiCommands || uiCommands.name && uiCommands.name.endsWith("Exception")) {
            return;
          }
          await ErpDesignerUI.doUICommands(form2, uiCommands);
        }
        (_a = window.FormDesignContainer) == null ? void 0 : _a.afterPaste();
      }
    }
  });
})();
let ErpDesignerGlobal = _ErpDesignerGlobal;
const DEFAULT_CONFIG = {
  maxWidth: 350,
  minWidth: 250,
  gap: 16,
  duration: 1e3,
  types: {
    success: {
      icon: "✓",
      color: "#4CAF50",
      backgroundColor: "#EDF7ED",
      textColor: "#1E4620"
    },
    error: {
      icon: "✕",
      color: "#F44336",
      backgroundColor: "#FDEDED",
      textColor: "#5F2120"
    },
    warning: {
      icon: "⚠",
      color: "#FF9800",
      backgroundColor: "#FFF4E5",
      textColor: "#663C00"
    },
    info: {
      icon: "ℹ",
      color: "#2196F3",
      backgroundColor: "#E5F6FD",
      textColor: "#014361"
    },
    custom: {
      icon: "",
      color: "#673AB7",
      backgroundColor: "#F3E5F5",
      textColor: "#3E2723"
    }
  }
};
class NotificationSystem {
  constructor() {
    this.config = JSON.parse(JSON.stringify(DEFAULT_CONFIG));
    this.timers = /* @__PURE__ */ new Map();
    this.createStyles();
    this.container = this.createContainer();
  }
  createStyles() {
    const style = document.createElement("style");
    style.textContent = `
      .notification-container {
        position: fixed;
        top: 6px;
        left: 50%;
        transform: translateX(-50%);
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: ${this.config.gap}px;
        z-index: 9999;
        width: 100%;
        pointer-events: none;
      }
      
      .notification {
        position: relative;
        padding: 16px 24px;
        border-radius: 12px;
        box-shadow: 0 6px 16px 0 rgba(0, 0, 0, 0.12);
        display: flex;
        align-items: center;
        opacity: 0;
        transform: translateY(-30px) scale(0.95);
        animation: notificationSlideIn 0.4s cubic-bezier(0.2, 0, 0, 1) forwards;
        max-width: ${this.config.maxWidth}px;
        min-width: ${this.config.minWidth}px;
        width: fit-content;
        pointer-events: auto;
        transition: all 0.3s ease;
        backdrop-filter: blur(10px);
      }
      
      .notification:hover {
        transform: translateY(0) scale(1.02);
        box-shadow: 0 8px 20px 0 rgba(0, 0, 0, 0.16);
      }
      
      @keyframes notificationSlideIn {
        0% { opacity: 0; transform: translateY(-30px) scale(0.95); }
        100% { opacity: 1; transform: translateY(0) scale(1); }
      }
      
      @keyframes notificationFadeOut {
        0% { opacity: 1; transform: translateY(0) scale(1); }
        100% { opacity: 0; transform: translateY(-20px) scale(0.98); }
      }
      
      .notification-icon {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 24px;
        height: 24px;
        margin-right: 16px;
        font-size: 16px;
        font-weight: bold;
        border-radius: 50%;
        flex-shrink: 0;
      }
      
      .notification-content {
        flex: 1;
        font-size: 14px;
        line-height: 1.5;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
      }
      
      .notification-close {
        position: absolute;
        top: 12px;
        right: 12px;
        width: 20px;
        height: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: transparent;
        border: none;
        border-radius: 50%;
        cursor: pointer;
        opacity: 0.6;
        padding: 0;
        transition: all 0.2s ease;
      }
      
      .notification-close:hover {
        opacity: 1;
        background: rgba(0, 0, 0, 0.08);
      }
      
      .notification-close::before {
        content: '×';
        font-size: 18px;
        line-height: 1;
      }
      
      .notification-progress {
        position: absolute;
        bottom: 0;
        left: 0;
        height: 3px;
        background: rgba(255, 255, 255, 0.3);
        border-radius: 0 0 0 12px;
        animation: progressBar ${this.config.duration}ms linear forwards;
      }
      
      @keyframes progressBar {
        0% { width: 100%; }
        100% { width: 0%; }
      }
      
      @media (max-width: 640px) {
        .notification-container {
          top: 16px;
          padding: 0 16px;
          box-sizing: border-box;
        }
        
        .notification {
          max-width: 100%;
          width: calc(100% - 32px);
          padding: 14px 20px;
        }
        
        .notification-icon {
          margin-right: 12px;
          width: 20px;
          height: 20px;
          font-size: 14px;
        }
      }
    `;
    document.head.appendChild(style);
  }
  createContainer() {
    const container = document.createElement("div");
    container.className = "notification-container";
    document.body.appendChild(container);
    return container;
  }
  show(type, message, options = {}) {
    const notification = document.createElement("div");
    notification.className = "notification";
    const baseConfig = type === "custom" ? { ...this.config.types.custom, ...options } : { ...this.config.types[type], ...options };
    notification.style.backgroundColor = baseConfig.backgroundColor || baseConfig.color + "15";
    notification.style.color = baseConfig.textColor || baseConfig.color;
    const progressBar = document.createElement("div");
    progressBar.className = "notification-progress";
    progressBar.style.backgroundColor = baseConfig.color;
    notification.innerHTML = `
      <div class="notification-icon" style="background-color: ${baseConfig.color}20; color: ${baseConfig.color}">
        ${baseConfig.icon}
      </div>
      <div class="notification-content">${message}</div>
      ${options.showClose !== false ? '<button class="notification-close" aria-label="关闭通知"></button>' : ""}
    `;
    notification.appendChild(progressBar);
    this.container.appendChild(notification);
    const duration = options.duration ?? this.config.duration;
    progressBar.style.animationDuration = `${duration}ms`;
    const timer = window.setTimeout(() => {
      this.closeNotification(notification);
    }, duration);
    this.timers.set(notification, timer);
    const closeBtn = notification.querySelector(".notification-close");
    if (closeBtn) {
      closeBtn.addEventListener("click", (e) => {
        e.stopPropagation();
        this.closeNotification(notification);
      });
    }
    notification.addEventListener("mouseenter", () => {
      this.clearTimer(notification);
      progressBar.style.animationPlayState = "paused";
    });
    notification.addEventListener("mouseleave", () => {
      const remainingTime = duration - this.getElapsedTime(progressBar) / duration * duration;
      progressBar.style.animation = `progressBar ${remainingTime}ms linear forwards`;
      const newTimer = window.setTimeout(() => {
        this.closeNotification(notification);
      }, remainingTime);
      this.timers.set(notification, newTimer);
    });
    notification.addEventListener("click", () => {
      this.closeNotification(notification);
    });
  }
  getElapsedTime(progressBar) {
    var _a;
    const style = getComputedStyle(progressBar);
    const animationDuration = parseFloat(style.animationDuration) * 1e3;
    const animationDelay = parseFloat(style.animationDelay) * 1e3;
    return animationDuration - (((_a = progressBar.getAnimations()[0]) == null ? void 0 : _a.currentTime) || 0) * 1e3 - animationDelay;
  }
  clearTimer(notification) {
    const timer = this.timers.get(notification);
    if (timer) {
      window.clearTimeout(timer);
      this.timers.delete(notification);
    }
  }
  closeNotification(notification) {
    this.clearTimer(notification);
    notification.style.animation = "notificationFadeOut 0.3s forwards";
    notification.addEventListener("animationend", () => {
      notification.remove();
    }, { once: true });
  }
}
const _ErpDesignerUI = class __ErpDesignerUI {
  constructor() {
    this.replaceXmlSource = async function(form2, uiCommand2) {
      var xmlPath = uiCommand2.content.xmlPath, activeOpenedXml = ErpDesigner.getActiveOpenedXml();
      if (xmlPath.indexOf("DataObject") != -1) {
        activeOpenedXml = ErpDesignerSrc.openedXmls.get(xmlPath);
      }
      if (!activeOpenedXml) {
        return;
      }
      var xmlEditor = activeOpenedXml.xmlEditor, find = uiCommand2.content.orgXmlFragment.replace(/\r\n/g, "\r"), searchCursor = xmlEditor.getSearchCursor(find, null, { caseFold: false });
      if (searchCursor.findNext()) {
        xmlEditor.doc.replaceRange(uiCommand2.content.newXmlFragment.replace(/\r\n/g, "\r"), searchCursor.pos.from, searchCursor.pos.to);
        await ErpDesigner.updateActiveXmlCaption(activeOpenedXml);
      } else {
        console.log("error");
      }
    };
  }
  static getActiveERPForm(targetId) {
    let formID = Tabs.getInstance().currentFormID;
    let form2 = FormStack.getForm(formID);
    let formList = {};
    if (!this.selectNode) {
      if (targetId) {
        formList = $.grep(FormStack.getFormList(), function(stackForm) {
          if (!stackForm)
            return false;
          if (formID !== stackForm.pFormID)
            return false;
          let $rootEl = stackForm.getRoot().getEl() ? $(stackForm.getRoot().getEl().getElm()) : null;
          if (!$rootEl)
            return false;
          return $rootEl.find($("#" + targetId))[0];
        });
      } else {
        return form2;
      }
    } else {
      formList = $.grep(FormStack.getFormList(), function(stackForm) {
        if (!stackForm)
          return false;
        if (formID !== stackForm.pFormID)
          return false;
        let $rootEl = stackForm.getRoot().getEl() ? $(stackForm.getRoot().getEl().getElm()) : null;
        if (!$rootEl)
          return false;
        return $rootEl.find(ERPDESIGNER.UI.selectNode)[0];
      });
    }
    if (formList && formList.length > 0)
      return formList[0];
    return form2;
  }
  static getComponentPropertyNodeByNode(node) {
    let attr = node.attr("meta-key");
    if (attr && attr.length > 0) {
      return node;
    } else {
      node = node.par