/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.entity.util;

import com.bokesoft.erp.entity.util.AndExpression;
import com.bokesoft.erp.entity.util.CompareExpression;
import com.bokesoft.erp.entity.util.Struct;
import com.bokesoft.erp.entity.util.WhereExpression;
import com.bokesoft.yes.mid.dbcache.WhereExpressionForCache;
import com.bokesoft.yes.util.VarUtil;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public class WhereExpressionUtil {
    public static WhereExpressionForCache parse(WhereExpression whereExpression) {
        Struct struct = new Struct();
        WhereExpressionUtil.parse(whereExpression, struct);
        WhereExpressionForCache result = null;
        if (!struct.fail) {
            if (struct.columnNames == null) {
                result = new WhereExpressionForCache(struct.oid, struct.soid, null, null, null);
            } else {
                int columnSize = struct.columnNames.size();
                result = new WhereExpressionForCache(struct.oid, struct.soid, struct.columnNames.toArray(new String[columnSize]), struct.columnValues.toArray(new Object[columnSize]), ArrayUtils.toPrimitive((Integer[])struct.operatorIDs.toArray(new Integer[columnSize])));
            }
        }
        return result;
    }

    private static void parse(WhereExpression whereExpression, Struct struct) {
        if (whereExpression instanceof CompareExpression) {
            CompareExpression compareExpression = (CompareExpression)whereExpression;
            int operationID = compareExpression.Operationid;
            String columnName = compareExpression.metaColumn.getBindingDBColumnName();
            if ("OID".equalsIgnoreCase(columnName)) {
                if (!struct.oid.equals(WhereExpressionForCache.Long_NotExist) || operationID != 2) {
                    struct.fail = true;
                    return;
                }
                struct.oid = VarUtil.toLong((Object)compareExpression.Data);
                return;
            }
            if ("SOID".equalsIgnoreCase(columnName)) {
                if (!struct.soid.equals(WhereExpressionForCache.Long_NotExist) || operationID != 2) {
                    struct.fail = true;
                    return;
                }
                struct.soid = VarUtil.toLong((Object)compareExpression.Data);
                return;
            }
            if (operationID >= 1 && operationID <= 6) {
                if (struct.columnNames == null) {
                    struct.columnNames = new ArrayList<String>();
                    struct.columnValues = new ArrayList<Object>();
                    struct.operatorIDs = new ArrayList<Integer>();
                }
                struct.columnNames.add(columnName);
                struct.columnValues.add(compareExpression.Data);
                struct.operatorIDs.add(operationID);
                return;
            }
            struct.fail = true;
        } else if (whereExpression instanceof AndExpression) {
            AndExpression andExpression = (AndExpression)whereExpression;
            for (WhereExpression sub : andExpression.getSubList()) {
                WhereExpressionUtil.parse(sub, struct);
                if (!struct.fail) continue;
                return;
            }
        } else {
            struct.fail = true;
        }
    }
}

