/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.entity.util;

import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.AbstractLoader;
import com.bokesoft.erp.entity.util.AbstractTableEntity;
import com.bokesoft.erp.entity.util.AbstractTableLoader;
import com.bokesoft.erp.entity.util.EntityHelper;
import com.bokesoft.erp.entity.util.OrderByExpression;
import com.bokesoft.erp.entity.util.OrderUtil;
import com.bokesoft.erp.entity.util.WhereExpression;
import com.bokesoft.erp.entity.util.WhereExpressionUtil;
import com.bokesoft.erp.mid.util.ArchiveDBUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.erp.dev.MidContextTool;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.mid.connection.util.ArchiveDSNUtil;
import com.bokesoft.yes.mid.dbcache.IWhereExpression;
import com.bokesoft.yes.mid.dbcache.WhereExpressionForCache;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.List;

class TableEntityManager {
    TableEntityManager() {
    }

    public static DataTable getRowSet(RichDocumentContext context, String tableKey, SqlString sql) throws Throwable {
        String sqlString = sql.getSql();
        Object[] parameters = sql.getParameters();
        DataTable result = context.getPrepareResultSet(tableKey, sqlString, parameters);
        return result;
    }

    public static DataTable getPrepareResultSet(RichDocumentContext context, String tableKey, String sql, Object[] arguments) throws Throwable {
        DataTable result = context.getPrepareResultSet(tableKey, sql, arguments);
        return result;
    }

    public static void executeSQL(RichDocumentContext context, SqlString sql) throws Throwable {
        context.executePrepareUpdate(sql.getSql(), sql.getParameters());
    }

    public static void save(RichDocumentContext context, List<? extends AbstractTableEntity> entities, String formKey) throws Throwable {
        if (entities == null || entities.size() == 0) {
            return;
        }
        ArrayList<DataTable> rsts = new ArrayList<DataTable>();
        for (AbstractTableEntity abstractTableEntity : entities) {
            DataTable rstData;
            if (abstractTableEntity.getBillEntity() != null) {
                RichDocument doc = abstractTableEntity.getBillEntity().document;
                doc.calcDelayFormula(true);
            }
            if (rsts.contains(rstData = abstractTableEntity.getDataTable())) continue;
            rsts.add(rstData);
        }
        String string = entities.get((int)0).tableKey;
        for (DataTable rstData : rsts) {
            rstData.first();
            MidContextTool.saveDataTableData((DefaultContext)context, (DataTable)rstData, (String)string, (String)"OID", (String)formKey);
            rstData.batchUpdate();
        }
    }

    public static <T extends AbstractTableEntity> void delete(RichDocumentContext context, T tableEntity) throws Throwable {
        AbstractBillEntity bill = tableEntity.getBillEntity();
        if (bill != null) {
            throw new Exception("\u8bf7\u76f4\u63a5\u9488\u5bf9\u8868\u5355\u5bf9\u8c61\u8fdb\u884c\u5904\u7406\u540e\u4fdd\u5b58,\u4e0d\u8981\u7528\u8fd9\u4e2a\u65b9\u6cd5\u5220\u9664.");
        }
        DataTable rstData = tableEntity.getDataTable();
        if (rstData.size() != 1) {
            throw new Exception("\u8fd9\u91cc\u6709\u591a\u6761\u6570\u636e,\u76ee\u524d\u7684\u5b9e\u73b0\u6709\u95ee\u9898,\u9700\u8981\u6539\u8fdb.");
        }
        String formKey = tableEntity.metaTablePropItem_getBillKey();
        String tableName = tableEntity.tableKey;
        rstData.first();
        rstData.delete();
        MidContextTool.saveDataTableData((DefaultContext)context, (DataTable)rstData, (String)tableName, (String)"OID", (String)formKey);
    }

    public static void save(RichDocumentContext context, AbstractTableEntity tableEntity, String formKey) throws Throwable {
        AbstractBillEntity bill = tableEntity.getBillEntity();
        if (bill != null) {
            throw new Exception("\u8bf7\u76f4\u63a5\u9488\u5bf9\u8868\u5355\u5bf9\u8c61\u8fdb\u884c\u5904\u7406\u540e\u4fdd\u5b58,\u4e0d\u8981\u7528\u8fd9\u4e2a\u65b9\u6cd5\u4fdd\u5b58.");
        }
        DataTable rstData = tableEntity.getDataTable();
        if (rstData.size() != 1) {
            throw new Exception("\u8fd9\u91cc\u6709\u591a\u6761\u6570\u636e,\u76ee\u524d\u7684\u5b9e\u73b0\u6709\u95ee\u9898,\u9700\u8981\u6539\u8fdb.");
        }
        if (tableEntity.getBillEntity() != null) {
            RichDocument doc = tableEntity.getBillEntity().document;
            doc.calcDelayFormula(true);
        }
        String tableName = tableEntity.tableKey;
        rstData.first();
        MidContextTool.saveDataTableData((DefaultContext)context, (DataTable)rstData, (String)tableName, (String)"OID", (String)formKey);
        rstData.batchUpdate();
    }

    public static DataTable findData(RichDocumentContext context, AbstractLoader<?> loader, String tableKey) throws Throwable {
        DataTable rst = TableEntityManager.findData2(context, loader, null, true, tableKey);
        if (rst == null || rst.size() == 0) {
            return null;
        }
        return rst;
    }

    public static DataTable findDataList(RichDocumentContext context, AbstractLoader<?> loader, List<OrderByExpression> orderBys, String metaTableKey) throws Throwable {
        DataTable rst = TableEntityManager.findData2(context, loader, orderBys, false, metaTableKey);
        return rst;
    }

    public static DataTable findList(RichDocumentContext context, AbstractLoader<?> loader, String metaTableKey) throws Throwable {
        return TableEntityManager.findDataList(context, loader, null, metaTableKey);
    }

    private static DataTable findData2(RichDocumentContext context, AbstractLoader<?> loader, List<OrderByExpression> orderBys, boolean signle, String tableKey) throws Throwable {
        DataTable rst = null;
        WhereExpression whereExpression = loader.getWhereExpression();
        WhereExpressionForCache whereExpressionForCache = WhereExpressionUtil.parse(whereExpression);
        if (whereExpressionForCache != null) {
            IDBManager gdbm = context.getDefaultContext().getDBManager();
            SortCriteria[] sorts = OrderUtil.parse(orderBys);
            rst = gdbm.getCacheDBRequest().queryByWhereExpression(tableKey, (IWhereExpression)whereExpressionForCache, sorts);
            if (rst != null && !rst.first()) {
                rst.beforeFirst();
            }
        }
        if (rst == null) {
            String sqlOrderBy = orderBys == null ? "" : TableEntityManager.join(orderBys, ",");
            SqlString sql = new SqlString(1024).append(new Object[]{MetaTableCache.getDefaultSelect((String)tableKey, (IDBManager)context.getDBManager())});
            if (whereExpression != null) {
                sql.append(new Object[]{" where "});
                whereExpression.toSQL(sql);
            }
            if (sqlOrderBy != null && sqlOrderBy.length() > 0) {
                sql.append(new Object[]{" Order By ", sqlOrderBy});
            }
            rst = TableEntityManager.getRowSet(context, tableKey, sql);
        }
        if (signle && rst.size() > 1) {
            String parseWhereExpression = loader.parseWhereExpression();
            throw new Exception("\u8868" + tableKey + "\u7684" + parseWhereExpression + "\u6761\u4ef6\u627e\u5230\u591a\u6761\u6570\u636e,\u751f\u6210\u8868\u5b9e\u4f53\u5931\u8d25.");
        }
        return rst;
    }

    public static DataTable findDataByOID(RichDocumentContext context, String tableKey, Long oid) throws Throwable {
        String dsn;
        SqlString sql;
        IDBManager gdbm = context.getDefaultContext().getDBManager();
        DataTable rst = gdbm.getCacheDBRequest().queryByOID(tableKey, oid);
        if (!(rst != null && rst.size() != 0 || (rst = TableEntityManager.getRowSet(context, tableKey, sql = new SqlString(1024).append(new Object[]{MetaTableCache.getDefaultSelect((String)tableKey, (IDBManager)context.getDBManager()), " where OID="}).appendPara((Object)oid))) != null && rst.size() != 0 || !ArchiveDBUtil.isArchiveTable((DefaultContext)context, (String)tableKey) || StringUtil.isBlankOrNull((String)(dsn = ArchiveDBUtil.getArchivedDsnById((DefaultContext)context, (String)"", (Long)oid))))) {
            IDBManager coldDBManager = ArchiveDSNUtil.getDBmanager((DefaultContext)context, (String)dsn);
            rst = coldDBManager.getCacheDBRequest().queryByOID(tableKey, oid);
        }
        if (rst.size() > 1) {
            throw new Exception("\u8868" + tableKey + "\u4e3b\u952e\u503c\u4e3a" + oid + "\u627e\u5230\u591a\u6761\u6570\u636e,\u751f\u6210\u8868\u5b9e\u4f53\u5931\u8d25.");
        }
        return rst;
    }

    public static String join(List<?> arrObject, String str) {
        if (arrObject == null) {
            return "";
        }
        StringBuilder sReturn = new StringBuilder(128);
        int i = 0;
        int len = arrObject.size();
        while (i < len) {
            if (i != 0) {
                sReturn.append(str);
            }
            sReturn.append(arrObject.get(i));
            ++i;
        }
        return sReturn.toString();
    }

    public static void delete(RichDocumentContext context, Class<? extends AbstractTableEntity> entityClass, AbstractLoader<?> loader) throws Throwable {
        String tableName = EntityHelper.getInstance().getEntityClassNameMap().getTableName(entityClass);
        SqlString sql = new SqlString(1024).append(new Object[]{"delete from ", tableName, " where ", loader.getWhereExpression().toSQL()});
        TableEntityManager.executeSQL(context, sql);
    }

    public static DataTable findDataTable(RichDocumentContext context, Class<? extends AbstractTableEntity> entityClass, AbstractLoader<?> loader, List<OrderByExpression> orderBys, String metaTableKey, String[] formKeys) throws Throwable {
        return TableEntityManager.findData2(context, loader, orderBys, false, metaTableKey);
    }

    public static DataTable findDataTable(RichDocumentContext context, Class<? extends AbstractTableEntity> entityClass, AbstractLoader<?> loader, String metaTableKey, String[] formKeys) throws Throwable {
        return TableEntityManager.findDataTable(context, entityClass, loader, null, metaTableKey, formKeys);
    }

    public static void preLoadingTableEntityData(RichDocumentContext context, AbstractTableLoader<?> loader) throws Throwable {
        String tableKey = loader.getTableKey();
        WhereExpression whereExpression = loader.getWhereExpression();
        WhereExpressionForCache whereExpressionForCache = WhereExpressionUtil.parse(whereExpression);
        if (whereExpressionForCache == null) {
            throw new RuntimeException("\u5f53\u524dSQL\u4e0d\u652f\u6301\u9884\u52a0\u8f7d\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002");
        }
        IDBManager gdbm = context.getDefaultContext().getDBManager();
        gdbm.getCacheDBRequest().addPreLoadingArgument(tableKey, (IWhereExpression)whereExpressionForCache);
    }
}

