/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.entity.util;

import com.bokesoft.erp.entity.util.AbstractTableEntity;
import com.bokesoft.erp.entity.util.AbstractWhereExpressionParser;
import com.bokesoft.erp.entity.util.AndExpression;
import com.bokesoft.erp.entity.util.WhereExpression;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import java.util.HashMap;
import java.util.List;

class OrExpression
extends WhereExpression {
    private WhereExpression left = null;
    private WhereExpression right = null;

    public OrExpression(WhereExpression l, WhereExpression r) {
        this.left = l;
        this.right = r;
    }

    @Override
    public SqlString toSQL(boolean tableNamePrefix) throws Throwable {
        boolean isLeftCombination = this.left instanceof AndExpression || this.left instanceof OrExpression;
        boolean isRightCombination = this.right instanceof AndExpression || this.right instanceof OrExpression;
        return new SqlString(128).append(new Object[]{isLeftCombination ? "(" : ""}).append(new Object[]{this.left.toSQL(tableNamePrefix)}).append(new Object[]{isLeftCombination ? ")" : ""}).append(new Object[]{" or "}).append(new Object[]{isRightCombination ? "(" : ""}).append(new Object[]{this.right.toSQL(tableNamePrefix)}).append(new Object[]{isRightCombination ? ")" : ""});
    }

    @Override
    public SqlString toSQL(SqlString sqlString, boolean tableNamePrefix) throws Throwable {
        boolean isLeftCombination = this.left instanceof AndExpression || this.left instanceof OrExpression;
        boolean isRightCombination = this.right instanceof AndExpression || this.right instanceof OrExpression;
        sqlString.append(new Object[]{isLeftCombination ? "(" : ""});
        this.left.toSQL(sqlString, tableNamePrefix).append(new Object[]{isLeftCombination ? ")" : ""}).append(new Object[]{" or "}).append(new Object[]{isRightCombination ? "(" : ""});
        this.right.toSQL(sqlString, tableNamePrefix).append(new Object[]{isRightCombination ? ")" : ""});
        return sqlString;
    }

    @Override
    public List<MetaTable> getMetaTables() {
        List<MetaTable> leftTables = this.left.getMetaTables();
        List<MetaTable> rightTables = this.right.getMetaTables();
        if (rightTables.size() == 0) {
            return leftTables;
        }
        int i = 0;
        while (i < rightTables.size()) {
            if (!leftTables.contains(rightTables.get(i))) {
                leftTables.add(rightTables.get(i));
            }
            ++i;
        }
        return leftTables;
    }

    @Override
    boolean isMatch(AbstractTableEntity tableEntity) throws Throwable {
        return this.left.isMatch(tableEntity) || this.right.isMatch(tableEntity);
    }

    @Override
    boolean isSame(WhereExpression whereExpression) throws Throwable {
        if (whereExpression instanceof OrExpression) {
            OrExpression tmp = (OrExpression)whereExpression;
            return this.left.isSame(tmp.left) && this.right.isSame(tmp.right);
        }
        return false;
    }

    @Override
    public boolean hasMetaColumnWhereClause(MetaColumn metaColumn) {
        return this.left.hasMetaColumnWhereClause(metaColumn) || this.right.hasMetaColumnWhereClause(metaColumn);
    }

    @Override
    public String parse(AbstractWhereExpressionParser parser) throws Throwable {
        return String.valueOf(this.left.parse(parser)) + " \u6216 " + this.right.parse(parser);
    }

    @Override
    public HashMap<String, MetaColumn> getMetaColumns() throws Throwable {
        HashMap<String, MetaColumn> leftMetaColumns = this.left.getMetaColumns();
        HashMap<String, MetaColumn> rightMetaColumns = this.right.getMetaColumns();
        for (String key : rightMetaColumns.keySet()) {
            if (leftMetaColumns.containsKey(key)) continue;
            leftMetaColumns.put(key, rightMetaColumns.get(key));
        }
        return leftMetaColumns;
    }

    @Override
    public Object getMetaColumnValue(MetaColumn metaColumn) {
        if (this.left.hasMetaColumnWhereClause(metaColumn)) {
            return this.left.getMetaColumnValue(metaColumn);
        }
        return this.right.getMetaColumnValue(metaColumn);
    }

    @Override
    public MetaColumn getMetaColumn() throws Exception {
        throw new Exception("\u4e0d\u5e94\u8be5\u8dd1\u5230\u8fd9\u91cc");
    }
}

