/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.entity.util;

import com.bokesoft.erp.entity.util.AbstractTableEntity;
import com.bokesoft.erp.entity.util.AbstractWhereExpressionParser;
import com.bokesoft.erp.entity.util.EntityHelper;
import com.bokesoft.erp.entity.util.OrderByExpression;
import com.bokesoft.erp.entity.util.TableColumnKey;
import com.bokesoft.erp.entity.util.WhereExpression;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.base.MidGlobalEnv;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.util.ERPStringUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.struct.dict.Item;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Triple;

public abstract class AbstractLoader<T> {
    public static final Map<TableColumnKey, MetaColumn> metaColumns = new LinkedHashMap<TableColumnKey, MetaColumn>();
    public static final Map<String, Triple<String, String[], String[]>> tables = new HashMap<String, Triple<String, String[], String[]>>(1024);
    protected RichDocumentContext context;
    protected String[] _metaFormKeys;
    protected String[] _dataObjectKeys;
    protected final String _tableKey;
    protected WhereExpression whereExpression = null;
    protected boolean hasIn = false;
    protected List<OrderByExpression> orderBys = null;
    private final AbstractWhereExpressionParser parser = new AbstractWhereExpressionParser(){

        @Override
        public String parsedValue(MetaColumn metaColumn, Object value) throws Throwable {
            int metaColumnType = metaColumn.getDataType();
            if (metaColumnType == 1010) {
                String itemKey = metaColumn.getItemKey();
                if (!StringUtil.isBlankOrNull((String)itemKey)) {
                    Long itemID = TypeConvertor.toLong((Object)value);
                    return this.getDicCaption(itemKey, itemID);
                }
                return value.toString();
            }
            return value.toString();
        }

        @Override
        public String getMetaColumnCaption(MetaColumn metaColumn) throws Throwable {
            if (metaColumn.getKey().equals("SOID") && !metaColumn.getItemKey().isEmpty()) {
                MetaDataObject metaDataObject = AbstractLoader.this.context.getMetaFactory().getDataObject(metaColumn.getItemKey());
                return metaDataObject.getCaption();
            }
            return metaColumn.getCaption();
        }

        public String getDicCaption(String itemKey, Long itemID) throws Throwable {
            if (itemID == 0L) {
                return null;
            }
            try {
                MetaDataObject metaDataObject = AbstractLoader.this.context.getMetaFactory().getDataObject(itemKey);
                String code = metaDataObject.getMainTable().containsKey("UseCode") ? TypeConvertor.toString((Object)this.getDicProp(itemKey, itemID, "UseCode")) : TypeConvertor.toString((Object)this.getDicProp(itemKey, itemID, "Code"));
                String name = TypeConvertor.toString((Object)this.getDicProp(itemKey, itemID, "Name"));
                return String.valueOf(code) + " " + name;
            }
            catch (Throwable e) {
                return TypeConvertor.toString((Object)itemID);
            }
        }

        public Object getDicProp(String itemKey, Long itemID, String propKey) throws Throwable {
            if (itemID == 0L) {
                return null;
            }
            String tableKey = AbstractLoader.this.context.getMetaFactory().getDataObject(itemKey).getMainTableKey();
            Item item = AbstractLoader.this.context.getDictCache().getItem(itemKey, itemID.longValue());
            return item.getValue(tableKey, propKey);
        }
    };

    public AbstractLoader(RichDocumentContext context, String[] metaFormKeys, String[] dataObjectKeys, String tableKey) {
        this.context = context;
        this._tableKey = tableKey;
    }

    public AbstractLoader(RichDocumentContext context, String metaFormKey) {
        this.context = context;
        this._metaFormKeys = new String[]{metaFormKey};
        this._tableKey = null;
    }

    public String getTableKey() {
        return this._tableKey;
    }

    public boolean hasIn() {
        return this.hasIn;
    }

    public AbstractLoader<T> desc() {
        if (this.orderBys != null && this.orderBys.size() > 0) {
            this.orderBys.get(this.orderBys.size() - 1).setDesc();
        }
        return this;
    }

    public AbstractLoader<T> asc() {
        if (this.orderBys != null && this.orderBys.size() > 0) {
            this.orderBys.get(this.orderBys.size() - 1).setAsc();
        }
        return this;
    }

    public AbstractLoader<T> orderBy(OrderByExpression orderByExpression) {
        if (this.orderBys == null) {
            this.orderBys = new LinkedList<OrderByExpression>();
        }
        this.orderBys.add(orderByExpression);
        return this;
    }

    public WhereExpression getWhereExpression() {
        return this.whereExpression;
    }

    public void setWhereExpression(WhereExpression whereExpression) {
        this.whereExpression = whereExpression;
    }

    public AbstractTableEntity loadTableEntity() throws Throwable {
        return (AbstractTableEntity)this.load();
    }

    String getMetaFormCaption(String formKey) throws Throwable {
        IMetaFactory factory = MetaFactory.getGlobalInstance();
        MetaForm metaForm = factory.getMetaForm(formKey);
        if (metaForm != null) {
            return metaForm.getCaption();
        }
        return "";
    }

    static String getTableCaption(Class<? extends AbstractTableEntity> entityClass) throws Throwable {
        String tableCaption = "";
        String tableName = EntityHelper.getInstance().getEntityClassNameMap().getTableName(entityClass);
        String[] formKeys = AbstractLoader.getMetaFormKeys(tableName);
        if (formKeys == null || formKeys.length == 0) {
            return tableCaption;
        }
        IMetaFactory factory = MetaFactory.getGlobalInstance();
        List metaFormList = Arrays.stream(formKeys).map(formKey -> {
            try {
                return factory.getMetaForm(formKey);
            }
            catch (Throwable e) {
                return null;
            }
        }).sorted((o1, o2) -> {
            if (o1.getFormType() == 2 && o2.getFormType() != 2) {
                return -1;
            }
            if (o1.getFormType() == 1 && (o2.getFormType() != 1 || o1.getFormType() == 2)) {
                return -1;
            }
            if (o1.getFormType() == 0 && (o2.getFormType() != 1 || o1.getFormType() == 2 || o2.getFormType() == 0)) {
                return -1;
            }
            return 0;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(metaFormList)) {
            for (MetaForm metaForm : metaFormList) {
                String temporaryTableCaption = metaForm.getMetaTable(tableName).getCaption();
                if (!ERPStringUtil.isBlankOrNull((Object)tableCaption)) continue;
                tableCaption = temporaryTableCaption;
                break;
            }
        }
        return tableCaption;
    }

    public abstract Object load() throws Throwable;

    public abstract Object loadNotNull() throws Throwable;

    public abstract Object loadList() throws Throwable;

    public abstract Object loadListNotNull() throws Throwable;

    public void delete() throws Throwable {
        throw new Exception("\u8868\u5355\u5bf9\u8c61\u672a\u5b9e\u73b0");
    }

    protected abstract boolean existCluster();

    protected abstract String clusterKey();

    protected abstract MetaColumn getClusterMetaColumn() throws Throwable;

    protected void processClusterMetaColumn() throws Throwable {
        if (this.existCluster()) {
            MetaColumn clusterMetaColumn = this.getClusterMetaColumn();
            if (this.whereExpression == null) {
                Long clusterID = this.getClientID();
                this.whereExpression = WhereExpression.eq(clusterMetaColumn, clusterID);
            } else if (!this.whereExpression.hasMetaColumnWhereClause(clusterMetaColumn)) {
                Long clusterID = this.getClientID();
                this.whereExpression = this.whereExpression.addEQ(clusterMetaColumn, clusterID);
            }
        }
    }

    private Long getClientID() throws Throwable {
        return this.context.getClientID();
    }

    public String parseWhereExpression() {
        if (this.whereExpression == null) {
            return "";
        }
        try {
            return this.whereExpression.parse(this.parser);
        }
        catch (Throwable e) {
            return this.whereExpression.toString();
        }
    }

    private static void init_(String tableKey) throws Throwable {
        Triple triple = tables.get(tableKey);
        if (triple == null) {
            ArrayList<String> metaFormKeyList = new ArrayList<String>();
            ArrayList<String> dataObjectKeyList = new ArrayList<String>();
            IMetaFactory metaFactory = MidGlobalEnv.getInstance().getMetaFactory();
            block0: for (MetaFormProfile profile : metaFactory.getMetaFormList()) {
                MetaTableCollection tableCollection;
                MetaDataObject dataObject;
                String formKey;
                MetaForm form;
                MetaDataSource dataSource;
                if (profile.getFormType() == 8 || profile.getFormType() == 9 || (dataSource = (form = metaFactory.getMetaForm(formKey = profile.getKey())).getDataSource()) == null || (dataObject = dataSource.getDataObject()) == null || (tableCollection = dataObject.getTableCollection()) == null) continue;
                for (MetaTable table : tableCollection) {
                    if (!table.getKey().equals(tableKey)) continue;
                    metaFormKeyList.add(formKey);
                    continue block0;
                }
            }
            MetaDataMigrationList metaDataMigrationList = metaFactory.getDataMigrationList();
            block2: for (MetaDataMigrationProfile profile : metaDataMigrationList) {
                String dataObjectKey;
                MetaDataObject dataObject;
                MetaTableCollection tableCollection;
                String dataMigrationkey = profile.getKey();
                MetaDataMigration metaDataMigration = metaFactory.getDataMigration(dataMigrationkey);
                if (metaDataMigration == null || (tableCollection = (dataObject = metaFactory.getDataObject(dataObjectKey = metaDataMigration.getTgtDataObjectKey())).getTableCollection()) == null) continue;
                for (MetaTable table : tableCollection) {
                    if (!table.getKey().equals(tableKey)) continue;
                    dataObjectKeyList.add(dataObjectKey);
                    continue block2;
                }
            }
            triple = Triple.of((Object)tableKey, (Object)metaFormKeyList.toArray(new String[0]), (Object)dataObjectKeyList.toArray(new String[0]));
            tables.put(tableKey, (Triple<String, String[], String[]>)triple);
        }
    }

    public static String[] getMetaFormKeys(String tableKey) throws Throwable {
        AbstractLoader.init_(tableKey);
        Triple<String, String[], String[]> triple = tables.get(tableKey);
        return (String[])triple.getMiddle();
    }

    public static String[] getDataObjectKeys(String tableKey) throws Throwable {
        AbstractLoader.init_(tableKey);
        Triple<String, String[], String[]> triple = tables.get(tableKey);
        return (String[])triple.getRight();
    }
}

