/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.performance;

public class Action {
    public final Object name;
    public final Action parent;
    public final int level;
    public final long startTime;
    private long runTime;
    private long selfTime;
    public final long gapTime;
    private Action subAction;

    public Action(Object name, Action parent, long lastTime) {
        this(name, parent, System.nanoTime(), lastTime);
    }

    private Action(Object name, Action parent, long startTime, long lastTime) {
        this.name = name;
        this.parent = parent;
        this.level = parent == null ? 0 : parent.level + 1;
        this.startTime = startTime;
        this.gapTime = parent == null ? 0L : startTime - lastTime;
    }

    public Action startSubAction(String name, long lastTime) {
        long time;
        if (this.subAction != null) {
            time = this.subAction.endAction();
            this.subAction = null;
            lastTime = time;
        } else {
            time = System.nanoTime();
        }
        this.subAction = new Action(name, this, time, lastTime);
        return this.subAction;
    }

    public long endAction() {
        long time = this.subAction != null && this.subAction.runTime > 0L ? this.subAction.startTime + this.subAction.runTime : System.nanoTime();
        this.runTime = time - this.startTime;
        return time;
    }

    public long getRunTime() {
        return this.runTime;
    }

    public long getSelfTime() {
        return this.selfTime;
    }

    public void setSelfTime(long selfTime) {
        this.selfTime = selfTime;
    }
}

