package com.bokesoft.distro.tech.yigosupport.extension.intf;

import com.bokesoft.yigo.mid.service.IServiceFilter;

import java.util.ServiceLoader;

/**
 * 标识自动注册的 Yigo 服务过滤器({@link IServiceFilter}) Provider.
 * <br/>
 * 具体实现方式采用 Java {@link ServiceLoader} 机制, 因此需要在 META-INF/services 目录下创建的
 * 文本文件 "com.bokesoft.distro.tech.yigosupport.extension.intf.IExtServiceFilterProvider" 中
 * 加上实现类名称.
 */
public interface IExtServiceFilterProvider {
    /**
     * 获取过滤器
     */
    IServiceFilter getFilter();

}
