package com.bokesoft.distro.tech.yigosupport.extension.dee.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

public class JSONUtils {
	private static final Logger log = LoggerFactory.getLogger(JSONUtils.class);
	
	public static List<JSONObject> evalJSONPath(JSONArray data, String jsonPath) {
		List<JSONObject> result = new ArrayList<>();
		// JSONPath.compile方法兼容A.B的父子关系jsonPath查找，
		// 不需要额外递归等方法来查找A.B的元素
		Object selection= JSONPath.compile(jsonPath).eval(data);
		
		if(null==selection){
			return result;
		}
		
		JSONArray nodes;
		if (selection instanceof JSONArray) {
			nodes = (JSONArray)selection;
		}else if (selection instanceof JSONObject) {
			nodes = new JSONArray();
			nodes.add(selection);
		} else {
			log.warn("忽略 JSONPath {} 查找到的对象 {} - JSONPath 查找到的结果只能是 JSONArray 或者 JSONObject",
					jsonPath, selection);
			nodes = new JSONArray();
		}
		
		for(Object obj: nodes) {
			if (obj instanceof JSONObject) {
				JSONObject node = (JSONObject)obj;
				result.add(node);
			}else {
				log.warn("忽略 JSONPath {} 查找结果中的元素 {} - 查找结果中的元素必须是 JSONObject",
						jsonPath, obj);
			}
		}
		return result;
	}
	
	public static void foreachJSONPath(JSONArray data, NodeItr itr) {
		int len = data.size();
		for(int i=0; i<len; i++) {
			JSONObject node = data.getJSONObject(i);
			itr.process(node);
		}
	}
	
	public static void foreachJSONPath(JSONArray data, String jsonPath, NodeItr itr) {
		List<JSONObject> nodes = evalJSONPath(data, jsonPath);
		for (JSONObject node: nodes) {
			itr.process(node);
		}
	}

}
