package com.bokesoft.distro.tech.yigosupport.extension.coordinate;

import com.bokesoft.distro.tech.commons.basis.coordinate.SemaphoreEventBus;
import com.bokesoft.distro.tech.commons.basis.coordinate.intf.ISemaphoreConsumer;
import com.bokesoft.distro.tech.commons.basis.coordinate.struct.Semaphore;
import com.bokesoft.distro.tech.commons.basis.coordinate.struct.ThrottleConfig;
import com.bokesoft.distro.tech.yigosupport.extension.coordinate.impl.YigoSemaphoreChannelFactory;

/**
 * 信号量发射器
 * @see SemaphoreEventBus
 */
public class SemaphoreFacade {

    private SemaphoreFacade() {
    }

    /**
     * 发送信号量
     * @param semaphoreKey 信号量类型,{@link SemaphoreEventBus#registerSender(String, ThrottleConfig)}
     */
    public static void send(String semaphoreKey) {
        SemaphoreEventBus.getINSTANCE().postSend(semaphoreKey);
    }

    public static void send(Semaphore semaphore) {
        init();
        SemaphoreEventBus.getINSTANCE().postSend(semaphore);
    }

    public static void registerReceiver(String semaphoreKey, ISemaphoreConsumer consumer, ThrottleConfig config) {
        init();
        SemaphoreEventBus.getINSTANCE().registerReceiver(semaphoreKey, consumer, config);
    }

    public static void registerSender(String semaphoreKey, ThrottleConfig config) {
        init();
        SemaphoreEventBus.getINSTANCE().registerSender(semaphoreKey, config);
    }

    private static boolean init = false;

    private static void init() {
        if (!init) {
            synchronized (SemaphoreEventBus.class) {
                if (!init) {
                    init = true;
                    SemaphoreEventBus.setFactory(new YigoSemaphoreChannelFactory());
                }
            }
        }

    }

}
