package com.bokesoft.distro.tech.yigosupport.extension.coordinate;

import com.bokesoft.distro.tech.commons.basis.coordinate.impl.SimpleLeaderStatusDetector;
import com.bokesoft.distro.tech.commons.basis.coordinate.intf.ILeaderStatusDetector;
import com.bokesoft.distro.tech.commons.basis.coordinate.intf.ILeaderStatusDetectorFactory;
import com.bokesoft.distro.tech.commons.basis.coordinate.struct.LeaderStatusConfig;
import com.bokesoft.distro.tech.yigosupport.extension.coordinate.impl.YigoLeaderStatusDetectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 节点状态探测器
 * 节点状态是虚拟的而不是物理节点
 * @see {@link ILeaderStatusDetector}
 */
public class LeaderStatusDetectors {

    private LeaderStatusDetectors() {
    }

    private static ILeaderStatusDetector detector;

    private static final Logger log = LoggerFactory.getLogger(LeaderStatusDetectors.class);

    /**
     * 延迟初始化,如果初始化失败,则打印日志并回退实现!
     *
     * @return
     */
    private static ILeaderStatusDetector detector() {
        if (detector == null) {
            synchronized (LeaderStatusDetectors.class) {
                if (detector == null) {
                    try {
                        ILeaderStatusDetectorFactory factory = new YigoLeaderStatusDetectorFactory();
                        detector = factory.create();
                    } catch (Exception e) {
                        log.error("LeaderStatusDetector 初始化失败,使用回退实现!", e);
                        detector = new SimpleLeaderStatusDetector();
                    }
                }
            }
        }
        return detector;
    }

    /**
     * 判断某个业务在当前节点是否Leader状态
     * @param bizTag 业务类型标签
     * @return
     * @see  ILeaderStatusDetector#isLeader(String)
     */
    public static boolean isLeader(String bizTag) {
        return detector().isLeader(bizTag);
    }

    /**
     * 注册一个业务状态配置
     * @param key 业务标签,不能重复
     * @param config
     * @see ILeaderStatusDetector#register(String, LeaderStatusConfig)
     */
    public static void register(String key, LeaderStatusConfig config) {
        detector().register(key, config);
    }


}
