package com.bokesoft.distro.tech.yigosupport.extension.cache;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 用于创建指定名称的 {@link SqlQueryCache} 对象
 */
public class SqlQueryCacheManager {
	private static final Logger log = LoggerFactory.getLogger(SqlQueryCacheManager.class);

	private static final Map<String, SqlQueryCache> caches = new ConcurrentHashMap<>();

	/**
	 * 通过指定与缓存数据相关的核心类 Class 创建 SqlQueryCache.
	 * @param clazz
	 * @return
	 */
	public static SqlQueryCache getCache(Class<?> clazz) {
		return getCache(clazz.getName());
	}
	
	/**
	 * 指定名称创建 SqlQueryCache. 注意: 一般情况下建议使用 {@link #getCache(Class)}, 以保证较好的强类型和重构支持.
	 * @param name
	 * @return
	 */
	public static SqlQueryCache getCache(String name) {
		 log.debug("get SqlQueryCache [{}]",name);
		 return caches.computeIfAbsent(name, (key) -> {
			 log.debug("create SqlQueryCache [{}]",key);
			 return new SqlQueryCache(key);
		 });
	}
}
