package com.bokesoft.distro.tech.yigosupport.extension.base;

import java.util.ArrayList;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.bokesoft.distro.tech.yigosupport.extension.exception.Misc;
import com.bokesoft.distro.tech.yigosupport.extension.impl.WrapperUtils;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IExtService;

/**
 * 通过 {@link IExtService} 调用参数找到匹配的静态方法名, 实现一个类处理多个服务调用.
 */
public interface IStaticMethodByArgsExtServiceWrapper extends IExtServiceWrapper {
	static final Logger log = LoggerFactory.getLogger(IStaticMethodByArgsExtServiceWrapper.class);

	@Override
	default public Object doCmd(DefaultContext ctx, ArrayList<Object> args) throws Throwable {
		try {
			if (null==args){
				args = new ArrayList<>();
			}

			String method = WrapperUtils.findStaticMethod(ctx, this.getClass(), args.toArray(), null);
			Object result = WrapperUtils.tryRunStaticMethod(ctx, this.getClass(), method, args.toArray());
			return result;
		}catch(Exception ex) {
			throw Misc.convertToYigoException(ex, log);
		}
	}

}
