package com.bokesoft.distro.tech.yigosupport.deployment.resource;

import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.intf.IResourceIO;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.utils.ResourcePaths;
import com.bokesoft.yigo.meta.base.IMetaResolver;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.List;

/**
 * 基于资源的多 solution MetaResolver
 */
public class ResourceMultiSolutionResolver implements IMetaResolver {
	private static final Logger log = LoggerFactory.getLogger(ResourceMultiSolutionResolver.class);
	
	private static final String SP = IResourceIO.SEPARATOR;
	private static final char SP_C = IResourceIO.SEPARATOR.charAt(0);
	
	private String prefix;
	private ResourcePaths resources;
	private IResourceIO resourceIO;

	/**
	 * 通过资源列表构建 MetaResolver
	 * @param resourceList 资源列表, 注意, 只有文件而不包含目录
	 * @param resourceIO
	 */
	public ResourceMultiSolutionResolver(List<String> resourceList, IResourceIO resourceIO, String prefix) {
		this.resources = new ResourcePaths(resourceList);
		this.resourceIO = resourceIO;
		
		if (! prefix.endsWith(SP)) {
			prefix = prefix + SP;
		}
		this.prefix = prefix;
	}

	@Override
	public boolean isListAbsolutePath() {
		return false;
	}

	/**
	 * 读取资源;
	 * FIXME 目前 type 没有作用
	 */
	@Override
	public InputStream read(String resource, int type) throws Exception {
		String fullPath = _fullPath(resource);
		log.debug("[{}]: read, resource='{}', type={}", this.resourceIO.getInstanceId(), fullPath, type);
		byte[] data = this.resourceIO.read(fullPath);
		if (null!=data) {
			return new ByteArrayInputStream(data);
		}else {
			return null;
		}
	}

	/**
	 * 获取资源的 URI;
	 * FIXME 目前 type 没有作用
	 */
	@Override
	public URI getURI(String resource, int type) throws Exception {
		String fullPath = _fullPath(resource);
		return this.resourceIO.getURI(fullPath);
	}

	@Override
	public boolean write(String resource, byte[] data) throws Exception {
		String fullPath = _fullPath(resource);
		log.debug("[{}]: write, resource='{}'", this.resourceIO.getInstanceId(), fullPath);
		this.resourceIO.write(fullPath, data);
		return true;
	}

	@Override
	public String getPath(String resource) {
		try {
			URI uri = this.getURI(resource, -1);
			try {
				File f = new File(uri);
				return f.getCanonicalPath();
			} catch (IllegalArgumentException e) {
				throw new UnsupportedOperationException(e);
			}
		} catch (Exception e) {
			return ExceptionUtils.rethrow(e);
		}
	}

	/**
	 * 获取目录下的资源列表; FIXME 目前 flag 没有作用.
	 */
	@Override
	public int listResource(String resource, String flag, List<String> resources, List<String> names, List<Boolean> flags) throws Exception {
		String fullPath = _fullPath(resource);
		log.info("[{}]: listResource: '{}', flag={}", this.resourceIO.getInstanceId(), fullPath, flag);
		
		int count = 0;
		List<String> files = this.resources.listFiles(fullPath);
		for (String file: files) {
			String name = _getName(file);
			resources.add(name);
			names.add(name);
			flags.add(false);
			count++;
		}
		List<String> dirs = this.resources.listDirs(fullPath);
		for (String dir: dirs) {
			String name = _getName(dir);
			resources.add(name);
			names.add(name);
			flags.add(true);
			count ++;
		}
		
		return count;
	}
	
	private String _getName(String path) {
		int lastSp = path.lastIndexOf(SP_C);
		if (lastSp<0) {
			return path;
		}
		MiscUtil.$assert((lastSp>=(path.length()-1)), "无法获取路径中的文件或目录名称: "+path);
		
		String name = path.substring(lastSp+1);
		return name;
	}

	private String _fullPath(String resource) {
		if (resource.startsWith(SP)) {
			resource = resource.substring(1);
		}
		resource = resource.replaceAll("\\\\", "/");
		return prefix + resource;
	}

	@Override
	public char getSeparator() {
		return SP_C;
	}

}
