package com.bokesoft.distro.tech.yigosupport.deployment.local;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;

/**
 * 支持本地多 solution 部署的 MetaResolverFactory.<br/>
 * 典型情况下使用的 solution properties 配置文件内容如下:<br/>
 * <pre>
 * PRIMARY=true  # 是否是主 solution, 默认情况下取 core.properties 中 SOLUTIONS=... 定义 solution 列表的第一个作为主 solution
 * IMPL=com.bokesoft.distro.tech.yigosupport.deployment.local.LocalMultiSolutionMetaResolverFactory
 * PARA.DIR=${application-testcase.core.solution-path}
 * </pre>
 */
public class LocalMultiSolutionMetaResolverFactory implements IMetaResolverFactory {
	private static final Logger log = LoggerFactory.getLogger(LocalMultiSolutionMetaResolverFactory.class);

	/** 初始参数, 用于在 solution 定义 properties 文件中指定 当前 solution 目录 */
	private static final String KEY_SOLUTION_DIR = "DIR";

	private String baseDir = null;

	@Override
	public void initParas(Map<String, Object> paras) {
		log.debug("initParas with '{}'", paras);
		baseDir = (String) paras.get(KEY_SOLUTION_DIR);
	}

	/**
	 * 目前的情况, 应该只有在无法加载到相关数据的时候才会调用这个方法
	 */
	@Override
	public String getSolutionPath() {
		log.debug("getSolutionPath return '{}'", baseDir);
		return baseDir;
	}

	/**
	 * 针对 Solution.xml 中使用相对目录引用 project 的情况
	 */
	@Override
	public IMetaResolver newMetaResolver(String prefix) {
		LocalMultiSolutionMetaResolver resolver = new LocalMultiSolutionMetaResolver(baseDir, prefix);
		log.info("create newMetaResolver [{}]: '{}' over '{}' .", Integer.toHexString(resolver.hashCode()), prefix, baseDir);
		return resolver;
	}

	/**
	 * 针对 Solution.xml 中使用绝对目录引用 project 的情况
	 */
	@Override
	public IMetaResolver newFileMetaResolver(String prefix) {
		throw new UnsupportedOperationException("不支持通过绝对目录的引用(baseDir='"+baseDir+"')");
	}

	@Override
	public char getSeparator() {
		return '/';
	}

}
