/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.data;

import java.io.Serializable;

public class PagingSearchResult<T>
implements Serializable {
    private static final long serialVersionUID = 20150706L;
    private int pageNo;
    private int pageSize;
    private long totalRecords;
    private int pageCount;
    private T data;

    public PagingSearchResult(int pageNo, int pageSize, long totalRecords) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.totalRecords = totalRecords;
        this.pageCount = Double.valueOf(Math.ceil(1.0 * (double)totalRecords / (double)pageSize)).intValue();
        if (this.pageCount < 1) {
            this.pageCount = 1;
        }
        if (this.pageNo > this.pageCount - 1) {
            this.pageNo = this.pageCount - 1;
        }
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public int getPageCount() {
        return this.pageCount;
    }
}

