/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.data;

import com.bokesoft.distro.tech.commons.basis.data.BaseResult;
import com.bokesoft.distro.tech.commons.basis.data.CodeMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CommonResult<T>
extends BaseResult<T> {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> attachments;

    public CommonResult() {
    }

    private CommonResult(int code, String msg, T data, boolean isSuccess) {
        this.setCode(code);
        this.setMessage(msg);
        this.setData(data);
        this.setSuccess(isSuccess);
    }

    public static <T> CommonResult<T> success(int code, String message, T data) {
        return new CommonResult<T>(code, message, data, true);
    }

    public static <T> CommonResult<T> success(CodeMessage message, T data) {
        return CommonResult.success(message.getCode(), message.getMessage(), data);
    }

    public static CommonResult<Object> success(CodeMessage message) {
        return CommonResult.success(message.getCode(), message.getMessage(), null);
    }

    public static <T> CommonResult<T> success(T data) {
        return CommonResult.success(200, "\u6210\u529f", data);
    }

    public static <T> CommonResult<T> failure(int code, String message, T data) {
        return new CommonResult<T>(code, message, data, false);
    }

    public static <T> CommonResult<T> failure(CodeMessage message, T data) {
        return CommonResult.failure(message.getCode(), message.getMessage(), data);
    }

    public static CommonResult<Object> failure(CodeMessage message) {
        return CommonResult.failure(message.getCode(), message.getMessage(), null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ServiceResult [success=");
        builder.append(this.success);
        builder.append(", code=");
        builder.append(this.getCode());
        builder.append(", ");
        if (this.attachments != null) {
            builder.append("attachments=");
            builder.append(this.attachments);
            builder.append(", ");
        }
        if (this.getMessage() != null) {
            builder.append("message=");
            builder.append(this.getMessage());
            builder.append(", ");
        }
        if (this.getData() != null) {
            builder.append("data=");
            builder.append(this.getData());
        }
        builder.append("]");
        return builder.toString();
    }

    public Map<String, Object> getAttachments() {
        if (null == this.attachments) {
            return null;
        }
        return Collections.unmodifiableMap(this.attachments);
    }

    @Deprecated
    public void setAttachments(Map<String, Object> attachments) {
        this.attachments = attachments;
    }

    public CommonResult<T> addAttachment(String key, Object value) {
        if (null == this.attachments) {
            this.attachments = new HashMap<String, Object>();
        }
        this.attachments.put(key, value);
        return this;
    }
}

