package com.bokesoft.distro.tech.commons.basis.jdbc.struc;


import java.io.Serializable;

public class DBTypeInfo implements Serializable {
    /**
     * jdbc正则匹配模板,使用startwith来匹配
     */
    private String jdbcUrlPattern;

    /**
     * 数据库类型,应与com.bokesoft.yigo.mid.connection.DBType常量定义一致
     */
    private String dbType;

    /**
     *  数据库对应的驱动类class
     */
    private String dbDriver;
    /**
     * 数据库对应的url
     */
    private String urlTemplate;
    /**
     * 区分相同数据库下的不同driver和url
     */
    private String subType;

    public DBTypeInfo(){
        //DO NOTHING;
    }



    public DBTypeInfo(String jdbcUrlPattern, String dbType, String dbDriver,String urlTemplate) {
        this(jdbcUrlPattern,dbType,dbDriver,urlTemplate,null);
    }

    public DBTypeInfo(String jdbcUrlPattern, String dbType, String dbDriver,String urlTemplate,String subType) {
        this.jdbcUrlPattern = jdbcUrlPattern;
        this.dbType = dbType;
        this.dbDriver = dbDriver;
        this.urlTemplate = urlTemplate;
        this.subType = subType;
    }

    public String getUrlTemplate() {
        return urlTemplate;
    }

    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getJdbcUrlPattern() {
        return jdbcUrlPattern;
    }
    public void setJdbcUrlPattern(String jdbcUrlPattern) {
        this.jdbcUrlPattern = jdbcUrlPattern;
    }
    public String getDbType() {
        return dbType;
    }
    public void setDbType(String dbType) {
        this.dbType = dbType;
    }
    public String getDbDriver() {
        return dbDriver;
    }
    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    @Override
    public String toString() {
        return "DBTypeInfo{" +
                "jdbcUrlPattern='" + jdbcUrlPattern + '\'' +
                ", dbType='" + dbType + '\'' +
                ", dbDriver='" + dbDriver + '\'' +
                ", urlTemplate='" + urlTemplate + '\'' +
                ", subType='" + subType + '\'' +
                '}';
    }
}
