package com.bokesoft.distro.tech.commons.basis.data;

import java.util.Formatter;

/**
 * 大部分服务调用结果中, 代码 和 执行信息 通常会绑定在一起, 所以专门单独定义一个对象进行描述
 */
public class CodeMessage {
	private int code;
	private String message;

	/**
	 * 通过 code 和 message 创建 代码/执行信息 对象
	 * @param code
	 * @param msg
	 */
	public CodeMessage(int code, String msg) {
		this.code = code;
		this.message = msg;
	}

	/**
	 * 通过 code 和 message 创建 代码/执行信息 对象, 可以使用 {@link Formatter} 支持的字符串格式定义
	 * @param code
	 * @param msg
	 * @param args
	 */
	public CodeMessage(int code, String msg, Object... args) {
		this.code = code;
		this.message = String.format(msg, args);
	}

	public int getCode() {
		return code;
	}

	public String getMessage() {
		return message;
	}

	/**
	 * 替换 message 中的 {@link Formatter} 字符串格式参数
	 * @param args
	 */
	public CodeMessage applyArgs(Object... args) {
		return new CodeMessage(this.getCode(), this.getMessage(), args);
	}
}