package com.bokesoft.distro.tech.commons.basis.coordinate.struct;

import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class ThrottleConfig {



    /**
     * 出现连续信号量时,
     * 合并逻辑的最大间隔,
     * 也是最后一个信号的最大延迟时间
     */
    private Duration step=Duration.ofSeconds(3);
    /**
     * 合并连续信号量时,必须发送一次信号的最大累计数量
     */
    private int maxCount=10;
    /**
     * 合并连续信号量时,必须发送一次信号的最大间隔时间
     */
    private Duration maxStep=Duration.ofSeconds(10);

    public static final ScheduledExecutorService delayedExecutor
            = Executors.newSingleThreadScheduledExecutor((r) -> {
        Thread th = new Thread(r);
        th.setDaemon(true);
        th.setName("SemaphoreThrottleDelayScheduler");
        return th;
    });
    private ScheduledExecutorService executor= delayedExecutor;

    public ThrottleConfig() {
    }

    public ThrottleConfig(Duration step, int maxCount, Duration maxStep, ScheduledExecutorService executor) {
        this.step = step;
        this.maxCount = maxCount;
        this.maxStep = maxStep;
        this.executor = executor;
    }

    public static ThrottleConfig throttle(Duration step, int maxCount, Duration maxStep) {
        return new ThrottleConfig(step, maxCount, maxStep, delayedExecutor);
    }

    public Duration getStep() {
        return step;
    }

    public void setStep(Duration step) {
        this.step = step;
    }

    public int getMaxCount() {
        return maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public Duration getMaxStep() {
        return maxStep;
    }

    public void setMaxStep(Duration maxStep) {
        this.maxStep = maxStep;
    }

    public ScheduledExecutorService getExecutor() {
        return executor;
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }
}
