package com.bokesoft.distro.tech.commons.basis.coordinate.impl;

import com.bokesoft.distro.tech.commons.basis.coordinate.intf.ISemaphoreChannel;
import com.bokesoft.distro.tech.commons.basis.coordinate.struct.Semaphore;
import com.bokesoft.distro.tech.commons.basis.coordinate.SemaphoreEventBus;

import java.util.concurrent.CompletableFuture;

public final class SimpleSemaphoreChannel implements ISemaphoreChannel {

   final SemaphoreEventBus eventBus;

    public SimpleSemaphoreChannel(SemaphoreEventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public void doSend(Semaphore semaphore) {
        //  CompletableFuture.runAsync是一个publish行为,runnable实现是一个callback;
        //  callback中省略了consumer#accept行为,因为consumer#accpet方法只是多一层方法调用,此处省略;
        CompletableFuture.runAsync(() -> {
            eventBus.onReceiver(semaphore);
        });
    }
}
