/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.utils;

import com.bokesoft.distro.tech.bootsupport.starter.wrapper.WrappedConnection;
import com.bokesoft.distro.tech.bootsupport.starter.wrapper.WrappedDBManager;
import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.distro.tech.commons.basis.flightrecord.utils.YFRUtils;
import com.bokesoft.yes.mid.connection.ConnectionProfile;
import com.bokesoft.yes.mid.connection.dbmanager.DB2DBManager;
import com.bokesoft.yes.mid.connection.dbmanager.DMDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.EsgynDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.GaussDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.HighGoDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.KingbaseManager;
import com.bokesoft.yes.mid.connection.dbmanager.MyCatDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.MySqlClusterDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.MySqlDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.OracleDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.PostgreSQLDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.ShenTongDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.SqlServerDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.SqliteDBManager;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.slf4j.event.Level;

public class DataSourceAwareDBManagerBuilder {
    public static IDBManager getDBManager(int dbType, DataSource dataSource, Level logLevel, boolean dbTraceCacheEnabled, boolean execTimeoutControlEnabled) throws Throwable {
        return DataSourceAwareDBManagerBuilder.getDBManager(DataSourceAwareDBManagerBuilder.buildConnectionProfile(dbType), dataSource, logLevel, dbTraceCacheEnabled, execTimeoutControlEnabled);
    }

    public static IDBManager getDBManager(IConnectionProfile connectionProfile, DataSource dataSource, Level logLevel, boolean dbTraceCacheEnabled, boolean execTimeoutControlEnabled) throws Throwable {
        String instanceId = UUID.randomUUID().toString();
        Connection connection = DataSourceAwareDBManagerBuilder.getConnection(instanceId, dataSource, dbTraceCacheEnabled, execTimeoutControlEnabled);
        IDBManager dbManager = DataSourceAwareDBManagerBuilder.getDBManager(connectionProfile, connection);
        dbManager.setKey(connectionProfile.getKey());
        WrappedDBManager wdbm = new WrappedDBManager(dbManager, instanceId, execTimeoutControlEnabled);
        wdbm.setLogLevel(logLevel);
        return wdbm;
    }

    private static Connection getConnection(String instanceId, DataSource datasource, boolean dbTraceCacheEnabled, boolean execTimeoutControlEnabled) throws SQLException {
        WrappedConnection conn = null;
        MiscUtil.$assert((null == datasource ? 1 : 0) != 0, (String)"\u672a\u914d\u7f6e\u6709\u6548\u7684\u6570\u636e\u6e90,\u7cfb\u7edf\u65e0\u6cd5\u4f7f\u7528 ");
        conn = new WrappedConnection(YFRUtils.getDatasourceId((DataSource)datasource), datasource.getConnection(), instanceId, dbTraceCacheEnabled, execTimeoutControlEnabled);
        try {
            conn.setTransactionIsolation(2);
        }
        catch (Exception ex) {
            conn.setTransactionIsolation(1);
        }
        return conn;
    }

    private static IDBManager getDBManager(IConnectionProfile connectionProfile, Connection conn) throws Throwable {
        conn.setAutoCommit(false);
        SqlServerDBManager dbm = null;
        int dbType = -1;
        if (connectionProfile != null && connectionProfile.getDBType() != 0) {
            dbType = connectionProfile.getDBType();
        }
        switch (dbType) {
            case 1: {
                dbm = new SqlServerDBManager(connectionProfile, conn);
                break;
            }
            case 2: {
                dbm = new OracleDBManager(connectionProfile, conn);
                break;
            }
            case 3: {
                dbm = new DB2DBManager(connectionProfile, conn);
                break;
            }
            case 4: {
                dbm = new MySqlDBManager(connectionProfile, conn);
                break;
            }
            case 6: {
                dbm = new MySqlClusterDBManager(connectionProfile, conn);
                break;
            }
            case 7: {
                dbm = new SqliteDBManager(connectionProfile, conn);
                break;
            }
            case 8: {
                dbm = new DMDBManager(connectionProfile, conn);
                break;
            }
            case 9: {
                dbm = new MyCatDBManager(connectionProfile, conn);
                break;
            }
            case 11: {
                dbm = new HighGoDBManager(connectionProfile, conn);
                break;
            }
            case 12: {
                dbm = new GaussDBManager(connectionProfile, conn);
                break;
            }
            case 13: {
                dbm = new KingbaseManager(connectionProfile, conn);
                break;
            }
            case 14: {
                dbm = new EsgynDBManager(connectionProfile, conn);
                break;
            }
            case 15: {
                dbm = new ShenTongDBManager(connectionProfile, conn);
                break;
            }
            case 10: {
                dbm = new PostgreSQLDBManager(connectionProfile, conn);
                break;
            }
            default: {
                throw new UnsupportedOperationException("DBType:" + dbType + ", no match! Unsupport db connection!");
            }
        }
        dbm.setKey(connectionProfile.getKey());
        return dbm;
    }

    private static IConnectionProfile buildConnectionProfile(int dbType) {
        ConnectionProfile cp = new ConnectionProfile();
        cp.setDBType(dbType);
        cp.setKey("DBTYPE_AUTO_" + dbType);
        return cp;
    }
}

