/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.servletcontextmocks;

import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(MockClassLoader.class);
    private String tmpPath;

    public MockClassLoader(ClassLoader parent, String tmpPath) {
        super(parent);
        this.tmpPath = tmpPath;
    }

    @Override
    public URL getResource(String name) {
        Path path = Paths.get(this.tmpPath, name);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                URL coreUrl = path.toUri().toURL();
                log.info("[Yigo \u521d\u59cb\u5316]: {} \u6240\u5728\u7684 URL: {}", (Object)name, (Object)coreUrl);
                return coreUrl;
            }
            catch (MalformedURLException e) {
                throw MiscUtil.toRuntimeException((Throwable)e);
            }
        }
        return super.getResource(name);
    }
}

