/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.readonly.impl;

import com.bokesoft.distro.tech.bootsupport.starter.config.ReadOnlyDbCheckConfig;
import com.bokesoft.distro.tech.bootsupport.starter.i18n.StringTable;
import com.bokesoft.distro.tech.bootsupport.starter.readonly.intf.IDBWatcher;
import com.bokesoft.distro.tech.bootsupport.starter.readonly.struc.DBReadOnlyStatus;
import com.bokesoft.distro.tech.bootsupport.starter.readonly.struc.DBWatchData;
import com.bokesoft.distro.tech.commons.basis.trace.TraceUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerDBWatcher
implements IDBWatcher {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerDBWatcher.class);
    private static String currentDBName = null;

    @Override
    public DBWatchData doCheck(DefaultContext context, ReadOnlyDbCheckConfig config) throws Throwable {
        IDBManager dbManager = context.getDBManager();
        if (StringUtils.isEmpty((CharSequence)currentDBName)) {
            currentDBName = dbManager.execQuery("select db_name() as dbname").getString(0);
        }
        String sql1 = "select id  as agent_id from distribution.dbo.MSdistribution_agents where subscriber_db= ?";
        DataTable dataTable = dbManager.execPrepareQuery(sql1, new Object[]{currentDBName});
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int size = dataTable.size();
        for (int i = 0; i < size; ++i) {
            arrayList.add((Integer)dataTable.getRowByIndex(i).getObject("agent_id"));
        }
        SqlServerDBWatchData sqlServerDBWatchData = null;
        if (!arrayList.isEmpty()) {
            String errLogSql = "select agent_id,runstatus,start_time,error_id,comments from distribution.dbo.MSdistribution_history WHERE error_id!=0 and  start_time =(SELECT max(start_time) from distribution.dbo.MSdistribution_history where agent_id in (?)) and agent_id in (?)";
            DataTable dataTable1 = dbManager.execPrepareQuery(errLogSql, new Object[]{StringUtils.join(arrayList, (String)","), StringUtils.join(arrayList, (String)",")});
            if (dataTable1.size() != 0) {
                new SqlServerDBWatchData(dataTable1);
            } else {
                SqlServerDBWatchData.OK();
            }
        } else {
            SqlServerDBWatchData.ERROR(this.dbAgentErrI18N());
        }
        return new DBWatchData(sqlServerDBWatchData.getReason(), sqlServerDBWatchData.getDescription(), sqlServerDBWatchData.getStatus());
    }

    @Override
    public boolean support(int dbType) {
        return 1 == dbType;
    }

    private String dbAgentErrI18N() {
        return StringTable.i18N(null, "DBReadOnlyCheckFaild", currentDBName, TraceUtil.getTraceId());
    }

    static class SqlServerDBWatchData {
        private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
        private int agentId = -1;
        private String startTime = "unkown";
        private Integer errorId = -1;
        private String comments = "unkown";
        private String reason;
        private DBReadOnlyStatus status = DBReadOnlyStatus.ERROR;

        private SqlServerDBWatchData() {
        }

        public SqlServerDBWatchData(DataTable dt) {
            this.agentId = dt.getInt("agent_id");
            this.startTime = this.formatter.format(dt.getDateTime("start_time"));
            this.errorId = dt.getInt("error_id");
            this.comments = dt.getString("comments");
            this.reason = this.i18NSyncError();
            this.status = DBReadOnlyStatus.ERROR;
        }

        public static SqlServerDBWatchData OK() {
            SqlServerDBWatchData data = new SqlServerDBWatchData();
            data.status = DBReadOnlyStatus.OK;
            return data;
        }

        public static SqlServerDBWatchData ERROR(String reason) {
            SqlServerDBWatchData data = new SqlServerDBWatchData();
            data.reason = reason;
            return data;
        }

        public String getDescription() {
            String result = "\n=====================================================\n";
            result = result + "\u4efb\u52a1\u7f16\u53f7\u4e3a: " + this.agentId + "\n";
            result = result + "\u6267\u884c\u65f6\u95f4\u4e3a: " + this.startTime + " \n";
            result = result + "\u9519\u8befid: " + this.errorId + " \n";
            result = result + "\u5b8c\u6574\u9519\u8bef\u4fe1\u606f\u4e3a: " + this.comments + "\n";
            result = result + "=====================================================";
            return result;
        }

        public String getReason() {
            return this.reason;
        }

        public DBReadOnlyStatus getStatus() {
            return this.status;
        }

        private String i18NSyncError() {
            return StringTable.i18N(null, "SqlserverSyncError", this.errorId, this.startTime, TraceUtil.getSpanId());
        }
    }
}

