/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.jsmodule;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoExtendJavascriptProvider;
import com.bokesoft.distro.tech.bootsupport.starter.utils.URLPathUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;

public class AutoScanYigoExtendJavascriptProvider
implements YigoExtendJavascriptProvider {
    private final ResourceLoader resourceLoader;
    private String rootUrl;

    public AutoScanYigoExtendJavascriptProvider(ResourceLoader resourceLoader, String rootUrl) {
        this.resourceLoader = resourceLoader;
        this.rootUrl = rootUrl;
    }

    @Override
    public List<Resource> getResources() {
        try {
            return this._listResources();
        }
        catch (IOException e) {
            return (List)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private List<Resource> _listResources() throws IOException {
        Resource root = this.resourceLoader.getResource(this.rootUrl);
        String rootPath = root.getURL().getPath();
        String pattern = URLPathUtils.get(this.rootUrl, "**", "*.*");
        ResourcePatternResolver patternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader);
        Resource[] resources = patternResolver.getResources(pattern);
        ArrayList<String> pathList = new ArrayList<String>();
        for (Resource r : resources) {
            String path = r.getURL().getPath();
            if (!(path = URLPathUtils.relativizeOf(path, rootPath)).endsWith(".js")) continue;
            pathList.add(path);
        }
        pathList.sort(null);
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (String path : pathList) {
            String resPath = URLPathUtils.get(this.rootUrl, path);
            Resource res = this.resourceLoader.getResource(resPath);
            result.add(res);
        }
        return result;
    }
}

