/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.execctl.model;

import com.bokesoft.yigo.struct.document.Document;
import java.util.UUID;

public class StartTimeObject {
    private long startTime;
    private StartTimeObjectType type;
    private String instanceId;
    private boolean parallel;
    private String executionPoint;

    public long getStartTime() {
        return this.startTime;
    }

    public StartTimeObjectType getType() {
        return this.type;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public String getExecutionPoint() {
        return this.executionPoint;
    }

    private StartTimeObject() {
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public static StartTimeObject buildServiceStartTimeObject() {
        StartTimeObject sto = new StartTimeObject();
        sto.startTime = System.currentTimeMillis();
        sto.type = StartTimeObjectType.SERVICE;
        return sto;
    }

    public static StartTimeObject buildTransactionStartTimeObject(String connectionInstanceId) {
        StartTimeObject sto = new StartTimeObject();
        sto.startTime = System.currentTimeMillis();
        sto.type = StartTimeObjectType.TRANSACTION;
        sto.instanceId = connectionInstanceId;
        sto.parallel = true;
        return sto;
    }

    public static StartTimeObject buildDataObjectStartTimeObject(Document doc, String executionPoint) {
        String instanceId = UUID.randomUUID().toString();
        doc.putExpandData(StartTimeObject.class.getName(), (Object)instanceId);
        StartTimeObject sto = new StartTimeObject();
        sto.startTime = System.currentTimeMillis();
        sto.type = StartTimeObjectType.DATAOBJECT;
        sto.instanceId = instanceId;
        sto.executionPoint = executionPoint;
        return sto;
    }

    public static StartTimeObject buildSqlExectionStartTimeObject() {
        StartTimeObject sto = new StartTimeObject();
        sto.startTime = System.currentTimeMillis();
        sto.type = StartTimeObjectType.SQLEXECUTION;
        return sto;
    }

    public static enum StartTimeObjectType {
        SERVICE(10),
        TRANSACTION(20),
        DATAOBJECT(30),
        SQLEXECUTION(40);

        private int value;

        private StartTimeObjectType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

