/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.auth.aspect;

import com.bokesoft.distro.tech.bootsupport.starter.auth.strage.PermissionCheckerRegistry;
import com.bokesoft.distro.tech.commons.basis.auth.annotation.Logical;
import com.bokesoft.distro.tech.commons.basis.auth.annotation.PermissionCheck;
import com.bokesoft.distro.tech.commons.basis.auth.annotation.RequiresPermission;
import com.bokesoft.distro.tech.commons.basis.auth.exception.NoPermissionException;
import java.util.Arrays;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PermissionAspect {
    private final PermissionCheckerRegistry permissionCheckerRegistry;

    public PermissionAspect(PermissionCheckerRegistry permissionCheckerRegistry) {
        this.permissionCheckerRegistry = permissionCheckerRegistry;
    }

    @Before(value="@annotation(requiresPermission)")
    public void checkPermission(RequiresPermission requiresPermission) {
        Logical logical = requiresPermission.logical();
        if (logical == Logical.NONE) {
            return;
        }
        PermissionCheck[] PermissionChecks = requiresPermission.value();
        boolean hasPermission = false;
        if (logical == Logical.ALL) {
            hasPermission = Arrays.stream(PermissionChecks).allMatch(permissionCheck -> this.permissionCheckerRegistry.get(permissionCheck.strategy()).hasPermission(permissionCheck.permission()));
        }
        if (logical == Logical.ANY) {
            hasPermission = Arrays.stream(PermissionChecks).anyMatch(permissionCheck -> this.permissionCheckerRegistry.get(permissionCheck.strategy()).hasPermission(permissionCheck.permission()));
        }
        if (!hasPermission) {
            throw new NoPermissionException();
        }
    }
}

