/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.api.ctx;

import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigerContext {
    private static final Logger log = LoggerFactory.getLogger(ConfigerContext.class);
    private static final String FILENAME_CORE_PROPERTIES = "core.properties";
    private static final String PROP_PARA_PREFIX = "PARA.";
    private static final String PROP_IMPL = "IMPL";
    private static final String PROP_PRIMARY = "PRIMARY";
    private static final String PROP_SOLUTIONS = "SOLUTIONS";
    private Map<String, String> additionalFiles = new HashMap<String, String>();
    private String primarySolutionName = null;

    private void addFile(String fileName, String content) {
        this.additionalFiles.put(fileName, content);
    }

    private void addFile(String fileName, Properties properties) {
        try (StringWriter w = new StringWriter();){
            properties.store(w, "Modified by " + this.getClass().getName());
            String content = ((Object)w).toString();
            this.addFile(fileName, content);
        }
        catch (IOException e) {
            throw MiscUtil.toRuntimeException((Throwable)e);
        }
    }

    public synchronized void addSolution(String solutionName, Class<? extends IMetaResolverFactory> resolverFac, Map<String, String> properties) {
        this.addSolution(solutionName, false, resolverFac, properties);
    }

    public synchronized void addSolution(String solutionName, boolean asPrimary, Class<? extends IMetaResolverFactory> resolverFac, Map<String, String> properties) {
        String fileName = solutionName + ".properties";
        if (null == properties) {
            properties = new HashMap<String, String>();
        }
        Properties target = new Properties();
        for (Map.Entry<String, String> en : properties.entrySet()) {
            String key = PROP_PARA_PREFIX + en.getKey();
            String val = en.getValue();
            target.setProperty(key, val);
        }
        target.setProperty(PROP_IMPL, resolverFac.getName());
        if (asPrimary) {
            if (null == this.primarySolutionName) {
                this.primarySolutionName = solutionName;
                target.setProperty(PROP_PRIMARY, Boolean.TRUE.toString());
                log.info("\u5df2\u5c06 Solution '{}' \u8bbe\u7f6e\u4e3a\u4e3b Solution .", (Object)solutionName);
            } else {
                throw new UnsupportedOperationException("\u65e0\u6cd5\u8bbe\u7f6e '" + solutionName + "' \u4e3a\u4e3b Solution: \u4e0e\u5f53\u524d\u4e3b Solution \u8bbe\u7f6e '" + this.primarySolutionName + "' \u51b2\u7a81");
            }
        }
        this.addFile(fileName, target);
        String core = this._getFile(FILENAME_CORE_PROPERTIES);
        MiscUtil.$assert((boolean)StringUtils.isBlank((CharSequence)core), (String)("\u672a\u627e\u5230 core.properties, \u65e0\u6cd5\u6267\u884c addSolution '" + solutionName + "'"));
        Properties coreProp = new Properties();
        try (StringReader r = new StringReader(core);){
            coreProp.load(r);
        }
        catch (IOException e) {
            throw MiscUtil.toRuntimeException((Throwable)e);
        }
        String solutions = coreProp.getProperty(PROP_SOLUTIONS);
        if (StringUtils.isBlank((CharSequence)solutions)) {
            coreProp.setProperty(PROP_SOLUTIONS, solutionName);
        } else {
            coreProp.setProperty(PROP_SOLUTIONS, solutions + "," + solutionName);
        }
        this.addFile(FILENAME_CORE_PROPERTIES, coreProp);
    }

    private String _getFile(String fileName) {
        String content = this.additionalFiles.get(fileName);
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            return content;
        }
        return this.getFile(fileName);
    }

    public abstract String getFile(String var1);

    public Map<String, String> getAdditionalFiles() {
        return this.additionalFiles;
    }
}

