package com.bokesoft.distro.tech.bootsupport.starter.utils;

import java.util.ArrayList;

public class URLPathUtils {

    /**
     * 拼接url, 自动处理分隔符
     * @param url
     * @param nexts
     * @return
     */
    public static String get(String url, String... nexts) {
        ArrayList<String> list = new ArrayList<>();
        list.add(removeTailSep(url));
        for (String next : nexts) {
            list.add(removeHeadSep(removeTailSep(next)));
        }
        return String.join("/", list);
    }

    /**
     * 移除最后的分隔符, 如果没有分隔符, 则返回原字符串
     * @param txt
     * @return
     */
    public static String removeTailSep(String txt) {
        if (txt.endsWith("/")) {
            return txt.substring(0, txt.length() - 1);
        } else
            return txt;
    }

    /**
     * 移除开头的分隔符, 如果没有分隔符, 则返回原字符串
     * @param txt
     * @return
     */
    public static String removeHeadSep(String txt) {
        if (txt.startsWith("/")) {
            return txt.substring(1);
        } else
            return txt;
    }

    /**
     * 从url中获取相对baseUrl的相对路径
     * @param url
     * @param baseUrl
     * @return
     */
    public static String relativizeOf(String url, String baseUrl) {
        if (url.startsWith(baseUrl)) {
            String tail = url.substring(baseUrl.length());
            return tail.startsWith("/") ? tail : "/" + tail;
        }
        throw new IllegalArgumentException("url [" + url + "] is not start with baseUrl [" + baseUrl + "]");
    }

}
