package com.bokesoft.distro.tech.bootsupport.starter.readonly.intf;

import com.bokesoft.distro.tech.bootsupport.starter.config.ReadOnlyDbCheckConfig;
import com.bokesoft.distro.tech.bootsupport.starter.readonly.struc.DBWatchData;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.DBType;

public interface IDBWatcher {

    /**
     * 执行只读服务的健康检查
     * @param context Yigo运行上下文
     * @param config 只读服务的健康检查的配置
     * @return 不允许返回 null (返回 null 视同 watcher 处理错误,系统将会置为不可用)
     * @throws Throwable
     */
    public DBWatchData doCheck(DefaultContext context, ReadOnlyDbCheckConfig config) throws Throwable;

    /**
     * 根据数据库类型,参考{@link DBType},判断是否适配
     * @param dbType
     * @return
     */
    public boolean support(int dbType);
}