package com.bokesoft.distro.tech.bootsupport.yigoconfig.configurer;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoBootPreparator;
import com.bokesoft.distro.tech.bootsupport.starter.utils.YigoPropPreparationHelper;
import com.bokesoft.distro.tech.bootsupport.yigoconfig.config.YigoConfigBean;
import com.bokesoft.distro.tech.bootsupport.yigoconfig.config.struc.SolutionConfig;
import com.bokesoft.yes.mid.event.EventListener;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.event.YigoEventFacade;
import com.bokesoft.yigo.mid.event.types.meta.factory.PrimarySettingPostLoadEvent;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

/**
 * spring boot 环境下启动yigo时，会进行一些准备工作
 * {@see com.bokesoft.distro.tech.bootsupport.starter.runtime.YigoInstanceManager#bootPrepare(org.springframework.context.ApplicationContext, boolean)}
 *
 * 在yigo启动前注册{@link com.bokesoft.yigo.mid.event.types.meta.factory.PrimarySettingPostLoadEvent}事件监听器，用于在yigo启动时及时设置solution 的 data-path
 */
@Configuration
public class SolutionDataPathConfigurer implements YigoBootPreparator {

    private static final Logger logger = LoggerFactory.getLogger(SolutionDataPathConfigurer.class);

    private final YigoConfigBean yigoConfig;

    public SolutionDataPathConfigurer(YigoConfigBean yigoConfig) {
        this.yigoConfig = yigoConfig;
    }

    @Override
    public void prepare(YigoPropPreparationHelper.PrepareResult prepareResult) {
        YigoEventFacade.registerListener(new SolutionDataPathInitListener());
    }


    /**
     * yigo启动时，会触发{@link com.bokesoft.yigo.mid.event.types.meta.factory.PrimarySettingPostLoadEvent}事件
     *
     */
     class SolutionDataPathInitListener implements EventListener<PrimarySettingPostLoadEvent> {

        @Override
        public void handleEvent(PrimarySettingPostLoadEvent event) {
            IMetaFactory metaFactory = event.getMetaFactory();
            try {
                setSolutionDataPath(metaFactory, yigoConfig.getSolution());
            } catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        /**
         * 设置 solution data-path
         */
        private void setSolutionDataPath(IMetaFactory metaFactory, SolutionConfig solutionConfig) throws Throwable {
            if (null != solutionConfig) {
                String dataPath = solutionConfig.getDataPath();
                if (StringUtils.isNotBlank(dataPath)) {
                    metaFactory.getSolution().setDataPath(dataPath);
                    if (logger.isInfoEnabled()) {
                        logger.info("加载 Yigo 程序: 强制设置 DataPath='{}' .", dataPath);
                    }
                }
            }
        }
    }


}
