/**
 * 额外的特殊样式
*/
let style = document.createElement('style')
style.setAttribute('type', 'text/css');
let cssStr = `
    /* from ux-yigo-spring-boot-starter.jar */

    /* 个性化设置界面，二级标题定制的样式*/
    div.ui-control.ui-lbl.ux-default-individuality-subtitle {
        padding-top: 0 !important;
        overflow: unset;

        height: 0.8rem !important;
        border-bottom: 0.1em solid #dddddd;
        justify-content: center;
    }
    
    div.ui-control.ui-lbl.ux-default-individuality-subtitle > label {
        width: auto;
        height: 1.5em;
        padding: 0 2em;

        background-color: white;

        font-size: 1.2em !important;
        letter-spacing: 0.1em;
    }
    
    div.ui-btn.ui-control.ux-default-individuality-button {
        font-size: 1.166rem;
        width: 1.5em;
        height: 1.5em        
    }

    div.ui-btn.ui-control.ux-default-individuality-button > button {
        text-overflow: clip;
        text-align: center;
        border: 0;

        font-size: 1rem;
    }

    div.ui-btn.ui-control.ux-default-individuality-button > button > span.txt {
        overflow: unset;
        
        padding: 0;
        margin: 0;
    }

    div.ui-btn.ui-control.ux-default-individuality-button > button > span.txt:after {
        width: auto;
        height: 1.5em;
        line-height: 1.5em;

        font-family: 'iconfont';
        font-size: 1.3em;
    }

    div.ui-btn.ui-control.ux-default-individuality-button.Ok > button > span.txt:after {
        content: '\\F375';
    }
 
    div.ui-btn.ui-control.ux-default-individuality-button.Cancel > button > span.txt:after {
        content: '\\F379';        
    }
`;
style.innerHTML = cssStr;
document.head.appendChild(style);

function appendOwnerDrawStyle() {
    if (!YIUI.YesOwnerDraw) { // 检测是否存在自绘支持
        return;
    }

    style.innerHTML += `
        div.cmb-tiled.default-individuality-colorgroup
        , div.cmb-tiled.default-individuality-fontscheme
        , div.cmb-tiled.default-individuality-navbar {
            overflow: hidden;
        }

        /* 颜色选择下拉 */
        div.cmb-tiled.default-individuality-colorgroup ul.cmb-ul {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            padding: 10px;
        }

        div.cmb-tiled.default-individuality-colorgroup li {
            position: relative;
            margin: 0 15px 20px 15px;
            overflow: unset;

            width: 40px;
            height: 40px;

            cursor: pointer;
            transition: transform 0.2s;
        }

        div.cmb-tiled.default-individuality-colorgroup li:hover {
            box-shadow: 0 0 5px 0 black;
            -moz-box-shadow: 0 0 5px 0 black;
            -webkit-box-shadow: 0 0 5px 0 black;
            transform: scale(1.1);    
        }

        div.cmb-tiled.default-individuality-colorgroup li.checked {
            box-shadow: 0 0 5px 0 black;
            -moz-box-shadow: 0 0 5px 0 black;
            -webkit-box-shadow: 0 0 5px 0 black;
        }

        div.cmb-tiled.default-individuality-colorgroup li.checked:before {
            left: 15.5px;
            bottom: -12px;

            background-color: green;
            width: 8px;
            height: 8px;
            border-radius: 50%;

            transform: rotate(0);
        }

        div.cmb-tiled.default-individuality-colorgroup li.checked:after {
            content: " ";
        }

        /* 字体选择下拉 */
        div.cmb-tiled.default-individuality-fontscheme ul.cmb-ul {
            display: flex;
            flex-wrap: nowrap;
            justify-content: space-between;
            overflow: hidden;

            background-image: linear-gradient(to right, #eeeeee, #eeeeee);
            background-size: 3px 3px;
            background-repeat: repeat-x;
            background-position: 0 10px;
        }

        div.cmb-tiled.default-individuality-fontscheme li {
            overflow: visible;
            text-align: center;

            width: auto;
            height: auto;
            line-height: 1.5em;

            background-color: transparent;

            cursor: pointer;
        }

        div.cmb-tiled.default-individuality-fontscheme li:hover > div.point {
            border: 2px solid rgb(155, 94, 244);
        }

        div.cmb-tiled.default-individuality-fontscheme li > div.point {
            display: inline-block;

            width: 20px;
            height: 20px;

            background-color: white;
            border: 3px solid #eeeeee;

            border-radius: 50%;
            pointer-events: none;
        }

        div.cmb-tiled.default-individuality-fontscheme li.checked {
            background-color: transparent;
        }

        div.cmb-tiled.default-individuality-fontscheme li.checked:before {
            background-color: transparent;
        }

        div.cmb-tiled.default-individuality-fontscheme li.checked:after {
            content: "";
        }

        div.cmb-tiled.default-individuality-fontscheme li.checked > div.point {
            border: 3px solid rgb(155, 94, 244);
        }

        div.cmb-tiled.default-individuality-fontscheme li > div.caption {
            pointer-events: none;
        }

        /* 菜单栏选择下拉 */
        div.cmb-tiled.default-individuality-navbar ul.cmb-ul {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            padding: 10px;
        }

        div.cmb-tiled.default-individuality-navbar li {
            position: relative;
            margin: 0 15px 20px 15px;
            overflow: unset;

            width: 60px;
            height: 45px;

            background-size: cover !important;
            background-repeat: no-repeat !important;
            background-position: center !important;

            cursor: pointer;
            transition: transform 0.2s;
        }

        div.cmb-tiled.default-individuality-navbar li:hover {
            box-shadow: 0 0 5px 0 black;
            -moz-box-shadow: 0 0 5px 0 black;
            -webkit-box-shadow: 0 0 5px 0 black;
            transform: scale(1.1);    
        }

        div.cmb-tiled.default-individuality-navbar li.checked {
            box-shadow: 0 0 5px 0 black;
            -moz-box-shadow: 0 0 5px 0 black;
            -webkit-box-shadow: 0 0 5px 0 black;
        }

        div.cmb-tiled.default-individuality-navbar li.checked:before {
            left: 28px;
            bottom: -12px;

            background-color: green;
            width: 8px;
            height: 8px;
            border-radius: 50%;

            transform: rotate(0);
        }

        div.cmb-tiled.default-individuality-navbar li.checked:after {
            content: " ";
        }
    `;
}

function waitYIUIReady() {
    if (window.Expr && window.View) {
        appendOwnerDrawStyle();
    } else {
        //FIXME 目前无法准确判定 YIUI 加载完成
        setTimeout(waitYIUIReady, 100);
    }
}
waitYIUIReady();

function appendMobileStyle() {
    if (_YigoUX_Utils.isMobile()) {
        style.innerHTML += `
        div.ui-cmb.cmb-tiled.default-individuality-colorgroup li{
            margin:5px 10px
        }
        `
    }    
}

// 等待utils工具加载完成
function waitUtilsReady() {
    if (window._YigoUX_Utils) {
        appendMobileStyle();
    } else {
        setTimeout(waitUtilsReady, 100);
    }
}
waitUtilsReady();
