(function () {

    function registerOwnerDraw() {
        if (!YIUI.YesOwnerDraw) { // 检测是否存在自绘支持
            return;
        }
    
        YIUI.YesOwnerDraw.Service.reg('default-individuality-colorgroup', (context, el) => {
            if (context.getType() == YIUI.YesOwnerDraw.Types.ITEM_OWNER_DRAW) {
                let item = context.getItem();

                if (typeof jQuery != 'undefined' && el instanceof jQuery) {
                    el.css('background-color', getColorValueByName(context, item.value));
                    el.text('');
                } else { // DOM
                    el.innerText = ``;
                    el.style.backgroundColor = getColorValueByName(context, item.value);
                }

                return true;
            } else {
                return false; // 忽略自绘过程，继续执行默认绘制
            }
        }, '个性化设置，色调下拉，自定义绘制');

        YIUI.YesOwnerDraw.Service.reg('default-individuality-fontscheme', (context, el) => {
            if (context.getType() == YIUI.YesOwnerDraw.Types.ITEM_OWNER_DRAW) {
                let item = context.getItem();

                if (typeof jQuery != 'undefined' && el instanceof jQuery) {
                    el.text('');
                    el.append(`
                        <div class="point"></div>
                        <div class="caption" style="font-size: ${(1 + item.index * 0.1)}em">${item.caption}</div>
                    `);
                } else { // DOM         
                    el.innerHTML= `
                        <div class="point"></div>
                        <div class="caption" style="font-size: ${(1 + item.index * 0.1)}em">${item.caption}</div>
                    `;
                }

                return true;
            } else {
                return false; // 忽略自绘过程，继续执行默认绘制
            }
        }, '个性化设置，字体大小，自定义绘制');

        YIUI.YesOwnerDraw.Service.reg('default-individuality-navbar', (context, el) => {
            if (context.getType() == YIUI.YesOwnerDraw.Types.ITEM_OWNER_DRAW) {
                let item = context.getItem();

                if (typeof jQuery != 'undefined' && el instanceof jQuery) {
                    el.css('background-image', getImageUrlByNavbarName(item.value));
                    el.text('');
                } else { // DOM                
                    el.innerText = ``;
                    el.style.backgroundImage = getImageUrlByNavbarName(item.value);
                }

                return true;
            } else {
                return false; // 忽略自绘过程，继续执行默认绘制
            }
        }, '个性化设置，菜单栏，自定义绘制');

        /**
         * 依据当前的主题选择，将颜色名称转换为颜色值
         * @param {*} context 
         * @param {*} name 
         * @returns 
         */
        let getColorValueByName = function(context, name) {
            // check
            if (!name) {
                return;
            }

            // Get theme setting
            let form = window.YIUI.FormStack.getForm(context._formId);
            let themeName = form && form.getComponent("cbThemeName") && form.getComponent("cbThemeName").getValue();;
            var theme = getThemePackageByName(themeName);
            if (!theme) {
                return;
            }

            // Get color by name 
            if (theme.colorPalette == "Monochromatic"){
                var colors = theme.colorGroups||[];
                for (let color of colors) {
                    if (color.name == name) {
                        return color.brandColor;
                    }
                }
            }

        }

        /**
         * 依据主题名称获取主题配置
         * @param {*} name 
         * @returns 
         */
        let getThemePackageByName = function(name) {
            let settings = _YigoUX_Utils.getSettings();
            if ((typeof settings != 'object')
                || (typeof settings.avaliableThemes != 'object')) {
                return;
            }

            let avaliableThemes = settings.avaliableThemes;
            for (let theme of avaliableThemes) {
                if (theme.name == name) {
                    return theme;
                }
            }
        }

        /**
         * 依据名称获取导航栏对应图片url
         * @param {*} name 
         * @returns 
         */
        let getImageUrlByNavbarName = function (name) {
            let settings = _YigoUX_Utils.getSettings();
            if ((typeof settings != 'object')
                || (typeof settings.avaliableNavbars != 'object')) {
                return;
            }

            for (let navbar of settings.avaliableNavbars) {
                if (name == navbar.name) {
                    return navbar.iconUrl;
                }
            }
        }        
    }

    function waitYIUIReady() {
        if (window.Expr && window.View) {
            registerOwnerDraw();
        } else {
            //FIXME 目前无法准确判定 YIUI 加载完成
            setTimeout(waitYIUIReady, 100);
        }
    }
    waitYIUIReady();
}());
