export function formRender (options) {
    var Return = {
        formKey: options.formKey,
        parameters: options.parameters || {},
        transmitParas: options.transmitParas || "",
        OID: options.OID || -1,
        formula: options.formula,
        formID: null,
        path : options.path,

        doLayout: function (width, height) {
            //var form = YIUI.FormStack.getForm(this.formID);
            this.form.getRoot().doLayout(width, height);
        },
        render: function (ct) {
            if ($.isString(ct)) {
                ct = $("#" + ct);
            }
            var self = this;
            ct.el = ct;

            ct.renderDom = function (form) {
                form.getRoot().render(this);
                form.rendered = true;
                if (self.formula) {
                    var cxt = new View.Context(form);
                    form.eval(self.formula, cxt);
                }

            };
            ct.build = function (form) {
                this.empty();
                if (self.formID && self.formID != form.formID) {
                    YIUI.FormStack.removeForm(ct.formID);
                }
                form.setContainer(this);
                self.formID = form.formID;
            };
            ct.removeForm = function (form) {
                this.empty();
                YIUI.FormStack.removeForm(form.formID);
                if ($.isFunction(ct.close)) {
                    ct.close();
                }
            };

            var splitPara = function (para) {
                if (!para) {
                    return null;
                }
                var mapCallback = {};
                para = YIUI.TypeConvertor.toString(para);
                var paras = para.split(';');
                paras.forEach((item,i)=>{
                    var arr = item.split('=');
                    mapCallback[arr[0]] = arr[1];
                })
                return mapCallback;
            };

            var pushPara = function (newForm) {
                if (self.transmitParas) {
                    var tsParas = splitPara(self.transmitParas);    
                    for (var key in tsParas) {  
                        newForm.setPara(key,tsParas[key]);
                    }
                }
            };

            var builder = new YIUI.YIUIBuilder(this.formKey);
           
            builder.setContainer(ct);

            if (this.OID > -1) {
                builder.setOperationState(YIUI.Form_OperationState.Default);

                builder.newEmpty().then(function (emptyForm) {
                    self.form = emptyForm;

                    emptyForm.getFilterMap().setOID(self.OID);

                    pushPara(emptyForm);
                    
                    emptyForm.setOptQueue(
                        new YIUI.OptQueue(new YIUI.LoadOpt(emptyForm))
                    );

                    builder.builder(emptyForm).then(form=>{
                        self.form = form;
                    });
                });
            } else {
                builder.setOperationState(YIUI.Form_OperationState.New);

                builder.newEmpty().then(function (emptyForm) {
                    pushPara(emptyForm);
                    emptyForm.entryParas = self.transmitParas;
                    emptyForm.setOptQueue(
                        new YIUI.OptQueue(new YIUI.NewOpt(emptyForm))
                    );

                    builder.builder(emptyForm).then(form=>{
                        self.form = form;
                    });
                });
            }
        }
    };
    return Return;
};

