(function () {
    YIUI.MainTree = {
        ...YIUI.MainTree || {}
    }
    YIUI.MainTree.default = function (rootEntry, dom, mainframe4Nav) {
        $("ul.tm", dom).remove();
        var el = $("<ul></ul>").addClass("tm").appendTo(dom);
        var options = {
            el: el,
            _open: false,
            menuType: rootEntry.style,
            _openedItem: null,
            _data: [],
            isSliding: false, //树是否正在展开和收缩的运动中
            rootEntry: rootEntry,
            clickEvent: {
                expandNode: function ($this, self) {
                    //展开和收缩的运动中不操作
                    if (self.isSliding) return;
                    
                    //展开
                    var nodeId = $this.attr("id");
                    var node = self.getTreeNode(nodeId);
                    self.callback.beforeExpand(node);
                    
                    if (!node.isLoaded) {
                        node.isLoaded = true;
                    }
                    var isSm = $(".mainLeft.mainLeft-sm").length ? true : false;
                    
                    var $wrap = $this.next();
                    if ($wrap.length) {
                        if (isSm) {
                            $this.next().css("display", "inline-block");
                        } else {
                            self.isSliding = true;
                            $wrap.slideDown();
                            setTimeout(()=>{
                                self.isSliding = false;
                            },400)
                        }
                    }

                    $this
                        .removeClass("close collapse")
                        .addClass("open expand cursel");
                    $this.parent().addClass("sel");
                    var close =
                        YIUI.closeOtherEntry == undefined
                            ? true
                            : YIUI.closeOtherEntry;
                    //YIUI.closeOtherEntry 控制其他菜单是否收缩
                    var $nodes = $this
                            .parent()
                            .siblings()
                            .find(".open.expand");
                    var $otherWrap = $nodes.next()
                    
                    if(isSm){
                        toggleClass();
                        $otherWrap.hide();
                    } else if(close){
                        toggleClass();
                        if(!$otherWrap.length) return;
                        self.isSliding = true;
                        $otherWrap.slideUp(); 
                        setTimeout(()=>{
                            self.isSliding = false;
                        },400)
                    } 

                    function toggleClass(){
                        $nodes.removeClass("open expand cursel").addClass("close collapse");
                    }

                },

                collapse: function ($this, self) {
                    //展开和收缩的运动中不操作
                    if (self.isSliding) return;
                    //console.log('collapse')
                    //up
                    if (!$this.has("open expand")) return;
                    var $wrap = $this
                        .parent()
                        .removeClass("sel")
                        .find(".open.expand")
                        .removeClass("open expand cursel")
                        .addClass("close collapse")
                        .next();
                    //$(".mainLeft.mainLeft-sm").length ? $ul.hide() : $ul.slideUp();
                    if ($wrap.length) {
                        if ($(".mainLeft.mainLeft-sm").length) {
                            $wrap.hide();
                        } else {
                            self.isSliding = true;
                            $wrap.slideUp();
                            setTimeout(()=>{
                                self.isSliding = false;
                            },400)
                        }
                    }
                },

                selectNode: function ($this, self) {
                    var id = $this.attr("id");
                    if (self.selectedNodeId) {
                        var node = document.getElementById(self.selectedNodeId);
                        var $node = $(node);
                        $node.removeClass("clicked");
                        $node.parent().removeClass("clicked");
                        var $clickNode = $("a.noExpand.clicked");
                        //预防id一样导致没有删掉class
                        if ($clickNode.length != 0) {
                            $clickNode.removeClass("clicked");
                            $clickNode.parent().removeClass("clicked");
                        }
                    }
                    self.selectedNodeId = id;
                    $this.addClass("clicked");
                    $this.parent().addClass("clicked");
                    var path = $this.parent().attr("path");
                    self.callback.onSelect(
                        $this,
                        self.el,
                        self.getTreeNode("", path)
                    );
                },
            },
            callback: $.extend({
                beforeExpand: $.noop,
                onSelect: function ($this, $tree, node) {
                    if (node.children) {
                        if (self.menuType == YIUI.TREEMENU_TYPE.GROUPTREE) {
                            $("#" + node.id + " span.icon").click();
                        } else if (self.menuType == YIUI.TREEMENU_TYPE.TREE) {
                            if ($("#" + node.id).attr("open")) {
                                self.clickEvent.collapse($this, self, null);
                                $("#" + node.id).attr("open", false);
                                $(this).removeClass("cursel");
                                $(this).parent().removeClass("sel");
                            } else {
                                self.clickEvent.expandNode($this, self, null);
                                $("#" + node.id).attr("open", true);
                                $(this).addClass("cursel");
                                $(this).parent().addClass("sel");
                            }
                        }
                    } else {
                        //var fn = YIUI.EventHandler.doTreeClick(node, container);
                        var fn = mainframe4Nav.menuClick(node);
                        if (fn && typeof fn["promise"] === "function") {
                            fn.then(
                                function () {},
                                function (e) {
                                    throw e;
                                },
                                function () {}
                            );
                        }

                        // YIUI.EventHandler.doTreeClick(node, container).fail(function(e){
                        // 	throw e;
                        // });
                    }
                },
            }),
            getTreeNode: function (nodeId, path) {
                if (path) {
                    for (var i = 0, len = this._data.length; i < len; i++) {
                        if (this._data[i].path == path) {
                            return this._data[i];
                        }
                    }
                } else {
                    for (var i = 0, len = this._data.length; i < len; i++) {
                        if (this._data[i].id == nodeId) {
                            return this._data[i];
                        }
                    }
                }
            },
            initDataSource: function (dataSource) {
                if (dataSource) {
                    if (!dataSource.length) {
                        dataSource = $(dataSource);
                    }
                    var data;
                    for (var i = 0, len = dataSource.length; i < len; i++) {
                        data = dataSource[i];
                        if (!data.id) {
                            data.id = data.key + i;
                        }
                        if (data.children) {
                            data.isParent = true;
                            this.initDataSource(data.children);
                        }
                    }
                }
            },
            dataSourceCopy: function (dataSource, parentID, parentVisible) {
                if (dataSource) {
                    if (!dataSource.length) {
                        dataSource = $(dataSource);
                    }
                    var visible;
                    for (var i = 0, len = dataSource.length; i < len; i++) {
                        var ds = dataSource[i];
                        var parent = ds.parent;
                        var d = new Object();
                        d.name = ds.name;
                        d.id = ds.id;
                        d.itemKey = ds.itemKey;
                        d.layerItemKey = ds.layerItemKey;
                        if (ds.isLoaded) {
                            d.isLoaded = ds.isLoaded;
                        } else {
                            d.isLoaded = false;
                        }

                        if (parentVisible === false) {
                            visible = false;
                        } else {
                            visible = !ds.visible
                                ? true
                                : this.calcBoolean(ds.visible);
                        }

                        ds._visible = visible;
                        d._visible = visible;

                        if (ds.children && ds.children.length > 0) {
                            d.open = ds.open;
                            var children = [];
                            for (
                                var j = 0, length = ds.children.length;
                                j < length;
                                j++
                            ) {
                                var child = ds.children[j];
                                children.push(child.id);
                                this.dataSourceCopy($(child), ds.id, visible);
                            }
                            d.children = children;
                        } else {
                            d.key = ds.key;
                            d.formKey = ds.formKey;
                            d.paras = ds.parameters;
                            d.single = ds.single;
                            d.target = ds.target;
                        }
                        d.path = ds.path;
                        if (ds.parent) {
                            d.parentId = ds.parent.id;
                        }

                        if (parentID) {
                            d.parentID = parentID;
                        }

                        this._data.push(d);
                    }
                }
            },
            /** 构建树结构 */
            buildTreenode: function (el, nodes, parentId) {
                if (!nodes) {
                    return;
                }
                if (!nodes.length) {
                    if (!parentId) {
                        nodes = nodes.children;
                    }
                }

                nodes && this.addChilds(nodes, parentId, 0, this);
            },

            calcBoolean: function (str) {
                if (!this.parser) {
                    this.parser = new View.Parser();
                }
                return this.parser.eval(str, new View.Context());
            },
            addChilds: function (nodes, parentId, level, options) {
                var $parent = null;
                if (parentId) {
                    var parent = document.getElementById(parentId);
                    $parent = $(parent);
                }
                if (nodes.length <= 0) {
                    if (parentId) {
                        $parent.next().remove();
                        $parent.children().first().removeClass("tm-collapse");
                    }
                    return;
                }

                //var node, nid,
                var isTree =
                    options.menuType != YIUI.TREEMENU_TYPE.GROUPTREE
                        ? true
                        : false;
                if (parentId) {
                    var parentNode = options.getTreeNode(parentId);
                    parentNode.children = [];
                }
                if (isTree) options.el.addClass("tree");

                var _this = this;
                $.each(nodes, function (key, node) {
                    var nid = node.id;
                    node.parentId = parentId;

                    if (!node._visible) return;

                    var _li = $(
                        "<li class='tm-node' level='" + level + "'></li>"
                    ).attr("path", node.path);
                    if (node.single) {
                        _li.attr("single", "true")
                            .attr("formKey", node.formKey)
                            .attr("paras", node.parameters);
                    }
                    if (node.target) {
                        _li.attr("target", node.target);
                    }
                    if (!node.parentId) {
                        _li.addClass("top-level");
                    }

                    if (node.appKey) {
                        _li.attr("appKey", node.appKey);
                    }
                    var isEnable = !node.enable
                        ? true
                        : _this.calcBoolean(node.enable);
                    if (!isEnable) {
                        _li.attr("enable", false);
                    }

                    if (parentId) {
                        parentNode.children.push(nid);
                        _li.appendTo($parent.next().find(".tm-ul").first());
                    } else {
                        _li.appendTo(options.el);
                    }

                    var _a = $(
                            "<a id='" +
                                nid +
                                "' class='tm-anchor' title='" +
                                node.name +
                                "'></a>"
                        ).appendTo(_li),
                        _div,
                        _ul;

                    if (node.isParent) {
                        //var disX = (level - 1) * 16 + 30;
                        var left = (level - 1) * 16 + 36;
                        _a.css({
                            //"backgroundPosition": disX ,
                            "padding-left": left + "px",
                        });
                    } else {
                        _a.css("padding-left", (level - 1) * 16 + 36);
                    }

                    if (node.isParent) {
                        _li.addClass("isparent");
                        _ul = $("<ul class='tm-ul'></ul>");
                        _div = $('<div class="tm-ul-wrap"></div>').append(_ul);

                        if (node.open && !options._isOpen && !node.parentId) {
                            _li.addClass("sel");
                            _a.addClass("cursel open expand").attr(
                                "open",
                                true
                            );
                            options._isOpen = true;
                            options._openedItem = _a;
                        } else {
                            _a.attr("open", false).addClass("close collapse");
                            _div.css("display", "none");
                        }
                        _div.appendTo(_li);
                    }

                    var _span = $(
                        "<span class='tm-name'>" + node.name + "</span>"
                    ).appendTo(_a);

                    if (node.icon) {
                        var _img = $("<img>");
                        _img.prependTo(_span);
                        _span.addClass("hasIcon");

                        new YIUI.Base64ImageService()
                            .loadBase64Image(node.icon)
                            .then(
                                function (src) {
                                    _img.attr("src", src);
                                },
                                function () {
                                    _img.remove();
                                    _span.removeClass("hasIcon");
                                    //_img.attr("src", window.cssPath + "/images/not-exist.png");
                                }
                            );
                    }

                    if (node.children) {
                        _this.addChilds(
                            node.children,
                            node.id,
                            level + 1,
                            options
                        );
                    } else {
                        _a.addClass("noExpand");
                    }
                });
            },

            install: function () {
                var self = this;
                self.el.delegate("a", "click", function (e) {
                    if ($(this).hasClass("open")) {
                        self.clickEvent.collapse($(this), self);
                        return false;
                    }
                    if ($(this).hasClass("close")) {
                        self.clickEvent.expandNode($(this), self);
                        return false;
                    }
                });
                //sm状态下目标移入2级菜单，显示3级菜单
                self.el.delegate("a", "mouseenter ", function (e) {
                    var $this = $(this),
                        isSm = $(".mainLeft.mainLeft-sm").length ? true : false,
                        $node = $this.parent("li");
                    if (
                        isSm &&
                        !$node.hasClass("top-level") &&
                        $node.hasClass("isparent")
                    ) {
                        self.clickEvent.expandNode($this, self);
                    }
                    return false;
                });

                //self.el mouseleave
                self.el.on("mouseleave", function (e) {
                    var isSm = $(".mainLeft.mainLeft-sm").length ? true : false;
                    if (isSm) {
                        $(".tm-anchor")
                            .removeClass("open expand")
                            .addClass("close collapse");
                        $(".tm-ul-wrap").hide();
                    }
                    return false;
                });

                var event = YIUI.openEntryByClick ? "click" : "dblclick";
                self.el.delegate("a", event, function () {
                    var $this = $(this),
                        isloading = $this.data("isloading");
                    if (!isloading && $this.hasClass("noExpand")) {
                        $this.data("isloading", true);
                        self.clickEvent.selectNode($this, self);
                        //sm菜单状态下，选中后隐藏列表
                        if ($(".mainLeft.mainLeft-sm").length) {
                            close($this);
                        }
                        setTimeout(function () {
                            $this.removeData("isloading");
                        }, 500);
                        return false;
                    }
                });
                //侧边栏sm状态下，单击打开tab页
                if (event != "click") {
                    self.el.delegate("a.noExpand", "click", function () {
                        var $this = $(this);
                        if ($(".mainLeft.mainLeft-sm").length) {
                            self.clickEvent.selectNode($this, self);
                            close($this);
                        }
                        return false;
                    });
                }

                function close($dom) {
                    $dom.closest("li[level=1]")
                        .closest("tm-ul-wrap")
                        .hide()
                        .prev()
                        .removeClass("open expand cursel")
                        .addClass("close collapse");
                }
            },

            init: function () {
                this.initDataSource(this.rootEntry);
                this.dataSourceCopy(this.rootEntry.children);
                this.buildTreenode(this.el, this.rootEntry);
                this.install();
            },
            // reload: function(entry) {
            // 	this.el.empty();
            // 	this._data = [];
            // 	this.initDataSource(entry);
            // 	this.dataSourceCopy(entry.children);
            // 	this.buildTreenode(this.el, entry);
            // }
            reload: function (rootEntry) {
                this.expandNodes = this.getExpandNodes();
                this.el.empty();
                this._data = [];
                this.initDataSource(rootEntry);
                this.dataSourceCopy(rootEntry.children);
                this.buildTreenode(el, rootEntry);
				this.expandSelectedNode();
            },
            getExpandNodes:function(){
                 var result= [];
                $('a.tm-anchor.open.expand.cursel').each((i,node)=>{
                    result.push($(node).attr('id'));
                })
                return result;
            },
			expandSelectedNode : function(){
				var id = this.selectedNodeId;
				var $node = $('#' + id);
                //处理删除添加相同节点的情况
                if($node.length){
                    var $nodeParent = $node.parent();
                    $node.addClass("clicked");
                    $nodeParent.addClass("clicked");
                }
                
                $.each(this.expandNodes,(i,id)=>{
                    var $node = $('#'+id);
                    $node.addClass('open expand cursel');
                    $node.parent('li').addClass('sel');
                    $node.next().show();
                })            
			}
        };
        options.init();
        return options;
    };
})();
