//引入util
import { loadcss } from "../ux/util/util.js";
//引入 instance tag 需要的 CSS
loadcss("./yesui/ux/instance-tag.css");

import "../ux/right-slide/index.js";
import { onceEventHandler, slideDown } from "../ux/util/util.js";
(function () {
    let el;
	let mainframe4Nav;
	let metaService = new YIUI.MetaService();
    function Navigation(container,mainframe) {
        this._init(container,mainframe);
    }

    Navigation.prototype = {
        constructor: Navigation,
        _init: function (container,mainframe) {
            el = container;
			mainframe4Nav = mainframe;
            formatNavOpt();
            createHTML(container);
            install();
        },
        resize: function () {
			let width = el.offsetWidth;
			let w = 
				el.querySelector('.nav-left').offsetWidth + 
				el.querySelector('.logo').offsetWidth + 
				el.querySelector('.logo-text').offsetWidth +
				el.querySelector('.nav-field-box.user').offsetWidth + 
				el.querySelector('.nav-field-box.setting').offsetWidth + 
				el.querySelector('.login_username').offsetWidth + 30;
			el.querySelector('.org_lbl').style.maxWidth = width - w + 'px';
		},
    };

    let navigationOption = {
        userActions: ["userProfile","modifyPwd","logout","exit"],
        settingActions: ["about"],
    };

    let avaliableNavActions = [
        {
            name: "logout",
            caption: "登出",
            actionType: "Buildin",
            buildinCommand: "logout",
        },
        {
            name: "exit",
            caption: "退出",
            actionType: "Buildin",
            buildinCommand: "exit",
        },
        {
            name: "modifyPwd",
            caption: "修改密码",
            actionType: "Buildin",
            buildinCommand: "modifyPwd",
        },
        {
            name: "userProfile",
            caption: "个性化设置",
            actionType: "Buildin",
            buildinCommand: "userProfile",
        },
        {
            name: "about",
            caption: "系统信息",
            actionType: "Buildin",
            buildinCommand: "about",
        },
    ];

    function formatNavOpt() {
        if (
            !YigoClientPageVariable ||
            !YigoClientPageVariable.YigoClassicUxSetting
        ) {
            return;
        }
        navigationOption =
            YigoClientPageVariable.YigoClassicUxSetting.navigationOption ||
            navigationOption;
        avaliableNavActions =
            YigoClientPageVariable.YigoClassicUxSetting.avaliableNavActions ||
            avaliableNavActions;
		//过滤
		let actionNameList = avaliableNavActions.map(item=>item.name);
		for (let key in navigationOption) {
			navigationOption[key] = navigationOption[key].filter(v => {
				if (v == "-") return true;
				return actionNameList.includes(v)
			})
			removeRepeatLine(navigationOption[key]);
		}

		function removeRepeatLine(arr){
			for(let i = 0; i < arr.length; i++){
				if( arr[i] =="-" && arr[i+1] && arr[i] == arr[i+1]){
					arr.splice(i,1);
					i--;
				}
			}
			//去头尾
			if(arr[0] == '-'){
				arr.shift();
			}
			if(arr[arr.length - 1] == '-'){
				arr.pop();
			}
		}

    }

    function createHTML(container) {
        createLeftSection(container);
        createLogoText(container);
        createRightSection(container);
		createInstanceTag(container)
    }

    function createLeftSection(container) {
        const oLeft = createNode("div", "nav-left");
        createAppBox(oLeft);
        createLogo(oLeft);
        container.appendChild(oLeft);
    }

    function createAppBox(container) {
        const oAppBox = createNode("div", "app-box");
        const oAppBtn = createNode("div", "app-box-btn");
        const oAppItems = createNode("div", "appItems");
        const oUl = createNode("ul");
		createApp(oUl);
        oAppBox.appendChild(oAppBtn);
        oAppBox.appendChild(oAppItems);
        oAppItems.appendChild(oUl);
		
        container.appendChild(oAppBox);
    }

    function createLogo(container) {
        const oLogo = createNode("div", "logo");
        container.appendChild(oLogo);
    }

    function createLogoText(container) {
        const oLogoText = createNode("span", "logo-text");
        oLogoText.innerText = YIUI.I18N.getString(
            "NAVIGATION_APPLICATION",
            "Yigo应用"
        );
        container.appendChild(oLogoText);
    }

    function createRightSection(container) {
        const oRight = createNode("div", "navRight");
        const oOrg = createNode("label", "org_lbl");
        const oUsername = createNode("span", "login_username");
		const user_name = JSON.parse(sessionStorage.getItem("SESSIONPARAS"))['_yigo_userName'];
		oUsername.innerText = user_name || YIUI.I18N.getString("NAVIGATION_USERNAME","Unknown");
        createFieldSection(oRight, "user", navigationOption.userActions);
        createFieldSection(oRight, "setting", navigationOption.settingActions);

        oRight.appendChild(oOrg);
        oRight.appendChild(oUsername);
        container.appendChild(oRight);
    }

    function createFieldSection(container, name, actions) {
        const oBox = createNode("div", "nav-field-box " + name);
        const oBtn = createNode("div", "nav-field-btn");
        const oContent = createNode("div", "nav-field-content");
        const oUl = createNode("ul", "nav-field-list");
        actions.forEach((name) => {
            if (name == "-") {
                createSeparateLink(oUl);
            } else {
                createActionItem(name, oUl);
            }
        });
        oContent.appendChild(oUl);
        oBox.appendChild(oBtn);
        oBox.appendChild(oContent);
        container.appendChild(oBox);
    }

    function createSeparateLink(container) {
        const oLink = createNode("li", "nav-field-separateLink");
        container.append(oLink);
    }

    function createActionItem(name, container) {
        const action = getAvaliableNavActionByName(name);
        const oLi = createNode("li", "nav-field-items");
        const oA = createNode("a", name);
        oA.innerText = action.caption;
        oLi.appendChild(oA);
        container.append(oLi);
		oA.addEventListener('click',actionItemclickHandler.bind(oA,action))
    }

    function createInstanceTag(container) { // 右上角的当前系统性质，比如开发版DEV
		// Get setting
		let setting = YigoClassicUxSetting && YigoClassicUxSetting.mainFrameDecoration && YigoClassicUxSetting.mainFrameDecoration.instanceTagImageUrl;
		if (!setting) { // invalid setting
			return;
		}	

		// create
		let getDefaultTagName = function(name) {
			let tags = ['DEV', 'GRP', 'ITS', 'PRD', 'PRE', 'QAS', 'RTS', 'SDB', 'TRN', 'UAT'];

			for (let i=0; i<tags.length; i++) {
				if (name.trim().toUpperCase() == tags[i]) {
					return tags[i];
				}
			}
		};
		let createDefaultTag = function(name) {
			// create
			const tag = createNode('div', 'instance-tag default-tag ' + name);
			tag.innerText = name;

			return tag;
		};

		let createCustomizedTag = function(setting) {
			// create
			const tag = createNode('div', 'instance-tag custom-tag');
			tag.style.backgroundImage = setting;

			return tag;
		};

		let name = getDefaultTagName(setting);
		let tag;
		if (name) {
			tag = createDefaultTag(name);
		} else {
			tag = createCustomizedTag(setting);
		}

		// append
		let navRight = container.querySelector('.navRight');
		let navbarName = YigoClassicUxSetting && YigoClassicUxSetting.navbarOption && YigoClassicUxSetting.navbarOption.navbarName;
		if (navRight) {
			if (navbarName == 'yigo-minix' || navbarName == 'yigo-top') {
				tag.className += ' ' + navbarName;
				navRight.append(tag);
			} else if (navbarName == 'yigo-default') {
				let navRightUser = navRight.querySelector('.nav-field-box.user');
				if (navRightUser) {
					navRight.insertBefore(tag, navRightUser);
				}	
			}
		}
	}

	function actionItemclickHandler(action){
		console.log(action)
		const buildinCommand = action.buildinCommand;
		if(action.buildinCommand){
			buildinHandler[buildinCommand] && buildinHandler[buildinCommand]();
		}else if(action.form && action.form.formKey){
			laodFormToDialog(action.form.formKey);
		}
		this.closest('.nav-field-content').style.display = 'none';
	}

    function install() {
        fieldBtnClickHandler();
		appBoxInstall()
    }

    function fieldBtnClickHandler() {
        const oFieldBtn = el.querySelectorAll(".nav-field-btn");
        oFieldBtn.forEach((btn) => {
            btn.addEventListener("click", function(e){
				clickHandler.call(this);
				e.stopPropagation();
			});
        });
		const oFieldBox = el.querySelectorAll('.nav-field-box');
		oFieldBox.forEach( box => {
			box.addEventListener('mouseleave',function(){
				this.querySelector('.nav-field-content').style.display = 'none';
			})
			box.addEventListener("mousedown", (e) => e.stopPropagation());
		})
        function clickHandler() {
			var oContent = this.nextElementSibling;
            let isShow = getComputedStyle(oContent).display != "none";
			if(isShow){
				oContent.style.display = "none";
			}else{
				hideAllContent();
				slideDown(oContent);
                onceEventHandler(document, "mousedown", () => {
                    oContent.style.display = "none";
                });
			}     
        }

		function hideAllContent(){
			oFieldBtn.forEach(btn=>{
				btn.nextElementSibling.style.display = 'none';
			})
		}
    }

	function appBoxInstall(){
		const oBtn = el.querySelector('.app-box-btn');
		oBtn.addEventListener('click',function(e){
			const oContent = this.nextElementSibling;
			let isShow = getComputedStyle(oContent).display != "none";
			if(isShow){
				oContent.style.display = "none";
			}else{
				slideDown(oContent);
                onceEventHandler(document, "mousedown", () => {
                    oContent.style.display = "none";
                });
			}   
			e.stopPropagation();
		})
		oBtn.addEventListener('mousedown',e=>e.stopPropagation());

		el.querySelectorAll(".appItems ul li a").forEach(item=>{
			item.addEventListener('click',itemClickHandler.bind(item))
		})
		
		function itemClickHandler(e){
			let key = this.getAttribute("id");
			//FIXME 待cokkie工具去jq后改写
			$.cookie("infokey",key);
			el.querySelector(".appItems").style.display = "none";
			e.stopPropagation();
		}

		metaService.getClientAppStatusInfo().then(function(status) {
			YIUI.AppDef.setStatus(status);
		});
	}

	const buildinHandler = {
		about,
		logout,
		exit,
		modifyPwd,
		userProfile
	}

	function userProfile(){
		const individualityFormKey = YigoClassicUxSetting.clientParameters.individualityFormKey;
        mainframe4Nav.showFormInRightSlide(individualityFormKey,"Opener=individuality");
	}

	function modifyPwd(){
		laodFormToDialog("ChangePassWord");
	}

	function laodFormToDialog(formKey){
		let builder = new YIUI.YIUIBuilder(formKey);
		builder.setTarget(YIUI.FormTarget.MODAL);
		builder.newEmpty().then(function(emptyForm){
			builder.builder(emptyForm);
		});
	}

	function logout(){
		Svr.SvrMgr.doLogout().then(function() {
			window.location.reload();
		});
	}

	function exit(){
		Svr.SvrMgr.doLogout().done(function() {
			window.location.replace("about:blank");
			
 		});
	}

	function about(){
		new Svr.Request().getData({service: "GetYigoInfo"}).then(function(result) {
			var html_about = "<div class='sys-about'><table>" +
							   "<tbody>" +
								   "<tr row='1'>" +
									   "<td col='0' colspan='2' rowspan='1'> "+ YIUI.I18N.getString("NAVIGATION_APPCOPYRIGHTS","上海博科资讯股份有限公司")+" </td>" +
									"</tr>" +
								   "<tr row='2'>" +
										"<td col='0' colspan='2' rowspan='1'></td>" +
									"</tr>" + 
									"<tr row='3'>" +
										"<td col='0' colspan='2' rowspan='1'></td>" +
									"</tr>" +
									"<tr row='4'>" +
										"<td col='0' colspan='1' rowspan='1'> "+ YIUI.I18N.getString("NAVIGATION_APPBUILDID","创建号：")+"&nbsp; " + result.BuildID + "</td>" +

									"</tr>" +
									"<tr row='5'>" +
									   "<td col='0' colspan='1' rowspan='1'>"+ YIUI.I18N.getString("NAVIGATION_APPVER","版本：")+"&nbsp; " + result.Ver + "</td>" +
									"</tr>" +
									"<tr row='6'>" +
										"<td col='0' colspan='1' rowspan='1'> </td>" +
										"<td col='1' colspan='1' rowspan='1'>" +
											"<button class='ok'><span class='txt'>"+ YIUI.I18N.getString("CURRENCY_OK","确定")+"</span></button>" +
										"</td>" +
									"</tr>" +
								"</tbody>" +
							"</table></div>";
					 
			//FIXME 待dialog插件去jq化后修改
		   var dialogDiv = $("<div class='modifyPwd abtCo' id='modifyPwd'></div>");
		   dialogDiv.modalDialog(null, {title: YIUI.I18N.getString("NAVIGATION_APPABOUT","关于Yigo"), showClose: false, width: "460px", height: "225px"});
		   $(dialogDiv).dialogContent().html(html_about);
		   $(".ok", dialogDiv).click(function() {
			   dialogDiv.close();
		   });
		   new Svr.Request().getData({service: "SystemInfo", cmd: "GetLicenseInfo"}).then(function(result) {
			document.querySelector("div.sys-about tr[row='2'] td").innerHTML = result.licenseTo;
			   if(result.moduleInfo){
				   var module = result.moduleInfo.split(";"),authorizationInfo = [], base , mobile;
				   for(var i = 0; i < module.length; i++){
					   var data = module[i].split(":");
					   authorizationInfo[data[0]] = module[i];
				   }
				   authorizationInfo.base ? base = authorizationInfo.base : base = "";
				   authorizationInfo.mobile ? mobile = authorizationInfo.mobile : mobile = "";
				   var info = YIUI.I18N.getString("NAVIGATION_AUTHORIZATIONINFO","授权信息") +": "+ base + "&nbsp; " + mobile;
				   document.querySelector("div.sys-about tr[row='3'] td").innerHTML = info;
			   }
			   
		   });
	   });
	}

	function createApp(container){
		
		metaService.getAppList().then(function(ret) {
			if ( ret.servers ) {
				ret.servers.forEach(function(server){
					const oLi = createNode('li');
					const oA = createNode('a');
					oA.innerHTML = server.caption || "test";
					oA.setAttribute("id",server.key);
					if (server.url.indexOf("?") != -1) {
						_a.setAttribute("href",server.url + "&appkey=" + server.key);
					} else {
						_a.setAttribute("href",server.url + "?appkey=" + server.key);
					}
					oLi.appendChild(oA);
					container.appendChild(oLi);
					el.querySelector('.app-box').style.display = 'block';
				})
			}
		})
	}

    function getAvaliableNavActionByName(name) {
        return avaliableNavActions.filter((item) => item.name == name)[0];
    }

    function createNode(tragetName, classname) {
        let node = document.createElement(tragetName);
        if (classname) {
            let arr = classname.split(" ");
            arr.forEach((name) => {
                node.classList.add(name);
            });
        }

        return node;
    }

    YIUI.Navigation = Navigation;
})();
