/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.ux.bootstarter.override;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
@ConditionalOnProperty(name={"yigoee.tech.bootsupport.ux.override-yigo.enabled"}, havingValue="true", matchIfMissing=false)
public class OverrideYigoResourceCssController {
    @Autowired
    private ResourceLoader resourceLoader;

    @GetMapping(value={"/yesui/dist/css/default/login.css"})
    public ResponseEntity<String> loginCss() throws IOException {
        return this.buildCss("classpath:/override-yigo-webapps/yigo/yesui/dist/css/default/login.css");
    }

    @GetMapping(value={"/yesui/dist/css/default/mainframe.css"})
    public ResponseEntity<String> mainframeCss() throws IOException {
        return this.buildCss("classpath:/override-yigo-webapps/yigo/yesui/dist/css/default/mainframe.css");
    }

    @GetMapping(value={"/yesui/dist/css/default/theme.css"})
    public ResponseEntity<String> themeCss() throws IOException {
        return this.buildCss("classpath:/override-yigo-webapps/yigo/yesui/dist/css/default/theme.css");
    }

    private ResponseEntity<String> buildCss(String loc) throws IOException {
        Resource resource = this.resourceLoader.getResource(loc);
        Assert.notNull((Object)resource, (String)("\u65e0\u6cd5\u627e\u5230\u8d44\u6e90 - '" + loc + "'"));
        try (InputStream is = resource.getInputStream();){
            ResponseEntity re;
            String css = IOUtils.toString((InputStream)is, (String)"UTF-8");
            HttpHeaders headers = new HttpHeaders();
            headers.set((Object)"Cache-Control", (Object)CacheControl.noCache().cachePrivate().mustRevalidate().getHeaderValue());
            headers.add((Object)"Content-Type", (Object)"text/css");
            ResponseEntity responseEntity = re = new ResponseEntity((Object)css, (MultiValueMap)headers, HttpStatus.OK);
            return responseEntity;
        }
    }
}

