/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.ux.bootstarter.impl;

import com.bokesoft.distro.tech.commons.basis.dependency.DependencySortCore;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.preference.Preference;
import com.bokesoft.yigo.ux.bootstarter.data.SpringUxConfigData;
import com.bokesoft.yigo.ux.bootstarter.data.additional.AdditionalThemeSetting;
import com.bokesoft.yigo.ux.defination.classic.YigoClassicUxSetting;
import com.bokesoft.yigo.ux.defination.classic.config.UxSystemParameters;
import com.bokesoft.yigo.ux.defination.classic.decorations.DefaultLoginDecoration;
import com.bokesoft.yigo.ux.defination.classic.decorations.DefaultMainFrameDecoration;
import com.bokesoft.yigo.ux.defination.classic.decorations.DefaultSiteDecoration;
import com.bokesoft.yigo.ux.defination.classic.navbar.NavbarOption;
import com.bokesoft.yigo.ux.defination.classic.navbar.NavbarPackage;
import com.bokesoft.yigo.ux.defination.classic.navigation.NavActionPackage;
import com.bokesoft.yigo.ux.defination.classic.navigation.NavActionSetting;
import com.bokesoft.yigo.ux.defination.classic.navigation.NavigationBuildin;
import com.bokesoft.yigo.ux.defination.classic.navigation.NavigationOption;
import com.bokesoft.yigo.ux.defination.common.themes.ThemeDecoration;
import com.bokesoft.yigo.ux.defination.common.themes.ThemeOption;
import com.bokesoft.yigo.ux.defination.common.themes.ThemePackage;
import com.bokesoft.yigo.ux.defination.mobile.YigoMobileUxSetting;
import com.bokesoft.yigo.ux.impl.DefaultUxFactory;
import com.bokesoft.yigo.ux.intf.ext.IClassicDecorationProvider;
import com.bokesoft.yigo.ux.intf.providers.IUxPackageProvider;
import com.bokesoft.yigo.ux.intf.providers.IUxSettingProvider;
import com.bokesoft.yigo.ux.preference.classic.UxUserLocalData;
import com.bokesoft.yigo.ux.preference.classic.UxUserPreferenceData;
import com.bokesoft.yigo.ux.utils.ExtendedFieldsUtils;
import com.bokesoft.yigo.ux.utils.PackagePathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import jodd.util.Wildcard;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.WebUtils;

public class SpringWebUxSettingProvider
implements IUxSettingProvider {
    private static final Logger log = LoggerFactory.getLogger(SpringWebUxSettingProvider.class);
    private SpringUxConfigData configData;
    private ResourceLoader resourceLoader;
    private List<IClassicDecorationProvider> additionalDecorationProviders;

    public SpringWebUxSettingProvider(SpringUxConfigData configData, ResourceLoader resourceLoader, List<IClassicDecorationProvider> additionalDecorationProviders) {
        this.configData = configData;
        this.resourceLoader = resourceLoader;
        if (null != additionalDecorationProviders) {
            this.additionalDecorationProviders = DependencySortCore.sort(additionalDecorationProviders);
        }
    }

    private IUxPackageProvider getPackageProvider() {
        return DefaultUxFactory.getUxPackageProvider();
    }

    private static void patchLocaleCookie(DefaultContext context) {
        if (null == context || null == context.getEnv()) {
            return;
        }
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        if (null == ra) {
            return;
        }
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        HttpServletRequest req = sra.getRequest();
        if (null == req) {
            return;
        }
        Cookie[] cookies = req.getCookies();
        if (null == cookies) {
            return;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie c = cookies[i];
            if (!"locale".equals(c.getName())) continue;
            context.getEnv().setLocale(c.getValue());
            break;
        }
    }

    public YigoClassicUxSetting getClassicUxSetting(DefaultContext context) {
        SpringWebUxSettingProvider.patchLocaleCookie(context);
        YigoClassicUxSetting setting = new YigoClassicUxSetting();
        UxSystemParameters sysPara = this.configData.getSystemParameters();
        setting.setClientParameters(SpringWebUxSettingProvider.getClientParameters(sysPara));
        setting.setClientSettings(this.configData.getClientSettings());
        UxUserPreferenceData userPref = this.getUserPref(context, sysPara.getIndividualityFormKey());
        setting.setNavbarOption(this.getNavbarOption(userPref));
        ThemeOption themeOpt = this.getThemeOption(userPref, context);
        setting.setThemeOption(themeOpt);
        setting.setNavigationOption(this.getNavigationOption());
        setting.setAvaliableNavbars(this.getPackageProvider().getNavbars());
        setting.setAvaliableNavActions(this.mergeAvaliableNavActions(this.getPackageProvider().getNavActions()));
        setting.setAvaliableThemes(this.getAvaliableThemePackagesByPlatform(1, context));
        this.processThemeExtension(themeOpt, vars -> setting.setAdditionalThemeVariables(vars), urls -> setting.setExtendThemeCssUrls(urls));
        this.mergeSimpleDecorations(context, setting, this.configData);
        DefaultSiteDecoration siteDecoration = setting.getSiteDecoration();
        if (null != siteDecoration && null != siteDecoration.getFaviconResourceUrl()) {
            siteDecoration.setFaviconResourceUrl(this.processImageResourceData(siteDecoration.getFaviconResourceUrl()));
        }
        ExtendedFieldsUtils.processClassicUxSetting((YigoClassicUxSetting)setting);
        return setting;
    }

    public YigoMobileUxSetting getMobileUxSetting(DefaultContext context) {
        SpringWebUxSettingProvider.patchLocaleCookie(context);
        YigoMobileUxSetting setting = new YigoMobileUxSetting();
        UxSystemParameters sysPara = this.configData.getSystemParameters();
        setting.setClientParameters(SpringWebUxSettingProvider.getClientParametersMobile(sysPara));
        UxUserPreferenceData userPref = this.getUserPref(context, sysPara.getMobileIndividualityFormKey());
        ThemeOption themeOpt = this.getThemeOptionMobile(userPref, context);
        setting.setThemeOption(themeOpt);
        setting.setAvaliableThemes(this.getAvaliableThemePackagesByPlatform(6, context));
        this.processThemeExtension(themeOpt, vars -> setting.setAdditionalThemeVariables(vars), urls -> setting.setExtendThemeCssUrls(urls));
        return setting;
    }

    private void processThemeExtension(ThemeOption themeOpt, Consumer<Map<String, String>> vars, Consumer<List<String>> urls) {
        if (null != themeOpt) {
            List<String> extCssUrls;
            List<AdditionalThemeSetting> addiThemeSettings;
            String themePath = PackagePathUtils.buildThemePackagePath((ThemeOption)themeOpt, (boolean)false);
            Map<String, String> addiThemeVars = this.buildAddiThemeVars(themePath, addiThemeSettings = this.configData.getAdditionalThemeSettings());
            if (null != addiThemeVars && !addiThemeVars.isEmpty()) {
                vars.accept(addiThemeVars);
            }
            if (null != (extCssUrls = this.buildExtThemeCssUrls(themePath, addiThemeSettings)) && !extCssUrls.isEmpty()) {
                urls.accept(extCssUrls);
            }
        }
    }

    private NavigationOption getNavigationOption() {
        ArrayList settingActions;
        ArrayList userActions;
        NavigationOption navOpts = this.configData.getNavigation();
        if (null == navOpts) {
            navOpts = new NavigationOption();
        }
        if (null == (userActions = navOpts.getUserActions())) {
            userActions = new ArrayList();
            navOpts.setUserActions(userActions);
        }
        if (userActions.isEmpty()) {
            userActions.addAll(NavigationBuildin.DEFAULT_USER_ACTIONS);
        }
        if (null == (settingActions = navOpts.getSettingActions())) {
            settingActions = new ArrayList();
            navOpts.setSettingActions(settingActions);
        }
        if (settingActions.isEmpty()) {
            settingActions.addAll(NavigationBuildin.DEFAULT_SETTING_ACTIONS);
        }
        return navOpts;
    }

    private ThemeOption getThemeOption(UxUserPreferenceData userPref, DefaultContext context) {
        ThemeOption themeOpt = this.configData.getThemeOption();
        if (null != userPref && null != userPref.getThemeOption()) {
            themeOpt = SpringWebUxSettingProvider.fillupUserOpt(userPref.getThemeOption(), themeOpt);
        }
        return this.getAvailableThemeOption(themeOpt, context);
    }

    private ThemeOption getThemeOptionMobile(UxUserPreferenceData userPref, DefaultContext context) {
        ThemeOption themeOpt = this.configData.getThemeOptionMobile();
        if (null != userPref && null != userPref.getThemeOptionMobile()) {
            themeOpt = SpringWebUxSettingProvider.fillupUserOpt(userPref.getThemeOptionMobile(), themeOpt);
        }
        return this.getAvailableThemeOption(themeOpt, context);
    }

    private static ThemeOption fillupUserOpt(ThemeOption userOpt, ThemeOption themeOpt) {
        if (null == themeOpt) {
            return userOpt;
        }
        if (!StringUtils.equals((CharSequence)userOpt.getThemeName(), (CharSequence)themeOpt.getThemeName())) {
            return userOpt;
        }
        if (StringUtils.isBlank((CharSequence)userOpt.getColorGroupName()) && StringUtils.isNotBlank((CharSequence)themeOpt.getColorGroupName())) {
            userOpt.setColorGroupName(themeOpt.getColorGroupName());
        }
        if (StringUtils.isBlank((CharSequence)userOpt.getFontSchemeName()) && StringUtils.isNotBlank((CharSequence)themeOpt.getFontSchemeName())) {
            userOpt.setFontSchemeName(themeOpt.getFontSchemeName());
        }
        return userOpt;
    }

    private NavbarOption getNavbarOption(UxUserPreferenceData userPref) {
        NavbarOption navbarOption = this.configData.getNavbarOption();
        if (null != userPref && null != userPref.getNavbarOption()) {
            NavbarOption userOpt;
            navbarOption = userOpt = userPref.getNavbarOption();
        }
        navbarOption = this.getAvailableNavbarOption(navbarOption);
        return navbarOption;
    }

    private static YigoClassicUxSetting.ClientParameters getClientParameters(UxSystemParameters sysPara) {
        YigoClassicUxSetting.ClientParameters toClient = new YigoClassicUxSetting.ClientParameters();
        if (!StringUtils.isNotBlank((CharSequence)sysPara.getIndividualityFormKey())) {
            throw new UnsupportedOperationException("\u672a\u6b63\u786e\u914d\u7f6e IndividualityFormKey");
        }
        toClient.setIndividualityFormKey(sysPara.getIndividualityFormKey());
        if (StringUtils.isNotBlank((CharSequence)sysPara.getMenuHelpFormula())) {
            toClient.setMenuHelpFormula(sysPara.getMenuHelpFormula());
        }
        return toClient;
    }

    private YigoClassicUxSetting mergeSimpleDecorations(DefaultContext context, YigoClassicUxSetting setting, SpringUxConfigData configData) {
        DefaultLoginDecoration loginDecoration = new DefaultLoginDecoration();
        DefaultMainFrameDecoration mainFrameDecoration = new DefaultMainFrameDecoration();
        DefaultSiteDecoration siteDecoration = new DefaultSiteDecoration();
        List<IClassicDecorationProvider> providers = this.additionalDecorationProviders;
        if (null != providers) {
            String providerClasses = providers.stream().map(p -> p.getClass().getName()).collect(Collectors.joining(", "));
            log.info("\u5f00\u59cb\u5904\u7406\u9644\u52a0 Decoration: {}", (Object)providerClasses);
            DefaultLoginDecoration currLoginDecoration = configData.getLogin();
            DefaultMainFrameDecoration currMainFrameDecoration = configData.getMainframe();
            DefaultSiteDecoration currSiteDecoration = configData.getSite();
            for (IClassicDecorationProvider p2 : providers) {
                DefaultLoginDecoration addiLoginDecoration = p2.getLoginDecoration(context);
                SpringWebUxSettingProvider.mergeSimpleConfigObject(loginDecoration, addiLoginDecoration, currLoginDecoration);
                currLoginDecoration = loginDecoration;
                DefaultMainFrameDecoration addiMainFrameDecoration = p2.getMainFrameDecoration(context);
                SpringWebUxSettingProvider.mergeSimpleConfigObject(mainFrameDecoration, addiMainFrameDecoration, currMainFrameDecoration);
                currMainFrameDecoration = mainFrameDecoration;
                DefaultSiteDecoration addiSiteDecoration = p2.getSiteDecoration(context);
                SpringWebUxSettingProvider.mergeSimpleConfigObject(siteDecoration, addiSiteDecoration, currSiteDecoration);
                currSiteDecoration = siteDecoration;
            }
        }
        setting.setLoginDecoration(loginDecoration);
        setting.setMainFrameDecoration(mainFrameDecoration);
        setting.setSiteDecoration(siteDecoration);
        return setting;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String processImageResourceData(String url) {
        int pointIndex;
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        if (url.startsWith("data:")) {
            return url;
        }
        Resource res = this.resourceLoader.getResource(url);
        String filename = res.getFilename();
        String ext = null;
        if (StringUtils.isNotBlank((CharSequence)filename) && (pointIndex = filename.indexOf(".")) > 0 && pointIndex < filename.length() - 1) {
            ext = filename.substring(filename.lastIndexOf(".") + 1);
        }
        if (StringUtils.isBlank(ext)) {
            ext = "png";
        }
        ext = ext.toLowerCase();
        try (InputStream in = res.getInputStream();){
            String data;
            byte[] bytes = IOUtils.toByteArray((InputStream)in);
            String string = data = "data:image/" + ext + ";base64," + Base64.getEncoder().encodeToString(bytes);
            return string;
        }
        catch (IOException ex) {
            log.error("\u8bfb\u53d6\u56fe\u7247\u8d44\u6e90 '" + url + "' \u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private static void mergeSimpleConfigObject(Object result, Object additional, Object current) {
        List flds = FieldUtils.getAllFieldsList(result.getClass());
        for (Field fld : flds) {
            SpringWebUxSettingProvider.setNotBlankField(result, additional, current, fld);
        }
    }

    private static void setNotBlankField(Object result, Object additional, Object current, Field fld) {
        try {
            Object value = null;
            if (null != additional) {
                value = FieldUtils.readField((Field)fld, (Object)additional, (boolean)true);
            }
            if ((null == value || StringUtils.isBlank((CharSequence)value.toString())) && null != current) {
                value = FieldUtils.readField((Field)fld, (Object)current, (boolean)true);
            }
            if (null != value) {
                FieldUtils.writeField((Field)fld, (Object)result, (Object)value, (boolean)true);
            }
        }
        catch (IllegalAccessException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private NavbarOption getAvailableNavbarOption(NavbarOption option) {
        List nps = this.getPackageProvider().getNavbars();
        if (null == nps || nps.isEmpty()) {
            return null;
        }
        String navbarName = null != option ? option.getNavbarName() : null;
        NavbarPackage np = null;
        if (StringUtils.isNotBlank((CharSequence)navbarName)) {
            for (NavbarPackage p : nps) {
                if (!navbarName.equals(p.getName())) continue;
                np = p;
                break;
            }
        }
        if (null == np) {
            navbarName = ((NavbarPackage)nps.get(0)).getName();
        }
        NavbarOption result = new NavbarOption();
        result.setNavbarName(navbarName);
        return result;
    }

    private ThemePackage.ColorGroup getThemeDefaultColorGroup(ThemePackage tp) {
        List cgs;
        if (null != tp && null != (cgs = tp.getColorGroups()) && !cgs.isEmpty()) {
            for (int i = 0; i < cgs.size(); ++i) {
                ThemePackage.ColorGroup cg = (ThemePackage.ColorGroup)cgs.get(i);
                if (!cg.isFallback()) continue;
                return cg;
            }
            return (ThemePackage.ColorGroup)cgs.get(0);
        }
        return null;
    }

    private ThemePackage.FontScheme getThemeDefaultFontSchema(ThemePackage tp) {
        List fss;
        if (null != tp && null != (fss = tp.getFontSchemes()) && !fss.isEmpty()) {
            for (int i = 0; i < fss.size(); ++i) {
                ThemePackage.FontScheme fs = (ThemePackage.FontScheme)fss.get(i);
                if (!fs.isFallback()) continue;
                return fs;
            }
            return (ThemePackage.FontScheme)fss.get(0);
        }
        return null;
    }

    private List<ThemePackage> getAvaliableThemePackages(DefaultContext context) {
        List avaliableThemes = this.getPackageProvider().getThemes();
        List<IClassicDecorationProvider> providers = this.additionalDecorationProviders;
        if (null != providers) {
            for (IClassicDecorationProvider p : providers) {
                this.mergeThemeDecorations(avaliableThemes, p.getThemeDecorations(context), p.getClass().getName());
            }
        }
        return avaliableThemes;
    }

    private ThemeOption getAvailableThemeOption(ThemeOption option, DefaultContext context) {
        List<ThemePackage> tps = this.getAvaliableThemePackages(context);
        if (null == tps || tps.isEmpty()) {
            return null;
        }
        String themeName = null != option ? option.getThemeName() : null;
        ThemePackage tp = null;
        if (StringUtils.isNotBlank((CharSequence)themeName)) {
            for (ThemePackage p : tps) {
                if (!themeName.equals(p.getName())) continue;
                tp = p;
                break;
            }
        }
        if (null == tp) {
            ThemePackage.FontScheme fs;
            tp = tps.get(0);
            ThemeOption result = new ThemeOption();
            result.setThemeName(tp.getName());
            ThemePackage.ColorGroup cg = this.getThemeDefaultColorGroup(tp);
            if (null != cg) {
                result.setColorGroupName(cg.getName());
            }
            if (null != (fs = this.getThemeDefaultFontSchema(tp))) {
                result.setFontSchemeName(fs.getName());
            }
            return result;
        }
        String colorGroupName = null != option ? option.getColorGroupName() : null;
        List cgs = tp.getColorGroups();
        if (StringUtils.isNotBlank((CharSequence)colorGroupName) && null != cgs && !cgs.isEmpty()) {
            ThemePackage.ColorGroup cg;
            boolean found = false;
            for (ThemePackage.ColorGroup cg2 : cgs) {
                if (!colorGroupName.equals(cg2.getName())) continue;
                found = true;
                break;
            }
            if (!found && null != (cg = this.getThemeDefaultColorGroup(tp))) {
                colorGroupName = cg.getName();
            }
        }
        String fontSchemeName = null != option ? option.getFontSchemeName() : null;
        List fss = tp.getFontSchemes();
        if (StringUtils.isNotBlank((CharSequence)fontSchemeName) && null != fss && !fss.isEmpty()) {
            ThemePackage.FontScheme fs;
            boolean found = false;
            for (ThemePackage.FontScheme fs2 : fss) {
                if (!fontSchemeName.equals(fs2.getName())) continue;
                found = true;
                break;
            }
            if (!found && null != (fs = this.getThemeDefaultFontSchema(tp))) {
                fontSchemeName = fs.getName();
            }
        }
        ThemeOption result = new ThemeOption();
        result.setThemeName(themeName);
        result.setColorGroupName(colorGroupName);
        result.setFontSchemeName(fontSchemeName);
        return result;
    }

    private Map<String, String> buildAddiThemeVars(String themePath, List<AdditionalThemeSetting> settings) {
        if (null == themePath) {
            return null;
        }
        if (null == settings || settings.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        settings.forEach(setting -> {
            String namePattern = setting.getTheme();
            if (Wildcard.matchPath((String)themePath, (String)namePattern)) {
                this.putAddiThemeVars(result, setting.getLessVariables(), "@");
                this.putAddiThemeVars(result, setting.getCssVariables(), "--");
            }
        });
        return result;
    }

    private void putAddiThemeVars(Map<String, String> result, Map<String, String> vars, String prefix) {
        if (null == vars) {
            return;
        }
        vars.forEach((key, value) -> {
            if (!key.startsWith(prefix)) {
                key = prefix + key;
            }
            result.put((String)key, (String)value);
        });
    }

    private List<String> buildExtThemeCssUrls(String themePath, List<AdditionalThemeSetting> settings) {
        if (null == themePath) {
            return null;
        }
        if (null == settings || settings.isEmpty()) {
            return null;
        }
        LinkedHashSet result = new LinkedHashSet();
        settings.forEach(setting -> {
            List<String> urls;
            String namePattern = setting.getTheme();
            if (Wildcard.matchPath((String)themePath, (String)namePattern) && null != (urls = setting.getExtendCssUrls()) && !urls.isEmpty()) {
                result.addAll(urls);
            }
        });
        return new ArrayList<String>(result);
    }

    private UxUserPreferenceData getUserPref(DefaultContext context, String individualityFormKey) {
        long uid = -1L;
        if (null != context) {
            uid = context.getUserID();
        }
        if (uid <= 0L) {
            return this.readByCookie();
        }
        UxUserPreferenceData pref = this.readByPreference(context, individualityFormKey);
        if (null == pref) {
            pref = this.readByCookie();
        }
        return pref;
    }

    private UxUserPreferenceData readByPreference(DefaultContext context, String individualityFormKey) {
        if (StringUtils.isBlank((CharSequence)individualityFormKey)) {
            throw new UnsupportedOperationException("\u672a\u6b63\u786e\u914d\u7f6e IndividualityFormKey");
        }
        try {
            Preference pref;
            try {
                String prefKey;
                String formKey = prefKey = individualityFormKey;
                Class<?> prefFac = Class.forName("com.bokesoft.yigo.mid.preference.PreferenceIOFactory");
                Object prefIO = MethodUtils.invokeStaticMethod(prefFac, (String)"getPreferenceIO", (Object[])new Object[]{context});
                pref = (Preference)MethodUtils.invokeMethod((Object)prefIO, (String)"load", (Object[])new Object[]{prefKey, formKey, context});
            }
            catch (ClassNotFoundException ex) {
                String formKey = individualityFormKey;
                Class<?> prefFac = Class.forName("com.bokesoft.yes.mid.cmd.form.preference.PreferenceIOFactory");
                Object prefIO = MethodUtils.invokeStaticMethod(prefFac, (String)"getPreferenceIO", (Object[])new Object[]{context});
                pref = (Preference)MethodUtils.invokeMethod((Object)prefIO, (String)"load", (Object[])new Object[]{formKey, context});
            }
            if (null == pref) {
                return null;
            }
            return UxUserPreferenceData.fromPreference((Preference)pref);
        }
        catch (Throwable e) {
            log.error("\u4ece\u7528\u6237\u559c\u597d\u83b7\u53d6 UX \u8bbe\u7f6e\u9519\u8bef", e);
            return null;
        }
    }

    private UxUserPreferenceData readByCookie() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null == requestAttributes) {
            return null;
        }
        HttpServletRequest req = ((ServletRequestAttributes)requestAttributes).getRequest();
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)req, (String)"yigo-ux-local");
        if (null == cookie) {
            return null;
        }
        String val = cookie.getValue();
        try {
            UxUserLocalData uld = UxUserLocalData.fromCookieValue((String)val);
            return UxUserPreferenceData.fromUserLocalData((UxUserLocalData)uld);
        }
        catch (Throwable e) {
            log.error("\u4ece Cookie \u83b7\u53d6 UX \u8bbe\u7f6e\u9519\u8bef", e);
            return null;
        }
    }

    private List<NavActionPackage> mergeAvaliableNavActions(List<NavActionPackage> defaultSettings) {
        Map<String, NavActionSetting> userSettings = this.configData.getNavActionSettings();
        if (null == userSettings) {
            return defaultSettings;
        }
        for (String key : userSettings.keySet()) {
            NavActionSetting userSetting = userSettings.get(key);
            boolean found = false;
            for (int i = 0; i < defaultSettings.size(); ++i) {
                NavActionPackage setting = defaultSettings.get(i);
                if (!key.equals(setting.getName())) continue;
                if (StringUtils.isNotBlank((CharSequence)userSetting.getCaption())) {
                    setting.setCaption(userSetting.getCaption());
                }
                if (StringUtils.isNotBlank((CharSequence)userSetting.getIcon())) {
                    if (userSetting.getIcon().trim().equals("-")) {
                        setting.setIcon(null);
                    } else {
                        setting.setIcon(userSetting.getIcon());
                    }
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("\u65e0\u6548\u7684NavAction:" + key);
        }
        return defaultSettings;
    }

    private static YigoMobileUxSetting.ClientParametersMobile getClientParametersMobile(UxSystemParameters sysPara) {
        YigoMobileUxSetting.ClientParametersMobile toClient = new YigoMobileUxSetting.ClientParametersMobile();
        if (!StringUtils.isNotBlank((CharSequence)sysPara.getMobileIndividualityFormKey())) {
            throw new UnsupportedOperationException("\u672a\u6b63\u786e\u914d\u7f6e IndividualityMobileFormKey");
        }
        toClient.setIndividualityFormKey(sysPara.getMobileIndividualityFormKey());
        return toClient;
    }

    private List<ThemePackage> getAvaliableThemePackagesByPlatform(int platform, DefaultContext context) {
        List<ThemePackage> avaliableThemes = this.getAvaliableThemePackages(context);
        ArrayList<ThemePackage> newAvaliableThemes = new ArrayList<ThemePackage>();
        avaliableThemes.forEach(ThemePackage2 -> {
            Integer platformSupport = ThemePackage2.getPlatformType();
            if (null == platformSupport) {
                platformSupport = 1;
            }
            if ((platformSupport & platform) == platform) {
                newAvaliableThemes.add((ThemePackage)ThemePackage2);
            }
        });
        return newAvaliableThemes;
    }

    private void mergeThemeDecorations(List<ThemePackage> themes, List<ThemeDecoration> themeDecorations, String progName) {
        if (null == themeDecorations || themeDecorations.isEmpty()) {
            return;
        }
        if (null != themes && !themes.isEmpty()) {
            for (ThemePackage t : themes) {
                this.doMergeThemeDecorations(t, themeDecorations, progName);
            }
        }
    }

    private void doMergeThemeDecorations(ThemePackage theme, List<ThemeDecoration> themeDecorations, String progName) {
        ArrayList<String> applyPaths = new ArrayList<String>();
        String themeName = theme.getName();
        for (ThemeDecoration td : themeDecorations) {
            String pattern = td.getApplyTo();
            List colorGroups = td.getColorGroups();
            if (null == colorGroups || colorGroups.isEmpty() || !Wildcard.match((CharSequence)themeName, (CharSequence)pattern)) continue;
            theme.setColorGroups(colorGroups);
            String cgNames = colorGroups.stream().map(cg -> cg.getName()).collect(Collectors.joining(", "));
            applyPaths.add(progName + "/" + pattern + "(" + cgNames + ")");
        }
        if (!applyPaths.isEmpty()) {
            String lastDecoration = (String)applyPaths.get(applyPaths.size() - 1);
            log.info("\u4e3b\u9898 '{}' \u6700\u7ec8\u88ab\u4fee\u9970\u4e3a '{}', \u5904\u7406\u8def\u5f84\u4e3a: {}", new Object[]{themeName, lastDecoration, StringUtils.join(applyPaths, (String)" -> ")});
        }
    }
}

