/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.ux.bootstarter.impl;

import com.bokesoft.yigo.ux.defination.classic.navbar.NavbarPackage;
import com.bokesoft.yigo.ux.defination.classic.navigation.NavActionPackage;
import com.bokesoft.yigo.ux.defination.common.themes.ThemePackage;
import com.bokesoft.yigo.ux.intf.providers.IUxPackageProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;

public class SpringUxPackageProvider
implements IUxPackageProvider {
    private ApplicationContext ctx;

    public SpringUxPackageProvider(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public List<NavbarPackage> getNavbars() {
        Map beans = this.ctx.getBeansOfType(NavbarPackage.class);
        return new ArrayList<NavbarPackage>(beans.values());
    }

    public List<ThemePackage> getThemes() {
        Map beans = this.ctx.getBeansOfType(ThemePackage.class);
        Collection origThemePackages = beans.values();
        ArrayList<ThemePackage> result = new ArrayList<ThemePackage>();
        ObjectMapper objectMapper = new ObjectMapper();
        for (ThemePackage item : origThemePackages) {
            ThemePackage clonedThemePackage = (ThemePackage)objectMapper.convertValue((Object)item, ThemePackage.class);
            result.add(clonedThemePackage);
        }
        return result;
    }

    public List<NavActionPackage> getNavActions() {
        Map beans = this.ctx.getBeansOfType(NavActionPackage.class);
        return new ArrayList<NavActionPackage>(beans.values());
    }
}

